// CSPI : Susie-Plugin('00IN' only) Support Class

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

typedef struct SpiPictureInfo {
	long left,top;							//	摜WJʒu
	long width; 								//	摜̕(pixel)
	long height;								//	摜̍(pixel)
	WORD x_density; 						//	f̐x
	WORD y_density; 						//	f̐x
	short colorDepth; 					//	Pfbit
	HLOCAL hInfo;								//	摜̃eLXg
} SpiPictureInfo, *LPSpiPictureInfo;

typedef	int (PASCAL *SpiFuncGetPluginInfo)(int, LPSTR, int);
typedef	int (PASCAL *SpiFuncIsSupported)(LPSTR, DWORD);
typedef	int (PASCAL *SpiFuncGetPictureInfo)(LPSTR, long, unsigned int, SpiPictureInfo*);
typedef	int (PASCAL *SpiFuncGetPicture)(LPSTR, long, unsigned int, HLOCAL*, HLOCAL*, FARPROC, long);
typedef	int (PASCAL *SpiFuncGetFile)(LPSTR, long, LPSTR, unsigned int, FARPROC, long);

typedef	int (PASCAL *SpiProgressCallbackFunc)(int,int,long);

class CSPI {

private:

	HMODULE					m_hDLL; //SPI-DLL̃nh
	SpiFuncGetPluginInfo	m_pGetPluginInfo;
	SpiFuncIsSupported		m_pIsSupported;
	SpiFuncGetPictureInfo	m_pGetPictureInfo;
	SpiFuncGetPicture		m_pGetPicture;
	SpiFuncGetFile			m_pGetFile;

	// fXgN^łƉĂ
	HLOCAL m_HBm;		// rbg}bvf[^{̂̃nh
	HLOCAL m_HBmInfo;	// BITMAPINFO \̂[߂ꂽnh

public:

	CSPI();
	~CSPI();
	BOOL LoadSPI(const char* szSPI);
	void FreeSPI(void);
	BOOL IsSupported(const char* szFile);

	// phBm,phBmInfoɓǂݍ񂾉摜̃nhԂB
	BOOL LoadPicture(const char* szFile, HLOCAL* phBm, HLOCAL* phBmInfo, FARPROC lpCallBack = NULL, long lData = 0);
	/*
	LPBYTE pbmd = (LPBYTE)LocalLock(hBm);
	BITMAPINFO* pbmi = (BITMAPINFO*)LocalLock(hBmInfo);
	Ƃ΁AƂ͎v̂܂܁BgILocalUnLock()YȂB
	*/

	void FreePicture(void);

};
