// CSPI : Susie-Plugin('00IN' only) Support Class

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "SPI.h"

CSPI::CSPI(){

	m_hDLL				= NULL;
	m_pGetPluginInfo	= NULL;
	m_pIsSupported		= NULL;
	m_pGetPictureInfo	= NULL;
	m_pGetPicture		= NULL;
	m_pGetFile			= NULL;

	m_HBm				= NULL;	
	m_HBmInfo			= NULL;

}

CSPI::~CSPI(){

	FreeSPI();

}

BOOL CSPI::LoadSPI(const char *szSPI){

	FreeSPI();

	if(!szSPI)
		return FALSE;

	m_hDLL = LoadLibrary(szSPI);
	if(!m_hDLL)
		return FALSE;

	m_pGetPluginInfo = (SpiFuncGetPluginInfo)GetProcAddress(m_hDLL, "GetPluginInfo");
	if(!m_pGetPluginInfo){
		FreeSPI();
		return FALSE;
	}

	// 00INmF
	char buf[10];
	int ilen = m_pGetPluginInfo(0,(LPSTR)buf,9);

	if(ilen<4)
	{
		FreeSPI();
		return FALSE;
	}

	if(buf[0]!='0' || buf[1]!='0' || buf[2]!='I' || buf[3]!='N')
	{
		FreeSPI();
		return FALSE;
	}

	m_pIsSupported		= (SpiFuncIsSupported)		GetProcAddress(m_hDLL, "IsSupported");
	m_pGetPicture		= (SpiFuncGetPicture)		GetProcAddress(m_hDLL, "GetPicture");

	// gp
//	m_pGetPictureInfo	= (SpiFuncGetPictureInfo)	GetProcAddress(m_hDLL, "GetPictureInfo");
//	m_pGetFile			= (SpiFuncGetFile)			GetProcAddress(m_hDLL, "GetFile");

	if(m_pIsSupported==NULL || m_pGetPicture==NULL)
//	   m_pGetPictureInfo==NULL || m_pGetFile==NULL)
	{
		FreeSPI();
		return FALSE;
	}

	return TRUE;

}

void CSPI::FreeSPI(void){

	if(m_hDLL!=NULL)
	{
		FreeLibrary(m_hDLL);
		m_hDLL = NULL;
	}

	m_pGetPluginInfo	= NULL;
	m_pIsSupported		= NULL;
	m_pGetPictureInfo	= NULL;
	m_pGetPicture		= NULL;
	m_pGetFile			= NULL;

	FreePicture();

}

BOOL CSPI::IsSupported(const char* szFile){

	if(!szFile || !m_pIsSupported)
		return FALSE;

	HANDLE hFile = CreateFile(szFile, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile==INVALID_HANDLE_VALUE)
		return FALSE;

	DWORD dw = (DWORD)hFile;
	int nRet = m_pIsSupported((LPSTR)szFile, dw);
	CloseHandle(hFile);
	return nRet;

}

BOOL CSPI::LoadPicture(const char* szFile, HLOCAL* phBm, HLOCAL* phBmInfo, FARPROC lpCallBack/*=NULL*/, long lData/*=0*/){

	if(!szFile || !m_pGetPicture)
		return FALSE;

	FreePicture();

	unsigned int flag = 0; // Load from DiskFile
	int ret;

	ret = m_pGetPicture((LPSTR)szFile, 0, flag, phBmInfo, phBm, lpCallBack, lData);

	if(ret==0)
	{
		// fXgN^ŉł悤ɉ摜̃nhۑ
		m_HBm		= *phBm;
		m_HBmInfo	= *phBmInfo;
		return TRUE;
	}
	else
		return FALSE;

}

void CSPI::FreePicture(void){

	if(m_HBm!=NULL)
	{
		LocalFree(m_HBm);
		m_HBm = NULL;
	}

	if(m_HBmInfo!=NULL)
	{
		LocalFree(m_HBmInfo);
		m_HBmInfo = NULL;
	}

}
