//
// MCI_MIDI.cpp
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include "MCI_MIDI.h"

extern void WriteLog(const char* Format,...);

MCI_MIDI::MCI_MIDI(){

	bPlay = FALSE;
	bInit = FALSE;

}

MCI_MIDI::~MCI_MIDI(){

	StopMIDI();
	CloseMIDI();

}

void MCI_MIDI::InitMIDI(HWND hwnd, char* cFilename){

	hmainwnd = hwnd;
	StopMIDI();
	CloseMIDI();

	// MCI
	MCI_OPEN_PARMS mciOpenParms;

	mciOpenParms.lpstrDeviceType = (LPCSTR) MCI_DEVTYPE_SEQUENCER;
	mciOpenParms.lpstrElementName = cFilename;

	MCIERROR res;
	res = mciSendCommand(NULL, MCI_OPEN,
						 MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_OPEN_ELEMENT | MCI_WAIT,
						 (DWORD)(LPVOID) &mciOpenParms);
	if (res!=0)
	{
		wMIDIDeviceID = NULL;
		char szMCIErr[255];
		mciGetErrorString(res, szMCIErr, 255);
		WriteLog("MCI_MIDI::InitMIDI() : MCȈɎs %s",szMCIErr);
	}
	else
	{
		wMIDIDeviceID = mciOpenParms.wDeviceID;
		bInit = TRUE;
	}

}

void MCI_MIDI::PlayMIDI(){

	if(wMIDIDeviceID!=NULL)
	{
		MCIERROR res;
		MCI_PLAY_PARMS mciPlayParms;
		
//		mciPlayParms.dwCallback = (DWORD)hmainwnd;
		res = mciSendCommand(wMIDIDeviceID, MCI_PLAY,NULL, //MCI_WAIT, // MCI_NOTIFY,
							 (DWORD)(LPVOID) &mciPlayParms);

		if(res!=0)
		{
			char szMCIErr[255];
			mciGetErrorString(res, szMCIErr, 255);
			WriteLog("MCI_MIDI::PlayMIDI() : MIDI̍ĐɎs %s",szMCIErr);
		}else
			bPlay = TRUE;

	}
	else
	{
		WriteLog("MCI_MIDI::PlayMIDI() : MCIĂ܂");
	}


}

void MCI_MIDI::StopMIDI(){

	if(!bPlay)
		return;


	MCIERROR res;
	res = mciSendCommand(wMIDIDeviceID, MCI_STOP,  0, NULL);

	if(res!=0)
	{
		char szMCIErr[255];
		mciGetErrorString(res, szMCIErr, 255);
		WriteLog("MCI_MIDI::StopMIDI() : MIDỈt~Ɏs %s",szMCIErr);
	}
	else
		bPlay = FALSE;

}

void MCI_MIDI::CloseMIDI(){

	if(!bInit)
		return;

	MCIERROR res;
	res = mciSendCommand(wMIDIDeviceID, MCI_CLOSE, 0, NULL);

	if(res!=0)
	{
		char szMCIErr[255];
		mciGetErrorString(res, szMCIErr, 255);
		WriteLog("MCI_MIDI::CloseMIDI() : MCI̊JɎs %s",szMCIErr);
	}
	else
		bInit = FALSE;

}
