//
// CRC32vZ
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "CRC32.h"

CRC32::CRC32()
{
	DWORD value;
	for(int i=0;i<256;i++)
	{
		value = i;
		for(int j=0;j<8;j++)
		{
			value = (value & 1) ? ((value >> 1) ^ 0xedb88320) : (value >> 1);
		}
		m_crcTable[i] = value;
	}

	m_crc = 0xffffffff;
}

CRC32::~CRC32()
{
}

void CRC32::Clear()
{
	m_crc = 0xffffffff;
}

DWORD CRC32::Get()
{
	return ~m_crc;
}

void CRC32::Calc(const void* buf, int size)
{
	BYTE* data = (BYTE*)buf;

	for(int i=0;i<size;i++)
	{
		m_crc = m_crcTable[(BYTE)m_crc ^ data[i]] ^ (m_crc >> 8);
	}
}
