//
// vOۂɃWX^񂾂̃X^bNg[X̂foNX
//
// respect to:
//  http://tokyo.cool.ne.jp/masapico/api_SetUnhandledExceptionFilter.html
//  http://www.geocities.co.jp/SiliconValley-PaloAlto/5920/api_StackWalk.html
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "CCrashHandler.h"

char CCrashHandler::m_logFileName[MAX_PATH];
char CCrashHandler::m_moduleName[MAX_PATH];
DWORD CCrashHandler::m_moduleTimeStamp;
ULONG CCrashHandler::m_imageSize;

CCrashHandler::CCrashHandler()
{
	SetLogFileName("crashlog.txt");
	m_moduleName[0] = '\0';
	Init();
}

CCrashHandler::~CCrashHandler()
{
}

// ǂŎ̂Ƃ
void CCrashHandler::SetLogFileName(const char* file)
{
	strncpy(m_logFileName, file, MAX_PATH);
	m_logFileName[MAX_PATH-1] = '\0';
}

BOOL CCrashHandler::Init(void)
{
	char szTxt[MAX_PATH];

	// scm
	if(GetModuleFileName(NULL, szTxt, MAX_PATH)!=0)
	{
		strcpy(m_moduleName, szTxt);

		LOADED_IMAGE* lpLI = ImageLoad(m_moduleName, NULL);
		if(lpLI!=NULL)
		{
			m_moduleTimeStamp = lpLI->FileHeader->FileHeader.TimeDateStamp;
			m_imageSize = lpLI->SizeOfImage;
		}
	}

	SetUnhandledExceptionFilter(ExceptionFilter);
	return TRUE;
}

LONG CCrashHandler::ExceptionFilter(EXCEPTION_POINTERS* ExInfo)
{
	SetCurrentToExeDir();
	FILE* fp = fopen(m_logFileName, "a+");
	if(fp==NULL)
		return(EXCEPTION_CONTINUE_SEARCH);

	// [U[܂ւ̂肢(
	fprintf(fp, "%s\n", m_LogHeader);

	fprintf(fp, "--- Start debug info ---\n\n");

	char timestr[32];
	strcpy(timestr, _ctime32((__time32_t*)&m_moduleTimeStamp));
	timestr[24] = '\0'; // \nԂ
	fprintf(fp, "%s, Size:%d, TimeStamp:0x%08x (%s)\n\n", m_moduleName, m_imageSize, m_moduleTimeStamp, timestr);

	DWORD ecode = ExInfo->ExceptionRecord->ExceptionCode;
	DWORD eaddr = (DWORD)(ExInfo->ExceptionRecord->ExceptionAddress);
	fprintf(fp, "Exception code : 0x%08x (%s)\n", ecode, GetExceptionStr(ecode));

	if(ecode==EXCEPTION_ACCESS_VIOLATION)
	{
		// ANZXᔽ̂Ƃ͒ǉ
		if(ExInfo->ExceptionRecord->ExceptionInformation[0] == 0)
		{
			// ǂƂAV
			fprintf(fp, "Exception info : ACCESS_VIOLATION occured while reading address 0x%08x\n", ExInfo->ExceptionRecord->ExceptionInformation[1]);
		}
		else
		{
			// ƂAV
			fprintf(fp, "Exception info : ACCESS_VIOLATION occured while writing address 0x%08x\n", ExInfo->ExceptionRecord->ExceptionInformation[1]);
		}
	}

	fprintf(fp, "Crash address : 0x%08x\n\n", eaddr);

	// WX^_v
	fprintf(fp, "Register dump :\n");
	fprintf(fp, "eax=%08x ebx=%08x ecx=%08x edx=%08x esi=%08x edi=%08x ebp=%08x esp=%08x eip=%08x\n\n",
			ExInfo->ContextRecord->Eax,
			ExInfo->ContextRecord->Ebx,
			ExInfo->ContextRecord->Ecx,
			ExInfo->ContextRecord->Edx,
			ExInfo->ContextRecord->Esi,
			ExInfo->ContextRecord->Edi,
			ExInfo->ContextRecord->Ebp,
			ExInfo->ContextRecord->Esp,
			ExInfo->ContextRecord->Eip);

	// X^bN_v
	{
		fprintf(fp, "Stack dump :\n");

		// ȃR[hł̂Ȃc
		DWORD* pStack = (DWORD*)(ExInfo->ContextRecord->Esp);
		for(int y=0;y<8;y++)
		{
			for(int x=0;x<8;x++)
			{
				fprintf(fp, "%08x ", *pStack);
				pStack++;
			}

			fprintf(fp, "\n");
		}

		fprintf(fp, "\n");
	}

	// X^bNg[X
	fprintf(fp, "Stack trace :\n", m_LogHeader);

	/* V{i[pobt@̏ */
	PIMAGEHLP_SYMBOL pSym;
	pSym = (PIMAGEHLP_SYMBOL)GlobalAlloc(GMEM_FIXED, 512);
	pSym->SizeOfStruct = sizeof(IMAGEHLP_SYMBOL);//10000;
	pSym->MaxNameLength = 512 - sizeof(IMAGEHLP_SYMBOL);

	/* X^bNt[̏ */
	STACKFRAME sf;
	ZeroMemory(&sf, sizeof(sf));
	sf.AddrPC.Offset = ExInfo->ContextRecord->Eip;
	sf.AddrStack.Offset = ExInfo->ContextRecord->Esp;
	sf.AddrFrame.Offset = ExInfo->ContextRecord->Ebp;
	sf.AddrPC.Mode = AddrModeFlat;
	sf.AddrStack.Mode = AddrModeFlat;
	sf.AddrFrame.Mode = AddrModeFlat;

	/* V{nh̏ */
	SymInitialize(GetCurrentProcess(), NULL, TRUE);

	/* X^bNt[ɕ\Ă */
	for(;;) {
		/* ̃X^bNt[̎擾 */
		BOOL bResult = StackWalk(
			IMAGE_FILE_MACHINE_I386,
			GetCurrentProcess(),
			GetCurrentThread(),
			&sf,
			NULL, 
			NULL,
			SymFunctionTableAccess,
			SymGetModuleBase,
			NULL);

		/* sȂ΁A[v𔲂 */
		if(!bResult || sf.AddrFrame.Offset == 0) break;

		/* vOJE^֐擾 */
		DWORD Disp;
		bResult = SymGetSymFromAddr(GetCurrentProcess(), sf.AddrPC.Offset, &Disp, pSym);
		
		/* 擾ʂ\ */
		if(bResult)
			fprintf(fp, "0x%08x : %s() + 0x%x\n", sf.AddrPC.Offset, pSym->Name, Disp);
		else
			fprintf(fp, "0x%08x : <No Symbol>\n", sf.AddrPC.Offset);
	}

	/* ㏈ */
	SymCleanup(GetCurrentProcess());
	GlobalFree(pSym);

	fprintf(fp, "\n--- End debug info ---\n\n");
	fclose(fp);

	return(EXCEPTION_CONTINUE_SEARCH);
}

void CCrashHandler::SetCurrentToExeDir(void)
{
	// st@C̃tH_Jgɂ(P)
	// t@ChbvċNƃJgC:\WindowsɂȂƂ^RȎdl̂߁B
	char szTxt[MAX_PATH];

	// scm
	if(GetModuleFileName(NULL, szTxt, MAX_PATH)!=0)
	{
		char* yen = strrchr(szTxt, '\\');
		
		// NULLȂ͂͂Ȃ
		if(yen != NULL)
		{
			// EXEt@C؂̂
			yen[1] = '\0';
			SetCurrentDirectory(szTxt);
		}
	}
}

const char* CCrashHandler::GetExceptionStr(DWORD ExceptionCode)
{
	switch(ExceptionCode)
	{
		case EXCEPTION_ACCESS_VIOLATION:			return "ACCESS_VIOLATION";
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:		return "ARRAY_BOUNDS_EXCEEDED";
		case EXCEPTION_BREAKPOINT:					return "BREAKPOINT";
		case EXCEPTION_DATATYPE_MISALIGNMENT:		return "DATATYPE_MISALIGNMENT";
		case EXCEPTION_FLT_DENORMAL_OPERAND:		return "FLT_DENORMAL_OPERAND";
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:			return "FLT_DIVIDE_BY_ZERO";
		case EXCEPTION_FLT_INEXACT_RESULT:			return "FLT_INEXACT_RESULT";
		case EXCEPTION_FLT_INVALID_OPERATION:		return "FLT_INVALID_OPERATION";
		case EXCEPTION_FLT_OVERFLOW:				return "FLT_OVERFLOW";
		case EXCEPTION_FLT_STACK_CHECK:				return "FLT_STACK_CHECK";
		case EXCEPTION_FLT_UNDERFLOW:				return "FLT_UNDERFLOW";
		case EXCEPTION_ILLEGAL_INSTRUCTION:			return "ILLEGAL_INSTRUCTION";
		case EXCEPTION_IN_PAGE_ERROR:				return "IN_PAGE_ERROR";
		case EXCEPTION_INT_DIVIDE_BY_ZERO:			return "INT_DIVIDE_BY_ZERO";
		case EXCEPTION_INT_OVERFLOW:				return "INT_OVERFLOW";
		case EXCEPTION_INVALID_DISPOSITION:			return "INVALID_DISPOSITION";
		case EXCEPTION_NONCONTINUABLE_EXCEPTION:	return "NONCONTINUABLE_EXCEPTION";
		case EXCEPTION_PRIV_INSTRUCTION:			return "PRIV_INSTRUCTION";
		case EXCEPTION_SINGLE_STEP:					return "SINGLE_STEP";
		case EXCEPTION_STACK_OVERFLOW:				return "STACK_OVERFLOW";
		default:									return "UNKNOWN";
	}
}
