//
// DirectSoundobt@Xg[~OĂNX
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

/*
eventWriteA, B
	obt@---ŏĂ݂

	---------------------------
	            A             B

	AEventAOFill
	BEventAB̊ԂFill

Stop
	t@C̐擪ɃV[N
*/

#include "AudioStream.h"

#include "AudioFileFactory.h"

#include <vector>
using std::vector;

#include <assert.h>
#include <process.h>

// Ɨ񂾂
extern void WriteLog(const char* Format,...);

AudioStream::AudioStream()
{
	m_StreamingThreadHandle = NULL;
	m_ThreadEnd = NULL;
	m_ThreadStop = NULL;
}

AudioStream::~AudioStream()
{
//	WriteLog("~AudioStream() called");
	Term();
}

BOOL AudioStream::Init(void)
{
	if(m_StreamingThreadHandle!=NULL || m_ThreadEnd!=NULL || m_ThreadStop!=NULL)
	{
		assert(0);
		return FALSE; // 2dH
	}

	// XbhIpCxg
	// Xg[~OXbhŎĝŁA
	// KXbhNOɏ
	m_ThreadEnd = CreateEvent(NULL, FALSE, FALSE, NULL);
	if(m_ThreadEnd==NULL)
		return FALSE;

	m_ThreadStop = CreateEvent(NULL, FALSE, FALSE, NULL);
	if(m_ThreadStop==NULL)
		return FALSE;

	// Xg[~OXbhN
	unsigned int threadDesc;
	m_StreamingThreadHandle = (HANDLE)_beginthreadex(NULL, 0, StreamingThread, this, 0, &threadDesc);
	if(m_StreamingThreadHandle==0)
	{
		assert(0);
		WriteLog("AudioStream::Init() : Xg[~OXbh̍쐬Ɏs");
		return FALSE;
	}

	return TRUE;
}

void AudioStream::Term(void)
{
	// Xg[~OXbhI
	if(m_StreamingThreadHandle!=NULL)
	{
		// XgSj
		UnRegisterAll();

		// Iw
		BOOL res = SetEvent(m_ThreadEnd);
		assert(res);

		// I҂
		WaitForSingleObject(m_StreamingThreadHandle, INFINITE);

		CloseHandle(m_StreamingThreadHandle);
		m_StreamingThreadHandle = NULL;
	}

	if(m_ThreadEnd!=NULL)
	{
		CloseHandle(m_ThreadEnd);
		m_ThreadEnd = NULL;
	}

	if(m_ThreadStop!=NULL)
	{
		CloseHandle(m_ThreadStop);
		m_ThreadStop = NULL;
	}
}

BOOL AudioStream::Register(LPDIRECTSOUNDBUFFER dsBuf, const string& fileName, BOOL isLoop/* = FALSE*/)
{
	if(dsBuf==NULL)
		return FALSE;

	AUDIOINFO info;

	// ʒmIuWFNgƁ[
	HRESULT hr = dsBuf->QueryInterface(IID_IDirectSoundNotify, (LPVOID*)&(info.dsNotify));
	if(FAILED(hr))
	{
		assert(0);
		WriteLog("AudioStream::Register() : QueryInterface(IDirectSoundNotify)Ɏs");
		return FALSE;
	}

	info.dsBuf = dsBuf;
	info.readPos = 0;
	info.isLoop = isLoop;

	// AudioFilȅ
	AudioFileFactory fac;
	info.file = fac.Open(fileName.c_str());
	if(info.file==NULL)
	{
		WriteLog("AudioStream::Register() : %sJ܂", fileName.c_str());
		return FALSE;
	}

	// obt@TCYƒʒmʒuvZ
	DSBCAPS caps = { sizeof(DSBCAPS) };
	hr = dsBuf->GetCaps(&caps);
	if(FAILED(hr))
	{
		assert(0);
		WriteLog("AudioStream::Register() : GetCaps()Ɏs");
		return FALSE;
	}

	info.bufSize  = caps.dwBufferBytes;
	info.halfSize = caps.dwBufferBytes/2; // ςbufSizeƂƂƍ񂾂

	// vobt@O
	if(!FillDSBuffer(this, info, FILL_BUF_A) || !FillDSBuffer(this, info, FILL_BUF_B))
	{
		WriteLog("AudioStream::Register() : vobt@OɎs");
		return FALSE;
	}

	// Cxgnhp
	info.eventWriteA = CreateEvent(NULL, FALSE, FALSE, NULL);
	info.eventWriteB = CreateEvent(NULL, FALSE, FALSE, NULL);
	info.eventStop = CreateEvent(NULL, FALSE, FALSE, NULL);

	if(info.eventWriteA==NULL || info.eventWriteB==NULL || info.eventStop==NULL)
	{
		assert(0);
		WriteLog("AudioStream::Register() : CreateEvent()Ɏs");
		return FALSE;
	}

	// ʒmʒuݒ
	DSBPOSITIONNOTIFY positionNotify[3] = {
		{ info.halfSize-1,	info.eventWriteA },
		{ info.bufSize-1,	info.eventWriteB },
		{ DSBPN_OFFSETSTOP,	info.eventStop },
		// DSBPN_OFFSETSTOPgƂ́Aʒuʒmz̍Ō̍ڂƂׂłB
	};

	hr = info.dsNotify->SetNotificationPositions(3, positionNotify);
	if(FAILED(hr))
	{
		assert(0);
		WriteLog("AudioStream::Register() : SetNotificationPositions()Ɏs");
		return FALSE;
	}

	// Xgɓo^
	SetEvent(m_ThreadStop);
	m_Ack.Wait();
	m_Ack.UnSignal();
	{
		// ŃXbh͂Ǝ~܂Ă
		m_AudioInfo.push_back(info);
	}
	m_ThreadStart.Signal();
		// ̊ԂɃXbhŃXg̍ēǂݍ݂s
	m_Ack.Wait();
	m_Ack.UnSignal();

	return TRUE;
}

BOOL AudioStream::SetLoop(LPDIRECTSOUNDBUFFER dsBuf, BOOL isLoop)
{
	BOOL bFound = FALSE;

	// Xg猟ď
	SetEvent(m_ThreadStop);
	m_Ack.Wait();
	m_Ack.UnSignal();
	{
		// ŃXbh͂Ǝ~܂Ă
		vector<AUDIOINFO>::iterator it;
		for(it=m_AudioInfo.begin() ; it!=m_AudioInfo.end() ; it++)
		{
			if((*it).dsBuf == dsBuf)
			{
				// ړĨuc
				(*it).isLoop = isLoop;
				bFound = TRUE;
				break;
			}
		}
	}

	m_ThreadStart.Signal();
		// ̊ԂɃXbhŃXg̍ēǂݍ݂s
	m_Ack.Wait();
	m_Ack.UnSignal();

	return bFound;
}

BOOL AudioStream::UnRegister(LPDIRECTSOUNDBUFFER dsBuf)
{
	// Xg猟E
	SetEvent(m_ThreadStop);
	m_Ack.Wait();
	m_Ack.UnSignal();
	{
		// ŃXbh͂Ǝ~܂Ă

		// tF[h̃obt@܂폜
		m_FadeInfoCS.Enter();
		{
			list<FADEINFO>::iterator it;
			for(it=m_FadeInfo.begin() ; it!=m_FadeInfo.end() ; it++)
			{
				if((*it).dsBuf == dsBuf)
				{
					m_FadeInfo.erase(it);
					break;
				}
			}
		}
		m_FadeInfoCS.Leave();

		vector<AUDIOINFO>::iterator it;
		for(it=m_AudioInfo.begin() ; it!=m_AudioInfo.end() ; it++)
		{
			if((*it).dsBuf == dsBuf)
			{
				// ړĨuc
				(*it).dsNotify->Release();
				CloseHandle((*it).eventStop);
				CloseHandle((*it).eventWriteA);
				CloseHandle((*it).eventWriteB);
				delete (*it).file;

				m_AudioInfo.erase(it);
				break;
			}
		}
	}
	m_ThreadStart.Signal();
		// ̊ԂɃXbhŃXg̍ēǂݍ݂s
	m_Ack.Wait();
	m_Ack.UnSignal();

	return TRUE;
}

/**********************************************************

	牺privateBʉ̓ẃc

***********************************************************/

void AudioStream::FadeOut(BYTE* buf, DWORD written, DWORD bits, DWORD ch)
{
	//
	// {͏ݗʂ܂ɏȂƃtF[h̑x̂ŁA
	// ЂƂÕobt@ɂ̂ڂătF[hȂƂȂc
	//

	int fadeSize = 4096; // blockAlignĂ
	if((int)written < fadeSize)
	{
		fadeSize = written;
		// WriteLog("fadelen : %d", fadeSize);
	}

	if(bits==8)
	{
		if(ch==1)
		{
			for(int i=0;i<fadeSize;i++)
			{
				DWORD val = buf[written-fadeSize+i];
				val *= (fadeSize-i);
				val /= fadeSize;
				buf[written-fadeSize+i] = (BYTE)val;
			}
		}
		else
		{
			for(int i=0;i<fadeSize/2;i++)
			{
				DWORD val = buf[written-fadeSize+i*2];
				val *= (fadeSize-i*2);
				val /= fadeSize;
				buf[written-fadeSize+i*2] = (BYTE)val;

				val = buf[written-fadeSize+i*2+1];
				val *= (fadeSize-i*2);
				val /= fadeSize;
				buf[written-fadeSize+i*2+1] = (BYTE)val;
			}
		}
	}
	else
	{
		if(ch==1)
		{
			for(int i=0;i<fadeSize/2;i++)
			{
				int val = (int)*(short*)&buf[written-fadeSize+i*2];
				val *= (fadeSize-i*2);
				val /= fadeSize;
				*(short*)&buf[written-fadeSize+i*2] = (short)val;
			}
		}
		else
		{
			for(int i=0;i<fadeSize/4;i++)
			{
				int val = (int)*(short*)&buf[written-fadeSize+i*4];
				val *= (fadeSize-i*4);
				val /= fadeSize;
				*(short*)&buf[written-fadeSize+i*4] = (short)val;

				val = (int)*(short*)&buf[written-fadeSize+i*4+2];
				val *= (fadeSize-i*4);
				val /= fadeSize;
				*(short*)&buf[written-fadeSize+i*4+2] = (short)val;
			}
		}
	}
}

BOOL AudioStream::FillDSBuffer(AudioStream* as, AUDIOINFO& info, int whichBuf)
{
	if(whichBuf!=FILL_BUF_A && whichBuf!=FILL_BUF_B)
		return FALSE;

	if(info.stopCount != -1)
	{
		info.stopCount--;
		if(info.stopCount==0)
		{
			// f[^̖ɂ̂Stop
			// StopEventōĐʒu߂ăvobt@O͂
			DWORD lockPos, lockLen;
			if(whichBuf==FILL_BUF_A)
			{
				lockPos = 0;
				lockLen = info.halfSize;
			}
			else
			{
				lockPos = info.halfSize;
				lockLen = info.bufSize - info.halfSize;
			}

			DWORD lockedBytes;
			BYTE* buf;
			HRESULT hr = info.dsBuf->Lock(lockPos, lockLen, (LPVOID*)&buf, &lockedBytes, NULL, NULL, 0);
			if(FAILED(hr) || lockedBytes!=lockLen)
			{
				assert(0); // [
				return FALSE;
			}
			ZeroMemory(buf, lockLen);
			info.dsBuf->Unlock(buf, lockLen, NULL, 0);

			// ƂŃ{[邽߂ɕۑ
			info.dsBuf->GetVolume(&info.oldVolume);
			
			// ʂStopƃmCŶŃtF[hc
			//info.dsBuf->SetVolume(DSBVOLUME_MIN);
			// info.dsBuf->Stop();
			as->m_FadeInfoCS.Enter();
			{
				FADEINFO fade;
				fade.dsBuf = info.dsBuf;
				fade.startTime = timeGetTime();
				as->m_FadeInfo.push_back(fade);
			}
			as->m_FadeInfoCS.Leave();

			info.stopCount = -1;
			return TRUE;
		}
	}

	DWORD lockPos;
	DWORD lockLen;

	if(whichBuf==FILL_BUF_A)
	{
		lockPos = 0;
		lockLen = info.halfSize;
	}
	else
	{
		lockPos = info.halfSize;
		lockLen = info.bufSize - info.halfSize;
	}

	BYTE* buf;

	// obt@̖𒴂邱Ƃ͂Ȃ
	DWORD lockedBytes;
	HRESULT hr = info.dsBuf->Lock(lockPos, lockLen, (LPVOID*)&buf, &lockedBytes, NULL, NULL, 0);
	if(FAILED(hr) || lockedBytes!=lockLen)
	{
		assert(0); // [
		return FALSE;
	}

	// obt@ɏ
	unsigned int written = info.file->Read(buf, lockLen);
	if(written != lockLen)
	{
		// EOFG[N炵
		if(info.isLoop)
		{
			// [vLȂ̂ōŏɖ߂đ
			info.file->Seek(0);

			unsigned int toRead = lockLen-written;
			if(info.file->Read(buf+written, toRead) != toRead)
			{
				// m
				assert(0);
				info.dsBuf->Unlock(buf, lockLen, NULL, 0);
				return FALSE;
			}
		}
		else
		{
			if(written!=0)
			{
				// [vȂ̂Ńv`mCY΍ɍŌtF[hAEg
				FadeOut(buf, written, info.file->GetBitsPerSample(), info.file->GetChannelCount());
			}
				
			// ]vȉȂ悤ɗ]0Ŗ߂
			unsigned int toRead = lockLen-written;
			ZeroMemory(buf+written, toRead);

			// 2FillBufferStop
			// ms~xꂻȋC񂾂ǁc
			if(info.stopCount == -1)
				info.stopCount = 2;
		}
	}

	info.dsBuf->Unlock(buf, lockLen, NULL, 0);

	return TRUE;
}

void AudioStream::ProcessBuffer(AudioStream* as, AUDIOINFO& info, int whichEvent)
{
	// ݃J[\ʒuƃtOgāAoObNotify̑΍
	// by http://www1.odn.ne.jp/ceb94660/frameset.html
	// łXg[~OƑΏȂB
	// ˂݂Notify͎g킸ׂ
	const DWORD CANT_GET_POS = 0xFFFFFFFF;
	DWORD writePos;
	if(FAILED(info.dsBuf->GetCurrentPosition(NULL, &writePos)))
	{
		// ȂȂdȂBNofifyM
		writePos = CANT_GET_POS;
	}

	switch(whichEvent)
	{
		case 0:
		{
			// Stop
			// Đʒu߂ăvobt@O
			info.readPos = 0;
			info.file->Seek(0);
			info.dsBuf->SetCurrentPosition(0); // Stop()͂̏ōĐJ[\~܂Ă邩߂
			info.dsBuf->SetVolume(info.oldVolume);
			FillDSBuffer(as, info, FILL_BUF_A);
			FillDSBuffer(as, info, FILL_BUF_B);
			info.fillFlag = FILL_BUF_A; // A
			break;
		}

		case 1:
		{
			// Write A
/*			if(writePos!=CANT_GET_POS)
			{
				if(writePos<=info.halfSize || info.fillFlag!=FILL_BUF_A)
				{
					// NotifyBĂقȂ̂
					// WriteLog("WriteA : wrong Notify");
					break;
				}
			}
*/
			FillDSBuffer(as, info, FILL_BUF_A);
			info.fillFlag = FILL_BUF_B; // B
			break;
		}

		case 2:
		{
			// Write B
/*			if(writePos!=CANT_GET_POS)
			{
				if(writePos>=info.halfSize || info.fillFlag!=FILL_BUF_B)
				{
					// NotifyBĂقȂ̂
					// WriteLog("WriteB : wrong Notify");
					break;
				}
			}
*/
			FillDSBuffer(as, info, FILL_BUF_B);
			info.fillFlag = FILL_BUF_A; // A
			break;
		}
	}
}

void AudioStream::ReloadAudioInfoList(vector<HANDLE>& handles, AudioStream* as)
{
	handles.clear();
	handles.push_back(as->m_ThreadEnd);
	handles.push_back(as->m_ThreadStop);

	vector<AUDIOINFO>::iterator it;
	for(it=as->m_AudioInfo.begin() ; it!=as->m_AudioInfo.end() ; it++)
	{
		handles.push_back((*it).eventStop);
		handles.push_back((*it).eventWriteA);
		handles.push_back((*it).eventWriteB);
	}
}

unsigned __stdcall AudioStream::StreamingThread(void* lpAudioStream)
{
	AudioStream* as = (AudioStream*)lpAudioStream;
	if(as==NULL)
		return 1; // 

	// Cxgnh
	vector<HANDLE> handles;
	ReloadAudioInfoList(handles, as);

	while(1)
	{
		if(handles.size() <= MAXIMUM_WAIT_OBJECTS)
		{
			// fɑSɑ҂
			DWORD res = WaitForMultipleObjects((DWORD)handles.size(), &handles[0], FALSE, 5);
			switch(res)
			{
				case WAIT_OBJECT_0+0:
				{
					// I
					return 0;
					break;
				}

				case WAIT_OBJECT_0+1:
				{
					// ꎞ~

					// ~̂ŉԂ
					as->m_Ack.Signal();

					// ĊJw߂҂
					as->m_ThreadStart.Wait();
					as->m_ThreadStart.UnSignal();

					// w߂̂ŃXgēǂݍ݂ĉԂ
					ReloadAudioInfoList(handles, as);
					as->m_Ack.Signal();
					break;
				}

				case WAIT_FAILED:
				{
					assert(0);

					// [XoCił͂Ƃ肠
					ReloadAudioInfoList(handles, as);
					break;
				}

				default:
				{
					if(WAIT_OBJECT_0+2 <= res && res < WAIT_OBJECT_0+2+handles.size())
					{
						int num = (res - (WAIT_OBJECT_0+2)) / 3; // m_AudioInfỏԖڂɑΉ̂
						int whichEvent = (res - (WAIT_OBJECT_0+2)) % 3; // ǂ̃CxgȂ̂
						ProcessBuffer(as, as->m_AudioInfo[num], whichEvent);
					}
					break;
				}
			}
		}
		else
		{
			// ^CXCXH
			DWORD timeOut = 1; // ĂƂ

			// ܂͊{2
			DWORD res = WaitForMultipleObjects(2, &handles[0], FALSE, timeOut);
			switch(res)
			{
				case WAIT_OBJECT_0:
				{
					// I
					return 0;
					break;
				}

				case WAIT_OBJECT_0 + 1:
				{
					// ꎞ~

					// ~̂ŉԂ
					as->m_Ack.Signal();

					// ĊJw߂҂
					as->m_ThreadStart.Wait();
					as->m_ThreadStart.UnSignal();

					// w߂̂ŃXgēǂݍ݂ĉԂ
					ReloadAudioInfoList(handles, as);
					as->m_Ack.Signal();
					break;
				}

				case WAIT_FAILED:
				{
					assert(0);

					// [XoCił͂Ƃ肠
					ReloadAudioInfoList(handles, as);
					break;
				}

				// ȊO̓^CAEgG[Ȃ̂łقĂ
			}

			// c̓IuWFNgɉ
			// 21IuWFNg63Cxg҂
			const int events = 63;
			int times = ((int)handles.size()-2) / events + 1;
			for(int i=0;i<times;i++)
			{
				int count;
				if(2 + (i+1)*events > (int)handles.size())
					count = (int)handles.size() - (2 + i*events); // Ō̂P͒[Ȃ̂Œ
				else
					count = events;

				if(count==0)
					break;

				DWORD res = WaitForMultipleObjects(count, &handles[2 + i*events], FALSE, timeOut);

				if(WAIT_OBJECT_0 <= res && res < WAIT_OBJECT_0+count)
				{
					int num = (res - WAIT_OBJECT_0) / 3; // m_AudioInfỏԖڂɑΉ̂
					int whichEvent = (res - WAIT_OBJECT_0) % 3; // ǂ̃CxgȂ̂
					ProcessBuffer(as, as->m_AudioInfo[i*events/3 + num], whichEvent);
				}
			}
		} // endof if(handles.size() <= MAXIMUM_WAIT_OBJECTS)

		// Cxgҋ@ItF[h
		// ł^CXCXĂƂ܂蕪\ǂȂǁcdȂ
		as->m_FadeInfoCS.Enter();
		{
			list<FADEINFO>::iterator it;
			for(it=as->m_FadeInfo.begin() ; it!=as->m_FadeInfo.end() ; )
			{
				if(timeGetTime() < (*it).startTime)
				{
					// ʧHH
					assert(0);
					it++; // Releaseł͖قđs
				}
				else if(timeGetTime() > (*it).startTime+FADE_TIME)
				{
					// tF[h
					(*it).dsBuf->SetVolume(DSBVOLUME_MIN);
					(*it).dsBuf->Stop();
					// WriteLog("fade : %p : stop", (*it).dsBuf);
					it = as->m_FadeInfo.erase(it);
				}
				else
				{
					// tF[h
					LONG elTime = LONG(timeGetTime() - (*it).startTime);
					LONG vol = LONG(DSBVOLUME_MIN - DSBVOLUME_MAX) * elTime / FADE_TIME;

					if(vol >= DSBVOLUME_MIN) // Ô
						(*it).dsBuf->SetVolume(vol);

					// WriteLog("fade : %p : %d", (*it).dsBuf, vol);
					it++;
				}
			}
		}
		as->m_FadeInfoCS.Leave();

	} // endof while(1)
}

void AudioStream::UnRegisterAll(void)
{
	// Xgׂĉ
	SetEvent(m_ThreadStop);
	m_Ack.Wait();
	m_Ack.UnSignal();
	{
		// ŃXbh͂Ǝ~܂Ă

		// tF[h̃obt@܂폜
		m_FadeInfoCS.Enter();
		{
			list<FADEINFO>::iterator it;
			for(it=m_FadeInfo.begin() ; it!=m_FadeInfo.end() ; )
			{
				it = m_FadeInfo.erase(it);
			}
		}
		m_FadeInfoCS.Leave();

		vector<AUDIOINFO>::iterator it;
		for(it=m_AudioInfo.begin() ; it!=m_AudioInfo.end() ;)
		{
			(*it).dsNotify->Release();
			CloseHandle((*it).eventStop);
			CloseHandle((*it).eventWriteA);
			CloseHandle((*it).eventWriteB);
			delete (*it).file;

			it = m_AudioInfo.erase(it);
		}
	}
	m_ThreadStart.Signal();
		// ̊ԂɃXbhŃXg̍ēǂݍ݂s
	m_Ack.Wait();
	m_Ack.UnSignal();
}
