/* File: tables.c */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

/* Purpose: Angband Tables */

#include "angband.h"


/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[DIRECTION_NUM] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/*
 * Circular keypad direction array
 */
s16b cdd[8] =
{ 2, 3, 6, 9, 8, 7, 4, 1 };

/*
 * Global arrays for optimizing "ddx[cdd[i]]" and "ddy[cdd[i]]"
 */
s16b ddx_cdd[8] =
{ 0, 1, 1, 1, 0, -1, -1, -1 };

s16b ddy_cdd[8] =
{ 1, 1, 0, -1, -1, -1, 0, 1 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting numbers to a logical list symbol
 */
char listsym[] =
{
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
	'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
	'\0'
};


/*
 * Encode the screen colors
 */
cptr color_char = "dwsorgbuDWvyRGBU";


// Base Action point
s16b adj_dex_action_point[STAT_TABLE_SIZE] =
{
	400	/* 3 */,
	350	/* 4 */,
	320	/* 5 */,
	290	/* 6 */,
	260	/* 7 */,
	230	/* 8 */,
	200	/* 9 */,
	190	/* 10 */,
	180	/* 11 */,
	170	/* 12 */,
	160	/* 13 */,
	150	/* 14 */,
	140	/* 15 */,
	130	/* 16 */,
	120	/* 17 */,
	115	/* 18 */,
	110	/* 19 */,
	105	/* 20 */,
	100	/* 21 */,
	 95	/* 22 */,
	 90	/* 23 */,
	 86	/* 24 */,
	 82	/* 25 */,
	 78	/* 26 */,
	 75	/* 27 */,
	 72	/* 28 */,
	 69	/* 29 */,
	 66	/* 30 */,
	 63	/* 31 */,
	 60	/* 32 */,
	 57	/* 33 */,
	 55 /* 34 */,
	 53	/* 35 */,
	 51	/* 36 */,
	 49	/* 37 */,
	 47	/* 38 */,
	 45	/* 39 */,
	 44	/* 40 */,
	 43 /* 41 */,
	 42	/* 42 */,
	 41	/* 43 */,
	 40	/* 44 */,
	 40	/* 45 */,
	 39	/* 46 */,
	 39	/* 47 */,
	 38	/* 48 */,
	 38	/* 49 */,
	 37	/* 50 */,
	 37	/* 51 */,
	 36	/* 52 */,
	 36	/* 53 */,
	 35	/* 54 */,
	 35	/* 55 */,
	 35	/* 56 */,
	 34	/* 57 */,
	 34	/* 58 */,
	 34	/* 59 */,
	 33	/* 60 */,
};

s16b adj_weight_action_point[PERCENTAGE / 5 + 1] =
{
	100, // 00-04%
	102, // 05-09%
	105, // 10-14%
	110, // 15-19%
	120, // 20-24%

	140, // 25-29%
	160, // 30-34%
	190, // 35-39%
	240, // 40-44%
	300, // 45-49%

	360, // 50-54%
	420, // 55-59%
	500, // 60-64%
	600, // 65-69%
	700, // 70-74%

	800, // 75-79%
	900, // 80-84%
	1000, // 85-89%
	1200, // 90-94%
	1400, // 95-99%

	1400, // 100%
};




/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[STAT_TABLE_SIZE] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18 */,
	2	/* 19 */,
	2	/* 20 */,
	2	/* 21 */,
	2	/* 22 */,
	3	/* 23 */,
	3	/* 24 */,
	3	/* 25 */,
	3	/* 26 */,
	4	/* 27 */,
	4	/* 28 */,
	4	/* 29 */,
	5	/* 30 */,
	5	/* 31 */,
	5	/* 32 */,
	5	/* 33 */,
	5	/* 34 */,
	5	/* 35 */,
	5	/* 36 */,
	5	/* 37 */,
	5	/* 38 */,
	6	/* 39 */,
	6	/* 40 */,
	6	/* 41 */,
	6	/* 42 */,
	6	/* 43 */,
	6	/* 44 */,
	6	/* 45 */,
	6	/* 46 */,
	6	/* 47 */,
	6	/* 48 */,
	6	/* 49 */,
	6	/* 50 */,
	6	/* 51 */,
	6	/* 52 */,
	6	/* 53 */,
	6	/* 54 */,
	6	/* 55 */,
	6	/* 56 */,
	6	/* 57 */,
	6	/* 58 */,
	6	/* 59 */,
	6	/* 60 */,
};


/*
 * Stat Table (INT/WIS) -- extra 1/4-mana-points per level
 */
byte adj_mag_mana[STAT_TABLE_SIZE] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	2       /* 9 */,
	3       /* 10 */,
	4       /* 11 */,
	5       /* 12 */,
	5       /* 13 */,
	6       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	9       /* 17 */,
	10      /* 18 */,
	11      /* 19 */,
	11      /* 20 */,
	12      /* 21 */,
	12      /* 22 */,
	13      /* 23 */,
	14      /* 24 */,
	15      /* 25 */,
	16      /* 26 */,
	17      /* 27 */,
	18      /* 28 */,
	19      /* 29 */,
	20      /* 30 */,
	21      /* 31 */,
	22      /* 32 */,
	23      /* 33 */,
	24      /* 34 */,
	25      /* 35 */,
	26      /* 36 */,
	27      /* 37 */,
	28      /* 38 */,
	29      /* 39 */,
	30      /* 40 */,
	31      /* 41 */,
	32      /* 42 */,
	33      /* 43 */,
	34      /* 44 */,
	35      /* 45 */,
	36      /* 46 */,
	37      /* 47 */,
	38      /* 48 */,
	39      /* 49 */,
	40      /* 50 */,
	41      /* 51 */,
	42      /* 52 */,
	43      /* 53 */,
	44      /* 54 */,
	45      /* 55 */,
	46      /* 56 */,
	47      /* 57 */,
	48      /* 58 */,
	49      /* 59 */,
	50      /* 60 */,
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[STAT_TABLE_SIZE] =
{
	99      /* 3 */,
	99      /* 4 */,
	99      /* 5 */,
	99      /* 6 */,
	99      /* 7 */,
	50      /* 8 */,
	30      /* 9 */,
	20      /* 10 */,
	15      /* 11 */,
	12      /* 12 */,
	11      /* 13 */,
	10      /* 14 */,
	9       /* 15 */,
	8       /* 16 */,
	7       /* 17 */,
	6       /* 18 */,
	6       /* 19 */,
	5       /* 20 */,
	5       /* 21 */,
	5       /* 22 */,
	4       /* 23 */,
	4       /* 24 */,
	4       /* 25 */,
	4       /* 26 */,
	3       /* 27 */,
	3       /* 28 */,
	2       /* 29 */,
	2       /* 30 */,
	2       /* 31 */,
	2       /* 32 */,
	1       /* 33 */,
	1       /* 34 */,
	1       /* 35 */,
	1       /* 36 */,
	1       /* 37 */,
	0       /* 38 */,
	0       /* 39 */,
	0       /* 40 */,
	0       /* 41 */,
	0       /* 42 */,
	0       /* 43 */,
	0       /* 44 */,
	0       /* 45 */,
	0       /* 46 */,
	0       /* 47 */,
	0       /* 48 */,
	0       /* 49 */,
	0       /* 50 */,
	0       /* 51 */,
	0       /* 52 */,
	0       /* 53 */,
	0       /* 54 */,
	0       /* 55 */,
	0       /* 56 */,
	0       /* 57 */,
	0       /* 58 */,
	0       /* 59 */,
	0       /* 60 */,
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[STAT_TABLE_SIZE] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18 */,
	3       /* 19 */,
	3       /* 20 */,
	3       /* 21 */,
	3       /* 22 */,
	4       /* 23 */,
	4       /* 24 */,
	5       /* 25 */,
	6       /* 26 */,
	7       /* 27 */,
	8       /* 28 */,
	9       /* 29 */,
	10      /* 30 */,
	11      /* 31 */,
	12      /* 32 */,
	13      /* 33 */,
	14      /* 34 */,
	15      /* 35 */,
	16      /* 36 */,
	17      /* 37 */,
	18      /* 38 */,
	19      /* 39 */,
	20      /* 40 */,
	21      /* 41 */,
	22      /* 42 */,
	23      /* 43 */,
	24      /* 44 */,
	25      /* 45 */,
	26      /* 46 */,
	27      /* 47 */,
	28      /* 48 */,
	30      /* 49 */,
	32      /* 50 */,
	34      /* 51 */,
	36      /* 52 */,
	38      /* 53 */,
	40      /* 54 */,
	42      /* 55 */,
	44      /* 56 */,
	46      /* 57 */,
	48      /* 58 */,
	50      /* 59 */,
	52      /* 60 */,
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[STAT_TABLE_SIZE] =
{
	130     /* 3 */,
	125     /* 4 */,
	122     /* 5 */,
	120     /* 6 */,
	118     /* 7 */,
	116     /* 8 */,
	114     /* 9 */,
	112     /* 10 */,
	110     /* 11 */,
	108     /* 12 */,
	106     /* 13 */,
	104     /* 14 */,
	103     /* 15 */,
	102     /* 16 */,
	101     /* 17 */,
	100     /* 18 */,
	99      /* 19 */,
	98      /* 20 */,
	97      /* 21 */,
	96      /* 22 */,
	95      /* 23 */,
	94      /* 24 */,
	93      /* 25 */,
	92      /* 26 */,
	91      /* 27 */,
	90      /* 28 */,
	89      /* 29 */,
	88      /* 30 */,
	87      /* 31 */,
	86      /* 32 */,
	85      /* 33 */,
	84      /* 34 */,
	83      /* 35 */,
	82      /* 36 */,
	81      /* 37 */,
	80      /* 38 */,
	79      /* 39 */,
	78      /* 40 */,
	76      /* 41 */,
	74      /* 42 */,
	72      /* 43 */,
	70      /* 44 */,
	68      /* 45 */,
	66      /* 46 */,
	64      /* 47 */,
	62      /* 48 */,
	60      /* 49 */,
	58      /* 50 */,
	56      /* 51 */,
	54      /* 52 */,
	52      /* 53 */,
	50      /* 54 */,
	50      /* 55 */,
	50      /* 56 */,
	50      /* 57 */,
	50      /* 58 */,
	50      /* 59 */,
	50      /* 60 */,
};

                                                                            
/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[STAT_TABLE_SIZE] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18 */,
	3       /* 19 */,
	4       /* 20 */,
	4       /* 21 */,
	5       /* 22 */,
	5       /* 23 */,
	6       /* 24 */,
	6       /* 25 */,
	7       /* 26 */,
	7       /* 27 */,
	8       /* 28 */,
	9       /* 29 */,
	10      /* 30 */,
	11      /* 31 */,
	12      /* 32 */,
	13      /* 33 */,
	14      /* 34 */,
	15      /* 35 */,
	16      /* 36 */,
	17      /* 37 */,
	18      /* 38 */,
	19      /* 39 */,
	20      /* 40 */,
	22      /* 41 */,
	24      /* 42 */,
	26      /* 43 */,
	28      /* 44 */,
	30      /* 45 */,
	32      /* 46 */,
	34      /* 47 */,
	36      /* 48 */,
	38      /* 49 */,
	40      /* 50 */,
	42      /* 51 */,
	44      /* 52 */,
	46      /* 53 */,
	48      /* 54 */,
	50      /* 55 */,
	52      /* 56 */,
	54      /* 57 */,
	56      /* 58 */,
	58      /* 59 */,
	60      /* 60 */,
};


/*
 * Stat Table -- Saving throw
 */
int adj_sav[STAT_TABLE_SIZE] =
{
	-10     /* 3 */,
	-9      /* 4 */,
	-8      /* 5 */,
	-7      /* 6 */,
	-6      /* 7 */,
	-5      /* 8 */,
	-4      /* 9 */,
	-3      /* 10 */,
	-2      /* 11 */,
	-1      /* 12 */,
	0       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	3       /* 16 */,
	4       /* 17 */,
	5       /* 18 */,
	6       /* 19 */,
	7       /* 20 */,
	8       /* 21 */,
	9       /* 22 */,
	10       /* 23 */,
	11       /* 24 */,
	12       /* 25 */,
	14       /* 26 */,
	16       /* 27 */,
	18       /* 28 */,
	20       /* 29 */,
	22       /* 30 */,
	24      /* 31 */,
	26      /* 32 */,
	28      /* 33 */,
	30      /* 34 */,
	32      /* 35 */,
	34      /* 36 */,
	37      /* 37 */,
	40      /* 38 */,
	43      /* 39 */,
	46      /* 40 */,
	49      /* 41 */,
	52      /* 42 */,
	55      /* 43 */,
	58      /* 44 */,
	61      /* 45 */,
	64      /* 46 */,
	67      /* 47 */,
	70      /* 48 */,
	73      /* 49 */,
	76      /* 50 */,
	80      /* 51 */,
	84      /* 52 */,
	88      /* 53 */,
	92      /* 54 */,
	96      /* 55 */,
	100     /* 56 */,
	104     /* 57 */,
	108     /* 58 */,
	112     /* 59 */,
	116     /* 60 */,
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[STAT_TABLE_SIZE] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	4       /* 18 */,
	4       /* 19 */,
	4       /* 20 */,
	4       /* 21 */,
	5       /* 22 */,
	5       /* 23 */,
	5       /* 24 */,
	6       /* 25 */,
	6       /* 26 */,
	7       /* 27 */,
	7       /* 28 */,
	8       /* 29 */,
	8       /* 30 */,
	9       /* 31 */,
	9       /* 32 */,
	10       /* 33 */,
	10       /* 34 */,
	11       /* 35 */,
	11       /* 36 */,
	12       /* 37 */,
	12      /* 38 */,
	13      /* 39 */,
	14      /* 40 */,
	15      /* 41 */,
	16      /* 42 */,
	17      /* 43 */,
	18      /* 44 */,
	19      /* 45 */,
	20      /* 46 */,
	21      /* 47 */,
	22      /* 48 */,
	23      /* 49 */,
	24      /* 50 */,
	25      /* 51 */,
	26      /* 52 */,
	27      /* 53 */,
	28      /* 54 */,
	29      /* 55 */,
	30      /* 56 */,
	32      /* 57 */,
	34      /* 58 */,
	37      /* 59 */,
	40      /* 60 */,
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[STAT_TABLE_SIZE] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18 */,
	3       /* 19 */,
	3       /* 20 */,
	4       /* 21 */,
	4       /* 22 */,
	5       /* 23 */,
	6       /* 24 */,
	7       /* 25 */,
	8       /* 26 */,
	9       /* 27 */,
	10      /* 28 */,
	10      /* 29 */,
	11      /* 30 */,
	12      /* 31 */,
	13      /* 32 */,
	14      /* 33 */,
	15      /* 34 */,
	16      /* 35 */,
	17      /* 36 */,
	18      /* 37 */,
	19      /* 38 */,
	19      /* 39 */,
	20      /* 40 */,
	20      /* 41 */,
	21      /* 42 */,
	22      /* 43 */,
	23      /* 44 */,
	24      /* 45 */,
	25      /* 46 */,
	26      /* 47 */,
	27      /* 48 */,
	28      /* 49 */,
	29      /* 50 */,
	30      /* 51 */,
	31      /* 52 */,
	32      /* 53 */,
	33      /* 54 */,
	34      /* 55 */,
	35      /* 56 */,
	36      /* 57 */,
	37      /* 58 */,
	38      /* 59 */,
	40      /* 60 */,
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
s16b adj_dex_to_ac[STAT_TABLE_SIZE] =
{
	-4    /* 3 */,
	-3    /* 4 */,
	-2    /* 5 */,
	-1    /* 6 */,
	0     /* 7 */,
	0     /* 8 */,
	0     /* 9 */,
	0     /* 10 */,
	0     /* 11 */,
	0     /* 12 */,
	0     /* 13 */,
	0     /* 14 */,
	1     /* 15 */,
	1     /* 16 */,
	1     /* 17 */,
	2     /* 18 */,
	2     /* 19 */,
	2     /* 20 */,
	2     /* 21 */,
	2     /* 22 */,
	3     /* 23 */,
	3     /* 24 */,
	3     /* 25 */,
	4     /* 26 */,
	5     /* 27 */,
	6     /* 28 */,
	7     /* 29 */,
	8     /* 30 */,
	9     /* 31 */,
	9     /* 32 */,
	10    /* 33 */,
	11    /* 34 */,
	12    /* 35 */,
	13    /* 36 */,
	14    /* 37 */,
	15    /* 38 */,
	15    /* 39 */,
	16    /* 40 */,
	16    /* 41 */,
	17    /* 42 */,
	17    /* 43 */,
	18    /* 44 */,
	18    /* 45 */,
	19    /* 46 */,
	19    /* 47 */,
	20    /* 48 */,
	20    /* 49 */,
	21    /* 50 */,
	21    /* 51 */,
	22    /* 52 */,
	22    /* 53 */,
	23    /* 54 */,
	23    /* 55 */,
	24    /* 56 */,
	24    /* 57 */,
	25    /* 58 */,
	25    /* 59 */,
	26    /* 60 */,
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
s16b adj_str_to_damage[STAT_TABLE_SIZE] =
{
	-2    /* 3 */,
	-2    /* 4 */,
	-1    /* 5 */,
	-1    /* 6 */,
	0     /* 7 */,
	0     /* 8 */,
	0     /* 9 */,
	0     /* 10 */,
	0     /* 11 */,
	0     /* 12 */,
	0     /* 13 */,
	0     /* 14 */,
	0     /* 15 */,
	1     /* 16 */,
	2     /* 17 */,
	2     /* 18 */,
	2     /* 19 */,
	3     /* 20 */,
	3     /* 21 */,
	3     /* 22 */,
	3     /* 23 */,
	3     /* 24 */,
	4     /* 25 */,
	5     /* 26 */,
	5     /* 27 */,
	6     /* 28 */,
	7     /* 29 */,
	8     /* 30 */,
	9     /* 31 */,
	10    /* 32 */,
	11    /* 33 */,
	12    /* 34 */,
	13    /* 35 */,
	14    /* 36 */,
	15    /* 37 */,
	16    /* 38 */,
	18    /* 39 */,
	19    /* 40 */,
	19    /* 41 */,
	20    /* 42 */,
	20    /* 43 */,
	21    /* 44 */,
	21    /* 45 */,
	22    /* 46 */,
	22    /* 47 */,
	23    /* 48 */,
	23    /* 49 */,
	24    /* 50 */,
	24    /* 51 */,
	25    /* 52 */,
	25    /* 53 */,
	26    /* 54 */,
	26    /* 55 */,
	27    /* 56 */,
	27    /* 57 */,
	28    /* 58 */,
	30    /* 59 */,
	32    /* 60 */,
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
s16b adj_dex_to_hit[STAT_TABLE_SIZE] =
{
	-3    /* 3 */,
	-2    /* 4 */,
	-2    /* 5 */,
	-1    /* 6 */,
	-1    /* 7 */,
	0     /* 8 */,
	0     /* 9 */,
	0     /* 10 */,
	0     /* 11 */,
	0     /* 12 */,
	0     /* 13 */,
	0     /* 14 */,
	0     /* 15 */,
	1     /* 16 */,
	2     /* 17 */,
	3     /* 18 */,
	3     /* 19 */,
	3     /* 20 */,
	3     /* 21 */,
	3     /* 22 */,
	4     /* 23 */,
	4     /* 24 */,
	4     /* 25 */,
	4     /* 26 */,
	5     /* 27 */,
	6     /* 28 */,
	7     /* 29 */,
	8     /* 30 */,
	9     /* 31 */,
	9     /* 32 */,
	10    /* 33 */,
	11    /* 34 */,
	12    /* 35 */,
	13    /* 36 */,
	14    /* 37 */,
	15    /* 38 */,
	15    /* 39 */,
	16    /* 40 */,
	16    /* 41 */,
	17    /* 42 */,
	17    /* 43 */,
	18    /* 44 */,
	18    /* 45 */,
	19    /* 46 */,
	19    /* 47 */,
	20    /* 48 */,
	20    /* 49 */,
	21    /* 50 */,
	21    /* 51 */,
	22    /* 52 */,
	22    /* 53 */,
	23    /* 54 */,
	23    /* 55 */,
	24    /* 56 */,
	24    /* 57 */,
	25    /* 58 */,
	25    /* 59 */,
	25    /* 60 */,
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
s16b adj_str_to_hit[STAT_TABLE_SIZE] =
{
	-3    /* 3 */,
	-2    /* 4 */,
	-1    /* 5 */,
	-1    /* 6 */,
	0     /* 7 */,
	0     /* 8 */,
	0     /* 9 */,
	0     /* 10 */,
	0     /* 11 */,
	0     /* 12 */,
	0     /* 13 */,
	0     /* 14 */,
	0     /* 15 */,
	0     /* 16 */,
	0     /* 17 */,
	1     /* 18 */,
	1     /* 19 */,
	1     /* 20 */,
	1     /* 21 */,
	1     /* 22 */,
	1     /* 23 */,
	1     /* 24 */,
	2     /* 25 */,
	3     /* 26 */,
	4     /* 27 */,
	5     /* 28 */,
	6     /* 29 */,
	7     /* 30 */,
	8     /* 31 */,
	9     /* 32 */,
	10    /* 33 */,
	11    /* 34 */,
	12    /* 35 */,
	13    /* 36 */,
	14    /* 37 */,
	15    /* 38 */,
	15    /* 39 */,
	16    /* 40 */,
	16    /* 41 */,
	16    /* 42 */,
	16    /* 43 */,
	16    /* 44 */,
	17    /* 45 */,
	17    /* 46 */,
	17    /* 47 */,
	17    /* 48 */,
	18    /* 49 */,
	18    /* 50 */,
	18    /* 51 */,
	18    /* 52 */,
	19    /* 53 */,
	19    /* 54 */,
	19    /* 55 */,
	19    /* 56 */,
	20    /* 57 */,
	20    /* 58 */,
	20    /* 59 */,
	20    /* 60 */,
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_carrying_weight[STAT_TABLE_SIZE] =
{
	10      /* 3 */,
	11      /* 4 */,
	12      /* 5 */,
	13      /* 6 */,
	14      /* 7 */,
	15      /* 8 */,
	16      /* 9 */,
	17      /* 10 */,
	18      /* 11 */,
	19      /* 12 */,
	20      /* 13 */,
	21      /* 14 */,
	22      /* 15 */,
	23      /* 16 */,
	24      /* 17 */,
	25      /* 18 */,
	26      /* 19 */,
	27      /* 20 */,
	28      /* 21 */,
	29      /* 22 */,
	30      /* 23 */,
	31      /* 24 */,
	31      /* 25 */,
	32      /* 26 */,
	32      /* 27 */,
	33      /* 28 */,
	33      /* 29 */,
	34      /* 30 */,
	34      /* 31 */,
	35      /* 32 */,
	35      /* 33 */,
	36      /* 34 */,
	36      /* 35 */,
	37      /* 36 */,
	37      /* 37 */,
	38      /* 38 */,
	38      /* 39 */,
	39      /* 40 */,
	39      /* 41 */,
	40      /* 42 */,
	40      /* 43 */,
	41      /* 44 */,
	41      /* 45 */,
	42      /* 46 */,
	42      /* 47 */,
	43      /* 48 */,
	43      /* 49 */,
	44      /* 50 */,
	44      /* 51 */,
	45      /* 52 */,
	45      /* 53 */,
	46      /* 54 */,
	46      /* 55 */,
	47      /* 56 */,
	47      /* 57 */,
	48      /* 58 */,
	49      /* 59 */,
	50      /* 60 */,
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_equipping_weight[STAT_TABLE_SIZE] =
{
	4      /* 3 */,
	5      /* 4 */,
	6      /* 5 */,
	7      /* 6 */,
	8      /* 7 */,
	9      /* 8 */,
	10     /* 9 */,
	11     /* 10 */,
	12     /* 11 */,
	13     /* 12 */,
	14     /* 13 */,
	15     /* 14 */,
	16     /* 15 */,
	17     /* 16 */,
	18     /* 17 */,
	19     /* 18 */,
	20     /* 19 */,
	21     /* 20 */,
	22     /* 21 */,
	23     /* 22 */,
	24     /* 23 */,
	25     /* 24 */,
	26     /* 25 */,
	27     /* 26 */,
	28     /* 27 */,
	30     /* 28 */,
	31     /* 29 */,
	32     /* 30 */,
	33     /* 31 */,
	34     /* 32 */,
	35     /* 33 */,
	37     /* 34 */,
	40     /* 35 */,
	44     /* 36 */,
	48     /* 37 */,
	50     /* 38 */,
	52     /* 39 */,
	54     /* 40 */,
	55     /* 41 */,
	56     /* 42 */,
	57     /* 43 */,
	58     /* 44 */,
	59     /* 45 */,
	60     /* 46 */,
	61     /* 47 */,
	62     /* 48 */,
	63     /* 49 */,
	64     /* 50 */,
	65     /* 51 */,
	66     /* 52 */,
	67     /* 53 */,
	68     /* 54 */,
	69     /* 55 */,
	70     /* 56 */,
	71     /* 57 */,
	72     /* 58 */,
	73     /* 59 */,
	74     /* 60 */,
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[STAT_TABLE_SIZE] =
{
	0      /* 3 */, 
	0      /* 4 */, 
	1      /* 5 */, 
	2      /* 6 */, 
	3      /* 7 */, 
	4      /* 8 */, 
	4      /* 9 */, 
	5      /* 10 */, 
	5      /* 11 */, 
	6      /* 12 */, 
	6      /* 13 */, 
	7      /* 14 */, 
	7      /* 15 */, 
	8      /* 16 */, 
	8      /* 17 */, 
	9      /* 18 */, 
	10     /* 19 */, 
	12     /* 20 */, 
	15     /* 21 */, 
	20     /* 22 */, 
	25     /* 23 */, 
	30     /* 24 */, 
	35     /* 25 */, 
	40     /* 26 */, 
	45     /* 27 */, 
	50     /* 28 */, 
	55     /* 29 */, 
	60     /* 30 */, 
	65     /* 31 */, 
	70     /* 32 */, 
	75     /* 33 */, 
	80     /* 34 */, 
	85     /* 35 */, 
	90     /* 36 */, 
	95     /* 37 */, 
	100    /* 38 */, 
	100    /* 39 */, 
	100    /* 40 */, 
	100    /* 41 */, 
	100    /* 42 */, 
	100    /* 43 */, 
	100    /* 44 */, 
	100    /* 45 */, 
	100    /* 46 */, 
	100    /* 47 */, 
	100    /* 48 */, 
	100    /* 49 */, 
	100    /* 50 */, 
	100    /* 51 */, 
	100    /* 52 */, 
	100    /* 53 */, 
	100    /* 54 */, 
	100    /* 55 */, 
	100    /* 56 */, 
	100    /* 57 */, 
	100    /* 58 */, 
	100    /* 59 */, 
	100    /* 60 */, 
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[STAT_TABLE_SIZE] =
{
	3     /* 3 */, 
	4     /* 4 */, 
	5     /* 5 */, 
	6     /* 6 */, 
	7     /* 7 */, 
	8     /* 8 */, 
	9     /* 9 */, 
	10    /* 10 */, 
	11    /* 11 */, 
	12    /* 12 */, 
	13    /* 13 */, 
	14    /* 14 */, 
	15    /* 15 */, 
	16    /* 16 */, 
	17    /* 17 */, 
	20    /* 18 */, 
	30    /* 19 */, 
	40    /* 20 */, 
	50    /* 21 */, 
	60    /* 22 */, 
	70    /* 23 */, 
	80    /* 24 */, 
	90    /* 25 */, 
	100   /* 26 */, 
	110   /* 27 */, 
	120   /* 28 */, 
	130   /* 29 */, 
	140   /* 30 */, 
	150   /* 31 */, 
	160   /* 32 */, 
	170   /* 33 */, 
	180   /* 34 */, 
	190   /* 35 */, 
	200   /* 36 */, 
	210   /* 37 */, 
	220   /* 38 */, 
	230   /* 39 */, 
	240   /* 40 */, 
	240   /* 41 */, 
	240   /* 42 */, 
	240   /* 43 */, 
	240   /* 44 */, 
	240   /* 45 */, 
	240   /* 46 */, 
	240   /* 47 */, 
	240   /* 48 */, 
	240   /* 49 */, 
	240   /* 50 */, 
	240   /* 51 */, 
	240   /* 52 */, 
	240   /* 53 */, 
	240   /* 54 */, 
	240   /* 55 */, 
	240   /* 56 */, 
	240   /* 57 */, 
	240   /* 58 */, 
	240   /* 59 */, 
	240   /* 60 */, 
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[STAT_TABLE_SIZE] =
{
	0      /* 3 */, 
	0      /* 4 */, 
	0      /* 5 */, 
	0      /* 6 */, 
	0      /* 7 */, 
	0      /* 8 */, 
	0      /* 9 */, 
	1      /* 10 */, 
	1      /* 11 */, 
	1      /* 12 */, 
	1      /* 13 */, 
	1      /* 14 */, 
	2      /* 15 */, 
	2      /* 16 */, 
	2      /* 17 */, 
	2      /* 18 */, 
	3      /* 19 */, 
	3      /* 20 */, 
	3      /* 21 */, 
	4      /* 22 */, 
	4      /* 23 */, 
	5      /* 24 */, 
	5      /* 25 */, 
	6      /* 26 */, 
	6      /* 27 */, 
	7      /* 28 */, 
	7      /* 29 */, 
	8      /* 30 */, 
	8      /* 31 */, 
	9      /* 32 */, 
	9      /* 33 */, 
	10     /* 34 */, 
	10     /* 35 */, 
	11     /* 36 */, 
	11     /* 37 */, 
	12     /* 38 */, 
	12     /* 39 */, 
	13     /* 40 */, 
	13     /* 41 */, 
	13     /* 42 */, 
	13     /* 43 */, 
	13     /* 44 */, 
	13     /* 45 */, 
	13     /* 46 */, 
	13     /* 47 */, 
	13     /* 48 */, 
	13     /* 49 */, 
	13     /* 50 */, 
	13     /* 51 */, 
	13     /* 52 */, 
	13     /* 53 */, 
	13     /* 54 */, 
	13     /* 55 */, 
	13     /* 56 */, 
	13     /* 57 */, 
	13     /* 58 */, 
	13     /* 59 */, 
	13     /* 60 */, 
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[STAT_TABLE_SIZE] =
{
	0       /* 3 */, 
	1       /* 4 */, 
	2       /* 5 */, 
	3       /* 6 */, 
	4       /* 7 */, 
	5       /* 8 */, 
	5       /* 9 */, 
	6       /* 10 */, 
	6       /* 11 */, 
	7       /* 12 */, 
	7       /* 13 */, 
	8       /* 14 */, 
	8       /* 15 */, 
	9       /* 16 */, 
	9       /* 17 */, 
	10      /* 18 */, 
	10      /* 19 */, 
	15      /* 20 */, 
	15      /* 21 */, 
	20      /* 22 */, 
	25      /* 23 */, 
	30      /* 24 */, 
	35      /* 25 */, 
	40      /* 26 */, 
	45      /* 27 */, 
	50      /* 28 */, 
	60      /* 29 */, 
	70      /* 30 */, 
	80      /* 31 */, 
	90      /* 32 */, 
	100     /* 33 */, 
	100     /* 34 */, 
	100     /* 35 */, 
	100     /* 36 */, 
	100     /* 37 */, 
	100     /* 38 */, 
	100     /* 39 */, 
	100     /* 40 */, 
	100     /* 41 */, 
	100     /* 42 */, 
	100     /* 43 */, 
	100     /* 44 */, 
	100     /* 45 */, 
	100     /* 46 */, 
	100     /* 47 */, 
	100     /* 48 */, 
	100     /* 49 */, 
	100     /* 50 */, 
	100     /* 51 */, 
	100     /* 52 */, 
	100     /* 53 */, 
	100     /* 54 */, 
	100     /* 55 */, 
	100     /* 56 */, 
	100     /* 57 */, 
	100     /* 58 */, 
	100     /* 59 */, 
	100     /* 60 */, 
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[STAT_TABLE_SIZE] =
{
	0       /* 3 */, 
	0       /* 4 */, 
	0       /* 5 */, 
	0       /* 6 */, 
	0       /* 7 */, 
	0       /* 8 */, 
	0       /* 9 */, 
	0       /* 10 */, 
	0       /* 11 */, 
	0       /* 12 */, 
	0       /* 13 */, 
	1       /* 14 */, 
	1       /* 15 */, 
	1       /* 16 */, 
	1       /* 17 */, 
	2       /* 18 */, 
	2       /* 19 */, 
	2       /* 20 */, 
	2       /* 21 */, 
	2       /* 22 */, 
	3       /* 23 */, 
	3       /* 24 */, 
	3       /* 25 */, 
	3       /* 26 */, 
	3       /* 27 */, 
	4       /* 28 */, 
	4       /* 29 */, 
	5       /* 30 */, 
	6       /* 31 */, 
	6       /* 32 */, 
	7       /* 33 */, 
	7       /* 34 */, 
	8       /* 35 */, 
	8       /* 36 */, 
	8       /* 37 */, 
	9       /* 38 */, 
	9       /* 39 */, 
	9       /* 40 */, 
	9       /* 41 */, 
	9       /* 42 */, 
	9       /* 43 */, 
	9       /* 44 */, 
	9       /* 45 */, 
	9       /* 46 */, 
	9       /* 47 */, 
	9       /* 48 */, 
	9       /* 49 */, 
	9       /* 50 */, 
	9       /* 51 */, 
	9       /* 52 */, 
	9       /* 53 */, 
	9       /* 54 */, 
	9       /* 55 */, 
	9       /* 56 */, 
	9       /* 57 */, 
	9       /* 58 */, 
	9       /* 59 */, 
	9       /* 60 */, 
};


/*
 * Stat Table (CON) -- extra 1/4-hitpoints per level (plus 128)
 */
s16b adj_con_mhp[STAT_TABLE_SIZE] =
{
	-16 /* 3.0 */,
	-14 /* 4.0 */,
	-12 /* 5.0 */,
	-10/* 6.0 */,
	-8 /* 7.0 */,
	-6 /* 8.0 */,
	-4 /* 9.0 */,
	-2 /* 10.0 */,
	0 /* 11.0 */,
	0 /* 12.0 */,
	0 /* 13.0 */,
	1 /* 14.0 */,
	1 /* 15.0 */,
	2 /* 16.0 */,
	3 /* 17.0 */,
	4 /* 18.0 */,
	5 /* 19.0 */,
	6 /* 20.0 */,
	7 /* 21.0 */,
	8 /* 22.0 */,
	9 /* 23.0 */,
	10 /* 24.0 */,
	11 /* 25.0 */,
	12 /* 26.0 */,
	13 /* 27.0 */,
	14 /* 28.0 */,
	15 /* 29.0 */,
	17 /* 30.0 */,
	19 /* 31.0 */,
	21 /* 32.0 */,
	23 /* 33.0 */,
	25 /* 34.0 */,
	27 /* 35.0 */,
	29 /* 36.0 */,
	31 /* 37.0 */,
	33 /* 38.0 */,
	35 /* 39.0 */,
	37 /* 40.0 */,
	39 /* 41.0 */,
	42 /* 42.0 */,
	45 /* 43.0 */,
	48 /* 44.0 */,
	51 /* 45.0 */,
	54 /* 46.0 */,
	57 /* 47.0 */,
	60 /* 48.0 */,
	63 /* 49.0 */,
	66 /* 50.0 */,
	69 /* 51.0 */,
	72 /* 52.0 */,
	75 /* 53.0 */,
	78 /* 54.0 */,
	81 /* 55.0 */,
	85 /* 56.0 */,
	89 /* 57.0 */,
	94 /* 58.0 */,
	99 /* 59.0 */,
	104 /* 60.0 */
};

/*
 * Stat Table (DR) -- plus maximum of hit dices)
 */
int adj_dr_mhp[DR_TABLE_SIZE] =
{
	1, /* 0 */

	2,
	2,
	3,
	3,
	4, /* 5 */

	8,
	9,
	10,
	11,
	12, /* 10 */

	17,
	18,
	19,
	20,
	21, /* 15 */

	26,
	27,
	28,
	29,
	30, /* 20 */

	41,
	42,
	43,
	44,
	45, /* 25 */

	61,
	62,
	63,
	64,
	65, /* 30 */

};


/*
 * Stat Table (DR) -- plus saving)
 */
int adj_dr_saving[DR_TABLE_SIZE] =
{
	5, /* 0 */

	10,
	11,
	12,
	13,
	15, /* 5 */

	20,
	21,
	22,
	23,
	25, /* 10 */

	30,
	31,
	32,
	33,
	35, /* 15 */

	40,
	41,
	42,
	43,
	45, /* 20 */

	50,
	52,
	54,
	56,
	60, /* 25 */

	80,
	82,
	84,
	86,
	100, /* 30 */

};

/*
 * Stat Table (DR) -- plus speed)
 */
int adj_dr_speed[DR_TABLE_SIZE] =
{
	0, /* 0 */

	2,
	2,
	2,
	2,
	3, /* 5 */

	4,
	4,
	4,
	4,
	5, /* 10 */

	6,
	6,
	7,
	7,
	8, /* 15 */

	10,
	11,
	12,
	13,
	14, /* 20 */

	17,
	18,
	19,
	20,
	21, /* 25 */

	25,
	26,
	27,
	28,
	30, /* 30 */

};


/*
 * Stat Table (DR) -- plus AC)
 */
int adj_dr_ac[DR_TABLE_SIZE] =
{
	10, /* 0 */

	12,
	14,
	16,
	18,
	20, /* 5 */

	32,
	34,
	36,
	38,
	40, /* 10 */

	52,
	54,
	56,
	58,
	60, /* 15 */

	72,
	74,
	76,
	78,
	80, /* 20 */

	92,
	94,
	96,
	98,
	100, /* 25 */

	120,
	130,
	140,
	150,
	160, /* 30 */

};



/*
 * Stat Table (CHR) -- charm
 */
byte adj_chr_chm[STAT_TABLE_SIZE] =
{
	0      /* 3 */, 
	0      /* 4 */, 
	1      /* 5 */, 
	2      /* 6 */, 
	3      /* 7 */, 
	4      /* 8 */, 
	4      /* 9 */, 
	5      /* 10 */, 
	5      /* 11 */, 
	6      /* 12 */, 
	6      /* 13 */, 
	7      /* 14 */, 
	7      /* 15 */, 
	8      /* 16 */, 
	8      /* 17 */, 
	9      /* 18 */, 
	10     /* 19 */, 
	12     /* 20 */, 
	15     /* 21 */, 
	18     /* 22 */, 
	21     /* 23 */, 
	24     /* 24 */, 
	28     /* 25 */, 
	32     /* 26 */, 
	36     /* 27 */, 
	39     /* 28 */, 
	42     /* 29 */, 
	45     /* 30 */, 
	49     /* 31 */, 
	53     /* 32 */, 
	57     /* 33 */, 
	61     /* 34 */, 
	65     /* 35 */, 
	69     /* 36 */, 
	73     /* 37 */, 
	77     /* 38 */, 
	81     /* 39 */, 
	85     /* 40 */, 
	85     /* 41 */, 
	85     /* 42 */, 
	85     /* 43 */, 
	85     /* 44 */, 
	85     /* 45 */, 
	85     /* 46 */, 
	85     /* 47 */, 
	85     /* 48 */, 
	85     /* 49 */, 
	85     /* 50 */, 
	85     /* 51 */, 
	85     /* 52 */, 
	85     /* 53 */, 
	85     /* 54 */, 
	85     /* 55 */, 
	85     /* 56 */, 
	85     /* 57 */, 
	85     /* 58 */, 
	85     /* 59 */, 
	85     /* 60 */, 
};

arena_type arena_info[MAX_ARENA_MONS + 2] =
{
	{ SPECIES_NOBORTA, 0, 0                             },
	{ SPECIES_MORI_TROLL, 0, 0                             },
	{ SPECIES_LION_HEART, 0, 0                             },
	{ SPECIES_TIGER, 0, 0                             },
	{ SPECIES_DRUID, 0, 0                             },
	{ SPECIES_HILL_GIANT, TV_POTION, SV_POTION_SPEED               },
	{ SPECIES_WERERAT, 0, 0                             },
	{ SPECIES_ORC_CAPTAIN, 0, 0                             },
	{ SPECIES_BERSERKER, 0, 0                             },
	{ SPECIES_STONE_GIANT, 0, 0                             },
	{ SPECIES_D_ELF_LORD, TV_POTION, SV_POTION_HEALING             },
	{ SPECIES_IRON_GOLEM, 0, 0                             },
	{ SPECIES_C_CRAWLER, 0, 0                             },
	{ SPECIES_XICLOTLAN, 0, 0                             },
	{ SPECIES_TROLL_PRIEST, 0, 0                             },
	{ SPECIES_ANGEL, TV_ROD, SV_ROD_STONE_TO_MUD           },
	{ SPECIES_SPIRIT_NAGA, 0, 0                             },
	{ SPECIES_BASILISK, 0, 0                             },
	{ SPECIES_MITHRIL_GOLEM, 0, 0                             },
	{ SPECIES_SHADOW_DRAKE, 0, 0                             },
	{ SPECIES_OGRE_SHAMAN, TV_SCROLL, SV_SCROLL_ACQUIREMENT         },
	{ SPECIES_BICLOPS, 0, 0                             },
	{ SPECIES_ETHER_DRAKE, TV_SCROLL, SV_SCROLL_RUNE_OF_PROTECTION  },
	{ SPECIES_HALFLING_S, 0, 0                             },
	{ SPECIES_ELDER_THING, TV_ROD, SV_ROD_DRAIN_LIFE             },
	{ SPECIES_M_MH_DRAGON, 0, 0                             },
	{ SPECIES_ETTIN, TV_SCROLL, SV_SCROLL_STAR_ENCHANT_WEAPON },
	{ SPECIES_VAMPIRE_LORD, 0, 0                             },
	{ SPECIES_BARNEY, TV_SCROLL, SV_SCROLL_GENOCIDE            },
	{ SPECIES_GROO, 0, 0                             },
	{ SPECIES_D_ELF_SORC, TV_WAND, SV_WAND_STRIKING              },
	{ SPECIES_IRON_LICH, 0, 0                             },
	{ SPECIES_G_TITAN, TV_POTION, SV_POTION_STAR_ENLIGHTENMENT  },
	{ SPECIES_G_BALROG, 0, 0                             },
	{ SPECIES_NIGHTWALKER, TV_ROD, SV_ROD_IDENTIFY               },
	{ SPECIES_SHAMBLER, TV_STAFF, SV_STAFF_HOLINESS             },
	{ SPECIES_BLACK_REAVER, TV_SCROLL, SV_SCROLL_STAR_ACQUIREMENT    },
	{ SPECIES_FENGHUANG, TV_STAFF, SV_STAFF_THE_MAGI             },
	{ SPECIES_WYRM_POWER, TV_ROD, SV_ROD_HEALING                },
	{ 0,   0, 0                             }, /* Victory prizing */
	{ SPECIES_HAGURE, TV_SCROLL, SV_SCROLL_ARTIFACT            },
};


/*
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest creature is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* S-50 */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* S-40 */     2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	/* S-30 */     2, 2, 2, 2, 2, 2, 2, 3, 3, 3,
	/* S-20 */     3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
	/* S-10 */     5, 5, 5, 5, 6, 6, 7, 7, 8, 9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
	/* F+30 */    40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	/* F+40 */    50, 52, 54, 56, 58, 60, 62, 64, 66, 68,
	/* F+50 */    70, 73, 76, 79, 82, 85, 88, 91, 94, 97,
	/* F+60 */    100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	/* F+70 */    100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
	/* Fast */    100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
};




/*
 * Base experience levels, may be adjusted up for race and/or class
 */

s32b creature_exp[PY_MAX_LEVEL] =
{
//  EXP         // Unique Standard
//  0			// Lv1 - 1F
	20,			// Lv2 - 2F
	45,			// Lv3 - 3F
	75,			// Lv4 - 4F
	100,		// Lv5 - 5F
	130,		// Lv6 - 6F
	180,		// Lv7 - 7F
	260,		// Lv8 - 8F
	360,		// Lv9 - 9F
	480,		// Lv10 - 10F
	630,		// Lv11 - 12F
	880,		// Lv12 - 14F
	1280,		// Lv13 - 16F
	1700,		// Lv14 - 18F
	2200,		// Lv15 - 20F
	2800,		// Lv16 - 22F
	3600,		// Lv17 - 24F
	4600,		// Lv18 - 26F
	5800,		// Lv19 - 28F
	7200,		// Lv20 - 30F
	8800,		// Lv21 - 32F
	10600,		// Lv22 - 34F
	12600,		// Lv23 - 36F
	15000,		// Lv24 - 38F
	18000,		// Lv25 - 40F
	22000,		// Lv26 - 42F
	27000,		// Lv27 - 44F
	35000L,		// Lv28 - 46F
	50000L,		// Lv29 - 48F
	75000L,		// Lv30 - 50F
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L, // Lv40
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3300000L,
	3600000L,
	3900000L, // Lv50
	4300000L,
	4700000L,
	5100000L,
	5500000L,
	6000000L,
	6500000L,
	7000000L,
	7500000L,
	8000000L,
	8500000L, // Lv60
	9000000L
};


s32b creature_exp_a[PY_MAX_LEVEL] =
{
	20,
	50,
	100,
	170,
	280,
	430,
	650,
	950,
	1400,/*10*/
	1850,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10400,
	12500,/*20*/
	17500,
	25000,
	35000,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,/*30*/
	450000L,
	550000L,
	650000L,
	800000L,
	950000L,
	1100000L,
	1250000L,
	1400000L,
	1550000L,
	1700000L,/*40*/
	1900000L,
	2100000L,
	2300000L,
	2550000L,
	2800000L,
	3050000L,
	3300000L,
	3700000L,
	4100000L,
	4500000L,/*50*/
	5000000L,
	5500000L,
	6000000L,
	6500000L,
	7000000L,
	7500000L,
	8000000L,
	8500000L,
	9000000L,
	9500000L,/*60*/
	10000000L,
};


/*
 * Player Sexes
 *
 *      Title,
 *      Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
#ifdef JP
		"",
		"[h",
#endif
		"None",
		"Lord"
	},
	{
#ifdef JP
		"",
		"NC[",
#endif
		"Female",
		"Queen"
	},
	{
#ifdef JP
		"j",
		"LO",
#endif
		"Male",
		"King"
	},
	{
#ifdef JP
		"",
		"[h",
#endif
		"InterSex",
		"Lord"
	},
};

magic_type technic_info[NUM_TECHNIC][32] =
{
	{
		/* Music */
		{ 1, 1, 10, 2},
		{ 2, 1, 10, 2},
		{ 3, 2, 20, 3},
		{ 4, 2, 20, 4},
		{ 5, 2, 20, 6},
		{ 7, 4, 30, 8},
		{ 9, 3, 30, 10},
		{ 10, 2, 30, 12},

		{ 12, 3, 40, 20},
		{ 15, 16, 42, 35},
		{ 17, 18, 40, 25},
		{ 18, 2, 45, 30},
		{ 23, 8, 50, 38},
		{ 28, 30, 50, 41},
		{ 33, 35, 60, 42},
		{ 38, 35, 70, 46},

		{ 10, 4, 20, 13},
		{ 22, 5, 30, 26},
		{ 23, 3, 35, 27},
		{ 26, 28, 37, 29},
		{ 32, 37, 41, 36},
		{ 33, 22, 43, 40},
		{ 37, 35, 46, 42},
		{ 45, 60, 50, 56},

		{ 23, 18, 20, 23},
		{ 30, 30, 30, 26},
		{ 33, 65, 41, 30},
		{ 37, 35, 43, 35},
		{ 40, 30, 46, 50},
		{ 42, 75, 50, 68},
		{ 45, 58, 62, 73},
		{ 49, 48, 70, 200}
	},

	{
		/* Hissatsu */
		{ 1, 15, 0, 0},
		{ 3, 10, 0, 0},
		{ 6, 15, 0, 0},
		{ 9, 8, 0, 0},
		{ 10, 12, 0, 0},
		{ 12, 25, 0, 0},
		{ 14, 7, 0, 0},
		{ 17, 20, 0, 0},

		{ 19, 10, 0, 0},
		{ 22, 20, 0, 0},
		{ 24, 30, 0, 0},
		{ 25, 10, 0, 0},
		{ 27, 15, 0, 0},
		{ 29, 45, 0, 0},
		{ 32, 70, 0, 0},
		{ 35, 50, 0, 0},

		{ 18, 40, 0, 0},
		{ 22, 22, 0, 0},
		{ 24, 30, 0, 0},
		{ 26, 35, 0, 0},
		{ 30, 30, 0, 0},
		{ 32, 60, 0, 0},
		{ 36, 40, 0, 0},
		{ 39, 80, 0, 0},

		{ 26, 20, 0, 0},
		{ 29, 40, 0, 0},
		{ 31, 35, 0, 0},
		{ 36, 80, 0, 0},
		{ 39, 100, 0, 0},
		{ 42, 110, 0, 0},
		{ 45, 130, 0, 0},
		{ 50, 255, 0, 0}
	},

	{
		/* Hex */
		{  1, 2, 20, 2},
		{  1, 2, 20, 2},
		{  3, 2, 30, 3},
		{  5, 3, 30, 4},
		{  7, 3, 40, 6},
		{  8, 10, 60, 8},
		{  9, 3, 30, 10},
		{ 10, 5, 40, 12},

		{ 12, 8, 40, 15},
		{ 12, 9, 35, 15},
		{ 15, 10, 50, 20},
		{ 20, 12, 45, 35},
		{ 25, 15, 50, 50},
		{ 30, 12, 60, 70},
		{ 35, 10, 60, 80},
		{ 40, 16, 70, 100},

		{ 15, 8, 20, 20},
		{ 18, 15, 50, 20},
		{ 22, 10, 65, 35},
		{ 25, 28, 70, 50},
		{ 28, 10, 70, 60},
		{ 30, 20, 60, 60},
		{ 36, 22, 70, 80},
		{ 40, 28, 70, 100},

		{  5, 6, 35, 5},
		{ 22, 24, 70, 40},
		{ 25, 2, 65, 50},
		{ 32, 20, 50, 70},
		{ 35, 35, 70, 80},
		{ 38, 32, 70, 90},
		{ 42, 24, 70, 120},
		{ 46, 45, 80, 200}
	},
};


/*
 * Zangband uses this array instead of the spell flags table, as there
 * are 5 realms of magic, each with 4 spellbooks and 8 spells per book -- TY
 */
u32b fake_spell_flags[4]=
{
	0x000000ff,
	0x0000ff00,
	0x00ff0000,
	0xff000000
};


s32b realm_choices1[MAX_CLASS] =
{
	(CH_NONE),				// None
	(CH_NONE),				/* Warrior */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                /* Mage */
	(CH_LIFE | CH_DEATH | CH_DAEMON |
	 CH_CRUSADE),                /* Priest */
	(CH_SORCERY | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT), /* Rogue */
	(CH_NATURE),              /* Ranger */
	(CH_CRUSADE | CH_DEATH),     /* Paladin */
	(CH_ARCANE),              /* Warrior-Mage */
	(CH_CHAOS | CH_DAEMON),   /* Chaos-Warrior */
	(CH_LIFE | CH_NATURE | CH_DEATH |
	 CH_ENCHANT),             /* Monk */
	(CH_NONE),                /* Mindcrafter */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE | CH_HEX),    /* High-Mage */
	(CH_ARCANE),              /* Tourist */
	(CH_NONE),                /* Imitator */
	(CH_TRUMP),               /* Beastmaster */
	(CH_NONE),                /* Sorcerer */
	(CH_NONE),                /* Archer */
	(CH_NONE),                /* Magic eater */
	(CH_MUSIC),               /* Bard */
	(CH_NONE),                /* Red Mage */
	(CH_HISSATSU),            /* Samurai */
	(CH_LIFE | CH_NATURE | CH_DEATH |
	 CH_ENCHANT | CH_CRUSADE),   /* ForceTrainer */
	(CH_NONE),                /* Blue Mage */
	(CH_NONE),				/* Cavalry */
	(CH_NONE),				/* Berserker */
	(CH_NONE),				/* Weaponsmith */
	(CH_NONE),				/* Mirror-master */
	(CH_NONE),				/* Ninja */
	(CH_NONE),				/* Sniper */
	(CH_NONE),				// Commoner
	(CH_NONE),				// Soldier
};


s32b realm_choices2[MAX_CLASS] =
{
	(CH_NONE),				// None
	(CH_NONE),                /* Warrior */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                /* Mage */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                /* Priest */
	(CH_NONE),                /* Rogue */
	(CH_SORCERY | CH_CHAOS | CH_DEATH |
	 CH_TRUMP | CH_ARCANE | CH_DAEMON), /* Ranger */
	(CH_NONE),                /* Paladin */
	(CH_LIFE | CH_NATURE | CH_CHAOS |
	 CH_DEATH | CH_TRUMP | CH_ARCANE |
	 CH_SORCERY | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                /* Warrior-Mage */
	(CH_NONE),                /* Chaos-Warrior */
	(CH_NONE),                /* Monk */
	(CH_NONE),                /* Mindcrafter */
	(CH_NONE),                /* High-Mage */
	(CH_NONE),                /* Tourist */
	(CH_NONE),                /* Imitator */
	(CH_NONE),                /* Beastmanster */
	(CH_NONE),                /* Sorcerer */
	(CH_NONE),                /* Archer */
	(CH_NONE),                /* Magic eater */
	(CH_NONE),                /* Bard */
	(CH_NONE),                /* Red Mage */
	(CH_NONE),                /* Samurai */
	(CH_NONE),                /* ForceTrainer */
	(CH_NONE),                /* Blue Mage */
	(CH_NONE),				/* Cavalry */
	(CH_NONE),				/* Berserker */
	(CH_NONE),				/* Weaponsmith */
	(CH_NONE),				/* Mirror-master */
	(CH_NONE),				/* Ninja */
	(CH_NONE),				/* Sniper */
	(CH_NONE),				// Commoner
	(CH_NONE),				// Soldier
};


#ifdef JP
cptr realm_names[] =
{
	"(Ȃ)",
	"",
	"p",
	"R",
	"JIX",
	"Í",
	"gv",
	"p",
	"",
	"",
	"j",
	"s",
	"s",
	"s",
	"s",
	"s",
	"",
	"|",
	"p",
	"s"
};
#endif

#ifdef JP
cptr E_realm_names[]
#else
cptr realm_names[]
#endif
= {
	"- none -",
	"Life",
	"Sorcery",
	"Nature",
	"Chaos",
	"Death",
	"Trump",
	"Arcane",
	"Craft",
	"Daemon",
	"Crusade",
	"unknown",
	"unknown",
	"unknown",
	"unknown",
	"unknown",
	"Music",
	"Kendo",
	"Hex",
	"unknown"
};


/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
int chest_traps[64] =
{
	0,                        /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),         /* 5 == best small wooden */
	0,
	(CHEST_ALARM),
	(CHEST_ALARM),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_SCATTER),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),   /* 15 == best large wooden */
	0,
	(CHEST_ALARM),
	(CHEST_SCATTER),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),          /* 25 == best small iron */
	0,
	(CHEST_E_SUMMON),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_BIRD_STORM),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON), /* 35 == best large iron */
	0,
	(CHEST_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_BIRD_STORM),
	(CHEST_EXPLODE | CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_H_SUMMON), /* 45 == best small steel */
	0,
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM | CHEST_ALARM),
	(CHEST_H_SUMMON | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_H_SUMMON | CHEST_SCATTER | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL | CHEST_EXPLODE), /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};

racial_power racial_powers[MAX_TRAITS] =
{
/* level, smana, %fail, manedam, %manefail, use_stat, name */
#ifdef JP
{  1, 1, 10, 0, 15, STAT_CON, ""},
{ 10, 4, 35, 89, 40, STAT_INT, ""},
{ 40, 35, 85, 0, 40, STAT_INT, "͏"},
{ 35, 30, 80, 800, 70, STAT_STR, "Pbg"},
{  5, 1, 20, 18, 15, STAT_DEX, "ˌ"},
{ 10, 4, 35, 89, 40, STAT_INT, ""},
{ 10, 4, 35, 89, 40, STAT_INT, ""},
{ 10, 4, 35, 89, 40, STAT_INT, ""},
{ 20, 15, 55, 1600, 95, STAT_CON, "_̃uX"},
{ 20, 15, 55, 1600, 95, STAT_CON, "d̃uX"},
{ 20, 15, 55, 1600, 95, STAT_CON, "̃uX"},
{ 20, 15, 55, 1600, 95, STAT_CON, "C̃uX"},
{ 20, 15, 55, 800, 95, STAT_CON, "ł̃uX"},
{ 20, 15, 70, 550, 95, STAT_CON, "ñuX"},
{ 20, 16, 70, 400, 95, STAT_CON, "M̃uX"},
{ 20, 16, 70, 400, 95, STAT_CON, "Í̃uX"},
{ 20, 20, 70, 450, 95, STAT_CON, "̃uX"},
{ 20, 20, 70, 450, 95, STAT_CON, "̃uX"},
{ 20, 20, 70, 600, 95, STAT_CON, "JIX̃uX"},
{ 20, 16, 70, 500, 95, STAT_CON, "򉻂̃uX"},
{ 30, 25, 80, 250, 95, STAT_CON, "ʍ̃uX"},
{ 35, 18, 80, 150, 95, STAT_CON, "ԋt]̃uX"},
{ 30, 25, 80, 200, 95, STAT_CON, "x݂̃uX"},
{ 30, 28, 90, 200, 95, STAT_CON, "d͂̃uX"},
{ 20, 15, 70, 500, 95, STAT_CON, "jЂ̃uX"},
{ 35, 15, 80, 150, 95, STAT_CON, "vY}̃uX"},
{ 30, 18, 70, 200, 95, STAT_CON, "tH[X̃uX"},
{ 30, 28, 80, 250, 95, STAT_CON, "͂̃uX"},
{ 25, 20, 95, 320, 80, STAT_INT, "˔\"},
{ 25, 15, 70, 800, 95, STAT_CON, "ːp̃uX"},
{ 30, 32, 85, 400, 80, STAT_INT, "OX"},
{ 35, 40, 95, 150, 95, STAT_CON, "̃uX"},
{ 18, 13, 55, 630, 80, STAT_INT, "AVbhE{["},
{ 14, 10, 45, 316, 60, STAT_INT, "T_[E{["},
{ 20, 14, 60, 720, 80, STAT_INT, "t@CAE{["},
{ 15, 11, 50, 320, 60, STAT_INT, "ACXE{["},
{  5, 3, 40, 48, 20, STAT_INT, "L_"},
{ 25, 18, 70, 350, 80, STAT_INT, "n"},
{ 30, 22, 75, 350, 80, STAT_INT, "EH[^[E{["},
{ 44, 45, 85, 550, 95, STAT_INT, "̗͂"},
{ 40, 42, 90, 550, 95, STAT_INT, "Í̗"},
{ 10, 5, 50, 0, 25, STAT_INT, "͋z"},
{ 25, 10, 60, 0, 30, STAT_INT, "_U"},
{ 30, 14, 65, 0, 30, STAT_INT, "]U"},
{  3, 1, 25, 24, 20, STAT_INT, "y"},
{ 12, 2, 35, 64, 25, STAT_INT, "d"},
{ 22, 6, 50, 150, 30, STAT_INT, "v"},
{ 32, 10, 70, 225, 35, STAT_INT, "E˂"},
{ 13, 7, 40, 178, 40, STAT_INT, "AVbhE{g"},
{ 10, 5, 35, 130, 35, STAT_INT, "T_[E{g"},
{ 15, 9, 50, 210, 45, STAT_INT, "t@CAE{g"},
{ 12, 6, 35, 162, 40, STAT_INT, "ACXE{g"},
{ 40, 42, 90, 550, 95, STAT_INT, "X^[Eo[Xg"},
{ 25, 17, 60, 255, 60, STAT_INT, "n̖"},
{ 25, 20, 65, 250, 60, STAT_INT, "EH[^[E{g"},
{ 25, 24, 90, 400, 80, STAT_INT, "̖͂"},
{ 25, 20, 80, 216, 60, STAT_INT, "vY}E{g"},
{ 25, 16, 60, 186, 60, STAT_INT, "Ɋ̖"},
{  3, 1, 25, 12, 20, STAT_INT, "}WbNE~TC"},
{  5, 3, 35, 0, 20, STAT_INT, "Q"},
{ 10, 5, 40, 0, 20, STAT_INT, "Ӗ"},
{ 10, 5, 40, 0, 20, STAT_INT, "pjbNEN[`["},
{ 10, 5, 40, 0, 20, STAT_INT, "XEEN[`["},
{ 10, 5, 40, 0, 20, STAT_INT, "X[vEN[`["},
{ 20, 10, 70, 0, 40, STAT_INT, "Xs[h"},
{ 45, 120, 95, 0, 60, STAT_INT, "jł̎"},
{ 20, 15, 70, 0, 20, STAT_WIS, "̗͉"},
{ 45, 65, 80, 0, 60, STAT_INT, "̋"},
{  5, 1, 30, 0, 20, STAT_INT, "V[gEe|[g"},
{ 15, 8, 40, 0, 30, STAT_INT, "e|[g"},
{ 40, 999, 99, 0, 80, STAT_INT, "UE[h"},
{  1, 0, 0, 0, 15, STAT_INT, ""},
{ 15, 8, 50, 0, 30, STAT_INT, "悹"},
{ 20, 13, 80, 0, 30, STAT_INT, "e|[gEAEFC"},
{ 30, 40, 95, 0, 40, STAT_INT, "e|[gEx"},
{ 35, 30, 80, 350, 70, STAT_INT, "̌"},
{  5, 1, 20, 0, 15, STAT_INT, "È"},
{  5, 1, 20, 0, 15, STAT_DEX, "gbvn"},
{ 15, 3, 40, 0, 30, STAT_INT, "Lr"},
{ 30, 30, 70, 0, 40, STAT_INT, "ҕ"},
{ 40, 70, 85, 0, 45, STAT_INT, "RĂ"},
{ 45, 90, 90, 0, 50, STAT_INT, "TCo[f[̏"},
{ 25, 20, 65, 0, 30, STAT_INT, "N[`[̏"},
{ 35, 30, 75, 0, 40, STAT_INT, "̃N[`[̏"},
{ 25, 25, 65, 0, 25, STAT_INT, "Ȁ"},
{ 25, 20, 60, 0, 25, STAT_INT, "w偂̏"},
{ 35, 26, 75, 0, 40, STAT_INT, "nEh̏"},
{ 30, 23, 70, 0, 35, STAT_INT, "qh̏"},
{ 40, 50, 85, 0, 40, STAT_INT, "Vg̏"},
{ 35, 50, 80, 0, 35, STAT_INT, "f[̏"},
{ 30, 30, 75, 0, 35, STAT_INT, "Afbh̏"},
{ 39, 70, 80, 0, 40, STAT_INT, "hS̏"},
{ 43, 85, 85, 0, 45, STAT_INT, "㋉Afbh̏"},
{ 46, 90, 85, 0, 45, STAT_INT, "ÑhS̏"},
{ 48, 120, 90, 0, 50, STAT_INT, "Ao[̉̏"},
{ 50, 150, 95, 0, 50, STAT_INT, "j[NN[`[̏"},
#else
{  1, 1, 10, 0, 15, STAT_CON, "shriek"},
{ 10, 4, 35, 89, 40, STAT_INT, "something"},
{ 40, 35, 85, 0, 40, STAT_INT, "dispel-magic"},
{ 35, 30, 80, 800, 70, STAT_STR, "rocket"},
{  2, 1, 15, 10, 15, STAT_DEX, "arrow"},
{  5, 2, 20, 18, 20, STAT_DEX, "arrows"},
{ 12, 3, 25, 30, 25, STAT_DEX, "missile"},
{ 16, 4, 30, 42, 30, STAT_DEX, "missiles"},
{ 20, 15, 55, 1600, 95, STAT_CON, "breath acid"},
{ 20, 15, 55, 1600, 95, STAT_CON, "breath lightning"},
{ 20, 15, 55, 1600, 95, STAT_CON, "breath fire"},
{ 20, 15, 55, 1600, 95, STAT_CON, "breath cold"},
{ 20, 15, 55, 800, 95, STAT_CON, "breath poison"},
{ 20, 15, 70, 550, 95, STAT_CON, "breath nether"},
{ 20, 16, 70, 400, 95, STAT_CON, "breath light"},
{ 20, 16, 70, 400, 95, STAT_CON, "breath dark"},
{ 20, 20, 70, 450, 95, STAT_CON, "breath confusion"},
{ 20, 20, 70, 450, 95, STAT_CON, "breath sound"},
{ 20, 20, 70, 600, 95, STAT_CON, "breath chaos"},
{ 20, 16, 70, 500, 95, STAT_CON, "breath disenchantment"},
{ 30, 25, 80, 250, 95, STAT_CON, "breath nexus"},
{ 35, 18, 80, 150, 95, STAT_CON, "breath time"},
{ 30, 25, 80, 200, 95, STAT_CON, "breath inertia"},
{ 30, 28, 90, 200, 95, STAT_CON, "breath gravity"},
{ 20, 15, 70, 500, 95, STAT_CON, "breath shards"},
{ 35, 15, 80, 150, 95, STAT_CON, "breath plasma"},
{ 30, 18, 70, 200, 95, STAT_CON, "breath force"},
{ 30, 28, 80, 250, 95, STAT_CON, "breath mana"},
{ 25, 20, 95, 320, 80, STAT_INT, "nuke ball"},
{ 25, 15, 70, 800, 95, STAT_CON, "breath nuke"},
{ 30, 32, 85, 400, 80, STAT_INT, "raw Logrus"},
{ 35, 40, 95, 150, 95, STAT_CON, "breath disintegrate"},
{ 18, 13, 55, 630, 80, STAT_INT, "acid ball"},
{ 14, 10, 45, 316, 60, STAT_INT, "lightning ball"},
{ 20, 14, 60, 720, 80, STAT_INT, "fire ball"},
{ 15, 11, 50, 320, 60, STAT_INT, "frost ball"},
{  5, 3, 40, 48, 20, STAT_INT, "stinking cloud"},
{ 25, 18, 70, 350, 80, STAT_INT, "nether ball"},
{ 30, 22, 75, 350, 80, STAT_INT, "water ball"},
{ 44, 45, 85, 550, 95, STAT_INT, "mana storm"},
{ 40, 42, 90, 550, 95, STAT_INT, "darkness storm"},
{ 10, 5, 50, 0, 25, STAT_INT, "drain mana"},
{ 25, 10, 60, 0, 30, STAT_INT, "mind blast"},
{ 30, 14, 65, 0, 30, STAT_INT, "brain smash"},
{  3, 1, 25, 24, 20, STAT_INT, "cause light wounds"},
{ 12, 2, 35, 64, 25, STAT_INT, "cause serious wounds"},
{ 22, 6, 50, 150, 30, STAT_INT, "cause critical wounds"},
{ 32, 10, 70, 225, 35, STAT_INT, "cause mortal wounds"},
{ 13, 7, 40, 178, 40, STAT_INT, "acid bolt"},
{ 10, 5, 35, 130, 35, STAT_INT, "lightning bolt"},
{ 15, 9, 50, 210, 45, STAT_INT, "fire bolt"},
{ 12, 6, 35, 162, 40, STAT_INT, "frost bolt"},
{ 40, 42, 90, 550, 95, STAT_INT, "starburst"},
{ 25, 17, 60, 255, 60, STAT_INT, "nether bolt"},
{ 25, 20, 65, 250, 60, STAT_INT, "water bolt"},
{ 25, 24, 90, 400, 80, STAT_INT, "mana bolt"},
{ 25, 20, 80, 216, 60, STAT_INT, "plasma bolt"},
{ 25, 16, 60, 186, 60, STAT_INT, "ice bolt"},
{  3, 1, 25, 12, 20, STAT_INT, "magic missile"},
{  5, 3, 35, 0, 20, STAT_INT, "scare"},
{ 10, 5, 40, 0, 20, STAT_INT, "blind"},
{ 10, 5, 40, 0, 20, STAT_INT, "confuse"},
{ 10, 5, 40, 0, 20, STAT_INT, "slow"},
{ 10, 5, 40, 0, 20, STAT_INT, "sleep"},
{ 20, 10, 70, 0, 40, STAT_INT, "speed"},
{ 45, 120, 95, 0, 60, STAT_INT, "the Hand of Doom"},
{ 20, 15, 70, 0, 20, STAT_WIS, "heal-self"},
{ 45, 65, 80, 0, 60, STAT_INT, "make invulnerable"},
{  5, 1, 30, 0, 20, STAT_INT, "blink-self"},
{ 15, 8, 40, 0, 30, STAT_INT, "teleport-self"},
{ 40, 999, 99, 0, 80, STAT_INT, "The world"},
{  1, 0, 0, 0, 15, STAT_INT, "something"},
{ 15, 8, 50, 0, 30, STAT_INT, "teleport to"},
{ 20, 13, 80, 0, 30, STAT_INT, "teleport away"},
{ 30, 40, 95, 0, 40, STAT_INT, "teleport level"},
{ 35, 30, 80, 350, 70, STAT_INT, "psycho-spear"},
{  5, 1, 20, 0, 15, STAT_INT, "create darkness"},
{  5, 1, 20, 0, 15, STAT_DEX, "create traps"},
{ 15, 3, 40, 0, 30, STAT_INT, "cause amnesia"},
{ 30, 30, 70, 0, 40, STAT_INT, "raise dead"},
{ 40, 70, 85, 0, 45, STAT_INT, "summon aid"},
{ 45, 90, 90, 0, 50, STAT_INT, "summon Cyberdemons"},
{ 25, 20, 65, 0, 30, STAT_INT, "summon a creature"},
{ 35, 30, 75, 0, 40, STAT_INT, "summon creatures"},
{ 25, 25, 65, 0, 25, STAT_INT, "summon ants"},
{ 25, 20, 60, 0, 25, STAT_INT, "summon spiders"},
{ 35, 26, 75, 0, 40, STAT_INT, "summon hounds"},
{ 30, 23, 70, 0, 35, STAT_INT, "summon hydras"},
{ 40, 50, 85, 0, 40, STAT_INT, "summon an angel"},
{ 35, 50, 80, 0, 35, STAT_INT, "summon a daemon"},
{ 30, 30, 75, 0, 35, STAT_INT, "summon an undead"},
{ 39, 70, 80, 0, 40, STAT_INT, "summon a dragon"},
{ 43, 85, 85, 0, 45, STAT_INT, "summon Greater Undead"},
{ 46, 90, 85, 0, 45, STAT_INT, "summon Ancient Dragon"},
{ 48, 120, 90, 0, 50, STAT_INT, "summon Lords of Amber"},
{ 50, 150, 95, 0, 50, STAT_INT, "summon Unique Creatures"},
#endif

};


/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr colospecies_names[16] =
{
#ifdef JP
	"",
	"",
	"DF",
	"IW",
	"",
	"",
	"",
	"ߐF",
	"DF",
	"DF",
	"",
	"",
	"邢",
	"邢",
	"邢",
	"ߐF",
#else
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
#endif

};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
#ifdef JP
	"r :", "m\ :", " :", "p :", "ϋv :", " :"
#else
	"STR : ", "INT : ", "WIS : ", "DEX : ", "CON : ", "CHR : "
#endif

};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
#ifdef JP
	"rx:", "m\x:", "x:", "px:", "ϋvx:", "x:"
#else
	"Str : ", "Int : ", "Wis : ", "Dex : ", "Con : ", "Chr : "
#endif

};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
cptr window_flag_desc[32] =
{
#ifdef JP
	"/ꗗ",
#else
	"Display inven/equip",
#endif

#ifdef JP
	"/ꗗ",
#else
	"Display equip/inven",
#endif

#ifdef JP
	"ꗗ",
#else
	"Display spell list",
#endif

#ifdef JP
	"LN^",
#else
	"Display character",
#endif

	NULL,
	NULL,
#ifdef JP
	"bZ[W",
#else
	"Display messages",
#endif

#ifdef JP
	"_WS̐}",
#else
	"Display overhead view",
#endif

#ifdef JP
	"N[`[̎vo",
#else
	"Display creature recall",
#endif

#ifdef JP
	"ACȅڍ",
#else
	"Display object recall",
#endif

#ifdef JP
	"̎͂\", 
#else
	"Display dungeon view",
#endif

#ifdef JP
	"LOBe",
#else
	"Display snap-shot",
#endif

	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 */
option_type option_info[] =
{
	/*** Input Options ***/

#ifdef JP
	{ &rogue_like_commands, FALSE, OPT_PAGE_INPUT, 0, 0,
	"rogue_like_commands", "[OL[zugp" },
#else
	{ &rogue_like_commands, FALSE, OPT_PAGE_INPUT, 0, 0,
	"rogue_like_commands", "Rogue-like commands" },
#endif

#ifdef JP
	{ &always_pickup, FALSE, OPT_PAGE_INPUT, 0, 5,
	"always_pickup",  "ɃACeE" },
#else
	{ &always_pickup, FALSE, OPT_PAGE_INPUT, 0, 5,
	"always_pickup",  "Pick things up by default" },
#endif

#ifdef JP
	{ &carry_query_flag, FALSE, OPT_PAGE_INPUT, 0, 3,
	"carry_query_flag", "ACeEOɊmF" },
#else
	{ &carry_query_flag, FALSE, OPT_PAGE_INPUT, 0, 3,
	"carry_query_flag", "Prompt before picking things up" },
#endif

#ifdef JP
	{ &quick_messages, TRUE, OPT_PAGE_INPUT, 0, 1,
	"quick_messages", "NCbNEbZ[Wgp" },
#else
	{ &quick_messages, TRUE, OPT_PAGE_INPUT, 0, 1,
	"quick_messages", "Activate quick messages" },
#endif

#ifdef JP
	{ &auto_more,     FALSE, OPT_PAGE_INPUT, 2, 6,
	"auto_more",      "L[҂ȂŘAŃbZ[W\" },
#else
	{ &auto_more,     FALSE, OPT_PAGE_INPUT, 2, 6,
	"auto_more",      "Automatically clear '-more-' prompts" },
#endif

#ifdef JP
	{ &command_menu,  TRUE, OPT_PAGE_INPUT, 2, 7,
	"command_menu",   "j[ɂR}hILɂ" },
#else
	{ &command_menu,  TRUE, OPT_PAGE_INPUT, 2, 7,
	"command_menu",   "Enable command selection menu" },
#endif

#ifdef JP
	{ &other_query_flag, FALSE, OPT_PAGE_INPUT, 0, 2,
	"other_query_flag", "̃ACegpƂɊmF" },
#else
	{ &other_query_flag, FALSE, OPT_PAGE_INPUT, 0, 2,
	"other_query_flag", "Prompt for floor item selection" },
#endif

#ifdef JP
	{ &use_old_target, FALSE, OPT_PAGE_INPUT, 0, 4,
	"use_old_target", "ɈȑÕ^[Qbgw肷" },
#else
	{ &use_old_target, FALSE, OPT_PAGE_INPUT, 0, 4,
	"use_old_target", "Use old target by default" },
#endif

#ifdef JP
	{ &always_repeat, TRUE, OPT_PAGE_INPUT, 0, 6,
	"always_repeat",  "R}hJԂ" },
#else
	{ &always_repeat, TRUE, OPT_PAGE_INPUT, 0, 6,
	"always_repeat",  "Repeat obvious commands" },
#endif

#ifdef JP
	{ &confirm_destroy, FALSE, OPT_PAGE_INPUT, 5, 3,
	"confirm_destroy", "ulvȃACej󂷂鎞mF" },
#else
	{ &confirm_destroy, FALSE, OPT_PAGE_INPUT, 5, 3,
	"confirm_destroy", "Prompt for destruction of known worthless items" },
#endif

#ifdef JP
	{ &confirm_wear,  TRUE, OPT_PAGE_INPUT, 5, 4,
	"confirm_wear",   "ꂽ𑕔鎞mF" },
#else
	{ &confirm_wear,  TRUE, OPT_PAGE_INPUT, 5, 4,
	"confirm_wear",   "Confirm to wear/wield known cursed items" },
#endif

#ifdef JP
	{ &confirm_quest, TRUE, OPT_PAGE_INPUT, 1, 9,
	"confirm_quest",  "NGXg߂ĊKiœOɊmF" },
#else
	{ &confirm_quest, TRUE, OPT_PAGE_INPUT, 1, 9,
	"confirm_quest",  "Prompt before exiting a quest level" },
#endif

#ifdef JP
	{ &target_pet,    FALSE, OPT_PAGE_INPUT, 2, 5,
	"target_pet",     "ybg^[Qbgɂ" },
#else
	{ &target_pet,    FALSE, OPT_PAGE_INPUT, 2, 5,
	"target_pet",     "Allow targetting pets" },
#endif

#ifdef JP
	{ &easy_open,     TRUE, OPT_PAGE_INPUT, 5, 7,
	"easy_open",      "IɃhAJ" },
#else
	{ &easy_open,     TRUE, OPT_PAGE_INPUT, 5, 7,
	"easy_open",      "Automatically open doors" },
#endif

#ifdef JP
	{ &easy_disarm,   TRUE, OPT_PAGE_INPUT, 5, 8,
	"easy_disarm",    "I㩂" },
#else
	{ &easy_disarm,   TRUE, OPT_PAGE_INPUT, 5, 8,
	"easy_disarm",    "Automatically disarm traps" },
#endif
#ifdef JP
	{ &easy_floor,    FALSE, OPT_PAGE_INPUT, 5, 9,
	"easy_floor",     "ŏdȂACeXg" },
#else
	{ &easy_floor,    FALSE, OPT_PAGE_INPUT, 5, 9,
	"easy_floor",     "Display floor stacks in a list" },
#endif

#ifdef JP
	{ &use_command,   FALSE, OPT_PAGE_INPUT, 5, 10,
	"use_command",    "ug(a)vR}hŃACełg" },
#else
	{ &use_command,   FALSE, OPT_PAGE_INPUT, 5, 10,
	"use_command",    "Allow unified use command" },
#endif

#ifdef JP
	{ &over_exert,    FALSE, OPT_PAGE_INPUT, 0, 29,
	"over_exert",     "MPȂĂ@ɒ킷" },
#else
	{ &over_exert,    FALSE, OPT_PAGE_INPUT, 0, 29,
	"over_exert",     "Allow casting spells when short of mana" },
#endif

#ifdef JP
	{ &numpad_as_cursorkey, TRUE, OPT_PAGE_INPUT, 2, 31,
	"numpad_as_cursorkey", "GfB^ŃeL[J[\L[ƂĎg" },
#else
	{ &numpad_as_cursorkey, TRUE, OPT_PAGE_INPUT, 2, 31,
	"numpad_as_cursorkey", "Use numpad keys as cursor keys in editor mode" },
#endif

	/*** Map Screen Options ***/

#ifdef JP
	{ &center_player, FALSE, OPT_PAGE_MAPSCREEN, 5, 11,
	"center_player",  "ɃvC[𒆐Sɒu(*x*)" },
#else
	{ &center_player, FALSE, OPT_PAGE_MAPSCREEN, 5, 11,
	"center_player",  "Center map while walking (*slow*)" },
#endif

#ifdef JP
	{ &center_running, TRUE, OPT_PAGE_MAPSCREEN, 5, 12,
	"center_running", "Ă鎞łSɒu" },
#else
	{ &center_running, TRUE, OPT_PAGE_MAPSCREEN, 5, 12,
	"center_running", "Centering even while running" },
#endif

#ifdef JP
	{ &view_yellow_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 28,
	"view_yellow_lite", "͈̔͂ʂȐFŕ\" },
#else
	{ &view_yellow_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 28,
	"view_yellow_lite", "Use special colors for torch-lit grids" },
#endif

#ifdef JP
	{ &view_bright_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 29,
	"view_bright_lite", "E͈̔͂ʂȐFŕ\" },
#else
	{ &view_bright_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 29,
	"view_bright_lite", "Use special colors for 'viewable' grids" },
#endif

#ifdef JP
	{ &view_granite_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 30,
	"view_granite_lite", "ǂʂȐFŕ\(d)" },
#else
	{ &view_granite_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 30,
	"view_granite_lite", "Use special colors for wall grids (slow)" },
#endif

#ifdef JP
	{ &view_special_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 31,
	"view_special_lite", "ʂȐFŕ\(d)" },
#else
	{ &view_special_lite, TRUE, OPT_PAGE_MAPSCREEN, 1, 31,
	"view_special_lite", "Use special colors for floor grids (slow)" },
#endif

#ifdef JP
	{ &view_perma_grids, TRUE, OPT_PAGE_MAPSCREEN, 1, 6,
	"view_perma_grids", "邢ꏊ͂̂܂܂ɂ" },
#else
	{ &view_perma_grids, TRUE, OPT_PAGE_MAPSCREEN, 1, 6,
	"view_perma_grids", "Map remembers all perma-lit grids" },
#endif

#ifdef JP
	{ &view_torch_grids, FALSE, OPT_PAGE_MAPSCREEN, 1, 7,
	"view_torch_grids", "ŏƂ炵ꏊ͂̂܂܂ɂ" },
#else
	{ &view_torch_grids, FALSE, OPT_PAGE_MAPSCREEN, 1, 7,
	"view_torch_grids", "Map remembers all torch-lit grids" },
#endif

#ifdef JP
	{ &view_unsafe_grids, FALSE, OPT_PAGE_MAPSCREEN, 1, 8,
	"view_unsafe_grids", "gbvmς݂łȂꏊ\" },
#else
	{ &view_unsafe_grids, FALSE, OPT_PAGE_MAPSCREEN, 1, 8,
	"view_unsafe_grids", "Map marked by detect traps" },
#endif

#ifdef JP
	{ &view_reduce_view, FALSE, OPT_PAGE_MAPSCREEN, 1, 17,
	"view_reduce_view", "Xł͎" },
#else
	{ &view_reduce_view, FALSE, OPT_PAGE_MAPSCREEN, 1, 17,
	"view_reduce_view", "Reduce view-radius in town" },
#endif

#ifdef JP
	{ &fresh_before,  TRUE, OPT_PAGE_MAPSCREEN, 1, 23,
	"fresh_before",   "AR}hɉʂĕ`悵" },
#else
	{ &fresh_before,  TRUE, OPT_PAGE_MAPSCREEN, 1, 23,
	"fresh_before",   "Flush output while continuous command" },
#endif

#ifdef JP
	{ &fresh_after,   FALSE, OPT_PAGE_MAPSCREEN, 1, 24,
	"fresh_after",    "R}hɉʂɍĕ`悵" },
#else
	{ &fresh_after,   FALSE, OPT_PAGE_MAPSCREEN, 1, 24,
	"fresh_after",    "Flush output after creature's move" },
#endif

#ifdef JP
	{ &fresh_message, FALSE, OPT_PAGE_MAPSCREEN, 1, 25,
	"fresh_message",  "bZ[W̌ɉʂĕ`悷" },
#else
	{ &fresh_message, FALSE, OPT_PAGE_MAPSCREEN, 1, 25,
	"fresh_message",  "Flush output after every message" },
#endif

#ifdef JP
	{ &hilite_player, FALSE, OPT_PAGE_MAPSCREEN, 1, 27,
	"hilite_player",  "vC[ɃJ[\킹" },
#else
	{ &hilite_player, FALSE, OPT_PAGE_MAPSCREEN, 1, 27,
	"hilite_player",  "Hilite the player with the cursor" },
#endif

#ifdef JP
	{ &display_path,  FALSE, OPT_PAGE_MAPSCREEN, 2, 8,
	"display_path",   "@̋OՂ\" },
#else
	{ &display_path,  FALSE, OPT_PAGE_MAPSCREEN, 2, 8,
	"display_path",   "Display actual path before shooting" },
#endif

	/*** Text Display Options ***/

#ifdef JP
	{ &plain_descriptions, TRUE, OPT_PAGE_TEXT, 5, 1,
	"plain_descriptions", "ACe̋Lqȗɂ" },
#else
	{ &plain_descriptions, TRUE, OPT_PAGE_TEXT, 5, 1,
	"plain_descriptions", "Plain object descriptions" },
#endif

#ifdef JP
	{ &plain_pickup,  FALSE, OPT_PAGE_TEXT, 6, 6,
	"plain_pickup",   "uEvbZ[Wȗ" },
#else
	{ &plain_pickup,  FALSE, OPT_PAGE_JAPANESE_ONLY, 6, 6,
	"plain_pickup",   "Plain pickup messages(japanese only)" },
#endif

#ifdef JP
	{ &always_show_list, TRUE, OPT_PAGE_TEXT, 4, 0,
	"always_show_list", "Iɂ͏Ɉꗗ\" },
#else
	{ &always_show_list, TRUE, OPT_PAGE_TEXT, 4, 0,
	"always_show_list", "Always show list when choosing items" },
#endif

#ifdef JP
	{ &depth_in_feet, FALSE, OPT_PAGE_TEXT, 0, 7,
	"depth_in_feet",  "_W̐[tB[gŕ\" },
#else
	{ &depth_in_feet, FALSE, OPT_PAGE_TEXT, 0, 7,
	"depth_in_feet",  "Show dungeon level in feet" },
#endif

#ifdef JP
	{ &show_labels,   TRUE, OPT_PAGE_TEXT, 0, 10,
	"show_labels",    "ꗗőꏊ\" },
#else
	{ &show_labels,   TRUE, OPT_PAGE_TEXT, 0, 10,
	"show_labels",    "Show labels in object listings" },
#endif

#ifdef JP
	{ &show_weights,  TRUE, OPT_PAGE_TEXT, 0, 11,
	"show_weights",   "ACeꗗŏdʂ\" },
#else
	{ &show_weights,  TRUE, OPT_PAGE_TEXT, 0, 11,
	"show_weights",   "Show weights in object listings" },
#endif

#ifdef JP
	{ &show_item_graph, TRUE, OPT_PAGE_TEXT, 2, 0,
	"show_item_graph", "ACẽV{\" },
#else
	{ &show_item_graph, TRUE, OPT_PAGE_TEXT, 2, 0,
	"show_item_graph", "Show items graphics" },
#endif

#ifdef JP
	{ &equippy_chars, TRUE, OPT_PAGE_TEXT, 1, 12,
	"equippy_chars",  "Xe[^Xɕő\" },
#else
	{ &equippy_chars, TRUE, OPT_PAGE_TEXT, 1, 12,
	"equippy_chars",  "Display 'equippy' chars" },
#endif

#ifdef JP
	{ &compress_savefile, FALSE, OPT_PAGE_TEXT, 1, 26,
	"compress_savefile", "Z[uEt@C̃bZ[Wk" },
#else
	{ &compress_savefile, FALSE, OPT_PAGE_TEXT, 1, 26,
	"compress_savefile", "Compress messages in savefiles" },
#endif

#ifdef JP
	{ &abbrev_extra,  FALSE, OPT_PAGE_TEXT, 2, 10,
	"abbrev_extra",   "ACeɒǉϐ/\̗͂̂" },
#else
	{ &abbrev_extra,  FALSE, OPT_PAGE_TEXT, 2, 10,
	"abbrev_extra",   "Describe obj's extra resistances by abbreviation" },
#endif

#ifdef JP
	{ &abbrev_all,    FALSE, OPT_PAGE_TEXT, 2, 11,
	"abbrev_all",     "ACeɑSĂ̑ϐ/\̗͂̂" },
#else
	{ &abbrev_all,    FALSE, OPT_PAGE_TEXT, 2, 11,
	"abbrev_all",     "Describe obj's all resistances by abbreviation" },
#endif

#ifdef JP
	{ &exp_need,      FALSE, OPT_PAGE_TEXT, 2, 12,
	"exp_need",       "̃xɕKvȌol\" },
#else
	{ &exp_need,      FALSE, OPT_PAGE_TEXT, 2, 12,
	"exp_need",       "Show the experience needed for next level" },
#endif

#ifdef JP
	{ &ignore_unview, FALSE, OPT_PAGE_TEXT, 2, 13,
	"ignore_unview",  "EÕN[`[̍s\Ȃ" },
#else
	{ &ignore_unview, FALSE, OPT_PAGE_TEXT, 2, 13,
	"ignore_unview",  "Ignore whenever any creature does" },
#endif

	/*** Game-Play ***/

#ifdef JP
	{ &stack_force_notes, TRUE, OPT_PAGE_GAMEPLAY, 0, 8,
	"stack_force_notes", "قȂ̃ACe܂Ƃ߂" },
#else
	{ &stack_force_notes, TRUE, OPT_PAGE_GAMEPLAY, 0, 8,
	"stack_force_notes", "Merge inscriptions when stacking" },
#endif

#ifdef JP
	{ &stack_force_costs, FALSE, OPT_PAGE_GAMEPLAY, 0, 9,
	"stack_force_costs", "قȂ銄\̃ACe܂Ƃ߂" },
#else
	{ &stack_force_costs, FALSE, OPT_PAGE_GAMEPLAY, 0, 9,
	"stack_force_costs", "Merge discounts when stacking" },
#endif

#ifdef JP
	{ &expand_list,   TRUE, OPT_PAGE_GAMEPLAY, 1, 5,
	"expand_list",    "uꗗvR}hg" },
#else
	{ &expand_list,   TRUE, OPT_PAGE_GAMEPLAY, 1, 5,
	"expand_list",    "Expand the power of the list commands" },
#endif

#ifdef JP
	{ &small_levels,  TRUE, OPT_PAGE_GAMEPLAY, 0, 30,
	"small_levels",   "ɏtA̐\ɂ" },
#else
	{ &small_levels,  TRUE, OPT_PAGE_GAMEPLAY, 0, 30,
	"small_levels",   "Allow unusually small dungeon levels" },
#endif

#ifdef JP
	{ &always_small_levels, FALSE, OPT_PAGE_GAMEPLAY, 2, 3,
	"always_small_levels", "ɔɏtA𐶐" },
#else
	{ &always_small_levels, FALSE, OPT_PAGE_GAMEPLAY, 2, 3,
	"always_small_levels", "Always create unusually small dungeon levels" },
#endif

#ifdef JP
	{ &empty_levels,  TRUE, OPT_PAGE_GAMEPLAY, 0, 31,
	"empty_levels",   "ۂ́uA[ivx̐\ɂ" },
#else
	{ &empty_levels,  TRUE, OPT_PAGE_GAMEPLAY, 0, 31,
	"empty_levels",   "Allow empty 'arena' levels" },
#endif

#ifdef JP
	{ &bound_walls_perm, FALSE, OPT_PAGE_GAMEPLAY, 2, 1,
	"bound_walls_perm", "_W̊Oǂivɂ" },
#else
	{ &bound_walls_perm, FALSE, OPT_PAGE_GAMEPLAY, 2, 1,
	"bound_walls_perm", "Boundary walls become 'permanent wall'" },
#endif

#ifdef JP
	{ &last_words,    TRUE, OPT_PAGE_GAMEPLAY, 0, 28,
	"last_words",     "LN^[񂾎⌾̂" },
#else
	{ &last_words,    TRUE, OPT_PAGE_GAMEPLAY, 0, 28,
	"last_words",     "Leave last words when your character dies" },
#endif

#ifdef WORLD_SCORE
#ifdef JP
	{ &send_score,    TRUE, OPT_PAGE_GAMEPLAY, 4, 6,
	"send_score",     "XRAT[oɃXRA𑗂" },
#else
	{ &send_score,    TRUE, OPT_PAGE_GAMEPLAY, 4, 6,
	"send_score",     "Send score dump to the world score server" },
#endif
#endif

#ifdef JP
	{ &allow_debug_opts, FALSE, OPT_PAGE_GAMEPLAY, 6, 11,
	"allow_debug_opts", "fobO/\IvV" },
#else
	{ &allow_debug_opts, FALSE, OPT_PAGE_GAMEPLAY, 6, 11,
	"allow_debug_opts", "Allow use of debug/cheat options" },
#endif

	/*** Disturbance ***/

#ifdef JP
	{ &find_ignore_stairs, FALSE, OPT_PAGE_DISTURBANCE, 0, 16,
	"find_ignore_stairs", "Ki͒ʉ߂" },
#else
	{ &find_ignore_stairs, FALSE, OPT_PAGE_DISTURBANCE, 0, 16,
	"find_ignore_stairs", "Run past stairs" },
#endif

#ifdef JP
	{ &find_ignore_doors, TRUE, OPT_PAGE_DISTURBANCE, 0, 17,
	"find_ignore_doors", "hA͒ʉ߂" },
#else
	{ &find_ignore_doors, TRUE, OPT_PAGE_DISTURBANCE, 0, 17,
	"find_ignore_doors", "Run through open doors" },
#endif

#ifdef JP
	{ &find_cut,      FALSE, OPT_PAGE_DISTURBANCE, 0, 18,
	"find_cut",       "Ȃp΂߂ɍŒZŒʉ߂" },
#else
	{ &find_cut,      FALSE, OPT_PAGE_DISTURBANCE, 0, 18,
	"find_cut",       "Run past known corners" },
#endif

#ifdef JP
	{ &check_abort,   TRUE, OPT_PAGE_DISTURBANCE, 1, 18,
	"check_abort",    "AR}h̓L[͂Œf" },
#else
	{ &check_abort,   TRUE, OPT_PAGE_DISTURBANCE, 1, 18,
	"check_abort",    "Check for user abort while continuous command" },
#endif

#ifdef JP
	{ &flush_failure, TRUE, OPT_PAGE_DISTURBANCE, 1, 20,
	"flush_failure",  "lXȃ~Xɓ͂NA" },
#else
	{ &flush_failure, TRUE, OPT_PAGE_DISTURBANCE, 1, 20,
	"flush_failure",  "Flush input on various failures" },
#endif

#ifdef JP
	{ &flush_disturb, FALSE, OPT_PAGE_DISTURBANCE, 1, 21,
	"flush_disturb",  "Qɓ͂NA" },
#else
	{ &flush_disturb, FALSE, OPT_PAGE_DISTURBANCE, 1, 21,
	"flush_disturb",  "Flush input whenever disturbed" },
#endif

#ifdef JP
	{ &disturb_move,  FALSE, OPT_PAGE_DISTURBANCE, 0, 20,
	"disturb_move",   "ǂ̃N[`[Ăs𒆎~" },
#else
	{ &disturb_move,  FALSE, OPT_PAGE_DISTURBANCE, 0, 20,
	"disturb_move",   "Disturb whenever any creature moves" },
#endif

#ifdef JP
	{ &disturb_high,  FALSE, OPT_PAGE_DISTURBANCE, 1, 3,
	"disturb_high",   "x̍N[`[s𒆎~" },
#else
	{ &disturb_high,  FALSE, OPT_PAGE_DISTURBANCE, 1, 3,
	"disturb_high",   "Disturb whenever high-level creature moves" },
#endif

#ifdef JP
	{ &disturb_near,  TRUE, OPT_PAGE_DISTURBANCE, 0, 21,
	"disturb_near",   "ẼN[`[s𒆎~" },
#else
	{ &disturb_near,  TRUE, OPT_PAGE_DISTURBANCE, 0, 21,
	"disturb_near",   "Disturb whenever viewable creature moves" },
#endif

#ifdef JP
	{ &disturb_pets,  FALSE, OPT_PAGE_DISTURBANCE, 5, 6,
	"disturb_pets",   "Ẽybgs𒆎~" },
#else
	{ &disturb_pets,  FALSE, OPT_PAGE_DISTURBANCE, 5, 6,
	"disturb_pets",   "Disturb when visible pets move" },
#endif

#ifdef JP
	{ &disturb_panel, TRUE, OPT_PAGE_DISTURBANCE, 0, 22,
	"disturb_panel",  "ʃXN[ɍs𒆎~" },
#else
	{ &disturb_panel, TRUE, OPT_PAGE_DISTURBANCE, 0, 22,
	"disturb_panel",  "Disturb whenever map panel changes" },
#endif

#ifdef JP
	{ &disturb_state, TRUE, OPT_PAGE_DISTURBANCE, 0, 23,
	"disturb_state",  "̃Xe[^Xωɍs𒆎~" },
#else
	{ &disturb_state, TRUE, OPT_PAGE_DISTURBANCE, 0, 23,
	"disturb_state",  "Disturb whenever player state changes" },
#endif

#ifdef JP
	{ &disturb_minor, TRUE, OPT_PAGE_DISTURBANCE, 0, 24,
	"disturb_minor",  "ׂȂƂNĂs𒆎~" },
#else
	{ &disturb_minor, TRUE, OPT_PAGE_DISTURBANCE, 0, 24,
	"disturb_minor",  "Disturb whenever boring things happen" },
#endif

#ifdef JP
	{ &ring_bell,     FALSE, OPT_PAGE_DISTURBANCE, 0, 14,
	"ring_bell",      "G[Ƀr[v炷" },
#else
	{ &ring_bell,     FALSE, OPT_PAGE_DISTURBANCE, 0, 14,
	"ring_bell",      "Audible bell (on errors, etc)" },
#endif

#ifdef JP
	{ &disturb_trap_detect, TRUE, OPT_PAGE_DISTURBANCE, 0, 27,
	"disturb_trap_detect", "gbvm͈͊Oɏo钼Oɍs𒆎~" },
#else
	{ &disturb_trap_detect, TRUE, OPT_PAGE_DISTURBANCE, 0, 27,
	"disturb_trap_detect", "Disturb when leaving trap detected area" },
#endif

#ifdef JP
	{ &alert_trap_detect, FALSE, OPT_PAGE_DISTURBANCE, 0, 25,
	"alert_trap_detect", "gbvm͈͊Oɏo钼OɌx" },
#else
	{ &alert_trap_detect, FALSE, OPT_PAGE_DISTURBANCE, 0, 25,
	"alert_trap_detect", "Alert when leaving trap detected area" },
#endif

	/*** Birth Options ***/

#ifdef JP
	{ &manual_haggle, FALSE, OPT_PAGE_BIRTH, 1, 0,
	"manual_haggle",  "XŒl؂" },
#else
	{ &manual_haggle, FALSE, OPT_PAGE_BIRTH, 1, 0,
	"manual_haggle",  "Manually haggle in stores" },
#endif

#ifdef JP
	{ &smart_learn,   TRUE, OPT_PAGE_BIRTH, 1, 14,
	"smart_learn",    "N[`[͎swK(*)" },
#else
	{ &smart_learn,   TRUE, OPT_PAGE_BIRTH, 1, 14,
	"smart_learn",    "Creatures learn from their mistakes (*)" },
#endif

#ifdef JP
	{ &smart_cheat,   FALSE, OPT_PAGE_BIRTH, 1, 15,
	"smart_cheat",    "N[`[̓vC[݂̎˂(*)" },
#else
	{ &smart_cheat,   FALSE, OPT_PAGE_BIRTH, 1, 15,
	"smart_cheat",    "Creatures exploit players weaknesses (*)" },
#endif

#ifdef JP
	{ &ironman_shops, FALSE, OPT_PAGE_BIRTH, 6, 2,
	"ironman_shops",  "(Slp)XgpȂ(*)" },
#else
	{ &ironman_shops, FALSE, OPT_PAGE_BIRTH, 6, 2,
	"ironman_shops",  "Stores are permanently closed (*)" },
#endif

#ifdef JP
	{ &ironman_small_levels, FALSE, OPT_PAGE_BIRTH, 6, 3,
	"ironman_small_levels", "(Slp)ɔɏtA𐶐(*)" },
#else
	{ &ironman_small_levels, FALSE, OPT_PAGE_BIRTH, 6, 3,
	"ironman_small_levels", "Always create unusually small dungeon levels (*)" },
#endif

#ifdef JP
	{ &ironman_downward, FALSE, OPT_PAGE_BIRTH, 6, 4,
	"ironman_downward", "(Slp)A҂ƏKiȂ(*)" },
#else
	{ &ironman_downward, FALSE, OPT_PAGE_BIRTH, 6, 4,
	"ironman_downward", "Disable recall and use of up stairs (*)" },
#endif

#ifdef JP
	{ &ironman_empty_levels, FALSE, OPT_PAGE_BIRTH, 6, 8,
	"ironman_empty_levels", "(Slp)ɋۂ̃A[ix𐶐(*)" },
#else
	{ &ironman_empty_levels, FALSE, OPT_PAGE_BIRTH, 6, 8,
	"ironman_empty_levels", "Always create empty 'arena' levels (*)" },
#endif

#ifdef JP
	{ &ironman_rooms, FALSE, OPT_PAGE_BIRTH, 6, 12,
	"ironman_rooms",  "(Slp)ɕʂłȂ𐶐(*)" },
#else
	{ &ironman_rooms, FALSE, OPT_PAGE_BIRTH, 6, 12,
	"ironman_rooms",  "Always generate very unusual rooms (*)" },
#endif

#ifdef JP
	{ &curse_of_Iluvatar, FALSE, OPT_PAGE_BIRTH, 6, 18,
	"curse_of_Iluvatar", "(Slp)C[@^[̎f(*)" },
#else
	{ &curse_of_Iluvatar, FALSE, OPT_PAGE_BIRTH, 6, 18,
	"curse_of_Iluvatar", "Curse of Iluvatar(undergo \"Morgoth\" )(*)" },
#endif

#ifdef JP
	{ &preserve_mode, TRUE, OPT_PAGE_BIRTH, 6, 14,
	"preserve_mode",  "`̃ACe蓦ĂĐ(*)" },
#else
	{ &preserve_mode, TRUE, OPT_PAGE_BIRTH, 6, 14,
	"preserve_mode",  "Preserve artifacts (*)" },
#endif

#ifdef JP
	{ &autoroller,    TRUE, OPT_PAGE_BIRTH, 6, 15,
	"autoroller",     "\͒lɃI[g[[gp(*)" },
#else
	{ &autoroller,    TRUE, OPT_PAGE_BIRTH, 6, 15,
	"autoroller",     "Allow use of autoroller for stats (*)" },
#endif

#ifdef JP
	{ &autochara,     FALSE, OPT_PAGE_BIRTH, 6, 16,
	"autochara",     "̊i/nʂɃI[g[[gp" },
#else
	{ &autochara,     FALSE, OPT_PAGE_BIRTH, 6, 16,
	"autochara",      "Autoroll for weight, height and social status" },
#endif

	/*** Easy Object Auto-Destroyer ***/

#ifdef JP
	{ &destroy_items, FALSE, OPT_PAGE_AUTODESTROY, 7, 0,
	"destroy_items",  "ACe̊ȈՎjgp" },
#else
	{ &destroy_items, FALSE, OPT_PAGE_AUTODESTROY, 7, 0,
	"destroy_items",  "Use easy auto-destroyer" },
#endif

#ifdef JP
	{ &destroy_feeling, FALSE, OPT_PAGE_AUTODESTROY, 7, 8,
	"destroy_feeling", "ȈՊӒ肵ƂjKp" },
#else
	{ &destroy_feeling, FALSE, OPT_PAGE_AUTODESTROY, 7, 8,
	"destroy_feeling", "Apply auto-destroy as sense feeling" },
#endif

#ifdef JP
	{ &destroy_identify, FALSE, OPT_PAGE_AUTODESTROY, 7, 9,
	"destroy_identify", "Ӓ肵ƂjKp" },
#else
	{ &destroy_identify, FALSE, OPT_PAGE_AUTODESTROY, 7, 9,
	"destroy_identify", "Apply auto-destroy as identify an item" },
#endif

#ifdef JP
	{ &leave_worth,   TRUE, OPT_PAGE_AUTODESTROY, 7, 2,
	"leave_worth",    "lACe͉󂳂Ȃ" },
#else
	{ &leave_worth,   TRUE, OPT_PAGE_AUTODESTROY, 7, 2,
	"leave_worth",    "Auto-destroyer leaves known worthy items" },
#endif

#ifdef JP
	{ &leave_equip,   FALSE, OPT_PAGE_AUTODESTROY, 7, 3,
	"leave_equip",    "/h͉󂳂Ȃ" },
#else
	{ &leave_equip,   FALSE, OPT_PAGE_AUTODESTROY, 7, 3,
	"leave_equip",    "Auto-destroyer leaves weapons and armour" },
#endif

#ifdef JP
	{ &leave_chest,   TRUE, OPT_PAGE_AUTODESTROY, 7, 7,
	"leave_chest",    "JĂȂ͉󂳂Ȃ" },
#else
	{ &leave_chest,   TRUE, OPT_PAGE_AUTODESTROY, 7, 7,
	"leave_chest",    "Auto-destroyer leaves closed chests" },
#endif

#ifdef JP
	{ &leave_wanted,  TRUE, OPT_PAGE_AUTODESTROY, 7, 4,
	"leave_wanted",   "܋̎/͉󂳂Ȃ" },
#else
	{ &leave_wanted,  TRUE, OPT_PAGE_AUTODESTROY, 7, 4,
	"leave_wanted",   "Auto-destroyer leaves wanted corpses" },
#endif

#ifdef JP
	{ &leave_corpse,  FALSE, OPT_PAGE_AUTODESTROY, 7, 5,
	"leave_corpse",   "/͉󂳂Ȃ" },
#else
	{ &leave_corpse,  FALSE, OPT_PAGE_AUTODESTROY, 7, 5,
	"leave_corpse",   "Auto-destroyer leaves corpses and skeletons" },
#endif

#ifdef JP
	{ &leave_junk,    FALSE, OPT_PAGE_AUTODESTROY, 7, 6,
	"leave_junk",     "炭͉󂳂Ȃ" },
#else
	{ &leave_junk,    FALSE, OPT_PAGE_AUTODESTROY, 7, 6,
	"leave_junk",     "Auto-destroyer leaves junk" },
#endif

#ifdef JP
	{ &leave_special, TRUE, OPT_PAGE_AUTODESTROY, 7, 1,
	"leave_special",  "푰/EƂœʂɕKvȃACe͉󂳂Ȃ" },
#else
	{ &leave_special, TRUE, OPT_PAGE_AUTODESTROY, 7, 1,
	"leave_special",  "Auto-destroyer leaves items your race/class needs" },
#endif

	/*** Play-record Options ***/

#ifdef JP
	{ &record_fix_art, TRUE, OPT_PAGE_PLAYRECORD, 4, 11,
	"record_fix_art", "ŒA[eBt@Ng̓L^" },
#else
	{ &record_fix_art, TRUE, OPT_PAGE_PLAYRECORD, 4, 11,
	"record_fix_art", "Record fixed artifacts" },
#endif

#ifdef JP
	{ &record_rand_art, TRUE, OPT_PAGE_PLAYRECORD, 4, 12,
	"record_rand_art", "_A[eBt@Ng̓L^" },
#else
	{ &record_rand_art, TRUE, OPT_PAGE_PLAYRECORD, 4, 12,
	"record_rand_art", "Record random artifacts" },
#endif

#ifdef JP
	{ &record_destroy_uniq, TRUE, OPT_PAGE_PLAYRECORD, 4, 13,
	"record_destroy_uniq", "j[NN[`[|ƂL^" },
#else
	{ &record_destroy_uniq, TRUE, OPT_PAGE_PLAYRECORD, 4, 13,
	"record_destroy_uniq", "Record when destroy unique creature" },
#endif

#ifdef JP
	{ &record_fix_quest, TRUE, OPT_PAGE_PLAYRECORD, 4, 14,
	"record_fix_quest", "ŒNGXg̒BL^" },
#else
	{ &record_fix_quest, TRUE, OPT_PAGE_PLAYRECORD, 4, 14,
	"record_fix_quest", "Record fixed quests" },
#endif

#ifdef JP
	{ &record_rand_quest, TRUE, OPT_PAGE_PLAYRECORD, 4, 15,
	"record_rand_quest", "_NGXg̒BL^" },
#else
	{ &record_rand_quest, TRUE, OPT_PAGE_PLAYRECORD, 4, 15,
	"record_rand_quest", "Record random quests" },
#endif

#ifdef JP
	{ &record_maxdepth, TRUE, OPT_PAGE_PLAYRECORD, 4, 16,
	"record_maxdepth", "Ő[KXVƂɋL^" },
#else
	{ &record_maxdepth, TRUE, OPT_PAGE_PLAYRECORD, 4, 16,
	"record_maxdepth", "Record movements to deepest level" },
#endif

#ifdef JP
	{ &record_stair,  TRUE, OPT_PAGE_PLAYRECORD, 4, 17,
	"record_stair",   "K̈ړL^" },
#else
	{ &record_stair,  TRUE, OPT_PAGE_PLAYRECORD, 4, 17,
	"record_stair",   "Record recall and stair movements" },
#endif

#ifdef JP
	{ &record_buy,    TRUE, OPT_PAGE_PLAYRECORD, 4, 18,
	"record_buy",     "ACe̍wL^" },
#else
	{ &record_buy,    TRUE, OPT_PAGE_PLAYRECORD, 4, 18,
	"record_buy",     "Record purchased items" },
#endif

#ifdef JP
	{ &record_sell,   FALSE, OPT_PAGE_PLAYRECORD, 4, 19,
	"record_sell",    "ACe̔pL^" },
#else
	{ &record_sell,   FALSE, OPT_PAGE_PLAYRECORD, 4, 19,
	"record_sell",    "Record sold items" },
#endif

#ifdef JP
	{ &record_danger, TRUE, OPT_PAGE_PLAYRECORD, 4, 20,
	"record_danger",  "s`ɂȂƂL^" },
#else
	{ &record_danger, TRUE, OPT_PAGE_PLAYRECORD, 4, 20,
	"record_danger",  "Record hitpoint warning" },
#endif

#ifdef JP
	{ &record_arena,  TRUE, OPT_PAGE_PLAYRECORD, 4, 21,
	"record_arena",   "A[ił̏L^" },
#else
	{ &record_arena,  TRUE, OPT_PAGE_PLAYRECORD, 4, 21,
	"record_arena",   "Record arena victories" },
#endif

#ifdef JP
	{ &record_ident,  TRUE, OPT_PAGE_PLAYRECORD, 4, 22,
	"record_ident",   "̃ACe̎ʂL^" },
#else
	{ &record_ident,  TRUE, OPT_PAGE_PLAYRECORD, 4, 22,
	"record_ident",   "Record first identified items" },
#endif

#ifdef JP
	{ &record_named_pet, FALSE, OPT_PAGE_PLAYRECORD, 4, 23,
	"record_named_pet", "Oybg̏L^" },
#else
	{ &record_named_pet, FALSE, OPT_PAGE_PLAYRECORD, 4, 23,
	"record_named_pet", "Record informations of named pets" },
#endif

	#ifdef JP
	{ &autosave_l, FALSE, OPT_PAGE_AUTOSAVE, 20, 0,
	"autosave_l",     "KwɃI[gZ[u" },
#else
	{ &autosave_l, FALSE, OPT_PAGE_PLAYRECORD, 20, 0,
	"autosave_l",     "Autosave" },
#endif


	/*** End of Table ***/

	{ NULL,           0, 0, 0, 0,
	NULL,             NULL }
};


martial_arts ma_blows[MAX_MA] =
{
#ifdef JP
	{ "%s%sB",            1, 0, 1, 5, 0 },
	{ "%s%sRB",             2, 0, 1, 7, 0 },
	{ "%s%sɐ˂킵B",           3, 0, 1, 9, 0 },
	{ "%s%sɕGR킵B", 5, 5, 2, 4, MA_KNEE },
	{ "%s%sɕIł킵B", 7, 5, 1, 12, 0 },
	{ "%s%sɑ̓肵B",             9, 10, 2, 6, 0 },
	{ "%s%sRB",             11, 10, 3, 6, MA_SLOW },
	{ "%s%sɃAbp[킵B",         13, 12, 5, 5, 6 },
	{ "%s%sɓiR킵B",      16, 15, 5, 6, 8 },
	{ "%s%sɔL܌킵B", 20, 20, 5, 8, 0 },
	{ "%s%sɒr킵B", 24, 25, 6, 8, 10 },
	{ "%s%sɘh܏P킵B", 28, 25, 7, 9, 0 },
	{ "%s%sɉ񂵏R킵B", 32, 30, 8, 10, 10 },
	{ "%s%sɓS킵B", 35, 35, 8, 11, 10 },
	{ "%s%sɔr킵B", 39, 35, 8, 12, 12 },
	{ "%s%sɏ킵B", 43, 35, 9, 12, 16 },
	{ "%s%sɐΔjV킵B", 48, 40, 10, 13, 18 },
#else
	//TODO
	{ "%s punch %s.",            1, 0, 1, 4, 0 },
	{ "%s kick %s.",             2, 0, 1, 6, 0 },
	{ "%s strike %s.",           3, 0, 1, 7, 0 },
	{ "%s hit %s with your knee.", 5, 5, 2, 3, MA_KNEE },
	{ "%s hit %s with your elbow.", 7, 5, 1, 8, 0 },
	{ "%s butt %s.",             9, 10, 2, 5, 0 },
	{ "%s kick %s.",             11, 10, 3, 4, MA_SLOW },
	{ "%s uppercut %s.",         13, 12, 4, 4, 6 },
	{ "%s double-kick %s.",      16, 15, 5, 4, 8 },
	{ "%s hit %s with a Cat's Claw.", 20, 20, 5, 5, 0 },
	{ "%s hit %s with a jump kick.", 25, 25, 5, 6, 10 },
	{ "%s hit %s with an Eagle's Claw.", 29, 25, 6, 6, 0 },
	{ "%s hit %s with a circle kick.", 33, 30, 6, 8, 10 },
	{ "%s hit %s with an Iron Fist.", 37, 35, 8, 8, 10 },
	{ "%s hit %s with a flying kick.", 41, 35, 8, 10, 12 },
	{ "%s hit %s with a Dragon Fist.", 45, 35, 10, 10, 16 },
	{ "%s hit %s with a Crushing Blow.", 48, 35, 10, 12, 18 },
#endif

};

/*
 * Table of game-generated inscriptions (indexed by the defines in
 * defines.h). -- RG
 */
cptr game_inscriptions[] =
{
	NULL, /* FEEL_NONE */
#ifdef JP
	"Ă", /* FEEL_BROKEN */
	"낵", /* FEEL_TERRIBLE */
	"l", /* FEEL_WORTHLESS */
	"Ă", /* FEEL_CURSED */
	"㎿ȏ", /* FEEL_UNCURSED */
	"", /* FEEL_AVERAGE */
	"㎿", /* FEEL_GOOD */
	"i", /* FEEL_EXCELLENT */
	"ʐ", /* FEEL_SPECIAL */
#else
	"broken", /* FEEL_BROKEN */
	"terrible", /* FEEL_TERRIBLE */
	"worthless", /* FEEL_WORTHLESS */
	"cursed", /* FEEL_CURSED */
	"uncursed", /* FEEL_UNCURSED */
	"average", /* FEEL_AVERAGE */
	"good", /* FEEL_GOOD */
	"excellent", /* FEEL_EXCELLENT */
	"special", /* FEEL_SPECIAL */
#endif

};

kamae kamae_shurui[MAX_KAMAE] =
{
#ifdef JP
	{"", 25, ""},
	{"", 30, ""},
	{"", 35, ""},
	{"鐝", 40, ""},
#else
	{"Genbu", 25, "(Black Tortoise) "},
	{"Byakko", 30, "(White Tiger) "},
	{"Seiryuu", 35, "(Blue Dragon) "},
	{"Suzaku", 40, "(Red Phoenix) "},
#endif
};

kamae kata_shurui[MAX_KATA] =
{
#ifdef JP
	{"", 25, ""},
	{"o", 30, ""},
	{"~S", 35, ""},
	{"z", 40, ""},
#else
	{"Iai", 25, ""},
	{"Huujin", 30, ""},
	{"Kouki", 35, ""},
	{"Musou", 40, ""},
#endif
};

cptr exp_level_str[5]=
#ifdef JP
{"[S]", "[]", "[n]", "[GLXp[g]", "[Bl]"};
#else
{"[Unskilled]", "[Beginner]", "[Skilled]", "[Expert]", "[Master]"};
#endif

/* Weird melee attack types when hallucinating */
#ifdef JP
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"ɏւꂽB",
	"Ȃ̉3ăƌB",
	"ɂ΂܂킳ꂽB",
	"ɌCȂ߂ꂽB",
	"ɃniN\΂ꂽB",
	"ɃWōUꂽB",
	"Ȃ̖jDł΂B",
	"Ȃ̑OŃ|[WOB",
	"ɃAJx[ꂽB",
	"Ɂu_̍v̓P߂ꂽB",
	"Ƀb[܂ꂽB",
	"ɂ݂ꂽB",
	"͂ȂƗxB",
	"Ɋɂ炭ꂽB",
	"Ɏ؋̕ԍς܂ꂽB",
	"ɃXJ[g߂ꂽB",
	"͂Ȃ̎葊B",
	"𖞂オꂽB",
	"爤̍ꂽB",
	"͂Ȃ500~ŌقB",
	"͂Ȃ100̔閧ɂĔMB",
	"j[ƖB",
	"͂ȂɋCB",
	"͂Ȃ|SB",
	"ɏꂽB",
	"̓Ae}̎I",
	"͂Ȃ̃XpCNubNB",
	"̓XChړB",
	"͏R}h̓͂ɎsB",
	"͊gUgC𔭎˂B",
	"̓fX[@B",
	"ɃC_[LbNōUꂽB",
	"ɓTԈȓŃrfIlɌȂƎʎ􂢂ꂽB",
	"̓pveB",
	"̓X[p[EgMNeBJ}OiB",
	"ɂႪݏLbNŃnꂽB",
	"ɃWFbgXg[A^bNꂽB",
	"͂Ȃəł߂āu1A2A3A_[bIvƋ񂾁B",
	"́uȂI΂΂΂IvƂċ삯oB",
	"uA[xX̊GvƌĐÂɖڂB",
	"͌BuD\'angbandA^JIv",
	"Ɂu{vꂽB",
	"͂Ȃ̗̎ɓf𐁂B"
};

/* Note: %s for strfmt() */
cptr silly_attacks2[MAX_SILLY_ATTACK] =
{
	"%sɏւB",
	"%s̉3ăƌB",
	"%s΂܂킵B",
	"%sɌCȂ߂B",
	"%sɃniN\΂B",
	"%sWōUB",
	"%s̖jDł΂B",
	"%s̑OŃ|[WOB",
	"%sɃAJx[B",
	"%sɁu_̍v̓P߂B",
	"%sɃb[܂B",
	"%sɂ݂ꂽB",
	"%sƗxB",
	"%s̊ɂ炭B",
	"%sɎ؋̕ԍς܂B",
	"%s̃XJ[g߂B",
	"%s̎葊B",
	"%s𖞂オB",
	"%sɈ̍B",
	"%s500~ŌقB",
	"%s100̔閧ɂĔMB",
	"j[ƖB",
	"%sɋCB",
	"%s|SB",
	"%sB",
	"Ae}̎I",
	"%s̃XpCNubNB",
	"XChړB",
	"R}h̓͂ɎsB",
	"%sɊgUgC𔭎˂B",
	"%sɃfX[@B",
	"%sC_[LbNōUB",
	"%sɓTԈȓŃrfIlɌȂƎʎ􂢂B",
	"pveB",
	"%sɃX[p[EgMNeBJ}OiB",
	"%sႪݏLbNŃnB",
	"%sɃWFbgXg[A^bNB",
	"%səł߂āu1A2A3A_[bIvƋ񂾁B",
	"uȂI΂΂΂IvƂċ삯oB",
	"uA[xX̊GvƌĐÂɖڂB",
	"BuD\'angbandA^JIv",
};
#else
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"smothers",
	"hugs",
	"humiliates",
	"whips",
	"kisses",

	"disgusts",
	"pees all over",
	"passes the gas on",
	"makes obscene gestures at",
	"licks",

	"stomps on",
	"swallows",
	"drools on",
	"misses",
	"shrinks",

	"emasculates",
	"evaporates",
	"solidifies",
	"digitizes",
	"insta-kills",

	"massacres",
	"slaughters",
	"drugs",
	"psychoanalyzes",
	"deconstructs",

	"falsifies",
	"disbelieves",
	"molests",
	"pusupusu",
};
#endif


/*
 * The table of "symbol info" -- each entry is a string of the form
 * "X:desc" where "X" is the trigger, and "desc" is the "info".
 */
cptr ident_info[] =
{
#ifdef JP
	" :È",
	"!:, IC",
	"\":A~bg, ",
	"#:(BhA)/A/C",
	"$:()",
	"%:z(n₩Ήp)",
	"&:",
	"':JhA",
	"(:炩h",
	"):",
	"*:܂񂾍z܂͋`̉",
	"+:hA",
	",:Hו, ΂LmR",
	"-:@_, bh",
	".:",
	"/:Ə󕐊(AbNX/pCN/)",
	"0:ق̓",
	"1:G݉̓",
	"2:h̓",
	"3:X̓",
	"4:@̓",
	"5:Bp̓X̓",
	"6:@̓X̓",
	"7:ubN}[Pbg̓",
	"8:䂪Ƃ̓",
	"9:X̓",
	"::",
	";:̒/̃[",
	"<:Ki",
	"=:w",
	">:Ki",
	"?:",
	"@:vC[",
	"A:Vg",
	"B:",
	"C:",
	"D:ÑhS/CA[",
	"E:G^",
	"F:g{",
	"G:S[Xg",
	"H:G",
	"I:",
	"J:wr",
	"K:L[Er[g",
	"L:b`",
	"M:঒",
	"N:̐",
	"O:I[K",
	"P:lԌ^",
	"Q:NCXO(ł)",
	"R:঒/",
	"S:w/T\/_j",
	"T:g",
	"U:㋉f[",
	"V:opCA",
	"W:Cg/CX/",
	"X:][/U/",
	"Y:CGeB",
	"Z:nEh",
	"[:A[}[",
	"\\:݊(CX/`/)",
	"]:X̖h",
	"^:gbv",
	"_:",
	"`:l`C",
	"a:A",
	"b:RE",
	"c:Jf",
	"d:hS",
	"e:ڋ",
	"f:lR",
	"g:S[",
	"h:zrbg/Gt/h[t",
	"i:xgxg",
	"j:[[",
	"k:R{h",
	"l:",
	"m:h",
	"n:i[K",
	"o:I[N",
	"p:l",
	"q:lb",
	"r:lY~",
	"s:XPg",
	"t:̐l",
	"u:f[",
	"v:{ebNX",
	"w:CV/Q",
	/* "x:unused", */
	"y:C[N",
	"z:]r/~C",
	"{:ѓ̒e(/e)",
	"|:(\[h/_K[/)",
	"}:ѓ(|/NX{E/XO)",
	"~:/n◬(X̃ACe)",
#else
	" :A dark grid",
	"!:A potion (or oil)",
	"\":An amulet (or necklace)",
	"#:A wall (or secret door) / a plant / a gas",
	"$:Treasure (gold or gems)",
	"%:A vein (magma or quartz)",
	"&:A chest",
	"':An open door",
	"(:Soft armor",
	"):A shield",
	"*:A vein with treasure or a ball creature",
	"+:A closed door",
	",:Food (or mushroom patch)",
	"-:A wand (or rod)",
	".:Floor",
	"/:A polearm (Axe/Pike/etc)",
	"0:Entrance to Museum",
	"1:Entrance to General Store",
	"2:Entrance to Armory",
	"3:Entrance to Weaponsmith",
	"4:Entrance to Temple",
	"5:Entrance to Alchemy shop",
	"6:Entrance to Magic store",
	"7:Entrance to Black Market",
	"8:Entrance to your home",
	"9:Entrance to the bookstore",
	"::Rubble",
	";:A glyph of warding / an explosive rune",
	"<:An up staircase",
	"=:A ring",
	">:A down staircase",
	"?:A scroll",
	"@:You",
	"A:Angel",
	"B:Bird",
	"C:Canine",
	"D:Ancient Dragon/Wyrm",
	"E:Elemental",
	"F:Dragon Fly",
	"G:Ghost",
	"H:Hybrid",
	"I:Insect",
	"J:Snake",
	"K:Killer Beetle",
	"L:Lich",
	"M:Multi-Headed Reptile",
	"N:Mystery Living",
	"O:Ogre",
	"P:Giant Humanoid",
	"Q:Quylthulg (Pulsing Flesh Mound)",
	"R:Reptile/Amphibian",
	"S:Spider/Scorpion/Tick",
	"T:Troll",
	"U:Major Demon",
	"V:Vampire",
	"W:Wight/Wraith/etc",
	"X:Xorn/Xaren/etc",
	"Y:Yeti",
	"Z:Zephyr Hound",
	"[:Hard armor",
	"\\:A hafted weapon (mace/whip/etc)",
	"]:Misc. armor",
	"^:A trap",
	"_:A staff",
	"`:A figurine or statue",
	"a:Ant",
	"b:Bat",
	"c:Centipede",
	"d:Dragon",
	"e:Floating Eye",
	"f:Feline",
	"g:Golem",
	"h:Hobbit/Elf/Dwarf",
	"i:Icky Thing",
	"j:Jelly",
	"k:Kobold",
	"l:Aquatic creature",
	"m:Mold",
	"n:Naga",
	"o:Orc",
	"p:Person/Human",
	"q:Quadruped",
	"r:Rodent",
	"s:Skeleton",
	"t:Townsperson",
	"u:Minor Demon",
	"v:Vortex",
	"w:Worm/Worm-Mass",
	/* "x:unused", */
	"y:Yeek",
	"z:Zombie/Mummy",
	"{:A missile (arrow/bolt/shot)",
	"|:An edged weapon (sword/dagger/etc)",
	"}:A launcher (bow/crossbow/sling)",
	"~:Fluid terrain (or miscellaneous item)",
#endif

	NULL
};


/*
 * The table of creatures' blow effects
 */
mbe_info_type mbe_info[] =
{
	{  0, 0, }, /* None      */
	{ 60, DO_EFFECT_MISSILE, }, /* HURT      */
	{  5, DO_EFFECT_POIS, }, /* POISON    */
	{ 20, DO_EFFECT_DISENCHANT, }, /* UN_BONUS  */
	{ 15, DO_EFFECT_MISSILE, }, /* UN_POWER  */ /* ToDo: Apply the correct effects */
	{  5, DO_EFFECT_MISSILE, }, /* EAT_GOLD  */
	{  5, DO_EFFECT_MISSILE, }, /* EAT_ITEM  */
	{  5, DO_EFFECT_MISSILE, }, /* EAT_FOOD  */
	{  5, DO_EFFECT_MISSILE, }, /* EAT_LITE  */
	{  0, DO_EFFECT_ACID, }, /* ACID      */
	{ 10, DO_EFFECT_ELEC, }, /* ELEC      */
	{ 10, DO_EFFECT_FIRE, }, /* FIRE      */
	{ 10, DO_EFFECT_COLD, }, /* COLD      */
	{  2, DO_EFFECT_MISSILE, }, /* BLIND     */
	{ 10, DO_EFFECT_CONFUSION, }, /* CONFUSE   */
	{ 10, DO_EFFECT_MISSILE, }, /* TERRIFY   */
	{  2, DO_EFFECT_MISSILE, }, /* PARALYZE  */
	{  0, DO_EFFECT_MISSILE, }, /* LOSE_STR  */
	{  0, DO_EFFECT_MISSILE, }, /* LOSE_INT  */
	{  0, DO_EFFECT_MISSILE, }, /* LOSE_WIS  */
	{  0, DO_EFFECT_MISSILE, }, /* LOSE_DEX  */
	{  0, DO_EFFECT_MISSILE, }, /* LOSE_CON  */
	{  0, DO_EFFECT_MISSILE, }, /* LOSE_CHR  */
	{  2, DO_EFFECT_MISSILE, }, /* LOSE_ALL  */
	{ 60, DO_EFFECT_ROCKET, }, /* SHATTER   */
	{  5, DO_EFFECT_MISSILE, }, /* EXP_10    */
	{  5, DO_EFFECT_MISSILE, }, /* EXP_20    */
	{  5, DO_EFFECT_MISSILE, }, /* EXP_40    */
	{  5, DO_EFFECT_MISSILE, }, /* EXP_80    */
	{  5, DO_EFFECT_POIS, }, /* DISEASE   */
	{  5, DO_EFFECT_TIME, }, /* TIME      */
	{  5, DO_EFFECT_MISSILE, }, /* EXP_VAMP  */
	{  5, DO_EFFECT_MANA, }, /* DR_MANA   */
	{ 60, DO_EFFECT_MISSILE, }, /* SUPERHURT */
};



/*
 * The table of features' actions
 */
byte feature_action_flags[FF_FLAG_MAX] =
{
	0, /* LOS */
	0, /* PROJECT */
	0, /* MOVE */
	0, /* PLACE */
	0, /* DROP */
	0, /* SECRET */
	0, /* NOTICE */
	0, /* REMEMBER */
	0, /* OPEN */
	0, /* CLOSE */
	FAF_CRASH_GLASS, /* BASH */
	0, /* SPIKE */
	FAF_DESTROY, /* DISARM */
	0, /* STORE */
	FAF_DESTROY | FAF_CRASH_GLASS, /* TUNNEL */
	0, /* MAY_HAVE_GOLD */
	0, /* HAS_GOLD */
	0, /* HAS_ITEM */
	0, /* DOOR */
	0, /* TRAP */
	0, /* STAIRS */
	0, /* GLYPH */
	0, /* LESS */
	0, /* MORE */
	0, /* RUN */
	0, /* FLOOR */
	0, /* WALL */
	0, /* PERMANENT */
	0, /* INNER */
	0, /* OUTER */
	0, /* SOLID */
	0, /* HIT_TRAP */

	0, /* BRIDGE */
	0, /* RIVER */
	0, /* LAKE */
	0, /* BRIDGED */
	0, /* COVERED */
	0, /* GLOW */
	0, /* ENSECRET */
	0, /* WATER */
	0, /* LAVA */
	0, /* SHALLOW */
	0, /* DEEP */
	0, /* FILLED */
	FAF_DESTROY | FAF_CRASH_GLASS, /* HURT_ROCK */
	0, /* HURT_FIRE */
	0, /* HURT_COLD */
	0, /* HURT_ACID */
	0, /* ICE */
	0, /* ACID */
	0, /* OIL */
	0, /* XXX04 */
	0, /* CAN_CLIMB */
	0, /* CAN_FLY */
	0, /* CAN_SWIM */
	0, /* CAN_PASS */
	0, /* CAN_OOZE */
	0, /* CAN_DIG */
	0, /* HIDE_ITEM */
	0, /* HIDE_SNEAK */
	0, /* HIDE_SWIM */
	0, /* HIDE_DIG */
	0, /* KILL_HUGE */
	0, /* KILL_MOVE */

	0, /* PICK_TRAP */
	0, /* PICK_DOOR */
	0, /* ALLOC */
	0, /* CHEST */
	0, /* DROP_1D2 */
	0, /* DROP_2D2 */
	0, /* DROP_GOOD */
	0, /* DROP_GREAT */
	0, /* HURT_POIS */
	0, /* HURT_ELEC */
	0, /* HURT_WATER */
	0, /* HURT_BWATER */
	0, /* USE_FEAT */
	0, /* GET_FEAT */
	0, /* GROUND */
	0, /* OUTSIDE */
	0, /* EASY_HIDE */
	0, /* EASY_CLIMB */
	0, /* MUST_CLIMB */
	0, /* TREE */
	0, /* NEED_TREE */
	0, /* BLOOD */
	0, /* DUST */
	0, /* SLIME */
	0, /* PLANT */
	0, /* XXX2 */
	0, /* INSTANT */
	0, /* EXPLODE */
	0, /* TIMED */
	0, /* ERUPT */
	0, /* STRIKE */
	0, /* SPREAD */

	0, /* SPECIAL */
	FAF_DESTROY | FAF_NO_DROP | FAF_CRASH_GLASS, /* HURT_DISI */
	0, /* QUEST_ENTER */
	0, /* QUEST_EXIT */
	0, /* QUEST */
	0, /* SHAFT */
	0, /* MOUNTAIN */
	0, /* BLDG */
	0, /* MINOR_GLYPH */
	0, /* PATTERN */
	0, /* TOWN */
	0, /* ENTRANCE */
	0, /* MIRROR */
	0, /* UNPERM */
	0, /* TELEPORTABLE */
	0, /* CONVERT */
	0, /* GLASS */
	0, /* CHAOS TAINTED */
};


byte race_crossing[MAX_RACES][MAX_RACES]=
{
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
};


starting_type starting_point[STARTING_MAX] =
{
	{
#if JP
		"CF_[",
#endif
		"Yender",
		TRUE,
		0, 0, 52, 97, 0, 0
	},
	{
#if JP
		"CF[L",
#endif
		"Yiyeeken",
		TRUE,
		0, 0, 71, 134, 0, 0
	},
	{
#if JP
		"hD[h",
#endif
		"Doodrine",
		FALSE,
		0, 0, 25, 27, 0, 0
	},
	{
#if JP
		"EEXg",
#endif
		"Ulurlist",
		FALSE,
		0, 0, 123, 53, 0, 0
	},
	{
#if JP
		"AOEB",
#endif
		"Angwil",
		FALSE,
		0, 0, 93, 67, 0, 0
	},
	{
#if JP
		"V",
#endif
		"Sila",
		FALSE,
		0, 0, 118, 68, 0, 0
	},
	{
#if JP
		"LZ_oW",
#endif
		"Cixedarbazi",
		FALSE,
		0, 0, 135, 134, 0, 0
	},
	{
#if JP
		"[C",
#endif
		"Duanhai",
		FALSE,
		0, 0, 100, 137, 0, 0
	},

	{
#if JP
		"Y",
#endif
		"Zul",
		FALSE,
		0, 0, 82, 146, 0, 0
	},

	{
#if JP
		"EgDm",
#endif
		"Virya-Utumno",
		FALSE,
		0, 0, 33, 95, 0, 0
	},

	{
#if JP
		"oh",
#endif
		"Morivant",
		FALSE,
		0, 0, 64, 86, 0, 0
	},

	{
#if JP
		"e",
#endif
		"Telmora",
		FALSE,
		0, 0, 68, 62, 0, 0
	},

	{
#if JP
		"eL\~",
#endif
		"Texorami",
		FALSE,
		0, 0, 37, 169, 0, 0
	},

	{
#if JP
		"OuY",
#endif
		"Lugburz",
		FALSE,
		0, 0, 62, 76, 0, 0
	},

	{
#if JP
		"CG",
#endif
		"R'lyeh",
		FALSE,
		0, 0, 118, 97, 0, 0
	},


};

half_race_description half_race_desc[MAX_HALF_RACE_DESCRIPTION] =
{
	{
		RACE_HUMAN,
		RACE_ELF,
#if JP
		"n[tGt",
#else
		"Half-Elf",
#endif
	},

	{
		RACE_HUMAN,
		RACE_DWARF,
#if JP
		"n[th[t",
#else
		"Half-Dwarf",
#endif
	},

	{
		RACE_HUMAN,
		RACE_HOBBIT,
#if JP
		"n[tzrbg",
#else
		"Half-Hobbit",
#endif
	},

	{
		RACE_HUMAN,
		RACE_ORC,
#if JP
		"n[tI[N",
#else
		"Half-Orc",
#endif
	},

	{
		RACE_HUMAN,
		RACE_TROLL,
#if JP
		"n[tg",
#else
		"Half-Troll",
#endif
	},

	{
		RACE_HUMAN,
		RACE_OGRE,
#if JP
		"n[tI[K",
#else
		"Half-Ogre",
#endif
	},

	{
		RACE_ORC,
		RACE_OGRE,
#if JP
		"IO",
#else
		"Ogrillon",
#endif
	},


};

int town_store_id[20][10] =
{
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{4, 12, 10, 7, 6, 8, 3, 0, 9, 1},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},

	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},

	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},

	{31, 34, 35, 41, 36, 37, 32, 0, 40, 1},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},
	{1, 2, 3, 4, 5, 6, 7, 8, 9, 0},

};

char authority_rank_disp[6][3] = {"E", "D", "C", "B", "A", "S"};

int divine_capacity[PY_DIVINE_LIMIT_LEVEL + 1] = 
{
	10,

	11,
	12,
	15,
	18,
	23,

	28,
	35,
	42,
	51,
	60,

	71,
	82,
	95,
	108,
	123,

	138,
	155,
	172,
	191,
	210,

	231,
	252,
	275,
	298,
	323,

	348,
	375,
	402,
	431,
	460,
};

/* List of prize object */
struct object_id prize_list[MAX_BOUNTY] = 
{
	{TV_POTION, SV_POTION_CURING},
	{TV_POTION, SV_POTION_SPEED},
	{TV_POTION, SV_POTION_SPEED},
	{TV_POTION, SV_POTION_RESISTANCE},
	{TV_POTION, SV_POTION_ENLIGHTENMENT},

	{TV_POTION, SV_POTION_HEALING},
	{TV_POTION, SV_POTION_RESTORE_MANA},
	{TV_SCROLL, SV_SCROLL_STAR_DESTRUCTION},
	{TV_POTION, SV_POTION_STAR_ENLIGHTENMENT},
	{TV_SCROLL, SV_SCROLL_TRAIT_S_PET},

	{TV_SCROLL, SV_SCROLL_GENOCIDE},
	{TV_POTION, SV_POTION_STAR_HEALING},
	{TV_POTION, SV_POTION_STAR_HEALING},
	{TV_POTION, SV_POTION_NEW_LIFE},
	{TV_SCROLL, SV_SCROLL_MASS_GENOCIDE},

	{TV_POTION, SV_POTION_LIFE},
	{TV_POTION, SV_POTION_LIFE},
	{TV_POTION, SV_POTION_AUGMENTATION},
	{TV_POTION, SV_POTION_INVULNERABILITY},
	{TV_SCROLL, SV_SCROLL_ARTIFACT},
};
