/* Purpose: create a player character */

/* 2011 Deskull modified. */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"

/*
 * How often the autoroller will update the display and pause
 * to check for user interuptions.
 * Bigger values will make the autoroller faster, but slower
 * system may have problems because the user can't stop the
 * autoroller for this number of rolls.
 */
#define AUTOROLLER_STEP 5431L

/*
 * Define this to cut down processor use while autorolling
 */
#if 0
#  define AUTOROLLER_DELAY
#endif

/*
 * Maximum number of tries for selection of a proper quest creature
 */
#define MAX_TRIES 100

#define MAX_CLASS_CHOICE     MAX_CLASS

/*
 * Forward declare
 */
typedef struct hist_type hist_type;

/*
 * Player background information
 */
struct hist_type
{
	cptr info;			    /* Textual History */

	byte roll;			    /* Frequency of this entry */
	byte chart;			    /* Chart index */
	byte next;			    /* Next chart index */
	byte bonus;			    /* Social Class Bonus + 50 */
};


/*
 * Background information (see below)
 *
 * Chart progression by race:
 *   Human         -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Elf      -->  4 -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Elf/High-Elf  -->  7 -->  8 -->  9 --> 54 --> 55 --> 56
 *   Hobbit        --> 10 --> 11 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Gnome         --> 13 --> 14 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Dwarf         --> 16 --> 17 --> 18 --> 57 --> 58 --> 59 --> 60 --> 61
 *   Half-Orc      --> 19 --> 20 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Troll    --> 22 --> 23 --> 62 --> 63 --> 64 --> 65 --> 66
 *
 * XXX XXX XXX This table *must* be correct or drastic errors may occur!
 */
static hist_type bg[] =
{
#ifdef JP
	{"̎qŔFm炳Ă܂B",			 10, 2, 3, 25},
	{"̎qłFm͂Ă܂B",			 20, 2, 3, 35},
	{"l̎q̂̈lłB",			 95, 2, 3, 45},
	{"qłB",						100, 2, 3, 50},
#else
	{"You are the illegitimate and unacknowledged child ",   10, 1, 2, 25},
	{"You are the illegitimate but acknowledged child ",     20, 1, 2, 35},
	{"You are one of several children ",                     95, 1, 2, 45},
	{"You are the first child ",                            100, 1, 2, 50},
#endif


#ifdef JP
	{"Ȃ͔_z",					 40, 1, 2, 65},
	{"Ȃ͎_",					 65, 1, 2, 80},
	{"Ȃ͒l",					 80, 1, 2, 90},
	{"Ȃ͐El",					 90, 1, 2,105},
	{"Ȃ͓y̋Rm",				 96, 1, 2,120},
	{"Ȃׂ͍̋{݈̎ʂM",				 99, 1, 2,130},
	{"Ȃ̓Ao[̉Ƃ̌҂",				100, 1, 2,140},
#else
	{"of a Serf.  ",                                         40, 2, 3, 65},
	{"of a Yeoman.  ",                                       65, 2, 3, 80},
	{"of a Townsman.  ",                                     80, 2, 3, 90},
	{"of a Guildsman.  ",                                    90, 2, 3, 105},
	{"of a Landed Knight.  ",                                96, 2, 3, 120},
	{"of a Noble Family in the Courts of Chaos.  ",          99, 2, 3, 130},
	{"of the Royal Blood Line of Amber.  ",                 100, 2, 3, 140},
#endif


#ifdef JP
	{"Ȃ͈Ƃ̂וłB",				 20, 3,50, 20},
	{"Ȃ͈Ƃ̌ւłB",				 80, 3,50, 55},
	{"Ȃ͉Ƒɑ؂ɂĂ܂B",			100, 3,50, 60},
#else
	{"You are the black sheep of the family.  ",             20, 3, 50, 20},
	{"You are a credit to the family.  ",                    80, 3, 50, 55},
	{"You are a well liked child.  ",                       100, 3, 50, 60},
#endif


#ifdef JP
	{"Ȃ̓̕ẽGtłB",		 40, 4, 1, 50},
	{"Ȃ̓̕ẽGtłB",		 75, 4, 1, 55},
	{"Ȃ̓̕mh[̃GtłB",		 90, 4, 1, 55},
	{"Ȃ̓̕mh[̃GtłB",		 95, 4, 1, 60},
	{"Ȃ̓̕@[̃GtłB",		 98, 4, 1, 65},
	{"Ȃ̓̕@[̃GtłB",				100, 4, 1, 70},
#else
	{"Your mother was of the Teleri.  ",			 40, 4, 1, 50},
	{"Your father was of the Teleri.  ",			 75, 4, 1, 55},
	{"Your mother was of the Noldor.  ",		 	 90, 4, 1, 55},
	{"Your father was of the Noldor.  ",		 	 95, 4, 1, 60},
	{"Your mother was of the Vanyar.  ",			 98, 4, 1, 65},
	{"Your father was of the Vanyar.  ",			100, 4, 1, 70},
#endif


#ifdef JP
	{"l̎q̂̈lłB",			 60, 9, 54, 50},
	{"ꗱłB",					100, 9, 54, 55},
#else
	{"You are one of several children ",			 60, 7, 8, 50},
	{"You are the only child ",					100, 7, 8, 55},
#endif


#ifdef JP
	{"Ȃ̓ẽGt",				 75, 7, 8, 50},
	{"Ȃ̓mh[̃Gt",			 95, 7, 8, 55},
	{"Ȃ̓@[̃Gt",			100, 7, 8, 60},
#else
	{"of a Teleri ",						 75, 8, 9, 50},
	{"of a Noldor ",						 95, 8, 9, 55},
	{"of a Vanyar ",						100, 8, 9, 60},
#endif


#ifdef JP
	{"W[",					 40, 8,9, 80},
	{"A[`[",					 70, 8,9, 90},
	{"m",						 87, 8,9,110},
	{"CW",						 95, 8,9,125},
	{"q",						 99, 8,9,140},
	{"",						100, 8,9,145},
#else
	{"Ranger.  ",						 40, 9, 54, 80},
	{"Archer.  ",						 70, 9, 54, 90},
	{"Warrior.  ",						 87, 9, 54, 110},
	{"Mage.  ",							 95, 9, 54, 125},
	{"Prince.  ",						 99, 9, 54, 140},
	{"King.  ",							100, 9, 54, 145},
#endif


#ifdef JP
	{"zrbg̉l̎q̂̈lłB",		 85,11,3, 45},
	{"zrbg̈ꗱłB",			        100,11,3, 55},
#else
	{"You are one of several children of a Hobbit ",		 85, 10, 11, 45},
	{"You are the only child of a Hobbit ",		        100, 10, 11, 55},
#endif


#ifdef JP
	{"Ȃ͌H",							 20,10,11, 55},
	{"Ȃ͎̓X",						 30,10,11, 80},
	{"Ȃ͕",							 40,10,11, 90},
	{"Ȃ͉Ǝ",							 50,10,11,100},
	{"Ȃ͔Eт̎҂",							 80,10,11,110},
	{"Ȃ͐m",							 95,10,11,115},
	{"Ȃ̓CW",							 99,10,11,125},
	{"Ȃ͈ꑰ̒",							100,10,11,140},
#else
	{"Bum.  ",							 20, 11, 3, 55},
	{"Tavern Owner.  ",						 30, 11, 3, 80},
	{"Miller.  ",						 40, 11, 3, 90},
	{"Home Owner.  ",						 50, 11, 3, 100},
	{"Burglar.  ",						 80, 11, 3, 110},
	{"Warrior.  ",						 95, 11, 3, 115},
	{"Mage.  ",							 99, 11, 3, 125},
	{"Clan Elder.  ",						100, 11, 3, 140},
#endif


#ifdef JP
	{"m[̊l̎q̂̈lłB",		 85,14,3, 45},
	{"m[̈ꗱłB",			        100,14,3, 55},
#else
	{"You are one of several children of a Gnome ",		 85, 13, 14, 45},
	{"You are the only child of a Gnome ",			100, 13, 14, 55},
#endif


#ifdef JP
	{"Ȃ͕",							 20,13,14, 55},
	{"Ȃ̓z",							 50,13,14, 70},
	{"Ȃ͂q҂",							 75,13,14, 85},
	{"Ȃ͐m",							 95,13,14,100},
	{"Ȃ̓CW",							100,13,14,125},
#else
	{"Beggar.  ",						 20, 14, 3, 55},
	{"Braggart.  ",						 50, 14, 3, 70},
	{"Prankster.  ",						 75, 14, 3, 85},
	{"Warrior.  ",						 95, 14, 3, 100},
	{"Mage.  ",							100, 14, 3, 125},
#endif


#ifdef JP
	{"h[t̓l̎q̂̈lłB",		 25,17,18, 40},
	{"h[ẗꗱłB",			        100,17,18, 50},
#else
	{"You are one of two children of a Dwarven ",		 25, 16, 17, 40},
	{"You are the only child of a Dwarven ",			100, 16, 17, 50},
#endif


#ifdef JP
	{"Ȃ͓D_",							 10,16,17, 60},
	{"Ȃ͘SԂ",							 25,16,17, 75},
	{"Ȃ͍Bv",							 75,16,17, 90},
	{"Ȃ͐m",							 90,16,17,110},
	{"Ȃ̓v[Xg",					 99,16,17,130},
	{"Ȃ͉",							100,16,17,150},
#else
	{"Thief.  ",						 10, 17, 18, 60},
	{"Prison Guard.  ",						 25, 17, 18, 75},
	{"Miner.  ",						 75, 17, 18, 90},
	{"Warrior.  ",						 90, 17, 18, 110},
	{"Priest.  ",						 99, 17, 18, 130},
	{"King.  ",							100, 17, 18, 150},
#endif


#ifdef JP
	{"Ȃ͈Ƃ̂וłB",						 15,18,57,10},
	{"Ȃ͈Ƃ̌ւłB",						 85,18,57, 50},
	{"Ȃ͉Ƒɑ؂ɂĂ܂B",				100,18,57, 55},
#else
	{"You are the black sheep of the family.  ",		 15, 18, 57, 10},
	{"You are a credit to the family.  ",			 85, 18, 57, 50},
	{"You are a well liked child.  ",				100, 18, 57, 55},
#endif


#ifdef JP
	{"Ȃ̓̕I[NłA͔閧ɂĂ܂B",	 25,19,20, 25},
	{"Ȃ̓̕I[NłA͔閧ɂĂ܂B",	100,19,20, 25},
#else
	{"Your mother was an Orc, but it is unacknowledged.  ",	 25, 19, 20, 25},
	{"Your father was an Orc, but it is unacknowledged.  ",	100, 19, 20, 25},
#endif


#ifdef JP
	{"Ȃ͔_z̗{qłB",						 40,20, 3, 65},
	{"Ȃ͎_̗{qłB",						 65,20, 3, 80},
	{"Ȃ͒l̗{qłB",						 80,20, 3, 90},
	{"Ȃ͐El̗{qłB",						 90,20, 3,105},
	{"Ȃ͓y̋Rm̗{qłB",					 96,20, 3,120},
	{"Ȃ͎݈ʂM̗{qłB",				 99,20, 3,130},
	{"Ȃ͉Ƃ̌҂̗{qłB",			100,20, 3,140},
#else
	{"You are the adopted child ",				100, 20, 2, 50},
#endif


#ifdef JP
	{"Ȃ͓̕Ag",				 30,22,23, 20},
	{"Ȃ͓̕Ag",				 60,22,23, 25},
	{"Ȃ͋̕ug",					 75,22,23, 30},
	{"Ȃ͋̕ug",					 90,22,23, 35},
	{"Ȃ͐̕g",					 95,22,23, 40},
	{"Ȃ͐̕g",					100,22,23, 45},
#else
	{"Your mother was a Cave-Troll ",				 30, 22, 23, 20},
	{"Your father was a Cave-Troll ",				 60, 22, 23, 25},
	{"Your mother was a Hill-Troll ",				 75, 22, 23, 30},
	{"Your father was a Hill-Troll ",				 90, 22, 23, 35},
	{"Your mother was a Water-Troll ",				 95, 22, 23, 40},
	{"Your father was a Water-Troll ",				100, 22, 23, 45},
#endif


#ifdef JP
	{"RbNłB",							  5,23,62, 60},
	{"młB",							 95,23,62, 55},
	{"ptłB",							 99,23,62, 65},
	{"ꑰ̒łB",						100,23,62, 80},
#else
	{"Cook.  ",							  5, 23, 62, 60},
	{"Warrior.  ",						 95, 23, 62, 55},
	{"Shaman.  ",						 99, 23, 62, 65},
	{"Clan Chief.  ",						100, 23, 62, 80},
#endif


#ifdef JP
	{"Ȃ͐[uE̓",				 20,50,51, 50},
	{"Ȃ̓uE̓",					 60,50,51, 50},
	{"Ȃ͒WF̓",					 70,50,51, 50},
	{"Ȃ̓O[̓",					 80,50,51, 50},
	{"Ȃ͐",						 90,50,51, 50},
	{"Ȃ̓u[OC̓",				100,50,51, 50},
#else
	{"You have dark brown eyes, ",				 20, 50, 51, 50},
	{"You have brown eyes, ",					 60, 50, 51, 50},
	{"You have hazel eyes, ",					 70, 50, 51, 50},
	{"You have green eyes, ",					 80, 50, 51, 50},
	{"You have blue eyes, ",					 90, 50, 51, 50},
	{"You have blue-gray eyes, ",				100, 50, 51, 50},
#endif


#ifdef JP
	{"Ȃ߂炩",							 70,51,52, 50},
	{"gł",							 90,51,52, 50},
	{"J[",							100,51,52, 50},
#else
	{"straight ",						 70, 51, 52, 50},
	{"wavy ",							 90, 51, 52, 50},
	{"curly ",							100, 51, 52, 50},
#endif


#ifdef JP
	{"A",						 30,52,53, 50},
	{"A",						 70,52,53, 50},
	{"ƂѐF̔A",					 80,52,53, 50},
	{"ԂA",						 90,52,53, 50},
	{"uh̔A",				100,52,53, 50},
#else
	{"black hair, ",						 30, 52, 53, 50},
	{"brown hair, ",						 70, 52, 53, 50},
	{"auburn hair, ",						 80, 52, 53, 50},
	{"red hair, ",						 90, 52, 53, 50},
	{"blond hair, ",						100, 52, 53, 50},
#endif


#ifdef JP
	{"̔Ă܂B",					 10,53, 0, 50},
	{"Ă܂B",					 30,53, 0, 50},
	{"ʂ̔FĂ܂B",				 80,53, 0, 50},
	{"Ă܂B",					 90,53, 0, 50},
	{"ʂ悤ȔĂ܂B",		100,53, 0, 50},
#else
	{"and a very dark complexion.",				 10, 53, 0, 50},
	{"and a dark complexion.",					 30, 53, 0, 50},
	{"and an average complexion.",				 80, 53, 0, 50},
	{"and a fair complexion.",					 90, 53, 0, 50},
	{"and a very fair complexion.",				100, 53, 0, 50},
#endif


#ifdef JP
	{"Ȃ͖邢O[̓",					 85,54,55, 50},
	{"Ȃ͖邢u[̓",					 95,54,55, 50},
	{"Ȃ͖邢O[̓",					100,54,55, 50},
#else
	{"You have light grey eyes, ",				 85, 54, 55, 50},
	{"You have light blue eyes, ",				 95, 54, 55, 50},
	{"You have light green eyes, ",				100, 54, 55, 50},
#endif


#ifdef JP
	{"Ȃ߂炩",							 75,55,56, 50},
	{"gł",							100,55,56, 50},
#else
	{"straight ",						 75, 55, 56, 50},
	{"wavy ",							100, 55, 56, 50},
#endif


#ifdef JP
	{"AĂ܂B",				 75,56, 0, 50},
	{"AĂ܂B",				 85,56, 0, 50},
	{"uh̔AĂ܂B",				 95,56, 0, 50},
	{"┯AĂ܂B",				100,56, 0, 50},
#else
	{"black hair, and a fair complexion.",			 75, 56, 0, 50},
	{"brown hair, and a fair complexion.",			 85, 56, 0, 50},
	{"blond hair, and a fair complexion.",			 95, 56, 0, 50},
	{"silver hair, and a fair complexion.",			100, 56, 0, 50},
#endif


#ifdef JP
	{"Ȃ͐[uE̓",					 99,57,58, 50},
	{"Ȃ͋PԂ",					100,57,58, 60},
#else
	{"You have dark brown eyes, ",				 99, 57, 58, 50},
	{"You have glowing red eyes, ",				100, 57, 58, 60},
#endif


#ifdef JP
	{"Ȃ߂炩",							 90,58,59, 50},
	{"gł",							100,58,59, 50},
#else
	{"straight ",						 90, 58, 59, 50},
	{"wavy ",							100, 58, 59, 50},
#endif


#ifdef JP
	{"A",						 75,59,60, 50},
	{"A",						100,59,60, 50},
#else
	{"black hair, ",						 75, 59, 60, 50},
	{"brown hair, ",						100, 59, 60, 50},
#endif


#ifdef JP
	{" 30cm قǂ̃qQA",						 25,60,61, 50},
	{" 60cm قǂ̃qQA",						 60,60,61, 51},
	{" 90cm قǂ̃qQA",					 90,60,61, 53},
	{" 1m20cm قǂ̃qQA ",						100,60,61, 55},
#else
	{"a one foot beard, ",					 25, 60, 61, 50},
	{"a two foot beard, ",					 60, 60, 61, 51},
	{"a three foot beard, ",					 90, 60, 61, 53},
	{"a four foot beard, ",					100, 60, 61, 55},
#endif


#ifdef JP
	{"Ă܂B",					100,61, 0, 50},
#else
	{"and a dark complexion.",					100, 61, 0, 50},
#endif


#ifdef JP
	{"Ȃ̓xg悤ȗ΂̓",					 60,62,63, 50},
	{"Ȃ͉̂悤ȉF",					 85,62,63, 50},
	{"Ȃ͐",				 99,62,63, 50},
	{"Ȃ͋PԂ",					100,62,63, 55},
#else
	{"You have slime green eyes, ",				 60, 62, 63, 50},
	{"You have puke yellow eyes, ",				 85, 62, 63, 50},
	{"You have blue-bloodshot eyes, ",				 99, 62, 63, 50},
	{"You have glowing red eyes, ",				100, 62, 63, 55},
#endif


#ifdef JP
	{"炵",							 33,63,64, 50},
	{"s",							 66,63,64, 50},
	{"",							100,63,64, 50},
#else
	{"dirty ",							 33, 63, 64, 50},
	{"mangy ",							 66, 63, 64, 50},
	{"oily ",							100, 63, 64, 50},
#endif


#ifdef JP
	{"J̗lȔA",					 33,64,65, 50},
	{"邢ԐF̔A",						 66,64,65, 50},
	{"ÂF̔A",						100,64,65, 50},
#else
	{"sea-weed green hair, ",					 33, 64, 65, 50},
	{"bright red hair, ",					 66, 64, 65, 50},
	{"dark purple hair, ",					100, 64, 65, 50},
#endif


#ifdef JP
	{"ΐF",							 25,65,66, 50},
	{"",							 50,65,66, 50},
	{"",							 75,65,66, 50},
	{"",							100,65,66, 50},
#else
	{"and green ",						 25, 65, 66, 50},
	{"and blue ",						 50, 65, 66, 50},
	{"and white ",						 75, 65, 66, 50},
	{"and black ",						100, 65, 66, 50},
#endif


#ifdef JP
	{"ucucĂ܂B",						 33,66, 0, 50},
	{"JTu^炯̔Ă܂B",						 66,66, 0, 50},
	{"KTKT̔Ă܂B",						100,66, 0, 50},
#else
	{"ulcerous skin.",						 33, 66, 0, 50},
	{"scabby skin.",						 66, 66, 0, 50},
	{"leprous skin.",                       100, 66, 0, 50},
#endif


#ifdef JP
	{"FmĂȂqłB",          50, 68, 50, 45},
	{"ꂽqłB",           80, 68, 50, 65},
	{"ĐʂꂽqłB",      100, 68, 50, 55},
#else
	{"You are an unacknowledged child of ", 50, 67, 68, 45},
	{"You are a rebel child of ",         80, 67, 68, 65},
	{"You are a long lost child of ",     100, 67, 68, 55},
#endif


#ifdef JP
	{"Ȃ͖̒mʃAo[̉",               50, 67, 68, 80 },
	{"Ȃ͑ÕAo[", 65, 67, 68, 90 },
	{"Ȃ͑񐢑̃Ao[", 79, 67, 68, 100 },
	{"Ȃ̓Ix",       80, 67, 68, 130 },
	{"Ȃ̓IYbN",        83, 67, 68, 105 },
	{"Ȃ̓tBh[",       84, 67, 68, 105 },
	{"Ȃ̓uh",        85, 67, 68, 90 },
	{"Ȃ̓t[",        87, 67, 68, 100 },
	{"Ȃ̓WF[h",       88, 67, 68, 125 },
	{"Ȃ̓fBAh",      89, 67, 68, 120 },
	{"Ȃ̓_",       90, 67, 68, 140 },
	{"Ȃ̓xlfBNg",     91, 67, 68, 115 },
	{"Ȃ̓R[EB",       92, 67, 68, 110 },
	{"Ȃ̓WA",       93, 67, 68, 105 },
	{"Ȃ̓PC",        94, 67, 68, 95 },
	{"Ȃ̓uCY",        95, 67, 68, 115 },
	{"Ȃ̓tBIi",        96, 67, 68, 110 },
	{"Ȃ̓GbN",         97, 67, 68, 135 },
	{"Ȃ̓ih",      98, 67, 68, 90 },
	{"Ȃ̓}[",       99, 67, 68, 105 },
	{"Ȃ̓}[eB",       100, 67,68, 80 },
#else
	{"an unknown Amberite.  ",               50, 68, 50, 80 },
	{"an unknown third generation Amberite.  ", 65, 68, 50, 90 },
	{"an unknown second generation Amberite.  ", 79, 68, 50, 100 },
	{"Oberon.  ",       80, 68, 50, 130 },
	{"Osric.  ",        83, 68, 50, 105 },
	{"Finndo.  ",       84, 68, 50, 105 },
	{"Brand.  ",        85, 68, 50, 90 },
	{"Flora.  ",        87, 68, 50, 100 },
	{"Gerard.  ",       88, 68, 50, 125 },
	{"Deirdre.  ",      89, 68, 50, 120 },
	{"Random.  ",       90, 68, 50, 140 },
	{"Benedict.  ",     91, 68, 50, 115 },
	{"Corwin.  ",       92, 68, 50, 110 },
	{"Julian.  ",       93, 68, 50, 105 },
	{"Caine.  ",        94, 68, 50, 95 },
	{"Bleys.  ",        95, 68, 50, 115 },
	{"Fiona.  ",        96, 68, 50, 110 },
	{"Eric.  ",         97, 68, 50, 135 },
	{"Rinaldo.  ",      98, 68, 50, 90 },
	{"Merlin.  ",       99, 68, 50, 105 },
	{"Martin.  ",       100, 68, 50, 80 },
#endif



#ifdef JP
	{"l̎q̂̈lłB",      85, 70, 71, 45},
	{"ꗱłB",         	 100, 70, 71, 55},

	{"Ȃ̓_[NGt̐m", 50, 69, 70, 60 },
	{"Ȃ̓_[NGt̖pm", 80, 69, 70, 75 },
	{"Ȃ̓_[NGt̋M", 100,  69, 70, 95 },
#else
	{"You are one of several children of a Dark Elven ",      85, 69, 70, 45},
	{"You are the only child of a Dark Elven ",          100, 69, 70, 55},

	{"Warrior.  ", 50, 70, 71, 60 },
	{"Warlock.  ", 80, 70, 71, 75 },
	{"Noble.  ", 100, 70, 71, 95 },
#endif


#ifdef JP
	{"Ȃ͍", 100, 71, 72, 50},
#else
	{"You have black eyes, ", 100, 71, 72, 50},
#endif


#ifdef JP
	{"Ȃ߂炩",                        70, 72, 73, 50},
	{"gł",                            90, 72, 73, 50},
	{"J[",                          100, 72, 73, 50},

	{"AĂƂĂÂF̔Ă܂B", 100, 73, 0, 50 },
#else
	{"straight ",                        70, 72, 73, 50},
	{"wavy ",                            90, 72, 73, 50},
	{"curly ",                          100, 72, 73, 50},

	{"black hair and a very dark complexion.", 100, 73, 0, 50 },
#endif


#ifdef JP
	{"Ȃ̕e̓I[KłA͔閧ɂĂ܂B", 25, 74, 20, 25},
	{"Ȃ̕e̓I[KłA͔閧ɂĂ܂B", 100, 74, 20, 25},
#else
	{"Your mother was an Ogre, but it is unacknowledged.  ", 25, 74, 20, 25},
	{"Your father was an Ogre, but it is unacknowledged.  ", 100, 74, 20, 25},
#endif


#ifdef JP
	{"Ȃ̕e͋uWCAgłB", 10, 75, 20, 50},
	{"Ȃ̕e̓t@CA[EWCAgłB", 12, 75, 20, 55},
	{"Ȃ̕e̓tXgEWCAgłB", 20, 75, 20, 60},
	{"Ȃ̕e̓NEhEWCAgłB", 23, 75, 20, 65},
	{"Ȃ̕e̓Xg[EWCAgłB", 25, 75, 20, 70},
	{"Ȃ̕e͋uWCAgłB",  60, 75, 20, 50},
	{"Ȃ̕e̓t@CA[EWCAgłB",  70, 75, 20, 55},
	{"Ȃ̕e̓tXgEWCAgłB",  80, 75, 20, 60},
	{"Ȃ̕e̓NEhEWCAgłB",  90, 75, 20, 65},
	{"Ȃ̕e̓Xg[EWCAgłB", 100, 75, 20, 70},
#else
	{"Your mother was a Hill Giant.  ", 10, 75, 20, 50},
	{"Your mother was a Fire Giant.  ", 12, 75, 20, 55},
	{"Your mother was a Frost Giant.  ", 20, 75, 20, 60},
	{"Your mother was a Cloud Giant.  ", 23, 75, 20, 65},
	{"Your mother was a Storm Giant.  ", 25, 75, 20, 70},
	{"Your father was a Hill Giant.  ",  60, 75, 20, 50},
	{"Your father was a Fire Giant.  ",  70, 75, 20, 55},
	{"Your father was a Frost Giant.  ",  80, 75, 20, 60},
	{"Your father was a Cloud Giant.  ",  90, 75, 20, 65},
	{"Your father was a Storm Giant.  ", 100, 75, 20, 70},
#endif


#ifdef JP
	{"Ȃ̕e͖̒mʃ^C^łB", 75, 76, 20, 50 },
	{"Ȃ̕e̓e~XłB",        80, 76, 20, 100 },
	{"Ȃ̕e̓mVłB",     85, 76, 20, 100 },
	{"Ȃ̕e̓IPAmXłB",      90, 76, 20, 100 },
	{"Ȃ̕e̓NEXłB",         95, 76, 20, 100 },
	{"Ȃ̕e̓nCyIłB",      98, 76, 20, 125 },
	{"Ȃ̕e̓NmXłB",       100, 76, 20, 150 },
#else
	{"Your father was an unknown Titan.  ", 75, 76, 20, 50 },
	{"Your mother was Themis.  ",        80, 76, 20, 100 },
	{"Your mother was Mnemosyne.  ",     85, 76, 20, 100 },
	{"Your father was Okeanoas.  ",      90, 76, 20, 100 },
	{"Your father was Crius.  ",         95, 76, 20, 100 },
	{"Your father was Hyperion.  ",      98, 76, 20, 125 },
	{"Your father was Kronos.  ",       100, 76, 20, 150 },
#endif


#ifdef JP
	{"Ȃ͖̒mʃTCNvX̎qłB", 90, 77, 109, 50 },
	{"Ȃ̓|tFX̎qłB", 98, 77, 109, 80 },
	{"Ȃ̓EmX̎qłB", 100, 77, 109, 135 },
#else
	{"You are the offspring of an unknown Cyclops.  ", 90, 77, 109, 50 },
	{"You are Polyphemos's child.  ", 98, 77, 109, 80 },
	{"You are Uranos's child.  ", 100, 77, 109, 135 },
#endif


#ifdef JP
	{"l̎q̂̈lłB", 100, 79, 80, 50 },

	{"Ȃ̓uEEC[N", 		50, 78, 79, 50 },
	{"Ȃ̓u[EC[N", 		75, 78, 79, 50 },
	{"Ȃ̓}X^[EC[N", 		95, 78, 79, 85 },
	{"Ȃ̓C[N̉w{h[x", 100, 78, 79, 120 },
#else
	{"You are one of several children of ", 100, 78, 79, 50 },

	{"a Brown Yeek. ", 50, 79, 80, 50 },
	{"a Blue Yeek.  ", 75, 79, 80, 50 },
	{"a Master Yeek.  ", 95, 79, 80, 85 },
	{"Boldor, the King of the Yeeks.  ", 100, 79, 80, 120 },
#endif


#ifdef JP
	{"Ȃ͐",    25, 80, 81, 50 },
	{"Ȃ͌铵",    50, 80, 81, 50 },
	{"Ȃ͏ȍ",    75, 80, 81, 50 },
	{"Ȃ͍P",    100, 80, 81, 50 },

	{"̂ȂA",        20, 81, 65, 50 },
	{"ZA",        40, 81, 65, 50 },
	{"A",        60, 81, 65, 50 },
	{"R悤ȐԂA",        80, 81, 65, 50 },
	{"F̂ȂA",        100, 81, 65, 50 },
#else
	{"You have pale eyes, ",    25, 80, 81, 50 },
	{"You have glowing eyes, ",    50, 80, 81, 50 },
	{"You have tiny black eyes, ",    75, 80, 81, 50 },
	{"You have shining black eyes, ",    100, 80, 81, 50 },

	{"no hair at all, ",        20, 81, 65, 50 },
	{"short black hair, ",        40, 81, 65, 50 },
	{"long black hair, ",        60, 81, 65, 50 },
	{"bright red hair, ",        80, 81, 65, 50 },
	{"colourless albino hair, ",        100, 81, 65, 50 },
#endif


#ifdef JP
	{"̉l̎q̂̈lłB ", 100, 83, 80, 50 },

	{"Ȃ̓X[ER{h",   	40, 82, 83, 50 },
	{"Ȃ̓R{h",         		75, 82, 83, 55 },
	{"Ȃ̓[WER{h",   		95, 82, 83, 65 },
	{"Ȃ̓R{h̉wKbVx",   100, 82, 83, 100 },
#else
	{"You are one of several children of ", 100, 82, 83, 50 },

	{"a Small Kobold.  ",   40, 83, 80, 50 },
	{"a Kobold.  ",         75, 83, 80, 55 },
	{"a Large Kobold.  ",   95, 83, 80, 65 },
	{"Mughash, the Kobold Lord.  ",     100, 83, 80, 100 },
#endif


#ifdef JP
	{"Ȃ͏NbR̉l̎q̂̈lłB"
	, 100, 84, 85, 50 },

	{"Ȃ͐Ԃ", 40, 85, 86, 50 },
	{"Ȃ͍", 90, 85, 86, 50 },
	{"Ȃ͉F", 100, 85, 86, 50 },

	{"ڂĂ܂B", 100, 86, 0, 50 },
#else
	{"You are one of several children of a Klackon hive queen.  "
	, 100, 84, 85, 50 },

	{"You have red skin, ", 40, 85, 86, 50 },
	{"You have black skin, ", 90, 85, 86, 50 },
	{"You have yellow skin, ", 100, 85, 86, 50 },

	{"and black eyes.", 100, 86, 0, 50 },
#endif


#ifdef JP
	{"̉l̎q̂̈lłB", 100, 88, 18, 89 },

	{"Ȃ̓j[xO̓z", 30,	87, 88, 20 },
	{"Ȃ̓j[xO̓", 50, 	87, 88, 40 },
	{"Ȃ̓j[xO̒b艮", 70, 	87, 88, 60 },
	{"Ȃ̓j[xO̍Bv", 90, 	87, 88, 75 },
	{"Ȃ̓j[xÕV[}", 95,87, 88, 100 },
	{"Ȃ̓j[xỎw~[x", 100,87, 88, 100 },/*nuke me*/
#else
	{"You are one of several children of ", 100, 87, 88, 89 },

	{"a Nibelung Slave.  ", 30, 88, 18, 20 },
	{"a Nibelung Thief.  ", 50, 88, 18, 40 },
	{"a Nibelung Smith.  ", 70, 88, 18, 60 },
	{"a Nibelung Miner.  ", 90, 88, 18, 75 },
	{"a Nibelung Shaman.  ", 95, 88, 18, 100 },
	{"Mime, the Nibelung.  ", 100, 88, 18, 100 },
#endif

#ifdef JP
	{"Ȃ̓hRjA", 100, 89, 90, 50 },

	{"̒qłB", 30, 135, 91, 55 },
	{"̖qłB", 50, 135, 91, 50 },
	{"̗{qłB", 55, 135, 91, 50 },
	{"̌ǎłB", 60, 135, 91, 45 },
	{"̊l̎q̂̈lłB", 85, 135, 91, 50 },
	{"̈ꗱłB", 100, 135, 91, 55 },

	{"H", 10, 90, 135, 20 },
	{"", 21, 90, 135, 30 },
	{"v", 26, 90, 135, 45 },
	{"b", 42, 90, 135, 45 },
	{"m", 73, 90, 135, 50 },
	{"l", 78, 90, 135, 50 },
	{"El", 85, 90, 135, 55 },
	{"É", 89, 90, 135, 60 },
	{"m", 94, 90, 135, 65 },
	{"pt", 97, 90, 135, 70 },
	{"w", 99, 90, 135, 80 },
	{"M", 100, 90, 135, 100 },

	{"Ȃ", 100, 91, 136, 50 },

	{"͍DF̗ƔAĊDF̕Ă܂B", 11, 136, 0, 50 },
	{"uYF̗ƔAēF̕Ă܂B", 16, 136, 0, 50 },
	{"̗A̔Ă܂B", 24, 136, 0, 50 },
	{"AĂ܂B", 26, 136, 0, 60 },
	{"ƔAĐF̕Ă܂B", 32, 136, 0, 50 },
	{"F̗AFłB", 33, 136, 0, 70 },
	{"F̗AF̔Ă܂B", 37, 136, 0, 45 },
	{"ƔAĔĂ܂B", 41, 136, 0, 50 },
	{"F̗ƔAĔĂ܂B", 48, 136, 0, 50 },
	{"ΐF̗ƔAĉFĂ܂B", 65, 136, 0, 50 },
	{"ΐF̗AΐF̔Ă܂B", 75, 136, 0, 50 },
	{"ԂAԂĂ܂B", 88, 136, 0, 50 },
	{"AĂ܂B", 94, 136, 0, 50 },
	{"߂AIȔĂ܂B", 100, 136, 0, 55},
#else
	{"You are ", 100, 89, 135, 50 },

	{"the oldest child of a Draconian ", 30, 135, 90, 55 },
	{"the youngest child of a Draconian ", 50, 135, 90, 50 },
	{"the adopted child of a Draconian ", 55, 135, 90, 50 },
	{"an orphaned child of a Draconian ", 60, 135, 90, 45 },
	{"one of several children of a Draconian ", 85, 135, 90, 50 },
	{"the only child of a Draconian ", 100, 135, 90, 55 },

	{"Beggar.  ", 10, 90, 91, 20 },
	{"Thief.  ", 21, 90, 91, 30 },
	{"Sailor.  ", 26, 90, 91, 45 },
	{"Mercenary.  ", 42, 90, 91, 45 },
	{"Warrior.  ", 73, 90, 91, 50 },
	{"Merchant.  ", 78, 90, 91, 50 },
	{"Artisan.  ", 85, 90, 91, 55 },
	{"Healer.  ", 89, 90, 91, 60 },
	{"Priest.  ", 94, 90, 91, 65 },
	{"Mage.  ", 97, 90, 91, 70 },
	{"Scholar.  ", 99, 90, 91, 80 },
	{"Noble.  ", 100, 90, 91, 100 },

	{"You have ", 100, 91, 136, 50 },

	{"charcoal wings, charcoal skin and a smoke-gray belly.", 11, 136, 0, 50 },
	{"bronze wings, bronze skin, and a copper belly.", 16, 136, 0, 50 },
	{"golden wings, and golden skin.", 24, 136, 0, 50 },
	{"white wings, and white skin.", 26, 136, 0, 60 },
	{"blue wings, blue skin, and a cyan belly.", 32, 136, 0, 50 },
	{"multi-hued wings, and multi-hued skin.", 33, 136, 0, 70 },
	{"brown wings, and brown skin.", 37, 136, 0, 45 },
	{"black wings, black skin, and a white belly.", 41, 136, 0, 50 },
	{"lavender wings, lavender skin, and a white belly.", 48, 136, 0, 50 },
	{"green wings, green skin and yellow belly.", 65, 136, 0, 50 },
	{"green wings, and green skin.", 75, 136, 0, 50 },
	{"red wings, and red skin.", 88, 136, 0, 50 },
	{"black wings, and black skin.", 94, 136, 0, 50 },
	{"metallic skin, and shining wings.", 100, 136, 0, 55},
#endif



#ifdef JP
	{"Ȃ͈̑Ȃ钷V̔]XłȂrŃI^}WNVƂĐ܂܂BȂ̓kkƋP󋕂ȖڂĂāA", 100, 92, 93, 80 },
	{"̎ɎO{̐G肪Ă܂B", 20, 93, 0, 45 },
	{"̎Ɏl{̐G肪Ă܂B", 80, 93, 0, 50 },
	{"̎Ɍܖ{̐G肪Ă܂B", 100, 93, 0, 55 },
#else
	{"You have slimy skin, empty glowing eyes, and ", 100, 92, 93, 80 },
	{"three tentacles around your mouth.", 20, 93, 0, 45 },
	{"four tentacles around your mouth.", 80, 93, 0, 50 },
	{"five tentacles around your mouth.", 100, 93, 0, 55 },
#endif


#ifdef JP
	{"Ȃ̑c", 100, 94, 95, 50 },

	{"SȂn̒ዉȐłB", 30, 95, 96, 20 },
	{"łB", 60, 95, 96, 50 },
	{"㋉łB", 90, 95, 96, 75 },
	{"łB", 100, 95, 96, 99 },

	{"Ȃ͐Ԃ", 50, 96, 97, 50 },
	{"Ȃ͒F", 100, 96, 97, 50},

	{"ԂR铵ĂāA܂ƉƎhĂ܂B", 40, 97, 0, 50 },
	{"ԂR铵ĂāA܂Ɖ傪Ă܂B", 70, 97, 0, 50 },
	{"ԂR铵ĂāA܂Ă܂B", 100, 97, 0, 50 },
#else
	{"You ancestor was ", 100, 94, 95, 50 },

	{"a mindless demonic spawn.  ", 30, 95, 96, 20 },
	{"a minor demon.  ", 60, 95, 96, 50 },
	{"a major demon.  ", 90, 95, 96, 75 },
	{"a demon lord.  ", 100, 95, 96, 99 },

	{"You have red skin, ", 50, 96, 97, 50 },
	{"You have brown skin, ", 100, 96, 97, 50},

	{"claws, fangs, spikes, and glowing red eyes.", 40, 97, 0, 50 },
	{"claws, fangs, and glowing red eyes.", 70, 97, 0, 50 },
	{"claws, and glowing red eyes.", 100, 97, 0, 50 },
#endif


#ifdef JP
	{"Ȃ̓Jo̔pɂ", 40,	98, 99, 50 },
	{"Ȃ͖@gɂ", 65, 	98, 99, 50 },
	{"Ȃ͘Bptɂ",	     90,	98, 99, 50},
	{"Ȃ͑mɂ", 100,	98, 99, 60},

	{"Ɛ키߂", 10, 99, 100, 65 },
	{"",		 100,  99, 100, 50 },

	{"Sy", 40, 100, 101, 50 },
	{"΂", 80, 100, 101, 50 },
	{"؂", 85, 100, 101, 40 },
	{"S", 99, 100, 101, 50 },
	{"", 100, 100, 101, 100},

	{"o܂B", 100,101, 0, 50 },
#else
	{"You were shaped from ", 100, 98, 99, 50 },

	{"clay ", 40, 99, 100, 50 },
	{"stone ", 80, 99, 100, 50 },
	{"wood ", 85, 99, 100, 40 },
	{"iron ", 99, 99, 100, 50 },
	{"pure gold ", 100, 99, 100, 100},

	{"by a Kabbalist", 40, 100, 101, 50 },
	{"by a Wizard", 65, 100, 101, 50 },
	{"by an Alchemist", 90, 100, 101, 50},
	{"by a Priest", 100, 100, 101, 60},

	{" to fight evil.", 10, 101, 0, 65 },
	{".", 100, 101, 0, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 102, 103, 50 },

	{"pmɂo܂B", 30, 103, 104, 50 },
	{"@̎ɂo܂B", 50, 103, 104, 50 },
	{"׈ȑmɂo܂B", 70, 103, 104, 50 },
	{"Ƃ̌_ɂ萶ݏo܂B", 75, 103, 104, 50 },
	{"삩琶܂܂B", 85, 103, 104, 50 },
	{"􂢂琶܂܂B", 95, 103, 104, 30 },
	{"_pɂ萶ݏo܂B", 100, 103, 104, 50 },

	{"Ȃ", 100, 104, 105, 50 },
	{"ÂꂽŏoĂāA", 40, 105, 106, 50 },
	{"ŏoĂāA", 60, 105, 106, 50 },
	{"ꂽFŏoĂāA", 80, 105, 106, 50 },
	{"PŏoĂāA", 100, 105, 106, 50 },

	{"ڂĂ܂B", 30, 106, 0, 50 },
	{"n̍΂RڂĂ܂B", 50, 106, 0, 50 },
	{"|͂ۂłB", 100, 106, 0, 50 },
#else
	{"You were created by ", 100, 102, 103, 50 },

	{"a Necromancer.  ", 30, 103, 104, 50 },
	{"a magical experiment.  ", 50, 103, 104, 50 },
	{"an Evil Priest.  ", 70, 103, 104, 50 },
	{"a pact with the demons.  ", 75, 103, 104, 50 },
	{"a restless spirit.  ", 85, 103, 104, 50 },
	{"a curse.  ", 95, 103, 104, 30 },
	{"an oath.  ", 100, 103, 104, 50 },

	{"You have ", 100, 104, 105, 50 },
	{"dirty, dry bones, ", 40, 105, 106, 50 },
	{"rotten black bones, ", 60, 105, 106, 50 },
	{"filthy, brown bones, ", 80, 105, 106, 50 },
	{"shining white bones, ", 100, 105, 106, 50 },

	{"and glowing eyes.", 30, 106, 0, 50 },
	{"and eyes which burn with hellfire.", 50, 106, 0, 50 },
	{"and empty eyesockets.", 100, 106, 0, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 107, 108, 50 },

	{"pmɂ萶ݏo܂B", 30, 108, 62, 50 },
	{"@gɂ萶ݏo܂B", 50, 108, 62, 50 },
	{"삩琶܂܂B",60, 108, 62, 50 },
	{"׈ȑmɂ萶ݏo܂B", 70, 108, 62, 50 },
	{"Ƃ̌_ɂ萶ݏo܂B", 80, 108, 62, 50 },
	{"􂢂琶܂܂B", 95, 108, 62, 30 },
	{"_pɂ萶ݏo܂B", 100, 108, 62, 50 },

	{"Ȃ͈ÊF̓A",               20, 109, 110, 50},
	{"Ȃ͊F̓A",                    60, 109, 110, 50},
	{"Ȃ͔F̓A",                    70, 109, 110, 50},
	{"Ȃ͗ΐF̓A",                    80, 109, 110, 50},
	{"Ȃ͐A",                     90, 109, 110, 50},
	{"Ȃ͒WF̓A",               100, 109, 110, 50}, /*tansei.cc.u-tokyo̗R */

	{"Ȃ߂炩",                        70, 110, 111, 50},
	{"gł",                            90, 110, 111, 50},
	{"J[",                          100, 110, 111, 50},

	{"A",                         30, 111, 112, 50},
	{"FA",                         70, 111, 112, 50},
	{"ԒF̔A",                        80, 111, 112, 50},
	{"ԂA",                       90, 111, 112, 50},
	{"A",                        100, 111, 112, 50},

	{"ĂƂĂÂĂ܂B",              10, 112, 0, 50},
	{"ĈÂĂ܂B",                   30, 112, 0, 50},
	{"ĕϓIȔ̐FĂ܂B",               80, 112, 0, 50},
	{"ČF̂Ă܂B",                   90, 112, 0, 50},
	{"ĂƂĂF̂Ă܂B",             100, 112, 0, 50},
#else
	{"You were created by ", 100, 107, 108, 50 },

	{"a Necromancer.  ", 30, 108, 62, 50 },
	{"a Wizard.  ", 50, 108, 62, 50 },
	{"a restless spirit.  ",60, 108, 62, 50 },
	{"an Evil Priest.  ", 70, 108, 62, 50 },
	{"a pact with the demons.  ", 80, 108, 62, 50 },
	{"a curse.  ", 95, 108, 62, 30 },
	{"an oath.  ", 100, 108, 62, 50 },

	{"You have a dark brown eye, ",               20, 109, 110, 50},
	{"You have a brown eye, ",                    60, 109, 110, 50},
	{"You have a hazel eye, ",                    70, 109, 110, 50},
	{"You have a green eye, ",                    80, 109, 110, 50},
	{"You have a blue eye, ",                     90, 109, 110, 50},
	{"You have a blue-gray eye, ",               100, 109, 110, 50},

	{"straight ",                        70, 110, 111, 50},
	{"wavy ",                            90, 110, 111, 50},
	{"curly ",                          100, 110, 111, 50},

	{"black hair, ",                         30, 111, 112, 50},
	{"brown hair, ",                         70, 111, 112, 50},
	{"auburn hair, ",                        80, 111, 112, 50},
	{"red hair, ",                       90, 111, 112, 50},
	{"blond hair, ",                        100, 111, 112, 50},

	{"and a very dark complexion.",              10, 112, 0, 50},
	{"and a dark complexion.",                   30, 112, 0, 50},
	{"and an average complexion.",               80, 112, 0, 50},
	{"and a fair complexion.",                   90, 112, 0, 50},
	{"and a very fair complexion.",             100, 112, 0, 50},
#endif


#ifdef JP
	{"Ȃ͖̂Ȃ̒S܂B", 20, 113, 114, 50 },
	{"Ȃ͐O̕SłAȃopCAE[h̉aHƂȂĂ܂܂B", 40, 113, 114, 50 },
	{"Ȃ͐O̓opCAEn^[łAނ̉aHƂȂĂ܂܂B", 60, 113, 114, 50 },
	{"Ȃ͐O͎pmłB", 80, 113, 114, 50 },
	{"Ȃ͐O͋ȋMłB", 95, 113, 114, 50 },
	{"Ȃ͐O͋ŎcEȐꐧNłB", 100, 113, 114, 50 },
#else
	{"You arose from an unmarked grave.  ", 20, 113, 114, 50 },
	{"In life you were a simple peasant, the victim of a powerful Vampire Lord.  ", 40, 113, 114, 50 },
	{"In life you were a Vampire Hunter, but they got you.  ", 60, 113, 114, 50 },
	{"In life you were a Necromancer.  ", 80, 113, 114, 50 },
	{"In life you were a powerful noble.  ", 95, 113, 114, 50 },
	{"In life you were a powerful and cruel tyrant.  ", 100, 113, 114, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 114, 115, 50 },

	{"̔A", 25, 115, 116, 50 },
	{"ꂽuE̔A", 50, 115, 116, 50 },
	{"A", 75, 115, 116, 50 },
	{"̂ȂA", 100, 115, 116, 50 },
#else
	{"You have ", 100, 114, 115, 50 },

	{"jet-black hair, ", 25, 115, 116, 50 },
	{"matted brown hair, ", 50, 115, 116, 50 },
	{"white hair, ", 75, 115, 116, 50 },
	{"a hairless head, ", 100, 115, 116, 50 },
#endif


#ifdef JP
	{"RΒŶ悤ȓA", 25, 116, 117, 50 },
	{"̂ȂځA", 50, 116, 117, 50 },
	{"\ȉFA", 75, 116, 117, 50 },
	{"ԂA", 100, 116, 117, 50 },

	{"Ďl̂悤ɐ߂Ă܂B", 100, 117, 0, 50 },
#else
	{"eyes like red coals, ", 25, 116, 117, 50 },
	{"blank white eyes, ", 50, 116, 117, 50 },
	{"feral yellow eyes, ", 75, 116, 117, 50 },
	{"bloodshot red eyes, ", 100, 116, 117, 50 },

	{"and a deathly pale complexion.", 100, 117, 0, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 118, 119, 50 },

	{"pmɂo܂B", 30, 119, 134, 50 },
	{"@̎ɂo܂B", 50, 119, 134, 50 },
	{"׈ȑmɂo܂B", 70, 119, 134, 50 },
	{"Ƃ̌_ɂ萶ݏo܂B", 75, 119, 134, 50 },
	{"삩琶܂܂B", 85, 119, 134, 50 },
	{"􂢂琶܂܂B", 95, 119, 134, 30 },
	{"_pɂ萶ݏo܂B", 100, 119, 134, 50 },
#else
	{"You were created by ", 100, 118, 119, 50 },

	{"a Necromancer.  ", 30, 119, 134, 50 },
	{"a magical experiment.  ", 50, 119, 134, 50 },
	{"an Evil Priest.  ", 70, 119, 134, 50 },
	{"a pact with the demons.  ", 75, 119, 134, 50 },
	{"a restless spirit.  ", 85, 119, 134, 50 },
	{"a curse.  ", 95, 119, 134, 30 },
	{"an oath.  ", 100, 119, 134, 50 },
#endif


#ifdef JP
	{"̔A", 25, 120, 121, 50 },
	{"ꂽuE̔A", 50, 120, 121, 50 },
	{"A", 75, 120, 121, 50 },
	{"̂ȂA", 100, 120, 121, 50 },
#else
	{"jet-black hair, ", 25, 120, 121, 50 },
	{"matted brown hair, ", 50, 120, 121, 50 },
	{"white hair, ", 75, 120, 121, 50 },
	{"a hairless head, ", 100, 120, 121, 50 },
#endif


#ifdef JP
	{"RΒŶ悤ȓA", 25, 121, 122, 50 },
	{"̂ȂځA", 50, 121, 122, 50 },
	{"\ȉFA", 75, 121, 122, 50 },
	{"ԂA", 100, 121, 122, 50 },
#else
	{"eyes like red coals, ", 25, 121, 122, 50 },
	{"blank white eyes, ", 50, 121, 122, 50 },
	{"feral yellow eyes, ", 75, 121, 122, 50 },
	{"bloodshot red eyes, ", 100, 121, 122, 50 },
#endif


#ifdef JP
	{"Ďl̂悤ȓyF̔Ă܂B", 100, 122, 123, 50 },
	{"Ȃ̎ɂ͕sCȗΐF̃I[Ă܂B", 100, 123, 0, 50 },
#else
	{" and a deathly gray complexion. ", 100, 122, 123, 50 },
	{"An eerie green aura surrounds you.", 100, 123, 0, 50 },
#endif


#ifdef JP
	{"Ȃ̗e", 100, 124, 125, 50 },

	{"sNV[łB", 20, 125, 126, 35 },
	{"jNV[łB", 30, 125, 126, 25 },
	{"X̗dłB", 75, 125, 126, 50 },
	{"X̐łB", 90, 125, 126, 75 },
	{"d̋MłB", 100, 125, 126, 85 }, /*nuke me J^Jîق */
#else
	{"Your parents were ", 100, 124, 125, 50 },

	{"pixies.  ", 20, 125, 126, 35 },
	{"nixies.  ", 30, 125, 126, 25 },
	{"wood sprites.  ", 75, 125, 126, 50 },
	{"wood spirits.  ", 90, 125, 126, 75 },
	{"noble faerie folk.  ", 100, 125, 126, 85 },
#endif


#ifdef JP
	{"Ȃ͔wɃCgu[̉HĂāA", 100, 126, 127, 50 },

	{"Ȃ߂炩ȋA",                        80, 127, 128, 50},
	{"głA",                            100, 127, 128, 50},

	{"AĔɐƂĂ܂B", 100, 128, 0, 50},
#else
	{"You have light blue wings attached to your back, ", 100, 126, 127, 50 },

	{"straight blond hair, ",                        80, 127, 128, 50},
	{"wavy blond hair, ",                            100, 127, 128, 50},

	{"blue eyes, and a very fair complexion.", 100, 128, 0, 50},
#endif


#ifdef JP
	{"Ȃ͖@̎ɂ萶ݏo܂B", 30, 129, 130, 40},
	{"Ȃ͎qAɂOXɓ˂ł܂܂B",
	50, 129, 130, 50 }, /*nuke me*/
	{"JIX̖VтłȂグ܂B",
	60, 129, 130, 60 },
	{"Ȃ͖@ɂ|킳ꂽƐlԂ̎qłB", 75, 129, 130, 50},
	{"Ȃ͌܂JIX̖̐`IȊ|킹ɂ萶܂܂B", 100, 129, 130, 30},
#else
	{"You were produced by a magical experiment.  ", 30, 129, 130, 40},
	{"In your childhood, you were stupid enough to stick your head in raw Logrus.  ",
	50, 129, 130, 50 },
	{"A Demon Lord of Chaos decided to have some fun, and so he created you.  ",
	60, 129, 130, 60 },
	{"You are the magical crossbreed of an animal and a man.  ", 75, 129, 130, 50},
	{"You are the blasphemous crossbreed of unspeakable creatures of chaos.  ", 100, 129, 130, 30},
#endif



#ifdef JP
	{"Ȃ͗ΐF঒ނ̖",              60, 130, 131, 50},
	{"Ȃ͍̖",                    85, 130, 131, 50},
	{"Ȃ̓IWF̔L̖",            99, 130, 131, 50},
	{"Ȃ͔R悤Ȉ̖",          100, 130, 131, 55},
#else
	{"You have green reptilian eyes, ",              60, 130, 131, 50},
	{"You have the black eyes of a bird, ",              85, 130, 131, 50},
	{"You have the orange eyes of a cat, ",               99, 130, 131, 50},
	{"You have the fiery eyes of a demon, ",             100, 130, 131, 55},
#endif


#ifdef JP

	{"Ɣ̂ȂA",                 10, 131, 133, 50},
	{"ĂāA",                     33, 131, 132, 50},
	{"ĂāA݂ڂ炵",             66, 131, 132, 50},
	{"ĂāAĂ",                100, 131, 132, 50},
#else
	{"no hair at all, ",                 10, 131, 133, 50 },
	{"dirty ",                           33, 131, 132, 50},
	{"mangy ",                           66, 131, 132, 50},
	{"oily ",                           100, 131, 132, 50},
#endif


#ifdef JP

	{"F̖є",                    33, 132, 133, 50},
	{"DF̖є",                    66, 132, 133, 50},
	{"є",                     100, 132, 133, 50},
#else
	{"brown fur, ",                    33, 132, 133, 50},
	{"gray fur, ",                    66, 132, 133, 50},
	{"albino fur, ",                  100, 132, 133, 50},
#endif


#ifdef JP
	{"Rr̒܂B",      50, 133, 0, 50 },
	{"lԂ̑Ă܂B",  75, 133, 0, 50 },
	{"̑Ă܂B",    85, 133, 0, 50 },
	{"঒ނ̑Ă܂B",90, 133, 0, 50 },
	{"̑Ă܂B",    95, 133, 0, 50 },
	{"L̑Ă܂B",    97, 133, 0, 50 },
	{"̑Ă܂B",   100, 133, 0, 50 },

	{"Ȃ", 100, 134, 120, 50 },
#else
	{"and the hooves of a goat.",      50, 133, 0, 50 },
	{"and human feet.",        75, 133, 0, 50 },
	{"and bird's feet.",       85, 133, 0, 50 },
	{"and reptilian feet.",    90, 133, 0, 50 },
	{"and bovine feet.",       95, 133, 0, 50 },
	{"and feline feet.",       97, 133, 0, 50 },
	{"and canine feet.",       100, 133, 0, 50 },

	{"You have ", 100, 134, 120, 50 },
#endif


#ifdef JP
	{"ss̎qłB", 25, 138, 139, 40},
	{"܂悤qłB", 50, 138, 139, 50},
	{"B̎qłB", 75, 138, 139, 60},
	{"ĂqłB", 100, 138, 139, 70},
#else
	{"You are the lost offspring of ", 25, 137, 138, 40},
	{"You are the wandering offspring of ", 50, 137, 138, 50},
	{"You are the only offspring of ", 75, 137, 138, 60},
	{"You are the beloved offspring of ", 100, 137, 138, 70},
#endif


#ifdef JP
	{"Ȃ͖mʃGg", 10, 137, 138, 35},
	{"Ȃ͌ǓƂȃGg", 35, 137, 138, 50},
	{"Ȃ̓Gg̈c̈", 55, 137, 138, 60},
	{"Ȃ͔ɉhĂGg̎Љ̃[_[", 70, 137, 138, 70},
	{"Ȃ̓Gg̐X̒", 81, 137, 138, 80},
	{"Ȃ͑hĂGǧ҂", 91, 137, 138, 90},
	{"Ȃ͍ł͒ǉ̒ɂȂGg", 96, 137, 138, 100},
	{"Ȃ̓t@S̐l", 100, 137, 138, 110},
#else
	{"an Ent whose name you have no recollection of.  ", 10, 138, 139, 35},
	{"a solitary Ent.  ", 35, 138, 139, 50},
	{"a member of a farflung Entish band.  ", 55, 138, 139, 60},
	{"a leader of a prosperous community of Ents.  ", 70, 138, 139, 70},
	{"an Entish Forestwarden.  ", 81, 138, 139, 80},
	{"a respected Entish sage.  ", 91, 138, 139, 90},
	{"an Entwife whose memory men cherish.  ", 96, 138, 139, 100},
	{"Fangorn himself.  ", 100, 138, 139, 110},
#endif

#ifdef JP
	{"Ȃ", 100, 139, 140, 50},
#else
	{"You have ", 100, 139, 140, 50},
#endif

#ifdef JP
	{"O{̎wA", 5, 140, 141, 50},
	{"l{̎wA", 20, 140, 141, 50},
	{"ܖ{̎wA", 40, 140, 141, 50},
	{"Z{̎wA", 60, 140, 141, 50},
	{"{̎wA", 80, 140, 141, 50},
	{"{̎wA", 95, 140, 141, 50},
	{"{̎wA", 100, 140, 141, 50},
#else
	{"three fingers and toes, and are covered in ", 5, 140, 141, 50},
	{"four fingers and toes, and are covered in ", 20, 140, 141, 50},
	{"five fingers and toes, and are covered in ", 40, 140, 141, 50},
	{"six fingers and toes, and are covered in ", 60, 140, 141, 50},
	{"seven fingers and toes, and are covered in ", 80, 140, 141, 50},
	{"eight fingers and toes, and are covered in ", 95, 140, 141, 50},
	{"nine fingers and toes, and are covered in ", 100, 140, 141, 50},
#endif
#ifdef JP
	{"F؏̔ɕĂ܂B", 10, 141, 0, 50},
	{"F̍rɕĂ܂B", 20, 141, 0, 50},
	{"DF̂Ȃ߂炩ȔɕĂ܂B", 30, 141, 0, 50},
	{"[O[̔ɕĂ܂B", 40, 141, 0, 50},
	{"ۂŕꂽĂ܂B", 50, 141, 0, 50},
	{"[uE̔ɕĂ܂B", 60, 141, 0, 50},
	{"p[uẼpTpT̔ɕĂ܂B", 70, 141, 0, 50},
	{"`R[gF̖LȔɕĂ܂B", 80, 141, 0, 50},
	{"؏̔ɕĂ܂B", 90, 141, 0, 50},
	{"قƂǂЂтAɕĂ܂B", 100, 141, 0, 50},
#else
	{"scaly brown skin.", 10, 141, 0, 50},
	{"rough brown skin.", 20, 141, 0, 50},
	{"smooth grey skin.", 30, 141, 0, 50},
	{"dark green skin.", 40, 141, 0, 50},
	{"mossy skin.", 50, 141, 0, 50},
	{"deep brown skin.", 60, 141, 0, 50},
	{"pale brown, flaky skin.", 70, 141, 0, 50},
	{"rich chocolate-colored skin.", 80, 141, 0, 50},
	{"ridged black skin.", 90, 141, 0, 50},
	{"thick, almost corky skin.", 100, 141, 0, 50},
#endif

#ifdef JP
	{"Ȃ͓VE̎lłB", 100, 142, 143, 80},
	{"Ȃ͈łڂ߂ɂ̒nɑĂ܂B", 100, 143, 144, 80},
	{"̖ړI𐬂܂ł͋xނƂ͋܂B", 100, 144, 0, 80},
#else
	{"You are of the blessed host of heaven.  ", 100, 142, 143, 80},
	{"You have been sent to earth to eradicate the wicked, ", 100, 143, 144, 80},
	{"and shall not rest until you have succeeded.", 100, 144, 0, 80},
#endif

#ifdef JP
	{"Ȃ͒n̎ꂽqłB", 100, 145, 146, 20},
	{"Ȃ̓O[^[Ef[̋C܂ɂĐ܂܂B", 100, 146, 147, 20},
	{"Ȃ͕Q̋@Ă܂B", 100, 147, 0, 20},
#else
	{"You are of the cursed spawn of hell. ", 100, 145, 146, 20},
	{"You have been cast out by the whim of the greater demons, ", 100, 146, 147, 20},
	{"and now seek revenge.", 100, 147, 0, 20},
#endif



#ifdef JP
	{"Ȃ͑f̒mȂ",  5, 148, 149, 25},
	{"Ȃ͕ߗ", 20, 148, 149, 35},
	{"Ȃ͐m", 40, 148, 149, 45},
	{"Ȃ̓W[", 50, 148, 149, 50},
	{"Ȃ͏L", 70, 148, 149, 65},
	{"Ȃ͖", 83, 148, 149, 75},
	{"Ȃ͘Bpt", 93, 148, 149, 90},
	{"Ȃ͋M̏", 98, 148, 149, 110},
	{"Ȃ͏", 100, 148, 149, 140},
#else
	{"whose identity you are uncertain of.",  5, 149, 8, 25},
	{"Captive.  ", 20, 149, 150, 35},
	{"Fighter.  ", 40, 149, 150, 45},
	{"Ranger.  ", 50, 149, 150, 50},
	{"Scribe.  ", 70, 149, 150, 65},
	{"Witch.  ", 83, 149, 150, 75},
	{"Alchemist.  ", 93, 149, 150, 90},
	{"Lady.  ", 98, 149, 150, 110},
	{"Queen.  ", 100, 149, 150, 140},
#endif
#ifdef JP
	{"etFA[̎łB", 10, 149, 150, 35},
	{"etFA[̊l̎q̂̈lłB", 30, 149, 150, 45},
	{"etFA[̑qłB", 55, 149, 150, 50},
	{"etFA[̒qłB", 80, 149, 150, 55},
	{"etFA[̈ꗱłB", 100, 149, 150, 60},
#else
	{"You are the bastard child of a Shadow-Fairy ", 10, 148, 149, 35},
	{"You are one of several children of a Shadow-Fairy ", 30, 148, 149, 45},
	{"You are the second child of a Shadow-Fairy ", 55, 148, 149, 50},
	{"You are the first child of a Shadow-Fairy ", 80, 148, 149, 55},
	{"You are the only child of a Shadow-Fairy ", 100, 148, 149, 60},
#endif


#ifdef JP
	{"Ȃ͍", 10, 150, 151, 50},
	{"Ȃ͐[uE̓", 25, 50, 151, 50},
	{"Ȃ̓uE̓", 60, 150, 151, 50},
	{"Ȃ͒WF̓", 70, 150, 151, 50},
	{"Ȃ̓O[̓", 80, 150, 151, 50},
	{"Ȃ͐", 90, 150, 151, 50},
	{"Ȃ̓u[OC̓", 100, 150, 151, 50},
#else
	{"You have black eyes, straight ", 10, 150, 151, 50},
	{"You have dark brown eyes, straight ", 25, 50, 151, 50},
	{"You have brown eyes, straight ", 60, 150, 151, 50},
	{"You have hazel eyes, straight ", 70, 150, 151, 50},
	{"You have green eyes, straight ", 80, 150, 151, 50},
	{"You have blue eyes, straight ", 90, 150, 151, 50},
	{"You have blue-gray eyes, straight ", 100, 150, 151, 50},
#endif

#ifdef JP
	{"O[̔A", 30, 152, 153, 50},
	{"̔A", 70, 152, 153, 50},
	{"p[CG[̔A", 80, 152, 153, 50},
	{"DF̔A", 90, 152, 153, 50},
	{"p[uE̔A", 100, 152, 153, 50},
#else
	{"grey hair ", 30, 151, 152, 50},
	{"pure white hair ", 70, 151, 152, 50},
	{"pale yellow hair ", 80, 151, 152, 50},
	{"grey-white hair ", 90, 151, 152, 50},
	{"pale brown hair ", 100, 151, 152, 50},
#endif

#ifdef JP
	{"킸Ɍɂ邭炢̂Ȃ߂炩", 30, 151, 152, 50},
	{"r܂œ͂炢̂Ȃ߂炩", 60, 151, 152, 55},
	{"܂łȂ߂炩", 90, 151, 152, 60},
	{"瑫܂ŋP̂悤ɂȂ߂炩", 100, 151, 152, 75},
#else
	{"that barely covers your shoulders, ", 30, 152, 153, 50},
	{"that reaches to your arms, ", 60, 152, 153, 55},
	{"that flows down to your waist, ", 90, 152, 153, 60},
	{"that forms a shining waterfall from head to foot, ", 100, 152, 153, 75},
#endif

#ifdef JP
	{"ʂ悤ȔĂ܂B", 20, 153, 0, 50},
	{"~NF̔Ă܂B", 35, 153, 0, 50},
	{"^F̔Ă܂B", 50, 153, 0, 50},
	{"Ă܂B", 85, 153, 0, 50},
	{"Ă܂B", 100, 153, 0, 50},
#else
	{"and an extremely fair complexion.", 20, 153, 0, 50},
	{"and a milky complexion.", 35, 153, 0, 50},
	{"and a pearly complexion.", 50, 153, 0, 50},
	{"and a pale complexion.", 85, 153, 0, 50},
	{"and an utterly white complexion.", 100, 153, 0, 50},
#endif

#ifdef JP
	{"Ȃ͕iUNUNfU[gŗVłA", 4, 154, 159, 50},
	{"Ȃ͕iOO^[ŗVłA", 8, 154, 159, 50},
	{"Ȃ͕izwzwJŗVłA", 12, 154, 159, 50},
	{"Ȃ͕ihvhvrŗVłA", 16, 154, 159, 50},
	{"Ȃ͕ieNeNGZŗVłA", 20, 154, 159, 50},
	{"Ȃ͕ittŗVłA", 24, 154, 159, 50},
	{"Ȃ͕iNmNmŗVłA", 28, 154, 159, 50},
	{"Ȃ͕iNNŗVłA", 32, 154, 159, 50},
	{"Ȃ͕ieeLvŗVłA", 36, 154, 159, 50},
	{"Ȃ͕iN^[OŗVłA", 40, 154, 159, 50},
	{"Ȃ͕ieNmŗVłA", 44, 154, 159, 50},
	{"Ȃ͕ieNmAChŗVłA", 48, 154, 159, 50},
	{"Ȃ͕ieNm}ŗVłA", 52, 154, 159, 50},
	{"Ȃ͕ieNmh[ŗVłA", 56, 154, 159, 50},
	{"Ȃ͕ieNmz[ŗVłA", 60, 154, 159, 50},
	{"Ȃ͕ieNmŗVłA", 64, 154, 159, 50},
	{"Ȃ͕ieNmsقŗVłA", 68, 154, 159, 50},
	{"Ȃ͕ieNmŗVłA", 72, 154, 159, 50},
	{"Ȃ͕iXCXCAvXŗVłA", 76, 154, 159, 65},
	{"Ȃ͕iq\q\XŗVłA", 80, 154, 159, 65},
	{"Ȃ͕ieNmԌŗVłA", 84, 154, 159, 65},
	{"Ȃ͕ieNmPbgˑŗVłA", 88, 154, 159, 65},
	{"Ȃ͕i`CiEH[ŗVłA", 92, 154, 159, 65},
	{"Ȃ͕iXy[XEH[ŗVłA", 96, 154, 159, 70},
	{"Ȃ͕ieNm][gzeŗVłA", 100, 154, 159, 75},

	{"ʂ̃N^[łB", 70, 159, 160, 50},
	{"݂ȂɂĂeN^[łB", 85, 159, 160, 65},
	{"Dȃp_N^[łB", 92, 159, 161, 75},
	{"ƂĂgN^[łB", 96, 159, 162, 80},
	{"ƂĂsJN^[łB", 100, 159, 163, 90},

	{"Ȃ͐ԐF̖тA", 6, 160, 164, 50},
	{"Ȃ̓N[F̖тA", 12, 160, 164, 50},
	{"Ȃ͉yF̖тA", 18, 160, 164, 50},
	{"Ȃ͉F̖тA", 24, 160, 164, 50},
	{"Ȃ͉ΐF̖тA", 30, 160, 164, 50},
	{"Ȃ͖F̖тA", 36, 160, 164, 50},
	{"Ȃ͔ZΐF̖тA", 42, 160, 164, 50},
	{"Ȃ͐ΐF̖тA", 48, 160, 164, 50},
	{"Ȃ͐F̖тA", 54, 160, 164, 50},
	{"Ȃ͔F̖тA", 60, 160, 164, 50},
	{"Ȃ͎F̖тA", 65, 160, 164, 50},
	{"Ȃ͈F̖тA", 70, 160, 164, 60},
	{"Ȃ̓sNF̖тA", 75, 160, 164, 60},
	{"Ȃ͔F̖тA", 80, 160, 164, 60},
	{"Ȃ͐F̖тA", 85, 160, 164, 65},
	{"Ȃ͍F̖тA", 90, 160, 164, 65},
	{"Ȃ͗ΐF̖тA", 95, 160, 164, 65},
	{"Ȃ͞F̖тA", 100, 160, 164, 70},
	{"Ȃ̓p_̂悤Ȕƍ̔͗l̖тA", 100, 161, 164, 70},
	{"Ȃ̓ĝ悤ȉƍ̎Ȗ͗l̖тA", 100, 162, 164, 70},
	{"Ȃ͖邭PĂāA", 100, 163, 164, 70},

	{"}t[󕨂ɂĂ܂B", 4, 164, 0, 50},
	{"C^[󕨂ɂĂ܂B", 8, 164, 0, 50},
	{"R󕨂ɂĂ܂B", 12, 164, 0, 50},
	{"ʂ󕨂ɂĂ܂B", 16, 164, 0, 50},
	{"r󕨂ɂĂ܂B", 20, 164, 0, 50},
	{"r̂ӂ󕨂ɂĂ܂B", 24, 164, 0, 50},
	{"싅X󕨂ɂĂ܂B", 28, 164, 0, 50},
	{"ւ󕨂ɂĂ܂B", 32, 164, 0, 50},
	{"obg󕨂ɂĂ܂B", 36, 164, 0, 50},
	{"卪󕨂ɂĂ܂B", 40, 164, 0, 50},
	{"bNTbN󕨂ɂĂ܂B", 44, 164, 0, 50},
	{"Ղ󕨂ɂĂ܂B", 48, 164, 0, 50},
	{"̋󕨂ɂĂ܂B", 52, 164, 0, 50},
	{"P󕨂ɂĂ܂B", 56, 164, 0, 50},
	{"₩󕨂ɂĂ܂B", 60, 164, 0, 50},
	{"ق󕨂ɂĂ܂B", 64, 164, 0, 50},
	{"eBbV󕨂ɂĂ܂B", 68, 164, 0, 50},
	{"_}󕨂ɂĂ܂B", 71, 164, 0, 50},
	{"jW󕨂ɂĂ܂B", 75, 164, 0, 60},
	{"z󕨂ɂĂ܂B", 79, 164, 0, 60},
	{"݂񔠂󕨂ɂĂ܂B", 83, 164, 0, 60},
	{"󔠂󕨂ɂĂ܂B", 86, 164, 0, 60},
	{"eKnbg󕨂ɂĂ܂B", 90, 164, 0, 60},
	{"At󕨂ɂĂ܂B", 94, 164, 0, 65},
	{"Ⴏ󕨂ɂĂ܂B", 97, 164, 0, 65},
	{"39{E󕨂ɂĂ܂B", 100, 164, 0, 70},

#else
	{"You are a normal Kutar.  You have orange colored fur.", 65, 154, 0, 55},
	{"You are a father Kutar, the patriarch of many normal Kutars.  You have green colored fur.", 95, 154, 0, 65},
	{"You are a very rare type of Kutar, famed for the yellow and black stripes on your body.", 100, 154, 0, 80},
#endif

#ifdef JP
	{"Ȃ͂vWFNg̎iƂ", 10, 155, 156, 50},
	{"Ȃ͎q炷邽߂", 30, 155, 156, 60},
	{"Ȃ͐g̉̐b邽߂", 50, 155, 156, 70},
	{"Ȃ͖SȂq̐gƂ", 60, 155, 156, 10},
	{"Ȃ͐퓬pAhChƂ", 90, 155, 156, 20},
	{"Ȃ͐Ê߂̓Ƃ", 100, 155, 156, 10},

	{"C̋Ȋw҂ɂč܂B", 20, 156, 157, 10},
	{"Ƃ̌ō܂B", 50, 156, 157, 80},
	{"a肤Ȋw҂ɂč܂B", 85, 156, 157, 50},
	{"l̓VˏNɂč܂B", 90, 156, 157, 30},
	{"22Iė܂B", 100, 156, 157, 100},

	{"lR̂悤Ȍ`", 15, 157, 158, 40},
	{"Ck̂悤Ȍ`", 30, 157, 158, 30},
	{"N^[̂悤Ȍ`", 45, 157, 158, 20},
	{"lԂ̂悤Ȍ`", 70, 157, 158, 60},
	{"h[t̂悤Ȍ`", 80, 157, 158, 70},
	{"zrbĝ悤Ȍ`", 90, 157, 158, 70},
	{"Gt̂悤Ȍ`", 100, 157, 158,  80},

	{"܂A̓lY~ɂĂȂȂĂ܂B", 5, 158, 0, 20},
	{"ƍ҂͎咣Ă܂AƂĂ͌܂B", 20, 158, 0, 30},
	{"܂B", 85, 158, 0, 50},
	{"āA{l͎̂Ƃ{ƐMĂ܂B", 95, 158, 0, 50},
	{"āAɂ悭łĂ̂Ŗ{ƌ܂B", 100, 158, 0, 100},
#else
	{"You were created by a mad scientist ", 20, 155, 156, 10},
	{"You were created in a corporate laboratory ", 50, 155, 156, 80},
	{"You were created by a peace-loving scientist ", 85, 155, 156, 50},
	{"You were created by a boy genius ", 90, 155, 156, 30},
	{"You have come from the twenty-second century ", 100, 155, 156, 100},

	{"as a project prototype. ", 10, 156, 157, 50},
	{"to educate children. ", 30, 156, 157, 60},
	{"to look after someone. ", 50, 156, 157, 70},
	{"as a substitute for a dead child. ", 60, 156, 157, 10},
	{"as a combat trooper. ", 90, 156, 157, 20},
	{"as a tool for conquest of the world. ", 100, 156, 157, 10},


	{"You have a cat-like appearance", 15, 157, 158, 40},
	{"You have a dog-like appearance", 30, 157, 158, 30},
	{"You have a Kutar-like appearance", 45, 157, 158, 20},
	{"You have a human-like appearance", 70, 157, 158, 60},
	{"You have a dwarf-like appearance", 80, 157, 158, 70},
	{"You have a hobbit-like appearance", 90, 157, 158, 70},
	{"You have a elf-like appearance", 100, 157, 158,  80},

	{", but your ears have been eaten by mice, and no trace of them remains.", 5, 158, 0, 20},
	{"... at least your creator thinks so.  Most people disagree.", 20, 158, 0, 30},
	{".", 85, 158, 0, 50},
	{", and you firmly believe that you are a real one.", 95, 158, 0, 50},
	{", and you are almost indistinguishable from a real one.", 100, 158, 0, 100},
#endif
};


static cptr class_jouhou[MAX_CLASS] =
{
#ifdef JP
"̃N[`[͎푰IȓEƂ̕Ă܂B",

"ḿAʂ̂قƂǂא؂ɒ@؂邱ƂŉLN^łBAܑދpĖ@̓̐bɂȂ邱Ƃ܂Bs^ɂAxȃACȇ͔ނ炪͈͂zĂ܂B",
  
"CW͖@głA̋@mɂĐтȂ΂Ȃ܂Bm̂悤ɁAPɐ؂܂邱ƂœJƂ͖]߂܂BɉāACW͏ɂȂ閂@̓^ԂׂłB͑̉yɊȒPɃ}X^[ł܂B@ɕKvȔ\͒l͒m\łB",
  
"v[Xg͍Mȗ͂gƂɐOLN^łBނ͎g̐_̂߂Ƀ_WTAɂꂽȂA͔ނM@̉hƂȂ܂Bv[Xg͐VF_̑蕨Ƃ`Ŏ󂯎邽߁AǂwԂ̂őIԂƂ͂ł܂Bv[Xg͖@̓̎g悭mĂ܂ACWقǂ܂͎g܂Bn̂݊D݁AjĂȂn̂𑕔ƕsȊoɏPA퓬\͂Ă܂܂B@ɕKvȔ\͒l͌łB",
  
"͂ςŐƂDރLN^łA̐SȂƂɂ͐퓬œ؂JƂł܂A㩂hA\͂ɗDA㩂̉⌮JɏnBĂ܂B͍BsÃN[`[̌Q̂΂NƂȂʂ蔲AEъĐ搧U邱Ƃł܂B@ɕKvȔ\͒l͒m\łB",
  
"W[͐mƃCW킹悤ȐEƂŁAg̉̎RƓʂȊ֌WグĂ܂Bނ͂młA|̂悤ȉIgEƂłBW[͂悢BsA悢moA悢TA悢@hA@̓̎gpɂĂ܂B@ɕKvȔ\͒l͒m\łB",
  
"pfB͐mƃv[Xg킹EƂłBpfB͂ƂĂ悢młÂ͓ӂł͂܂BpfBɂ͑̔\͂Ă܂BBs, mo, T, Ė@gpłA̐_Ƃ̒gɂĖ@h͂łB@ɕKvȔ\͒l͌łB",
  
"@m̖͂̂Ӗʂ̐EƂłAmƃCW̎킹܂Bނ̓Ǝ҂ł郌W[R̖@Ɛ߂̃XLɓĂA{̖@m͂ǂ̐EłԂɂȂ낤ƂĂ܂BmƂĂ͕ʂ̃CWƂ͔וɂȂȂقǗDĂ܂BAۂɂ͖@ł퓬ł̐EƂɂ͋y΂AmƃCW̒ԂɈʒu悤ȐEƂłB@ɕKvȔ\͒l͒m\łB",
  
"ׂ̐mׂ͋JIX̖̎gƂċ鑶݂łBׂ̐m̓pgƂȂ鈫AxオxɕV𓾂邱Ƃ܂Bނ͎ÂĂꂽAωA\͒lグĂ邩܂񂵁AɉBoA\͒l⑕Dm܂B͒Pɂ𖳎邾܂BJIX̖͖ŗ\̂Ȃ݂łBV̎ނ̓pgƂȂ鈫ƋRɈˑ܂iႤ͈قȂV^܂jB@ɕKvȔ\͒l͒m\łB",
  
"Csm͑̐EƂƂ͒قȂEƂłBނ͑̐EƓlƖhg܂A}[VA[čPςł邽߁AAhȂł苭͂ȑ݂ƂȂ܂Bxł́AKvȑϐgɂ邽߂̖h𑕔Kv܂A܂ɏdh𑕔Ă܂ƁȂ̏pɐ[ȖWƂȂ܂BxオƁAނ͐V͂ȍU@wсAh\͂㏸܂B@ɕKvȔ\͒l͌łB",
  
"\͎҂͖@̂ɂ̐_̗͂gB̐EƂłB̗͂͒\͎ғƓ̂̂ŁAPɒoIȂ̂瑼l̐_xẑ܂ŗlXłBނ̗͂͂̌PɂĊĴȂ̂ŁA\͎҂͗͂ĝɎKvƂ܂Bg͂͒PɃLN^̃xɂČ܂܂B\͂ɕKvȔ\͒l͌łB",
  
"nCCW͈̗̈ɓÄ̗ʏ̃CW͂邩ɐ[w񂾃CWłBP̗̈ɓŁAނ͎炪Ï̎ۂ̏loAŒ჌xAsőȉb󂯂܂BÄ̗ł̓v[Xgقǂ܂͂ȂȂƂɂ͒ӂׂłB@ɕKvȔ\͒l͒m\łB",
  
"όq͊ό̂߂ɂ̐EɂĂ܂B퓬͂ႭA͂ȎgƂłȂ߁AłʂĂ̂EƂƌ܂B@ɕKvȔ\͒l͒m\łB",
  
"̂܂ˎt͐퓬͂͂܂AȔ\͂gƂ͑Sł܂BA̖ڂ̑Oɂ鑊肪\͂gꍇA̔\͂ƑS\͂肻̂܂܎gƂł܂B̂܂˂ɕKvȔ\͂͊{IɊpłA܂˂\͂Ɋ֌W鑼̔\͂KvłB",
  
"bgD\'angbandẼ_WɏZސƐSʂ킹܂Bނ͍ł܂N[`[肱ȂƂłAȂÂ肵N[`[̎葫̂悤Ɏg܂B@ɕKvȔ\͖͂͂łB",
  
"Xy}X^[͑SĂ̖@ɂ߂҂łBނ͑SɂĔɗDꂽ@głA閂@ׂ̂Ă̎wK̎ԂȂgȂƂł܂B̔ʁAނ͐mƂĂ͍ŒŁAǂȕɈ܂Bpt̏񂾂͗OłAƂĂ͎gɂȂȂł傤BׂĂ̖@܂Ȃ΂ȂȂ߁Aɏ㋉ҌȐEƂƌ܂B@ɕKvȔ\͂͒m\łB",
  
"A[`[͖@gƂ͂ł܂񂪁AǂȐEƂI݂ɋ|XOgȂ܂Bʂ̖eKvƂ̂͊młA΂XOp̒eAxオƃN[`[̍₪炭肷Zpgɂ܂B܂AmƔׂĉBsAmoATA@̎gpȂǂɂDĂAƂƂɂ͖@̓ɗ邱Ƃł܂B",
  
"pt͏A@_AbhƂ@̃ACe疂͂荞ނƂɂĖ@g܂B@̃ACe𔭌邱Ƃ̐EƂ͂邩ɏdvɂȂ܂B퓬͍͂͂ȂłA̋܂B@ɕKvȔ\͂͒m\łB",
  
"Vl͖͂тт̂̂Ƃł܂B͕̉̂ʂ̖@ƈقȂÂ̂ĂԌpČʂ𔭊܂BA2̉̂̂ƂłȂAƂ_܂BEŜɉeyڂ̂AƂ܂B̓IȔ\͕͂nŁAPɐ؂܂邱ƂœJƂ͂ł܂B@ɕKvȔ\͖͂͂łB",
  
"Ԗt͉@̂قƂǂgƂłA퓬͂\ɂ܂BxオƋ͂Ȕ\́uAvgɂ邱Ƃł܂BA@oXs[h͒xA㋉@gȂ̂ŁACWقǂɂ͖@𗊂ɂ邱Ƃł܂B@gpƖ@h͂łAȊŐZ\͋łB@ɕKvȔ\͂͒m\łB",
  
"pƂ͐mɎ퓬͂AlXȋZgƂł܂BނMP̓xɈˑAŌ܂AC߂邱ƂɂAőlzMP𑝂₷Ƃł܂BAmƓlAx̖@̃ACe͔ނ͈̈͂zĂA㩂̉T̔\͂Ƃ͂܂BKEZ̎gpɕKvȔ\͂͌łB",
  
"Cpt́uCvgBlłBCsmƓlAhɐ키ƂD݁AEhȂł苭͂ȑ݂ƂȂ܂BCsmقǂ̐퓬\͂͂܂񂪁ACsmƓl̖@gAɁuCv̗͂𑀂܂BƂAdh𑕔邱Ƃ́AuCv̗͂̎gpW܂B@ƗCpɕKvȔ\͂͌łB",
  
"t͗Dꂽ@głA̋@mɂĐтȂ΂Ȃ܂BCW̖̑@gƂ̈Ⴂ͖@̊oŁAt̓N[`[̖@̌ʂ󂯂邱Ƃł̖@o܂Bo邽߂ɂ́u[jOv̏ԂɂȂĂȂƂ܂B@ɕKvȔ\͂͒m\łB",
  
"R͔nɏ삯G[gmłB@͎g܂񂪁Anォ̈|IȍU͂ւɁA@͂𐶂ˌӂƂĂ܂Bxオ΁A쐶̃N[`[ɂ܂薳Ȃ邱Ƃł܂Bނ͌Ȃ̓̂Ɛ_ɌւA@ɂ͂܂藊낤Ƃ͂܂B",
  
"m͓{苶ĕU邤ׂmłBSEƒō̓̔\͂ւA|ƖჂɑ΂ϐAxオ΂̋xȓ̂Ŗ̎𒵂˕ԂƂł܂BɕȂŐ키ƂA􂢂̂ꂽ͂ÂŔƂłA̋Z(@Ԃł)gƂł܂BA▂@͑SgƂłA㩂̉BsATA@hAѓ̋Z\ɊւĂ͐]IłBЂ牣ēJ܂BH͔ɏ₷łXRAȂႭC܂B",

"bt͕hŋ邱Ƃł܂Bʂhʂ̌ƂȂGbZXoAʂ̕hɃGbZXt邱ƂɂĂ̓ʂtł܂Bx̐퓬\͂܂A@͈؎gpłAB▂@h̋Z\ႭȂ܂B",

"ǵA͂̍߂ꂽoāAG}ƂčUsȂƂł鋾@g܂Bg͋̏Ŏ͂𔭊Ȁł͑fe|[g\ƂȂ܂B@̋́AxɂĈxɐł鐔܂B@ɕKvȔ\͂͒m\łB",

"E҂͈ÈłɐދׂÎE҂łAɍsA̕sӂꌂő̍~߂܂B܂Af킷߂̔Epgɂ܂B㩂hA\͂ɗDA㩂̉⌮JɏnBĂ܂ByD݁AdZ═𑕔ƒA܂A𑕔悤Ƃ͂܂ByȂ΁Axオɂ葬Âɍsł܂BɔE҂͋|AΓłقƂǌȂȂAȂ̂邱Ƃł悤ɂȂ܂BEpɕKvȔ\͂͊płB",

"XiCp[͈ꌂKE_ׂˎłB_߂邱ƂɂAˌ̈З͂Ɛx߂܂B܂A@gƂ͂ł܂񂪁A܂ꂽ_Joˌp͂ȂЗ͂炷Ƃł傤BeNjbNKvƂEƂłB",

"͂̎푰̎Љ̒ŁA蕪Đ퓬ňZ\ȂEƂɂĂ҂w܂B"

#else

"This creature doesn't have classical feature."

"A Warrior is a hack-and-slash character, who solves most of his problems by cutting them to pieces, but will occasionally fall back on the help of a magical device.  Unfortunately, many high-level devices may be forever beyond their use.",

"A Mage is a spell caster that must live by his wits as he cannot hope to simply hack his way through the dungeon like a warrior.  In addition to his spellbooks, a mage should carry a range of magical devices to help him in his endeavors which he can master far more easily than anyone else.  A mage's prime statistic is Intelligence as this determines his spell casting ability. ",

"A Priest is a character devoted to serving a higher power.  They explore the dungeon in the service of their God.  Since Priests receive new prayers as gifts from their patron deity, they cannot choose which ones they will learn.  Priests are familiar with magical devices which they believe act as foci for divine intervention in the natural order of things.  A priest wielding an edged weapon will be so uncomfortable with it that his fighting ability.  A Priest's primary stat is Wisdom since this determine his success at praying to his deity. ",

"A Rogue is a character that prefers to live by his cunning, but is capable of fighting his way out of a tight spot.  Rogues are good at locating hidden traps and doors and are the masters of disarming traps and picking locks.  A rogue has a high stealth allowing him to sneak around many creatures without having to fight, or to get in a telling first blow.  A rogue may also backstab a fleeing creature.  Intelligence determines a Rogue's spell casting ability.",

"A Ranger is a combination of a warrior and a mage who has developed a special affinity for the natural world around him.  He is a good fighter and also good about a missile weapon such as a bow.  A ranger has a good stealth, good perception, good searching, a good saving throw and is good with magical devices.  Intelligence determines a Ranger's spell casting ability.",

"A Paladin is a combination of a warrior and a priest.  Paladins are very good fighters, but not very good at missile weapons.  A paladin lacks much in the way of abilities.  He is poor at stealth, perception, searching, and magical devices but has a decent saving throw due to his divine alliance.  Wisdom determines a Paladin's success at praying to his deity.",

"A Warrior-Mage is precisely what the name suggests: a cross between the warrior and mage classes.  While their brothers, the rangers, specialize in Nature magic and survival skills, true Warrior-Mages attempt to reach the best of both worlds.  As warriors they are much superior to the usual Mage class.  Intelligence determines a Warrior-Mage's spell casting ability.",

"Chaos Warriors are the feared servants of the terrible Demon Lords of Chaos.  Every Chaos Warrior has a Patron Demon and, when gaining a level, may receive a reward from his Patron.  He might be healed or polymorphed, his stats could be increased, or he might be rewarded with an awesome weapon.  On the other hand, the Patrons might surround him with creatures, drain his stats or wreck his equipment or they might simply ignore him.  The Demon Lords of Chaos are chaotic and unpredictable indeed.  The exact type of reward depends on both the Patron Demon (different Demons give different rewards) and chance.",

"The Monk character class is very different from all other classes.  Their training in martial arts makes them much more powerful with no armor or weapons.  To gain the resistances necessary for survival a monk may need to wear some kind of armor, but if the armor he wears is too heavy, it will severely disturb his martial arts maneuvers.  As the monk advances levels, new, powerful forms of attack become available.  Their defensive capabilities increase likewise, but if armour is being worn, this effect decreases.  Wisdom determines a Monk's spell casting ability.",

"The Mindcrafter is a unique class that uses the powers of the mind instead of magic.  These powers are unique to Mindcrafters, and vary from simple extrasensory powers to mental domination of others.  Since these powers are developed by the practice of certain disciplines, a Mindcrafter requires no spellbooks to use them.  The available powers are simply determined by the character's level.  Wisdom determines a Mindcrafter's ability to use mind powers.",

"High-mages are mages who specialize in one particular field of magic and learn it very well - much better than the ordinary mage.  For the price of giving up a second realm of magic, they gain substantial benefits in the mana costs, minimum levels, and failure rates in the spells of the realm of their specialty.  A high mage's prime statistic is intelligence as this determines his spell casting ability. ",

"Tourists have visited this world for the purpose of sightseeing.  Their fighting skills is bad, and they cannot cast powerful spells.  They are the most difficult class to win the game with.  Intelligence determines a tourist's spell casting ability.",

"Imitators have enough fighting skills to survive, but rely on their ability to imitate creature spells.  When creatures in line of sight use spells, they are added to a temporary spell list which the imitator can choose among.  Spells should be imitated quickly, because timing and situation are everything.  An imitator can only repeat a spell once each time he observes it.  Dexterity determines general imitation ability, but a stat related to the specific action is often also taken into account.",

"Beastmasters are in tune with the minds of the creatures of the world of D\'angband.  They are very good at riding, and have enough fighting ability.  They use creatures which summoned or dominated by him as his hands and feet.  Beastmasters can cast trump magic, and very good at summoning spell, but they can not summon non-living creatures.  Charisma determines a Beastmaster's spell casting ability.",

"Sorcerers are the all-around best magicians, being able to cast any spell from most magic realms without having to learn it.  On the downside, they are the worst fighters in the dungeon, being unable to use any weapon but a Wizardstaff.",

"Archers are to bows what warriors are to melee.  They are the best class around with any bow, crossbow, or sling.  They need a lot of ammunition, but will learn how to make it from junk found in the dungeon.  An archer is better than a warrior at stealth, perception, searching and magical devices.",

"Magic-Eaters can absorb the energy of wands, staffs, and rods, and can then use these magics as if they were carrying all of these absorbed devices.  They are middling-poor at fighting.  A Magic-Eater's prime statistic is intelligence.",

"Bards are something like traditional musicians.  Their magical attacks are sound-based, and last as long as the Bard has mana.  Although a bard cannot sing two or more songs at the same time, he or she does have the advantage that many songs affect all areas in sight.  A bard's prime statistic is charisma.",

"Red-Mages can use almost all spells from lower rank spellbooks of most realms without having to learn it.  At higher level, they develop the powerful ability \"Double Magic\".  However, they have large penalties in the mana costs, minimum levels, and failure rates of spells, and they cannot use any spells from higher rank spellbooks.  They are not bad at using magical devices and magic resistance, and are decent fighter, but are bad at other skills.  A red-mage's prime statistic is intelligence.",

"Samurai, masters of the art of the blade, are the next strongest fighters after Warriors.  Their spellpoints do not depend on level, but depend solely on wisdom, and they can use the technique Concentration to temporarily increase SP beyond its usual maximum value.  Samurai are not good at most other skills, and many magical devices may be too difficult for them to use.  Wisdom determines a Samurai's ability to use the special combat techniques available to him.",

"A ForceTrainer is a master of the spiritual Force.  They prefer fighting with neither weapon nor armor.  They are not as good fighters as are Monks, but they can use both magic and the spiritual Force.  Wielding weapons or wearing heavy armor disturbs use of the Force.  Wisdom is a ForceTrainer's primary stat.",

"A Blue-Mage is a spell caster that must live by his wits, as he cannot hope to simply hack his way through the dungeon like a warrior.  A major difference between the Mage and the Blue-Mage is the method of learning spells: Blue-Mages may learn spells from creatures by activating his Learning ability.  A Blue-Mage's prime statistic is Intelligence as this determines his spell casting ability. ",

"Cavalry ride on horses into battle.  Although they cannot cast spells, they are proud of their overwhelming offensive strength on horseback.  They are good at shooting.  At high levels, they learn to forcibly saddle and tame wild creatures.  Since they take pride in the body and the soul, they don't use magical devices well.",

"A Berserker is a fearful fighter indeed, immune to fear and paralysis.  At high levels, Berserkers can reflect bolt spells with their tough flesh.  Furthermore, they can fight without weapons, can remove cursed equipment by force, and can even use their special combat techniques when surrounded by an anti-magic barrier.  Berserkers, however, cannot use any magical devices or read any scrolls, and are hopeless at all non-combat skills.  Since Berserker LICHs are quite easy to *win* with, their scores are lowered.",

"A Weaponsmith can improve weapons and armors for him or herself.  They can extract the essences of special effects from weapons or armors which have various special abilities, and can add these essences to another weapon or armor.  They are good at fighting, but cannot cast spells, and are poor at skills such as stealth or magic defense.",

"Mirror-Masters are spell casters; like other mages, they must live by their wits.  They can create magical mirrors, and employ them in the casting of Mirror-Magic spells.  A Mirror-Master standing on a mirror has greater ability and, for example, can perform quick teleports.  The maximum number of Magical Mirrors which can be controlled simultaneously depends on the level.  Intelligence determines a Mirror-Master's spell casting ability.",

"A Ninja is a fearful assassin lurking in darkness.  He or she can navigate effectively with no light source, catch enemies unawares, and kill with a single blow.  Ninjas can use Ninjutsu, and are good at locating hidden traps and doors, disarming traps and picking locks.  Since heavy armors, heavy weapons, or shields will restrict their motion greatly, they prefer light clothes, and become faster and more stealthy as they gain levels.  A Ninja knows no fear and, at high level, becomes almost immune to poison and able to see invisible things.  Dexterity determines a Ninja's ability to use Ninjutsu.",

"Snipers are good at shooting, and they can kill targets by a few shots. After they concentrate deeply, they can demonstrate their shooting talents. You can see incredibly firepower of their shots.",

"TODO:Description of Commoner"
#endif
};


static cptr chara_jouhou[MAX_CHARA] =
{
#ifdef JP
"ʂ́AɓMׂȂiłBZ\𕽋ϓIɂȂ܂B",

"͎́A̓IȔ\͂Z\㏸܂BA@Ɋ֌W\͂Z\͗Am̃Xe[^X܂B",

"؂҂́A̓IȔ\͉͂܂Am\▂@Ɋ֌WZ\͏㏸ACW̃Xe[^X܂B",

"K҂́A_M\͂Ȃ܂B̓Iɂ͕ϓIȔ\͂Av[Xgɋ߂Xe[^XƂȂ܂B",

"f́Aǂ̃XLrI܂Ȃ܂A̓IȔ\͂͒ႭȂ܂B",

"m炸́A퓬́A@\̗͂㏸܂A@hAgoƂ\͈͂Ȃ܂B",

"DȐHו͏Ăr[tB}Ă͂邪A`SȈCTB`AECƂψȏゾJbƂ₷BvIls΂̐lIł܂^CvŁÄِ͋B",

"ӂ҂́AXLႭAĂ܂܂B",

"ZNV[ḾAXL܂ȂƂł܂BA̐lȂ߂i͑SẴN[`[{点邱ƂɂȂł傤B̐i͏IԂƂł܂B",

"bL[}́A\͒l͂Ȃ܂̂ɕCG邭炢Ⴂɂ炸AǂȂƂĂȂ܂Ă܂܂B̐i͒jIԂƂł܂B",

"䖝́AƕɂƂ肭ސTdȐiŁA̐iɔׂčϋv͂𓾂邱Ƃł܂BAŝ͋ŁA̋Z\͒ႭȂĂ܂܂B",

"CJT}́AS҂̗Kp̐iłB\͂ȂĂ܂B̐igΏ҂ɂȂ邱Ƃ͗eՂłAĂSɂȂ܂B",

"`[W}́uȂƂvɘAčsĂd̂ȂȂFBȂc`Br߂^t̓}X݂ɋ̂ǒm\ʂ͂܂őʖڂȂ̂邾낤H̐i͍ŏCĂ̂ŁA茶oSzȂ̂łB",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",

#else

"\"Ordinary\" is a personality with no special skills or talents, with unmodified stats and skills.",

"\"Mighty\" raises your physical stats and skills, but reduces stats and skills which influence magic.  It makes your stats suitable for a warrior.  Also it directly influences your hit-points and spell fail rate.",

"\"Shrewd\" reduces your physical stats, and raises your intelligence and magical skills.  It makes your stats suitable for a mage.  Also it directly influences your hit-points and spell fail rate.",

"\"Pious\" deepens your faith in your God.  It makes your physical ability average, and your stats suitable for priest. ",

"\"Nimble\" renders you highly skilled comparatively well, but reduces your physical ability. ",

"\"Fearless\" raises both your melee and magical ability.  Stats such as magic defense and constitution are reduced.  Also it has a direct bad influence on your hit-points.",

"\"Combat\" gives you comparatively high melee and shooting abilities, and average constitution.  Other skills such as stealth, magic defence, and magical devices are weakened.  All \"Combat\" people have great respect for the legendary \"Combat Echizen\".\n\
(See \"Death Crimson\" / Ecole Software Corp.)",

"A \"Lazy\" person has no good stats and can do no action well.  Also it has a direct bad influence on your spell fail rate.",

"\"Sexy\" rises all of your abilities, but your haughty attitude will aggravate all creatures.  Only females can choose this personality.",

"A \"Lucky\" man has poor stats, equivalent to a \"Lazy\" person.  Mysteriously, however, he can do all things well.  Only males can choose this personality.",

"A \"Patient\" person does things carefully.  Patient people have high constitution, and high resilience, but poor abilities in most other skills.  Also it directly influences your hit-points.",

"\"Munchkin\" is a personality for beginners.  It raises all your stats and skills.  With this personality, you can win the game easily, but gain little honor in doing so."

"\"ChargeMan\" is crazy killer. It render you powerfull strength and constitution, but poor intelligence. you are not confused and seen the illusion because this you go mad from the beginning. ",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",
"TODO::Explain",

#endif
};

static cptr realm_jouhou[VALID_REALM] =
{
#ifdef JP
"͉񕜔\͂ɗDꂽ@łBÂhAm@܂܂Ă܂AU킸ɎĂ܂Bɍx̎ɂ̓AfbhoɋA͂ƌĂ܂B",

"ṕumetav̈łAmӒAɑދpp̎⎩g̔\͂߂Ȃǂ֗̕Ȏ܂܂Ă܂BAڍUp͎̎Ă܂B",

"R̖@͎gp҂f̃}X^[ɂ܂Bɂ͖hATmAÂƍU܂܂Ă܂B܂AȊÖ̗ōō̎Î̗̈ɂ܂B",

"JIX̖@͐䂪ŁA\̂łȂ@܂BJIX͔ɔ񌳑fIłAJIX̎͑złłׂj󕺊łB̎̂̓JIX̐땺ɑ΂AG⎩gψق悤v܂B",

"płÍ̖@قǎ׈ȃJeS[͂܂B͔̎rIwԂ̂łAxɂȂƏp҂ɐƃAfbhRɑ\͂^܂BcOȂƂɁAƂ͂Ȏ͂̐G}ƂďpҎǧKvƂArɂ΂Ώp҂܂B",

"gv̖@̓e|[gn̎ŐIꂽ̂ĂȀo͑̐邽߂ɂg邽߁AI肷ꂽ̂lɎĂ܂BA̖@ɂđSẲʂ̏ꏊ֌Ă΂̂𗝉킯ł͂ȂAɎsƂ͓̐GƂȂ܂B",

"p̖@́ASĂ̗̈悩LpȎ悤Ƃpr̈łBKvȁuvIĂĂx̋͂Ȏ͎Ă܂BʂƂāASĂ̎͊XŔ߂邱Ƃł܂B܂Ä̗ɑ݂铯lȎ̕჌xARXgŏ邱Ƃł܂B",

"̖@́A⓹邽߂̖@܂܂Ă܂B@ɂĎg̐퓬͂ɍ߂邱Ƃł܂A𒼐ڍU悤Ȏ͊܂܂Ă܂B",

"̖@͈ÍƓlɎ׈ȃJeS[łBlXȍU@ɗDA܂̂Ƃmo\͂𓾂邱Ƃł܂Bx͈݂̎ɑAg̓̂邱Ƃł܂B",

"jׂ́u`v̖@łBړG閂@܂܂AɎ׈ȓGɑ΂ׂ͂͋̂܂BAPǂȓGɂ͂܂ʂ܂B",

"̏ẂÂɂČʂ𔭊閂@łB@ƓlAgɌʂ̂̂ƁÂ邱ƂɂĎČʂ𔭊̂܂B҂̏ꍇ́AMP̑ʂ𔭊邱Ƃł܂Aɉ̂̂1Ƃ܂B",

"|̏́AlXȐ퓬̋ZɂďĂ܂B̖{͋ZoƂɓǂޕKv܂AxoZ͎ĝɖ{Kv͂܂BZgƂɂ͕K𑕔ĂȂ΂܂B",

"p͊ނׂ̈łB̎􂢂̌t̂̂悤ɖaȂr܂B͉̎r邱ƂɂČʂ܂Bɂ͑̍s𑩔́A_[W^́AUɑ΂Ĕ̂܂B"
#else

"Life magic is very good for healing; it relies mostly on healing, protection and detection spells.  Also life magic have a few attack spells as well.  It said that some high level spell of life magic can disintegrate Undead creatures into ash.",

"Sorcery is a `meta` realm, including enchantment and general spells.  It provides superb protection spells, spells to enhance your odds in combat and, most importantly, a vast selection of spells for gathering information.  However, Sorcery has one weakness: it has no spells to deal direct damage to your enemies.",

"Nature magic makes you master of elements; it provides protection, detection, curing and attack spells.  Nature also has a spell of Herbal Healing, which is the only powerful healing spell outside the realm of Life magic.",

"There are few types of magic more unpredictable and difficult to control than Chaos magic.  Chaos is the very element of unmaking, and the Chaos spells are the most terrible weapons of destruction imaginable.  The caster can also call on the primal forces of Chaos to induce mutations in his/her opponents and even him/herself.",

"There is no fouler nor more evil category of spells than the necromantic spells of Death Magic.  These spells are relatively hard to learn, but at higher levels the spells give the caster power over living and the (un)dead, but the most powerful spells need his / her own blood as the focus, often hurting the caster in the process of casting.",

"Trump magic has, indeed, an admirable selection of teleportation spells.  Since the Trump gateways can also be used to summon other creatures, Trump magic has an equally impressive selection of summoning spells.  However, not all creatures appreciate being drawn to another place by Trump user.",

"Arcane magic is a general purpose realm of magic.  It attempts to encompass all 'useful' spells from all realms.  This is the downside of Arcane magic: while Arcane does have all the necessary 'tool' spells for a dungeon delver, it has no ultra-powerful high level spells.  As a consequence, all Arcane spellbooks can be bought in town.  It should also be noted that the 'specialized' realms usually offer the same spell at a lower level and cost. ",

"Craft magic can strengthen the caster or the equipments.  These spells can greatly improve the caster's fighting ability.  Using them against opponents directly is not possible.",

"Demon is a very evil realm, same as Death.  It provides various attack spells and devilish detection spells.  at higher levels, Demon magic provides ability to dominate demons, and to polymorph yourself into a demon.",

"Crusade is a magic of 'Justice'.  It includes damage spells, which are greatly effective against foul and evil creatures, but have poor effects against good creatures.",

"Music magic shows various effects as sing song.  There is two type of song; the one which shows effects instantly and the other one shows effect continuously until SP runs out.  But the latter type has a limit; only one song can be sing at the same time.",

"The books of Kendo describe about various combat techniques.  When learning new techniques, you are required to carry the books, but once you memorizes them, you don't have to carry them.  When using a technique, wielding a weapon is required.",

"Hex is a very terrible realm. Spells gives continual effects when they are spelled continually like songs. Spells may obstract creatures' actions, may deal damages in sight, may revenge against enemies."
#endif
};

static char realm_subinfo[VALID_REALM][41] =
{
#ifdef JP
"mƖhƉ񕜂ɗDĂ܂",
"U͂ł܂񂪔ɕ֗ł",
"mƖhɗDĂ܂",
"jIȍUɗDĂ܂",
"̂Gւ̍UɗDĂ܂",
"ƃe|[gɗDĂ܂",
"アȂɕ֗ł",
"ڐ퓬̕⏕ɗDĂ܂",
"UƖh̗ʂɗDĂ܂",
"׈ȉɑ΂UɗDĂ܂",
"lXȖ@ʂ̂̂܂",
"ŌUɓ\͂t܂",
"GזQ_܂"
#else
"Good at detection and healing.",
"Utility and protective spells.",
"Good at detection and defence.",
"Offensive and destructive.",
"Ruins living creatures.",
"Good at summoning, teleportation.",
"Very useful but poor a bit.",
"Support for melee fighting.",
"Good at both offence and defence.",
"Destroys evil creatures.",
"Song with magical effects.",
"Special attacks on melee.",
"Good at obstacle and revenge."
#endif
};

static cptr starting_point_jouhou[STARTING_MAX] =
{
"CF_[́qҁr䂫ꂸɂ͋Ȃh̒nłBw^̑{x̉ɂ͖m**B̎iłwCF_[̖xĂ܂Bł₩**𓾂ɂ͂̓ynn߂̂ǂł傤B",
"CF[L͔Q̎푰C[NBAsт̒nɌグĒz񑩂̒nłBAŋ߂ɂȂĎw҂ł剤{h[Ƃ̈ꑰ̎Ɋŋ낵oNĂ܂B̒nɂ̓C[NȊOޓ͎̋҂َ푰̗vllAŒ̎{݂Ă܂B",
"hD[hɂ͌Â炱̓ynɏZłp̐M҂ł錴ZZł܂Bޓ͂˂ꂽ̓ĂlB̐N󂯂ĂARd˂Ă܂݂͖k̕ƒnɒǂAޓ̒zグA̍Ԃɐ[l̔O𒍂ł܂B",
"EEXg̓I[N̕RU炵̖グǓssłBł쓌ɂ̖͌łI[NB߂ÂȂƂׂa̋CɖJЂTU炵Ă܂Bǂ̖͂܂SXTE炵̂Ǝ咣Ă܂Amȏ؋͂Ȃ悤łB",

"X[ɂAOEB̖͂⌚z̗lɂāA炭͖{ẪGtグssłAۂ	ꓝ̂łwւ̉R}EF̓ẻɋ߂΂̃GtłBޏMƂAOEB̕xTsB͂ʂŋԂɒ؂̎R̖̂ҒB𖾂炩ɌŷĂ܂BAޓ͓̗񋭁AɃENA@ɑ΂Ă͔ɗFDIŁAޓ݂̍֋ɂ߂ėǎ̋𔄂邱ƂŉhA̎R̖SĂ̕xW߂Ă܂y΂Ȃɉh𓾂Ă܂B",
"̉nV́AĂ͑傫ȓsłՂcĂ܂ׂ݂͗Ȗq{̌i΂̎ꂽnłBW̖kɂ͍łȈՂłn悪LĂ܂B̒ɖY߂Rt`҂͌₿܂񂪁A͐ċA炸A镨𓾂҂͂܂ɂȂ悤łB",
"LZ_oW͔ɌÂlZłynƎv̂łAZB܂߂Ă̗Rؕ܂B{sՓV̓GmƂ푰BRƍ킵Đ܂ꂽAGȍBl̑命߂Ă܂BǂƂȂ䩗mƂԓx̏ZB́AҒBɑ΂ėFDIł͂܂A΂ɖkɍRƌꂽF̖̏邩炳ƁAf[̌Qɂ͜RƂɂȂ悤łB",
"[C͊C݂ɐڂynłA痤̌Ղ𐶋ƂƂҒB̃IAVXƂĔFmĂ܂Bk̛ĎRɂ͕̈ɋ_ȓc悤łB܂A̓ynɂb̈ꑰ͖ȂAőɌȂ͂ȕbpĂ܂B",

"TODO:Y",
"TODO:EgDm",
"TODO:oh",
"TODO:e",

"TODO:eL\~",
"TODO:OuY",
"TODO:CG",

};

/*
 * Autoroll limit
 */
static s16b stat_limit[6];

static struct {
	s16b agemin, agemax;
	s16b htmin, htmax;
	s16b wtmin, wtmax;
	s16b scmin, scmax;
} chara_limit;

/*
 * Autoroll matches
 */
static s32b stat_match[6];

/*
 * Autoroll round
 */
static s32b auto_round;


static void birth_quit(void)
{
	remove_loc();
	quit(NULL);
}

/*
 *  Put initial status
 */
static void put_initial_status(creature_type *creature_ptr)
{
	cptr race, cls;

#ifdef JP
		put_str("푰  :                                                                         ", 1, 1);
#else
		put_str("Race  :                                                                         ", 1, 1);
#endif
	if(creature_ptr->race_idx1 != INDEX_NONE)
	{
		race = desc_race_name(creature_ptr);
		c_put_str(TERM_L_BLUE, race, 1, 9);
	}

#ifdef JP
		put_str("E  :                                                                         ", 2, 1);
#else
		put_str("Class :                                                                         ", 2, 1);
#endif
	if(creature_ptr->class_idx != INDEX_NONE)
	{
		cls = get_class_desc(creature_ptr);
		c_put_str(TERM_L_BLUE, cls, 2, 9);
	}

#ifdef JP
		put_str("_  :                                                                         ", 3, 1);
#else
		put_str("Patron:                                                                         ", 3, 1);
#endif
	if(creature_ptr->patron_idx != INDEX_NONE)
	{
		c_put_str(TERM_L_BLUE, species_name + species_info[creature_ptr->patron_idx].name, 3, 9);
	}


}


/*
 *  Show specific help file
 */
static void show_help(cptr helpfile)
{
	/* Save screen */
	screen_save();

	/* Peruse the help file */
	(void)show_file(TRUE, helpfile, NULL, 0, 0);

	/* Load screen */
	screen_load();
}


/*
 * Choose from one of the available magical realms
 */
static int choose_realm(s32b choices, bool npc)
{
	int i;
	selection re[MAX_REALM + 3];
	int picks[VALID_REALM] = {0};
	int n = 0;

	/* Count the choices */
	if (choices & CH_LIFE)
	{
		strcpy(re[n].cap, realm_names[REALM_LIFE]);
		re[n].code = REALM_LIFE;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_SORCERY)
	{
		strcpy(re[n].cap, realm_names[REALM_SORCERY]);
		re[n].code = REALM_SORCERY;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_NATURE)
	{
		strcpy(re[n].cap, realm_names[REALM_NATURE]);
		re[n].code = REALM_NATURE;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_CHAOS)
	{
		strcpy(re[n].cap, realm_names[REALM_CHAOS]);
		re[n].code = REALM_CHAOS;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_DEATH)
	{
		strcpy(re[n].cap, realm_names[REALM_DEATH]);
		re[n].code = REALM_DEATH;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_TRUMP)
	{
		strcpy(re[n].cap, realm_names[REALM_TRUMP]);
		re[n].code = REALM_TRUMP;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_ARCANE)
	{
		strcpy(re[n].cap, realm_names[REALM_ARCANE]);
		re[n].code = REALM_ARCANE;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_ENCHANT)
	{
		strcpy(re[n].cap, realm_names[REALM_CRAFT]);
		re[n].code = REALM_CRAFT;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_DAEMON)
	{
		strcpy(re[n].cap, realm_names[REALM_DAEMON]);
		re[n].code = REALM_DAEMON;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_CRUSADE)
	{
		strcpy(re[n].cap, realm_names[REALM_CRUSADE]);
		re[n].code = REALM_CRUSADE;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_MUSIC)
	{
		strcpy(re[n].cap, realm_names[REALM_MUSIC]);
		re[n].code = REALM_MUSIC;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_HISSATSU)
	{
		strcpy(re[n].cap, realm_names[REALM_HISSATSU]);
		re[n].code = REALM_HISSATSU;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	if (choices & CH_HEX)
	{
		strcpy(re[n].cap, realm_names[REALM_HEX]);
		re[n].code = REALM_HEX;
		re[n].key = '\0';
		re[n].d_color = TERM_L_DARK;
		re[n].l_color = TERM_WHITE;
		n++;
	}
	
	if(n <= 0) return REALM_NONE;


#if JP
	strcpy(re[n].cap, "_");
#else
	strcpy(re[n].cap, "Random");
#endif
	re[n].code = -1;
	re[n].key = '*';
	re[n].d_color = TERM_UMBER;
	re[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(re[n].cap, "ŏɖ߂");
#else
	strcpy(re[n].cap, "Back to start");
#endif
	re[n].code = -2;
	re[n].key = 'S';
	re[n].d_color = TERM_UMBER;
	re[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(re[n].cap, "I");
#else
	strcpy(re[n].cap, "Quit game");
#endif
	re[n].code = -3;
	re[n].key = 'Q';
	re[n].d_color = TERM_UMBER;
	re[n].l_color = TERM_L_UMBER;
	n++;


	/* Extra info */
/*
#ifdef JP
	put_str ("ӁF@̗̈̑Iɂ肠ȂK̃^Cv܂܂B", 23, 5);
#else
	put_str ("Note: The realm of magic will determine which spells you can learn.", 23, 5);
#endif
*/
	if(!npc)
		i = get_selection(re, n, 0, 5, 2, 18, 20, realm_detail, 0);
	else
		return re[randint0(n-3)].code;

	if (i >= 0) return i;
	else if (i == -1) return re[randint0(n-3)].code;
	else return i;

}


/*
 * Choose the magical realms
 */
static bool get_creature_realms(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i;

	if(!npc)
	{
		clear_from(0);
		put_initial_status(creature_ptr);
	}

	if(!npc)
	{
#if JP
		put_str("̈Iĉ:", 0, 0);
#else
		put_str("Select a realm:", 0, 0);
#endif
		put_initial_status(creature_ptr);
	}

	/* Select the first realm */

	if(species_ptr->realm1 != INDEX_VARIABLE)
	{
		creature_ptr->realm1 = species_ptr->realm1;
	}
	else
	{
		creature_ptr->realm1 = REALM_NONE;
		creature_ptr->realm2 = 255;
		i = choose_realm(realm_choices1[creature_ptr->class_idx], npc);

		if(i == -2)
			return -2;
		else if(i == -3)
			return -3;
		else
			creature_ptr->realm1 = i;
	}

	if(!npc)
	{
#if JP
		put_str("̈Iĉ:", 0, 0);
#else
		put_str("Select a realm:", 0, 0);
#endif
		put_initial_status(creature_ptr);
	}

	if(species_ptr->realm2 != INDEX_VARIABLE)
	{
		creature_ptr->realm2 = species_ptr->realm2;
	}
	else
	{
		
		/* Select the second realm */
		creature_ptr->realm2 = REALM_NONE;
		i = choose_realm(realm_choices2[creature_ptr->class_idx] & ~(1 << (creature_ptr->realm1 - 1)), npc);
		if(i == -2)
			return -2;
		else if(i == -3)
			return -3;
		else
			creature_ptr->realm2 = i;
	}

	return (TRUE);
}

/*
 * Returns adjusted stat -JK-  Algorithm by -JWT-
 */
static int adjust_stat(int value, int amount)
{
	int i;

	/* Negative amounts */
	if (amount < 0)
	{
		/* Apply penalty */
		for (i = 0; i < (0 - amount); i++)
		{
			if (value >= 18+10)
			{
				value -= 10;
			}
			else if (value > 18)
			{
				value = 18;
			}
			else if (value > 3)
			{
				value--;
			}
		}
	}

	/* Positive amounts */
	else if (amount > 0)
	{
		/* Apply reward */
		for (i = 0; i < amount; i++)
		{
			if (value < 18)
			{
				value++;
			}
			else
			{
				value += 10;
			}
		}
	}

	/* Return the result */
	return (value);
}




/*
 * Roll for a characters stats
 *
 * For efficiency, we include a chunk of "set_creature_bonuses()".
 */
static void set_stats(creature_type *creature_ptr, species_type *species_ptr)
{
	int i;

	// Roll and verify some stats
	while (TRUE)
	{
		int sum = 0;

		// Roll some dice
		for (i = 0; i < 2; i++)
		{
			s32b tmp = randint0(60 * 60 * 60);
			int val;

			// Extract 5 + 1d3 + 1d4 + 1d5
			val = 5 + 3;
			val += tmp % 3; tmp /= 3;
			val += tmp % 4; tmp /= 4;
			val += tmp % 5; tmp /= 5;

			// Save that value
			sum += val;
			creature_ptr->stat_cur[3 * i] = creature_ptr->stat_max[3 * i] = val * STAT_FRACTION;

			// Extract 5 + 1d3 + 1d4 + 1d5
			val = 5 + 3;
			val += tmp % 3; tmp /= 3;
			val += tmp % 4; tmp /= 4;
			val += tmp % 5; tmp /= 5;

			// Save that value
			sum += val;
			creature_ptr->stat_cur[3 * i + 1] = creature_ptr->stat_max[3 * i + 1] = val * STAT_FRACTION;

			// Extract 5 + 1d3 + 1d4 + 1d5
			val = 5 + 3;
			val += tmp % 3; tmp /= 3;
			val += tmp % 4; tmp /= 4;
			val += tmp;

			// Save that value
			sum += val;
			creature_ptr->stat_cur[3 * i + 2] = creature_ptr->stat_max[3 * i + 2] = val * STAT_FRACTION;
		}

		// Verify totals
		if ((sum > 42 + 5 * 6) && (sum < 57 + 5 * 6))
		{
			for(i = 0; i < STAT_MAX; i++) if(creature_ptr->stat_cur[i] < STAT_VALUE_MIN) creature_ptr->stat_cur[i] = STAT_VALUE_MIN;
			break;
		}

		// 57 was 54... I hate 'magic numbers' :< TY
		// Agree. Deskull
	}

	for(i = 0; i < STAT_MAX; i++)
	{
		if(creature_ptr->stat_cur[i] < STAT_VALUE_MIN) msg_print("Warning: Out Range Status Point.");
	}

}

void get_max_stats(creature_type *creature_ptr)
{
	int		i, j;
	int		dice[6];

	/* Roll and verify some stats */
	while (TRUE)
	{
		/* Roll some dice */
		for (j = i = 0; i < 6; i++)
		{
			/* Roll the dice */
			dice[i] = randint1(7);

			/* Collect the maximum */
			j += dice[i];
		}

		/* Verify totals */
		if (j == 24) break;
	}

	/* Acquire the stats */
	for (i = 0; i < 6; i++)
	{
		j = STAT_VALUE_BASE_MAX_MAX + dice[i]*10;
		// Save that value
		creature_ptr->stat_max_max[i] = j;
		if (creature_ptr->stat_max[i] > j) creature_ptr->stat_max[i] = j;
		if (creature_ptr->stat_cur[i] > j) creature_ptr->stat_cur[i] = j;
	}
	creature_ptr->knowledge &= ~(KNOW_STAT);

	/* Redisplay the stats later */
	play_redraw |= (PR_STATS);
}


/*
 * Roll for some info that the auto-roller ignores
 */
static void get_extra(creature_type *creature_ptr, bool roll_hitdice)
{

	set_expfact(creature_ptr);

	/* Reset record of race/realm changes */
	creature_ptr->start_race1 = creature_ptr->race_idx1;
	creature_ptr->start_race2 = creature_ptr->race_idx2;
	creature_ptr->old_race1 = 0L;
	creature_ptr->old_race2 = 0L;
	creature_ptr->old_realm = 0;

	initialize_skill(creature_ptr);

	set_bodysize(creature_ptr);
	set_hitdice(creature_ptr);

	/* Roll for hit point unless quick-start */
	if (roll_hitdice) set_base_hp(creature_ptr);


}


/*
 * Get the racial history, and social class, using the "history charts".
 */
static void get_history(creature_type *creature_ptr)
{
	int i, j, n;
	char *s, *t;

	char buf[240];
	species_type *species_ptr = &species_info[creature_ptr->species_idx];
	char *history = (species_text + species_ptr->text);
	char temp[HISTORY_ROW * HISTORY_COL];


	/* Clear the previous history strings */
	for (i = 0; i < HISTORY_ROW; i++) creature_ptr->history[i][0] = '\0';

	/* Clear the history text */
	buf[0] = '\0';

	/* Skip leading spaces */
	for (s = buf; *s == ' '; s++) /* loop */;

	/* Get apparent length */
	n = strlen(s);

	/* History  */
	if(history)
	{
		/* Clear the previous history strings */
		for (i = 0; i < HISTORY_ROW; i++) creature_ptr->history[i][0] = '\0';

		/* Skip leading spaces */
		for (s = history; *s == ' '; s++) /* loop */;

		/* Get apparent length */
		n = strlen(s);

		/* Kill trailing spaces */
		while ((n > 0) && (s[n - 1] == ' ')) s[--n] = '\0';

		roff_to_buf(s, HISTORY_COL, temp, sizeof(temp));
		t = temp;
		for (i = 0; i < HISTORY_ROW; i++)
		{
			if (t[0] == 0) break;
			else
			{
				strcpy(creature_ptr->history[i], t);
				t += strlen(t) + 1;
			}
		}

		/* Fill the remaining spaces */
		for (i = 0; i < HISTORY_ROW; i++)
		{
			for (j = 0; creature_ptr->history[i][j]; j++) /* loop */;

			for (; j < HISTORY_COL - 1; j++) creature_ptr->history[i][j] = ' ';
			creature_ptr->history[i][HISTORY_COL - 1] = '\0';
		}

	}

	if(species_ptr->sc) creature_ptr->sc = species_info->sc;
	else
	{
		creature_ptr->sc = diceroll(4, 20);
		if(one_in_(10)) creature_ptr->sc += diceroll(1, 60);
	}

}


static void set_exp(creature_type *creature_ptr, species_type *species_ptr)
{
	s32b exp1, exp2, rate1, rate2;

	exp1 = 0;
	exp2 = species_ptr->exp;
	rate1 = 0;
	rate2 = randnor(10000, EXP_STAND_RATE);

	s64b_mul(&exp1, &exp2, rate1, rate2);
	s64b_div(&exp1, &exp2, 0, 10000);

	exp2 = (exp2 >= 0) ? exp2 : 0;

	creature_ptr->exp = creature_ptr->max_exp = creature_ptr->max_max_exp = exp2;
}

/*
 * Computes character's age
 * by henkma (get_ahw)
 * Modified by deskull in D'angband.
 */
static void set_age(creature_type *creature_ptr)
{
	species_type *species_ptr = &species_info[creature_ptr->species_idx];

	if(species_ptr->age <= 0)
	{
		/* Get character's age */
		creature_ptr->age = race_info[creature_ptr->race_idx1].b_age + race_info[creature_ptr->race_idx2].b_age;
		creature_ptr->age += randint0((race_info[creature_ptr->race_idx1].m_age + race_info[creature_ptr->race_idx2].m_age)/2);
	}
	else
	{
		creature_ptr->age = species_ptr->age;
	}
}


/*
 * Get the player's starting money
 */
static void get_money(creature_type *creature_ptr)
{
	int gold;

	// Starting gold
	gold = randint1(100) + 300;
	if (creature_ptr->class_idx == CLASS_TOURIST) gold += 2000;
	if (gold < 100) gold = 100;

	if (creature_ptr->chara_idx == CHARA_NAMAKE)
		gold /= 2;
	else if (creature_ptr->chara_idx == CHARA_MUNCHKIN)
		gold = 10000000;
	if (has_trait(creature_ptr, TRAIT_ANDROID)) gold /= 5;

	gold += creature_ptr->sc * (creature_ptr->lev * creature_ptr->lev + 5) / 2; // Level and social class calc

	// Save the gold
	creature_ptr->au = gold;
}



/*
 * Display stat values, subset of "put_stats()"
 *
 * See 'display_creature_status()' for screen layout constraints.
 */
static void birth_put_stats(creature_type *creature_ptr)
{
	int i, j, m, p;
	int col;
	byte attr;
	char buf[80];


	if (autoroller)
	{
		col = 42;
		/* Put the stats (and percents) */
		for (i = 0; i < 6; i++)
		{
			/* Race/Class bonus */
			if(IS_PURE(creature_ptr))
				j = race_info[creature_ptr->race_idx1].r_adj[i];
			else
				j = race_info[creature_ptr->race_idx1].r_s_adj[i] + race_info[creature_ptr->race_idx2].r_s_adj[i];

			j += class_info[creature_ptr->class_idx].c_adj[i] + chara_info[creature_ptr->chara_idx].a_adj[i];
			/* Obtain the current stat */
			m = adjust_stat(creature_ptr->stat_max[i], j);

			// Put the stat
			cnv_stat(m, buf);
			c_put_str(TERM_L_GREEN, buf, 3 + i, col + 24);

			if (stat_match[i]) // Put the percent
			{
				if (stat_match[i] > 1000000L)
				{
					/* Prevent overflow */
					p = stat_match[i] / (auto_round / 1000L);
				}
				else
				{
					p = 1000L * stat_match[i] / auto_round;
				}
			
				attr = (p < 100) ? TERM_YELLOW : TERM_L_GREEN;
				sprintf(buf, "%3d.%d%%", p/10, p%10);
				c_put_str(attr, buf, 3+i, col+13);
			}

			/* Never happened */
			else
			{
#ifdef JP
				c_put_str(TERM_RED, "(Ȃ)", 3+i, col+13);
#else
				c_put_str(TERM_RED, "(NONE)", 3+i, col+13);
#endif

			}
		}
	}
}


/*
 * Clear all the global "character" data
 */
void creature_wipe(creature_type *creature_ptr)
{
	int i;

	/* Hack -- free the "last message" string */
	if (creature_ptr->last_message) string_free(creature_ptr->last_message);

	/* Hack -- zero the struct */
	(void)WIPE(creature_ptr, creature_type);

	/* Wipe the history */
	for (i = 0; i < HISTORY_ROW; i++)
	{
		strcpy(creature_ptr->history[i], "");
	}

	/* No weight */
	creature_ptr->carrying_weight = 0;
	creature_ptr->equipping_weight = 0;

	/* No items */
	creature_ptr->inven_cnt = 0;
	creature_ptr->equip_cnt = 0;

	/* Clear the creature_ptr->inventory */
	for (i = 0; i < INVEN_TOTAL; i++)
	{
		object_wipe(&creature_ptr->inventory[i]);
	}


	/* Hack -- Well fed player */
	creature_ptr->food = PY_FOOD_FULL - 1;

	/* Wipe the spells */
	if (creature_ptr->class_idx == CLASS_SORCERER)
	{
		creature_ptr->spell_learned1 = creature_ptr->spell_learned2 = 0xffffffffL;
		creature_ptr->spell_worked1 = creature_ptr->spell_worked2 = 0xffffffffL;
	}
	else
	{
		creature_ptr->spell_learned1 = creature_ptr->spell_learned2 = 0L;
		creature_ptr->spell_worked1 = creature_ptr->spell_worked2 = 0L;
	}
	creature_ptr->spell_forgotten1 = creature_ptr->spell_forgotten2 = 0L;
	for (i = 0; i < 64; i++) creature_ptr->spell_order[i] = 99;
	creature_ptr->learned_spells = 0;
	creature_ptr->add_spells = 0;
	creature_ptr->knowledge = 0;

	/* Clean the mutation count */
	creature_ptr->mutant_regenerate_mod = 100;

	/* Default pet command settings */
	creature_ptr->pet_follow_distance = PET_FOLLOW_DIST;
	creature_ptr->pet_extra_flags = (PF_TELEPORT | PF_ATTACK_SPELL | PF_SUMMON_SPELL);

	/* Wipe the recall depths */
	for (i = 0; i < max_dungeon_idx; i++)
	{
		max_dlv[i] = 0;
	}

	creature_ptr->visit = 1;

	/* Reset wild_mode to FALSE */
	wild_mode = FALSE;

	for (i = 0; i < 108; i++)
	{
		creature_ptr->magic_num1[i] = 0;
		creature_ptr->magic_num2[i] = 0;
	}

	/* Level one */
	creature_ptr->max_plv = creature_ptr->lev = 1;

	/* Initialize arena and rewards information -KMW- */
	arena_number = 0;
	fight_arena_mode = FALSE;
	inside_quest = 0;
	for (i = 0; i < MAX_MANE; i++)
	{
		creature_ptr->mane_spell[i] = -1;
		creature_ptr->mane_dam[i] = 0;
	}
	creature_ptr->mane_num = 0;

	/* Reset karmas*/
	for (i = 0; i < MAX_KARMA; i++) creature_ptr->karmas[i] = 0;

	creature_ptr->recall_dungeon = DUNGEON_GALGALS;

	creature_ptr->race_idx1 = INDEX_NONE;
	creature_ptr->race_idx2 = INDEX_NONE;
	creature_ptr->mimic_race_idx = INDEX_NONE;
	creature_ptr->sex = SEX_NONE;
	creature_ptr->class_idx = INDEX_NONE;
	creature_ptr->chara_idx = INDEX_NONE;
	creature_ptr->patron_idx = INDEX_NONE;
	creature_ptr->realm1 = REALM_NONE;
	creature_ptr->realm2 = REALM_NONE;
	creature_ptr->sub_race[0] = 0x0;
	creature_ptr->sub_race[1] = 0x0;
	creature_ptr->sub_race[2] = 0x0;
	creature_ptr->sub_race[3] = 0x0;
	creature_ptr->sub_race[4] = 0x0;
	creature_ptr->sub_race[5] = 0x0;
	creature_ptr->sub_race[6] = 0x0;
	creature_ptr->sub_race[7] = 0x0;

	creature_ptr->total_winner = FALSE;

}


/*
 *  Hook function for quest creatures
 */
static bool creature_hook_quest(int species_idx)
{
	species_type *species_ptr = &species_info[species_idx];
	if (is_wild_only_species(species_ptr)) return FALSE;	// Random quests are in the dungeon
	if (is_aquatic_species(species_ptr)) return FALSE;		// No random quests for aquatic creatures
	if (is_multiply_species(species_ptr)) return FALSE;		// No random quests for multiplying creatures
	if (is_friendly_species(species_ptr)) return FALSE;		// No quests to kill friendly creatures
	return TRUE;
}


/*
 * Determine the random quest uniques
 */
void determine_random_questor(quest_type *quest_ptr)
{
	int          species_idx;
	species_type *r_ptr;

	get_species_num_prep(creature_hook_quest, NULL); // Prepare allocation table

	while (1)
	{
		/*
		 * Random creatures 5 - 10 levels out of depth
		 * (depending on level)
		 */
		species_idx = get_species_num(current_floor_ptr, quest_ptr->level + 5 + randint1(quest_ptr->level / 10));
		r_ptr = &species_info[species_idx];

		if (!is_unique_species(r_ptr)) continue;
		if (is_quest_species(r_ptr)) continue;
		if (r_ptr->rarity > 100) continue;
		if (is_friendly_species(r_ptr)) continue;
		if (is_aquatic_species(r_ptr)) continue;
		if (is_wild_only_species(r_ptr)) continue;
		if (no_questor_or_bounty_uniques(species_idx)) continue;

		/*
		 * Accept creatures that are 2 - 6 levels
		 * out of depth depending on the quest level
		 */
		if (r_ptr->level > (quest_ptr->level + (quest_ptr->level / 20))) break;
	}

	quest_ptr->species_idx = species_idx;
}


/*
 *  Initialize random quests and final quests
 */
void init_dungeon_quests(void)
{
	int number_of_quests = MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1;
	int i;

	/* Init the random quests */
	init_flags = INIT_ASSIGN;
	inside_quest = MIN_RANDOM_QUEST;

	process_dungeon_file(current_floor_ptr, "q_info.txt", 0, 0, 0, 0);

	inside_quest = 0;

	/* Generate quests */
	for (i = MIN_RANDOM_QUEST + number_of_quests - 1; i >= MIN_RANDOM_QUEST; i--)
	{
		quest_type      *quest_ptr = &quest[i];
		species_type    *quest_r_ptr;

		quest_ptr->status = QUEST_STATUS_TAKEN;
		determine_random_questor(quest_ptr);

		/* Mark uniques */
		quest_r_ptr = &species_info[quest_ptr->species_idx];
		//TODO quest_r_ptr->flags1 |= RF1_QUESTOR;

		quest_ptr->max_num = 1;
	}

	/* Init the two main quests (AOY) */
	init_flags = INIT_ASSIGN;
	inside_quest = QUEST_AOY;

	process_dungeon_file(current_floor_ptr, "q_info.txt", 0, 0, 0, 0);

	quest[QUEST_AOY].status = QUEST_STATUS_TAKEN;
	inside_quest = 0;


}

/*
 * Reset turn
 */
static void init_turn(creature_type *creature_ptr)
{
	if (is_undead_creature(creature_ptr))
	{
		/* Undead start just after midnight */
		turn = (TURNS_PER_TICK * 3 * TOWN_DAWN) / 4 + 1;
		turn_limit = TURNS_PER_TICK * TOWN_DAWN * MAX_DAYS + TURNS_PER_TICK * TOWN_DAWN * 3 / 4;
	}
	else
	{
		turn = 1;
		turn_limit = TURNS_PER_TICK * TOWN_DAWN * (MAX_DAYS - 1) + TURNS_PER_TICK * TOWN_DAWN * 3 / 4;
	}
}

static int wield_one(creature_type *creature_ptr, int item, u32b flags)
{
	object_type *object_ptr; 
	object_type *i_ptr; 
	object_type object_type_body; 
 
	int slot; 

	object_ptr = &creature_ptr->inventory[item]; 
 
	// Skip non-objects
	if (!object_ptr->k_idx) return -1; 
 
	// Make sure we can wield it and that there's nothing else in that slot
	slot = WIELD_SLOT(object_ptr);

	if (slot == INVEN_SLOT_INVENTORY) return -1; 
	if (creature_ptr->inventory[slot].k_idx) return -1; 
 
	/* Get local object */ 
	i_ptr = &object_type_body; 
	object_copy(i_ptr, object_ptr); 
 
	/* Modify quantity */ 
	i_ptr->number = 1; 
 
	/* Decrease the item (from the pack) */ 
	if (item >= 0) 
	{ 
		inven_item_increase(creature_ptr, item, -1); 
		inven_item_optimize(creature_ptr, item); 
	} 
 
	/* Decrease the item (from the floor) */ 
	else 
	{ 
		floor_item_increase(0 - item, -1); 
		floor_item_optimize(0 - item); 
	} 
 
	/* Get the wield slot */ 
	object_ptr = &creature_ptr->inventory[slot]; 
 
	/* Wear the new stuff */ 
	object_copy(object_ptr, i_ptr); 
 
	/* Increase the weight */ 
	set_inventory_weight(creature_ptr);
 
	/* Increment the equip counter by hand */ 
	creature_ptr->equip_cnt++;

	return slot; 
}


/* 
 * Try to wield everything wieldable in the inventory. 
 * Code taken from Angband 3.1.0 under Angband license
 */ 
static void wield_all(creature_type *creature_ptr, u32b flags) 
{ 
	int item;
	/* Scan through the slots backwards */ 
	for (item = INVEN_TOTAL - 1; item >= 0; item--) 
	{
		wield_one(creature_ptr, item, flags);
 	} 
	return; 
} 



/*
 * Hook function for human corpses
 */
bool creature_hook_human(int species_idx)
{
	species_type *r_ptr = &species_info[species_idx];

	if (is_unique_species(r_ptr)) return FALSE;

	if (my_strchr("pht", r_ptr->d_char)) return TRUE;

	return FALSE;
}


/*
 * Add an outfit object
 */
void add_outfit(creature_type *creature_ptr, object_type *object_ptr, u32b flags)
{
	s16b slot;

	if(is_player(creature_ptr))
	{
		object_aware(object_ptr);
		object_known(object_ptr);
	}
	slot = inven_carry(creature_ptr, object_ptr);

	/* Auto-inscription */
	autopick_alter_item(creature_ptr, slot, FALSE);

	if(!(flags & ADD_OUTFIT_MULTIPLE_FENCING) && object_is_weapon(object_ptr))
	{
		if(get_equip_weapon_num(creature_ptr) >= 1) return;
	}

	/* Now try wielding everything */ 
	if(flags & ADD_OUTFIT_EQUIP) wield_all(creature_ptr, flags); 
}


void race_detail(int code)
{
	bool e;
	int base = 5;
	int i, pena = 0;
	char buf[100], temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++)
		prt("                                                                       ", base + i, 24);
	if(code < 0) return;

#ifdef JP
	c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
	put_str("̎푰C", base, 24+strlen(race_info[code].title));
	put_str("r    m\        p    ϋv         o   ", base+1, 24);
#else
	c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
	put_str("'s Main-Race modification", base, 24+strlen(race_info[code].title));
	put_str("Str     Int     Wis     Dex     Con     Chr      EXP   ", base+1, 24);
#endif

	sprintf(buf, "%+3d>%+3d %+3d>%+3d %+3d>%+3d %+3d>%+3d %+3d>%+3d %+3d>%+3d  %+4d%% ",
		race_info[code].r_adj[0] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_STR), race_info[code].r_adj[0],
		race_info[code].r_adj[1] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_INT), race_info[code].r_adj[1],
		race_info[code].r_adj[2] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_WIS), race_info[code].r_adj[2],
		race_info[code].r_adj[3] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_DEX), race_info[code].r_adj[3],
		race_info[code].r_adj[4] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_CON), race_info[code].r_adj[4],
		race_info[code].r_adj[5] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_CHA), race_info[code].r_adj[5],
		(race_info[code].r_exp - 100));
	c_put_str(TERM_L_BLUE, buf, base+2, 23);
	c_put_str(TERM_L_WHITE, ">", base+2, 26);
	c_put_str(TERM_L_WHITE, ">", base+2, 34);
	c_put_str(TERM_L_WHITE, ">", base+2, 42);
	c_put_str(TERM_L_WHITE, ">", base+2, 50);
	c_put_str(TERM_L_WHITE, ">", base+2, 58);
	c_put_str(TERM_L_WHITE, ">", base+2, 66);

#ifdef JP
	put_str("bx:   b_i:", base, 53);
#else
	put_str("Base Level:   Base DR :", base, 53);
#endif

	sprintf(buf, "%2d", race_info[code].lev);
	c_put_str(TERM_L_BLUE, buf, base, 64);

	if(race_info[code].dr >= 0)
	{
		sprintf(buf, "%2d", race_info[code].dr);
		c_put_str(TERM_L_BLUE, buf, base, 76);
	}
	else
		c_put_str(TERM_L_DARK, "--", base, 76);

	roff_to_buf(race_text + race_info[code].text, 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;

		if(e)
		{
			prt("                                                                       ", base+4 + i, 24);
		}
		else
		{
			prt(t, base+4 + i, 24);
			t += strlen(t) + 1;
		}
	}
}

void subrace_detail(int code)
{
	bool e;
	int base = 5;
	int i, pena = 0;
	char buf[100], temp[58*18];
	cptr t;

	if(code >= 0)
	{
		put_str("                                                  " , base, 24);
		put_str("                                                  " , base+1, 24);
		put_str("                                                  " , base+2, 24);
#ifdef JP
		c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
		put_str("̕푰C", base, 24+strlen(race_info[code].title));
		put_str("r    m\        p    ϋv         o   ", base+1, 24);
#else
		c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
		put_str("'s Sub-Race modification", base, 24+strlen(race_info[code].title));
		put_str("Str     Int     Wis     Dex     Con     Chr      EXP   ", base+1, 24);
#endif

		sprintf(buf, "%+2d      %+2d      %+2d      %+2d      %+2d      %+2d      %+4d%% ",
			race_info[code].r_s_adj[0],
			race_info[code].r_s_adj[1],
			race_info[code].r_s_adj[2],
			race_info[code].r_s_adj[3],
			race_info[code].r_s_adj[4],
			race_info[code].r_s_adj[5],
			(race_info[code].r_s_exp - 100));
		c_put_str(TERM_L_BLUE, buf, base+2, 24);

		roff_to_buf(race_text + race_info[code].text, 56, temp, sizeof(temp));
		t = temp;
		e = FALSE;
		for (i = 0; i < 18; i++)
		{
			if(!e)
				if(t[0] == 0) e = TRUE;

			if(e)
			{
				prt("                                                                       ", base+4 + i, 24);
			}
			else
			{
				prt(t, base+4 + i, 24);
				t += strlen(t) + 1;
			}
		}
	}
	else
	{
		put_str("                                                      " , base, 24);
		put_str("                                                      " , base+1, 24);
		put_str("                                                      " , base+2, 24);
		for (i = 0; i < 18; i++)
			prt("                                                                       ", base+4 + i, 24);
	}


}

void class_detail(int code)
{
	bool e;
	int base = 5;
	int i, pena = 0;
	char buf[100], temp[58*18];
	cptr t;
	put_str("                                                      " , base, 24);
	put_str("                                                      " , base+1, 24);
	put_str("                                                      " , base+2, 24);

	for (i = 0; i < 18; i++)
	{
		prt("                                                                       ", base+4 + i, 24);
	}

	if(code < 0) return;

#ifdef JP
	c_put_str(TERM_L_BLUE, class_info[code].title, base, 24);
	put_str("̎푰C", base, 24+strlen(class_info[code].title));
	put_str("r    m\        p    ϋv         o   ", base+1, 24);
#else
	c_put_str(TERM_L_BLUE, class_info[code].title, base, 24);
	put_str("'s Main-Race modification", base, 24+strlen(class_info[code].title));
	put_str("Str     Int     Wis     Dex     Con     Chr      EXP   ", base+1, 24);
#endif

	sprintf(buf, "%+2d      %+2d      %+2d      %+2d       %+2d      %+2d     %+4d%% ",
		class_info[code].c_adj[0],
		class_info[code].c_adj[1],
		class_info[code].c_adj[2],
		class_info[code].c_adj[3],
		class_info[code].c_adj[4],
		class_info[code].c_adj[5],
		class_info[code].c_exp);
	c_put_str(TERM_L_BLUE, buf, base+2, 24);

	roff_to_buf(class_jouhou[code], 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base+4 + i, 24);
			t += strlen(t) + 1;
		}
	}
}


void chara_detail(int code)
{
	bool e;
	int base = 5;
	int i, pena = 0;
	char buf[100], temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++)
		prt("                                                                       ", base + i, 24);
	if(code < 0) return;

#ifdef JP
	c_put_str(TERM_L_BLUE, chara_info[code].title, base, 24);
	put_str("̎푰C", base, 24+strlen(chara_info[code].title));
	put_str("r    m\        p    ϋv         o   ", base+1, 24);
#else
	c_put_str(TERM_L_BLUE, chara_info[code].title, base, 24);
	put_str("'s Main-Race modification", base, 24+strlen(chara_info[code].title));
	put_str("Str     Int     Wis     Dex     Con     Chr      EXP   ", base+1, 24);
#endif

	sprintf(buf, "%+2d      %+2d      %+2d      %+2d       %+2d      %+2d     %+4d%% ",
		chara_info[code].a_adj[0],
		chara_info[code].a_adj[1],
		chara_info[code].a_adj[2],
		chara_info[code].a_adj[3],
		chara_info[code].a_adj[4],
		chara_info[code].a_adj[5],
		0);
	c_put_str(TERM_L_BLUE, buf, base+2, 24);

	roff_to_buf(chara_jouhou[code], 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base+4 + i, 24);
			t += strlen(t) + 1;
		}
	}
}


void realm_detail(int code)
{
	bool e;
	int base = 5;
	int i, pena = 0;
	char temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++)
		prt("                                                                       ", base + i, 24);

	if(code < 0) return;

	roff_to_buf(realm_jouhou[technic2magic(code)-1], 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base + i, 24);
			t += strlen(t) + 1;
		}
	}
}

void starting_point_detail(int code)
{
	bool e;
	int base = 5;
	int i, pena = 0;
	char temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++)
		prt("                                                                       ", base + i, 24);

	if(code < 0) return;

	roff_to_buf(starting_point_jouhou[code], 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base + i, 24);
			t += strlen(t) + 1;
		}
	}
}


/*
 * Creature race
 */
static int get_creature_first_race(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int     n, i;
	selection se[MAX_RACES + 3];

	if(species_ptr->race_idx1 != INDEX_VARIABLE)
	{
		creature_ptr->race_idx1 = species_ptr->race_idx1;
		return 0;
	}

	for (i = 0, n = 0; i < MAX_RACES; i++)
	{
		if(race_info[i].race_category < RACE_RARELITY_UNSELECTABLE)
		{
			strcpy(se[n].cap, race_name + race_info[i].name);
			se[n].code = i;
			se[n].key = '\0';
			se[n].d_color = TERM_L_DARK;
			se[n].l_color = TERM_WHITE;
			n++;
		}
	}

	if(npc)
	{
		creature_ptr->race_idx1 = se[randint0(n)].code;
		return 0;
	}

#if JP
	strcpy(se[n].cap, "_");
#else
	strcpy(se[n].cap, "Random");
#endif
	se[n].code = -1;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "ŏɖ߂");
#else
	strcpy(se[n].cap, "Back to start");
#endif
	se[n].code = -2;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "I");
#else
	strcpy(se[n].cap, "Quit game");
#endif
	se[n].code = -3;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	put_str("푰Iĉ:", 0, 0);
#else
	put_str("Select a race:", 0, 0);
#endif

	i = get_selection(se, n, 0, 5, 2, 18, 20, race_detail, 0);

	if(i >= 0)
	{
		creature_ptr->race_idx1 = i;
		return 0;
	}
	else if(i == -1)
	{
		creature_ptr->race_idx1 = se[randint0(n - 3)].code;
		return 0;
	}
	else
	{
		return i;
	}
}


/*
 * Creature sub-race
 */
static int get_creature_second_race(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int     n = 0, i;
	selection se[MAX_RACES + 3];

	if(species_ptr->race_idx2 != INDEX_VARIABLE)
	{
		creature_ptr->race_idx2 = species_ptr->race_idx2;
		return 0;
	}

#if JP
	strcpy(se[n].cap, "");
#else
	strcpy(se[n].cap, "Pure Breed");
#endif
	se[n].code = creature_ptr->race_idx1;
	se[n].key = '\0';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	for (i = 0; i < MAX_RACES; i++)
	{
		if(race_crossing[creature_ptr->race_idx1][i] > 0 && creature_ptr->race_idx1 != i)
		{
			strcpy(se[n].cap, race_info[i].title);
			se[n].code = i;
			se[n].key = '\0';
			se[n].d_color = TERM_L_DARK;
			se[n].l_color = TERM_WHITE;
			n++;
		}
	}

#if JP
	strcpy(se[n].cap, "_");
#else
	strcpy(se[n].cap, "Random");
#endif
	se[n].code = -1;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "ŏɖ߂");
#else
	strcpy(se[n].cap, "Back to start");
#endif
	se[n].code = -2;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "I");
#else
	strcpy(se[n].cap, "Quit game");
#endif
	se[n].code = -3;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	if(npc)
	{
		if(one_in_(RATE_OF_HALF_RACE))
		{
			creature_ptr->race_idx2 = se[randint0(n-3)].code;
			return 0;
		}
		else
		{
			creature_ptr->race_idx2 = creature_ptr->race_idx1;
			return 0;
		}
	}

#if JP
		put_str("푰Iĉ:", 0, 0);
#else
		put_str("Select second race:", 0, 0);
#endif
		i = get_selection(se, n, 0, 5, 2, 18, 20, race_detail, 0);

	if(i >= 0)
	{
		creature_ptr->race_idx2 = i;
		return 0;
	}
	else if(i == -1)
	{
		int t = randint0(n-3);
		creature_ptr->race_idx2 = se[t].code;
		return 0;
	}
	else
	{
		return i;
	}
}


/*
 * Player SubRace(Eldar)
 */
static bool get_creature_subrace_eldar(creature_type *creature_ptr, bool npc)
{
/*
	int     i, n = 0;
	selection se[3 + 3];

	strcpy(se[n].cap, race_info[RACE_TELERI_LINEAGE].title);
	se[n].code = RACE_TELERI_LINEAGE;
	se[n].key = '\0';
	se[n].d_color = TERM_L_DARK;
	se[n].l_color = TERM_WHITE;
	n++;

	strcpy(se[n].cap, race_info[RACE_NOLDOR_LINEAGE].title);
	se[n].code = RACE_NOLDOR_LINEAGE;
	se[n].key = '\0';
	se[n].d_color = TERM_L_DARK;
	se[n].l_color = TERM_WHITE;
	n++;

	strcpy(se[n].cap, race_info[RACE_VANYAR_LINEAGE].title);
	se[n].code = RACE_VANYAR_LINEAGE;
	se[n].key = '\0';
	se[n].d_color = TERM_L_DARK;
	se[n].l_color = TERM_WHITE;
	n++;

#if JP
	strcpy(se[n].cap, "_");
#else
	strcpy(se[n].cap, "Random");
#endif
	se[n].code = -1;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "ŏɖ߂");
#else
	strcpy(se[n].cap, "Back to start");
#endif
	se[n].code = -2;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "I");
#else
	strcpy(se[n].cap, "Quit game");
#endif
	se[n].code = -3;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	if(!npc)
	{
#if JP
		put_str("G_[̕푰Iĉ:", 0, 0);
#else
		put_str("Select a sub-race of Eldar:", 0, 0);
#endif
		i = get_selection(se, n, 5, 2, 18, 20, subrace_detail, 0);
	}
	else
	{
		set_subrace(creature_ptr, se[randint0(3)].code, TRUE);
		return 0;
	}

	if(i >= 0)
	{
		set_subrace(creature_ptr, i, TRUE);
		return 0;
	}
	if(i == -1)
	{
		set_subrace(creature_ptr, se[randint0(3)].code, TRUE);
		return 0;
	}
	else
	{
		return i;
	}


*/
	return 0;

}


/*
 * Creature SubRace(Dragon & Draconian)
 */
static bool get_creature_subrace_dragonbone(creature_type *creature_ptr, bool npc)
{
/*
	int     i, n = 0;
	selection se[15];

	strcpy(se[n].cap, race_info[RACE_RED_LINEAGE].title);
	se[n].code = RACE_RED_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_WHITE_LINEAGE].title);
	se[n].code = RACE_WHITE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BLUE_LINEAGE].title);
	se[n].code = RACE_BLUE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BLACK_LINEAGE].title);
	se[n].code = RACE_BLACK_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_GREEN_LINEAGE].title);
	se[n].code = RACE_GREEN_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_CHROMATIC_LINEAGE].title);
	se[n].code = RACE_CHROMATIC_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BRONZE_LINEAGE].title);
	se[n].code = RACE_BRONZE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_GOLD_LINEAGE].title);
	se[n].code = RACE_GOLD_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_CRYSTAL_LINEAGE].title);
	se[n].code = RACE_CRYSTAL_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_LAW_LINEAGE].title);
	se[n].code = RACE_LAW_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BALANCE_LINEAGE].title);
	se[n].code = RACE_BALANCE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_CHAOS_LINEAGE].title);
	n++;
	se[n].code = RACE_CHAOS_LINEAGE;

	for(i = 0; i < 12; i++)
	{
		se[i].d_color = TERM_L_DARK;
		se[i].l_color = TERM_WHITE;
		se[i].key = '\0';
	}

#if JP
	strcpy(se[n].cap, "_");
#else
	strcpy(se[n].cap, "Random");
#endif
	se[n].code = -1;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "ŏɖ߂");
#else
	strcpy(se[n].cap, "Back to start");
#endif
	se[n].code = -2;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "I");
#else
	strcpy(se[n].cap, "Quit game");
#endif
	se[n].code = -3;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	if(!npc)
	{
#if JP
		put_str("̕푰Iĉ:", 0, 0);
#else
		put_str("Select a sub-race of Dragonbone:", 0, 0);
#endif
		i = get_selection(se, n, 5, 2, 18, 20, subrace_detail, 0);
	}
	else
	{
		set_subrace(creature_ptr, se[randint0(12)].code, TRUE);
		return 0;
	}

	if(i >= 0)
	{
		set_subrace(creature_ptr, i, TRUE);
		return 0;
	}
	if(i == -1)
	{
		set_subrace(creature_ptr, se[randint0(12)].code, TRUE);
		return 0;
	}
	else
	{
		return i;
	}

*/
	/* Success */
	return TRUE;

}

/*
 * Creature sex
 */
static bool get_creature_sex(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, n;
	selection se[MAX_SEXES + 3];
	int list[MAX_SEXES] = {SEX_MALE, SEX_FEMALE, SEX_INTERSEX, SEX_NONE};

	if(species_ptr->sex != INDEX_VARIABLE)
	{
		creature_ptr->sex = species_ptr->sex;
		return 0;
	}

	for (i = 0, n = 0; i < MAX_SEXES; i++)
	{
		strcpy(se[n].cap, sex_info[list[i]].title);
		se[n].code = list[i];
		se[n].key = '\0';
		if(race_info[creature_ptr->race_idx1].sex_flag & (0x01 << list[i]) ||
		   race_info[creature_ptr->race_idx2].sex_flag & (0x01 << list[i]))
		{
			se[n].d_color = TERM_L_DARK;
			se[n].l_color = TERM_WHITE;
		}
		else
		{
			se[n].d_color = TERM_RED;
			se[n].l_color = TERM_L_RED;
		}
		n++;
	}

#if JP
	strcpy(se[n].cap, "_");
#else
	strcpy(se[n].cap, "Random");
#endif
	se[n].code = -1;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "ŏɖ߂");
#else
	strcpy(se[n].cap, "Back to start");
#endif
	se[n].code = -2;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "I");
#else
	strcpy(se[n].cap, "Quit game");
#endif
	se[n].code = -3;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	if(npc)
	{
		creature_ptr->sex = se[randint0(4)].code;
		return 0;
	}

#if JP
		put_str("ʂIĉ(Ԏ̐ʂɂ͎푰yieB܂):", 0, 0);
#else
		put_str("Select a sex(Red entries have race penalty) ", 0, 0);
#endif
		i = get_selection(se, n, 0, 5, 2, 18, 20, NULL, 0);


	if(i >= 0)
	{
		creature_ptr->sex = i;
		return 0;
	}
	else if(i == -1)
	{
		creature_ptr->sex = se[randint0(4)].code;
		return 0;
	}
	else
	{
		return i;
	}
}


/*
 * Player class
 */
static bool get_creature_class(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, n;
	selection ce[MAX_CLASS+3];

	if(species_ptr->class_idx != INDEX_VARIABLE)
	{
		creature_ptr->class_idx = species_ptr->class_idx;
		return 0;
	}

	clear_from(0);
	put_initial_status(creature_ptr);

	for (i = 0, n = 0; i < MAX_CLASS; i++)
	{
		if(class_info[i].rarelity != CLASS_RARELITY_UNSELECTED)
		{
			strcpy(ce[n].cap, class_info[i].title);
			ce[n].code = i;
			ce[n].key = '\0';
			ce[n].d_color = TERM_L_DARK;
			ce[n].l_color = TERM_WHITE;
			if(SUITABLE_CLASS(creature_ptr, i))
			{
				ce[n].d_color = TERM_GREEN;
				ce[n].l_color = TERM_L_GREEN;
			}
			else
			{
				ce[n].d_color = TERM_L_DARK;
				ce[n].l_color = TERM_WHITE;
			}
			n++;
		}
	}

	if(npc)
	{
		creature_ptr->class_idx = ce[randint0(n)].code;
		return 0;
	}

#if JP
	strcpy(ce[n].cap, "_");
#else
	strcpy(ce[n].cap, "Random");
#endif
	ce[n].code = -1;
	ce[n].key = '*';
	ce[n].d_color = TERM_UMBER;
	ce[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(ce[n].cap, "ŏɖ߂");
#else
	strcpy(ce[n].cap, "Back to start");
#endif
	ce[n].code = -2;
	ce[n].key = 'S';
	ce[n].d_color = TERM_UMBER;
	ce[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(ce[n].cap, "I");
#else
	strcpy(ce[n].cap, "Quit game");
#endif
	ce[n].code = -3;
	ce[n].key = 'Q';
	ce[n].d_color = TERM_UMBER;
	ce[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	put_str("EƂIĉ(Ύ̐EƂɂ͎푰{[iX܂):", 0, 0);
#else
	put_str("Select a class(Any green entries have race bonus):", 0, 0);
#endif
	put_initial_status(creature_ptr);
	i = get_selection(ce, n, 0, 5, 2, 18, 20, class_detail, 0);

	if(i >= 0)
	{
		creature_ptr->class_idx = i;
		return 0;
	}
	else if(i == -1)
	{
		creature_ptr->class_idx = ce[randint0(n - 3)].code;
		return 0;
	}
	else
	{
		return i;
	}

}

/*
 * Player patron
 */
static bool get_creature_patron(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, n = 0;
	selection pt[400+3];

	if(species_ptr->patron_idx != INDEX_VARIABLE)
	{
		creature_ptr->patron_idx = species_ptr->patron_idx;
		return 0;
	}

	for (i = 0; i < max_species_idx; i++)
	{
		if(!is_unique_species(&species_info[i])) continue;		
		if(species_info[i].dr < 5 || species_info[i].dr < calc_base_divine_rank(creature_ptr)) continue;
		
		if(IS_PURE_RACE(creature_ptr, RACE_MELNIBONE))
		{
			if(i != MON_ARIOCH) continue;
		}

		if(IS_PURE_RACE(creature_ptr, RACE_AMBERITE))
		{
			if(i != MON_UNICORN_ORD) continue;
		}

		if(IS_PURE_RACE(creature_ptr, RACE_CHAOSIAN))
		{
			if(i != MON_SERPENT) continue;
		}

		if(IS_PURE_RACE(creature_ptr, RACE_ISTARI))
		{
			if(!has_trait_raw(&species_info[i].flags, TRAIT_AMAN)) continue;		
		}

		strcpy(pt[n].cap, species_name + species_info[i].name);
		pt[n].code = i;
		pt[n].key = '\0';
		pt[n].d_color = TERM_L_DARK;
		pt[n].l_color = TERM_WHITE;
		n++; 
		
		if(n == 400) break;
	}


#if JP
	strcpy(pt[n].cap, "_");
#else
	strcpy(pt[n].cap, "Random");
#endif
	pt[n].code = -1;
	pt[n].key = '*';
	pt[n].d_color = TERM_UMBER;
	pt[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(pt[n].cap, "ŏɖ߂");
#else
	strcpy(pt[n].cap, "Back to start");
#endif
	pt[n].code = -2;
	pt[n].key = 'S';
	pt[n].d_color = TERM_UMBER;
	pt[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(pt[n].cap, "I");
#else
	strcpy(pt[n].cap, "Quit game");
#endif
	pt[n].code = -3;
	pt[n].key = 'Q';
	pt[n].d_color = TERM_UMBER;
	pt[n].l_color = TERM_L_UMBER;
	n++;

	if(npc)
	{
		creature_ptr->patron_idx = pt[randint0(n)].code;
		return 0;
	}

#if JP
	put_str("_Iĉ:", 0, 0);
#else
	put_str("Select a patron:", 0, 0);
#endif
	put_initial_status(creature_ptr);
	i = get_selection(pt, n, 0, 5, 2, 18, 76, NULL, 0);

	if(i >= 0)
	{
		creature_ptr->patron_idx = i;
		return 0;
	}
	else if(i == -1)
	{
		creature_ptr->patron_idx = pt[randint0(n - 3)].code;
		return 0;
	}
	else
	{
		return i;
	}

}


/*
 * Player Chara
 */
static bool get_chara_type(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, n;
	selection ce[MAX_CHARA + 3];
	int id[MAX_CHARA];
	int rarity[MAX_CHARA];

	if(!npc)
	{
		clear_from(0);
		put_initial_status(creature_ptr);
	}

	if(creature_ptr->patron_idx == SPECIES_ILUVATAR)
	{
		creature_ptr->chara_idx = CHARA_MUNCHKIN;
		return 0;
	}

	if(species_ptr->chara_idx != INDEX_VARIABLE)
	{
		creature_ptr->chara_idx = species_ptr->chara_idx;
		return 0;
	}

	for (i = 0, n = 0; i < MAX_CHARA; i++)
	{
		if((chara_info[i].sex & (0x01 << creature_ptr->sex)) && (!npc || chara_info[i].rarity < 100))
		{
			strcpy(ce[n].cap, chara_info[i].title);
			ce[n].code = i;
			ce[n].key = '\0';
			ce[n].d_color = TERM_L_DARK;
			ce[n].l_color = TERM_WHITE;

			id[n] = i;
			rarity[n] = chara_info[i].rarity;
			n++;
		}
	}

	if(npc)
	{
		creature_ptr->chara_idx = uneven_rand(id, rarity, n);
		return 0;
	}

#if JP
	strcpy(ce[n].cap, "_");
#else
	strcpy(ce[n].cap, "Random");
#endif
	ce[n].code = -1;
	ce[n].key = '*';
	ce[n].d_color = TERM_UMBER;
	ce[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(ce[n].cap, "ŏɖ߂");
#else
	strcpy(ce[n].cap, "Back to start");
#endif
	ce[n].code = -2;
	ce[n].key = 'S';
	ce[n].d_color = TERM_UMBER;
	ce[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(ce[n].cap, "I");
#else
	strcpy(ce[n].cap, "Quit game");
#endif
	ce[n].code = -3;
	ce[n].key = 'Q';
	ce[n].d_color = TERM_UMBER;
	ce[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	put_str("iIĉ:", 0, 0);


#else
	put_str("Select a personality:", 0, 0);
#endif
	put_initial_status(creature_ptr);
	i = get_selection(ce, n, 0, 5, 2, 18, 20, chara_detail, 0);

	if(i >= 0)
	{
		creature_ptr->chara_idx = i;
		return 0;
	}
	else if(i == -1)
	{
		creature_ptr->chara_idx = uneven_rand(id, rarity, n - 3);
		return 0;
	}
	else
	{
		return i;
	}

	/* Success */
	return 0;
}


/*
 * Player Starting Point
 */
static bool get_starting_point(creature_type *creature_ptr, bool npc)
{
	int i, j, n;
	selection se[STARTING_MAX + 3];

	clear_from(0);
	put_initial_status(creature_ptr);

	for (i = 0, n = 0; i < STARTING_MAX; i++)
	{
		if(starting_point[i].enable)
		{
			strcpy(se[n].cap, starting_point[i].name);
			se[n].code = i;
			se[n].key = '\0';
			se[n].d_color = TERM_L_DARK;
			se[n].l_color = TERM_WHITE;
			n++;
		}
	}

#if JP
	strcpy(se[n].cap, "_");
#else
	strcpy(se[n].cap, "Random");
#endif
	se[n].code = -1;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "ŏɖ߂");
#else
	strcpy(se[n].cap, "Back to start");
#endif
	se[n].code = -2;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

#if JP
	strcpy(se[n].cap, "I");
#else
	strcpy(se[n].cap, "Quit game");
#endif
	se[n].code = -3;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	if(!npc)
	{
#if JP
		put_str("Jnn_Iĉ:", 0, 0);
#else
		put_str("Select a starting point:", 0, 0);
#endif
		i = get_selection(se, n, 0, 5, 2, 18, 20, starting_point_detail, 0);
	}
	else
	{
		j = se[randint0(n - 3)].code;
		creature_ptr->start_wy = starting_point[j].wy;
		creature_ptr->start_wx = starting_point[j].wx;
		return 0;
	}

	if(i >= 0)
	{
		creature_ptr->start_wy = starting_point[i].wy;
		creature_ptr->start_wx = starting_point[i].wx;
		return 0;
	}
	else if(i == -1)
	{
		j = se[randint0(n - 3)].code;
		creature_ptr->start_wy = starting_point[j].wy;
		creature_ptr->start_wx = starting_point[j].wx;
		return 0;
	}
	else
	{
		return i;
	}

	/* Success */
	return 0;
}

static bool get_stat_limits(creature_type *creature_ptr)
{
	int i, j, m, cs, os;
	int mval[6], cval[6];
	char c;
	char buf[80], cur[80];
	char inp[80];

	/* Clean up */
	clear_from(0);

	/* Extra infomation */
#ifdef JP
	put_str("Œ\͒lݒ肵ĉB", 10, 10);
	put_str("2/8ōڑIA4/6Œl̑AEnterŎ", 11, 10);
#else
	put_str("Set minimum stats.", 10, 10);
	put_str("2/8 for Select, 4/6 for Change value, Enter for Goto next", 11, 10);
#endif
	
#ifdef JP
	put_str("         {l  푰 E i     vl  ől", 13, 10);
#else
	put_str("           Base   Rac  Cla  Per      Total  Maximum", 13, 10);
#endif

	/* Output the maximum stats */
	for (i = 0; i < 6; i++)
	{
		/* Reset the "success" counter */
		stat_match[i] = 0;
		cval[i] = 3;

		/* Race/Class bonus */
		if(IS_PURE(creature_ptr))
			j = race_info[creature_ptr->race_idx1].r_adj[i];
		else
			j = race_info[creature_ptr->race_idx1].r_s_adj[i] + race_info[creature_ptr->race_idx2].r_s_adj[i];
		
		j += class_info[creature_ptr->class_idx].c_adj[i] + chara_info[creature_ptr->chara_idx].a_adj[i];

		/* Obtain the "maximal" stat */
		m = adjust_stat(17, j);

		/* Save the maximum */
		mval[i] = m;

		/* Above 18 */
		if (m > 18)
		{
#ifdef JP
			sprintf(cur, "18/%02d", (m - 18));
#else
			sprintf(cur, "18/%02d", (m - 18));
#endif
		}
		
		/* From 3 to 18 */
		else
		{
#ifdef JP
			sprintf(cur, "%2d", m);
#else
			sprintf(cur, "%2d", m);
#endif
		}

		/* Obtain the current stat */
		m = adjust_stat(cval[i], j);

		/* Above 18 */
		if (m > 18)
		{
#ifdef JP
			sprintf(inp, "18/%02d", (m - 18));
#else
			sprintf(inp, "18/%02d", (m - 18));
#endif
		}
		
		/* From 3 to 18 */
		else
		{
#ifdef JP
			sprintf(inp, "%2d", m);
#else
			sprintf(inp, "%2d", m);
#endif
		}

		/* Prepare a prompt */
		//TODO
		sprintf(buf, "%6s       %2d   %+3d  %+3d  %+3d  =  %6s  %6s",
			stat_names[i], cval[i], race_info[creature_ptr->race_idx1].r_adj[i], class_info[creature_ptr->class_idx].c_adj[i],
			chara_info[creature_ptr->chara_idx].a_adj[i], inp, cur);
		
		/* Dump the prompt */
		put_str(buf, 14 + i, 10);
	}
	
	/* Get a minimum stat */
	cs = 0;
	os = 6;
	while (TRUE)
	{
		/* Move Cursol */
		if (cs != os)
		{
			if(os == 6)
			{
#ifdef JP
				c_put_str(TERM_WHITE, "肷", 21, 35);
#else
				c_put_str(TERM_WHITE, "Accept", 21, 35);
#endif
			}
			else if(os < 6)
				c_put_str(TERM_WHITE, cur, 14 + os, 10);
			
			if(cs == 6)
			{
#ifdef JP
				c_put_str(TERM_YELLOW, "肷", 21, 35);
#else
				c_put_str(TERM_YELLOW, "Accept", 21, 35);
#endif
			}
			else
			{
				/* Race/Class bonus */
				j = race_info[creature_ptr->race_idx1].r_adj[cs] + class_info[creature_ptr->class_idx].c_adj[cs] + chara_info[creature_ptr->chara_idx].a_adj[cs];

				/* Obtain the current stat */
				m = adjust_stat(cval[cs], j);
				
				/* Above 18 */
				if (m > 18)
				{
#ifdef JP
					sprintf(inp, "18/%02d", (m - 18));
#else
					sprintf(inp, "18/%02d", (m - 18));
#endif
				}
				
				/* From 3 to 18 */
				else
				{
#ifdef JP
					sprintf(inp, "%2d", m);
#else
					sprintf(inp, "%2d", m);
#endif
				}
				
				/* Prepare a prompt */
				sprintf(cur, "%6s       %2d   %+3d  %+3d  %+3d  =  %6s",
					stat_names[cs], cval[cs], race_info[creature_ptr->race_idx1].r_adj[cs],
					class_info[creature_ptr->class_idx].c_adj[cs], chara_info[creature_ptr->chara_idx].a_adj[cs], inp);
				c_put_str(TERM_YELLOW, cur, 14 + cs, 10);
			}
			os = cs;
		}
		
		/* Prompt for the minimum stats */
		c = inkey();
		switch ( c ){
		case 'Q':
			birth_quit();
		case 'S':
			return FALSE;
		case ESCAPE:
			break;
		case ' ':
		case '\r':
		case '\n':
			if(cs == 6) break;
			cs++;
			c = '2';
			break;
		case '8':
		case 'k':
			if (cs > 0) cs--;
			break;
		case '2':
		case 'j':
			if (cs < 6) cs++;
			break;
		case '4':
		case 'h':
			if (cs != 6)
			{
				if (cval[cs] == 3)
				{
					cval[cs] = 17;
					os = 7;
				}
				else if (cval[cs] > 3)
				{
					cval[cs]--;
					os = 7;
				}
				else return FALSE;
			}
			break;
		case '6':
		case 'l':
			if (cs != 6)
			{
				if (cval[cs] == 17)
				{
					cval[cs] = 3;
					os = 7;
				}
				else if (cval[cs] < 17)
				{
					cval[cs]++;
					os = 7;
				}
				else return FALSE;
			}
			break;
		case 'm':
			if(cs != 6)
			{
				cval[cs] = 17;
				os = 7;
			}
			break;
		case 'n':
			if(cs != 6)
			{
				cval[cs] = 3;
				os = 7;
			}
			break;
		case '?':
#ifdef JP
			show_help("jbirth.txt#AutoRoller");
#else
			show_help("birth.txt#AutoRoller");
#endif
			break;
		case '=':
			screen_save();
#ifdef JP
			do_cmd_options_aux(OPT_PAGE_BIRTH, "IvV((*)̓XRAɉe)");
#else
			do_cmd_options_aux(OPT_PAGE_BIRTH, "Birth Option((*)s effect score)");
#endif

			screen_load();
			break;
		default:
			bell();
			break;
		}
		if(c == ESCAPE || ((c == ' ' || c == '\r' || c == '\n') && cs == 6))break;
	}
	
	for (i = 0; i < 6; i++)
	{
		/* Save the minimum stat */
		stat_limit[i] = cval[i];
	}

	return TRUE;
}

static bool get_chara_limits(creature_type *creature_ptr)
{
#define MAXITEMS 8

	int i, j, m, cs, os;
	int mval[MAXITEMS], cval[MAXITEMS];
	int max_percent, min_percent;
	char c;
	char buf[80], cur[80];
	cptr itemname[] = {
#ifdef JP
		"N",
		"g(cm)",
		"̏d(kg)",
		"n"
#else
		"age",
		"height",
		"weight",
		"social class"
#endif
	};

	/* Clean up */
	clear_from(10);
	
	/* Prompt for the minimum stats */
#ifdef JP
	put_str("2/4/6/8ōڑIA+/-Œl̑AEnterŎ", 11, 10);
	put_str("ӁFgƑ̏d̍ől/ŏl肬̒l͔ɏomႭȂ܂B", 23, 2);
#else
	put_str("2/4/6/8 for Select, +/- for Change value, Enter for Goto next", 11, 10);
	put_str("Caution: Values near minimum or maximum is extremery rare.", 23, 5);
#endif
	
	if (creature_ptr->sex == SEX_MALE)
	{
		max_percent = (int)(race_info[creature_ptr->race_idx1].m_b_ht+race_info[creature_ptr->race_idx1].m_m_ht*4-1) * 100 / (int)(race_info[creature_ptr->race_idx1].m_b_ht);
		min_percent = (int)(race_info[creature_ptr->race_idx1].m_b_ht-race_info[creature_ptr->race_idx1].m_m_ht*4+1) * 100 / (int)(race_info[creature_ptr->race_idx1].m_b_ht);
	}
	else
	{
		max_percent = (int)(race_info[creature_ptr->race_idx1].f_b_ht+race_info[creature_ptr->race_idx1].f_m_ht*4-1) * 100 / (int)(race_info[creature_ptr->race_idx1].f_b_ht);
		min_percent = (int)(race_info[creature_ptr->race_idx1].f_b_ht-race_info[creature_ptr->race_idx1].f_m_ht*4+1) * 100 / (int)(race_info[creature_ptr->race_idx1].f_b_ht);
	}
	
#ifdef JP
	put_str("̊i/nʂ̍ŏl/őlݒ肵ĉB", 10, 10);
	put_str("                       ŏl  ől", 13,20);
#else
	put_str(" Parameter                    Min     Max", 13,20);
	put_str("Set minimum/maximum attribute.", 10, 10);
#endif

	/* Output the maximum stats */
	for (i = 0; i < MAXITEMS; i++)
	{
		/* Obtain the "maximal" stat */
		switch (i)
		{
		case 0:	/* Minimum age */
			m = race_info[creature_ptr->race_idx1].b_age + 1;
			break;
		case 1:	/* Maximum age */
			m = race_info[creature_ptr->race_idx1].b_age + race_info[creature_ptr->race_idx1].m_age;
			break;

		case 2:	/* Minimum height */
			if (creature_ptr->sex == SEX_MALE) m = race_info[creature_ptr->race_idx1].m_b_ht-race_info[creature_ptr->race_idx1].m_m_ht*4+1;
			else m = race_info[creature_ptr->race_idx1].f_b_ht-race_info[creature_ptr->race_idx1].f_m_ht*4+1;
			break;
		case 3:	/* Maximum height */
			if (creature_ptr->sex == SEX_MALE) m = race_info[creature_ptr->race_idx1].m_b_ht+race_info[creature_ptr->race_idx1].m_m_ht*4-1;
			else m = race_info[creature_ptr->race_idx1].f_b_ht+race_info[creature_ptr->race_idx1].f_m_ht*4-1;
			break;
		case 4:	/* Minimum weight */
			if (creature_ptr->sex == SEX_MALE) m = (race_info[creature_ptr->race_idx1].m_b_wt * min_percent / 100) - (race_info[creature_ptr->race_idx1].m_m_wt * min_percent / 75) +1;
			else m = (race_info[creature_ptr->race_idx1].f_b_wt * min_percent / 100) - (race_info[creature_ptr->race_idx1].f_m_wt * min_percent / 75) +1;
			break;
		case 5:	/* Maximum weight */
			if (creature_ptr->sex == SEX_MALE) m = (race_info[creature_ptr->race_idx1].m_b_wt * max_percent / 100) + (race_info[creature_ptr->race_idx1].m_m_wt * max_percent / 75) -1;
			else m = (race_info[creature_ptr->race_idx1].f_b_wt * max_percent / 100) + (race_info[creature_ptr->race_idx1].f_m_wt * max_percent / 75) -1;
			break;
		case 6:	/* Minimum social class */
			m = 1;
			break;
		case 7:	/* Maximum social class */
			m = 100;
			break;
		default:
			m = 1;
			break;
		}
		
		/* Save the maximum or minimum */
		mval[i] = m;
		cval[i] = m;
	}

	for (i = 0; i < 4; i++)
	{
		/* Prepare a prompt */
		sprintf(buf, "%-12s (%3d - %3d)", itemname[i], mval[i*2], mval[i*2+1]);

		/* Dump the prompt */
		put_str(buf, 14 + i, 20);

		for (j = 0; j < 2; j++)
		{
			sprintf(buf, "     %3d", cval[i*2+j]);
			put_str(buf, 14 + i, 45 + 8 * j);
		}
	}
	
	/* Get a minimum stat */
	cs = 0;
	os = MAXITEMS;
	while (TRUE)
	{
		/* Move Cursol */
		if (cs != os)
		{
#ifdef JP
			const char accept[] = "肷";
#else
			const char accept[] = "Accept";
#endif
			if(os == MAXITEMS)
			{
				c_put_str(TERM_WHITE, accept, 19, 35);
			}
			else
			{
				c_put_str(TERM_WHITE, cur, 14 + os/2, 45 + 8 * (os%2));
			}
			
			if(cs == MAXITEMS)
			{
				c_put_str(TERM_YELLOW, accept, 19, 35);
			}
			else
			{
				/* Prepare a prompt */
				sprintf(cur, "     %3d", cval[cs]);
				c_put_str(TERM_YELLOW, cur, 14 + cs/2, 45 + 8 * (cs%2));
			}
			os = cs;
		}
		
		/* Prompt for the minimum stats */
		c = inkey();
		switch (c){
		case 'Q':
			birth_quit();
		case 'S':
			return (FALSE);
		case ESCAPE:
			break; /*łbreak*/
		case ' ':
		case '\r':
		case '\n':
			if(cs == MAXITEMS) break;
			cs++;
			c = '6';
			break;
		case '8':
		case 'k':
			if (cs-2 >= 0) cs -= 2;
			break;
		case '2':
		case 'j':
			if (cs < MAXITEMS) cs += 2;
			if (cs > MAXITEMS) cs = MAXITEMS;
			break;
		case '4':
		case 'h':
			if (cs > 0) cs--;
			break;
		case '6':
		case 'l':
			if (cs < MAXITEMS) cs++;
			break;
		case '-':
		case '<':
			if (cs != MAXITEMS)
			{
				if(cs%2)
				{
					if(cval[cs] > cval[cs-1])
					{
						cval[cs]--;
						os = 127;
					}
				}
				else
				{
					if(cval[cs] > mval[cs])
					{
						cval[cs]--;
						os = 127;
					}
				}
			}
			break;
		case '+':
		case '>':
			if (cs != MAXITEMS)
			{
				if(cs%2)
				{
					if(cval[cs] < mval[cs])
					{
						cval[cs]++;
						os = 127;
					}
				}
				else
				{
					if(cval[cs] < cval[cs+1])
					{
						cval[cs]++;
						os = 127;
					}
				}
			}
			break;
		case 'm':
			if(cs != MAXITEMS)
			{
				if(cs%2)
				{
					if(cval[cs] < mval[cs])
					{
						cval[cs] = mval[cs];
						os = 127;
					}
				}
				else
				{
					if(cval[cs] < cval[cs+1])
					{
						cval[cs] = cval[cs+1];
						os = 127;
					}
				}
			}
			break;
		case 'n':
			if(cs != MAXITEMS)
			{
				if(cs%2)
				{
					if(cval[cs] > cval[cs-1])
					{
						cval[cs] = cval[cs-1];
						os = 255;
					}
				}
				else
				{
					if(cval[cs] > mval[cs])
					{
						cval[cs] = mval[cs];
						os = 255;
					}
				}
			}
			break;
		case '?':
#ifdef JP
			show_help("jbirth.txt#AutoRoller");
#else
			show_help("birth.txt#AutoRoller");
#endif
			break;
		case '=':
			screen_save();
#ifdef JP
			do_cmd_options_aux(OPT_PAGE_BIRTH, "IvV((*)̓XRAɉe)");
#else
			do_cmd_options_aux(OPT_PAGE_BIRTH, "Birth Option((*)s effect score)");
#endif

			screen_load();
			break;
		default:
			bell();
			break;
		}
		if(c == ESCAPE || ((c == ' ' || c == '\r' || c == '\n') && cs == MAXITEMS))break;
	}

	/* Input the minimum stats */
	chara_limit.agemin = cval[0];
	chara_limit.agemax = cval[1];
	chara_limit.htmin = cval[2];
	chara_limit.htmax = cval[3];
	chara_limit.wtmin = cval[4];
	chara_limit.wtmax = cval[5];
	chara_limit.scmin = cval[6];
	chara_limit.scmax = cval[7];

	return TRUE;
}

#define HISTPREF_LIMIT 1024
static char *histpref_buf = NULL;

/*
 * Hook function for reading the histpref.prf file.
 */
void add_history_from_pref_line(cptr t)
{
	/* Do nothing if the buffer is not ready */
	if (!histpref_buf) return;

	my_strcat(histpref_buf, t, HISTPREF_LIMIT);
}


static bool do_cmd_histpref(creature_type *creature_ptr)
{
	char buf[80];
	errr err;
	int i, j, n;
	char *s, *t;
	char temp[HISTORY_ROW * HISTORY_COL];
	char histbuf[HISTPREF_LIMIT];

#ifdef JP
	if (!get_check("vtB[t@C[h܂? ")) return FALSE;
#else
	if (!get_check("Load profile preference file? ")) return FALSE;
#endif

	/* Prepare the buffer */
	histbuf[0] = '\0';
	histpref_buf = histbuf;

#ifdef JP
	sprintf(buf, "histedit-%s.prf", player_base);
#else
	sprintf(buf, "histpref-%s.prf", player_base);
#endif
	err = process_histpref_file(buf);

	/* Process 'hist????.prf' if 'hist????-<name>.prf' doesn't exist */
	if (0 > err)
	{
#ifdef JP
		strcpy(buf, "histedit.prf");
#else
		strcpy(buf, "histpref.prf");
#endif
		err = process_histpref_file(buf);
	}

	if (err)
	{
#ifdef JP
		msg_print("vtB[t@C̓ǂݍ݂Ɏs܂B");
#else
		msg_print("Failed to load profile preference.");
#endif
		msg_print(NULL);

		/* Kill the buffer */
		histpref_buf = NULL;

		return FALSE;
	}
	else if (!histpref_buf[0])
	{
#ifdef JP
		msg_print("LȃvtB[͂̃t@Cɂ܂B");
#else
		msg_print("There does not exist valid profile preference.");
#endif
		msg_print(NULL);

		/* Kill the buffer */
		histpref_buf = NULL;

		return FALSE;
	}

	/* Clear the previous history strings */
	for (i = 0; i < HISTORY_ROW; i++) creature_ptr->history[i][0] = '\0';

	/* Skip leading spaces */
	for (s = histpref_buf; *s == ' '; s++) /* loop */;

	/* Get apparent length */
	n = strlen(s);

	/* Kill trailing spaces */
	while ((n > 0) && (s[n - 1] == ' ')) s[--n] = '\0';

	roff_to_buf(s, HISTORY_COL, temp, sizeof(temp));
	t = temp;
	for (i = 0; i < HISTORY_ROW; i++)
	{
		if (t[0] == 0) break;
		else
		{
			strcpy(creature_ptr->history[i], t);
			t += strlen(t) + 1;
		}
	}

	/* Fill the remaining spaces */
	for (i = 0; i < HISTORY_ROW; i++)
	{
		for (j = 0; creature_ptr->history[i][j]; j++) /* loop */;

		for (; j < HISTORY_COL - 1; j++) creature_ptr->history[i][j] = ' ';
		creature_ptr->history[i][HISTORY_COL - 1] = '\0';
	}

	/* Kill the buffer */
	histpref_buf = NULL;

	return TRUE;
}

/*
 *  Character background edit-mode
 */
static void edit_history(creature_type *creature_ptr)
{
	char old_history[HISTORY_ROW][HISTORY_COL];
	int y = 0, x = 0;
	int i, j;

	/* Edit character background */
	for (i = 0; i < HISTORY_ROW; i++)
	{
		sprintf(old_history[i], "%s", creature_ptr->history[i]);
	}
	/* Turn 0 to space */
	for (i = 0; i < HISTORY_ROW; i++)
	{
		for (j = 0; creature_ptr->history[i][j]; j++) /* loop */;

		for (; j < HISTORY_COL - 1; j++) creature_ptr->history[i][j] = ' ';
		creature_ptr->history[i][HISTORY_COL - 1] = '\0';
	}
	display_creature_status(1, creature_ptr);
#ifdef JP
	c_put_str(TERM_L_GREEN, "(N[`[̃vtB[ - ҏW[h)", 2, 20);
	put_str("[ J[\L[ňړAEnterŏIACtrl-AŃt@Cǂݍ ]", 23, 10);
#else
	c_put_str(TERM_L_GREEN, "(Creature Profile - Edit Mode)", 2, 20);
	put_str("[ Cursor key for Move, Enter for End, Ctrl-A for Read pref ]", 23, 10);
#endif

	while (TRUE)
	{
		int skey;
		char c;

		for (i = 0; i < HISTORY_ROW; i++)
		{
			put_str(creature_ptr->history[i], i + 4, 3);
		}
#ifdef JP
		if (iskanji2(creature_ptr->history[y], x))
			c_put_str(TERM_L_BLUE, format("%c%c", creature_ptr->history[y][x],creature_ptr->history[y][x+1]), y + 4, x + 3);
		else
#endif
		c_put_str(TERM_L_BLUE, format("%c", creature_ptr->history[y][x]), y + 4, x + 3);

		/* Place cursor just after cost of current stat */
		Term_gotoxy(x + 3, y + 4);

		/* Get special key code */
		skey = inkey_special(TRUE);

		/* Get a character code */
		if (!(skey & SKEY_MASK)) c = (char)skey;
		else c = 0;

		if (skey == SKEY_UP || c == KTRL('p'))
		{
			y--;
			if (y < 0) y = HISTORY_ROW - 1;
#ifdef JP
			if ((x > 0) && (iskanji2(creature_ptr->history[y], x-1))) x--;
#endif
		}
		else if (skey == SKEY_DOWN || c == KTRL('n'))
		{
			y++;
			if (y >= HISTORY_ROW) y = 0;
#ifdef JP
			if ((x > 0) && (iskanji2(creature_ptr->history[y], x-1))) x--;
#endif
		}
		else if (skey == SKEY_RIGHT || c == KTRL('f'))
		{
#ifdef JP
			if (iskanji2(creature_ptr->history[y], x)) x++;
#endif
			x++;
			if (x > HISTORY_COL - 2)
			{
				x = 0;
				if (y < HISTORY_ROW - 1) y++;
			}
		}
		else if (skey == SKEY_LEFT || c == KTRL('b'))
		{
			x--;
			if (x < 0)
			{
				if (y)
				{
					y--;
					x = HISTORY_ROW - 2;
				}
				else x = 0;
			}

#ifdef JP
			if ((x > 0) && (iskanji2(creature_ptr->history[y], x-1))) x--;
#endif
		}
		else if (c == '\r' || c == '\n')
		{
			Term_erase(0, 11, 255);
			Term_erase(0, 17, 255);
#ifdef JP
			put_str("(N[`[̃vtB[ - ҏWς)", 2, 20);
#else
			put_str("(Creature Profile - Edited)", 2, 20);
#endif
			break;
		}
		else if (c == ESCAPE)
		{
			clear_from(2);
#ifdef JP
			put_str("(N[`[̃vtB[)", 2, 25);
#else
			put_str("(Creature Profile)", 2, 25);
#endif

			for (i = 0; i < HISTORY_ROW; i++)
			{
				sprintf(creature_ptr->history[i], "%s", old_history[i]);
				put_str(creature_ptr->history[i], i + 4, 3);
			}
			break;
		}
		else if (c == KTRL('A'))
		{
			if (do_cmd_histpref(creature_ptr))
			{
#ifdef JP
				if ((x > 0) && (iskanji2(creature_ptr->history[y], x - 1))) x--;
#endif
			}
		}
		else if (c == '\010')
		{
			x--;
			if (x < 0)
			{
				if (y)
				{
					y--;
					x = HISTORY_ROW - 2;
				}
				else x = 0;
			}

			creature_ptr->history[y][x] = ' ';
#ifdef JP
			if ((x > 0) && (iskanji2(creature_ptr->history[y], x - 1)))
			{
				x--;
				creature_ptr->history[y][x] = ' ';
			}
#endif
		}
#ifdef JP
		else if (iskanji(c) || isprint(c))
#else
		else if (isprint(c)) /* BUGFIX */
#endif
		{
#ifdef JP
			if (iskanji2(creature_ptr->history[y], x))
			{
				creature_ptr->history[y][x+1] = ' ';
			}

			if (iskanji(c))
			{
				if (x > HISTORY_COL - 3)
				{
					x = 0;
					y++;
					if (y > HISTORY_ROW - 1) y = 0;
				}

				if (iskanji2(creature_ptr->history[y], x+1))
				{
					creature_ptr->history[y][x+2] = ' ';
				}

				creature_ptr->history[y][x++] = c;

				c = inkey();
			}
#endif
			creature_ptr->history[y][x++] = c;
			if (x > HISTORY_COL - 2)
			{
				x = 0;
				y++;
				if (y >= HISTORY_ROW) y = 0;
			}
		}
	} /* while (TRUE) */

}


/*
 * Helper function for 'generate_creature'
 *
 * The delay may be reduced, but is recommended to keep players
 * from continuously rolling up characters, which can be VERY
 * expensive CPU wise.  And it cuts down on player stupidity.
 */
static bool generate_creature_aux(creature_type *creature_ptr, int species_idx, creature_type *save_ptr, u32b flags)
{

	int i;
	int mode = 0;

	bool flag = FALSE;
	bool prev = FALSE;
	bool player = flags & GC_PLAYER;
	bool auto_generate = flags & GC_AUTO;

	char c;

#if 0
	char p1 = '(';
#endif

	char p2 = ')';
	char b1 = '[';
	char b2 = ']';

	char buf[80];

	species_type *species_ptr = &species_info[species_idx];

	/* Wipe the player */
	creature_wipe(creature_ptr);

	creature_ptr->creature_idx = ++creature_idx_latest;

	creature_ptr->species_idx = species_idx;
	creature_ptr->ap_species_idx = species_idx;

	if(flags & GC_PLAYER) creature_ptr->player = TRUE;

	strcpy(creature_ptr->name, species_name + species_ptr->name);


	// Authority is statics
	for(i = 0; i < 8; i++)
	{
		creature_ptr->authority[i] = species_ptr->authority[i];
	}


	// Race Select

	if(species_ptr->race_idx1 == INDEX_VARIABLE)
	{
		if(!auto_generate)
		{
			Term_clear();
			clear_from(0);
			put_initial_status(creature_ptr);
		}
		i = get_creature_first_race(creature_ptr, species_ptr, auto_generate);
		if(i == -2) return (FALSE);
		if(i == -3) birth_quit();
	}
	else
	{
		creature_ptr->race_idx1 = species_ptr->race_idx1;
	}

	if(species_ptr->race_idx2 == INDEX_VARIABLE)
	{
		if(!auto_generate)
			put_initial_status(creature_ptr);

		i = get_creature_second_race(creature_ptr, species_ptr, auto_generate);
		if(i == -2) return (FALSE);
		if(i == -3) birth_quit();
	}
	else
	{
		creature_ptr->race_idx2 = species_ptr->race_idx2;
	}

	// race_idx swap
	if(creature_ptr->race_idx1 > creature_ptr->race_idx2)
	{
		creature_ptr->race_idx1 ^= creature_ptr->race_idx2;
		creature_ptr->race_idx2 ^= creature_ptr->race_idx1;
		creature_ptr->race_idx1 ^= creature_ptr->race_idx2;
	}

	// TODO Race Trait

	// Give beastman a mutation at character birth
	if (IS_RACE(creature_ptr, RACE_BEASTMAN)) creature_ptr->hack_mutation = TRUE;
	else creature_ptr->hack_mutation = FALSE;

	//
	// Sex Select
	//
	if(species_ptr->sex == INDEX_VARIABLE)
	{
		if(!auto_generate)
		{
			clear_from(0);
			put_initial_status(creature_ptr);
		}
		i = get_creature_sex(creature_ptr, species_ptr, auto_generate);
		if(i == -2) return (FALSE);
		if(i == -3) birth_quit();
	}
	else
	{
		creature_ptr->sex = species_ptr->sex;
	}

	//
	// Class Select
	//
	i = get_creature_class(creature_ptr, species_ptr, auto_generate);
	if(i == -2) return (FALSE);
	if(i == -3) birth_quit();

	//
	// Realm Select
	//
	i = get_creature_realms(creature_ptr, species_ptr, auto_generate);
	if(i == -2) return (FALSE);
	if(i == -3) birth_quit();

	//
	// Patron Select
	//
	i = get_creature_patron(creature_ptr, species_ptr, auto_generate);
	if(i == -2) return (FALSE);
	if(i == -3) birth_quit();

	//
	// Character Select
	//
	i = get_chara_type(creature_ptr, species_ptr, auto_generate);
	if(i == -2) return (FALSE);
	if(i == -3) birth_quit();

	//
	// Starting Point
	//
	if(player)
	{
		i = get_starting_point(creature_ptr, auto_generate);
		if(i == -2) return (FALSE);
		if(i == -3) birth_quit();
	}

	creature_ptr->lev = 1;
	creature_ptr->dr = species_ptr->dr;

	if(player)
	{
		screen_save();

#ifdef JP
		do_cmd_options_aux(OPT_PAGE_BIRTH, "IvV((*)̓XRAɉe)");
#else
		do_cmd_options_aux(OPT_PAGE_BIRTH, "Birth Option((*)s effect score)");
#endif

		screen_load();

		/*** Autoroll ***/

		if (autoroller || autochara)
		{
			/* Clear fields */
			auto_round = 0L;
		}

		/* Initialize */
		if (autoroller)
		{
			if (!get_stat_limits(creature_ptr)) return FALSE;
		}

		if (autochara)
		{
			if (!get_chara_limits(creature_ptr)) return FALSE;
		}

		/* Clear */
		clear_from(0);

		/* Reset turn; before auto-roll and after choosing race */
		init_turn(creature_ptr);
	}

	/*** Generate ***/

	/* Roll */
	while (TRUE)
	{
		int col;

		col = 42;

		if (!auto_generate && (autoroller || autochara))
		{
			Term_clear();

			/* Label count */
#ifdef JP
			put_str(" :", 10, col+13);
#else
			put_str("Round:", 10, col+13);
#endif


			/* Indicate the state */
#ifdef JP
			put_str("(ESCŒ~)", 12, col+13);
#else
			put_str("(Hit ESC to stop)", 12, col+13);
#endif
		}

		// Otherwise just get a character
		else
		{

			set_stats(creature_ptr, species_ptr);   // Get a new character
			set_age(creature_ptr);                  // Roll for age
			set_exp(creature_ptr, species_ptr);                  // Roll for exp
			set_height_weight(creature_ptr);        // Roll for height and weight

			set_underlings(creature_ptr, species_ptr);

			get_history(creature_ptr);              // Roll for social class
		}

		/* Feedback */
		if (!auto_generate && autoroller)
		{
			/* Label */
#ifdef JP
			put_str("ŏl", 2, col+5);
#else
			put_str(" Limit", 2, col+5);
#endif


			/* Label */
#ifdef JP
			put_str("", 2, col+13);
#else
			put_str("  Freq", 2, col+13);
#endif


			/* Label */
#ifdef JP
			put_str("ݒl", 2, col+24);
#else
			put_str("  Roll", 2, col+24);
#endif


			/* Put the minimal stats */
			for (i = 0; i < 6; i++)
			{
				int j, m;

				/* Label stats */
				put_str(stat_names[i], 3 + i, col);

				/* Race/Class/Species bonus */
				if(IS_PURE(creature_ptr))
					j = race_info[creature_ptr->race_idx1].r_adj[i] + 
						class_info[creature_ptr->class_idx].c_adj[i] +
						chara_info[creature_ptr->chara_idx].a_adj[i] +
						species_ptr->stat_max[i] / STAT_FRACTION - 10;
				else
					j = race_info[creature_ptr->race_idx1].r_s_adj[i] +
						race_info[creature_ptr->race_idx2].r_s_adj[i] +
						class_info[creature_ptr->class_idx].c_adj[i] +
						chara_info[creature_ptr->chara_idx].a_adj[i] +
						species_ptr->stat_max[i] / STAT_FRACTION - 10;


				/* Obtain the current stat */
				m = adjust_stat(stat_limit[i], j);

				/* Put the stat */
				cnv_stat(m, buf);
				c_put_str(TERM_L_BLUE, buf, 3+i, col+5);
			}
		}

		// Auto-roll
		while (!auto_generate && (autoroller || autochara))
		{
			bool accept = TRUE;

			/* Get a new character */
			set_stats(creature_ptr, species_ptr);

			/* Advance the round */
			auto_round++;

			/* Hack -- Prevent overflow */
			if (auto_round >= 1000000000L)
			{
				auto_round = 1;

				if (autoroller)
				{
					for (i = 0; i < 6; i++)
					{
						stat_match[i] = 0;
					}
				}
			}

			if (autoroller)
			{
				/* Check and count acceptable stats */
				for (i = 0; i < 6; i++)
				{
					/* This stat is okay */
					if (creature_ptr->stat_max[i] >= stat_limit[i])
					{
						stat_match[i]++;
					}

					/* This stat is not okay */
					else
					{
						accept = FALSE;
					}
				}
			}

			/* Break if "happy" */
			if (accept)
			{
				set_age(creature_ptr);            // Roll for age
				set_exp(creature_ptr, species_ptr);                  // Roll for exp
				set_height_weight(creature_ptr);  // Roll for height and weight

				set_underlings(creature_ptr, species_ptr);

				get_history(creature_ptr);

				if (autochara)
				{
					if ((creature_ptr->age < chara_limit.agemin) || (creature_ptr->age > chara_limit.agemax)) accept = FALSE;
					if ((creature_ptr->ht < chara_limit.htmin) || (creature_ptr->ht > chara_limit.htmax)) accept = FALSE;
					if ((creature_ptr->wt < chara_limit.wtmin) || (creature_ptr->wt > chara_limit.wtmax)) accept = FALSE;
					if ((creature_ptr->sc < chara_limit.scmin) || (creature_ptr->sc > chara_limit.scmax)) accept = FALSE;
				}
				if (accept) break;
			}

			/* Take note every x rolls */
			flag = (!(auto_round % AUTOROLLER_STEP));

			/* Update display occasionally */
			if (flag)
			{
				/* Dump data */
				birth_put_stats(creature_ptr);

				/* Dump round */
				put_str(format("%10ld", auto_round), 10, col+20);

#ifdef AUTOROLLER_DELAY
				/* Delay 1/10 second */
				if (flag) Term_xtra(TERM_XTRA_DELAY, 10);
#endif

				/* Make sure they see everything */
				Term_fresh();

				/* Do not wait for a key */
				inkey_scan = TRUE;

				/* Check for a keypress */
				if (inkey())
				{
					set_age(creature_ptr);            // Roll for age
					set_exp(creature_ptr, species_ptr);  // Roll for exp
					set_height_weight(creature_ptr);  // Roll for height and weight
					get_history(creature_ptr);        // Roll for social class
					break;
				}
			}
		}

		if (!auto_generate && (autoroller || autochara)) sound(SOUND_LEVEL);

		/* Flush input */
		flush();

		/*** Display ***/

		/* Mode */
		mode = 0;

		/* Roll for base hitpoints */
		get_extra(creature_ptr, TRUE);

		// Deal Item
		set_creature_bonuses(creature_ptr, FALSE);
		set_experience(creature_ptr);

		deal_item(creature_ptr);

		/* Roll for gold */
		get_money(creature_ptr);

		/* Input loop */
		while (TRUE)
		{

			set_experience(creature_ptr);
			set_creature_bonuses(creature_ptr, FALSE);

			// Calculate the bonuses and hitpoints
			// Update stuff 
			creature_ptr->creature_update |= (CRU_BONUS | CRU_HP | CRU_MANA);
			update_creature(creature_ptr, FALSE);


			/* And start out fully healthy */
			if (creature_ptr->species_idx == MON_WOUNDED_BEAR)
				set_creature_hp_percent(creature_ptr, 50);
			else
				set_creature_hp_percent(creature_ptr, 100);
			set_creature_sp_percent(creature_ptr, 100);

			// Sexy gal gets bonus to maximum weapon skill of whip
			// TODO if (creature_ptr->chara_idx == CHARA_SEXY) skill_info[player_ptr->class_idx].w_max[TV_HAFTED - TV_WEAPON_BEGIN][SV_WHIP] = WEAPON_EXP_MASTER;

			if(auto_generate) break;

			/* Display the player */
			display_creature_status(mode, creature_ptr);

			/* Prepare a prompt (must squeeze everything in) */
			Term_gotoxy(2, 23);
			Term_addch(TERM_WHITE, b1);
#ifdef JP
			Term_addstr(-1, TERM_WHITE, "'r' ̐l");
#else
			Term_addstr(-1, TERM_WHITE, "'r'eroll");
#endif

#ifdef JP
			if (prev) Term_addstr(-1, TERM_WHITE, ", 'p' O̐l");
#else
			if (prev) Term_addstr(-1, TERM_WHITE, ", 'p'previous");
#endif

#ifdef JP
			if (mode) Term_addstr(-1, TERM_WHITE, ", 'h' ̑̏");
#else
			if (mode) Term_addstr(-1, TERM_WHITE, ", 'h' Misc.");
#endif

#ifdef JP
			else Term_addstr(-1, TERM_WHITE, ", 'h' \");
#else
			else Term_addstr(-1, TERM_WHITE, ", 'h'istory");
#endif

#ifdef JP
			Term_addstr(-1, TERM_WHITE, ", Enter ̐lɌ");
#else
			Term_addstr(-1, TERM_WHITE, ", or Enter to accept");
#endif

			Term_addch(TERM_WHITE, b2);

			/* Prompt and get a command */
			c = inkey();

			/* Quit */
			if (c == 'Q') birth_quit();

			/* Start over */
			if (c == 'S') return (FALSE);

			/* Escape accepts the roll */
			if (c == '\r' || c == '\n' || c == ESCAPE) break;

			/* Reroll this character */
			if ((c == ' ') || (c == 'r')) break;

			/* Previous character */
			if (prev && (c == 'p'))
			{
				*creature_ptr = player_prev;
				continue;
			}

			/* Toggle the display */
			if ((c == 'H') || (c == 'h'))
			{
				((mode >= 3) ? mode = 0 : mode++);
				continue;
			}

			/* Help */
			if (c == '?')
			{
#ifdef JP
				show_help("jbirth.txt#AutoRoller");
#else
				show_help("birth.txt#AutoRoller");
#endif
				continue;
			}
			else if (c == '=')
			{
				screen_save();
#ifdef JP
				do_cmd_options_aux(OPT_PAGE_BIRTH, "IvV((*)̓XRAɉe)");
#else
				do_cmd_options_aux(OPT_PAGE_BIRTH, "Birth Option((*)s effect score)");
#endif

				screen_load();
				continue;
			}

			/* Warning */
#ifdef JP
			bell();
#else
			bell();
#endif

		}

		/* Are we done? */
		if (auto_generate || c == '\r' || c == '\n' || c == ESCAPE) break;

		/* Save this for the "previous" character */
		player_prev = *creature_ptr;
		quick_ok = FALSE;

		/* Note that a previous roll exists */
		prev = TRUE;
	}

	if(!auto_generate)
	{
		get_name(creature_ptr); // Get a name, recolor it, prepare savefile
		set_creature_name(creating_savefile, creature_ptr); // Process the player name
		edit_history(creature_ptr); // Edit character background
	}

	get_max_stats(creature_ptr);

	if(auto_generate) return (TRUE);

	// Prompt for it
#ifdef JP
	prt("[ 'Q' f, 'S' ߂, Enter Q[Jn ]", 23, 14);
#else
	prt("['Q'uit, 'S'tart over, or Enter to continue]", 23, 10);
#endif

	/* Get a key */
	c = inkey();

	/* Quit */
	if (c == 'Q') birth_quit();

	/* Start over */
	if (c == 'S') return (FALSE);


	/* Accept */
	return (TRUE);
}

/*
 * Ask whether the player use Quick Start or not.
 */
bool ask_quick_start(creature_type *creature_ptr)
{

	/* Doesn't have previous data */
	if (!quick_ok) return FALSE;


	/* Clear screen */
	Term_clear();

	/* Extra info */
#ifdef JP
	put_str("NCbNEX^[ggƈȑOƑSLN^[Ŏn߂܂B", 11, 5);
#else
	put_str("Do you want to use the quick start function(same character as your last one).", 11, 2);
#endif

	/* Choose */
	while (1)
	{
		char c;

#ifdef JP
		put_str("NCbNEX^[gg܂H[y/N]", 14, 10);
#else
		put_str("Use quick start? [y/N]", 14, 10);
#endif
		c = inkey();

		if (c == 'Q') quit(NULL);
		else if (c == 'S') return (FALSE);
		else if (c == '?')
		{
#ifdef JP
			show_help("jbirth.txt#QuickStart");
#else
			show_help("birth.txt#QuickStart");
#endif
		}
		else if ((c == 'y') || (c == 'Y'))
		{
			/* Yes */
			break;
		}
		else
		{
			/* No */
			return FALSE;
		}
	}

	*creature_ptr = player_prev;
	init_dungeon_quests();
	init_turn(creature_ptr);

	creature_ptr->wy = creature_ptr->start_wy;
	creature_ptr->wx = creature_ptr->start_wx;

	/* Calc hitdice, but don't roll */
	get_extra(creature_ptr, FALSE);

	// Update the bonuses and hitpoints
	creature_ptr->creature_update |= (CRU_BONUS | CRU_HP);
	update_creature(creature_ptr, TRUE);

	/* Fully healed */
	creature_ptr->chp = creature_ptr->mhp;

	/* Fully rested */
	creature_ptr->csp = creature_ptr->msp;

	/* Process the player name */
	set_creature_name(FALSE, creature_ptr);

	return TRUE;
}

/*
 * Create a new character.
 *
 * Note that we may be called with "junk" leftover in the various
 * fields, so we must be sure to clear them first.
 */
creature_type* generate_creature(cave_type *c_ptr, int species_idx, creature_type *save_ptr, u32b flags)
{
	char buf[80];
	int id;
	creature_type *creature_ptr;

	// Make a new creature
	id = creature_pop();
	if (!id) return NULL;

	// Get a new creature record
	creature_ptr = &creature_list[id];

	if(c_ptr) c_ptr->creature_idx = id;

	// Create a new character
	while (!generate_creature_aux(creature_ptr, species_idx, save_ptr, flags));

	if(flags & GC_PLAYER)
	{
		/* Note player birth in the message recall */
		message_add(" ");
		message_add("  ");
		message_add("====================");
		message_add(" ");
		message_add("  ");

	#ifdef JP
		do_cmd_write_nikki(DIARY_GAMESTART, 1, "-------- j[N쐬 --------");
	#else
		do_cmd_write_nikki(DIARY_GAMESTART, 1, "-------- Create Unique --------");
	#endif
		do_cmd_write_nikki(DIARY_HIGAWARI, 0, NULL);

	#ifdef JP
		sprintf(buf,"                            ʂ%sIB", sex_info[creature_ptr->sex].title);
	#else
		sprintf(buf,"                            choose %s personality.", sex_info[creature_ptr->sex].title);
	#endif
		do_cmd_write_nikki(DIARY_BUNSHOU, 1, buf);

		if(IS_PURE(creature_ptr))
		{
	#ifdef JP
			sprintf(buf,"                            푰%sIB", race_info[creature_ptr->race_idx1].title);
	#else
			sprintf(buf,"                            choose %s race.", race_info[creature_ptr->race_idx1].title);
	#endif
		}
		else
		{
	#ifdef JP
			sprintf(buf,"                            푰%s%s̍IB",
				race_info[creature_ptr->race_idx1].title, race_info[creature_ptr->race_idx2].title);
	#else
			sprintf(buf,"                            choose %s and %s races.",
				race_info[creature_ptr->race_idx1].title, race_info[creature_ptr->race_idx2].title);
	#endif
		}
		do_cmd_write_nikki(DIARY_BUNSHOU, 1, buf);

	#ifdef JP
		sprintf(buf,"                            EƂ%sIB", class_info[creature_ptr->class_idx].title);
	#else
		sprintf(buf,"                            choose %s class.", class_info[creature_ptr->class_idx].title);
	#endif
		do_cmd_write_nikki(DIARY_BUNSHOU, 1, buf);

		if (creature_ptr->realm1)
		{
	#ifdef JP
			sprintf(buf,"                            @̗̈%s%sIB",realm_names[creature_ptr->realm1], creature_ptr->realm2 ? format("%s",realm_names[creature_ptr->realm2]) : "");
	#else
			sprintf(buf,"                            choose %s%s realm.",realm_names[creature_ptr->realm1], creature_ptr->realm2 ? format(" realm and %s",realm_names[creature_ptr->realm2]) : "");
	#endif
			do_cmd_write_nikki(DIARY_BUNSHOU, 1, buf);
		}

	#ifdef JP
		sprintf(buf,"                            i%sIB", chara_info[creature_ptr->chara_idx].title);
	#else
		sprintf(buf,"                            choose %s.", chara_info[creature_ptr->chara_idx].title);
	#endif
		do_cmd_write_nikki(DIARY_BUNSHOU, 1, buf);

	}

	return creature_ptr;
}


void dump_yourself(creature_type *creature_ptr, FILE *fff)
{
	char temp[80*10];
	int i;
	cptr t;

	if (!fff) return;

	roff_to_buf(race_text + race_info[creature_ptr->race_idx1].text, 78, temp, sizeof(temp));
	fprintf(fff, "\n\n");
#ifdef JP
	fprintf(fff, "푰: %s\n", race_info[creature_ptr->race_idx1].title);
#else
	fprintf(fff, "Race: %s\n", race_info[creature_ptr->race_idx1].title);
#endif
	t = temp;
	for (i = 0; i < 10; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	roff_to_buf(class_jouhou[creature_ptr->class_idx], 78, temp, sizeof(temp));
	fprintf(fff, "\n");
#ifdef JP
	fprintf(fff, "E: %s\n", class_info[creature_ptr->class_idx].title);
#else
	fprintf(fff, "Class: %s\n", class_info[creature_ptr->class_idx].title);
#endif
	t = temp;
	for (i = 0; i < 10; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	roff_to_buf(chara_jouhou[creature_ptr->chara_idx], 78, temp, sizeof(temp));
	fprintf(fff, "\n");
#ifdef JP
	fprintf(fff, "i: %s\n", chara_info[creature_ptr->chara_idx].title);
#else
	fprintf(fff, "Pesonality: %s\n", chara_info[creature_ptr->chara_idx].title);
#endif
	t = temp;
	for (i = 0; i < 6; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	fprintf(fff, "\n");
	if (creature_ptr->realm1)
	{
		roff_to_buf(realm_jouhou[technic2magic(creature_ptr->realm1)-1], 78, temp, sizeof(temp));
#ifdef JP
		fprintf(fff, "@: %s\n", realm_names[creature_ptr->realm1]);
#else
		fprintf(fff, "Realm: %s\n", realm_names[creature_ptr->realm1]);
#endif
		t = temp;
		for (i = 0; i < 6; i++)
		{
			if(t[0] == 0)
				break; 
			fprintf(fff, "%s\n",t);
			t += strlen(t) + 1;
		}
	}
	fprintf(fff, "\n");
	if (creature_ptr->realm2)
	{
		roff_to_buf(realm_jouhou[technic2magic(creature_ptr->realm2)-1], 78, temp, sizeof(temp));
#ifdef JP
		fprintf(fff, "@: %s\n", realm_names[creature_ptr->realm2]);
#else
		fprintf(fff, "Realm: %s\n", realm_names[creature_ptr->realm2]);
#endif
		t = temp;
		for (i = 0; i < 6; i++)
		{
			if(t[0] == 0)
				break; 
			fprintf(fff, "%s\n",t);
			t += strlen(t) + 1;
		}
	}
}

