/* File: melee1.c */

/* Purpose: Creature attacks */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"

#define MAX_VAMPIRIC_DRAIN 50



static void touch_zap_player(creature_type *atk_ptr, creature_type *tar_ptr)
{
	int aura_damage = 0;
	species_type *species_ptr = &species_info[tar_ptr->species_idx];

	if (has_cf_creature(tar_ptr, CF_AURA_FIRE))
	{
		if (!atk_ptr->immune_fire)
		{
			char aura_dam[80];

			aura_damage = diceroll(1 + (tar_ptr->lev / 13), 1 + (tar_ptr->lev / 7));

			/* Hack -- Get the "died from" name */
			creature_desc(aura_dam, tar_ptr, MD_IGNORE_HALLU | MD_ASSUME_VISIBLE | MD_INDEF_VISIBLE);

#ifdef JP
			msg_print("ˑRƂĂMȂI");
#else
			msg_print("You are suddenly very hot!");
#endif

			aura_damage = calc_damage(atk_ptr, aura_damage, DAMAGE_TYPE_FIRE, FALSE);
			take_hit(NULL, atk_ptr, DAMAGE_NOESCAPE, aura_damage, aura_dam, NULL, -1);

			if (is_original_ap_and_seen(atk_ptr, tar_ptr)) reveal_creature_info(tar_ptr, CF_AURA_FIRE);
			handle_stuff();
		}
	}

	if (has_cf_creature(tar_ptr, CF_AURA_COLD))
	{
		if (!atk_ptr->immune_cold)
		{
			char aura_dam[80];

			aura_damage = diceroll(1 + (tar_ptr->lev / 13), 1 + (tar_ptr->lev / 7));

			/* Hack -- Get the "died from" name */
			creature_desc(aura_dam, tar_ptr, MD_IGNORE_HALLU | MD_ASSUME_VISIBLE | MD_INDEF_VISIBLE);

#ifdef JP
			msg_print("ˑRƂĂȂI");
#else
			msg_print("You are suddenly very cold!");
#endif

			if (IS_OPPOSE_COLD(atk_ptr)) aura_damage = (aura_damage + 2) / 3;
			if (atk_ptr->resist_cold) aura_damage = (aura_damage + 2) / 3;

			take_hit(NULL, atk_ptr, DAMAGE_NOESCAPE, aura_damage, aura_dam, NULL, -1);
			if (is_original_ap_and_seen(atk_ptr, tar_ptr)) reveal_creature_info(tar_ptr, CF_AURA_COLD);
			handle_stuff();
		}
	}

	if (has_cf_creature(tar_ptr, CF_AURA_ELEC))
	{
		if (!atk_ptr->immune_elec)
		{
			char aura_dam[80];

			aura_damage = diceroll(1 + (tar_ptr->lev / 13), 1 + (tar_ptr->lev / 7));

			/* Hack -- Get the "died from" name */
			creature_desc(aura_dam, tar_ptr, MD_IGNORE_HALLU | MD_ASSUME_VISIBLE | MD_INDEF_VISIBLE);

			if (has_cf_creature(atk_ptr, CF_ANDROID)) aura_damage += aura_damage / 3;
			if (IS_OPPOSE_ELEC(atk_ptr)) aura_damage = (aura_damage + 2) / 3;
			if (atk_ptr->resist_elec) aura_damage = (aura_damage + 2) / 3;

#ifdef JP
			msg_print("dI");
#else
			msg_print("You get zapped!");
#endif

			take_hit(NULL, atk_ptr, DAMAGE_NOESCAPE, aura_damage, aura_dam, NULL, -1);
			if (is_original_ap_and_seen(atk_ptr, tar_ptr)) reveal_creature_info(tar_ptr, CF_AURA_ELEC);
			handle_stuff();
		}
	}
}

/*
 * Player attacks a (poor, defenseless) creature        -RAK-
 *
 * If no "weapon" is available, then "punch" the creature one time.
 */
static void weapon_attack(creature_type *atk_ptr, creature_type *tar_ptr, int y, int x, bool *fear, bool *mdeath, s16b hand, int mode)
{
	int		num = 0, k, bonus, chance;

	floor_type      *floor_ptr = get_floor_ptr(atk_ptr);
	cave_type       *c_ptr = &floor_ptr->cave[y][x];
	species_type    *r_ptr = &species_info[tar_ptr->species_idx];

	// Access the weapon
	object_type     *weapon_ptr = get_equipped_slot_ptr(atk_ptr, INVEN_SLOT_HAND, hand);

	char            atk_name[80];
	char            tar_name[80];
	char			weapon_name[80];

	bool            success_hit = FALSE;
	bool            backstab = FALSE;
	bool            vorpal_cut = FALSE;
	int             chaos_effect = 0;
	bool            stab_fleeing = FALSE;
	bool            fuiuchi = FALSE;
	bool            tramping = FALSE;
	bool            do_quake = FALSE;
	bool            weak = FALSE;
	bool            drain_msg = TRUE;
	int             drain_result = 0, drain_heal = 0;
	bool            can_drain = FALSE;
	int             drain_left = MAX_VAMPIRIC_DRAIN;
	u32b flgs[TR_FLAG_SIZE]; /* A massive hack -- life-draining weapons */
	bool            is_human = (r_ptr->d_char == 'p');
	bool            is_lowlevel = (r_ptr->level < (atk_ptr->lev - 15));
	bool            zantetsu_mukou, e_j_mukou;

	switch (atk_ptr->class_idx)
	{
	case CLASS_ROGUE:
	case CLASS_NINJA:
		if (get_equipped_slot_num(atk_ptr, INVEN_SLOT_HAND) > hand && !atk_ptr->icky_wield[hand])
		{
			int tmp = atk_ptr->lev * 6 + (atk_ptr->skill_stl + 10) * 4;
			if (atk_ptr->monlite && (mode != HISSATSU_NYUSIN)) tmp /= 3;
			if (atk_ptr->cursed & TRC_AGGRAVATE) tmp /= 2;
			if (r_ptr->level > (atk_ptr->lev * atk_ptr->lev / 20 + 10)) tmp /= 3;
			if (tar_ptr->paralyzed && tar_ptr->ml)
			{
				// Can't backstab creatures that we can't see, right?
				backstab = TRUE;
			}
			else if ((atk_ptr->special_defense & NINJA_S_STEALTH) && (randint0(tmp) > (r_ptr->level+20)) && tar_ptr->ml && !(tar_ptr->resist_ultimate))
			{
				fuiuchi = TRUE;
			}
			else if (tar_ptr->afraid && tar_ptr->ml)
			{
				stab_fleeing = TRUE;
			}
		}
		break;
	}

	object_desc(weapon_name, weapon_ptr, OD_NAME_ONLY);

	if (object_is_melee_weapon(atk_ptr, weapon_ptr))
	{
		// Weapon skill mastering
		if ((r_ptr->level + 10) > atk_ptr->lev && atk_ptr->class_idx != INDEX_NONE)
		{
			int tval = atk_ptr->inventory[hand].tval - TV_WEAPON_BEGIN;
			int sval = atk_ptr->inventory[hand].sval;
			/*
			int now_exp = atk_ptr->weapon_exp[tval][sval];
			if (now_exp < skill_info[atk_ptr->class_idx].w_max[tval][sval])
			{
				int amount = 0;
				if (now_exp < WEAPON_EXP_BEGINNER) amount = 80;
				else if (now_exp < WEAPON_EXP_SKILLED) amount = 10;
				else if ((now_exp < WEAPON_EXP_EXPERT) && (atk_ptr->lev > 19)) amount = 1;
				else if ((atk_ptr->lev > 34) && one_in_(2)) amount = 1;
				atk_ptr->weapon_exp[tval][sval] += amount;
				atk_ptr->creature_update |= (CRU_BONUS);
			}
			*/
		}
	}

	// Disturb the creature
	(void)set_paralyzed(tar_ptr, 0);

	// Extract attacker and target name (or "it")
	creature_desc(atk_name, atk_ptr, 0);
	creature_desc(tar_name, tar_ptr, 0);

	// Calculate the "attack quality"
	bonus = atk_ptr->to_hit[hand] + weapon_ptr->to_hit;
	chance = (atk_ptr->skill_thn + (bonus * BTH_PLUS_ADJ));
	if (mode == HISSATSU_IAI) chance += 60;
	if (atk_ptr->special_defense & KATA_KOUKIJIN) chance += 150;

	if (atk_ptr->sutemi) chance = MAX(chance * 3 / 2, chance + 60);

	zantetsu_mukou = ((weapon_ptr->name1 == ART_ZANTETSU) && (r_ptr->d_char == 'j'));
	e_j_mukou = ((weapon_ptr->name1 == ART_EXCALIBUR_J) && (r_ptr->d_char == 'S'));

	// Attack once for each legal blow
	if (((weapon_ptr->tval == TV_SWORD) && (weapon_ptr->sval == SV_DOKUBARI)) || (mode == HISSATSU_KYUSHO))
	{
		int n = count_melee_slot(atk_ptr);
		if (mode == HISSATSU_3DAN) n *= 2;
		success_hit = one_in_(n);
	}
	else if ((atk_ptr->class_idx == CLASS_NINJA) && ((backstab || fuiuchi) && !(tar_ptr->resist_ultimate))) success_hit = TRUE;
	else success_hit = test_hit_norm(atk_ptr, chance,  tar_ptr->ac + tar_ptr->to_ac, tar_ptr->ml);

	if (mode == HISSATSU_MAJIN && one_in_(2)) success_hit = FALSE;

	// Test for hit
	if (success_hit)
	{
		int vorpal_chance = ((weapon_ptr->name1 == ART_VORPAL_BLADE) || (weapon_ptr->name1 == ART_CHAINSWORD)) ? 2 : 4;
		sound(SOUND_HIT);
		if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
		{
#ifdef JP
			if (backstab)
			{
				msg_format("%s͗⍓ɂĂ閳͂%s˂hI", atk_name, tar_name);
			}
			else if (fuiuchi)
			{
				msg_format("%s͕sӂ˂%sɋȈꌂ킹I", atk_name, tar_name);
			}
			else if (stab_fleeing)
			{
				msg_format("%s͓%sw˂hI", atk_name, tar_name);
			}
#else
			if (backstab)
			{
				//TODO
				msg_format("%s cruelly stab the helpless, sleeping %s!", atk_name, tar_name);
			}
			else if (fuiuchi)
			{
				//TODO
				msg_format("%s make surprise attack, and hit %s with a powerful blow!", atk_name, tar_name);
			}
			else if (stab_fleeing)
			{
				//TODO
				msg_format("%s backstab the fleeing %s!", atk_name, tar_name);
			}
#endif
		}

		/* Hack -- bare hands do one damage */
		k = 1;

		object_flags(weapon_ptr, flgs);

		// Select a chaotic effect (50% chance)
		if ((have_flag(flgs, TR_CHAOTIC)) && one_in_(2))
		{
			if (one_in_(10))
			{
				if (randint1(5) < 3)   chaos_effect = 1; // Vampiric (20%)
				else if (one_in_(250)) chaos_effect = 2; // Quake (0.12%)
				else if (!one_in_(10)) chaos_effect = 3; // Confusion (26.892%)
				else if (one_in_(2))   chaos_effect = 4; // Teleport away (1.494%)
				else                   chaos_effect = 5; // Polymorph (1.494%)
			}
		}

		// Vampiric drain
		if ((have_flag(flgs, TR_VAMPIRIC)) || (chaos_effect == 1) || (mode == HISSATSU_DRAIN) || hex_spelling(atk_ptr, HEX_VAMP_BLADE))
		{
			// Only drain "living" creatures
			if (creature_living(tar_ptr)) can_drain = TRUE;
			else can_drain = FALSE;
		}

		if ((have_flag(flgs, TR_VORPAL) || hex_spelling(atk_ptr, HEX_RUNESWORD)) && (randint1(vorpal_chance*3/2) == 1) && !zantetsu_mukou)
			vorpal_cut = TRUE;
		else vorpal_cut = FALSE;

		// Handle normal weapon
		if (weapon_ptr->k_idx)
		{
			k = diceroll(weapon_ptr->dd + atk_ptr->to_damaged[hand], weapon_ptr->ds + atk_ptr->to_damages[hand]);
			k = tot_dam_aux(atk_ptr, weapon_ptr, k, tar_ptr, mode, FALSE);

			if (backstab)
			{
				k *= (3 + (atk_ptr->lev / 20));
			}
			else if (fuiuchi)
			{
				k = k*(5+(atk_ptr->lev*2/25))/2;
			}
			else if (stab_fleeing)
			{
				k = (3 * k) / 2;
			}

			if ((atk_ptr->impact[hand] && ((k > 50) || one_in_(7))) ||
				(chaos_effect == 2) || (mode == HISSATSU_QUAKE))
			{
				do_quake = TRUE;
			}

			if ((!(weapon_ptr->tval == TV_SWORD) || !(weapon_ptr->sval == SV_DOKUBARI)) && !(mode == HISSATSU_KYUSHO))
				k = critical_norm(atk_ptr, weapon_ptr->weight, weapon_ptr->to_hit, k, atk_ptr->to_hit[hand], mode);

			drain_result = k;

			if (vorpal_cut)
			{
				int mult = 2;

				if ((weapon_ptr->name1 == ART_CHAINSWORD) && !one_in_(2))
				{
					char chainsword_noise[1024];
#ifdef JP
					if (!get_rnd_line("chainswd_j.txt", 0, chainsword_noise))
#else
					if (!get_rnd_line("chainswd.txt", 0, chainsword_noise))
#endif
					{
						msg_print(chainsword_noise);
					}
				}

				if (weapon_ptr->name1 == ART_VORPAL_BLADE)
				{
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_print("ڂɂ~܂ʃH[pu[hAB̑ƁI");
#else
						msg_print("Your Vorpal Blade goes snicker-snack!");
#endif
				}
				else
				{
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("%sObT؂􂢂I", tar_name);
#else
						msg_format("Your weapon cuts deep into %s!", tar_name);
#endif
				}

				/* Try to increase the damage */
				while (one_in_(vorpal_chance))
				{
					mult++;
				}

				k *= mult;

				// Ouch!
				if (((tar_ptr->resist_ultimate) ? k / 100 : k) > tar_ptr->chp)
				{
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("%s^ɂI", tar_name);
#else
						msg_format("You cut %s in half!", tar_name);
#endif
				}
				else
				{
					switch (mult)
					{
						if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
						{
#ifdef JP
							case 2: msg_format("%saI", tar_name); break;
							case 3: msg_format("%sԂaI", tar_name); break;
							case 4: msg_format("%sb^aɂI", tar_name); break;
							case 5: msg_format("%sb^^ɎaI", tar_name); break;
							case 6: msg_format("%shgɂI", tar_name); break;
							case 7: msg_format("%saĎaĎa܂I", tar_name); break;
							default: msg_format("%sא؂ɂI", tar_name); break;
#else
							case 2: msg_format("You gouge %s!", tar_name); break;
							case 3: msg_format("You maim %s!", tar_name); break;
							case 4: msg_format("You carve %s!", tar_name); break;
							case 5: msg_format("You cleave %s!", tar_name); break;
							case 6: msg_format("You smite %s!", tar_name); break;
							case 7: msg_format("You eviscerate %s!", tar_name); break;
							default: msg_format("You shred %s!", tar_name); break;
#endif
						}
					}
				}
				drain_result = drain_result * 3 / 2;
			}

			k += weapon_ptr->to_damage;
			drain_result += weapon_ptr->to_damage;
		}

		// Apply the player damage bonuses
		k += atk_ptr->to_damage[hand];
		drain_result += atk_ptr->to_damage[hand];

		if ((mode == HISSATSU_SUTEMI) || (mode == HISSATSU_3DAN)) k *= 2;
		if ((mode == HISSATSU_SEKIRYUKA) && !creature_living(tar_ptr)) k = 0;
		if ((mode == HISSATSU_SEKIRYUKA) && !atk_ptr->cut) k /= 2;
		if (k < 0) k = 0; // No negative damage
		if ((mode == HISSATSU_ZANMA) && !(!creature_living(tar_ptr) && is_enemy_of_good_creature(tar_ptr)))
		{
			k = 0;
		}

		if (zantetsu_mukou)
		{
			if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
				msg_print("ȓ炩̂͐؂I");
#else
				msg_print("You cannot cut such a elastic thing!");
#endif
			k = 0;
		}

		if (e_j_mukou)
		{
			if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
				msg_print("w偂͋肾I");
#else
				msg_print("Spiders are difficult for you to deal with!");
#endif
			k /= 2;
		}

		if (mode == HISSATSU_MINEUCHI)
		{
			int tmp = (10 + randint1(15) + atk_ptr->lev / 5);

			k = 0;
			anger_creature(atk_ptr, tar_ptr);

			if (!has_cf_creature(tar_ptr, CF_NO_STUN))
			{
				if (tar_ptr->stun) // Get stunned
				{
					if(is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("%s͂Ђǂ낤ƂB", tar_name);
#else
						msg_format("%s is more dazed.", tar_name);
#endif
					tmp /= 2;
				}
				else
				{
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("%s ͂낤ƂB", tar_name);
#else
						msg_format("%s is dazed.", tar_name);
#endif
				}

				/* Apply stun */
				(void)set_stun(&creature_list[c_ptr->creature_idx], tar_ptr->stun + tmp);
			}
			else
			{
				if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
					msg_format("%s ɂ͌ʂȂB", tar_name);
#else
					msg_format("%s is not effected.", tar_name);
#endif
			}
		}

		// Modify the damage
		k = invuln_damage_mod(tar_ptr, k, (bool)(((weapon_ptr->tval == TV_POLEARM) && (weapon_ptr->sval == SV_DEATH_SCYTHE)) || ((atk_ptr->class_idx == CLASS_BERSERKER) && one_in_(2))));
		if (((weapon_ptr->tval == TV_SWORD) && (weapon_ptr->sval == SV_DOKUBARI)) || (mode == HISSATSU_KYUSHO))
		{
			if ((randint1(randint1(r_ptr->level / 7)+5) == 1) && !is_unique_creature(tar_ptr) && !is_sub_unique_creature(tar_ptr))
			{
				k = tar_ptr->chp + 1;
				if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
					msg_format("%s̋}˂hI", tar_name);
#else
					msg_format("You hit %s on a fatal spot!", tar_name);
#endif
			}
			else k = 1;
		}
		else if ((atk_ptr->class_idx == CLASS_NINJA) && get_equipped_slot_num(atk_ptr, INVEN_SLOT_HAND) && !atk_ptr->icky_wield[hand] && ((atk_ptr->cur_lite <= 0) || one_in_(7)))
		{
			if (one_in_(backstab ? 13 : (stab_fleeing || fuiuchi) ? 15 : 27))
			{
				k *= 5;
				drain_result *= 2;
				if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
					msg_format("n%sɐ[XƓ˂hI", tar_name);
#else
					msg_format("You critically injured %s!", tar_name);
#endif
			}

			else if (((tar_ptr->chp < tar_ptr->mhp/2) && one_in_(10)) || ((one_in_(666) || ((backstab || fuiuchi) && one_in_(11))) && !is_unique_creature(tar_ptr) && !is_sub_unique_creature(tar_ptr)))
			{
				if (is_unique_creature(tar_ptr) || is_sub_unique_creature(tar_ptr) || (tar_ptr->chp >= tar_ptr->mhp/2))
				{
					k = MAX(k*5, tar_ptr->chp/2);
					drain_result *= 2;
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("%sɒv𕉂킹I", tar_name);
#else
						msg_format("You fatally injured %s!", tar_name);
#endif
				}
				else
				{
					k = tar_ptr->chp + 1;
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("n%s̋}тI", tar_name);
#else
						msg_format("You hit %s on a fatal spot!", tar_name);
#endif
				}
			}
		}

		// Complex message
		if (wizard || cheat_xtra)
		{
			msg_format("DAM:%d HP:%d->%d", k, tar_ptr->chp, tar_ptr->chp - k);
		}

		if (k <= 0) can_drain = FALSE;

		if (drain_result > tar_ptr->chp)
			drain_result = tar_ptr->chp;

		take_hit(atk_ptr, tar_ptr, 0, k, NULL, NULL, -1); // Damage, check for fear and death

		if(gameover);
		{
			*mdeath = TRUE;
			if ((atk_ptr->class_idx == CLASS_BERSERKER) && energy_use)
			{
				//TODO
			}
			if ((weapon_ptr->name1 == ART_ZANTETSU) && is_lowlevel)
				if(is_player(atk_ptr))
#ifdef JP
					msg_print("܂܂ʂ̂aĂ܂DDD");
#else
					msg_print("Sigh... Another trifling thing I've cut....");
#endif
		}

		// Anger the creature
		if (k > 0) anger_creature(atk_ptr, tar_ptr);

		touch_zap_player(atk_ptr, tar_ptr);

		// Are we draining it?  A little note: If the creature is dead, the drain does not work...

		if (can_drain && (drain_result > 0))
		{
			if (weapon_ptr->name1 == ART_MURAMASA)
			{
				if (is_human)
				{
					int to_hit = weapon_ptr->to_hit;
					int to_damage = weapon_ptr->to_damage;
					int i, flag;

					flag = 1;
					for (i = 0; i < to_hit + 3; i++) if (one_in_(4)) flag = 0;
					if (flag) to_hit++;

					flag = 1;
					for (i = 0; i < to_damage + 3; i++) if (one_in_(4)) flag = 0;
					if (flag) to_damage++;

					if (weapon_ptr->to_hit != to_hit || weapon_ptr->to_damage != to_damage)
					{
						if(is_seen(player_ptr, atk_ptr))
#ifdef JP
							msg_print("d͌zċȂI");
#else
							msg_print("Muramasa sucked blood, and became more powerful!");
#endif
						weapon_ptr->to_hit = to_hit;
						weapon_ptr->to_damage = to_damage;
					}
				}
			}
			else
			{
				if (drain_result > 5) /* Did we really hurt it? */
				{
					drain_heal = diceroll(2, drain_result / 6);

					/* Hex */
					if (hex_spelling(atk_ptr, HEX_VAMP_BLADE)) drain_heal *= 2;

					if (cheat_xtra)
					{
#ifdef JP
						msg_format("Draining left: %d", drain_left);
#else
						msg_format("Draining left: %d", drain_left);
#endif

					}

					if (drain_left)
					{
						if (drain_heal < drain_left)
						{
							drain_left -= drain_heal;
						}
						else
						{
							drain_heal = drain_left;
							drain_left = 0;
						}

						if (drain_msg)
						{
							if(is_seen(player_ptr, atk_ptr))
#ifdef JP
								msg_format("n%s琶͂zI", tar_name);
#else
								msg_format("Your weapon drains life from %s!", tar_name);
#endif

							drain_msg = FALSE;
						}

						drain_heal = (drain_heal * atk_ptr->mutant_regenerate_mod) / 100;

						hp_player(atk_ptr, drain_heal);
						/* We get to keep some of it! */
					}
				}
			}
			tar_ptr->mhp -= (k+7)/8;
			if (tar_ptr->chp > tar_ptr->mhp) tar_ptr->chp = tar_ptr->mhp;
			if (tar_ptr->mhp < 1) tar_ptr->mhp = 1;
			weak = TRUE;
		}
		can_drain = FALSE;
		drain_result = 0;

		if (chaos_effect == 4)
		{
			bool resists_tele = FALSE;

			if (has_cf_creature(tar_ptr, CF_RES_TELE))
			{
				if (is_unique_creature(tar_ptr))
				{
					if (is_original_ap_and_seen(player_ptr, tar_ptr)) reveal_creature_info(tar_ptr, CF_RES_TELE);
#ifdef JP
					msg_format("%^sɂ͌ʂȂB", tar_name);
#else
					msg_format("%^s is unaffected!", tar_name);
#endif

					resists_tele = TRUE;
				}
				else if (r_ptr->level > randint1(100))
				{
					if (is_original_ap_and_seen(player_ptr, tar_ptr)) reveal_creature_info(tar_ptr, CF_RES_TELE);
#ifdef JP
					msg_format("%^s͒R͂ĂI", tar_name);
#else
					msg_format("%^s resists!", tar_name);
#endif

					resists_tele = TRUE;
				}
			}

			if (!resists_tele)
			{
#ifdef JP
				msg_format("%^s͏I", tar_name);
#else
				msg_format("%^s disappears!", tar_name);
#endif

				teleport_away(&creature_list[c_ptr->creature_idx], 50, TELEPORT_PASSIVE);
				*mdeath = TRUE;
			}
		}

		else if ((chaos_effect == 5) && (randint1(90) > r_ptr->level))
		{
			if (!(is_unique_creature(tar_ptr) || is_quest_creature(tar_ptr)) &&
				!has_cf_creature(tar_ptr, CF_RES_CHAO))
			{
				if (polymorph_creature(atk_ptr, y, x))
				{
#ifdef JP
					msg_format("%^s͕ωI", tar_name);
#else
					msg_format("%^s changes!", tar_name);
#endif

					*fear = FALSE;
					weak = FALSE;
				}
				else
				{
#ifdef JP
					msg_format("%^sɂ͌ʂȂB", tar_name);
#else
					msg_format("%^s is unaffected.", tar_name);
#endif
				}

				/* Hack -- Get new creature */
				tar_ptr = &creature_list[c_ptr->creature_idx];

				/* Oops, we need a different name... */
				creature_desc(tar_name, tar_ptr, 0);

				/* Hack -- Get new race */
				r_ptr = &species_info[tar_ptr->species_idx];
			}
		}
		else if (weapon_ptr->name1 == ART_G_HAMMER)
		{
			creature_type *tar_ptr = &creature_list[c_ptr->creature_idx];

			//TODO reimplement get item process.
		}
	}

	/* Player misses */
	else
	{
		backstab = FALSE; /* Clumsy! */
		fuiuchi = FALSE; /* Clumsy! */

		if ((weapon_ptr->tval == TV_POLEARM) && (weapon_ptr->sval == SV_DEATH_SCYTHE) && one_in_(3))
		{

			/* Sound */
			sound(SOUND_HIT);

			/* Message */
			if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
			{
#ifdef JP
				msg_format("%s%s̍U킵B", tar_name, atk_name);
#else
				msg_format("%^s misses %s.", tar_name, atk_name);
#endif
#ifdef JP
				msg_print("U񂵂劙gɕԂĂI");
#else
				msg_print("Your scythe returns to you!");
#endif
			}

			//TODO Death Scythe damage.
			k = 0;
#ifdef JP
			take_hit(NULL, atk_ptr, DAMAGE_FORCE, k, "̑劙", NULL, -1);
#else
			take_hit(NULL, atk_ptr, DAMAGE_FORCE, k, "Death scythe", NULL, -1);
#endif

			redraw_stuff();
		}
		else
		{
			/* Sound */
			sound(SOUND_MISS);

			/* Message */
#ifdef JP

			msg_format("%s%s̍U킵B", tar_name, atk_name);
#else
			msg_format("%^s misses %s.", tar_name, atk_name);
#endif
		}
	}
	backstab = FALSE;
	fuiuchi = FALSE;


	if (weak && !(*mdeath))
	{
#ifdef JP
		msg_format("%s͎キȂ悤B", tar_name);
#else
		msg_format("%^s seems weakened.", tar_name);
#endif
	}

	// Mega-Hack -- apply earthquake brand
	if (do_quake)
	{
		earthquake(tar_ptr, atk_ptr->fy, atk_ptr->fx, 10);
		if (!floor_ptr->cave[y][x].creature_idx) *mdeath = TRUE;
	}

}


static void natural_attack(creature_type *atk_ptr, creature_type *tar_ptr, int attack, bool *fear, bool *mdeath)
{
	int             k, bonus, chance;
	int             n_weight = 0;
	char            target_name[80];

	int             dss, ddd;

	cptr            atk_desc;

	switch (attack)
	{
		case CF_SCOR_TAIL:
			dss = 3;
			ddd = 7;
			n_weight = 5;
#ifdef JP
			atk_desc = "K";
#else
			atk_desc = "tail";
#endif

			break;
		case CF_HORNS:
			dss = 2;
			ddd = 6;
			n_weight = 15;
#ifdef JP
			atk_desc = "p";
#else
			atk_desc = "horns";
#endif

			break;
		case CF_BEAK:
			dss = 2;
			ddd = 4;
			n_weight = 5;
#ifdef JP
			atk_desc = "N`oV";
#else
			atk_desc = "beak";
#endif

			break;
		case CF_TRUNK:
			dss = 1;
			ddd = 4;
			n_weight = 35;
#ifdef JP
			atk_desc = "ۂ̕@";
#else
			atk_desc = "trunk";
#endif

			break;
		case CF_TENTACLES:
			dss = 2;
			ddd = 5;
			n_weight = 5;
#ifdef JP
			atk_desc = "G";
#else
			atk_desc = "tentacles";
#endif

			break;
		default:
			dss = ddd = n_weight = 1;
#ifdef JP
			atk_desc = "`̕";
#else
			atk_desc = "undefined body part";
#endif

	}

	/* Extract creature name (or "it") */
	creature_desc(target_name, tar_ptr, 0);


	/* Calculate the "attack quality" */
	bonus = atk_ptr->to_hit_m;
	bonus += (atk_ptr->lev * 6 / 5);
	chance = (atk_ptr->skill_thn + (bonus * BTH_PLUS_ADJ));

	/* Test for hit */
	if ((!has_cf_creature(tar_ptr, CF_QUANTUM) || !randint0(2)) && test_hit_norm(atk_ptr, chance, tar_ptr->ac + tar_ptr->to_ac, tar_ptr->ml))
	{
		/* Sound */
		sound(SOUND_HIT);

#ifdef JP
		msg_format("%s%sōUB", target_name, atk_desc);
#else
		msg_format("You hit %s with your %s.", target_name, atk_desc);
#endif


		k = diceroll(ddd, dss);
		k = critical_norm(atk_ptr, n_weight, bonus, k, (s16b)bonus, 0);

		/* Apply the player damage bonuses */
		k += atk_ptr->to_damage_m;

		/* No negative damage */
		if (k < 0) k = 0;

		/* Modify the damage */
		k = invuln_damage_mod(tar_ptr, k, FALSE);

		/* Complex message */
		if (wizard)
		{
			msg_format("DAM:%d HP:%d->%d", k, tar_ptr->chp, tar_ptr->chp - k);
		}

		/* Anger the creature */
		if (k > 0) anger_creature(atk_ptr, tar_ptr);

		/* Damage, check for fear and mdeath */
		switch (attack)
		{
			case CF_SCOR_TAIL:
				project(0, 0, tar_ptr->fy, tar_ptr->fx, k, GF_POIS, PROJECT_KILL, -1);
				break;
			case CF_HORNS:
				take_hit(atk_ptr, tar_ptr, 0, k, NULL , NULL, -1);
				break;
			case CF_BEAK:
				take_hit(atk_ptr, tar_ptr, 0, k, NULL , NULL, -1);
				break;
			case CF_TRUNK:
				take_hit(atk_ptr, tar_ptr, 0, k, NULL , NULL, -1);
				break;
			case CF_TENTACLES:
				take_hit(atk_ptr, tar_ptr, 0, k, NULL , NULL, -1);
				break;
			default:
				take_hit(atk_ptr, tar_ptr, 0, k, NULL , NULL, -1);
		}
		*mdeath = (tar_ptr->species_idx == 0);
		touch_zap_player(atk_ptr, tar_ptr);
	}
	/* Player misses */
	else
	{
		/* Sound */
		sound(SOUND_MISS);

		/* Message */
		if(is_player(atk_ptr))
		{
#ifdef JP
			msg_format("~XI %sɂ킳ꂽB", target_name);
#else
			msg_format("You miss %s.", target_name);
#endif
		}

	}
}



static void trampling_attack(s16b m_idx, int attack, bool *fear, bool *mdeath)
{
	creature_type    *m_ptr = &creature_list[m_idx];
	species_type    *r_ptr = &species_info[m_ptr->species_idx];
}


static void barehand_attack(creature_type *atk_ptr, creature_type *tar_ptr, int y, int x, bool *fear, bool *mdeath, s16b hand, int mode)
{
	char weapon_name[100], atk_name[100], tar_name[100];
	floor_type *floor_ptr = get_floor_ptr(atk_ptr);
	cave_type *c_ptr = &floor_ptr->cave[y][x];
	species_type *r_ptr = &species_info[tar_ptr->species_idx];
	bool monk_attack = FALSE;
	int k;

	switch(atk_ptr->class_idx)
	{
		case CLASS_MONK:
		case CLASS_FORCETRAINER:
		case CLASS_BERSERKER:
			if ((empty_hands(atk_ptr, TRUE) & EMPTY_HAND_RARM) && !atk_ptr->riding) monk_attack = TRUE;
			break;
	}

#if JP
	strcpy(weapon_name, "f");
#else
	strcpy(weapon_name, "bare hand");
#endif

	if ((r_ptr->level + 10) > atk_ptr->lev)
	{
		// Matrial arts skill mastering
		if (atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] < skill_info[atk_ptr->class_idx].s_max[SKILL_MARTIAL_ARTS])
		{
			if (atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] < WEAPON_EXP_BEGINNER)
				atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] += 40;
			else if ((atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] < WEAPON_EXP_SKILLED))
				atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] += 5;
			else if ((atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] < WEAPON_EXP_EXPERT) && (atk_ptr->lev > 19))
				atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] += 1;
			else if ((atk_ptr->lev > 34))
				if (one_in_(3)) atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] += 1;
			atk_ptr->creature_update |= (CRU_BONUS);
		}
	}

	if (monk_attack)
	{
		int special_effect = 0, stun_effect = 0, times = 0, max_times;
		int min_level = 1;
		martial_arts *ma_ptr = &ma_blows[0], *old_ptr = &ma_blows[0];
		int resist_stun = 0;
		int weight = 8;

		if (has_cf_creature(tar_ptr, CF_UNIQUE)) resist_stun += 88;
		if (has_cf_creature(tar_ptr, CF_NO_STUN)) resist_stun += 66;
		if (has_cf_creature(tar_ptr, CF_NO_CONF)) resist_stun += 33;
		if (has_cf_creature(tar_ptr, CF_NO_SLEEP)) resist_stun += 33;
		if (is_undead_creature(tar_ptr) || has_cf_creature(tar_ptr, CF_NONLIVING))
			resist_stun += 66;

		if (atk_ptr->special_defense & KAMAE_BYAKKO)
			max_times = (atk_ptr->lev < 3 ? 1 : atk_ptr->lev / 3);
		else if (atk_ptr->special_defense & KAMAE_SUZAKU)
			max_times = 1;
		else if (atk_ptr->special_defense & KAMAE_GENBU)
			max_times = 1;
		else
			max_times = (atk_ptr->lev < 7 ? 1 : atk_ptr->lev / 7);
		/* Attempt 'times' */
		for (times = 0; times < max_times; times++)
		{
			do
			{
				ma_ptr = &ma_blows[randint0(MAX_MA)];
				if ((atk_ptr->class_idx == CLASS_FORCETRAINER) && (ma_ptr->min_level > 1)) min_level = ma_ptr->min_level + 3;
				else min_level = ma_ptr->min_level;
			}
			while ((min_level > atk_ptr->lev) || (randint1(atk_ptr->lev) < ma_ptr->chance));

			/* keep the highest level attack available we found */
			if ((ma_ptr->min_level > old_ptr->min_level) && !atk_ptr->stun && !atk_ptr->confused)
			{
				old_ptr = ma_ptr;

				if (wizard && cheat_xtra)
				{
#ifdef JP
					msg_print("UđI܂B");
#else
					msg_print("Attack re-selected.");
#endif
				}
			}
			else
			{
				ma_ptr = old_ptr;
			}
		}

		if (atk_ptr->class_idx == CLASS_FORCETRAINER) min_level = MAX(1, ma_ptr->min_level - 3);
		else min_level = ma_ptr->min_level;
		k = diceroll(ma_ptr->dd + atk_ptr->to_damaged[hand], ma_ptr->ds + atk_ptr->to_damages[hand]);
		if (atk_ptr->special_attack & ATTACK_SUIKEN) k *= 2;

		if (ma_ptr->effect == MA_KNEE)
		{
			if (IS_MALE(tar_ptr))
			{
				if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
				{
#ifdef JP
					msg_format("%s%sɋIGR킵I", atk_name, tar_name);
#else
					//TODO
					msg_format("%s hit %s in the groin with your knee!", atk_name, tar_name);
#endif

					sound(SOUND_PAIN);
					special_effect = MA_KNEE;
				}
			}
			else
			{
				if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
					msg_format(ma_ptr->desc, atk_name, tar_name);
			}
		}

		else if (ma_ptr->effect == MA_SLOW)
		{
			if (!((is_never_move_species(r_ptr)) || my_strchr("~#{}.UjmeEv$,DdsbBFIJQSXclnw!=?", r_ptr->d_char)))
			{
				if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
				{
#ifdef JP
					msg_format("%s%s̑Ɋ֐ߏR킵I", atk_name, tar_name);
#else
					//TODO
					msg_format("You kick %s in the ankle.", tar_name);
#endif
				}
				special_effect = MA_SLOW;
			}
			else if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr)) msg_format(ma_ptr->desc, tar_name);
		}
		else
		{
			if (ma_ptr->effect)
			{
				stun_effect = (ma_ptr->effect / 2) + randint1(ma_ptr->effect / 2);
			}

			if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr)) msg_format(ma_ptr->desc, atk_name, tar_name);
		}

		if (atk_ptr->special_defense & KAMAE_SUZAKU) weight = 4;
		if ((atk_ptr->class_idx == CLASS_FORCETRAINER) && (atk_ptr->magic_num1[0]))
		{
			weight += (atk_ptr->magic_num1[0]/30);
			if (weight > 20) weight = 20;
		}

		k = critical_norm(atk_ptr, atk_ptr->lev * weight, min_level, k, atk_ptr->to_hit[0], 0);

		if ((special_effect == MA_KNEE) && ((k + atk_ptr->to_damage[hand]) < tar_ptr->chp))
		{
#ifdef JP
			if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr)) msg_format("%^s͋ɂɂ߂ĂI", tar_name);
#else
			if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr)) msg_format("%^s moans in agony!", tar_name);
#endif

			stun_effect = 7 + randint1(13);
			resist_stun /= 3;
		}

		else if ((special_effect == MA_SLOW) && ((k + atk_ptr->to_damage[hand]) < tar_ptr->chp))
		{
			if (!is_unique_creature(tar_ptr) &&
			    (randint1(atk_ptr->lev) > r_ptr->level) &&
			    tar_ptr->speed > 60)
			{
				if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
					msg_format("%^s͑Ђn߂B", tar_name);
#else
					msg_format("%^s starts limping slower.", tar_name);
#endif

				tar_ptr->speed -= 10;
			}
		}

		if (stun_effect && ((k + atk_ptr->to_damage[hand]) < tar_ptr->chp))
		{
			if (atk_ptr->lev > randint1(r_ptr->level + resist_stun + 10))
			{
				if (set_stun(&creature_list[c_ptr->creature_idx], stun_effect + tar_ptr->stun))
				{
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("%^s̓ttɂȂB", tar_name);
#else
						msg_format("%^s is stunned.", tar_name);
#endif
				}
				else
				{
					if(is_seen(player_ptr, atk_ptr) || is_seen(player_ptr, tar_ptr))
#ifdef JP
						msg_format("%^s͂ɃttɂȂB", tar_name);
#else
						msg_format("%^s is more stunned.", tar_name);
#endif
				}
			}
		}
	}
}



static void confuse_melee(creature_type *atk_ptr, creature_type *tar_ptr, int y, int x, bool *fear, bool *mdeath, s16b hand, int mode)
{
	char tar_name[100];
	floor_type *floor_ptr = get_floor_ptr(atk_ptr);
	cave_type *c_ptr = &floor_ptr->cave[y][x];
	species_type *r_ptr = &species_info[tar_ptr->species_idx];

	// Confusion attack
	//TODO if ((atk_ptr->special_attack & ATTACK_CONFUSE) || (chaos_effect == 3) || (mode == HISSATSU_CONF) || hex_spelling(atk_ptr, HEX_CONFUSION))
	{
		// Cancel glowing hands
		if (atk_ptr->special_attack & ATTACK_CONFUSE)
		{
			atk_ptr->special_attack &= ~(ATTACK_CONFUSE);
			if(is_seen(player_ptr, atk_ptr))
#ifdef JP
				msg_print("̋PȂȂB");
#else
				msg_print("Your hands stop glowing.");
#endif
			play_redraw |= (PR_STATUS);

		}

		// Confuse the creature
		if (has_cf_creature(tar_ptr, CF_NO_CONF))
		{
			if (is_original_ap_and_seen(atk_ptr, tar_ptr)) reveal_creature_info(tar_ptr, CF_NO_CONF);

			if(is_seen(player_ptr, tar_ptr))
#ifdef JP
				msg_format("%^sɂ͌ʂȂB", tar_name);
#else
				msg_format("%^s is unaffected.", tar_name);
#endif

		}
		else if (randint0(100) < r_ptr->level)
		{
			if(is_seen(player_ptr, tar_ptr))
#ifdef JP
				msg_format("%^sɂ͌ʂȂB", tar_name);
#else
				msg_format("%^s is unaffected.", tar_name);
#endif

		}
		else
		{
			if(is_seen(player_ptr, tar_ptr))
#ifdef JP
				msg_format("%^s͍悤B", tar_name);
#else
				msg_format("%^s appears confused.", tar_name);
#endif

			(void)set_confused(&creature_list[c_ptr->creature_idx], tar_ptr->confused + 10 + randint0(atk_ptr->lev) / 5);
		}
	}
}





static bool zantetsuken_cancel(creature_type *attacker_ptr, creature_type *target_ptr)
{
	int i, n;
	char attacker_name[100];
	creature_desc(attacker_name, attacker_ptr, 0);

	if (IS_FEMALE(target_ptr) && has_cf_creature(target_ptr, CF_HUMANOID) &&
	    !(attacker_ptr->stun || attacker_ptr->confused || attacker_ptr->image || !target_ptr->ml))
	{
		n = get_equipped_slot_num(attacker_ptr, INVEN_SLOT_HAND);
		for(i = 0; i < n; i++)
		{
			if (attacker_ptr->inventory[i].name1 == ART_ZANTETSU)
			{
#ifdef JP
				msg_format("%s͎v킸񂾁BuَҁAȂ͎aʁIv", attacker_name);
#else
				msg_print("%s shouted, \"I can not attack women!\"", attacker_name);
#endif
				return TRUE;
			}
		}
	}

	return FALSE;
}

static bool fear_cancel(creature_type *attacker_ptr, creature_type *target_ptr)
{
	if (attacker_ptr->afraid) // Handle player fear
	{
		char attacker_name[100];
		char target_name[100];
		creature_desc(attacker_name, attacker_ptr, 0);
		creature_desc(target_name, target_ptr, 0);

		if (target_ptr->ml) // Message
		{
#ifdef JP
			msg_format("%s͋Ă%sUłȂI", attacker_name, target_name);
#else
			msg_format("%s are too afraid to attack %s!", attacker_name, target_name);
#endif
		}

		else if(is_player(attacker_ptr))
		{
#ifdef JP
			msg_format ("ɂ͉̂I");
#else
			msg_format ("There is something scary in your way!");
#endif
		}

		(void)set_paralyzed(target_ptr, 0); // Disturb the creature
		return TRUE; // Done
	}

	return FALSE;
}



static void gain_two_fencing_skill(creature_type *attacker_ptr, creature_type *target_ptr)
{
	if (count_melee_slot(attacker_ptr))
	{
		if ((attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] < skill_info[attacker_ptr->class_idx].s_max[SKILL_MULTI_WEAPON]) && ((attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] - 1000) / 200 < target_ptr->lev))
		{
			if (attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] < WEAPON_EXP_BEGINNER)
				attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] += 80;
			else if(attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] < WEAPON_EXP_SKILLED)
				attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] += 4;
			else if(attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] < WEAPON_EXP_EXPERT)
				attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] += 1;
			else if(attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] < WEAPON_EXP_MASTER)
				if (one_in_(3)) attacker_ptr->skill_exp[SKILL_MULTI_WEAPON] += 1;
			attacker_ptr->creature_update |= (CRU_BONUS);
		}
	}
}

static void gain_riding_skill(creature_type *attacker_ptr, creature_type *target_ptr)
{
	if (attacker_ptr->riding)
	{
		int cur = attacker_ptr->skill_exp[SKILL_RIDING];
		int max = skill_info[attacker_ptr->class_idx].s_max[SKILL_RIDING];

		if (cur < max)
		{
			int ridinglevel = species_info[creature_list[attacker_ptr->riding].species_idx].level;
			int targetlevel = target_ptr->lev;
			int inc = 0;

			if ((cur / 200 - 5) < targetlevel)
				inc += 1;

			// Extra experience
			if ((cur / 100) < ridinglevel)
			{
				if ((cur / 100 + 15) < ridinglevel)
					inc += 1 + (ridinglevel - (cur / 100 + 15));
				else
					inc += 1;
			}

			attacker_ptr->skill_exp[SKILL_RIDING] = MIN(max, cur + inc);
			attacker_ptr->creature_update |= (CRU_BONUS);
		}
	}
}


static bool cease_for_friend(creature_type *attacker_ptr, creature_type *target_ptr)
{
	if (!is_hostile(target_ptr) && !(attacker_ptr->stun || attacker_ptr->confused || attacker_ptr->image || attacker_ptr->shero || !target_ptr->ml))
	{
		char attacker_name[100];
		char target_name[100];
		char weapon_name[100];
		int i, n, stormbringer;
		creature_desc(attacker_name, attacker_ptr, 0);
		creature_desc(target_name, target_ptr, 0);

		n = get_equipped_slot_num(attacker_ptr, INVEN_SLOT_HAND);
		for(i = 0; i < n; i++)
		{
			if (attacker_ptr->inventory[i].name1 == ART_STORMBRINGER)
			{
				object_desc(weapon_name, &attacker_ptr->inventory[i], (OD_NAME_ONLY));
				stormbringer = TRUE;
				break;
			}
		}

		// Attack by Storm-Bringer
		if (stormbringer)
		{
#ifdef JP
			msg_format("%s͋~%sUI", weapon_name, target_name);
#else
			msg_format("%s greedily attacks %s!", weapon_name, target_name);
#endif
		}
		else if (attacker_ptr->class_idx != CLASS_BERSERKER && is_player(attacker_ptr))
		{
#ifdef JP
			if (!get_check("{ɍU܂H"))
#else
			if (!get_check("Really hit it? "))
#endif
			{
#ifdef JP
				msg_format("%sÛ~߂B", target_name);
#else
				msg_format("You stop to avoid hitting %s.", target_name);
#endif
				return TRUE;
			}
		}
	}

	return FALSE;
}

static bool cease_by_counter(creature_type *attacker_ptr, creature_type *target_ptr)
{
	if (target_ptr->special_defense & KATA_IAI)
	{
		char attacker_name[100];
		char target_name[100];
		creature_desc(attacker_name, attacker_ptr, 0);
		creature_desc(target_name, target_ptr, 0);
#ifdef JP
		msg_format("%s%sPOɑfUB", target_name, attacker_name);
#else
		msg_format("%s took \"sen\", drew and cut in one motion before %s moved.", target_name, attacker_name);
#endif
		if (melee_attack(target_ptr, attacker_ptr->fy, attacker_ptr->fx, HISSATSU_IAI)) return TRUE;
	}

	return FALSE;
}


static bool melee_limitation_field(floor_type *floor_ptr)
{
	if (dungeon_info[floor_ptr->dun_type].flags1 & DF1_NO_MELEE)
	{
#ifdef JP
		msg_print("ȂU邱ƂłȂB");
#else
		msg_print("Something prevent you from attacking.");
#endif
		return TRUE;
	}
	return FALSE;
}



bool melee_attack(creature_type *attacker_ptr, int y, int x, int mode)
{
	int i;

	bool fear = FALSE;
	bool dead = FALSE;

	floor_type      *floor_ptr = get_floor_ptr(attacker_ptr);
	cave_type       *c_ptr = &floor_ptr->cave[y][x];
	creature_type   *target_ptr;
	species_type    *atk_species_ptr;
	species_type    *tar_species_ptr;
	object_type			*weapon_ptr;
	special_blow_type	*special_ptr;
	char			attacker_name[80];
	char            target_name[80];

	int action_power;
	int action_list[MAX_MELEE_TYPE];
	int action_cost[MAX_MELEE_TYPE];
	int action_weight[MAX_MELEE_TYPE];
	int action_num;
	int tried_num;

	target_ptr = &creature_list[c_ptr->creature_idx];

	atk_species_ptr = &species_info[attacker_ptr->species_idx];
	tar_species_ptr = &species_info[target_ptr->species_idx];

	disturb(player_ptr, 0, 0); // Disturb the player

	// Extract attacker and target name (or "it")
	creature_desc(target_name, target_ptr, 0);
	creature_desc(attacker_name, attacker_ptr, 0);

	if (target_ptr->ml)
	{
		if (!attacker_ptr->image) species_type_track(target_ptr->ap_species_idx); // Auto-Recall if possible and visible
		health_track(c_ptr->creature_idx); // Track a new creature
	}

	if(zantetsuken_cancel(attacker_ptr, target_ptr)) return FALSE; // Cease by Zantetsu-Ken
	if(melee_limitation_field(floor_ptr)) return FALSE; // No melee flag
	if(cease_for_friend(attacker_ptr, target_ptr)) return FALSE; // Stop if friendly
	if(fear_cancel(attacker_ptr, target_ptr)) return FALSE; // Ceased by fear
	if(cease_by_counter(attacker_ptr, target_ptr)) return FALSE; // Ceased by Iai Counter
	if(kawarimi(target_ptr, TRUE)) return FALSE; // Ceased by Kawarimi

	gain_two_fencing_skill(attacker_ptr, target_ptr); // Gain two sword fencing skill
	gain_riding_skill(attacker_ptr, target_ptr); // Gain riding experience

	riding_t_m_idx = c_ptr->creature_idx;

	action_power = calc_action_power(attacker_ptr);
	action_num = 0;
	tried_num = 0;
	energy_use = 100;

	do
	{
		action_num = 0;

		for(i = 0; i < MAX_MELEE_TYPE; i++)
		{
			switch(i)
			{
				case MELEE_TYPE_WEAPON_1ST:
				case MELEE_TYPE_WEAPON_2ND:
				case MELEE_TYPE_WEAPON_3RD:
				case MELEE_TYPE_WEAPON_4TH:
				case MELEE_TYPE_WEAPON_5TH:
				case MELEE_TYPE_WEAPON_6TH:
				case MELEE_TYPE_WEAPON_7TH:
				case MELEE_TYPE_WEAPON_8TH:
					if(attacker_ptr->can_melee[i])
					{
						weapon_ptr = get_equipped_slot_ptr(attacker_ptr, INVEN_SLOT_HAND, i - MELEE_TYPE_WEAPON_1ST);
						action_list[action_num] = i;
						action_weight[action_num] = calc_weapon_melee_priority(attacker_ptr, weapon_ptr);
						action_num++;
					}
					break;

				case MELEE_TYPE_SPECIAL_1ST:
				case MELEE_TYPE_SPECIAL_2ND:
				case MELEE_TYPE_SPECIAL_3RD:
				case MELEE_TYPE_SPECIAL_4TH:
					if(attacker_ptr->blow[i - MELEE_TYPE_SPECIAL_1ST].d_dice);
					{
						special_ptr = &attacker_ptr->blow[i - MELEE_TYPE_SPECIAL_1ST];
						action_list[action_num] = i;
						action_cost[action_num] = calc_special_melee_cost(attacker_ptr, special_ptr);
						action_weight[action_num] = calc_special_melee_priority(attacker_ptr, special_ptr);
						action_num++;
					}
					break;
					break;

				case MELEE_TYPE_BARE_HAND:
					break;

				case MELEE_TYPE_STAMP:
					break;

				case MELEE_TYPE_HORNS:
				case MELEE_TYPE_BEAK:
				case MELEE_TYPE_SCOR_TAIL:
				case MELEE_TYPE_TRUNK:
				case MELEE_TYPE_TENTACLES:
					break;

			}
		}

		if(!action_num) break;

		i = uneven_rand(action_list, action_weight, action_num);

		switch(i)
		{
			case MELEE_TYPE_WEAPON_1ST:
			case MELEE_TYPE_WEAPON_2ND:
			case MELEE_TYPE_WEAPON_3RD:
			case MELEE_TYPE_WEAPON_4TH:
			case MELEE_TYPE_WEAPON_5TH:
			case MELEE_TYPE_WEAPON_6TH:
			case MELEE_TYPE_WEAPON_7TH:
			case MELEE_TYPE_WEAPON_8TH:
				if (attacker_ptr->can_melee[i]) weapon_attack(attacker_ptr, target_ptr, y, x, &fear, &dead, i + MELEE_TYPE_WEAPON_1ST + 1, mode);
				break;

			case MELEE_TYPE_SPECIAL_1ST:
			case MELEE_TYPE_SPECIAL_2ND:
			case MELEE_TYPE_SPECIAL_3RD:
			case MELEE_TYPE_SPECIAL_4TH:
				special_melee(attacker_ptr, target_ptr, i - MELEE_TYPE_SPECIAL_1ST, &fear, &dead);
				break;

			case MELEE_TYPE_BARE_HAND:
				break;

			case MELEE_TYPE_STAMP:
				break;

			case MELEE_TYPE_HORNS:
				natural_attack(attacker_ptr, target_ptr, CF_HORNS, &fear, &dead);
				break;

			case MELEE_TYPE_BEAK:
				natural_attack(attacker_ptr, target_ptr, CF_BEAK, &fear, &dead);
				break;

			case MELEE_TYPE_SCOR_TAIL:
				natural_attack(attacker_ptr, target_ptr, CF_SCOR_TAIL, &fear, &dead);
				break;

			case MELEE_TYPE_TRUNK:
				natural_attack(attacker_ptr, target_ptr, CF_TRUNK, &fear, &dead);
				break;

			case MELEE_TYPE_TENTACLES:
				natural_attack(attacker_ptr, target_ptr, CF_TENTACLES, &fear, &dead);
				break;

		}

		tried_num++;
		action_power -= action_cost[i];

	} while(tried_num < 10 && !dead);

	if(!tried_num)
	{
#ifdef JP
		msg_format("%sUłȂB", (!empty_hands(attacker_ptr, FALSE)) ? "肪ӂ" : "");
#else
		msg_print("You cannot do attacking.");
#endif
		return FALSE;
	}

	/* Hack -- delay fear messages */
	if (fear && target_ptr->ml && !dead)
	{
		/* Sound */
		sound(SOUND_FLEE);

		/* Message */
#ifdef JP
		msg_format("%^s͋|ēoI", target_name);
#else
		msg_format("%^s flees in terror!", target_name);
#endif
	}

	if ((attacker_ptr->special_defense & KATA_IAI) && ((mode != HISSATSU_IAI) || dead))
	{
		set_action(attacker_ptr, ACTION_NONE);
	}

	return dead;
}




/*
 * Critical blow.  All hits that do 95% of total possible damage,
 * and which also do at least 20 damage, or, sometimes, N damage.
 * This is used only to determine "cuts" and "stuns".
 */
static int creature_critical(int dice, int sides, int dam)
{
	int max = 0;
	int total = dice * sides;

	/* Must do at least 95% of perfect */
	if (dam < total * 19 / 20) return (0);

	/* Weak blows rarely work */
	if ((dam < 20) && (randint0(100) >= dam)) return (0);

	/* Perfect damage */
	if ((dam >= total) && (dam >= 40)) max++;

	/* Super-charge */
	if (dam >= 20)
	{
		while (randint0(100) < 2) max++;
	}

	/* Critical damage */
	if (dam > 45) return (6 + max);
	if (dam > 33) return (5 + max);
	if (dam > 25) return (4 + max);
	if (dam > 18) return (3 + max);
	if (dam > 11) return (2 + max);
	return (1 + max);
}





/*
 * Determine if a creature attack against the player succeeds.
 * Always miss 5% of the time, Always hit 5% of the time.
 * Otherwise, match creature power against player armor.
 */
static int check_hit(creature_type *target_ptr, int power, int level, int stun)
{
	int i, k, ac;

	/* Percentile dice */
	k = randint0(100);

	if (stun && one_in_(2)) return FALSE;

	/* Hack -- Always miss or hit */
	if (k < 10) return (k < 5);

	/* Calculate the "attack quality" */
	i = (power + (level * 3));

	/* Total armor */
	ac = target_ptr->ac + target_ptr->to_ac;
	if (target_ptr->special_attack & ATTACK_SUIKEN) ac += (target_ptr->lev * 2);

	/* Power and Level compete against Armor */
	if ((i > 0) && (randint1(i) > ((ac * 3) / 4))) return (TRUE);

	/* Assume miss */
	return (FALSE);
}



/*
 * Hack -- possible "insult" messages
 */
static cptr desc_insult[] =
{
#ifdef JP
	"Ȃ𕎐JI",
	"Ȃ̕𕎐JI",
	"ȂŷI",
	"ȂJ߂I",
	"ȂI",
	"Ȃ̉ŗxI",
	"ȐgԂI",
	"ȂڂƌIII",
	"ȂpTCgĂ΂肵I",
	"ȂTC{[OI"
#else
	"insults you!",
	"insults your mother!",
	"gives you the finger!",
	"humiliates you!",
	"defiles you!",
	"dances around you!",
	"makes obscene gestures!",
	"moons you!!!"
	"calls you a parasite!",
	"calls you a cyborg!"
#endif

};



/*
 * Hack -- possible "insult" messages
 */
static cptr desc_moan[] =
{
#ifdef JP
	"͉߂ł悤B",
	"ނ̎ȂƐq˂ĂB",
	"꒣肩očsƌĂB",
	"̓LmRǂƂꂢĂB"
#else
	"seems sad about something.",
	"asks if you have seen his dogs.",
	"tells you to get off his land.",
	"mumbles something about mushrooms."
#endif

};


/*
 * Attack the player via physical attacks.
 */
bool special_melee(creature_type *attacker_ptr, creature_type *target_ptr, int ap_cnt, bool *fear, bool *dead)
{

	species_type *r_ptr = &species_info[attacker_ptr->species_idx];
	floor_type *floor_ptr = &floor_list[attacker_ptr->floor_id];

	int i, k, tmp, ac, rlev;
	int do_cut, do_stun;

	s32b gold;

	object_type *o_ptr;

	char o_name[MAX_NLEN];

	char attacker_name[100];
	char target_name[100];

	char ddesc[80];

	bool blinked;
	bool touched = FALSE;
	bool explode = FALSE;
	bool do_silly_attack = (one_in_(2) && target_ptr->image);
	int get_damage = 0;

	bool obvious = FALSE;
	int power = 0;
	int damage = 0;

	cptr act = NULL;

	/* Extract the attack infomation */
	int effect = attacker_ptr->blow[ap_cnt].effect;
	int method = attacker_ptr->blow[ap_cnt].method;
	int d_dice = attacker_ptr->blow[ap_cnt].d_dice;
	int d_side = attacker_ptr->blow[ap_cnt].d_side;

#ifdef JP
	int abbreviate = 0;
#endif

	/* Not allowed to attack */
	if (has_cf_creature(attacker_ptr, CF_NEVER_BLOW)) return (FALSE);

	if (dungeon_info[floor_ptr->dun_type].flags1 & DF1_NO_MELEE) return (FALSE);

	/* ...nor if friendly */
	if (!is_hostile(attacker_ptr)) return FALSE;

	/* Extract the effective creature level */
	rlev = ((r_ptr->level >= 1) ? r_ptr->level : 1);


	/* Get the creature name (or "it") */
	creature_desc(attacker_name, attacker_ptr, 0);
	creature_desc(target_name, target_ptr, 0);

	/* Get the "died from" information (i.e. "a kobold") */
	creature_desc(ddesc, attacker_ptr, MD_IGNORE_HALLU | MD_ASSUME_VISIBLE | MD_INDEF_VISIBLE);

	/* Assume no blink */
	blinked = FALSE;


	/* Hack -- no more attacks */
	if (!method) return FALSE;

	if (is_pet(player_ptr, attacker_ptr) && (is_unique_species(r_ptr)) && (method == RBM_EXPLODE))
	{
		method = RBM_HIT;
		d_dice /= 10;
	}

	/* Stop if player is dead or gone */
	if (!playing || IS_DEAD(target_ptr)) return FALSE;
	if (distance(target_ptr->fy, target_ptr->fx, attacker_ptr->fy, attacker_ptr->fx) > 1) return FALSE;

	/* Handle "leaving" */
	if (subject_change_floor) return FALSE;

	if (method == RBM_SHOOT) return FALSE;

	/* Extract the attack "power" */
	power = mbe_info[effect].power;

	/* Total armor */
	ac = target_ptr->ac + target_ptr->to_ac;

	/* Creature hits player */
	if (!effect || check_hit(target_ptr, power, rlev, attacker_ptr->stun))
	{
		/* Always disturbing */
		disturb(player_ptr, 1, 0);


		/* Hack -- Apply "protection from evil" */
		if ((target_ptr->protevil > 0) &&
			is_enemy_of_good_creature(target_ptr) &&
			(target_ptr->lev >= rlev) &&
			((randint0(100) + target_ptr->lev) > 50))
		{
			/* Remember the Evil-ness */
			//TODO if (is_original_ap_and_seen(target_ptr, attacker_ptr)) r_ptr->r_flags3 |= RF3_EVIL;

			/* Message */
#ifdef JP
			if (abbreviate)
				msg_format("ނB");
			else
				msg_format("%^s͌ނꂽB", attacker_name);
			abbreviate = 1;/*Qڈȍ~͏ȗ */
#else
			msg_format("%^s is repelled.", attacker_name);
#endif

			/* Hack -- Next attack */
			return FALSE;
		}


		/* Assume no cut or stun */
		do_cut = do_stun = 0;

		/* Describe the attack method */
		switch (method)
		{
		case RBM_HIT:
			{
#ifdef JP
				abbreviate = 0;
				act = "B";
#else
				if(is_player(attacker_ptr))
					act = "hit";
				else
					act = "hits";
#endif

				do_cut = do_stun = 1;
				touched = TRUE;
				sound(SOUND_HIT);
				break;
			}

		case RBM_TOUCH:
			{
#ifdef JP
				abbreviate = 1;
				act = "GꂽB";
#else
				if(is_player(attacker_ptr))
					act = "touch";
				else
					act = "touches";
#endif

				touched = TRUE;
				sound(SOUND_TOUCH);
				break;
			}

		case RBM_PUNCH:
			{
#ifdef JP
				abbreviate = 0;
				act = "p`B";
#else
				if(is_player(attacker_ptr))
					act = "punch";
				else
					act = "punches";
#endif

				touched = TRUE;
				do_stun = 1;
				sound(SOUND_HIT);
				break;
			}

		case RBM_KICK:
			{
#ifdef JP
				abbreviate = 0;
				act = "RB";
#else
				if(is_player(attacker_ptr))
					act = "kick";
				else
					act = "kicks";
#endif

				touched = TRUE;
				do_stun = 1;
				sound(SOUND_HIT);
				break;
			}

		case RBM_CLAW:
			{
#ifdef JP
				abbreviate = 0;
				act = "~B";
#else
				if(is_player(attacker_ptr))
					act = "claw";
				else
					act = "claws";
#endif

				touched = TRUE;
				do_cut = 1;
				sound(SOUND_CLAW);
				break;
			}

		case RBM_BITE:
			{
#ifdef JP
				abbreviate = 0;
				act = "񂾁B";
#else
				if(is_player(attacker_ptr))
					act = "bite";
				else
					act = "bites";
#endif

				do_cut = 1;
				touched = TRUE;
				sound(SOUND_BITE);
				break;
			}

		case RBM_STING:
			{
#ifdef JP
				abbreviate = 0;
				act = "hB";
#else
				if(is_player(attacker_ptr))
					act = "sting";
				else
					act = "stings";
#endif

				touched = TRUE;
				sound(SOUND_STING);
				break;
			}

		case RBM_SLASH:
			{
#ifdef JP
				abbreviate = 0;
				act = "aB";
#else
				if(is_player(attacker_ptr))
					act = "slash";
				else
					act = "slashes";
#endif

				touched = TRUE;
				do_cut = 1;
				sound(SOUND_CLAW);
				break;
			}

		case RBM_BUTT:
			{
#ifdef JP
				abbreviate = 0;
				act = "pœ˂B";
#else
				if(is_player(attacker_ptr))
					act = "butt";
				else
					act = "butts";
#endif

				do_stun = 1;
				touched = TRUE;
				sound(SOUND_HIT);
				break;
			}

		case RBM_CRUSH:
			{
#ifdef JP
				abbreviate = 1;
				act = "̓肵B";
#else
				if(is_player(attacker_ptr))
					act = "crush";
				else
					act = "crushes";
#endif

				do_stun = 1;
				touched = TRUE;
				sound(SOUND_CRUSH);
				break;
			}

		case RBM_ENGULF:
			{
#ifdef JP
				abbreviate = 0;
				act = "ݍ񂾁B";
#else
				if(is_player(attacker_ptr))
					act = "engulf";
				else
					act = "engulfs";
#endif

				touched = TRUE;
				sound(SOUND_CRUSH);
				break;
			}

		case RBM_CHARGE:
			{
#ifdef JP
				abbreviate = 1;
				act = "悱B";
#else
				if(is_player(attacker_ptr))
					act = "charge";
				else
					act = "charges";
#endif

				touched = TRUE;
				sound(SOUND_BUY); /* Note! This is "charges", not "charges at". */
				break;
			}

		case RBM_CRAWL:
			{
#ifdef JP
				abbreviate = 2;
				act = "̂̏𔇂B";
#else
				if(is_player(attacker_ptr))
					act = "crawl on";
				else
					act = "crawls on";
#endif

				touched = TRUE;
				sound(SOUND_SLIME);
				break;
			}

		case RBM_DROOL:
			{
#ifdef JP
				abbreviate = 1;
				act = "悾炵B";
#else
				if(is_player(attacker_ptr))
					act = "drool on";
				else
					act = "drools on";
#endif

				sound(SOUND_SLIME);
				break;
			}

		case RBM_SPIT:
			{
#ifdef JP
				abbreviate = 3;
				act = "fB";
#else
				if(is_player(attacker_ptr))
					act = "spit on";
				else
					act = "spits on";
#endif

				sound(SOUND_SLIME);
				break;
			}

		case RBM_EXPLODE:
			{
#ifdef JP
				abbreviate = 4;
				act = "͔B";
#else
				if(is_player(attacker_ptr))
					act = "explode";
				else
					act = "explodes";
#endif

				explode = TRUE;
				break;
			}

		case RBM_GAZE:
			{
#ifdef JP
				abbreviate = 0;
				act = "ɂ񂾁B";
#else
				if(is_player(attacker_ptr))
					act = "gaze at";
				else
					act = "gazes at";
#endif

				break;
			}

		case RBM_WAIL:
			{
#ifdef JP
				abbreviate = 3;
				act = "񂾁B";
#else
				if(is_player(attacker_ptr))
					act = "wail at";
				else
					act = "wails at";
#endif

				sound(SOUND_WAIL);
				break;
			}

		case RBM_SPORE:
			{
#ifdef JP
				abbreviate = 3;
				act = "Eq΂B";
#else
				if(is_player(attacker_ptr))
					act = "release spores at";
				else
					act = "releases spores at";
#endif

				sound(SOUND_SLIME);
				break;
			}

		case RBM_XXX4:
			{
#ifdef JP
				abbreviate = 3;
				act = "XXX4 𔭎˂B";
#else
				if(is_player(attacker_ptr))
					act = "project XXX4's at";
				else
					act = "projects XXX4's at";
#endif

				break;
			}

		case RBM_BEG:
			{
#ifdef JP
				abbreviate = 1;
				act = "񂾁B";
#else
				if(is_player(attacker_ptr))
					act = "beg";
				else
					act = "begs";
#endif

				sound(SOUND_MOAN);
				break;
			}

		case RBM_INSULT:
			{
#ifdef JP
				abbreviate = 2;
#endif
				act = desc_insult[randint0(attacker_ptr->species_idx == MON_DEBBY ? 10 : 8)];
				sound(SOUND_MOAN);
				break;
			}

		case RBM_MOAN:
			{
#ifdef JP
				abbreviate = 2;
#endif
				act = desc_moan[randint0(4)];
				sound(SOUND_MOAN);
				break;
			}

		case RBM_SHOW:
			{
#ifdef JP
				abbreviate = 4;
#endif
				if (attacker_ptr->species_idx == MON_JAIAN)
				{
#ifdef JP
					switch(randint1(15))
					{
					case 1:
					case 6:
					case 11:
						act = "u􂨁`̓WCA``K`L傤`v";
						break;
					case 2:
						act = "uā`񂩂ށ`Ă̂`Ƃ``v";
						break;
					case 3:
						act = "ú`ёXlv̓Ȃ``v";
						break;
					case 4:
						act = "u􂯁`񂩃X|`c`ǂƂ`v";
						break;
					case 5:
						act = "u􂤂````܂`܂Ƃ`v";
						break;
					case 7:
						act = "u܁`΁`̂Ɂ`񂫂́``v";
						break;
					case 8:
						act = "uׂ񂫂傤キȂ``v";
						break;
					case 9:
						act = "u􂫂͂₳`ā```v";
						break;
					case 10:
						act = "u􂩂```X^C`ocO`v";
						break;
					case 12:
						act = "u􂪂`́``΂ڂ``v";
						break;
					case 13:
						act = "uh`h~Ȃ``v";
						break;
					case 14:
						act = "u悶ۂƁ`ȁ`ā`v";
						break;
					case 15:
						act = "u􂠂`́``Ȃ`́`܂Ȃ`v";
						break;
					}
#else
					act = "horribly sings 'I AM GIAAAAAN. THE BOOOSS OF THE KIIIIDS.'";
#endif
				}
				else
				{
					if (one_in_(3))
#ifdef JP
						act = "́l͊yƑƉ̂ĂB";
					else
						act = "́AC u [A[ u ~[Ɖ̂ĂB";
#else
						act = "sings 'We are a happy family.'";
					else
						act = "sings 'I love you, you love me.'";
#endif
				}

				sound(SOUND_SHOW);
				break;
			}
		}

		/* Message */
		if (act)
		{
			if (do_silly_attack)
			{
#ifdef JP
				abbreviate = -1;
#endif
				act = silly_attacks[randint0(MAX_SILLY_ATTACK)];
			}
#ifdef JP
			if (abbreviate == 0)
				msg_format("%^s%s%s", attacker_name, target_name, act);
			else if (abbreviate == 1)
				msg_format("%^s%s%s", attacker_name, target_name, act);
			else if (abbreviate == 2)
				msg_format("%^s%s%s", attacker_name, target_name, act);
			else if (abbreviate == 3)
				msg_format("%^s%sɌ%s", attacker_name, target_name, act);
			else if (abbreviate == 4)
				msg_format("%^s%s", attacker_name, act);
			else /* if (abbreviate == -1) */
				msg_format("%s", act);
			abbreviate = -1;/*Qڈȍ~͏ȗ */
#else
			msg_format("%^s %s %s", attacker_name, act, do_silly_attack ? target_name : "");
#endif
		}

		/* Hack -- assume all attacks are obvious */
		obvious = TRUE;

		/* Roll out the damage */
		damage = diceroll(d_dice, d_side);

		/*
		* Skip the effect when exploding, since the explosion
		* already causes the effect.
		*/
		if (explode)
			damage = 0;
		/* Apply appropriate damage */
		switch (effect)
		{
		case 0:
			{
				/* Hack -- Assume obvious */
				obvious = TRUE;

				/* Hack -- No damage */
				damage = 0;

				break;
			}

		case RBE_SUPERHURT:
			{
				if (((randint1(rlev*2+300) > (ac+200)) || one_in_(13)) && !(target_ptr->multishadow && (turn & 1)))
				{
					int tmp_damage = damage - (damage * ((ac < 150) ? ac : 150) / 250);
#ifdef JP
					msg_print("NeBJqbgI");
#else
					msg_print("It was a critical hit!");
#endif

					tmp_damage = MAX(damage, tmp_damage*2);

					/* Take damage */
					get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, tmp_damage, ddesc, NULL, -1);
					break;
				}
			}
		case RBE_HURT:
			{
				/* Obvious */
				obvious = TRUE;

				/* Hack -- Player armor reduces total damage */
				damage -= (damage * ((ac < 150) ? ac : 150) / 250);

				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				break;
			}

		case RBE_POISON:
			{
				if (explode) break;

				/* Take "poison" effect */
				if (!(target_ptr->resist_pois || IS_OPPOSE_POIS(target_ptr)) && !(target_ptr->multishadow && (turn & 1)))
				{
					if (set_poisoned(target_ptr, target_ptr->poisoned + randint1(rlev) + 5))
					{
						obvious = TRUE;
					}
				}

				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_POIS);

				break;
			}

		case RBE_UN_BONUS:
			{
				if (explode) break;

				/* Allow complete resist */
				if (!target_ptr->resist_disen && !(target_ptr->multishadow && (turn & 1)))
				{
					/* Apply disenchantment */
					if (apply_disenchant(target_ptr, 0))
					{
						/* Hack -- Update AC */
						update_creature(target_ptr, TRUE);
						obvious = TRUE;
					}
				}

				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_DISEN);

				break;
			}

		case RBE_UN_POWER:
			{
				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Find an item */
				for (k = 0; k < 10; k++)
				{
					/* Pick an item */
					i = randint0(INVEN_TOTAL);

					/* Obtain the item */
					o_ptr = &target_ptr->inventory[i];

					/* Skip non-objects */
					if (!o_ptr->k_idx) continue;

					/* Drain charged wands/staffs */
					if (((o_ptr->tval == TV_STAFF) ||
						(o_ptr->tval == TV_WAND)) &&
						(o_ptr->pval))
					{
						/* Calculate healed hitpoints */
						int heal=rlev * o_ptr->pval;
						if( o_ptr->tval == TV_STAFF)
							heal *=  o_ptr->number;

						/* Don't heal more than max hp */
						heal = MIN(heal, attacker_ptr->mhp - attacker_ptr->chp);

						/* Message */
#ifdef JP
						msg_print("GlM[zI");
#else
						msg_print("Energy drains from your magic device!");
#endif


						/* Obvious */
						obvious = TRUE;

						/* Heal the creature */
						attacker_ptr->chp += heal;

						/* Redraw (later) if needed */
						//TODO if (&magic_info[health_who] == attacker_ptr) play_redraw |= (PR_HEALTH);
						//if (&magic_info[target_ptr->riding] == attacker_ptr) play_redraw |= (PR_UHEALTH);

						/* Uncharge */
						o_ptr->pval = 0;

						/* Combine / Reorder the pack */
						target_ptr->creature_update |= (CRU_COMBINE | CRU_REORDER);

						/* Window stuff */
						play_window |= (PW_INVEN);

						/* Done */
						break;
					}
				}

				break;
			}

		case RBE_EAT_GOLD:
			{
				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				/* Confused creatures cannot steal successfully. -LM-*/
				if (attacker_ptr->confused) break;

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Obvious */
				obvious = TRUE;

				/* Saving throw (unless paralyzed) based on dex and level */
				if (!target_ptr->paralyzed &&
					(randint0(100) < (adj_dex_safe[target_ptr->stat_ind[STAT_DEX]] +
					target_ptr->lev)))
				{
					/* Saving throw message */
#ifdef JP
					msg_print("fzI");
#else
					msg_print("You quickly protect your money pouch!");
#endif


					/* Occasional blink anyway */
					if (randint0(3)) blinked = TRUE;
				}

				/* Eat gold */
				else
				{
					gold = (target_ptr->au / 10) + randint1(25);
					if (gold < 2) gold = 2;
					if (gold > 5000) gold = (target_ptr->au / 20) + randint1(3000);
					if (gold > target_ptr->au) gold = target_ptr->au;
					target_ptr->au -= gold;
					if (gold <= 0)
					{
#ifdef JP
						msg_print("܂ȂB");
#else
						msg_print("Nothing was stolen.");
#endif

					}
					else if (target_ptr->au)
					{
#ifdef JP
						msg_print("zyȂCB");
						msg_format("$%ld ̂܂ꂽI", (long)gold);
#else
						msg_print("Your purse feels lighter.");
						msg_format("%ld coins were stolen!", (long)gold);
#endif
					}
					else
					{
#ifdef JP
						msg_print("zyȂCB");
						msg_print("S܂ꂽI");
#else
						msg_print("Your purse feels lighter.");
						msg_print("All of your coins were stolen!");
#endif
					}

					/* Redraw gold */
					play_redraw |= (PR_GOLD);

					/* Window stuff */
					play_window |= (PW_PLAYER);

					/* Blink away */
					blinked = TRUE;
				}

				break;
			}

		case RBE_EAT_ITEM:
			{
				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				/* Confused creatures cannot steal successfully. -LM-*/
				if (attacker_ptr->confused) break;

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Saving throw (unless paralyzed) based on dex and level */
				if (!target_ptr->paralyzed &&
					(randint0(100) < (adj_dex_safe[target_ptr->stat_ind[STAT_DEX]] +
					target_ptr->lev)))
				{
					/* Saving throw message */
#ifdef JP
					msg_print("ĂăUbNԂI");
#else
					msg_print("You grab hold of your backpack!");
#endif


					/* Occasional "blink" anyway */
					blinked = TRUE;

					/* Obvious */
					obvious = TRUE;

					/* Done */
					break;
				}

				/* Find an item */
				for (k = 0; k < 10; k++)
				{
					s16b object_idx;

					/* Pick an item */
					i = randint0(INVEN_TOTAL);

					/* Obtain the item */
					o_ptr = &target_ptr->inventory[i];

					/* Skip non-objects */
					if (!o_ptr->k_idx) continue;

					/* Skip artifacts */
					if (object_is_artifact(o_ptr)) continue;

					/* Get a description */
					object_desc(o_name, o_ptr, OD_OMIT_PREFIX);

					/* Message */
#ifdef JP
					msg_format("%s(%c)%s܂ꂽI",
						o_name, index_to_label(i),
						((o_ptr->number > 1) ? "" : ""));
#else
					msg_format("%sour %s (%c) was stolen!",
						((o_ptr->number > 1) ? "One of y" : "Y"),
						o_name, index_to_label(i));
#endif

					/* Make an object */
					object_idx = object_pop();

					/* Success */
					if (object_idx)
					{
						object_type *j_ptr;

						/* Get new object */
						j_ptr = &object_list[object_idx];

						/* Copy object */
						object_copy(j_ptr, o_ptr);

						/* Modify number */
						j_ptr->number = 1;

						/* Hack -- If a rod or wand, allocate total
						* maximum timeouts or charges between those
						* stolen and those missed. -LM-
						*/
						if ((o_ptr->tval == TV_ROD) || (o_ptr->tval == TV_WAND))
						{
							j_ptr->pval = o_ptr->pval / o_ptr->number;
							o_ptr->pval -= j_ptr->pval;
						}

						/* Forget mark */
						j_ptr->marked = OM_TOUCHED;

						/* Memorize creature */
						//TODO j_ptr->held_m_idx = m_idx;
					}

					/* Steal the items */
					inven_item_increase(target_ptr, i, -1);
					inven_item_optimize(target_ptr, i);

					/* Obvious */
					obvious = TRUE;

					/* Blink away */
					blinked = TRUE;

					/* Done */
					break;
				}

				break;
			}

		case RBE_EAT_FOOD:
			{
				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Steal some food */
				for (k = 0; k < 10; k++)
				{
					/* Pick an item from the pack */
					i = randint0(INVEN_TOTAL);

					/* Get the item */
					o_ptr = &target_ptr->inventory[i];

					/* Skip non-objects */
					if (!o_ptr->k_idx) continue;

					/* Skip non-food objects */
					if ((o_ptr->tval != TV_FOOD) && !((o_ptr->tval == TV_CORPSE) && (o_ptr->sval))) continue;

					/* Get a description */
					object_desc(o_name, o_ptr, (OD_OMIT_PREFIX | OD_NAME_ONLY));

					/* Message */
#ifdef JP
					msg_format("%s(%c)%sHׂĂ܂I",
						o_name, index_to_label(i),
						((o_ptr->number > 1) ? "" : ""));
#else
					msg_format("%sour %s (%c) was eaten!",
						((o_ptr->number > 1) ? "One of y" : "Y"),
						o_name, index_to_label(i));
#endif


					/* Steal the items */
					inven_item_increase(target_ptr, i, -1);
					inven_item_optimize(target_ptr, i);

					/* Obvious */
					obvious = TRUE;

					/* Done */
					break;
				}

				break;
			}

		case RBE_EAT_LITE:
			{
				/* Access the lite */
				o_ptr = get_equipped_slot_ptr(target_ptr, INVEN_SLOT_LITE, 1);

				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Drain fuel */
				if ((o_ptr->xtra4 > 0) && (!object_is_fixed_artifact(o_ptr)))
				{
					/* Reduce fuel */
					o_ptr->xtra4 -= (250 + (s16b)randint1(250));
					if (o_ptr->xtra4 < 1) o_ptr->xtra4 = 1;

					/* Notice */
					if (!target_ptr->blind)
					{
#ifdef JP
						msg_print("肪ÂȂĂ܂B");
#else
						msg_print("Your light dims.");
#endif

						obvious = TRUE;
					}

					/* Window stuff */
					play_window |= (PW_EQUIP);
				}

				break;
			}

		case RBE_ACID:
			{
				if (explode) break;
				/* Obvious */
				obvious = TRUE;

				/* Message */
#ifdef JP
				msg_print("_𗁂тꂽI");
#else
				msg_print("You are covered in acid!");
#endif


				/* Special damage */
				get_damage += acid_dam(target_ptr, damage, ddesc, -1);

				/* Hack -- Update AC */
				update_creature(target_ptr, TRUE);

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_ACID);

				break;
			}

		case RBE_ELEC:
			{
				if (explode) break;
				/* Obvious */
				obvious = TRUE;

				/* Message */
#ifdef JP
				msg_print("d𗁂тꂽI");
#else
				msg_print("You are struck by electricity!");
#endif


				/* Special damage */
				get_damage += elec_dam(target_ptr, damage, ddesc, -1);

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_ELEC);

				break;
			}

		case RBE_FIRE:
			{
				if (explode) break;
				/* Obvious */
				obvious = TRUE;

				/* Message */
#ifdef JP
				msg_print("Sgɕ܂ꂽI");
#else
				msg_print("You are enveloped in flames!");
#endif


				/* Special damage */
				get_damage += fire_dam(target_ptr, damage, ddesc, -1);

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_FIRE);

				break;
			}

		case RBE_COLD:
			{
				if (explode) break;
				/* Obvious */
				obvious = TRUE;

				/* Message */
#ifdef JP
				msg_print("SgCŕꂽI");
#else
				msg_print("You are covered with frost!");
#endif


				/* Special damage */
				get_damage += cold_dam(target_ptr, damage, ddesc, -1);

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_COLD);

				break;
			}

		case RBE_BLIND:
			{
				/* Take damage */
				get_damage += take_hit(NULL, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr)) break;

				/* Increase "blind" */
				if (!target_ptr->resist_blind && !(target_ptr->multishadow && (turn & 1)))
				{
					if (set_blind(target_ptr, target_ptr->blind + 10 + randint1(rlev)))
					{
#ifdef JP
						if (attacker_ptr->species_idx == MON_DIO) msg_print("uǂbǏ̖ڒׂ̓bIv");
#else
						/* nanka */
#endif
						obvious = TRUE;
					}
				}

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_BLIND);

				break;
			}

		case RBE_CONFUSE:
			{
				if (explode) break;
				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr)) break;

				/* Increase "confused" */
				if (!target_ptr->resist_conf && !(target_ptr->multishadow && (turn & 1)))
				{
					if (set_confused(target_ptr, target_ptr->confused + 3 + randint1(rlev)))
					{
						obvious = TRUE;
					}
				}

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_CONF);

				break;
			}

		case RBE_TERRIFY:
			{
				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr)) break;

				/* Increase "afraid" */
				if ((target_ptr->multishadow && (turn & 1)))
				{
					/* Do nothing */
				}
				else if (target_ptr->resist_fear)
				{
#ifdef JP
					msg_print("|ɐNȂI");
#else
					msg_print("You stand your ground!");
#endif

					obvious = TRUE;
				}
				else if (randint0(100 + r_ptr->level/2) < target_ptr->skill_rob)
				{
#ifdef JP
					msg_print("|ɐNȂI");
#else
					msg_print("You stand your ground!");
#endif

					obvious = TRUE;
				}
				else
				{
					if (set_afraid(target_ptr, target_ptr->afraid + 3 + randint1(rlev)))
					{
						obvious = TRUE;
					}
				}

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_FEAR);

				break;
			}

		case RBE_PARALYZE:
			{
				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr)) break;

				/* Increase "paralyzed" */
				if ((target_ptr->multishadow && (turn & 1)))
				{
					/* Do nothing */
				}
				else if (target_ptr->free_act)
				{
#ifdef JP
					msg_print("ʂȂI");
#else
					msg_print("You are unaffected!");
#endif

					obvious = TRUE;
				}
				else if (randint0(100 + r_ptr->level/2) < target_ptr->skill_rob)
				{
#ifdef JP
					msg_print("͂𒵂˕ԂI");
#else
					msg_print("You resist the effects!");
#endif

					obvious = TRUE;
				}
				else
				{
					if (!target_ptr->paralyzed)
					{
						if (set_paralyzed(target_ptr, 3 + randint1(rlev)))
						{
							obvious = TRUE;
						}
					}
				}

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_FREE);

				break;
			}

		case RBE_LOSE_STR:
			{
				/* Damage (physical) */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Damage (stat) */
				if (do_dec_stat(target_ptr, STAT_STR)) obvious = TRUE;

				break;
			}

		case RBE_LOSE_INT:
			{
				/* Damage (physical) */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Damage (stat) */
				if (do_dec_stat(target_ptr, STAT_INT)) obvious = TRUE;

				break;
			}

		case RBE_LOSE_WIS:
			{
				/* Damage (physical) */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Damage (stat) */
				if (do_dec_stat(target_ptr, STAT_WIS)) obvious = TRUE;

				break;
			}

		case RBE_LOSE_DEX:
			{
				/* Damage (physical) */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Damage (stat) */
				if (do_dec_stat(target_ptr, STAT_DEX)) obvious = TRUE;

				break;
			}

		case RBE_LOSE_CON:
			{
				/* Damage (physical) */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Damage (stat) */
				if (do_dec_stat(target_ptr, STAT_CON)) obvious = TRUE;

				break;
			}

		case RBE_LOSE_CHR:
			{
				/* Damage (physical) */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Damage (stat) */
				if (do_dec_stat(target_ptr, STAT_CHA)) obvious = TRUE;

				break;
			}

		case RBE_LOSE_ALL:
			{
				/* Damage (physical) */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Damage (stats) */
				if (do_dec_stat(target_ptr, STAT_STR)) obvious = TRUE;
				if (do_dec_stat(target_ptr, STAT_DEX)) obvious = TRUE;
				if (do_dec_stat(target_ptr, STAT_CON)) obvious = TRUE;
				if (do_dec_stat(target_ptr, STAT_INT)) obvious = TRUE;
				if (do_dec_stat(target_ptr, STAT_WIS)) obvious = TRUE;
				if (do_dec_stat(target_ptr, STAT_CHA)) obvious = TRUE;

				break;
			}

		case RBE_SHATTER:
			{
				/* Obvious */
				obvious = TRUE;

				/* Hack -- Reduce damage based on the player armor class */
				damage -= (damage * ((ac < 150) ? ac : 150) / 250);

				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				/* Radius 8 earthquake centered at the creature */
				if (damage > 23 || explode)
				{
					//TODO earthquake_aux(attacker_ptr->fy, attacker_ptr->fx, 8, m_idx);
				}

				break;
			}

		case RBE_EXP_10:
			{
				s32b d = diceroll(10, 6) + (target_ptr->exp / 100) * MON_DRAIN_LIFE;

				/* Obvious */
				obvious = TRUE;

				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				(void)drain_exp(target_ptr, d, d / 10, 95);
				break;
			}

		case RBE_EXP_20:
			{
				s32b d = diceroll(20, 6) + (target_ptr->exp / 100) * MON_DRAIN_LIFE;

				/* Obvious */
				obvious = TRUE;

				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				(void)drain_exp(target_ptr, d, d / 10, 90);
				break;
			}

		case RBE_EXP_40:
			{
				s32b d = diceroll(40, 6) + (target_ptr->exp / 100) * MON_DRAIN_LIFE;

				/* Obvious */
				obvious = TRUE;

				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				(void)drain_exp(target_ptr, d, d / 10, 75);
				break;
			}

		case RBE_EXP_80:
			{
				s32b d = diceroll(80, 6) + (target_ptr->exp / 100) * MON_DRAIN_LIFE;

				/* Obvious */
				obvious = TRUE;

				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				(void)drain_exp(target_ptr, d, d / 10, 50);
				break;
			}

		case RBE_DISEASE:
			{
				/* Take some damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				/* Take "poison" effect */
				if (!(target_ptr->resist_pois || IS_OPPOSE_POIS(target_ptr)))
				{
					if (set_poisoned(target_ptr, target_ptr->poisoned + randint1(rlev) + 5))
					{
						obvious = TRUE;
					}
				}

				/* Damage CON (10% chance)*/
				if ((randint1(100) < 11) && !has_cf_creature(target_ptr, CF_ANDROID))
				{
					/* 1% chance for perm. damage */
					bool perm = one_in_(10);
					if (dec_stat(target_ptr, STAT_CON, randint1(10), perm))
					{
#ifdef JP
						msg_print("aȂIłCB");
#else
						msg_print("You feel strange sickness.");
#endif

						obvious = TRUE;
					}
				}

				break;
			}
		case RBE_TIME:
			{
				if (explode) break;
				if (!target_ptr->resist_time && !(target_ptr->multishadow && (turn & 1)))
				{
					switch (randint1(10))
					{
					case 1: case 2: case 3: case 4: case 5:
						{
							if (has_cf_creature(target_ptr, CF_ANDROID)) break;
#ifdef JP
							msg_print("lt߂肵CB");
#else
							msg_print("You feel life has clocked back.");
#endif

							lose_exp(target_ptr, 100 + (target_ptr->exp / 100) * MON_DRAIN_LIFE);
							break;
						}

					case 6: case 7: case 8: case 9:
						{
							int stat = randint0(6);

							switch (stat)
							{
#ifdef JP
					case STAT_STR: act = ""; break;
					case STAT_INT: act = ""; break;
					case STAT_WIS: act = ""; break;
					case STAT_DEX: act = "p"; break;
					case STAT_CON: act = "N"; break;
					case STAT_CHA: act = ""; break;
#else
					case STAT_STR: act = "strong"; break;
					case STAT_INT: act = "bright"; break;
					case STAT_WIS: act = "wise"; break;
					case STAT_DEX: act = "agile"; break;
					case STAT_CON: act = "hale"; break;
					case STAT_CHA: act = "beautiful"; break;
#endif

							}

#ifdef JP
							msg_format("Ȃ͈ȑOق%sȂȂĂ܂...B", act);
#else
							msg_format("You're not as %s as you used to be...", act);
#endif


							target_ptr->stat_cur[stat] = (target_ptr->stat_cur[stat] * 3) / 4;
							if (target_ptr->stat_cur[stat] < 3) target_ptr->stat_cur[stat] = 3;
							target_ptr->creature_update |= (CRU_BONUS);
							break;
						}

					case 10:
						{
#ifdef JP
							msg_print("Ȃ͈ȑOقǗ͋ȂȂĂ܂...B");
#else
							msg_print("You're not as powerful as you used to be...");
#endif


							for (k = 0; k < 6; k++)
							{
								target_ptr->stat_cur[k] = (target_ptr->stat_cur[k] * 7) / 8;
								if (target_ptr->stat_cur[k] < 3) target_ptr->stat_cur[k] = 3;
							}
							target_ptr->creature_update |= (CRU_BONUS);
							break;
						}
					}
				}
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				break;
			}
		case RBE_EXP_VAMP:
			{
				s32b d = diceroll(60, 6) + (target_ptr->exp / 100) * MON_DRAIN_LIFE;
				bool resist_drain;

				/* Obvious */
				obvious = TRUE;

				/* Take damage */
				get_damage += take_hit(attacker_ptr, target_ptr, DAMAGE_ATTACK, damage, ddesc, NULL, -1);

				if (IS_DEAD(target_ptr) || (target_ptr->multishadow && (turn & 1))) break;

				resist_drain = !drain_exp(target_ptr, d, d / 10, 50);

				/* Heal the attacker? */
				if(has_cf_creature(target_ptr, CF_NONLIVING) || is_undead_creature(target_ptr) || is_demon_creature(target_ptr))
				{
					resist_drain = TRUE;
					break;
				}

				if ((damage > 5) && !resist_drain)
				{
					bool did_heal = FALSE;

					if (attacker_ptr->chp < attacker_ptr->mhp) did_heal = TRUE;

					/* Heal */
					attacker_ptr->chp += diceroll(4, damage / 6);
					if (attacker_ptr->chp > attacker_ptr->mhp) attacker_ptr->chp = attacker_ptr->mhp;

					/* Redraw (later) if needed */
					//TODO if (health_who == m_idx) play_redraw |= (PR_HEALTH);
					//TODO if (target_ptr->riding == m_idx) play_redraw |= (PR_UHEALTH);

					/* Special message */
					if (attacker_ptr->ml && did_heal)
					{
#ifdef JP
						msg_format("%s̗͑͂񕜂悤B", attacker_name);
#else
						msg_format("%^s appears healthier.", attacker_name);
#endif

					}
				}

				break;
			}
		case RBE_DR_MANA:
			{
				/* Obvious */
				obvious = TRUE;

				if ((target_ptr->multishadow && (turn & 1)))
				{
#ifdef JP
					msg_print("U͌eɖAȂɂ͓͂ȂB");
#else
					msg_print("The attack hits Shadow, you are unharmed!");
#endif
				}
				else
				{
					do_cut = 0;

					/* Take damage */
					target_ptr->csp -= damage;
					if (target_ptr->csp < 0)
					{
						target_ptr->csp = 0;
						target_ptr->csp_frac = 0;
					}

					play_redraw |= (PR_MANA);
				}

				/* Learn about the player */
				//TODO update_smart_learn(m_idx, DRS_MANA);

				break;
			}
		}

		/* Hack -- only one of cut or stun */
		if (do_cut && do_stun)
		{
			/* Cancel cut */
			if (randint0(100) < 50)
			{
				do_cut = 0;
			}

			/* Cancel stun */
			else
			{
				do_stun = 0;
			}
		}

		/* Handle cut */
		if (do_cut)
		{
			int k = 0;

			/* Critical hit (zero if non-critical) */
			tmp = creature_critical(d_dice, d_side, damage);

			/* Roll for damage */
			switch (tmp)
			{
			case 0: k = 0; break;
			case 1: k = randint1(5); break;
			case 2: k = randint1(5) + 5; break;
			case 3: k = randint1(20) + 20; break;
			case 4: k = randint1(50) + 50; break;
			case 5: k = randint1(100) + 100; break;
			case 6: k = 300; break;
			default: k = 500; break;
			}

			/* Apply the cut */
			if (k) (void)set_cut(target_ptr, target_ptr->cut + k);
		}

		/* Handle stun */
		if (do_stun)
		{
			int k = 0;

			/* Critical hit (zero if non-critical) */
			tmp = creature_critical(d_dice, d_side, damage);

			/* Roll for damage */
			switch (tmp)
			{
			case 0: k = 0; break;
			case 1: k = randint1(5); break;
			case 2: k = randint1(5) + 10; break;
			case 3: k = randint1(10) + 20; break;
			case 4: k = randint1(15) + 30; break;
			case 5: k = randint1(20) + 40; break;
			case 6: k = 80; break;
			default: k = 150; break;
			}

			/* Apply the stun */
			if (k) (void)set_stun(target_ptr, target_ptr->stun + k);
		}

		if (explode)
		{
			sound(SOUND_EXPLODE);

			take_hit(attacker_ptr, attacker_ptr, 0, attacker_ptr->chp + 1, NULL, NULL, -1);
			if(attacker_ptr->species_idx == 0)
			{
				blinked = FALSE;
				*dead = TRUE;
			}
		}

		if (touched)
		{
			if (target_ptr->sh_fire && !*dead && !IS_DEAD(target_ptr))
			{
				if (!has_cf_creature(attacker_ptr, CF_RES_SHAR))
				{
					int dam = diceroll(2, 6);

					/* Modify the damage */
					dam = invuln_damage_mod(attacker_ptr, dam, FALSE);

#ifdef JP
					msg_format("%^s͓ˑRMȂI", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, "͊D̎RɂȂB", -1);
#else
					msg_format("%^s is suddenly very hot!", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, " turns into a pile of ash.", -1);
#endif
					if(attacker_ptr->species_idx == 0)
					{
						blinked = FALSE;
						*dead = TRUE;
					}
				}
				else
				{
					//if (is_original_ap_and_seen(target_ptr, attacker_ptr))
					//TODO 	r_ptr->r_flags10 |= (r_ptr->flags10 & RF10_EFF_IM_FIRE_MASK);
				}
			}

			if (target_ptr->sh_elec && !*dead && !IS_DEAD(target_ptr))
			{
				if (!has_cf_creature(attacker_ptr, CF_RES_ELEC))
				{
					int dam = diceroll(2, 6);

					/* Modify the damage */
					dam = invuln_damage_mod(attacker_ptr, dam, FALSE);

#ifdef JP
					msg_format("%^s͓dI", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, "͔Rk̎RɂȂB", -1);
#else
					msg_format("%^s gets zapped!", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, " turns into a pile of cinder.", -1);
#endif
					if(attacker_ptr->species_idx == 0)
					{
						blinked = FALSE;
						*dead = TRUE;
					}
				}
				else
				{
					//TODO if (is_original_ap_and_seen(target_ptr, attacker_ptr))
					//TODO r_ptr->r_flags10 |= (r_ptr->flags10 & RF10_EFF_IM_ELEC_MASK);
				}
			}

			if (target_ptr->sh_cold && !*dead && !IS_DEAD(target_ptr))
			{
				if (!has_cf_creature(attacker_ptr, CF_RES_COLD))
				{
					int dam = diceroll(2, 6);

					/* Modify the damage */
					dam = invuln_damage_mod(attacker_ptr, dam, FALSE);

#ifdef JP
					msg_format("%^s͗CI", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, "͓B", -1);
#else
					msg_format("%^s is very cold!", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, " was frozen.", -1);
#endif
					if(attacker_ptr->species_idx == 0)
					{
						blinked = FALSE;
						*dead = TRUE;
					}
				}
				else
				{
					//TODO if (is_original_ap_and_seen(target_ptr, attacker_ptr))
					//TODO r_ptr->r_flags10 |= (r_ptr->flags10 & RF10_EFF_IM_COLD_MASK);
				}
			}

			/* by henkma */
			if (target_ptr->dustrobe && !*dead && !IS_DEAD(target_ptr))
			{
				if (!has_cf_creature(attacker_ptr, CF_RES_SHAR))
				{
					int dam = diceroll(2, 6);

					/* Modify the damage */
					dam = invuln_damage_mod(attacker_ptr, dam, FALSE);

#ifdef JP
					msg_format("%^s͋̔jЂI", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, "̓Y^Y^ɂȂB", -1);
#else
					msg_format("%^s gets zapped!", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, " had torn to pieces.", -1);
#endif
					if(attacker_ptr->species_idx == 0)
					{
						blinked = FALSE;
						*dead = TRUE;
					}
				}
				else
				{
					//if (is_original_ap_and_seen(target_ptr, attacker_ptr))
					//TODO r_ptr->r_flags10 |= (r_ptr->flags10 & RF10_EFF_RES_SHAR_MASK);
				}

				if (is_mirror_grid(&floor_ptr->cave[target_ptr->fy][target_ptr->fx]))
				{
					teleport_player(target_ptr, 10, 0L);
				}
			}

			if (target_ptr->tim_sh_holy && !*dead && !IS_DEAD(target_ptr))
			{
				if (is_enemy_of_good_creature(target_ptr))
				{
					if (!(attacker_ptr->resist_ultimate))
					{
						int dam = diceroll(2, 6);

						/* Modify the damage */
						dam = invuln_damage_mod(attacker_ptr, dam, FALSE);

#ifdef JP
						msg_format("%^s͐ȂI[ŏI", attacker_name);
						take_hit(target_ptr, attacker_ptr, 0, dam, NULL, "͓|ꂽB", -1);
#else
						msg_format("%^s is injured by holy power!", attacker_name);
						take_hit(target_ptr, attacker_ptr, 0, dam, NULL, " is destroyed.", -1);
#endif
						if(attacker_ptr->species_idx == 0)
						{
							blinked = FALSE;
							*dead = TRUE;
						}
						if(is_original_ap_and_seen(player_ptr, target_ptr)) reveal_creature_info(target_ptr, INFO_TYPE_ALIGNMENT);
					}
					else
					{
						if(is_original_ap_and_seen(player_ptr, target_ptr)) reveal_creature_info(target_ptr, CF_RES_ALL);
					}
				}
			}

			if (target_ptr->tim_sh_touki && !*dead && !IS_DEAD(target_ptr))
			{
				if (!(attacker_ptr->resist_ultimate))
				{
					int dam = diceroll(2, 6);

					/* Modify the damage */
					dam = invuln_damage_mod(attacker_ptr, dam, FALSE);

#ifdef JP
					msg_format("%^ssC̃I[ŏI", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, "͓|ꂽB", -1);
#else
					msg_format("%^s is injured by the Force", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, " is destroyed.", -1);
#endif
					if(attacker_ptr->species_idx == 0)
					{
						blinked = FALSE;
						*dead = TRUE;
					}
				}
				else
				{
					if(is_original_ap_and_seen(player_ptr, target_ptr)) reveal_creature_info(target_ptr, CF_RES_ALL);
				}
			}

			if (hex_spelling(target_ptr, HEX_SHADOW_CLOAK) && !*dead && !IS_DEAD(target_ptr))
			{
				int dam = 1;
				object_type *o_ptr = get_equipped_slot_ptr(target_ptr, INVEN_SLOT_HAND, 1);

				if (!has_cf_creature(attacker_ptr, CF_RES_DARK))
				{
					if (o_ptr->k_idx)
					{
						int basedam = ((o_ptr->dd + target_ptr->to_damaged[0]) * (o_ptr->ds + target_ptr->to_damages[0] + 1));
						dam = basedam / 2 + o_ptr->to_damage + target_ptr->to_damage[0];
					}

					/* Cursed armor makes damages doubled */
					o_ptr = get_equipped_slot_ptr(target_ptr, INVEN_SLOT_BODY, 1);
					if ((o_ptr->k_idx) && object_is_cursed(o_ptr)) dam *= 2;

					/* Modify the damage */
					dam = invuln_damage_mod(attacker_ptr, dam, FALSE);

#ifdef JP
					msg_format("ẽI[%^sɔI", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, "͓|ꂽB", -1);
#else
					msg_format("Enveloped shadows attack %^s.", attacker_name);
					take_hit(target_ptr, attacker_ptr, 0, dam, NULL, " is destroyed.", -1);
#endif
					if(attacker_ptr->species_idx == 0)
					{
						blinked = FALSE;
						*dead = TRUE;
					}
					/* TODO
					else // creature does not dead
					{
					int j;
					int flg = PROJECT_STOP | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL;
					int typ[4][2] = {
					{ INVEN_SLOT_HEAD, GF_OLD_CONF },
					{ INVEN_SLOT_HAND,  GF_OLD_SLEEP },
					{ INVEN_SLOT_ARM, GF_TURN_ALL },
					{ INVEN_SLOT_FEET, GF_OLD_SLOW }
					};

					// Some cursed armours gives an extra effect
					for (j = 0; j < 4; j++)
					{
					o_ptr = &target_ptr->inventory[typ[j][0]];
					if ((o_ptr->k_idx) && object_is_cursed(o_ptr) && object_is_armour(o_ptr))
					project(attacker_ptr, 0, attacker_ptr->fy, attacker_ptr->fx, (target_ptr->lev * 2), typ[j][1], flg, -1);
					}
					}
					*/
				}
				else
				{
					if(is_original_ap_and_seen(player_ptr, target_ptr))
					{
						reveal_creature_info(target_ptr, CF_RES_ALL);
						reveal_creature_info(target_ptr, CF_RES_DARK);
					}
				}
			}
		}
	}

	/* Creature missed player */
	else
	{
		/* Analyze failed attacks */
		switch (method)
		{
		case RBM_HIT:
		case RBM_TOUCH:
		case RBM_PUNCH:
		case RBM_KICK:
		case RBM_CLAW:
		case RBM_BITE:
		case RBM_STING:
		case RBM_SLASH:
		case RBM_BUTT:
		case RBM_CRUSH:
		case RBM_ENGULF:
		case RBM_CHARGE:

			/* Visible creatures */
			if (attacker_ptr->ml)
			{
				/* Disturbing */
				disturb(player_ptr, 1, 0);

				/* Message */
#ifdef JP
				if (abbreviate)
					msg_format("%s킵B", (target_ptr->special_attack & ATTACK_SUIKEN) ? "ȓ" : "");
				else
					msg_format("%s%^s̍U킵B", (target_ptr->special_attack & ATTACK_SUIKEN) ? "ȓ" : "", attacker_name);
				abbreviate = 1;/*Qڈȍ~͏ȗ */
#else
				msg_format("%^s misses you.", attacker_name);
#endif

			}
			damage = 0;

			break;
		}
	}


	/* Analyze "visible" creatures only */
	if (is_original_ap_and_seen(target_ptr, attacker_ptr) && !do_silly_attack)
	{
		/* Count "obvious" attacks (and ones that cause damage) */
		if (obvious || damage || (r_ptr->r_blows[ap_cnt] > 10))
		{
			/* Count attacks of this type */
			if (r_ptr->r_blows[ap_cnt] < MAX_UCHAR)
			{
				r_ptr->r_blows[ap_cnt]++;
			}
		}
	}

	if (target_ptr->riding && damage)
	{
		char attacker_name[80];
		creature_desc(attacker_name, &creature_list[target_ptr->riding], 0);
		if (rakuba(target_ptr, (damage > 200) ? 200 : damage, FALSE))
		{
#ifdef JP
			msg_format("%^s痎Ă܂I", attacker_name);
#else
			msg_format("You have fallen from %s.", attacker_name);
#endif
		}
	}

	if (target_ptr->special_defense & NINJA_KAWARIMI)
	{
		if (kawarimi(target_ptr, FALSE)) return TRUE;
	}

	/* Hex - revenge damage stored */
	revenge_store(target_ptr, get_damage);

	if ((target_ptr->tim_eyeeye || hex_spelling(target_ptr, HEX_EYE_FOR_EYE))
		&& get_damage > 0 && !IS_DEAD(target_ptr))
	{
#ifdef JP
		msg_format("U%sgI", attacker_name);
#else
		char attacker_name_self[80];

		/* hisself */
		creature_desc(attacker_name_self, attacker_ptr, MD_PRON_VISIBLE | MD_POSSESSIVE | MD_OBJECTIVE);

		msg_format("The attack of %s has wounded %s!", attacker_name, attacker_name_self);
#endif
		project(attacker_ptr, 0, attacker_ptr->fy, attacker_ptr->fx, get_damage, GF_MISSILE, PROJECT_KILL, -1);
		if (target_ptr->tim_eyeeye) set_tim_eyeeye(target_ptr, target_ptr->tim_eyeeye-5, TRUE);
	}

	if ((target_ptr->counter || (target_ptr->special_defense & KATA_MUSOU)) && !*dead && !IS_DEAD(target_ptr) && attacker_ptr->ml && (target_ptr->csp > 7))
	{
		char attacker_name[80];
		creature_desc(attacker_name, attacker_ptr, 0);

		target_ptr->csp -= 7;
#ifdef JP
		msg_format("%^sɔI", attacker_name);
#else
		msg_format("Your counterattack to %s!", attacker_name);
#endif
		melee_attack(target_ptr, attacker_ptr->fy, attacker_ptr->fx, HISSATSU_COUNTER);
		fear = FALSE;

		/* Redraw mana */
		play_redraw |= (PR_MANA);
	}

	/* Blink away */
	if (blinked && !*dead && !IS_DEAD(target_ptr))
	{
		if (teleport_barrier(target_ptr, attacker_ptr))
		{
#ifdef JP
			msg_print("D_͏΂ē...悤ƂoAɖhꂽB");
#else
			msg_print("The thief flees laughing...? But magic barrier obstructs it.");
#endif
		}
		else
		{
#ifdef JP
			msg_print("D_͏΂ēI");
#else
			msg_print("The thief flees laughing!");
#endif
			//TODO teleport_away(m_idx, MAX_SIGHT * 2 + 5, 0L);
		}
	}


	/* Always notice cause of death */
	if (IS_DEAD(target_ptr) && (r_ptr->r_deaths < MAX_SHORT) && !fight_arena_mode)
	{
		r_ptr->r_deaths++;
	}

	if (target_ptr->special_defense & KATA_IAI)
	{
		set_action(target_ptr, ACTION_NONE);
	}

	/* Assume we attacked */
	return (TRUE);
}


static void tramping_attack(creature_type *atk_ptr, creature_type *tar_ptr, int y, int x, bool *fear, bool *mdeath, s16b hand, int mode)
{
	char attacker_name[100], target_name[100];

	floor_type      *floor_ptr = get_floor_ptr(atk_ptr);
	cave_type       *c_ptr = &floor_ptr->cave[y][x];
	species_type    *r_ptr = &species_info[tar_ptr->species_idx];

	if(!mdeath)
	{
		int prob = 100 * atk_ptr->skill_exp[SKILL_MARTIAL_ARTS] / WEAPON_EXP_MASTER;
		if(tar_ptr->levitation) prob /= 4;
		if(atk_ptr->size - tar_ptr->size < 10) prob /= 2;
		if(atk_ptr->size - tar_ptr->size < 5) prob /= 2;
		if(atk_ptr->size - tar_ptr->size < 3) prob /= 2;
		if(atk_ptr->size - tar_ptr->size < 1) prob /= 2;
		if(100 * tar_ptr->chp / tar_ptr->mhp < 50) prob = prob * 3 / 2; 
		if(100 * tar_ptr->chp / tar_ptr->mhp < 30) prob = prob * 3 / 2; 
		if(100 * tar_ptr->chp / tar_ptr->mhp < 10) prob = prob * 3 / 2; 
		if(prob > 95) prob = 95;

		if (atk_ptr->size > tar_ptr->size && randint0(100) < prob)
		{
			int k;
#ifdef JP
			msg_format("%s͎cɂ%s𓥂݂I", attacker_name, target_name);
#else
			msg_format("%s tranmpled %s cruelly!", attacker_name, target_name);
#endif
			k = diceroll(atk_ptr->size - tar_ptr->size, atk_ptr->size - tar_ptr->size);
			take_hit(atk_ptr, tar_ptr, 0, k, NULL , NULL, -1);
			if (wizard)
			{
				msg_format("DAM:%d HP:%d->%d", k, tar_ptr->chp, tar_ptr->chp - k);
			}
		}

	}

}
