/* File: mutation.c */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

/* Purpose: Mutation effects (and racial powers) */

#include "angband.h"


bool gain_random_mutation(creature_type *cr_ptr, int choose_mut, bool messsage)
{
	int     attempts_left = 20;
	cptr    muta_desc = "";
	bool    muta_chosen = FALSE;
	u32b    muta_which = 0;
	u32b    *muta_class = NULL;

	if (choose_mut) attempts_left = 1;

	while (attempts_left--)
	{
		switch (choose_mut ? choose_mut : (cr_ptr->cls_idx == CLASS_BERSERKER ? 74+randint1(119) : randint1(193)))
		{
		case 1: case 2: case 3: case 4:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SPIT_ACID;
#ifdef JP
muta_desc = "_f\͂𓾂B";
#else
			muta_desc = "You gain the ability to spit acid.";
#endif

			break;
		case 5: case 6: case 7:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BR_FIRE;
#ifdef JP
muta_desc = "΂f\͂𓾂B";
#else
			muta_desc = "You gain the ability to breathe fire.";
#endif

			break;
		case 8: case 9:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_HYPN_GAZE;
#ifdef JP
muta_desc = "Ö̔\͂𓾂B";
#else
			muta_desc = "Your eyes look mesmerizing...";
#endif

			break;
		case 10: case 11:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_TELEKINES;
#ifdef JP
muta_desc = "̂O͂œ\͂𓾂B";
#else
			muta_desc = "You gain the ability to move objects telekinetically.";
#endif

			break;
		case 12: case 13: case 14:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_VTELEPORT;
#ifdef JP
muta_desc = "̈ӎvŃe|[g\͂𓾂B";
#else
			muta_desc = "You gain the power of teleportation at will.";
#endif

			break;
		case 15: case 16:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_MIND_BLST;
#ifdef JP
muta_desc = "_U̔\͂𓾂B";
#else
			muta_desc = "You gain the power of Mind Blast.";
#endif

			break;
		case 17: case 18:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_RADIATION;
#ifdef JP
muta_desc = "Ȃ͋ː𔭐n߂B";
#else
			muta_desc = "You start emitting hard radiation.";
#endif

			break;
		case 19: case 20:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_VAMPIRISM;
#ifdef JP
muta_desc = "͂zł悤ɂȂB";
#else
			muta_desc = "You become vampiric.";
#endif

			break;
		case 21: case 22: case 23:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SMELL_MET;
#ifdef JP
muta_desc = "̓k悤ɂȂB";
#else
			muta_desc = "You smell a metallic odor.";
#endif

			break;
		case 24: case 25: case 26: case 27:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SMELL_MON;
#ifdef JP
muta_desc = "X^[̏Lk悤ɂȂB";
#else
			muta_desc = "You smell filthy monsters.";
#endif

			break;
		case 28: case 29: case 30:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BLINK;
#ifdef JP
muta_desc = "ߋe|[g̔\͂𓾂B";
#else
			muta_desc = "You gain the power of minor teleportation.";
#endif

			break;
		case 31: case 32:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_EAT_ROCK;
#ifdef JP
muta_desc = "ǂɌB";
#else
			muta_desc = "The walls look delicious.";
#endif

			break;
		case 33: case 34:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SWAP_POS;
#ifdef JP
muta_desc = "ľCň}C悤ȋCB";
#else
			muta_desc = "You feel like walking a mile in someone else's shoes.";
#endif

			break;
		case 35: case 36: case 37:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SHRIEK;
#ifdef JP
muta_desc = "Ȃ̐͑ȂB";
#else
			muta_desc = "Your vocal cords get much tougher.";
#endif

			break;
		case 38: case 39: case 40:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_ILLUMINE;
#ifdef JP
muta_desc = "Ȃ͌Pĕ𖾂邭悤ɂȂB";
#else
			muta_desc = "You can light up rooms with your presence.";
#endif

			break;
		case 41: case 42:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_DET_CURSE;
#ifdef JP
muta_desc = "׈Ȗ@mł悤ɂȂB";
#else
			muta_desc = "You can feel evil magics.";
#endif

			break;
		case 43: case 44: case 45:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BERSERK;
#ifdef JP
muta_desc = "ł錃B";
#else
			muta_desc = "You feel a controlled rage.";
#endif

			break;
		case 46:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_POLYMORPH;
#ifdef JP
muta_desc = "̂ψق₷ȂB";
#else
			muta_desc = "Your body seems mutable.";
#endif

			break;
		case 47: case 48:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_MIDAS_TCH;
#ifdef JP
muta_desc = "u~_X̎v̔\͂𓾂B";/*gD[C_[Xɂ܂ˁB */
#else
			muta_desc = "You gain the Midas touch.";
#endif

			break;
		case 49:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_GROW_MOLD;
#ifdef JP
muta_desc = "ˑRJrɐe݂oB";
#else
			muta_desc = "You feel a sudden affinity for mold.";
#endif

			break;
		case 50: case 51: case 52:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_RESIST;
#ifdef JP
muta_desc = "Ȃ͎gCB";
#else
			muta_desc = "You feel like you can protect yourself.";
#endif

			break;
		case 53: case 54: case 55:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_EARTHQUAKE;
#ifdef JP
muta_desc = "_Wj󂷂\͂𓾂B";
#else
			muta_desc = "You gain the ability to wreck the dungeon.";
#endif

			break;
		case 56:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_EAT_MAGIC;
#ifdef JP
muta_desc = "@̃ACeɌB";
#else
			muta_desc = "Your magic items look delicious.";
#endif

			break;
		case 57: case 58:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_WEIGH_MAG;
#ifdef JP
muta_desc = "Ȃ͎͂ɂ閂@ǂłCB";
#else
			muta_desc = "You feel you can better understand the magic around you.";
#endif

			break;
		case 59:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_STERILITY;
#ifdef JP
muta_desc = "̑SĂ̎҂ɓɂNƂłB";
#else
			muta_desc = "You can give everything around you a headache.";
#endif

			break;
		case 60: case 61:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_PANIC_HIT;
#ifdef JP
muta_desc = "ˑRAD_̋C悤ɂȂB";
#else
			muta_desc = "You suddenly understand how thieves feel.";
#endif

			break;
		case 62: case 63: case 64:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_DAZZLE;
#ifdef JP
muta_desc = "ῂM𔭂\͂𓾂B";
#else
			muta_desc = "You gain the ability to emit dazzling lights.";
#endif

			break;
		case 65: case 66: case 67:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_LASER_EYE;
#ifdef JP
muta_desc = "Ȃ̖ڂ͈uĂtB";
#else
			muta_desc = "Your eyes burn for a moment.";
#endif

			break;
		case 68: case 69:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_RECALL;
#ifdef JP
muta_desc = "z[VbNɂȂAB";
#else
			muta_desc = "You feel briefly homesick, but it passes.";
#endif

			break;
		case 70:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BANISH;
#ifdef JP
muta_desc = "_ȓ{̗͂ɖꂽB";
#else
			muta_desc = "You feel a holy wrath fill you.";
#endif

			break;
		case 71: case 72:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_COLD_TOUCH;
#ifdef JP
muta_desc = "Ȃ̗͂ƂĂ₽ȂB";
#else
			muta_desc = "Your hands get very cold.";
#endif

			break;
		case 73: case 74:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_LAUNCHER;
#ifdef JP
muta_desc = "Ȃ̕𓊂͂Ȃ苭ȂCB";
#else
			muta_desc = "Your throwing arm feels much stronger.";
#endif

			break;
		case 75:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_BERS_RAGE;
#ifdef JP
muta_desc = "Ȃ͋\̔N悤ɂȂI";
#else
			muta_desc = "You become subject to fits of berserk rage!";
#endif

			break;
		case 76:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_COWARDICE;
#ifdef JP
muta_desc = "MȂ炢aɂȂI";
#else
			muta_desc = "You become an incredible coward!";
#endif

			break;
		case 77:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_RTELEPORT;
#ifdef JP
muta_desc = "Ȃ̈ʒu͔ɕsmɂȂB";
#else
			muta_desc = "Your position seems very uncertain...";
#endif

			break;
		case 78:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ALCOHOL;
#ifdef JP
muta_desc = "Ȃ̓AR[𕪔傷悤ɂȂB";
#else
			muta_desc = "Your body starts producing alcohol!";
#endif

			break;
		case 79:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_HALLU;
#ifdef JP
muta_desc = "Ȃ͌oN_ɐNꂽB";
#else
			muta_desc = "You are afflicted by a hallucinatory insanity!";
#endif

			break;
		case 80:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_FLATULENT;
#ifdef JP
muta_desc = "Ȃ͐s\ȋț悤ɂȂB";
#else
			muta_desc = "You become subject to uncontrollable flatulence.";
#endif

			break;
		case 81: case 82:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_SCOR_TAIL;
#ifdef JP
muta_desc = "T\̐KĂI";
#else
			muta_desc = "You grow a scorpion tail!";
#endif

			break;
		case 83: case 84:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_HORNS;
#ifdef JP
muta_desc = "zɊpI";
#else
			muta_desc = "Horns pop forth into your forehead!";
#endif

			break;
		case 85: case 86:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_BEAK;
#ifdef JP
muta_desc = "sN`oVɕωI";
#else
			muta_desc = "Your mouth turns into a sharp, powerful beak!";
#endif

			break;
		case 87: case 88:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ATT_DEMON;
#ifdef JP
muta_desc = "t悤ɂȂB";
#else
			muta_desc = "You start attracting demons.";
#endif

			break;
		case 89:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_PROD_MANA;
#ifdef JP
muta_desc = "Ȃ͐s\Ȗ@̃GlM[𔭐悤ɂȂB";
#else
			muta_desc = "You start producing magical energy uncontrollably.";
#endif

			break;
		case 90: case 91:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_SPEED_FLUX;
#ifdef JP
muta_desc = "ȂNTɂȂB";
#else
			muta_desc = "You become manic-depressive.";
#endif

			break;
		case 92: case 93:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_BANISH_ALL;
#ifdef JP
muta_desc = "낵͂Ȃ̔wɐłCB";
#else
			muta_desc = "You feel a terrifying power lurking behind you.";
#endif

			break;
		case 94:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_EAT_LIGHT;
#ifdef JP
muta_desc = "Ȃ̓ESAgɊȐe݂o悤ɂȂB";
#else
			muta_desc = "You feel a strange kinship with Ungoliant.";
#endif

			break;
		case 95: case 96:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_TRUNK;
#ifdef JP
muta_desc = "Ȃ̕@͐Lтďۂ̕@̂悤ɂȂB";
#else
			muta_desc = "Your nose grows into an elephant-like trunk.";
#endif

			break;
		case 97:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ATT_ANIMAL;
#ifdef JP
muta_desc = "t悤ɂȂB";
#else
			muta_desc = "You start attracting animals.";
#endif

			break;
		case 98:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_TENTACLES;
#ifdef JP
muta_desc = "׈ȐG肪̗̂ɐĂB";
#else
			muta_desc = "Evil-looking tentacles sprout from your sides.";
#endif

			break;
		case 99:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_RAW_CHAOS;
#ifdef JP
muta_desc = "͂̋ԂsɂȂCB";
#else
			muta_desc = "You feel the universe is less stable around you.";
#endif

			break;
		case 100: case 101: case 102:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_NORMALITY;
#ifdef JP
muta_desc = "Ȃ͊ȂقǕʂɂȂCB";
#else
			muta_desc = "You feel strangely normal.";
#endif

			break;
		case 103:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WRAITH;
#ifdef JP
muta_desc = "Ȃ͗H̉̉肷悤ɂȂB";
#else
			muta_desc = "You start to fade in and out of the physical world.";
#endif

			break;
		case 104:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_POLY_WOUND;
#ifdef JP
muta_desc = "Ȃ̓JIX̗͂Âɓ荞ł̂B";
#else
			muta_desc = "You feel forces of chaos entering your old scars.";
#endif

			break;
		case 105:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WASTING;
#ifdef JP
muta_desc = "Ȃ͓ˑR܂aɂB";
#else
			muta_desc = "You suddenly contract a horrible wasting disease.";
#endif

			break;
		case 106:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ATT_DRAGON;
#ifdef JP
muta_desc = "Ȃ̓hS悤ɂȂB";
#else
			muta_desc = "You start attracting dragons.";
#endif

			break;
		case 107: case 108:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WEIRD_MIND;
#ifdef JP
muta_desc = "Ȃ̎vl͓ˑRȕɌn߂B";
#else
			muta_desc = "Your thoughts suddenly take off in strange directions.";
#endif

			break;
		case 109:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_NAUSEA;
#ifdef JP
muta_desc = "ݑ܂sNsN͂߂B";
#else
			muta_desc = "Your stomach starts to roil nauseously.";
#endif

			break;
		case 110: case 111:
			/* Chaos warriors already have a chaos deity */
			if (cr_ptr->cls_idx != CLASS_CHAOS_WARRIOR)
			{
				muta_class = &(cr_ptr->flags13);
				muta_which = CF_CHAOS_GIFT;
#ifdef JP
muta_desc = "Ȃ̓JIX̎숫̒ӂ䂭悤ɂȂB";
#else
				muta_desc = "You attract the notice of a chaos deity!";
#endif

			}
			break;
		case 112:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WALK_SHAD;
#ifdef JP
muta_desc = "Ȃ͌̂悤ɔƊ悤ɂȂB";
#else
			muta_desc = "You feel like reality is as thin as paper.";
#endif

			break;
		case 113: case 114:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WARNING;
#ifdef JP
muta_desc = "Ȃ͓ˑRpmCAɂȂCB";
#else
			muta_desc = "You suddenly feel paranoid.";
#endif

			break;
		case 115:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_INVULN;
#ifdef JP
muta_desc = "Ȃ͏jAGԂɂȂ锭N悤ɂȂB";
#else
			muta_desc = "You are blessed with fits of invulnerability.";
#endif

			break;
		case 116: case 117:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_SP_TO_HP;
#ifdef JP
muta_desc = "@̎̔N悤ɂȂB";
#else
			muta_desc = "You are subject to fits of magical healing.";
#endif

			break;
		case 118:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_HP_TO_SP;
#ifdef JP
muta_desc = "ɂ݂𔺂_ĉ̔N悤ɂȂB";
#else
			muta_desc = "You are subject to fits of painful clarity.";
#endif

			break;
		case 119:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_DISARM;
#ifdef JP
muta_desc = "Ȃ̋r͒l{ɂȂB";
#else
			muta_desc = "Your feet grow to four times their former size.";
#endif

			break;
		case 120: case 121: case 122:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_HYPER_STR;
#ifdef JP
muta_desc = "lIɋȂI";
#else
			muta_desc = "You turn into a superhuman he-man!";
#endif

			break;
		case 123: case 124: case 125:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_PUNY;
#ifdef JP
muta_desc = "ؓĂ܂...";
#else
			muta_desc = "Your muscles wither away...";
#endif

			break;
		case 126: case 127: case 128:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_HYPER_INT;
#ifdef JP
muta_desc = "Ȃ̔]͐̃Rs[^ɐiI";
#else
			muta_desc = "Your brain evolves into a living computer!";
#endif

			break;
		case 129: case 130: case 131:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_MORONIC;
#ifdef JP
muta_desc = "]ޏkĂ܂...";
#else
			muta_desc = "Your brain withers away...";
#endif

			break;
		case 132: case 133:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_RESILIENT;
#ifdef JP
muta_desc = "Oă^tɂȂB";
#else
			muta_desc = "You become extraordinarily resilient.";
#endif

			break;
		case 134: case 135:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_FAT;
#ifdef JP
muta_desc = "Ȃ͋C炢I";
#else
			muta_desc = "You become sickeningly fat!";
#endif

			break;
		case 136: case 137:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ALBINO;
#ifdef JP
muta_desc = "ArmɂȂIキȂC...";
#else
			muta_desc = "You turn into an albino! You feel frail...";
#endif

			break;
		case 138: case 139: case 140:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_FLESH_ROT;
#ifdef JP
muta_desc = "Ȃ͕̓̂saCɐNꂽI";
#else
			muta_desc = "Your flesh is afflicted by a rotting disease!";
#endif

			break;
		case 141: case 142:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_SILLY_VOI;
#ifdef JP
muta_desc = "ԔȃL[L[ɂȂI";
#else
			muta_desc = "Your voice turns into a ridiculous squeak!";
#endif

			break;
		case 143: case 144:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_BLANK_FAC;
#ifdef JP
muta_desc = "̂؂ڂɂȂI";
#else
			muta_desc = "Your face becomes completely featureless!";
#endif

			break;
		case 145:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ILL_NORM;
#ifdef JP
muta_desc = "S̈炮efo悤ɂȂB";
#else
			muta_desc = "You start projecting a reassuring image.";
#endif

			break;
		case 146: case 147: case 148:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_EYES;
#ifdef JP
muta_desc = "Vɓ̖ڂoI";
#else
			muta_desc = "You grow an extra pair of eyes!";
#endif

			break;
		case 149: case 150:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_MAGIC_RES;
#ifdef JP
muta_desc = "@ւ̑ϐB";
#else
			muta_desc = "You become resistant to magic.";
#endif

			break;
		case 151: case 152: case 153:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_NOIS;
#ifdef JP
muta_desc = "Ȃ͊ȉ𗧂Ďn߂I";
#else
			muta_desc = "You start making strange noise!";
#endif

			break;
		case 154: case 155: case 156:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_INFRAVIS;
#ifdef JP
muta_desc = "ԊO͂B";
#else
			muta_desc = "Your infravision is improved.";
#endif

			break;
		case 157: case 158:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_LEGS;
#ifdef JP
muta_desc = "Vɓ{̑ĂI";
#else
			muta_desc = "You grow an extra pair of legs!";
#endif

			break;
		case 159: case 160:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_SHORT_LEG;
#ifdef JP
muta_desc = "ZˋNɂȂĂ܂I";
#else
			muta_desc = "Your legs turn into short stubs!";
#endif

			break;
		case 161: case 162:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ELEC_TOUC;
#ifdef JP
muta_desc = "ǂdn߂I";
#else
			muta_desc = "Electricity starts running through you!";
#endif

			break;
		case 163: case 164:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_FIRE_BODY;
#ifdef JP
muta_desc = "Ȃ͉̑̂ɂ܂ĂB";
#else
			muta_desc = "Your body is enveloped in flames!";
#endif

			break;
		case 165: case 166: case 167:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_WART_SKIN;
#ifdef JP
muta_desc = "CC{C{̒ɂłI";
#else
			muta_desc = "Disgusting warts appear everywhere on you!";
#endif

			break;
		case 168: case 169: case 170:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_SCALES;
#ifdef JP
muta_desc = "؂ɕςI";
#else
			muta_desc = "Your skin turns into black scales!";
#endif

			break;
		case 171: case 172:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_IRON_SKIN;
#ifdef JP
muta_desc = "Ȃ͓̔SɂȂI";
#else
			muta_desc = "Your skin turns to steel!";
#endif

			break;
		case 173: case 174:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_WINGS;
#ifdef JP
muta_desc = "wɉHB";
#else
			muta_desc = "You grow a pair of wings.";
#endif

			break;
		case 175: case 176: case 177:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_FEARLESS;
#ifdef JP
muta_desc = "Sɕ|m炸ɂȂB";
#else
			muta_desc = "You become completely fearless.";
#endif

			break;
		case 178: case 179:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_REGEN;
#ifdef JP
muta_desc = "}ɉ񕜂n߂B";
#else
			muta_desc = "You start regenerating.";
#endif

			break;
		case 180: case 181:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ESP;
#ifdef JP
muta_desc = "epV[̔\͂𓾂I";
#else
			muta_desc = "You develop a telepathic ability!";
#endif

			break;
		case 182: case 183: case 184:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_LIMBER;
#ifdef JP
muta_desc = "ؓȂ₩ɂȂB";
#else
			muta_desc = "Your muscles become limber.";
#endif

			break;
		case 185: case 186: case 187:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ARTHRITIS;
#ifdef JP
muta_desc = "֐߂ˑRɂݏoB";
#else
			muta_desc = "Your joints suddenly hurt.";
#endif

			break;
		case 188:
			if (cr_ptr->chara_idx == CHARA_LUCKY) break;
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_BAD_LUCK;
#ifdef JP
muta_desc = "ӂɖI[ȂƂ܂...";
#else
			muta_desc = "There is a malignant black aura surrounding you...";
#endif

			break;
		case 189:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_VULN_ELEM;
#ifdef JP
muta_desc = "ɖhɂȂCB";
#else
			muta_desc = "You feel strangely exposed.";
#endif

			break;
		case 190: case 191: case 192:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_MOTION;
#ifdef JP
muta_desc = "̂̓삪萳mɂȂB";
#else
			muta_desc = "You move with new assurance.";
#endif

			break;
		case 193:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_GOOD_LUCK;
#ifdef JP
muta_desc = "ߐ[I[ȂƂ܂...";
#else
			muta_desc = "There is a benevolent white aura surrounding you...";
#endif

			break;
		default:
			muta_class = NULL;
			muta_which = 0;
		}

		if (muta_class && muta_which)
		{
			if (!(*muta_class & muta_which))
			{
				muta_chosen = TRUE;
			}
		}
		if (muta_chosen == TRUE) break;
	}

	if (!muta_chosen)
	{
#ifdef JP
if(messsage) msg_print("ʂɂȂCB");
#else
		if(messsage) msg_print("You feel normal.");
#endif

		return FALSE;
	}
	else
	{

		/*
		  some races are apt to gain specified mutations
		  This should be allowed only if "choose_mut" is 0.
							--- henkma
		*/
		if(!choose_mut){
			if (has_cf_creature(cr_ptr, CF_VAMPIRE) &&
			  !has_cf_creature(cr_ptr, CF_HYPN_GAZE) &&
			   (randint1(10) < 7))
			{
				muta_class = &(cr_ptr->flags12);
				muta_which = CF_HYPN_GAZE;
#ifdef JP
muta_desc = "ႪfIɂȂ...";
#else
				muta_desc = "Your eyes look mesmerizing...";
#endif

			}

			else if (cr_ptr->race_idx1 == RACE_IMP &&
				 !has_cf_creature(cr_ptr, CF_HORNS) &&
				 (randint1(10) < 7))
			  {
				muta_class = &(cr_ptr->flags13);
				muta_which = CF_HORNS;
#ifdef JP
muta_desc = "pz琶ĂI";
#else
				muta_desc = "Horns pop forth into your forehead!";
#endif

			}

			else if (cr_ptr->race_idx1 == RACE_YEEK &&
				!has_cf_creature(cr_ptr, CF_SHRIEK) &&
				(randint1(10) < 7))
			{
				muta_class = &(cr_ptr->flags12);
				muta_which = CF_SHRIEK;
#ifdef JP
muta_desc = "Ȃ苭ȂB";
#else
				muta_desc = "Your vocal cords get much tougher.";
#endif

			}

			else if (cr_ptr->race_idx1 == RACE_BEASTMAN &&
				!has_cf_creature(cr_ptr, CF_POLYMORPH) &&
				(randint1(10) < 2))
			{
				muta_class = &(cr_ptr->flags12);
				muta_which = CF_POLYMORPH;
#ifdef JP
muta_desc = "Ȃ͕̓̂ωł悤ɂȂA";
#else
				muta_desc = "Your body seems mutable.";
#endif

			}

			else if (cr_ptr->race_idx1 == RACE_MIND_FLAYER &&
				!has_cf_creature(cr_ptr, CF_TENTACLES) &&
				(randint1(10) < 7))
			{
				muta_class = &(cr_ptr->flags13);
				muta_which = CF_TENTACLES;
#ifdef JP
muta_desc = "׈ȐG肪̎ɐB";
#else
				muta_desc = "Evil-looking tentacles sprout from your mouth.";
#endif

			}
		}
#ifdef JP
		if(messsage) msg_print("ˑRψقI");
#else
		if(messsage) msg_print("You mutate!");
#endif

		if(messsage) msg_print(muta_desc);
		*muta_class |= muta_which;

		if (muta_class == &(cr_ptr->flags14))
		{
			if (muta_which == CF_PUNY)
			{
				if (has_cf_creature(cr_ptr, CF_HYPER_STR))
				{
#ifdef JP
if(messsage) msg_print("Ȃ͂lIɋ͂ȂI");
#else
					if(messsage) msg_print("You no longer feel super-strong!");
#endif

					cr_ptr->flags14 &= ~(CF_HYPER_STR);
				}
			}
			else if (muta_which == CF_HYPER_STR)
			{
				if (has_cf_creature(cr_ptr, CF_PUNY))
				{
#ifdef JP
if(messsage) msg_print("Ȃ͂ł͂ȂI");
#else
					if(messsage) msg_print("You no longer feel puny!");
#endif

					cr_ptr->flags14 &= ~(CF_PUNY);
				}
			}
			else if (muta_which == CF_MORONIC)
			{
				if (has_cf_creature(cr_ptr, CF_HYPER_INT))
				{
#ifdef JP
if(messsage) msg_print("Ȃ̔]͂̃Rs[^ł͂ȂB");
#else
					if(messsage) msg_print("Your brain is no longer a living computer.");
#endif

					cr_ptr->flags14 &= ~(CF_HYPER_INT);
				}
			}
			else if (muta_which == CF_HYPER_INT)
			{
				if (has_cf_creature(cr_ptr, CF_MORONIC))
				{
#ifdef JP
if(messsage) msg_print("Ȃ͂_ł͂ȂB");
#else
					if(messsage) msg_print("You are no longer moronic.");
#endif

					cr_ptr->flags14 &= ~(CF_MORONIC);
				}
			}
			else if (muta_which == CF_IRON_SKIN)
			{
				if (has_cf_creature(cr_ptr, CF_SCALES))
				{
#ifdef JP
if(messsage) msg_print("؂ȂȂB");
#else
					if(messsage) msg_print("You lose your scales.");
#endif

					cr_ptr->flags14 &= ~(CF_SCALES);
				}
				if (has_cf_creature(cr_ptr, CF_FLESH_ROT))
				{
#ifdef JP
if(messsage) msg_print("̂ȂȂB");
#else
					if(messsage) msg_print("Your flesh rots no longer.");
#endif

					cr_ptr->flags14 &= ~(CF_FLESH_ROT);
				}
				if (has_cf_creature(cr_ptr, CF_WART_SKIN))
				{
#ifdef JP
if(messsage) msg_print("̃C{C{ȂȂB");
#else
					if(messsage) msg_print("You lose your warts.");
#endif

					cr_ptr->flags14 &= ~(CF_WART_SKIN);
				}
			}
			else if (muta_which == CF_WART_SKIN || muta_which == CF_SCALES
				|| muta_which == CF_FLESH_ROT)
			{
				if (has_cf_creature(cr_ptr, CF_IRON_SKIN))
				{
#ifdef JP
if(messsage) msg_print("Ȃ̔͂Sł͂ȂB");
#else
					if(messsage) msg_print("Your skin is no longer made of steel.");
#endif

					cr_ptr->flags14 &= ~(CF_IRON_SKIN);
				}
			}
			else if (muta_which == CF_FEARLESS)
			{
				if (has_cf_creature(cr_ptr, CF_COWARDICE))
				{
#ifdef JP
if(messsage) msg_print("ałȂȂB");
#else
					if(messsage) msg_print("You are no longer cowardly.");
#endif

					cr_ptr->flags13 &= ~(CF_COWARDICE);
				}
			}
			else if (muta_which == CF_FLESH_ROT)
			{
				if (has_cf_creature(cr_ptr, CF_REGEN))
				{
#ifdef JP
if(messsage) msg_print("}ɉ񕜂ȂȂB");
#else
					if(messsage) msg_print("You stop regenerating.");
#endif

					cr_ptr->flags14 &= ~(CF_REGEN);
				}
			}
			else if (muta_which == CF_REGEN)
			{
				if (has_cf_creature(cr_ptr, CF_FLESH_ROT))
				{
#ifdef JP
if(messsage) msg_print("̂ȂȂB");
#else
					if(messsage) msg_print("Your flesh stops rotting.");
#endif

					cr_ptr->flags14 &= ~(CF_FLESH_ROT);
				}
			}
			else if (muta_which == CF_LIMBER)
			{
				if (has_cf_creature(cr_ptr, CF_ARTHRITIS))
				{
#ifdef JP
if(messsage) msg_print("֐߂ɂȂȂB");
#else
					if(messsage) msg_print("Your joints stop hurting.");
#endif

					cr_ptr->flags14 &= ~(CF_ARTHRITIS);
				}
			}
			else if (muta_which == CF_ARTHRITIS)
			{
				if (has_cf_creature(cr_ptr, CF_LIMBER))
				{
#ifdef JP
if(messsage) msg_print("Ȃ͂Ȃ₩łȂȂB");
#else
					if(messsage) msg_print("You no longer feel limber.");
#endif

					cr_ptr->flags14 &= ~(CF_LIMBER);
				}
			}
		}
		else if (muta_class == &(cr_ptr->flags13))
		{
			if (muta_which == CF_COWARDICE)
			{
				if (has_cf_creature(cr_ptr, CF_FEARLESS))
				{
#ifdef JP
if(messsage) msg_print("m炸łȂȂB");
#else
					if(messsage) msg_print("You no longer feel fearless.");
#endif

					cr_ptr->flags14 &= ~(CF_FEARLESS);
				}
			}
			if (muta_which == CF_BEAK)
			{
				if (has_cf_creature(cr_ptr, CF_TRUNK))
				{
#ifdef JP
if(messsage) msg_print("Ȃ̕@͂ۂ̕@̂悤ł͂ȂȂB");
#else
					if(messsage) msg_print("Your nose is no longer elephantine.");
#endif

					cr_ptr->flags13 &= ~(CF_TRUNK);
				}
			}
			if (muta_which == CF_TRUNK)
			{
				if (has_cf_creature(cr_ptr, CF_BEAK))
				{
#ifdef JP
if(messsage) msg_print("dN`oVȂȂB");
#else
					if(messsage) msg_print("You no longer have a hard beak.");
#endif

					cr_ptr->flags13 &= ~(CF_BEAK);
				}
			}
		}

		cr_ptr->mutant_regenerate_mod = calc_mutant_regenerate_mod(cr_ptr);
		cr_ptr->creature_update |= CRU_BONUS;
		handle_stuff();
		return TRUE;
	}
}


bool lose_mutation(creature_type *cr_ptr, int choose_mut)
{
	int attempts_left = 20;
	cptr muta_desc = "";
	bool muta_chosen = FALSE;
	u32b muta_which = 0;
	u32b *muta_class = NULL;

	if (choose_mut) attempts_left = 1;

	while (attempts_left--)
	{
		switch (choose_mut ? choose_mut : randint1(193))
		{
		case 1: case 2: case 3: case 4:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SPIT_ACID;
#ifdef JP
muta_desc = "_𐁂\͂B";
#else
			muta_desc = "You lose the ability to spit acid.";
#endif

			break;
		case 5: case 6: case 7:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BR_FIRE;
#ifdef JP
muta_desc = "̃uXf\͂B";
#else
			muta_desc = "You lose the ability to breathe fire.";
#endif

			break;
		case 8: case 9:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_HYPN_GAZE;
#ifdef JP
muta_desc = "Ȃ̖ڂ͂܂ȂڂɂȂB";
#else
			muta_desc = "Your eyes look uninteresting.";
#endif

			break;
		case 10: case 11:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_TELEKINES;
#ifdef JP
muta_desc = "O͂ŕ𓮂\͂B";
#else
			muta_desc = "You lose the ability to move objects telekinetically.";
#endif

			break;
		case 12: case 13: case 14:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_VTELEPORT;
#ifdef JP
muta_desc = "̈ӎvŃe|[g\͂B";
#else
			muta_desc = "You lose the power of teleportation at will.";
#endif

			break;
		case 15: case 16:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_MIND_BLST;
#ifdef JP
muta_desc = "_U̔\͂B";
#else
			muta_desc = "You lose the power of Mind Blast.";
#endif

			break;
		case 17: case 18:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_RADIATION;
#ifdef JP
muta_desc = "Ȃ͕˔\𔭐ȂȂB";
#else
			muta_desc = "You stop emitting hard radiation.";
#endif

			break;
		case 19: case 20:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_VAMPIRISM;
#ifdef JP
muta_desc = "z̔\͂B";
#else
			muta_desc = "You are no longer vampiric.";
#endif

			break;
		case 21: case 22: case 23:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SMELL_MET;
#ifdef JP
muta_desc = "̏LkȂȂB";
#else
			muta_desc = "You no longer smell a metallic odor.";
#endif

			break;
		case 24: case 25: case 26: case 27:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SMELL_MON;
#ifdef JP
muta_desc = "sȃX^[̏LkȂȂB";
#else
			muta_desc = "You no longer smell filthy monsters.";
#endif

			break;
		case 28: case 29: case 30:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BLINK;
#ifdef JP
muta_desc = "ߋe|[g̔\͂B";
#else
			muta_desc = "You lose the power of minor teleportation.";
#endif

			break;
		case 31: case 32:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_EAT_ROCK;
#ifdef JP
muta_desc = "ǂ͔ɌȂȂB";
#else
			muta_desc = "The walls look unappetizing.";
#endif

			break;
		case 33: case 34:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SWAP_POS;
#ifdef JP
muta_desc = "Ȃ͎̌Cɗ܂銴B";
#else
			muta_desc = "You feel like staying in your own shoes.";
#endif

			break;
		case 35: case 36: case 37:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_SHRIEK;
#ifdef JP
muta_desc = "Ȃ͎̐キȂB";
#else
			muta_desc = "Your vocal cords get much weaker.";
#endif

			break;
		case 38: case 39: case 40:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_ILLUMINE;
#ifdef JP
muta_desc = "𖾂邭Ƃ炷ƂoȂȂB";
#else
			muta_desc = "You can no longer light up rooms with your presence.";
#endif

			break;
		case 41: case 42:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_DET_CURSE;
#ifdef JP
muta_desc = "׈Ȗ@ȂȂB";
#else
			muta_desc = "You can no longer feel evil magics.";
#endif

			break;
		case 43: case 44: case 45:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BERSERK;
#ifdef JP
muta_desc = "ł錃ȂȂB";
#else
			muta_desc = "You no longer feel a controlled rage.";
#endif

			break;
		case 46:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_POLYMORPH;
#ifdef JP
muta_desc = "Ȃ͈̑̂肵悤ɌB";
#else
			muta_desc = "Your body seems stable.";
#endif

			break;
		case 47: case 48:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_MIDAS_TCH;
#ifdef JP
muta_desc = "~_X̎̔\͂B";
#else
			muta_desc = "You lose the Midas touch.";
#endif

			break;
		case 49:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_GROW_MOLD;
#ifdef JP
muta_desc = "ˑRJrɂȂB";
#else
			muta_desc = "You feel a sudden dislike for mold.";
#endif

			break;
		case 50: case 51: case 52:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_RESIST;
#ifdef JP
muta_desc = "ՂȂCB";
#else
			muta_desc = "You feel like you might be vulnerable.";
#endif

			break;
		case 53: case 54: case 55:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_EARTHQUAKE;
#ifdef JP
muta_desc = "_W󂷔\͂B";
#else
			muta_desc = "You lose the ability to wreck the dungeon.";
#endif

			break;
		case 56:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_EAT_MAGIC;
#ifdef JP
muta_desc = "@̃ACe͂ɌȂȂB";
#else
			muta_desc = "Your magic items no longer look delicious.";
#endif

			break;
		case 57: case 58:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_WEIGH_MAG;
#ifdef JP
muta_desc = "͂ȂȂB";
#else
			muta_desc = "You no longer sense magic.";
#endif

			break;
		case 59:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_STERILITY;
#ifdef JP
muta_desc = "̈g̓fB";
#else
			muta_desc = "You hear a massed sigh of relief.";
#endif

			break;
		case 60: case 61:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_PANIC_HIT;
#ifdef JP
muta_desc = "ׂ֒CȂȂB";
#else
			muta_desc = "You no longer feel jumpy.";
#endif

			break;
		case 62: case 63: case 64:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_DAZZLE;
#ifdef JP
muta_desc = "܂΂䂢M𔭂\͂B";
#else
			muta_desc = "You lose the ability to emit dazzling lights.";
#endif

			break;
		case 65: case 66: case 67:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_LASER_EYE;
#ifdef JP
muta_desc = "Ⴊ̊ԏĂtāAɂ݂a炢B";
#else
			muta_desc = "Your eyes burn for a moment, then feel soothed.";
#endif

			break;
		case 68: case 69:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_RECALL;
#ifdef JP
muta_desc = "̊ԃz[VbNɂȂB";
#else
			muta_desc = "You feel briefly homesick.";
#endif

			break;
		case 70:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_BANISH;
#ifdef JP
muta_desc = "_ȓ{̗͂ȂȂB";
#else
			muta_desc = "You no longer feel a holy wrath.";
#endif

			break;
		case 71: case 72:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_COLD_TOUCH;
#ifdef JP
muta_desc = "肪gȂB";
#else
			muta_desc = "Your hands warm up.";
#endif

			break;
		case 73: case 74:
			muta_class = &(cr_ptr->flags12);
			muta_which = CF_LAUNCHER;
#ifdef JP
muta_desc = "𓊂肪キȂCB";
#else
			muta_desc = "Your throwing arm feels much weaker.";
#endif

			break;
		case 75:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_BERS_RAGE;
#ifdef JP
muta_desc = "\̔ɂ炳ȂȂI";
#else
			muta_desc = "You are no longer subject to fits of berserk rage!";
#endif

			break;
		case 76:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_COWARDICE;
#ifdef JP
muta_desc = "Mقǉał͂ȂȂI";
#else
			muta_desc = "You are no longer an incredible coward!";
#endif

			break;
		case 77:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_RTELEPORT;
#ifdef JP
muta_desc = "Ȃ̈ʒu͂mIɂȂB";
#else
			muta_desc = "Your position seems more certain.";
#endif

			break;
		case 78:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ALCOHOL;
#ifdef JP
muta_desc = "Ȃ̓AR[𕪔債ȂȂI";
#else
			muta_desc = "Your body stops producing alcohol!";
#endif

			break;
		case 79:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_HALLU;
#ifdef JP
muta_desc = "oЂN_QNȂȂI";
#else
			muta_desc = "You are no longer afflicted by a hallucinatory insanity!";
#endif

			break;
		case 80:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_FLATULENT;
#ifdef JP
muta_desc = "ț͂ȂȂB";
#else
			muta_desc = "You are no longer subject to uncontrollable flatulence.";
#endif

			break;
		case 81: case 82:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_SCOR_TAIL;
#ifdef JP
muta_desc = "T\̐KȂȂI";
#else
			muta_desc = "You lose your scorpion tail!";
#endif

			break;
		case 83: case 84:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_HORNS;
#ifdef JP
muta_desc = "zpI";
#else
			muta_desc = "Your horns vanish from your forehead!";
#endif

			break;
		case 85: case 86:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_BEAK;
#ifdef JP
muta_desc = "ʂɖ߂I";
#else
			muta_desc = "Your mouth reverts to normal!";
#endif

			break;
		case 87: case 88:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ATT_DEMON;
#ifdef JP
muta_desc = "f[񂹂ȂȂB";
#else
			muta_desc = "You stop attracting demons.";
#endif

			break;
		case 89:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_PROD_MANA;
#ifdef JP
muta_desc = "s\Ȗ@̃GlM[𔭐ȂȂB";
#else
			muta_desc = "You stop producing magical energy uncontrollably.";
#endif

			break;
		case 90: case 91:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_SPEED_FLUX;
#ifdef JP
muta_desc = "NTłȂȂB";
#else
			muta_desc = "You are no longer manic-depressive.";
#endif

			break;
		case 92: case 93:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_BANISH_ALL;
#ifdef JP
muta_desc = "wɋ낵͂ȂȂB";
#else
			muta_desc = "You no longer feel a terrifying power lurking behind you.";
#endif

			break;
		case 94:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_EAT_LIGHT;
#ifdef JP
muta_desc = "E邢ƊB";
#else
			muta_desc = "You feel the world's a brighter place.";
#endif

			break;
		case 95: case 96:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_TRUNK;
#ifdef JP
muta_desc = "@ʂ̒ɖ߂B";
#else
			muta_desc = "Your nose returns to a normal length.";
#endif

			break;
		case 97:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ATT_ANIMAL;
#ifdef JP
muta_desc = "񂹂ȂȂB";
#else
			muta_desc = "You stop attracting animals.";
#endif

			break;
		case 98:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_TENTACLES;
#ifdef JP
muta_desc = "G肪B";
#else
			muta_desc = "Your tentacles vanish from your sides.";
#endif

			break;
		case 99:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_RAW_CHAOS;
#ifdef JP
muta_desc = "͂̋Ԃ肵CB";
#else
			muta_desc = "You feel the universe is more stable around you.";
#endif

			break;
		case 100: case 101: case 102:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_NORMALITY;
#ifdef JP
muta_desc = "ʂɊȊB";
#else
			muta_desc = "You feel normally strange.";
#endif

			break;
		case 103:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WRAITH;
#ifdef JP
muta_desc = "Ȃ͕Eɂ葶݂ĂB";
#else
			muta_desc = "You are firmly in the physical world.";
#endif

			break;
		case 104:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_POLY_WOUND;
#ifdef JP
muta_desc = "ÂJIX̗͂ĂB";
#else
			muta_desc = "You feel forces of chaos departing your old scars.";
#endif

			break;
		case 105:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WASTING;
#ifdef JP
muta_desc = "܂aI";
#else
			muta_desc = "You are cured of the horrible wasting disease!";
#endif

			break;
		case 106:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_ATT_DRAGON;
#ifdef JP
muta_desc = "hS񂹂ȂȂB";
#else
			muta_desc = "You stop attracting dragons.";
#endif

			break;
		case 107: case 108:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WEIRD_MIND;
#ifdef JP
muta_desc = "vlދȕɖ߂B";
#else
			muta_desc = "Your thoughts return to boring paths.";
#endif

			break;
		case 109:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_NAUSEA;
#ifdef JP
muta_desc = "݂zȂȂB";
#else
			muta_desc = "Your stomach stops roiling.";
#endif

			break;
		case 110: case 111:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_CHAOS_GIFT;
#ifdef JP
muta_desc = "ׂ̐_X̋䂩ȂȂB";
#else
			muta_desc = "You lose the attention of the chaos deities.";
#endif

			break;
		case 112:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WALK_SHAD;
#ifdef JP
muta_desc = "Eɕ߂ĂCB";
#else
			muta_desc = "You feel like you're trapped in reality.";
#endif

			break;
		case 113: case 114:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_WARNING;
#ifdef JP
muta_desc = "pmCAłȂȂB";
#else
			muta_desc = "You no longer feel paranoid.";
#endif

			break;
		case 115:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_INVULN;
#ifdef JP
muta_desc = "GԂ̔NȂȂB";
#else
			muta_desc = "You are no longer blessed with fits of invulnerability.";
#endif

			break;
		case 116: case 117:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_SP_TO_HP;
#ifdef JP
muta_desc = "@̎̔ɏPȂȂB";
#else
			muta_desc = "You are no longer subject to fits of magical healing.";
#endif

			break;
		case 118:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_HP_TO_SP;
#ifdef JP
muta_desc = "ɂ݂𔺂_ĉ̔ɏPȂȂB";
#else
			muta_desc = "You are no longer subject to fits of painful clarity.";
#endif

			break;
		case 119:
			muta_class = &(cr_ptr->flags13);
			muta_which = CF_DISARM;
#ifdef JP
muta_desc = "ȓ傫ɖ߂B";
#else
			muta_desc = "Your feet shrink to their former size.";
#endif

			break;
		case 120: case 121: case 122:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_HYPER_STR;
#ifdef JP
muta_desc = "ؓʂɖ߂B";
#else
			muta_desc = "Your muscles revert to normal.";
#endif

			break;
		case 123: case 124: case 125:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_PUNY;
#ifdef JP
muta_desc = "ؓʂɖ߂B";
#else
			muta_desc = "Your muscles revert to normal.";
#endif

			break;
		case 126: case 127: case 128:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_HYPER_INT;
#ifdef JP
muta_desc = "]ʂɖ߂B";
#else
			muta_desc = "Your brain reverts to normal.";
#endif

			break;
		case 129: case 130: case 131:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_MORONIC;
#ifdef JP
muta_desc = "]ʂɖ߂B";
#else
			muta_desc = "Your brain reverts to normal.";
#endif

			break;
		case 132: case 133:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_RESILIENT;
#ifdef JP
muta_desc = "ʂ̏vɖ߂B";
#else
			muta_desc = "You become ordinarily resilient again.";
#endif

			break;
		case 134: case 135:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_FAT;
#ifdef JP
muta_desc = "ՓIȃ_CGbgɐI";
#else
			muta_desc = "You benefit from a miracle diet!";
#endif

			break;
		case 136: case 137:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ALBINO;
#ifdef JP
muta_desc = "ArmłȂȂI";
#else
			muta_desc = "You are no longer an albino!";
#endif

			break;
		case 138: case 139: case 140:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_FLESH_ROT;
#ifdef JP
muta_desc = "̂𕅔saCI";
#else
			muta_desc = "Your flesh is no longer afflicted by a rotting disease!";
#endif

			break;
		case 141: case 142:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_SILLY_VOI;
#ifdef JP
muta_desc = "ʂɖ߂B";
#else
			muta_desc = "Your voice returns to normal.";
#endif

			break;
		case 143: case 144:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_BLANK_FAC;
#ifdef JP
muta_desc = "ɖڕ@߂B";
#else
			muta_desc = "Your facial features return.";
#endif

			break;
		case 145:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ILL_NORM;
#ifdef JP
muta_desc = "S炮efoȂȂB";
#else
			muta_desc = "You stop projecting a reassuring image.";
#endif

			break;
		case 146: case 147: case 148:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_EYES;
#ifdef JP
muta_desc = "]ȖڂĂ܂I";
#else
			muta_desc = "Your extra eyes vanish!";
#endif

			break;
		case 149: case 150:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_MAGIC_RES;
#ifdef JP
muta_desc = "@ɎキȂB";
#else
			muta_desc = "You become susceptible to magic again.";
#endif

			break;
		case 151: case 152: case 153:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_NOIS;
#ifdef JP
muta_desc = "ȉ𗧂ĂȂȂI";
#else
			muta_desc = "You stop making strange noise!";
#endif

			break;
		case 154: case 155: case 156:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_INFRAVIS;
#ifdef JP
muta_desc = "ԊO͂B";
#else
			muta_desc = "Your infravision is degraded.";
#endif

			break;
		case 157: case 158:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_XTRA_LEGS;
#ifdef JP
muta_desc = "]ȋrĂ܂I";
#else
			muta_desc = "Your extra legs disappear!";
#endif

			break;
		case 159: case 160:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_SHORT_LEG;
#ifdef JP
muta_desc = "r̒ʂɖ߂B";
#else
			muta_desc = "Your legs lengthen to normal.";
#endif

			break;
		case 161: case 162:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ELEC_TOUC;
#ifdef JP
muta_desc = "̂dȂȂB";
#else
			muta_desc = "Electricity stops running through you.";
#endif

			break;
		case 163: case 164:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_FIRE_BODY;
#ifdef JP
muta_desc = "̂ɕ܂ȂȂB";
#else
			muta_desc = "Your body is no longer enveloped in flames.";
#endif

			break;
		case 165: case 166: case 167:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_WART_SKIN;
#ifdef JP
muta_desc = "C{C{I";
#else
			muta_desc = "Your warts disappear!";
#endif

			break;
		case 168: case 169: case 170:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_SCALES;
#ifdef JP
muta_desc = "؂I";
#else
			muta_desc = "Your scales vanish!";
#endif

			break;
		case 171: case 172:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_IRON_SKIN;
#ifdef JP
muta_desc = "ɂǂI";
#else
			muta_desc = "Your skin reverts to flesh!";
#endif

			break;
		case 173: case 174:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_WINGS;
#ifdef JP
muta_desc = "w̉HꗎB";
#else
			muta_desc = "Your wings fall off.";
#endif

			break;
		case 175: case 176: case 177:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_FEARLESS;
#ifdef JP
muta_desc = "Ăы|悤ɂȂB";
#else
			muta_desc = "You begin to feel fear again.";
#endif

			break;
		case 178: case 179:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_REGEN;
#ifdef JP
muta_desc = "}񕜂ȂȂB";
#else
			muta_desc = "You stop regenerating.";
#endif

			break;
		case 180: case 181:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ESP;
#ifdef JP
muta_desc = "epV[̔\͂I";
#else
			muta_desc = "You lose your telepathic ability!";
#endif

			break;
		case 182: case 183: case 184:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_LIMBER;
#ifdef JP
muta_desc = "ؓdȂB";
#else
			muta_desc = "Your muscles stiffen.";
#endif

			break;
		case 185: case 186: case 187:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_ARTHRITIS;
#ifdef JP
muta_desc = "֐߂ɂȂȂB";
#else
			muta_desc = "Your joints stop hurting.";
#endif

			break;
		case 188:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_BAD_LUCK;
#ifdef JP
muta_desc = "I[͉QďB";
#else
			muta_desc = "Your black aura swirls and fades.";
#endif

			break;
		case 189:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_VULN_ELEM;
#ifdef JP
muta_desc = "hȊ͂ȂȂB";
#else
			muta_desc = "You feel less exposed.";
#endif

			break;
		case 190: case 191: case 192:
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_MOTION;
#ifdef JP
muta_desc = "̐mȂȂB";
#else
			muta_desc = "You move with less assurance.";
#endif

			break;
		case 193:
			if (cr_ptr->chara_idx == CHARA_LUCKY) break;
			muta_class = &(cr_ptr->flags14);
			muta_which = CF_GOOD_LUCK;
#ifdef JP
muta_desc = "I[͋PďB";
#else
			muta_desc = "Your white aura shimmers and fades.";
#endif

			break;
		default:
			muta_class = NULL;
			muta_which = 0;
		}

		if (muta_class && muta_which)
		{
			if (*(muta_class) & muta_which)
			{
				muta_chosen = TRUE;
			}
		}
		if (muta_chosen == TRUE) break;
	}

	if (!muta_chosen)
	{
		return FALSE;
	}
	else
	{
		msg_print(muta_desc);
		*(muta_class) &= ~(muta_which);

		cr_ptr->creature_update |= CRU_BONUS;
		handle_stuff();
		cr_ptr->mutant_regenerate_mod = calc_mutant_regenerate_mod(cr_ptr);
		return TRUE;
	}
}


void dump_mutations(creature_type *cr_ptr, FILE *OutFile)
{
	if (!OutFile) return;

	if (cr_ptr->flags12)
	{
		if (has_cf_creature(cr_ptr, CF_SPIT_ACID))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎_𐁂邱ƂłB(_[W xX1)\n");
#else
			fprintf(OutFile, " You can spit acid (dam lvl).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BR_FIRE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͉̃uXfƂłB(_[W xX2)\n");
#else
			fprintf(OutFile, " You can breathe fire (dam lvl * 2).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_HYPN_GAZE))
		{
#ifdef JP
fprintf(OutFile, " Ȃɂ݂͍ÖʂB\n");
#else
			fprintf(OutFile, " Your gaze is hypnotic.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_TELEKINES))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͔O͂ĂB\n");
#else
			fprintf(OutFile, " You are telekinetic.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_VTELEPORT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎̈ӎvŃe|[głB\n");
#else
			fprintf(OutFile, " You can teleport at will.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_MIND_BLST))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͓G𐸐_UłB\n");
#else
			fprintf(OutFile, " You can Mind Blast your enemies.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_RADIATION))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎̈ӎvŕ˔\𔭐邱ƂłB\n");
#else
			fprintf(OutFile, " You can emit hard radiation at will.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_VAMPIRISM))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͋zŜ悤ɓG琶͂z邱ƂłB\n");
#else
			fprintf(OutFile, " You can drain life from a foe like a vampire.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SMELL_MET))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͋߂ɂM邱ƂłB\n");
#else
			fprintf(OutFile, " You can smell nearby precious metal.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SMELL_MON))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͋߂̃X^[݂̑邱ƂłB\n");
#else
			fprintf(OutFile, " You can smell nearby monsters.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BLINK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͒Ze|[głB\n");
#else
			fprintf(OutFile, " You can teleport yourself short distances.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_EAT_ROCK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͍dHׂ邱ƂłB\n");
#else
			fprintf(OutFile, " You can consume solid rock.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SWAP_POS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͑̎҂Əꏊւ邱ƂłB\n");
#else
			fprintf(OutFile, " You can switch locations with another being.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SHRIEK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͐g̖т悾ѐ𔭂邱ƂłB\n");
#else
			fprintf(OutFile, " You can emit a horrible shriek.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ILLUMINE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͖邢ƂłB\n");
#else
			fprintf(OutFile, " You can emit bright light.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_DET_CURSE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎׈Ȗ@̊댯Ƃ邱ƂłB\n");
#else
			fprintf(OutFile, " You can feel the danger of evil magic.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BERSERK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎̈ӎvŋ퓬ԂɂȂ邱ƂłB\n");
#else
			fprintf(OutFile, " You can drive yourself into a berserk frenzy.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_POLYMORPH))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎̈ӎuŕωłB\n");
#else
			fprintf(OutFile, " You can polymorph yourself at will.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_MIDAS_TCH))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͒ʏACeɕς邱ƂłB\n");
#else
			fprintf(OutFile, " You can turn ordinary items to gold.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_GROW_MOLD))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎͂ɃLmR𐶂₷ƂłB\n");
#else
			fprintf(OutFile, " You can cause mold to grow near you.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_RESIST))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͌f̍Uɑ΂Đgd邱ƂłB\n");
#else
			fprintf(OutFile, " You can harden yourself to the ravages of the elements.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_EARTHQUAKE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎͂̃_W󂳂邱ƂłB\n");
#else
			fprintf(OutFile, " You can bring down the dungeon around your ears.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_EAT_MAGIC))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͖@̃GlM[̕ƂĎgpłB\n");
#else
			fprintf(OutFile, " You can consume magic energy for your own use.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WEIGH_MAG))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎ɉe^閂@̗͂邱ƂłB\n");
#else
			fprintf(OutFile, " You can feel the strength of the magics affecting you.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_STERILITY))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͏WcIBs\NƂłB\n");
#else
			fprintf(OutFile, " You can cause mass impotence.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_PANIC_HIT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͍Ug邽ߓ邱ƂłB\n");
#else
			fprintf(OutFile, " You can run for your life after hitting something.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_DAZZLE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͍ƖӖڂN˔\𔭐邱ƂłB \n");
#else
			fprintf(OutFile, " You can emit confusing, blinding radiation.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_LASER_EYE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͖ڂ烌[U[𔭎˂邱ƂłB\n");
#else
			fprintf(OutFile, " Your eyes can fire laser beams.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_RECALL))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͊Xƃ_W̊Ԃs邱ƂłB\n");
#else
			fprintf(OutFile, " You can travel between town and the depths.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BANISH))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎׈ȃX^[nɗƂƂłB\n");
#else
			fprintf(OutFile, " You can send evil creatures directly to Hell.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_COLD_TOUCH))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͕Gē点邱ƂłB\n");
#else
			fprintf(OutFile, " You can freeze things with a touch.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_LAUNCHER))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓ACe͋邱ƂłB\n");
#else
			fprintf(OutFile, " You can hurl objects with great force.\n");
#endif

		}
	}

	if (cr_ptr->flags13)
	{
		if (has_cf_creature(cr_ptr, CF_BERS_RAGE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͋m̔NB\n");
#else
			fprintf(OutFile, " You are subject to berserker fits.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_COWARDICE))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎XaɂȂB\n");
#else
			fprintf(OutFile, " You are subject to cowardice.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_RTELEPORT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓_Ƀe|[gB\n");
#else
			fprintf(OutFile, " You are teleporting randomly.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ALCOHOL))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̑̂̓AR[𕪔傷B\n");
#else
			fprintf(OutFile, " Your body produces alcohol.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_HALLU))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͌oN_ɐNĂB\n");
#else
			fprintf(OutFile, " You have a hallucinatory insanity.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_FLATULENT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͐łȂțB\n");
#else
			fprintf(OutFile, " You are subject to uncontrollable flatulence.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_PROD_MANA))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͐s\Ȗ@̃GlM[𔭂ĂB\n");
#else
			fprintf(OutFile, " You are producing magical energy uncontrollably.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ATT_DEMON))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓f[B\n");
#else
			fprintf(OutFile, " You attract demons.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SCOR_TAIL))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓T\̐KĂB(ŁA_[W 3d7)\n");
#else
			fprintf(OutFile, " You have a scorpion tail (poison, 3d7).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_HORNS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͊pĂB(_[W 2d6)\n");
#else
			fprintf(OutFile, " You have horns (dam. 2d6).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BEAK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓N`oVĂB(_[W 2d4)\n");
#else
			fprintf(OutFile, " You have a beak (dam. 2d4).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SPEED_FLUX))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓_ɑx肷B\n");
#else
			fprintf(OutFile, " You move faster or slower randomly.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BANISH_ALL))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎X߂̃X^[łB\n");
#else
			fprintf(OutFile, " You sometimes cause nearby creatures to vanish.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_EAT_LIGHT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎X͂̌zĉh{ɂB\n");
#else
			fprintf(OutFile, " You sometimes feed off of the light around you.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_TRUNK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͏ۂ̂悤ȕ@ĂB(_[W 1d4)\n");
#else
			fprintf(OutFile, " You have an elephantine trunk (dam 1d4).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ATT_ANIMAL))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͓B\n");
#else
			fprintf(OutFile, " You attract animals.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_TENTACLES))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎׈ȐGĂB(_[W 2d5)\n");
#else
			fprintf(OutFile, " You have evil looking tentacles (dam 2d5).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_RAW_CHAOS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͂΂ΏJIXɕ܂B\n");
#else
			fprintf(OutFile, " You occasionally are surrounded with raw chaos.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_NORMALITY))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͕ψقĂA񕜂ĂĂB\n");
#else
			fprintf(OutFile, " You may be mutated, but you're recovering.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WRAITH))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓̂͗H̉̉肷B\n");
#else
			fprintf(OutFile, " You fade in and out of physical reality.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_POLY_WOUND))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̌N̓JIX̗͂ɉe󂯂B\n");
#else
			fprintf(OutFile, " Your health is subject to chaotic forces.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WASTING))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͐シ鋰낵aCɂĂB\n");
#else
			fprintf(OutFile, " You have a horrible wasting disease.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ATT_DRAGON))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓hSB\n");
#else
			fprintf(OutFile, " You attract dragons.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WEIRD_MIND))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̐_̓_Ɋg債k肵ĂB\n");
#else
			fprintf(OutFile, " Your mind randomly expands and contracts.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_NAUSEA))
		{
#ifdef JP
fprintf(OutFile, " Ȃ݂͔̈ɗȂB\n");
#else
			fprintf(OutFile, " You have a seriously upset stomach.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_CHAOS_GIFT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓JIX̎숫JƂB\n");
#else
			fprintf(OutFile, " Chaos deities give you gifts.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WALK_SHAD))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͂΂ΆuevɖށB\n");
#else
			fprintf(OutFile, " You occasionally stumble into other shadows.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WARNING))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͓GɊւxB\n");
#else
			fprintf(OutFile, " You receive warnings about your foes.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_INVULN))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎Xm炸ȋCɂȂB\n");
#else
			fprintf(OutFile, " You occasionally feel invincible.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SP_TO_HP))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎XؓɂǂƗB\n");
#else
			fprintf(OutFile, " Your blood sometimes rushes to your muscles.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_HP_TO_SP))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͎XɌǂƗB\n");
#else
			fprintf(OutFile, " Your blood sometimes rushes to your head.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_DISARM))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͂悭܂Âĕ𗎂ƂB\n");
#else
			fprintf(OutFile, " You occasionally stumble and drop things.\n");
#endif

		}
	}

	if (cr_ptr->flags14)
	{
		if (has_cf_creature(cr_ptr, CF_HYPER_STR))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͒lIɋB(r+4)\n");
#else
			fprintf(OutFile, " You are superhumanly strong (+4 STR).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_PUNY))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͋ゾB(r-4)\n");
#else
			fprintf(OutFile, " You are puny (-4 STR).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_HYPER_INT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̔]͐̃Rs[^B(m\+4)\n");
#else
			fprintf(OutFile, " Your brain is a living computer (+4 INT/WIS).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_MORONIC))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͐_ゾB(m\-4)\n");
#else
			fprintf(OutFile, " You are moronic (-4 INT/WIS).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_RESILIENT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̑̂͒e͐ɕxłB(ϋv+4)\n");
#else
			fprintf(OutFile, " You are very resilient (+4 CON).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_XTRA_FAT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͋ɒ[ɑĂB(ϋv+2,Xs[h-2)\n");
#else
			fprintf(OutFile, " You are extremely fat (+2 CON, -2 speed).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ALBINO))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓ArmB(ϋv-4)\n");
#else
			fprintf(OutFile, " You are albino (-4 CON).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_FLESH_ROT))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͕̓̂sĂB(ϋv-2,-1)\n");
#else
			fprintf(OutFile, " Your flesh is rotting (-2 CON, -1 CHR).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SILLY_VOI))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̐͊ԔȃL[L[B(-4)\n");
#else
			fprintf(OutFile, " Your voice is a silly squeak (-4 CHR).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BLANK_FAC))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͂̂؂ڂB(-1)\n");
#else
			fprintf(OutFile, " Your face is featureless (-1 CHR).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ILL_NORM))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͌eɕĂB\n");
#else
			fprintf(OutFile, " Your appearance is masked with illusion.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_XTRA_EYES))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͗]ɓ̖ڂĂB(T+15)\n");
#else
			fprintf(OutFile, " You have an extra pair of eyes (+15 search).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_MAGIC_RES))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͖@ւ̑ϐĂB\n");
#else
			fprintf(OutFile, " You are resistant to magic.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_XTRA_NOIS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͕ςȉ𔭂ĂB(B-3)\n");
#else
			fprintf(OutFile, " You make a lot of strange noise (-3 stealth).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_INFRAVIS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͑f炵ԊO͂ĂB(+3)\n");
#else
			fprintf(OutFile, " You have remarkable infravision (+3).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_XTRA_LEGS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͗]ɓ{̑ĂB(+3)\n");
#else
			fprintf(OutFile, " You have an extra pair of legs (+3 speed).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SHORT_LEG))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̑͒ZˋNB(-3)\n");
#else
			fprintf(OutFile, " Your legs are short stubs (-3 speed).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ELEC_TOUC))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̌ǂɂ͓dĂB\n");
#else
			fprintf(OutFile, " Electricity is running through your veins.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_FIRE_BODY))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͉̑̂ɂ܂ĂB\n");
#else
			fprintf(OutFile, " Your body is enveloped in flames.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WART_SKIN))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̔̓C{ɔĂB(-2, AC+5)\n");
#else
			fprintf(OutFile, " Your skin is covered with warts (-2 CHR, +5 AC).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_SCALES))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̔͗؂ɂȂĂB(-1, AC+10)\n");
#else
			fprintf(OutFile, " Your skin has turned into scales (-1 CHR, +10 AC).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_IRON_SKIN))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͓̔SłłĂB(p-1, AC+25)\n");
#else
			fprintf(OutFile, " Your skin is made of steel (-1 DEX, +25 AC).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_WINGS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͉HĂB\n");
#else
			fprintf(OutFile, " You have wings.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_FEARLESS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͑S|ȂB\n");
#else
			fprintf(OutFile, " You are completely fearless.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_REGEN))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͋}ɉ񕜂B\n");
#else
			fprintf(OutFile, " You are regenerating.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ESP))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓epV[ĂB\n");
#else
			fprintf(OutFile, " You are telepathic.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_LIMBER))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͔̑̂ɂȂ₩B(p+3)\n");
#else
			fprintf(OutFile, " Your body is very limber (+3 DEX).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_ARTHRITIS))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͂֐߂ɒɂ݂ĂB(p-3)\n");
#else
			fprintf(OutFile, " Your joints ache constantly (-3 DEX).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_VULN_ELEM))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͌f̍UɎアB\n");
#else
			fprintf(OutFile, " You are susceptible to damage from the elements.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_MOTION))
		{
#ifdef JP
fprintf(OutFile, " Ȃ̓͐mŗ͋B(B+1)\n");
#else
			fprintf(OutFile, " Your movements are precise and forceful (+1 STL).\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_GOOD_LUCK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͔I[ɂ܂ĂB\n");
#else
			fprintf(OutFile, " There is a white aura surrounding you.\n");
#endif

		}
		if (has_cf_creature(cr_ptr, CF_BAD_LUCK))
		{
#ifdef JP
fprintf(OutFile, " Ȃ͍I[ɂ܂ĂB\n");
#else
			fprintf(OutFile, " There is a black aura surrounding you.\n");
#endif

		}
	}
}


/*
 * List mutations we have...
 */
void do_cmd_knowledge_mutations(creature_type *cr_ptr)
{
	FILE *fff;
	char file_name[1024];

	/* Open a new file */
	fff = my_fopen_temp(file_name, 1024);

	/* Dump the mutations to file */
	if (fff) dump_mutations(cr_ptr, fff);

	/* Close the file */
	my_fclose(fff);

	/* Display the file contents */
#ifdef JP
    show_file(TRUE, file_name, "ˑRψ", 0, 0);
#else
	show_file(TRUE, file_name, "Mutations", 0, 0);
#endif


	/* Remove the file */
	fd_kill(file_name);
}


int count_bits(u32b x)
{
	int n = 0;

	if (x) do
	{
		n++;
	}
	while (0 != (x = x&(x-1)));

	return (n);
}


static int count_mutations(creature_type *cr_ptr)
{
	return (count_bits(cr_ptr->flags12) +
		count_bits(cr_ptr->flags13) +
		count_bits(cr_ptr->flags14));
}


/*
 * Return the modifier to the regeneration rate
 * (in percent)
 */
int calc_mutant_regenerate_mod(creature_type *cr_ptr)
{
	int regen;
	int mod = 10;
	int count = count_mutations(cr_ptr);

	/*
	 * Beastman get 10 "free" mutations and
	 * only 5% decrease per additional mutation
	 */

	if (cr_ptr->chara_idx == CHARA_LUCKY) count--;
	if (cr_ptr->race_idx1 == RACE_BEASTMAN)
	{
		count -= 10;
		mod = 5;
	}

	/* No negative modifier */
	if (count <= 0) return 100;

	regen = 100 - count * mod;

	/* Max. 90% decrease in regeneration speed */
	if (regen < 10) regen = 10;

	return (regen);
}


void mutation_stop_mouth(creature_type *cr_ptr)
{
	if (music_singing_any(cr_ptr)) stop_singing(cr_ptr);
	if (hex_spelling_any(cr_ptr)) stop_hex_spell_all(cr_ptr);
}


bool mutation_power_aux(creature_type *creature_ptr, u32b power)
{
	int     dir = 0;
	int     lvl = creature_ptr->lev;
	floor_type *floor_ptr = get_floor_ptr(creature_ptr);

	switch (power)
	{
		case CF_SPIT_ACID:
			if (!get_aim_dir(creature_ptr, &dir)) return FALSE;
			mutation_stop_mouth(creature_ptr);
#ifdef JP
			msg_print("_f...");
#else
			msg_print("You spit acid...");
#endif

			fire_ball(creature_ptr, GF_ACID, dir, lvl, 1 + (lvl / 30));
			break;

		case CF_BR_FIRE:
			if (!get_aim_dir(creature_ptr, &dir)) return FALSE;
			mutation_stop_mouth(creature_ptr);
#ifdef JP
			msg_print("Ȃ͉Ή̃uXf...");
#else
			msg_print("You breathe fire...");
#endif

			fire_ball(creature_ptr, GF_FIRE, dir, lvl * 2, 1 + (lvl / 20));
			break;

		case CF_HYPN_GAZE:
			if (!get_aim_dir(creature_ptr, &dir)) return FALSE;
#ifdef JP
			msg_print("Ȃ̖ڂ͌fIɂȂ...");
#else
			msg_print("Your eyes look mesmerizing...");
#endif

			(void)charm_creature(creature_ptr, dir, lvl);
			break;

		case CF_TELEKINES:
			if (!get_aim_dir(creature_ptr, &dir)) return FALSE;
#ifdef JP
			msg_print("WĂ...");
#else
			msg_print("You concentrate...");
#endif

			fetch(creature_ptr, dir, lvl * 10, TRUE);
			break;

		case CF_VTELEPORT:
#ifdef JP
			msg_print("WĂ...");
#else
			msg_print("You concentrate...");
#endif

			teleport_player(creature_ptr, 10 + 4 * lvl, 0L);
			break;

		case CF_MIND_BLST:
			if (!get_aim_dir(creature_ptr, &dir)) return FALSE;
#ifdef JP
			msg_print("WĂ...");
#else
			msg_print("You concentrate...");
#endif

			fire_bolt(creature_ptr, GF_PSI, dir, diceroll(3 + ((lvl - 1) / 5), 3));
			break;

		case CF_RADIATION:
#ifdef JP
			msg_print("̂˔\I");
#else
			msg_print("Radiation flows from your body!");
#endif

			fire_ball(creature_ptr, GF_NUKE, 0, (lvl * 2), 3 + (lvl / 20));
			break;

		case CF_VAMPIRISM:
			{
				int x, y, dummy;
				cave_type *c_ptr;

				/* Only works on adjacent monsters */
				if (!get_rep_dir2(creature_ptr, &dir)) return FALSE;
				y = creature_ptr->fy + ddy[dir];
				x = creature_ptr->fx + ddx[dir];
				c_ptr = &floor_ptr->cave[y][x];

				mutation_stop_mouth(creature_ptr);

				if (!(c_ptr->creature_idx))
				{
#ifdef JP
					msg_print("ȂꏊɊ݂I");
#else
					msg_print("You bite into thin air!");
#endif

					break;
				}

#ifdef JP
				msg_print("Ȃ̓jƂĉނ...");
#else
				msg_print("You grin and bare your fangs...");
#endif


				dummy = lvl * 2;

				if (drain_life(creature_ptr, dir, dummy))
				{
					if (creature_ptr->food < PY_FOOD_FULL)
						/* No heal if we are "full" */
						(void)hp_player(creature_ptr, dummy);
					else
#ifdef JP
						msg_print("Ȃ͋󕠂ł͂܂B");
#else
						msg_print("You were not hungry.");
#endif

					/* Gain nutritional sustenance: 150/hp drained */
					/* A Food ration gives 5000 food points (by contrast) */
					/* Don't ever get more than "Full" this way */
					/* But if we ARE Gorged,  it won't cure us */
					dummy = creature_ptr->food + MIN(5000, 100 * dummy);
					if (creature_ptr->food < PY_FOOD_MAX)   /* Not gorged already */
						(void)set_food(creature_ptr, dummy >= PY_FOOD_MAX ? PY_FOOD_MAX-1 : dummy);
				}
				else
#ifdef JP
					msg_print("IЂǂB");
#else
					msg_print("Yechh. That tastes foul.");
#endif

			}
			break;

		case CF_SMELL_MET:
			mutation_stop_mouth(creature_ptr);
			(void)detect_treasure(creature_ptr, DETECT_RAD_DEFAULT);
			break;

		case CF_SMELL_MON:
			mutation_stop_mouth(creature_ptr);
			(void)detect_monsters_normal(creature_ptr, DETECT_RAD_DEFAULT);
			break;

		case CF_BLINK:
			teleport_player(creature_ptr, 10, 0L);
			break;

		case CF_EAT_ROCK:
			{
				int x, y;
				cave_type *c_ptr;
				feature_type *f_ptr, *mimic_f_ptr;

				if (!get_rep_dir2(creature_ptr,&dir)) return FALSE;
				y = creature_ptr->fy + ddy[dir];
				x = creature_ptr->fx + ddx[dir];
				c_ptr = &floor_ptr->cave[y][x];
				f_ptr = &feature_info[c_ptr->feat];
				mimic_f_ptr = &feature_info[get_feat_mimic(c_ptr)];

				mutation_stop_mouth(creature_ptr);

				if (!have_flag(mimic_f_ptr->flags, FF_HURT_ROCK))
				{
#ifdef JP
					msg_print("̒n`͐HׂȂB");
#else
					msg_print("You cannot eat this feature.");
#endif
					break;
				}
				else if (have_flag(f_ptr->flags, FF_PERMANENT))
				{
#ifdef JP
					msg_format("ĂI%s͂Ȃ̎dI", feature_name + mimic_f_ptr->name);
#else
					msg_format("Ouch!  This %s is harder than your teeth!", feature_name + mimic_f_ptr->name);
#endif
					break;
				}
				else if (c_ptr->creature_idx)
				{
					creature_type *m_ptr = &creature_list[c_ptr->creature_idx];
#ifdef JP
					msg_print("זĂ܂I");
#else
					msg_print("There's something in the way!");
#endif

					if (!m_ptr->ml || !is_pet(player_ptr, m_ptr)) melee_attack(creature_ptr, y, x, 0);
					break;
				}
				else if (have_flag(f_ptr->flags, FF_TREE))
				{
#ifdef JP
					msg_print("؂̖͍DȂI");
#else
					msg_print("You don't like the woody taste!");
#endif
					break;
				}
				else if (have_flag(f_ptr->flags, FF_GLASS))
				{
#ifdef JP
					msg_print("KX̖͍DȂI");
#else
					msg_print("You don't like the glassy taste!");
#endif
					break;
				}
				else if (have_flag(f_ptr->flags, FF_DOOR) || have_flag(f_ptr->flags, FF_CAN_DIG))
				{
					(void)set_food(creature_ptr, creature_ptr->food + 3000);
				}
				else if (have_flag(f_ptr->flags, FF_MAY_HAVE_GOLD) || have_flag(f_ptr->flags, FF_HAS_GOLD))
				{
					(void)set_food(creature_ptr, creature_ptr->food + 5000);
				}
				else
				{
#ifdef JP
					msg_format("%s͂ƂĂI", feature_name + mimic_f_ptr->name);
#else
					msg_format("This %s is very filling!", feature_name + mimic_f_ptr->name);
#endif
					(void)set_food(creature_ptr, creature_ptr->food + 10000);
				}

				/* Destroy the wall */
				cave_alter_feat(floor_ptr, y, x, FF_HURT_ROCK);

				/* Move the player */
				(void)move_creature_effect(creature_ptr, y, x, MPE_DONT_PICKUP);
			}
			break;

		case CF_SWAP_POS:
			project_length = -1;
			if (!get_aim_dir(creature_ptr, &dir))
			{
				project_length = 0;
				return FALSE;
			}
			(void)teleport_swap(creature_ptr, dir);
			project_length = 0;
			break;

		case CF_SHRIEK:
			mutation_stop_mouth(creature_ptr);
			(void)fire_ball(creature_ptr, GF_SOUND, 0, 2 * lvl, 8);
			(void)aggravate_creatures(creature_ptr);
			break;

		case CF_ILLUMINE:
			(void)lite_area(creature_ptr, diceroll(2, (lvl / 2)), (lvl / 10) + 1);
			break;

		case CF_DET_CURSE:
			{
				int i;

				for (i = 0; i < INVEN_TOTAL; i++)
				{
					object_type *o_ptr = &creature_ptr->inventory[i];

					if (!o_ptr->k_idx) continue;
					if (!object_is_cursed(o_ptr)) continue;

					o_ptr->feeling = FEEL_CURSED;
				}
			}
			break;

		case CF_BERSERK:
			(void)set_shero(creature_ptr, randint1(25) + 25, FALSE);
			(void)hp_player(creature_ptr, 30);
			(void)set_afraid(creature_ptr, 0);
			break;

		case CF_POLYMORPH:
#ifdef JP
			if (!get_check("ϐg܂B낵łH")) return FALSE;
#else
			if (!get_check("You will polymorph your self. Are you sure? ")) return FALSE;
#endif
			do_poly_self(creature_ptr);
			break;

		case CF_MIDAS_TCH:
			if (!alchemy(creature_ptr)) return FALSE;
			break;

		/* Summon pet molds around the player */
		case CF_GROW_MOLD:
			{
				int i;
				for (i = 0; i < 8; i++)
				{
					summon_specific(NULL, creature_ptr->fy, creature_ptr->fx, lvl, SUMMON_BIZARRE1, PM_FORCE_PET);
				}
			}
			break;

		case CF_RESIST:
			{
				int num = lvl / 10;
				int dur = randint1(20) + 20;

				if (randint0(5) < num)
				{
					(void)set_oppose_acid(creature_ptr, dur, FALSE);
					num--;
				}
				if (randint0(4) < num)
				{
					(void)set_oppose_elec(creature_ptr, dur, FALSE);
					num--;
				}
				if (randint0(3) < num)
				{
					(void)set_oppose_fire(creature_ptr, dur, FALSE);
					num--;
				}
				if (randint0(2) < num)
				{
					(void)set_oppose_cold(creature_ptr, dur, FALSE);
					num--;
				}
				if (num)
				{
					(void)set_oppose_pois(creature_ptr, dur, FALSE);
					num--;
				}
			}
			break;

		case CF_EARTHQUAKE:
			(void)earthquake(creature_ptr, creature_ptr->fy, creature_ptr->fx, 10);
			break;

		case CF_EAT_MAGIC:
			if (!eat_magic(creature_ptr, creature_ptr->lev * 2)) return FALSE;
			break;

		case CF_WEIGH_MAG:
			report_magics(creature_ptr);
			break;

		case CF_STERILITY:
			/* Fake a population explosion. */
#ifdef JP
			msg_print("ˑRɂȂI");
			take_hit(NULL, creature_ptr, DAMAGE_LOSELIFE, randint1(17) + 17, "֗~J", NULL, -1);
#else
			msg_print("You suddenly have a headache!");
			take_hit(NULL, creature_ptr, DAMAGE_LOSELIFE, randint1(17) + 17, "the strain of forcing abstinence", NULL, -1);
#endif

			floor_ptr->num_repro += MAX_REPRO;
			break;

		case CF_PANIC_HIT:
			{
				int x, y;

				if (!get_rep_dir2(creature_ptr,&dir)) return FALSE;
				y = creature_ptr->fy + ddy[dir];
				x = creature_ptr->fx + ddx[dir];
				if (floor_ptr->cave[y][x].creature_idx)
				{
					melee_attack(creature_ptr, y, x, 0);
					if (randint0(creature_ptr->skill_dis) < 7)
#ifdef JP
						msg_print("܂ȂB");
#else
						msg_print("You failed to teleport.");
#endif
					else teleport_player(creature_ptr, 30, 0L);
				}
				else
				{
#ifdef JP
					msg_print("̕ɂ̓X^[͂܂B");
#else
					msg_print("You don't see any monster in this direction");
#endif

					msg_print(NULL);
				}
			}
			break;

		case CF_DAZZLE:
			stun_creatures(creature_ptr, lvl * 4);
			confuse_creatures(creature_ptr, lvl * 4);
			turn_creatures(creature_ptr, lvl * 4);
			break;

		case CF_LASER_EYE:
			if (!get_aim_dir(creature_ptr, &dir)) return FALSE;
			fire_beam(creature_ptr, GF_LITE, dir, 2 * lvl);
			break;

		case CF_RECALL:
			if (!word_of_recall(creature_ptr)) return FALSE;
			break;

		case CF_BANISH:
			{
				int x, y;
				cave_type *c_ptr;
				creature_type *m_ptr;
				species_type *r_ptr;

				if (!get_rep_dir2(creature_ptr, &dir)) return FALSE;
				y = creature_ptr->fy + ddy[dir];
				x = creature_ptr->fx + ddx[dir];
				c_ptr = &floor_ptr->cave[y][x];

				if (!c_ptr->creature_idx)
				{
#ifdef JP
					msg_print("׈ȑ݂Ƃ܂I");
#else
					msg_print("You sense no evil there!");
#endif

					break;
				}

				m_ptr = &creature_list[c_ptr->creature_idx];
				r_ptr = &species_info[m_ptr->species_idx];

				if (is_enemy_of_good_species(r_ptr) &&
				    !(is_quest_species(r_ptr)) &&
				    !(is_unique_species(r_ptr)) &&
				    !fight_arena_mode && !inside_quest &&
					(r_ptr->level < randint1(creature_ptr->lev+50)) &&
					!(m_ptr->mflag2 & MFLAG2_NOGENO))
				{
					if (record_named_pet && is_pet(player_ptr, m_ptr) && m_ptr->nickname)
					{
						char m_name[80];

						creature_desc(m_name, m_ptr, MD_INDEF_VISIBLE);
						do_cmd_write_nikki(NIKKI_NAMED_PET, RECORD_NAMED_PET_GENOCIDE, m_name);
					}

					/* Delete the monster, rather than killing it. */
					delete_species_idx(&creature_list[c_ptr->creature_idx]);
#ifdef JP
					msg_print("̎׈ȃX^[͗LƂƂɏI");
#else
					msg_print("The evil creature vanishes in a puff of sulfurous smoke!");
#endif

				}
				else
				{
#ifdef JP
					msg_print("F͌ʂȂI");
#else
					msg_print("Your invocation is ineffectual!");
#endif

					if (one_in_(13)) m_ptr->mflag2 |= MFLAG2_NOGENO;
				}
			}
			break;

		case CF_COLD_TOUCH:
			{
				int x, y;
				cave_type *c_ptr;

				if (!get_rep_dir2(creature_ptr, &dir)) return FALSE;
				y = creature_ptr->fy + ddy[dir];
				x = creature_ptr->fx + ddx[dir];
				c_ptr = &floor_ptr->cave[y][x];

				if (!c_ptr->creature_idx)
				{
#ifdef JP
					msg_print("Ȃ͉ȂꏊŎUB");
#else
					msg_print("You wave your hands in the air.");
#endif

					break;
				}
				fire_bolt(creature_ptr, GF_COLD, dir, 2 * lvl);
			}
			break;

		/* XXX_XXX_XXX Hack!  CF_LAUNCHER is negative, see above */
		case 3: /* CF_LAUNCHER */
			/* Gives a multiplier of 2 at first, up to 3 at 40th */
			if (!do_cmd_throw_aux(creature_ptr, 2 + lvl / 40, FALSE, 0)) return FALSE;
			break;

		default:
			energy_use = 0;
#ifdef JP
			msg_format("\ %s ͎Ă܂B", power);
#else
			msg_format("Power %s not implemented. Oops.", power);
#endif

	}

	return TRUE;
}
