/* Purpose: create a player character */

/* 2011 Deskull modified. */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"

/*
 * How often the autoroller will update the display and pause
 * to check for user interuptions.
 * Bigger values will make the autoroller faster, but slower
 * system may have problems because the user can't stop the
 * autoroller for this number of rolls.
 */
#define AUTOROLLER_STEP 5431L

/*
 * Forward declare
 */
typedef struct hist_type hist_type;

/*
 * Player background information
 */
struct hist_type
{
	cptr info;			    /* Textual History */

	byte roll;			    /* Frequency of this entry */
	byte chart;			    /* Chart index */
	byte next;			    /* Next chart index */
	byte bonus;			    /* Social Class Bonus + 50 */
};


/*
 * Background information (see below)
 *
 * Chart progression by race:
 *   Human         -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Elf      -->  4 -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Elf/High-Elf  -->  7 -->  8 -->  9 --> 54 --> 55 --> 56
 *   Hobbit        --> 10 --> 11 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Gnome         --> 13 --> 14 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Dwarf         --> 16 --> 17 --> 18 --> 57 --> 58 --> 59 --> 60 --> 61
 *   Half-Orc      --> 19 --> 20 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Troll    --> 22 --> 23 --> 62 --> 63 --> 64 --> 65 --> 66
 *
 *  This table *must* be correct or drastic errors may occur!
 */
static hist_type bg[] =
{
#ifdef JP
	{"̎qŔFm炳Ă܂B",			 10, 2, 3, 25},
	{"̎qłFm͂Ă܂B",			 20, 2, 3, 35},
	{"l̎q̂̈lłB",			 95, 2, 3, 45},
	{"qłB",						100, 2, 3, 50},
#else
	{"You are the illegitimate and unacknowledged child ", 10, 1, 2, 25},
	{"You are the illegitimate but acknowledged child ", 20, 1, 2, 35},
	{"You are one of several children ",       95, 1, 2, 45},
	{"You are the first child ",              100, 1, 2, 50},
#endif


#ifdef JP
	{"Ȃ͔_z",					 40, 1, 2, 65},
	{"Ȃ͎_",					 65, 1, 2, 80},
	{"Ȃ͒l",					 80, 1, 2, 90},
	{"Ȃ͐El",					 90, 1, 2,105},
	{"Ȃ͓y̋Rm",				 96, 1, 2,120},
	{"Ȃׂ͍̋{݈̎ʂM",				 99, 1, 2,130},
	{"Ȃ̓Ao[̉Ƃ̌҂",				100, 1, 2,140},
#else
	{"of a Serf.  ",                           40, 2, 3, 65},
	{"of a Yeoman.  ",                         65, 2, 3, 80},
	{"of a Townsman.  ",                       80, 2, 3, 90},
	{"of a Guildsman.  ",                      90, 2, 3, 105},
	{"of a Landed Knight.  ",                  96, 2, 3, 120},
	{"of a Noble Family in the Courts of Chaos.  ", 99, 2, 3, 130},
	{"of the Royal Blood Line of Amber.  ",   100, 2, 3, 140},
#endif


#ifdef JP
	{"Ȃ͈Ƃ̂וłB",				 20, 3,50, 20},
	{"Ȃ͈Ƃ̌ւłB",				 80, 3,50, 55},
	{"Ȃ͉Ƒɑ؂ɂĂ܂B",			100, 3,50, 60},
#else
	{"You are the black sheep of the family.  ", 20, 3, 50, 20},
	{"You are a credit to the family.  ",      80, 3, 50, 55},
	{"You are a well liked child.  ",         100, 3, 50, 60},
#endif


#ifdef JP
	{"Ȃ̓̕ẽGtłB",		 40, 4, 1, 50},
	{"Ȃ̓̕ẽGtłB",		 75, 4, 1, 55},
	{"Ȃ̓̕mh[̃GtłB",		 90, 4, 1, 55},
	{"Ȃ̓̕mh[̃GtłB",		 95, 4, 1, 60},
	{"Ȃ̓̕@[̃GtłB",		 98, 4, 1, 65},
	{"Ȃ̓̕@[̃GtłB",				100, 4, 1, 70},
#else
	{"Your mother was of the Teleri.  ",			 40, 4, 1, 50},
	{"Your father was of the Teleri.  ",			 75, 4, 1, 55},
	{"Your mother was of the Noldor.  ",		 	 90, 4, 1, 55},
	{"Your father was of the Noldor.  ",		 	 95, 4, 1, 60},
	{"Your mother was of the Vanyar.  ",			 98, 4, 1, 65},
	{"Your father was of the Vanyar.  ",			100, 4, 1, 70},
#endif


#ifdef JP
	{"l̎q̂̈lłB",			 60, 9, 54, 50},
	{"ꗱłB",					100, 9, 54, 55},
#else
	{"You are one of several children ",			 60, 7, 8, 50},
	{"You are the only child ",					100, 7, 8, 55},
#endif


#ifdef JP
	{"Ȃ̓ẽGt",				 75, 7, 8, 50},
	{"Ȃ̓mh[̃Gt",			 95, 7, 8, 55},
	{"Ȃ̓@[̃Gt",			100, 7, 8, 60},
#else
	{"of a Teleri ",						 75, 8, 9, 50},
	{"of a Noldor ",						 95, 8, 9, 55},
	{"of a Vanyar ",						100, 8, 9, 60},
#endif


#ifdef JP
	{"W[",					 40, 8,9, 80},
	{"A[`[",					 70, 8,9, 90},
	{"m",						 87, 8,9,110},
	{"CW",						 95, 8,9,125},
	{"q",						 99, 8,9,140},
	{"",						100, 8,9,145},
#else
	{"Ranger.  ",						 40, 9, 54, 80},
	{"Archer.  ",						 70, 9, 54, 90},
	{"Warrior.  ",						 87, 9, 54, 110},
	{"Mage.  ",							 95, 9, 54, 125},
	{"Prince.  ",						 99, 9, 54, 140},
	{"King.  ",							100, 9, 54, 145},
#endif


#ifdef JP
	{"zrbg̉l̎q̂̈lłB",		 85,11,3, 45},
	{"zrbg̈ꗱłB",			        100,11,3, 55},
#else
	{"You are one of several children of a Hobbit ",		 85, 10, 11, 45},
	{"You are the only child of a Hobbit ",		        100, 10, 11, 55},
#endif


#ifdef JP
	{"Ȃ͌H",							 20,10,11, 55},
	{"Ȃ͎̓X",						 30,10,11, 80},
	{"Ȃ͕",							 40,10,11, 90},
	{"Ȃ͉Ǝ",							 50,10,11,100},
	{"Ȃ͔Eт̎҂",							 80,10,11,110},
	{"Ȃ͐m",							 95,10,11,115},
	{"Ȃ̓CW",							 99,10,11,125},
	{"Ȃ͈ꑰ̒",							100,10,11,140},
#else
	{"Bum.  ",							 20, 11, 3, 55},
	{"Tavern Owner.  ",						 30, 11, 3, 80},
	{"Miller.  ",						 40, 11, 3, 90},
	{"Home Owner.  ",						 50, 11, 3, 100},
	{"Burglar.  ",						 80, 11, 3, 110},
	{"Warrior.  ",						 95, 11, 3, 115},
	{"Mage.  ",							 99, 11, 3, 125},
	{"Clan Elder.  ",						100, 11, 3, 140},
#endif


#ifdef JP
	{"m[̊l̎q̂̈lłB",		 85,14,3, 45},
	{"m[̈ꗱłB",			        100,14,3, 55},
#else
	{"You are one of several children of a Gnome ",		 85, 13, 14, 45},
	{"You are the only child of a Gnome ",			100, 13, 14, 55},
#endif


#ifdef JP
	{"Ȃ͕",							 20,13,14, 55},
	{"Ȃ̓z",							 50,13,14, 70},
	{"Ȃ͂q҂",							 75,13,14, 85},
	{"Ȃ͐m",							 95,13,14,100},
	{"Ȃ̓CW",							100,13,14,125},
#else
	{"Beggar.  ",						 20, 14, 3, 55},
	{"Braggart.  ",						 50, 14, 3, 70},
	{"Prankster.  ",						 75, 14, 3, 85},
	{"Warrior.  ",						 95, 14, 3, 100},
	{"Mage.  ",							100, 14, 3, 125},
#endif


#ifdef JP
	{"h[t̓l̎q̂̈lłB",		 25,17,18, 40},
	{"h[ẗꗱłB",			        100,17,18, 50},
#else
	{"You are one of two children of a Dwarven ",		 25, 16, 17, 40},
	{"You are the only child of a Dwarven ",			100, 16, 17, 50},
#endif


#ifdef JP
	{"Ȃ͓D_",							 10,16,17, 60},
	{"Ȃ͘SԂ",							 25,16,17, 75},
	{"Ȃ͍Bv",							 75,16,17, 90},
	{"Ȃ͐m",							 90,16,17,110},
	{"Ȃ̓v[Xg",					 99,16,17,130},
	{"Ȃ͉",							100,16,17,150},
#else
	{"Thief.  ",						 10, 17, 18, 60},
	{"Prison Guard.  ",						 25, 17, 18, 75},
	{"Miner.  ",						 75, 17, 18, 90},
	{"Warrior.  ",						 90, 17, 18, 110},
	{"Priest.  ",						 99, 17, 18, 130},
	{"King.  ",							100, 17, 18, 150},
#endif


#ifdef JP
	{"Ȃ͈Ƃ̂וłB",						 15,18,57,10},
	{"Ȃ͈Ƃ̌ւłB",						 85,18,57, 50},
	{"Ȃ͉Ƒɑ؂ɂĂ܂B",				100,18,57, 55},
#else
	{"You are the black sheep of the family.  ",		 15, 18, 57, 10},
	{"You are a credit to the family.  ",			 85, 18, 57, 50},
	{"You are a well liked child.  ",				100, 18, 57, 55},
#endif


#ifdef JP
	{"Ȃ̓̕I[NłA͔閧ɂĂ܂B",	 25,19,20, 25},
	{"Ȃ̓̕I[NłA͔閧ɂĂ܂B",	100,19,20, 25},
#else
	{"Your mother was an Orc, but it is unacknowledged.  ",	 25, 19, 20, 25},
	{"Your father was an Orc, but it is unacknowledged.  ",	100, 19, 20, 25},
#endif


#ifdef JP
	{"Ȃ͔_z̗{qłB",						 40,20, 3, 65},
	{"Ȃ͎_̗{qłB",						 65,20, 3, 80},
	{"Ȃ͒l̗{qłB",						 80,20, 3, 90},
	{"Ȃ͐El̗{qłB",						 90,20, 3,105},
	{"Ȃ͓y̋Rm̗{qłB",					 96,20, 3,120},
	{"Ȃ͎݈ʂM̗{qłB",				 99,20, 3,130},
	{"Ȃ͉Ƃ̌҂̗{qłB",			100,20, 3,140},
#else
	{"You are the adopted child ",				100, 20, 2, 50},
#endif


#ifdef JP
	{"Ȃ͓̕Ag",				 30,22,23, 20},
	{"Ȃ͓̕Ag",				 60,22,23, 25},
	{"Ȃ͋̕ug",					 75,22,23, 30},
	{"Ȃ͋̕ug",					 90,22,23, 35},
	{"Ȃ͐̕g",					 95,22,23, 40},
	{"Ȃ͐̕g",					100,22,23, 45},
#else
	{"Your mother was a Cave-Troll ",				 30, 22, 23, 20},
	{"Your father was a Cave-Troll ",				 60, 22, 23, 25},
	{"Your mother was a Hill-Troll ",				 75, 22, 23, 30},
	{"Your father was a Hill-Troll ",				 90, 22, 23, 35},
	{"Your mother was a Water-Troll ",				 95, 22, 23, 40},
	{"Your father was a Water-Troll ",				100, 22, 23, 45},
#endif


#ifdef JP
	{"RbNłB",							  5,23,62, 60},
	{"młB",							 95,23,62, 55},
	{"ptłB",							 99,23,62, 65},
	{"ꑰ̒łB",						100,23,62, 80},
#else
	{"Cook.  ",							  5, 23, 62, 60},
	{"Warrior.  ",						 95, 23, 62, 55},
	{"Shaman.  ",						 99, 23, 62, 65},
	{"Clan Chief.  ",						100, 23, 62, 80},
#endif


#ifdef JP
	{"Ȃ͐[uE̓",				 20,50,51, 50},
	{"Ȃ̓uE̓",					 60,50,51, 50},
	{"Ȃ͒WF̓",					 70,50,51, 50},
	{"Ȃ̓O[̓",					 80,50,51, 50},
	{"Ȃ͐",						 90,50,51, 50},
	{"Ȃ̓u[OC̓",				100,50,51, 50},
#else
	{"You have dark brown eyes, ",				 20, 50, 51, 50},
	{"You have brown eyes, ",					 60, 50, 51, 50},
	{"You have hazel eyes, ",					 70, 50, 51, 50},
	{"You have green eyes, ",					 80, 50, 51, 50},
	{"You have blue eyes, ",					 90, 50, 51, 50},
	{"You have blue-gray eyes, ",				100, 50, 51, 50},
#endif


#ifdef JP
	{"Ȃ߂炩",							 70,51,52, 50},
	{"gł",							 90,51,52, 50},
	{"J[",							100,51,52, 50},
#else
	{"straight ",						 70, 51, 52, 50},
	{"wavy ",							 90, 51, 52, 50},
	{"curly ",							100, 51, 52, 50},
#endif


#ifdef JP
	{"A",						 30,52,53, 50},
	{"A",						 70,52,53, 50},
	{"ƂѐF̔A",					 80,52,53, 50},
	{"ԂA",						 90,52,53, 50},
	{"uh̔A",				100,52,53, 50},
#else
	{"black hair, ",						 30, 52, 53, 50},
	{"brown hair, ",						 70, 52, 53, 50},
	{"auburn hair, ",						 80, 52, 53, 50},
	{"red hair, ",						 90, 52, 53, 50},
	{"blond hair, ",						100, 52, 53, 50},
#endif


#ifdef JP
	{"̔Ă܂B",					 10,53, 0, 50},
	{"Ă܂B",					 30,53, 0, 50},
	{"ʂ̔FĂ܂B",				 80,53, 0, 50},
	{"Ă܂B",					 90,53, 0, 50},
	{"ʂ悤ȔĂ܂B",		100,53, 0, 50},
#else
	{"and a very dark complexion.",				 10, 53, 0, 50},
	{"and a dark complexion.",					 30, 53, 0, 50},
	{"and an average complexion.",				 80, 53, 0, 50},
	{"and a fair complexion.",					 90, 53, 0, 50},
	{"and a very fair complexion.",				100, 53, 0, 50},
#endif


#ifdef JP
	{"Ȃ͖邢O[̓",					 85,54,55, 50},
	{"Ȃ͖邢u[̓",					 95,54,55, 50},
	{"Ȃ͖邢O[̓",					100,54,55, 50},
#else
	{"You have light grey eyes, ",				 85, 54, 55, 50},
	{"You have light blue eyes, ",				 95, 54, 55, 50},
	{"You have light green eyes, ",				100, 54, 55, 50},
#endif


#ifdef JP
	{"Ȃ߂炩",							 75,55,56, 50},
	{"gł",							100,55,56, 50},
#else
	{"straight ",						 75, 55, 56, 50},
	{"wavy ",							100, 55, 56, 50},
#endif


#ifdef JP
	{"AĂ܂B",				 75,56, 0, 50},
	{"AĂ܂B",				 85,56, 0, 50},
	{"uh̔AĂ܂B",				 95,56, 0, 50},
	{"┯AĂ܂B",				100,56, 0, 50},
#else
	{"black hair, and a fair complexion.",			 75, 56, 0, 50},
	{"brown hair, and a fair complexion.",			 85, 56, 0, 50},
	{"blond hair, and a fair complexion.",			 95, 56, 0, 50},
	{"silver hair, and a fair complexion.",			100, 56, 0, 50},
#endif


#ifdef JP
	{"Ȃ͐[uE̓",					 99,57,58, 50},
	{"Ȃ͋PԂ",					100,57,58, 60},
#else
	{"You have dark brown eyes, ",				 99, 57, 58, 50},
	{"You have glowing red eyes, ",				100, 57, 58, 60},
#endif


#ifdef JP
	{"Ȃ߂炩",							 90,58,59, 50},
	{"gł",							100,58,59, 50},
#else
	{"straight ",						 90, 58, 59, 50},
	{"wavy ",							100, 58, 59, 50},
#endif


#ifdef JP
	{"A",						 75,59,60, 50},
	{"A",						100,59,60, 50},
#else
	{"black hair, ",						 75, 59, 60, 50},
	{"brown hair, ",						100, 59, 60, 50},
#endif


#ifdef JP
	{" 30cm قǂ̃qQA",						 25,60,61, 50},
	{" 60cm قǂ̃qQA",						 60,60,61, 51},
	{" 90cm قǂ̃qQA",					 90,60,61, 53},
	{" 1m20cm قǂ̃qQA ",						100,60,61, 55},
#else
	{"a one foot beard, ",					 25, 60, 61, 50},
	{"a two foot beard, ",					 60, 60, 61, 51},
	{"a three foot beard, ",					 90, 60, 61, 53},
	{"a four foot beard, ",					100, 60, 61, 55},
#endif


#ifdef JP
	{"Ă܂B",					100,61, 0, 50},
#else
	{"and a dark complexion.",					100, 61, 0, 50},
#endif


#ifdef JP
	{"Ȃ̓xg悤ȗ΂̓",					 60,62,63, 50},
	{"Ȃ͉̂悤ȉF",					 85,62,63, 50},
	{"Ȃ͐",				 99,62,63, 50},
	{"Ȃ͋PԂ",					100,62,63, 55},
#else
	{"You have slime green eyes, ",				 60, 62, 63, 50},
	{"You have puke yellow eyes, ",				 85, 62, 63, 50},
	{"You have blue-bloodshot eyes, ",				 99, 62, 63, 50},
	{"You have glowing red eyes, ",				100, 62, 63, 55},
#endif


#ifdef JP
	{"炵",							 33,63,64, 50},
	{"s",							 66,63,64, 50},
	{"",							100,63,64, 50},
#else
	{"dirty ",							 33, 63, 64, 50},
	{"mangy ",							 66, 63, 64, 50},
	{"oily ",							100, 63, 64, 50},
#endif


#ifdef JP
	{"J̗lȔA",					 33,64,65, 50},
	{"邢ԐF̔A",						 66,64,65, 50},
	{"ÂF̔A",						100,64,65, 50},
#else
	{"sea-weed green hair, ",					 33, 64, 65, 50},
	{"bright red hair, ",					 66, 64, 65, 50},
	{"dark purple hair, ",					100, 64, 65, 50},
#endif


#ifdef JP
	{"ΐF",							 25,65,66, 50},
	{"",							 50,65,66, 50},
	{"",							 75,65,66, 50},
	{"",							100,65,66, 50},
#else
	{"and green ",						 25, 65, 66, 50},
	{"and blue ",						 50, 65, 66, 50},
	{"and white ",						 75, 65, 66, 50},
	{"and black ",						100, 65, 66, 50},
#endif


#ifdef JP
	{"ucucĂ܂B",						 33,66, 0, 50},
	{"JTu^炯̔Ă܂B",						 66,66, 0, 50},
	{"KTKT̔Ă܂B",						100,66, 0, 50},
#else
	{"ulcerous skin.",						 33, 66, 0, 50},
	{"scabby skin.",						 66, 66, 0, 50},
	{"leprous skin.",         100, 66, 0, 50},
#endif


#ifdef JP
	{"FmĂȂqłB", 50, 68, 50, 45},
	{"ꂽqłB", 80, 68, 50, 65},
	{"ĐʂꂽqłB", 100, 68, 50, 55},
#else
	{"You are an unacknowledged child of ", 50, 67, 68, 45},
	{"You are a rebel child of ", 80, 67, 68, 65},
	{"You are a long lost child of ", 100, 67, 68, 55},
#endif


#ifdef JP
	{"Ȃ͖̒mʃAo[̉", 50, 67, 68, 80 },
	{"Ȃ͑ÕAo[", 65, 67, 68, 90 },
	{"Ȃ͑񐢑̃Ao[", 79, 67, 68, 100 },
	{"Ȃ̓Ix", 80, 67, 68, 130 },
	{"Ȃ̓IYbN", 83, 67, 68, 105 },
	{"Ȃ̓tBh[", 84, 67, 68, 105 },
	{"Ȃ̓uh", 85, 67, 68, 90 },
	{"Ȃ̓t[", 87, 67, 68, 100 },
	{"Ȃ̓WF[h", 88, 67, 68, 125 },
	{"Ȃ̓fBAh", 89, 67, 68, 120 },
	{"Ȃ̓_", 90, 67, 68, 140 },
	{"Ȃ̓xlfBNg", 91, 67, 68, 115 },
	{"Ȃ̓R[EB", 92, 67, 68, 110 },
	{"Ȃ̓WA", 93, 67, 68, 105 },
	{"Ȃ̓PC", 94, 67, 68, 95 },
	{"Ȃ̓uCY", 95, 67, 68, 115 },
	{"Ȃ̓tBIi", 96, 67, 68, 110 },
	{"Ȃ̓GbN", 97, 67, 68, 135 },
	{"Ȃ̓ih", 98, 67, 68, 90 },
	{"Ȃ̓}[", 99, 67, 68, 105 },
	{"Ȃ̓}[eB", 100, 67,68, 80 },
#else
	{"an unknown Amberite.  ", 50, 68, 50, 80 },
	{"an unknown third generation Amberite.  ", 65, 68, 50, 90 },
	{"an unknown second generation Amberite.  ", 79, 68, 50, 100 },
	{"Oberon.  ", 80, 68, 50, 130 },
	{"Osric.  ", 83, 68, 50, 105 },
	{"Finndo.  ", 84, 68, 50, 105 },
	{"Brand.  ", 85, 68, 50, 90 },
	{"Flora.  ", 87, 68, 50, 100 },
	{"Gerard.  ", 88, 68, 50, 125 },
	{"Deirdre.  ", 89, 68, 50, 120 },
	{"Random.  ", 90, 68, 50, 140 },
	{"Benedict.  ", 91, 68, 50, 115 },
	{"Corwin.  ", 92, 68, 50, 110 },
	{"Julian.  ", 93, 68, 50, 105 },
	{"Caine.  ", 94, 68, 50, 95 },
	{"Bleys.  ", 95, 68, 50, 115 },
	{"Fiona.  ", 96, 68, 50, 110 },
	{"Eric.  ", 97, 68, 50, 135 },
	{"Rinaldo.  ", 98, 68, 50, 90 },
	{"Merlin.  ", 99, 68, 50, 105 },
	{"Martin.  ", 100, 68, 50, 80 },
#endif



#ifdef JP
	{"l̎q̂̈lłB", 85, 70, 71, 45},
	{"ꗱłB", 	 100, 70, 71, 55},

	{"Ȃ̓_[NGt̐m", 50, 69, 70, 60 },
	{"Ȃ̓_[NGt̖pm", 80, 69, 70, 75 },
	{"Ȃ̓_[NGt̋M", 100, 69, 70, 95 },
#else
	{"You are one of several children of a Dark Elven ", 85, 69, 70, 45},
	{"You are the only child of a Dark Elven ", 100, 69, 70, 55},

	{"Warrior.  ", 50, 70, 71, 60 },
	{"Warlock.  ", 80, 70, 71, 75 },
	{"Noble.  ", 100, 70, 71, 95 },
#endif


#ifdef JP
	{"Ȃ͍", 100, 71, 72, 50},
#else
	{"You have black eyes, ", 100, 71, 72, 50},
#endif


#ifdef JP
	{"Ȃ߂炩",          70, 72, 73, 50},
	{"gł",              90, 72, 73, 50},
	{"J[",            100, 72, 73, 50},

	{"AĂƂĂÂF̔Ă܂B", 100, 73, 0, 50 },
#else
	{"straight ",          70, 72, 73, 50},
	{"wavy ",              90, 72, 73, 50},
	{"curly ",            100, 72, 73, 50},

	{"black hair and a very dark complexion.", 100, 73, 0, 50 },
#endif


#ifdef JP
	{"Ȃ̕e̓I[KłA͔閧ɂĂ܂B", 25, 74, 20, 25},
	{"Ȃ̕e̓I[KłA͔閧ɂĂ܂B", 100, 74, 20, 25},
#else
	{"Your mother was an Ogre, but it is unacknowledged.  ", 25, 74, 20, 25},
	{"Your father was an Ogre, but it is unacknowledged.  ", 100, 74, 20, 25},
#endif


#ifdef JP
	{"Ȃ̕e͋uWCAgłB", 10, 75, 20, 50},
	{"Ȃ̕e̓t@CA[EWCAgłB", 12, 75, 20, 55},
	{"Ȃ̕e̓tXgEWCAgłB", 20, 75, 20, 60},
	{"Ȃ̕e̓NEhEWCAgłB", 23, 75, 20, 65},
	{"Ȃ̕e̓Xg[EWCAgłB", 25, 75, 20, 70},
	{"Ȃ̕e͋uWCAgłB", 60, 75, 20, 50},
	{"Ȃ̕e̓t@CA[EWCAgłB", 70, 75, 20, 55},
	{"Ȃ̕e̓tXgEWCAgłB", 80, 75, 20, 60},
	{"Ȃ̕e̓NEhEWCAgłB", 90, 75, 20, 65},
	{"Ȃ̕e̓Xg[EWCAgłB", 100, 75, 20, 70},
#else
	{"Your mother was a Hill Giant.  ", 10, 75, 20, 50},
	{"Your mother was a Fire Giant.  ", 12, 75, 20, 55},
	{"Your mother was a Frost Giant.  ", 20, 75, 20, 60},
	{"Your mother was a Cloud Giant.  ", 23, 75, 20, 65},
	{"Your mother was a Storm Giant.  ", 25, 75, 20, 70},
	{"Your father was a Hill Giant.  ", 60, 75, 20, 50},
	{"Your father was a Fire Giant.  ", 70, 75, 20, 55},
	{"Your father was a Frost Giant.  ", 80, 75, 20, 60},
	{"Your father was a Cloud Giant.  ", 90, 75, 20, 65},
	{"Your father was a Storm Giant.  ", 100, 75, 20, 70},
#endif


#ifdef JP
	{"Ȃ̕e͖̒mʃ^C^łB", 75, 76, 20, 50 },
	{"Ȃ̕e̓e~XłB", 80, 76, 20, 100 },
	{"Ȃ̕e̓mVłB", 85, 76, 20, 100 },
	{"Ȃ̕e̓IPAmXłB", 90, 76, 20, 100 },
	{"Ȃ̕e̓NEXłB", 95, 76, 20, 100 },
	{"Ȃ̕e̓nCyIłB", 98, 76, 20, 125 },
	{"Ȃ̕e̓NmXłB", 100, 76, 20, 150 },
#else
	{"Your father was an unknown Titan.  ", 75, 76, 20, 50 },
	{"Your mother was Themis.  ", 80, 76, 20, 100 },
	{"Your mother was Mnemosyne.  ", 85, 76, 20, 100 },
	{"Your father was Okeanoas.  ", 90, 76, 20, 100 },
	{"Your father was Crius.  ", 95, 76, 20, 100 },
	{"Your father was Hyperion.  ", 98, 76, 20, 125 },
	{"Your father was Kronos.  ", 100, 76, 20, 150 },
#endif


#ifdef JP
	{"Ȃ͖̒mʃTCNvX̎qłB", 90, 77, 109, 50 },
	{"Ȃ̓|tFX̎qłB", 98, 77, 109, 80 },
	{"Ȃ̓EmX̎qłB", 100, 77, 109, 135 },
#else
	{"You are the offspring of an unknown Cyclops.  ", 90, 77, 109, 50 },
	{"You are Polyphemos's child.  ", 98, 77, 109, 80 },
	{"You are Uranos's child.  ", 100, 77, 109, 135 },
#endif


#ifdef JP
	{"l̎q̂̈lłB", 100, 79, 80, 50 },

	{"Ȃ̓uEEC[N", 		50, 78, 79, 50 },
	{"Ȃ̓u[EC[N", 		75, 78, 79, 50 },
	{"Ȃ̓}X^[EC[N", 		95, 78, 79, 85 },
	{"Ȃ̓C[N̉w{h[x", 100, 78, 79, 120 },
#else
	{"You are one of several children of ", 100, 78, 79, 50 },

	{"a Brown Yeek. ", 50, 79, 80, 50 },
	{"a Blue Yeek.  ", 75, 79, 80, 50 },
	{"a Master Yeek.  ", 95, 79, 80, 85 },
	{"Boldor, the King of the Yeeks.  ", 100, 79, 80, 120 },
#endif


#ifdef JP
	{"Ȃ͐", 25, 80, 81, 50 },
	{"Ȃ͌铵", 50, 80, 81, 50 },
	{"Ȃ͏ȍ", 75, 80, 81, 50 },
	{"Ȃ͍P", 100, 80, 81, 50 },

	{"̂ȂA", 20, 81, 65, 50 },
	{"ZA", 40, 81, 65, 50 },
	{"A", 60, 81, 65, 50 },
	{"R悤ȐԂA", 80, 81, 65, 50 },
	{"F̂ȂA", 100, 81, 65, 50 },
#else
	{"You have pale eyes, ", 25, 80, 81, 50 },
	{"You have glowing eyes, ", 50, 80, 81, 50 },
	{"You have tiny black eyes, ", 75, 80, 81, 50 },
	{"You have shining black eyes, ", 100, 80, 81, 50 },

	{"no hair at all, ", 20, 81, 65, 50 },
	{"short black hair, ", 40, 81, 65, 50 },
	{"long black hair, ", 60, 81, 65, 50 },
	{"bright red hair, ", 80, 81, 65, 50 },
	{"colourless albino hair, ", 100, 81, 65, 50 },
#endif


#ifdef JP
	{"̉l̎q̂̈lłB ", 100, 83, 80, 50 },

	{"Ȃ̓X[ER{h", 	40, 82, 83, 50 },
	{"Ȃ̓R{h", 		75, 82, 83, 55 },
	{"Ȃ̓[WER{h", 		95, 82, 83, 65 },
	{"Ȃ̓R{h̉wKbVx", 100, 82, 83, 100 },
#else
	{"You are one of several children of ", 100, 82, 83, 50 },

	{"a Small Kobold.  ", 40, 83, 80, 50 },
	{"a Kobold.  ", 75, 83, 80, 55 },
	{"a Large Kobold.  ", 95, 83, 80, 65 },
	{"Mughash, the Kobold Lord.  ", 100, 83, 80, 100 },
#endif


#ifdef JP
	{"Ȃ͏NbR̉l̎q̂̈lłB"
	, 100, 84, 85, 50 },

	{"Ȃ͐Ԃ", 40, 85, 86, 50 },
	{"Ȃ͍", 90, 85, 86, 50 },
	{"Ȃ͉F", 100, 85, 86, 50 },

	{"ڂĂ܂B", 100, 86, 0, 50 },
#else
	{"You are one of several children of a Klackon hive queen.  "
	, 100, 84, 85, 50 },

	{"You have red skin, ", 40, 85, 86, 50 },
	{"You have black skin, ", 90, 85, 86, 50 },
	{"You have yellow skin, ", 100, 85, 86, 50 },

	{"and black eyes.", 100, 86, 0, 50 },
#endif


#ifdef JP
	{"̉l̎q̂̈lłB", 100, 88, 18, 89 },

	{"Ȃ̓j[xO̓z", 30,	87, 88, 20 },
	{"Ȃ̓j[xO̓", 50, 	87, 88, 40 },
	{"Ȃ̓j[xO̒b艮", 70, 	87, 88, 60 },
	{"Ȃ̓j[xO̍Bv", 90, 	87, 88, 75 },
	{"Ȃ̓j[xÕV[}", 95,87, 88, 100 },
	{"Ȃ̓j[xỎw~[x", 100,87, 88, 100 },/*nuke me*/
#else
	{"You are one of several children of ", 100, 87, 88, 89 },

	{"a Nibelung Slave.  ", 30, 88, 18, 20 },
	{"a Nibelung Thief.  ", 50, 88, 18, 40 },
	{"a Nibelung Smith.  ", 70, 88, 18, 60 },
	{"a Nibelung Miner.  ", 90, 88, 18, 75 },
	{"a Nibelung Shaman.  ", 95, 88, 18, 100 },
	{"Mime, the Nibelung.  ", 100, 88, 18, 100 },
#endif

#ifdef JP
	{"Ȃ̓hRjA", 100, 89, 90, 50 },

	{"̒qłB", 30, 135, 91, 55 },
	{"̖qłB", 50, 135, 91, 50 },
	{"̗{qłB", 55, 135, 91, 50 },
	{"̌ǎłB", 60, 135, 91, 45 },
	{"̊l̎q̂̈lłB", 85, 135, 91, 50 },
	{"̈ꗱłB", 100, 135, 91, 55 },

	{"H", 10, 90, 135, 20 },
	{"", 21, 90, 135, 30 },
	{"v", 26, 90, 135, 45 },
	{"b", 42, 90, 135, 45 },
	{"m", 73, 90, 135, 50 },
	{"l", 78, 90, 135, 50 },
	{"El", 85, 90, 135, 55 },
	{"É", 89, 90, 135, 60 },
	{"m", 94, 90, 135, 65 },
	{"pt", 97, 90, 135, 70 },
	{"w", 99, 90, 135, 80 },
	{"M", 100, 90, 135, 100 },

	{"Ȃ", 100, 91, 136, 50 },

	{"͍DF̗ƔAĊDF̕Ă܂B", 11, 136, 0, 50 },
	{"uYF̗ƔAēF̕Ă܂B", 16, 136, 0, 50 },
	{"̗A̔Ă܂B", 24, 136, 0, 50 },
	{"AĂ܂B", 26, 136, 0, 60 },
	{"ƔAĐF̕Ă܂B", 32, 136, 0, 50 },
	{"F̗AFłB", 33, 136, 0, 70 },
	{"F̗AF̔Ă܂B", 37, 136, 0, 45 },
	{"ƔAĔĂ܂B", 41, 136, 0, 50 },
	{"F̗ƔAĔĂ܂B", 48, 136, 0, 50 },
	{"ΐF̗ƔAĉFĂ܂B", 65, 136, 0, 50 },
	{"ΐF̗AΐF̔Ă܂B", 75, 136, 0, 50 },
	{"ԂAԂĂ܂B", 88, 136, 0, 50 },
	{"AĂ܂B", 94, 136, 0, 50 },
	{"߂AIȔĂ܂B", 100, 136, 0, 55},
#else
	{"You are ", 100, 89, 135, 50 },

	{"the oldest child of a Draconian ", 30, 135, 90, 55 },
	{"the youngest child of a Draconian ", 50, 135, 90, 50 },
	{"the adopted child of a Draconian ", 55, 135, 90, 50 },
	{"an orphaned child of a Draconian ", 60, 135, 90, 45 },
	{"one of several children of a Draconian ", 85, 135, 90, 50 },
	{"the only child of a Draconian ", 100, 135, 90, 55 },

	{"Beggar.  ", 10, 90, 91, 20 },
	{"Thief.  ", 21, 90, 91, 30 },
	{"Sailor.  ", 26, 90, 91, 45 },
	{"Mercenary.  ", 42, 90, 91, 45 },
	{"Warrior.  ", 73, 90, 91, 50 },
	{"Merchant.  ", 78, 90, 91, 50 },
	{"Artisan.  ", 85, 90, 91, 55 },
	{"Healer.  ", 89, 90, 91, 60 },
	{"Priest.  ", 94, 90, 91, 65 },
	{"Mage.  ", 97, 90, 91, 70 },
	{"Scholar.  ", 99, 90, 91, 80 },
	{"Noble.  ", 100, 90, 91, 100 },

	{"You have ", 100, 91, 136, 50 },

	{"charcoal wings, charcoal skin and a smoke-gray belly.", 11, 136, 0, 50 },
	{"bronze wings, bronze skin, and a copper belly.", 16, 136, 0, 50 },
	{"golden wings, and golden skin.", 24, 136, 0, 50 },
	{"white wings, and white skin.", 26, 136, 0, 60 },
	{"blue wings, blue skin, and a cyan belly.", 32, 136, 0, 50 },
	{"multi-hued wings, and multi-hued skin.", 33, 136, 0, 70 },
	{"brown wings, and brown skin.", 37, 136, 0, 45 },
	{"black wings, black skin, and a white belly.", 41, 136, 0, 50 },
	{"lavender wings, lavender skin, and a white belly.", 48, 136, 0, 50 },
	{"green wings, green skin and yellow belly.", 65, 136, 0, 50 },
	{"green wings, and green skin.", 75, 136, 0, 50 },
	{"red wings, and red skin.", 88, 136, 0, 50 },
	{"black wings, and black skin.", 94, 136, 0, 50 },
	{"metallic skin, and shining wings.", 100, 136, 0, 55},
#endif



#ifdef JP
	{"Ȃ͈̑Ȃ钷V̔]XłȂrŃI^}WNVƂĐ܂܂BȂ̓kkƋP󋕂ȖڂĂāA", 100, 92, 93, 80 },
	{"̎ɎO{̐G肪Ă܂B", 20, 93, 0, 45 },
	{"̎Ɏl{̐G肪Ă܂B", 80, 93, 0, 50 },
	{"̎Ɍܖ{̐G肪Ă܂B", 100, 93, 0, 55 },
#else
	{"You have slimy skin, empty glowing eyes, and ", 100, 92, 93, 80 },
	{"three tentacles around your mouth.", 20, 93, 0, 45 },
	{"four tentacles around your mouth.", 80, 93, 0, 50 },
	{"five tentacles around your mouth.", 100, 93, 0, 55 },
#endif


#ifdef JP
	{"Ȃ̑c", 100, 94, 95, 50 },

	{"SȂn̒ዉȐłB", 30, 95, 96, 20 },
	{"łB", 60, 95, 96, 50 },
	{"㋉łB", 90, 95, 96, 75 },
	{"łB", 100, 95, 96, 99 },

	{"Ȃ͐Ԃ", 50, 96, 97, 50 },
	{"Ȃ͒F", 100, 96, 97, 50},

	{"ԂR铵ĂāA܂ƉƎhĂ܂B", 40, 97, 0, 50 },
	{"ԂR铵ĂāA܂Ɖ傪Ă܂B", 70, 97, 0, 50 },
	{"ԂR铵ĂāA܂Ă܂B", 100, 97, 0, 50 },
#else
	{"You ancestor was ", 100, 94, 95, 50 },

	{"a mindless demonic spawn.  ", 30, 95, 96, 20 },
	{"a minor demon.  ", 60, 95, 96, 50 },
	{"a major demon.  ", 90, 95, 96, 75 },
	{"a demon lord.  ", 100, 95, 96, 99 },

	{"You have red skin, ", 50, 96, 97, 50 },
	{"You have brown skin, ", 100, 96, 97, 50},

	{"claws, fangs, spikes, and glowing red eyes.", 40, 97, 0, 50 },
	{"claws, fangs, and glowing red eyes.", 70, 97, 0, 50 },
	{"claws, and glowing red eyes.", 100, 97, 0, 50 },
#endif


#ifdef JP
	{"Ȃ̓Jo̔pɂ", 40,	98, 99, 50 },
	{"Ȃ͖@gɂ", 65, 	98, 99, 50 },
	{"Ȃ͘Bptɂ",	     90,	98, 99, 50},
	{"Ȃ͑mɂ", 100,	98, 99, 60},

	{"Ɛ키߂", 10, 99, 100, 65 },
	{"",		 100, 99, 100, 50 },

	{"Sy", 40, 100, 101, 50 },
	{"΂", 80, 100, 101, 50 },
	{"؂", 85, 100, 101, 40 },
	{"S", 99, 100, 101, 50 },
	{"", 100, 100, 101, 100},

	{"o܂B", 100,101, 0, 50 },
#else
	{"You were shaped from ", 100, 98, 99, 50 },

	{"clay ", 40, 99, 100, 50 },
	{"stone ", 80, 99, 100, 50 },
	{"wood ", 85, 99, 100, 40 },
	{"iron ", 99, 99, 100, 50 },
	{"pure gold ", 100, 99, 100, 100},

	{"by a Kabbalist", 40, 100, 101, 50 },
	{"by a Wizard", 65, 100, 101, 50 },
	{"by an Alchemist", 90, 100, 101, 50},
	{"by a Priest", 100, 100, 101, 60},

	{" to fight evil.", 10, 101, 0, 65 },
	{".", 100, 101, 0, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 102, 103, 50 },

	{"pmɂo܂B", 30, 103, 104, 50 },
	{"@̎ɂo܂B", 50, 103, 104, 50 },
	{"׈ȑmɂo܂B", 70, 103, 104, 50 },
	{"Ƃ̌_ɂ萶ݏo܂B", 75, 103, 104, 50 },
	{"삩琶܂܂B", 85, 103, 104, 50 },
	{"􂢂琶܂܂B", 95, 103, 104, 30 },
	{"_pɂ萶ݏo܂B", 100, 103, 104, 50 },

	{"Ȃ", 100, 104, 105, 50 },
	{"ÂꂽŏoĂāA", 40, 105, 106, 50 },
	{"ŏoĂāA", 60, 105, 106, 50 },
	{"ꂽFŏoĂāA", 80, 105, 106, 50 },
	{"PŏoĂāA", 100, 105, 106, 50 },

	{"ڂĂ܂B", 30, 106, 0, 50 },
	{"n̍΂RڂĂ܂B", 50, 106, 0, 50 },
	{"|͂ۂłB", 100, 106, 0, 50 },
#else
	{"You were created by ", 100, 102, 103, 50 },

	{"a Necromancer.  ", 30, 103, 104, 50 },
	{"a magical experiment.  ", 50, 103, 104, 50 },
	{"an Evil Priest.  ", 70, 103, 104, 50 },
	{"a pact with the demons.  ", 75, 103, 104, 50 },
	{"a restless spirit.  ", 85, 103, 104, 50 },
	{"a curse.  ", 95, 103, 104, 30 },
	{"an oath.  ", 100, 103, 104, 50 },

	{"You have ", 100, 104, 105, 50 },
	{"dirty, dry bones, ", 40, 105, 106, 50 },
	{"rotten black bones, ", 60, 105, 106, 50 },
	{"filthy, brown bones, ", 80, 105, 106, 50 },
	{"shining white bones, ", 100, 105, 106, 50 },

	{"and glowing eyes.", 30, 106, 0, 50 },
	{"and eyes which burn with hellfire.", 50, 106, 0, 50 },
	{"and empty eyesockets.", 100, 106, 0, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 107, 108, 50 },

	{"pmɂ萶ݏo܂B", 30, 108, 62, 50 },
	{"@gɂ萶ݏo܂B", 50, 108, 62, 50 },
	{"삩琶܂܂B",60, 108, 62, 50 },
	{"׈ȑmɂ萶ݏo܂B", 70, 108, 62, 50 },
	{"Ƃ̌_ɂ萶ݏo܂B", 80, 108, 62, 50 },
	{"􂢂琶܂܂B", 95, 108, 62, 30 },
	{"_pɂ萶ݏo܂B", 100, 108, 62, 50 },

	{"Ȃ͈ÊF̓A", 20, 109, 110, 50},
	{"Ȃ͊F̓A",      60, 109, 110, 50},
	{"Ȃ͔F̓A",      70, 109, 110, 50},
	{"Ȃ͗ΐF̓A",      80, 109, 110, 50},
	{"Ȃ͐A",       90, 109, 110, 50},
	{"Ȃ͒WF̓A", 100, 109, 110, 50}, /*tansei.cc.u-tokyo̗R */

	{"Ȃ߂炩",          70, 110, 111, 50},
	{"gł",              90, 110, 111, 50},
	{"J[",            100, 110, 111, 50},

	{"A",           30, 111, 112, 50},
	{"FA",           70, 111, 112, 50},
	{"ԒF̔A",          80, 111, 112, 50},
	{"ԂA",         90, 111, 112, 50},
	{"A",          100, 111, 112, 50},

	{"ĂƂĂÂĂ܂B", 10, 112, 0, 50},
	{"ĈÂĂ܂B",     30, 112, 0, 50},
	{"ĕϓIȔ̐FĂ܂B", 80, 112, 0, 50},
	{"ČF̂Ă܂B",     90, 112, 0, 50},
	{"ĂƂĂF̂Ă܂B", 100, 112, 0, 50},
#else
	{"You were created by ", 100, 107, 108, 50 },

	{"a Necromancer.  ", 30, 108, 62, 50 },
	{"a Wizard.  ", 50, 108, 62, 50 },
	{"a restless spirit.  ",60, 108, 62, 50 },
	{"an Evil Priest.  ", 70, 108, 62, 50 },
	{"a pact with the demons.  ", 80, 108, 62, 50 },
	{"a curse.  ", 95, 108, 62, 30 },
	{"an oath.  ", 100, 108, 62, 50 },

	{"You have a dark brown eye, ", 20, 109, 110, 50},
	{"You have a brown eye, ",      60, 109, 110, 50},
	{"You have a hazel eye, ",      70, 109, 110, 50},
	{"You have a green eye, ",      80, 109, 110, 50},
	{"You have a blue eye, ",       90, 109, 110, 50},
	{"You have a blue-gray eye, ", 100, 109, 110, 50},

	{"straight ",          70, 110, 111, 50},
	{"wavy ",              90, 110, 111, 50},
	{"curly ",            100, 110, 111, 50},

	{"black hair, ",           30, 111, 112, 50},
	{"brown hair, ",           70, 111, 112, 50},
	{"auburn hair, ",          80, 111, 112, 50},
	{"red hair, ",         90, 111, 112, 50},
	{"blond hair, ",          100, 111, 112, 50},

	{"and a very dark complexion.", 10, 112, 0, 50},
	{"and a dark complexion.",     30, 112, 0, 50},
	{"and an average complexion.", 80, 112, 0, 50},
	{"and a fair complexion.",     90, 112, 0, 50},
	{"and a very fair complexion.", 100, 112, 0, 50},
#endif


#ifdef JP
	{"Ȃ͖̂Ȃ̒S܂B", 20, 113, 114, 50 },
	{"Ȃ͐O̕SłAȃopCAE[h̉aHƂȂĂ܂܂B", 40, 113, 114, 50 },
	{"Ȃ͐O̓opCAEn^[łAނ̉aHƂȂĂ܂܂B", 60, 113, 114, 50 },
	{"Ȃ͐O͎pmłB", 80, 113, 114, 50 },
	{"Ȃ͐O͋ȋMłB", 95, 113, 114, 50 },
	{"Ȃ͐O͋ŎcEȐꐧNłB", 100, 113, 114, 50 },
#else
	{"You arose from an unmarked grave.  ", 20, 113, 114, 50 },
	{"In life you were a simple peasant, the victim of a powerful Vampire Lord.  ", 40, 113, 114, 50 },
	{"In life you were a Vampire Hunter, but they got you.  ", 60, 113, 114, 50 },
	{"In life you were a Necromancer.  ", 80, 113, 114, 50 },
	{"In life you were a powerful noble.  ", 95, 113, 114, 50 },
	{"In life you were a powerful and cruel tyrant.  ", 100, 113, 114, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 114, 115, 50 },

	{"̔A", 25, 115, 116, 50 },
	{"ꂽuE̔A", 50, 115, 116, 50 },
	{"A", 75, 115, 116, 50 },
	{"̂ȂA", 100, 115, 116, 50 },
#else
	{"You have ", 100, 114, 115, 50 },

	{"jet-black hair, ", 25, 115, 116, 50 },
	{"matted brown hair, ", 50, 115, 116, 50 },
	{"white hair, ", 75, 115, 116, 50 },
	{"a hairless head, ", 100, 115, 116, 50 },
#endif


#ifdef JP
	{"RΒŶ悤ȓA", 25, 116, 117, 50 },
	{"̂ȂځA", 50, 116, 117, 50 },
	{"\ȉFA", 75, 116, 117, 50 },
	{"ԂA", 100, 116, 117, 50 },

	{"Ďl̂悤ɐ߂Ă܂B", 100, 117, 0, 50 },
#else
	{"eyes like red coals, ", 25, 116, 117, 50 },
	{"blank white eyes, ", 50, 116, 117, 50 },
	{"feral yellow eyes, ", 75, 116, 117, 50 },
	{"bloodshot red eyes, ", 100, 116, 117, 50 },

	{"and a deathly pale complexion.", 100, 117, 0, 50 },
#endif


#ifdef JP
	{"Ȃ", 100, 118, 119, 50 },

	{"pmɂo܂B", 30, 119, 134, 50 },
	{"@̎ɂo܂B", 50, 119, 134, 50 },
	{"׈ȑmɂo܂B", 70, 119, 134, 50 },
	{"Ƃ̌_ɂ萶ݏo܂B", 75, 119, 134, 50 },
	{"삩琶܂܂B", 85, 119, 134, 50 },
	{"􂢂琶܂܂B", 95, 119, 134, 30 },
	{"_pɂ萶ݏo܂B", 100, 119, 134, 50 },
#else
	{"You were created by ", 100, 118, 119, 50 },

	{"a Necromancer.  ", 30, 119, 134, 50 },
	{"a magical experiment.  ", 50, 119, 134, 50 },
	{"an Evil Priest.  ", 70, 119, 134, 50 },
	{"a pact with the demons.  ", 75, 119, 134, 50 },
	{"a restless spirit.  ", 85, 119, 134, 50 },
	{"a curse.  ", 95, 119, 134, 30 },
	{"an oath.  ", 100, 119, 134, 50 },
#endif


#ifdef JP
	{"̔A", 25, 120, 121, 50 },
	{"ꂽuE̔A", 50, 120, 121, 50 },
	{"A", 75, 120, 121, 50 },
	{"̂ȂA", 100, 120, 121, 50 },
#else
	{"jet-black hair, ", 25, 120, 121, 50 },
	{"matted brown hair, ", 50, 120, 121, 50 },
	{"white hair, ", 75, 120, 121, 50 },
	{"a hairless head, ", 100, 120, 121, 50 },
#endif


#ifdef JP
	{"RΒŶ悤ȓA", 25, 121, 122, 50 },
	{"̂ȂځA", 50, 121, 122, 50 },
	{"\ȉFA", 75, 121, 122, 50 },
	{"ԂA", 100, 121, 122, 50 },
#else
	{"eyes like red coals, ", 25, 121, 122, 50 },
	{"blank white eyes, ", 50, 121, 122, 50 },
	{"feral yellow eyes, ", 75, 121, 122, 50 },
	{"bloodshot red eyes, ", 100, 121, 122, 50 },
#endif


#ifdef JP
	{"Ďl̂悤ȓyF̔Ă܂B", 100, 122, 123, 50 },
	{"Ȃ̎ɂ͕sCȗΐF̃I[Ă܂B", 100, 123, 0, 50 },
#else
	{" and a deathly gray complexion. ", 100, 122, 123, 50 },
	{"An eerie green aura surrounds you.", 100, 123, 0, 50 },
#endif


#ifdef JP
	{"Ȃ̗e", 100, 124, 125, 50 },

	{"sNV[łB", 20, 125, 126, 35 },
	{"jNV[łB", 30, 125, 126, 25 },
	{"X̗dłB", 75, 125, 126, 50 },
	{"X̐łB", 90, 125, 126, 75 },
	{"d̋MłB", 100, 125, 126, 85 }, /*nuke me J^Jîق */
#else
	{"Your parents were ", 100, 124, 125, 50 },

	{"pixies.  ", 20, 125, 126, 35 },
	{"nixies.  ", 30, 125, 126, 25 },
	{"wood sprites.  ", 75, 125, 126, 50 },
	{"wood spirits.  ", 90, 125, 126, 75 },
	{"noble faerie folk.  ", 100, 125, 126, 85 },
#endif


#ifdef JP
	{"Ȃ͔wɃCgu[̉HĂāA", 100, 126, 127, 50 },

	{"Ȃ߂炩ȋA",          80, 127, 128, 50},
	{"głA",              100, 127, 128, 50},

	{"AĔɐƂĂ܂B", 100, 128, 0, 50},
#else
	{"You have light blue wings attached to your back, ", 100, 126, 127, 50 },

	{"straight blond hair, ",          80, 127, 128, 50},
	{"wavy blond hair, ",              100, 127, 128, 50},

	{"blue eyes, and a very fair complexion.", 100, 128, 0, 50},
#endif


#ifdef JP
	{"Ȃ͖@̎ɂ萶ݏo܂B", 30, 129, 130, 40},
	{"Ȃ͎qAɂOXɓ˂ł܂܂B",
	50, 129, 130, 50 }, /*nuke me*/
	{"JIX̖VтłȂグ܂B",
	60, 129, 130, 60 },
	{"Ȃ͖@ɂ|킳ꂽƐlԂ̎qłB", 75, 129, 130, 50},
	{"Ȃ͌܂JIX̖̐`IȊ|킹ɂ萶܂܂B", 100, 129, 130, 30},
#else
	{"You were produced by a magical experiment.  ", 30, 129, 130, 40},
	{"In your childhood, you were stupid enough to stick your head in raw Logrus.  ",
	50, 129, 130, 50 },
	{"A Demon Lord of Chaos decided to have some fun, and so he created you.  ",
	60, 129, 130, 60 },
	{"You are the magical crossbreed of an animal and a man.  ", 75, 129, 130, 50},
	{"You are the blasphemous crossbreed of unspeakable creatures of chaos.  ", 100, 129, 130, 30},
#endif



#ifdef JP
	{"Ȃ͗ΐF঒ނ̖", 60, 130, 131, 50},
	{"Ȃ͍̖",      85, 130, 131, 50},
	{"Ȃ̓IWF̔L̖", 99, 130, 131, 50},
	{"Ȃ͔R悤Ȉ̖", 100, 130, 131, 55},
#else
	{"You have green reptilian eyes, ", 60, 130, 131, 50},
	{"You have the black eyes of a bird, ", 85, 130, 131, 50},
	{"You have the orange eyes of a cat, ", 99, 130, 131, 50},
	{"You have the fiery eyes of a demon, ", 100, 130, 131, 55},
#endif


#ifdef JP

	{"Ɣ̂ȂA",   10, 131, 133, 50},
	{"ĂāA",       33, 131, 132, 50},
	{"ĂāA݂ڂ炵", 66, 131, 132, 50},
	{"ĂāAĂ",  100, 131, 132, 50},
#else
	{"no hair at all, ",   10, 131, 133, 50 },
	{"dirty ",             33, 131, 132, 50},
	{"mangy ",             66, 131, 132, 50},
	{"oily ",             100, 131, 132, 50},
#endif


#ifdef JP

	{"F̖є",      33, 132, 133, 50},
	{"DF̖є",      66, 132, 133, 50},
	{"є",       100, 132, 133, 50},
#else
	{"brown fur, ",      33, 132, 133, 50},
	{"gray fur, ",      66, 132, 133, 50},
	{"albino fur, ",    100, 132, 133, 50},
#endif


#ifdef JP
	{"Rr̒܂B", 50, 133, 0, 50 },
	{"lԂ̑Ă܂B", 75, 133, 0, 50 },
	{"̑Ă܂B", 85, 133, 0, 50 },
	{"঒ނ̑Ă܂B",90, 133, 0, 50 },
	{"̑Ă܂B", 95, 133, 0, 50 },
	{"L̑Ă܂B", 97, 133, 0, 50 },
	{"̑Ă܂B", 100, 133, 0, 50 },

	{"Ȃ", 100, 134, 120, 50 },
#else
	{"and the hooves of a goat.", 50, 133, 0, 50 },
	{"and human feet.", 75, 133, 0, 50 },
	{"and bird's feet.", 85, 133, 0, 50 },
	{"and reptilian feet.", 90, 133, 0, 50 },
	{"and bovine feet.", 95, 133, 0, 50 },
	{"and feline feet.", 97, 133, 0, 50 },
	{"and canine feet.", 100, 133, 0, 50 },

	{"You have ", 100, 134, 120, 50 },
#endif


#ifdef JP
	{"ss̎qłB", 25, 138, 139, 40},
	{"܂悤qłB", 50, 138, 139, 50},
	{"B̎qłB", 75, 138, 139, 60},
	{"ĂqłB", 100, 138, 139, 70},
#else
	{"You are the lost offspring of ", 25, 137, 138, 40},
	{"You are the wandering offspring of ", 50, 137, 138, 50},
	{"You are the only offspring of ", 75, 137, 138, 60},
	{"You are the beloved offspring of ", 100, 137, 138, 70},
#endif


#ifdef JP
	{"Ȃ͖mʃGg", 10, 137, 138, 35},
	{"Ȃ͌ǓƂȃGg", 35, 137, 138, 50},
	{"Ȃ̓Gg̈c̈", 55, 137, 138, 60},
	{"Ȃ͔ɉhĂGg̎Љ̃[_[", 70, 137, 138, 70},
	{"Ȃ̓Gg̐X̒", 81, 137, 138, 80},
	{"Ȃ͑hĂGǧ҂", 91, 137, 138, 90},
	{"Ȃ͍ł͒ǉ̒ɂȂGg", 96, 137, 138, 100},
	{"Ȃ̓t@S̐l", 100, 137, 138, 110},
#else
	{"an Ent whose name you have no recollection of.  ", 10, 138, 139, 35},
	{"a solitary Ent.  ", 35, 138, 139, 50},
	{"a member of a farflung Entish band.  ", 55, 138, 139, 60},
	{"a leader of a prosperous community of Ents.  ", 70, 138, 139, 70},
	{"an Entish Forestwarden.  ", 81, 138, 139, 80},
	{"a respected Entish sage.  ", 91, 138, 139, 90},
	{"an Entwife whose memory men cherish.  ", 96, 138, 139, 100},
	{"Fangorn himself.  ", 100, 138, 139, 110},
#endif

#ifdef JP
	{"Ȃ", 100, 139, 140, 50},
#else
	{"You have ", 100, 139, 140, 50},
#endif

#ifdef JP
	{"O{̎wA", 5, 140, 141, 50},
	{"l{̎wA", 20, 140, 141, 50},
	{"ܖ{̎wA", 40, 140, 141, 50},
	{"Z{̎wA", 60, 140, 141, 50},
	{"{̎wA", 80, 140, 141, 50},
	{"{̎wA", 95, 140, 141, 50},
	{"{̎wA", 100, 140, 141, 50},
#else
	{"three fingers and toes, and are covered in ", 5, 140, 141, 50},
	{"four fingers and toes, and are covered in ", 20, 140, 141, 50},
	{"five fingers and toes, and are covered in ", 40, 140, 141, 50},
	{"six fingers and toes, and are covered in ", 60, 140, 141, 50},
	{"seven fingers and toes, and are covered in ", 80, 140, 141, 50},
	{"eight fingers and toes, and are covered in ", 95, 140, 141, 50},
	{"nine fingers and toes, and are covered in ", 100, 140, 141, 50},
#endif
#ifdef JP
	{"F؏̔ɕĂ܂B", 10, 141, 0, 50},
	{"F̍rɕĂ܂B", 20, 141, 0, 50},
	{"DF̂Ȃ߂炩ȔɕĂ܂B", 30, 141, 0, 50},
	{"[O[̔ɕĂ܂B", 40, 141, 0, 50},
	{"ۂŕꂽĂ܂B", 50, 141, 0, 50},
	{"[uE̔ɕĂ܂B", 60, 141, 0, 50},
	{"p[uẼpTpT̔ɕĂ܂B", 70, 141, 0, 50},
	{"`R[gF̖LȔɕĂ܂B", 80, 141, 0, 50},
	{"؏̔ɕĂ܂B", 90, 141, 0, 50},
	{"قƂǂЂтAɕĂ܂B", 100, 141, 0, 50},
#else
	{"scaly brown skin.", 10, 141, 0, 50},
	{"rough brown skin.", 20, 141, 0, 50},
	{"smooth grey skin.", 30, 141, 0, 50},
	{"dark green skin.", 40, 141, 0, 50},
	{"mossy skin.", 50, 141, 0, 50},
	{"deep brown skin.", 60, 141, 0, 50},
	{"pale brown, flaky skin.", 70, 141, 0, 50},
	{"rich chocolate-colored skin.", 80, 141, 0, 50},
	{"ridged black skin.", 90, 141, 0, 50},
	{"thick, almost corky skin.", 100, 141, 0, 50},
#endif

#ifdef JP
	{"Ȃ͓VE̎lłB", 100, 142, 143, 80},
	{"Ȃ͈łڂ߂ɂ̒nɑĂ܂B", 100, 143, 144, 80},
	{"̖ړI𐬂܂ł͋xނƂ͋܂B", 100, 144, 0, 80},
#else
	{"You are of the blessed host of heaven.  ", 100, 142, 143, 80},
	{"You have been sent to earth to eradicate the wicked, ", 100, 143, 144, 80},
	{"and shall not rest until you have succeeded.", 100, 144, 0, 80},
#endif

#ifdef JP
	{"Ȃ͒n̎ꂽqłB", 100, 145, 146, 20},
	{"Ȃ̓O[^[Ef[̋C܂ɂĐ܂܂B", 100, 146, 147, 20},
	{"Ȃ͕Q̋@Ă܂B", 100, 147, 0, 20},
#else
	{"You are of the cursed spawn of hell. ", 100, 145, 146, 20},
	{"You have been cast out by the whim of the greater demons, ", 100, 146, 147, 20},
	{"and now seek revenge.", 100, 147, 0, 20},
#endif



#ifdef JP
	{"Ȃ͑f̒mȂ", 5, 148, 149, 25},
	{"Ȃ͕ߗ", 20, 148, 149, 35},
	{"Ȃ͐m", 40, 148, 149, 45},
	{"Ȃ̓W[", 50, 148, 149, 50},
	{"Ȃ͏L", 70, 148, 149, 65},
	{"Ȃ͖", 83, 148, 149, 75},
	{"Ȃ͘Bpt", 93, 148, 149, 90},
	{"Ȃ͋M̏", 98, 148, 149, 110},
	{"Ȃ͏", 100, 148, 149, 140},
#else
	{"whose identity you are uncertain of.", 5, 149, 8, 25},
	{"Captive.  ", 20, 149, 150, 35},
	{"Fighter.  ", 40, 149, 150, 45},
	{"Ranger.  ", 50, 149, 150, 50},
	{"Scribe.  ", 70, 149, 150, 65},
	{"Witch.  ", 83, 149, 150, 75},
	{"Alchemist.  ", 93, 149, 150, 90},
	{"Lady.  ", 98, 149, 150, 110},
	{"Queen.  ", 100, 149, 150, 140},
#endif
#ifdef JP
	{"etFA[̎łB", 10, 149, 150, 35},
	{"etFA[̊l̎q̂̈lłB", 30, 149, 150, 45},
	{"etFA[̑qłB", 55, 149, 150, 50},
	{"etFA[̒qłB", 80, 149, 150, 55},
	{"etFA[̈ꗱłB", 100, 149, 150, 60},
#else
	{"You are the bastard child of a Shadow-Fairy ", 10, 148, 149, 35},
	{"You are one of several children of a Shadow-Fairy ", 30, 148, 149, 45},
	{"You are the second child of a Shadow-Fairy ", 55, 148, 149, 50},
	{"You are the first child of a Shadow-Fairy ", 80, 148, 149, 55},
	{"You are the only child of a Shadow-Fairy ", 100, 148, 149, 60},
#endif


#ifdef JP
	{"Ȃ͍", 10, 150, 151, 50},
	{"Ȃ͐[uE̓", 25, 50, 151, 50},
	{"Ȃ̓uE̓", 60, 150, 151, 50},
	{"Ȃ͒WF̓", 70, 150, 151, 50},
	{"Ȃ̓O[̓", 80, 150, 151, 50},
	{"Ȃ͐", 90, 150, 151, 50},
	{"Ȃ̓u[OC̓", 100, 150, 151, 50},
#else
	{"You have black eyes, straight ", 10, 150, 151, 50},
	{"You have dark brown eyes, straight ", 25, 50, 151, 50},
	{"You have brown eyes, straight ", 60, 150, 151, 50},
	{"You have hazel eyes, straight ", 70, 150, 151, 50},
	{"You have green eyes, straight ", 80, 150, 151, 50},
	{"You have blue eyes, straight ", 90, 150, 151, 50},
	{"You have blue-gray eyes, straight ", 100, 150, 151, 50},
#endif

#ifdef JP
	{"O[̔A", 30, 152, 153, 50},
	{"̔A", 70, 152, 153, 50},
	{"p[CG[̔A", 80, 152, 153, 50},
	{"DF̔A", 90, 152, 153, 50},
	{"p[uE̔A", 100, 152, 153, 50},
#else
	{"grey hair ", 30, 151, 152, 50},
	{"pure white hair ", 70, 151, 152, 50},
	{"pale yellow hair ", 80, 151, 152, 50},
	{"grey-white hair ", 90, 151, 152, 50},
	{"pale brown hair ", 100, 151, 152, 50},
#endif

#ifdef JP
	{"킸Ɍɂ邭炢̂Ȃ߂炩", 30, 151, 152, 50},
	{"r܂œ͂炢̂Ȃ߂炩", 60, 151, 152, 55},
	{"܂łȂ߂炩", 90, 151, 152, 60},
	{"瑫܂ŋP̂悤ɂȂ߂炩", 100, 151, 152, 75},
#else
	{"that barely covers your shoulders, ", 30, 152, 153, 50},
	{"that reaches to your arms, ", 60, 152, 153, 55},
	{"that flows down to your waist, ", 90, 152, 153, 60},
	{"that forms a shining waterfall from head to foot, ", 100, 152, 153, 75},
#endif

#ifdef JP
	{"ʂ悤ȔĂ܂B", 20, 153, 0, 50},
	{"~NF̔Ă܂B", 35, 153, 0, 50},
	{"^F̔Ă܂B", 50, 153, 0, 50},
	{"Ă܂B", 85, 153, 0, 50},
	{"Ă܂B", 100, 153, 0, 50},
#else
	{"and an extremely fair complexion.", 20, 153, 0, 50},
	{"and a milky complexion.", 35, 153, 0, 50},
	{"and a pearly complexion.", 50, 153, 0, 50},
	{"and a pale complexion.", 85, 153, 0, 50},
	{"and an utterly white complexion.", 100, 153, 0, 50},
#endif

#ifdef JP
	{"Ȃ͕iUNUNfU[gŗVłA", 4, 154, 159, 50},
	{"Ȃ͕iOO^[ŗVłA", 8, 154, 159, 50},
	{"Ȃ͕izwzwJŗVłA", 12, 154, 159, 50},
	{"Ȃ͕ihvhvrŗVłA", 16, 154, 159, 50},
	{"Ȃ͕ieNeNGZŗVłA", 20, 154, 159, 50},
	{"Ȃ͕ittŗVłA", 24, 154, 159, 50},
	{"Ȃ͕iNmNmŗVłA", 28, 154, 159, 50},
	{"Ȃ͕iNNŗVłA", 32, 154, 159, 50},
	{"Ȃ͕ieeLvŗVłA", 36, 154, 159, 50},
	{"Ȃ͕iN^[OŗVłA", 40, 154, 159, 50},
	{"Ȃ͕ieNmŗVłA", 44, 154, 159, 50},
	{"Ȃ͕ieNmAChŗVłA", 48, 154, 159, 50},
	{"Ȃ͕ieNm}ŗVłA", 52, 154, 159, 50},
	{"Ȃ͕ieNmh[ŗVłA", 56, 154, 159, 50},
	{"Ȃ͕ieNmz[ŗVłA", 60, 154, 159, 50},
	{"Ȃ͕ieNmŗVłA", 64, 154, 159, 50},
	{"Ȃ͕ieNmsقŗVłA", 68, 154, 159, 50},
	{"Ȃ͕ieNmŗVłA", 72, 154, 159, 50},
	{"Ȃ͕iXCXCAvXŗVłA", 76, 154, 159, 65},
	{"Ȃ͕iq\q\XŗVłA", 80, 154, 159, 65},
	{"Ȃ͕ieNmԌŗVłA", 84, 154, 159, 65},
	{"Ȃ͕ieNmPbgˑŗVłA", 88, 154, 159, 65},
	{"Ȃ͕i`CiEH[ŗVłA", 92, 154, 159, 65},
	{"Ȃ͕iXy[XEH[ŗVłA", 96, 154, 159, 70},
	{"Ȃ͕ieNm][gzeŗVłA", 100, 154, 159, 75},

	{"ʂ̃N^[łB", 70, 159, 160, 50},
	{"݂ȂɂĂeN^[łB", 85, 159, 160, 65},
	{"Dȃp_N^[łB", 92, 159, 161, 75},
	{"ƂĂgN^[łB", 96, 159, 162, 80},
	{"ƂĂsJN^[łB", 100, 159, 163, 90},

	{"Ȃ͐ԐF̖тA", 6, 160, 164, 50},
	{"Ȃ̓N[F̖тA", 12, 160, 164, 50},
	{"Ȃ͉yF̖тA", 18, 160, 164, 50},
	{"Ȃ͉F̖тA", 24, 160, 164, 50},
	{"Ȃ͉ΐF̖тA", 30, 160, 164, 50},
	{"Ȃ͖F̖тA", 36, 160, 164, 50},
	{"Ȃ͔ZΐF̖тA", 42, 160, 164, 50},
	{"Ȃ͐ΐF̖тA", 48, 160, 164, 50},
	{"Ȃ͐F̖тA", 54, 160, 164, 50},
	{"Ȃ͔F̖тA", 60, 160, 164, 50},
	{"Ȃ͎F̖тA", 65, 160, 164, 50},
	{"Ȃ͈F̖тA", 70, 160, 164, 60},
	{"Ȃ̓sNF̖тA", 75, 160, 164, 60},
	{"Ȃ͔F̖тA", 80, 160, 164, 60},
	{"Ȃ͐F̖тA", 85, 160, 164, 65},
	{"Ȃ͍F̖тA", 90, 160, 164, 65},
	{"Ȃ͗ΐF̖тA", 95, 160, 164, 65},
	{"Ȃ͞F̖тA", 100, 160, 164, 70},
	{"Ȃ̓p_̂悤Ȕƍ̔͗l̖тA", 100, 161, 164, 70},
	{"Ȃ̓ĝ悤ȉƍ̎Ȗ͗l̖тA", 100, 162, 164, 70},
	{"Ȃ͖邭PĂāA", 100, 163, 164, 70},

	{"}t[󕨂ɂĂ܂B", 4, 164, 0, 50},
	{"C^[󕨂ɂĂ܂B", 8, 164, 0, 50},
	{"R󕨂ɂĂ܂B", 12, 164, 0, 50},
	{"ʂ󕨂ɂĂ܂B", 16, 164, 0, 50},
	{"r󕨂ɂĂ܂B", 20, 164, 0, 50},
	{"r̂ӂ󕨂ɂĂ܂B", 24, 164, 0, 50},
	{"싅X󕨂ɂĂ܂B", 28, 164, 0, 50},
	{"ւ󕨂ɂĂ܂B", 32, 164, 0, 50},
	{"obg󕨂ɂĂ܂B", 36, 164, 0, 50},
	{"卪󕨂ɂĂ܂B", 40, 164, 0, 50},
	{"bNTbN󕨂ɂĂ܂B", 44, 164, 0, 50},
	{"Ղ󕨂ɂĂ܂B", 48, 164, 0, 50},
	{"̋󕨂ɂĂ܂B", 52, 164, 0, 50},
	{"P󕨂ɂĂ܂B", 56, 164, 0, 50},
	{"₩󕨂ɂĂ܂B", 60, 164, 0, 50},
	{"ق󕨂ɂĂ܂B", 64, 164, 0, 50},
	{"eBbV󕨂ɂĂ܂B", 68, 164, 0, 50},
	{"_}󕨂ɂĂ܂B", 71, 164, 0, 50},
	{"jW󕨂ɂĂ܂B", 75, 164, 0, 60},
	{"z󕨂ɂĂ܂B", 79, 164, 0, 60},
	{"݂񔠂󕨂ɂĂ܂B", 83, 164, 0, 60},
	{"󔠂󕨂ɂĂ܂B", 86, 164, 0, 60},
	{"eKnbg󕨂ɂĂ܂B", 90, 164, 0, 60},
	{"At󕨂ɂĂ܂B", 94, 164, 0, 65},
	{"Ⴏ󕨂ɂĂ܂B", 97, 164, 0, 65},
	{"39{E󕨂ɂĂ܂B", 100, 164, 0, 70},

#else
	{"You are a normal Kutar.  You have orange colored fur.", 65, 154, 0, 55},
	{"You are a father Kutar, the patriarch of many normal Kutars.  You have green colored fur.", 95, 154, 0, 65},
	{"You are a very rare type of Kutar, famed for the yellow and black stripes on your body.", 100, 154, 0, 80},
#endif

#ifdef JP
	{"Ȃ͂vWFNg̎iƂ", 10, 155, 156, 50},
	{"Ȃ͎q炷邽߂", 30, 155, 156, 60},
	{"Ȃ͐g̉̐b邽߂", 50, 155, 156, 70},
	{"Ȃ͖SȂq̐gƂ", 60, 155, 156, 10},
	{"Ȃ͐퓬pAhChƂ", 90, 155, 156, 20},
	{"Ȃ͐Ê߂̓Ƃ", 100, 155, 156, 10},

	{"C̋Ȋw҂ɂč܂B", 20, 156, 157, 10},
	{"Ƃ̌ō܂B", 50, 156, 157, 80},
	{"a肤Ȋw҂ɂč܂B", 85, 156, 157, 50},
	{"l̓VˏNɂč܂B", 90, 156, 157, 30},
	{"22Iė܂B", 100, 156, 157, 100},

	{"lR̂悤Ȍ`", 15, 157, 158, 40},
	{"Ck̂悤Ȍ`", 30, 157, 158, 30},
	{"N^[̂悤Ȍ`", 45, 157, 158, 20},
	{"lԂ̂悤Ȍ`", 70, 157, 158, 60},
	{"h[t̂悤Ȍ`", 80, 157, 158, 70},
	{"zrbĝ悤Ȍ`", 90, 157, 158, 70},
	{"Gt̂悤Ȍ`", 100, 157, 158, 80},

	{"܂A̓lY~ɂĂȂȂĂ܂B", 5, 158, 0, 20},
	{"ƍ҂͎咣Ă܂AƂĂ͌܂B", 20, 158, 0, 30},
	{"܂B", 85, 158, 0, 50},
	{"āA{l͎̂Ƃ{ƐMĂ܂B", 95, 158, 0, 50},
	{"āAɂ悭łĂ̂Ŗ{ƌ܂B", 100, 158, 0, 100},
#else
	{"You were created by a mad scientist ", 20, 155, 156, 10},
	{"You were created in a corporate laboratory ", 50, 155, 156, 80},
	{"You were created by a peace-loving scientist ", 85, 155, 156, 50},
	{"You were created by a boy genius ", 90, 155, 156, 30},
	{"You have come from the twenty-second century ", 100, 155, 156, 100},

	{"as a project prototype. ", 10, 156, 157, 50},
	{"to educate children. ", 30, 156, 157, 60},
	{"to look after someone. ", 50, 156, 157, 70},
	{"as a substitute for a dead child. ", 60, 156, 157, 10},
	{"as a combat trooper. ", 90, 156, 157, 20},
	{"as a tool for conquest of the world. ", 100, 156, 157, 10},

	{"You have a cat-like appearance", 15, 157, 158, 40},
	{"You have a dog-like appearance", 30, 157, 158, 30},
	{"You have a Kutar-like appearance", 45, 157, 158, 20},
	{"You have a human-like appearance", 70, 157, 158, 60},
	{"You have a dwarf-like appearance", 80, 157, 158, 70},
	{"You have a hobbit-like appearance", 90, 157, 158, 70},
	{"You have a elf-like appearance", 100, 157, 158, 80},

	{", but your ears have been eaten by mice, and no trace of them remains.", 5, 158, 0, 20},
	{"... at least your creator thinks so.  Most people disagree.", 20, 158, 0, 30},
	{".", 85, 158, 0, 50},
	{", and you firmly believe that you are a real one.", 95, 158, 0, 50},
	{", and you are almost indistinguishable from a real one.", 100, 158, 0, 100},
#endif
};

static cptr realm_jouhou[MAX_REALMS] =
{
#ifdef JP
"͉񕜔\͂ɗDꂽ@łBÂhAm@܂܂Ă܂AU킸ɎĂ܂Bɍx̎ɂ̓AfbhoɋA͂ƌĂ܂B",
"ṕumetav̈łAmӒAɑދpp̎⎩g̔\͂߂Ȃǂ֗̕Ȏ܂܂Ă܂BAڍUp͎̎Ă܂B",
"R̖@͎gp҂f̃}X^[ɂ܂Bɂ͖hATmAÂƍU܂܂Ă܂B܂AȊÖ̗ōō̎Î̗̈ɂ܂B",
"JIX̖@͐䂪ŁA\̂łȂ@܂BJIX͔ɔ񌳑fIłAJIX̎͑złłׂj󕺊łB̎̂̓JIX̐땺ɑ΂AG⎩gψق悤v܂B",
"płÍ̖@قǎ׈ȃJeS[͂܂B͔̎rIwԂ̂łAxɂȂƏp҂ɐƃAfbhRɑ\͂^܂BcOȂƂɁAƂ͂Ȏ͂̐G}ƂďpҎǧKvƂArɂ΂Ώp҂܂B",
"gv̖@̓e|[gn̎ŐIꂽ̂ĂȀo͑̐邽߂ɂg邽߁AI肷ꂽ̂lɎĂ܂BA̖@ɂđSẲʂ̏ꏊ֌Ă΂̂𗝉킯ł͂ȂAɎsƂ͓̐GƂȂ܂B",
"p̖@́ASĂ̗̈悩LpȎ悤Ƃpr̈łBKvȁuvIĂĂx̋͂Ȏ͎Ă܂BʂƂāASĂ̎͊XŔ߂邱Ƃł܂B܂Ä̗ɑ݂铯lȎ̕჌xARXgŏ邱Ƃł܂B",
"̖@́A⓹邽߂̖@܂܂Ă܂B@ɂĎg̐퓬͂ɍ߂邱Ƃł܂A𒼐ڍU悤Ȏ͊܂܂Ă܂B",
"̖@͈ÍƓlɎ׈ȃJeS[łBlXȍU@ɗDA܂̂Ƃmo\͂𓾂邱Ƃł܂Bx͈݂̎ɑAg̓̂邱Ƃł܂B",
"jׂ́u`v̖@łBړG閂@܂܂AɎ׈ȓGɑ΂ׂ͂͋̂܂BAPǂȓGɂ͂܂ʂ܂B",
"̏ẂÂɂČʂ𔭊閂@łB@ƓlAgɌʂ̂̂ƁÂ邱ƂɂĎČʂ𔭊̂܂B҂̏ꍇ́AMP̑ʂ𔭊邱Ƃł܂Aɉ̂̂1Ƃ܂B",
"|̏́AlXȐ퓬̋ZɂďĂ܂B̖{͋ZoƂɓǂޕKv܂AxoZ͎ĝɖ{Kv͂܂BZgƂɂ͕K𑕔ĂȂ΂܂B",
"p͊ނׂ̈łB̎􂢂̌t̂̂悤ɖaȂr܂B͉̎r邱ƂɂČʂ܂Bɂ͑̍s𑩔́A_[W^́AUɑ΂Ĕ̂܂B"
#else
"Life magic is very good for healing; it relies mostly on healing, protection and detection spells.  Also life magic have a few attack spells as well.  It said that some high level spell of life magic can disintegrate Undead creatures into ash.",
"Sorcery is a `meta` realm, including enchantment and general spells.  It provides superb protection spells, spells to enhance your odds in combat and, most importantly, a vast selection of spells for gathering information.  However, Sorcery has one weakness: it has no spells to deal direct damage to your enemies.",
"Nature magic makes you master of elements; it provides protection, detection, curing and attack spells.  Nature also has a spell of Herbal Healing, which is the only powerful healing spell outside the realm of Life magic.",
"There are few types of magic more unpredictable and difficult to control than Chaos magic.  Chaos is the very element of unmaking, and the Chaos spells are the most terrible weapons of destruction imaginable.  The caster can also call on the primal forces of Chaos to induce mutations in his/her opponents and even him/herself.",
"There is no fouler nor more evil category of spells than the necromantic spells of Death Magic.  These spells are relatively hard to learn, but at higher levels the spells give the caster power over living and the (un)dead, but the most powerful spells need his / her own blood as the focus, often hurting the caster in the process of casting.",
"Trump magic has, indeed, an admirable selection of teleportation spells.  Since the Trump gateways can also be used to summon other creatures, Trump magic has an equally impressive selection of summoning spells.  However, not all creatures appreciate being drawn to another place by Trump user.",
"Arcane magic is a general purpose realm of magic.  It attempts to encompass all 'useful' spells from all realms.  This is the downside of Arcane magic: while Arcane does have all the necessary 'tool' spells for a dungeon delver, it has no ultra-powerful high level spells.  As a consequence, all Arcane spellbooks can be bought in town.  It should also be noted that the 'specialized' realms usually offer the same spell at a lower level and cost. ",
"Craft magic can strengthen the caster or the equipments.  These spells can greatly improve the caster's fighting ability.  Using them against opponents directly is not possible.",
"Demon is a very evil realm, same as Death.  It provides various attack spells and devilish detection spells.  at higher levels, Demon magic provides ability to dominate demons, and to polymorph yourself into a demon.",
"Crusade is a magic of 'Justice'.  It includes damage spells, which are greatly effective against foul and evil creatures, but have poor effects against good creatures.",
"Music magic shows various effects as sing song.  There is two type of song; the one which shows effects instantly and the other one shows effect continuously until SP runs out.  But the latter type has a limit; only one song can be sing at the same time.",
"The books of Kendo describe about various combat techniques.  When learning new techniques, you are required to carry the books, but once you memorizes them, you don't have to carry them.  When using a technique, wielding a weapon is required.",
"Hex is a very terrible realm. Spells gives continual effects when they are spelled continually like songs. Spells may obstract creatures' actions, may deal damages in sight, may revenge against enemies."
#endif
};

static cptr starting_point_jouhou[STARTING_MAX] =
{
"CF_[́qҁr䂫ꂸɂ͋Ȃh̒nłBw^̑{x̉ɂ͖m**B̎iłwCF_[̖xĂ܂Bł₩**𓾂ɂ͂̓ynn߂̂ǂł傤B",
"CF[L͔Q̎푰C[NBAsт̒nɌグĒz񑩂̒nłBAŋ߂ɂȂĎw҂ł剤{h[Ƃ̈ꑰ̎Ɋŋ낵oNĂ܂B̒nɂ̓C[NȊOޓ͎̋҂َ푰̗vllAŒ̎{݂Ă܂B",
"hD[hɂ͌Â炱̓ynɏZłp̐M҂ł錴ZZł܂Bޓ͂˂ꂽ̓ĂlB̐N󂯂ĂARd˂Ă܂݂͖k̕ƒnɒǂAޓ̒zグA̍Ԃɐ[l̔O𒍂ł܂B",
"EEXg̓I[N̕RU炵̖グǓssłBł쓌ɂ̖͌łI[NB߂ÂȂƂׂa̋CɖJЂTU炵Ă܂Bǂ̖͂܂SXTE炵̂Ǝ咣Ă܂Amȏ؋͂Ȃ悤łB",

"X[ɂAOEB̖͂⌚z̗lɂāA炭͖{ẪGtグssłAۂ	ꓝ̂łwւ̉R}EF̓ẻɋ߂΂̃GtłBޏMƂAOEB̕xTsB͂ʂŋԂɒ؂̎R̖̂ҒB𖾂炩ɌŷĂ܂BAޓ͓̗񋭁AɃENA@ɑ΂Ă͔ɗFDIŁAޓ݂̍֋ɂ߂ėǎ̋𔄂邱ƂŉhA̎R̖SĂ̕xW߂Ă܂y΂Ȃɉh𓾂Ă܂B",
"̉nV́AĂ͑傫ȓsłՂcĂ܂ׂ݂͗Ȗq{̌i΂̎ꂽnłBW̖kɂ͍łȈՂłn悪LĂ܂B̒ɖY߂Rt`҂͌₿܂񂪁A͐ċA炸A镨𓾂҂͂܂ɂȂ悤łB",
"LZ_oW͔ɌÂlZłynƎv̂łAZB܂߂Ă̗Rؕ܂B{sՓV̓GmƂ푰BRƍ킵Đ܂ꂽAGȍBl̑命߂Ă܂BǂƂȂ䩗mƂԓx̏ZB́AҒBɑ΂ėFDIł͂܂A΂ɖkɍRƌꂽF̖̏邩炳ƁAf[̌Qɂ͜RƂɂȂ悤łB",
"[C͊C݂ɐڂynłA痤̌Ղ𐶋ƂƂҒB̃IAVXƂĔFmĂ܂Bk̛ĎRɂ͕̈ɋ_ȓc悤łB܂A̓ynɂb̈ꑰ͖ȂAőɌȂ͂ȕbpĂ܂B",

"TODO:Y",
"TODO:EgDm",
"TODO:oh",
"TODO:e",

"TODO:eL\~",
"TODO:OuY",
"TODO:CG",

};

// Autoroll limit
static s16b stat_limit[STAT_MAX];

static struct {
	s16b agemin, agemax;
	s16b htmin, htmax;
	s16b wtmin, wtmax;
	s16b scmin, scmax;
} chara_limit;

// Autoroll matches
static s32b stat_match[STAT_MAX];

/*
 * Autoroll round
 */
static s32b auto_round;


static void birth_quit(void)
{
	remove_loc();
	quit(NULL);
}

/*
 *  Put initial status
 */
static void put_initial_status(creature_type *creature_ptr)
{
	cptr race, cls;

	put_str("      :                                                                         ", 1, 1);
	put_str("      :                                                                         ", 2, 1);
	put_str("      :                                                                         ", 3, 1);
	put_str(KW_RACE, 1, 1);
	put_str(KW_CLASS, 2, 1);
	put_str(KW_PATRON, 3, 1);

	if(creature_ptr->race_idx1 != INDEX_NONE)
	{
		race = desc_race_name(creature_ptr, CD_SEX | CD_PURE_RACE);
		c_put_str(TERM_L_BLUE, race, 1, 9);
	}

	if(creature_ptr->class_idx != INDEX_NONE)
	{
		cls = desc_class_name(creature_ptr, CD_SUB_CLASS | CD_REALM);
		c_put_str(TERM_L_BLUE, cls, 2, 9);
	}

	if(creature_ptr->patron_idx != INDEX_NONE)
	{
		c_put_str(TERM_L_BLUE, species_name + species_info[creature_ptr->patron_idx].name, 3, 9);
	}


}


/*
 *  Show specific help file
 */
static void show_help(cptr helpfile)
{
	screen_save();
	(void)show_file(TRUE, helpfile, NULL, 0, 0);
	screen_load();
}

// Choose from one of the available magical realms
static s16b choose_realm(s32b choices, bool npc)
{
	int i;
	selection_table re[MAX_REALMS + 3];
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = realm_detail;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 20;
	se_info.num = 0;

	/* Count the choices */
	if(choices & CH_LIFE)
	{
		re[se_info.num].cap = realm_names[REALM_LIFE];
		re[se_info.num].code = REALM_LIFE;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_SORCERY)
	{
		re[se_info.num].cap = realm_names[REALM_SORCERY];
		re[se_info.num].code = REALM_SORCERY;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_NATURE)
	{
		re[se_info.num].cap = realm_names[REALM_NATURE];
		re[se_info.num].code = REALM_NATURE;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_CHAOS)
	{
		re[se_info.num].cap = realm_names[REALM_CHAOS];
		re[se_info.num].code = REALM_CHAOS;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_DEATH)
	{
		re[se_info.num].cap = realm_names[REALM_DEATH];
		re[se_info.num].code = REALM_DEATH;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_TRUMP)
	{
		re[se_info.num].cap = realm_names[REALM_TRUMP];
		re[se_info.num].code = REALM_TRUMP;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_ARCANE)
	{
		re[se_info.num].cap = realm_names[REALM_ARCANE];
		re[se_info.num].code = REALM_ARCANE;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_ENCHANT)
	{
		re[se_info.num].cap = realm_names[REALM_CRAFT];
		re[se_info.num].code = REALM_CRAFT;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_DAEMON)
	{
		re[se_info.num].cap = realm_names[REALM_DAEMON];
		re[se_info.num].code = REALM_DAEMON;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_CRUSADE)
	{
		re[se_info.num].cap = realm_names[REALM_CRUSADE];
		re[se_info.num].code = REALM_CRUSADE;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_MUSIC)
	{
		re[se_info.num].cap = realm_names[REALM_MUSIC];
		re[se_info.num].code = REALM_MUSIC;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_HISSATSU)
	{
		re[se_info.num].cap = realm_names[REALM_HISSATSU];
		re[se_info.num].code = REALM_HISSATSU;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	if(choices & CH_HEX)
	{
		re[se_info.num].cap = realm_names[REALM_HEX];
		re[se_info.num].code = REALM_HEX;
		re[se_info.num].key = '\0';
		re[se_info.num].d_color = TERM_L_DARK;
		re[se_info.num].l_color = TERM_WHITE;
		se_info.num++;
	}
	
	if(se_info.num <= 0) return REALM_NONE;

	re[se_info.num].cap = KW_RANDOM;
	re[se_info.num].code = BIRTH_SELECT_RANDOM;
	re[se_info.num].key = '*';
	re[se_info.num].d_color = TERM_UMBER;
	re[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	re[se_info.num].cap = KW_BACK_TO_START;
	re[se_info.num].code = BIRTH_SELECT_RETURN;
	re[se_info.num].key = 'S';
	re[se_info.num].d_color = TERM_UMBER;
	re[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	re[se_info.num].cap = KW_QUIT_GAME;
	re[se_info.num].code = BIRTH_SELECT_QUIT;
	re[se_info.num].key = 'Q';
	re[se_info.num].d_color = TERM_UMBER;
	re[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	if(!npc) i = get_selection(&se_info, re);
	else return (s16b)re[randint0(se_info.num - 3)].code;

	if(i >= 0) return (s16b)i;
	else if(i == BIRTH_SELECT_RANDOM) return (s16b)re[randint0(se_info.num - 3)].code;
	else return (s16b)i;

}


/*
 * Choose the magical realms
 */
static bool get_creature_realms(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	s16b i;

	if(!npc)
	{
		clear_from(0);
		put_initial_status(creature_ptr);
	}

	if(!npc)
	{
		put_str(MES_BIRTH_REALM, 0, 0);
		put_initial_status(creature_ptr);
	}

	/* Select the first realm */

	if(species_ptr->realm1 != INDEX_VARIABLE)
	{
		creature_ptr->realm1 = species_ptr->realm1;
	}
	else
	{
		creature_ptr->realm1 = REALM_NONE;
		creature_ptr->realm2 = 255;
		i = choose_realm(realm_choices1[creature_ptr->class_idx], npc);

		if(i == BIRTH_SELECT_RETURN) return BIRTH_SELECT_RETURN;
		else if(i == BIRTH_SELECT_QUIT) return BIRTH_SELECT_QUIT;
		else creature_ptr->realm1 = i;
	}

	if(!npc)
	{
		put_str(MES_BIRTH_REALM, 0, 0);
		put_initial_status(creature_ptr);
	}

	if(species_ptr->realm2 != INDEX_VARIABLE) creature_ptr->realm2 = species_ptr->realm2;
	else
	{
		
		/* Select the second realm */
		creature_ptr->realm2 = REALM_NONE;
		i = choose_realm(realm_choices2[creature_ptr->class_idx] & ~(1 << (creature_ptr->realm1 - 1)), npc);
		if(i == BIRTH_SELECT_RETURN)
			return BIRTH_SELECT_RETURN;
		else if(i == BIRTH_SELECT_QUIT)
			return BIRTH_SELECT_QUIT;
		else
			creature_ptr->realm2 = i;
	}

	return TRUE;
}

void get_max_stats(creature_type *creature_ptr)
{
	int		i, j;
	int		dice[STAT_MAX];

	/* Roll and verify some stats */
	while (TRUE)
	{
		/* Roll some dice */
		for (j = i = 0; i < STAT_MAX; i++)
		{
			/* Roll the dice */
			dice[i] = randint1(7);

			/* Collect the maximum */
			j += dice[i];
		}

		/* Verify totals */
		if(j == 24) break;
	}

	/* Acquire the stats */
	for (i = 0; i < STAT_MAX; i++)
	{
		j = STAT_VALUE_BASE_MAX_MAX + dice[i] * 10;
		// Save that value
		creature_ptr->stat_max_max[i] = (s16b)j;
		if(creature_ptr->stat_max[i] > j) creature_ptr->stat_max[i] = (s16b)j;
		if(creature_ptr->stat_cur[i] > j) creature_ptr->stat_cur[i] = (s16b)j;
	}
	creature_ptr->knowledge &= ~(KNOW_STAT);

	/* Redisplay the stats later */
	prepare_redraw(PR_STATS);
}


/*
 * Roll for some info that the auto-roller ignores
 */
static void get_extra(creature_type *creature_ptr, bool roll_hitdice)
{
	set_expfact(creature_ptr);

	// Reset record of realm changes
	creature_ptr->old_realm = 0;

	initialize_skill(creature_ptr);

	set_bodysize(creature_ptr);
	set_hitdice(creature_ptr);

	/* Roll for hit point unless quick-start */
	if(roll_hitdice) set_base_hp(creature_ptr);
}


/*
 * Get the racial history, and social class, using the "history charts".
 */
static void get_history(creature_type *creature_ptr)
{
	int i, j, n;
	char *s, *t;

	char buf[240];
	species_type *species_ptr = &species_info[creature_ptr->species_idx];
	char *history = (species_text + species_ptr->text);
	char temp[HISTORY_ROW * HISTORY_COL];


	/* Clear the previous history strings */
	for (i = 0; i < HISTORY_ROW; i++) creature_ptr->history[i][0] = '\0';

	/* Clear the history text */
	buf[0] = '\0';

	/* Skip leading spaces */
	for (s = buf; *s == ' '; s++) /* loop */;

	/* Get apparent length */
	n = strlen(s);

	if(history)
	{
		/* Clear the previous history strings */
		for (i = 0; i < HISTORY_ROW; i++) creature_ptr->history[i][0] = '\0';

		/* Skip leading spaces */
		for (s = history; *s == ' '; s++) /* loop */;

		/* Get apparent length */
		n = strlen(s);

		/* Kill trailing spaces */
		while ((n > 0) && (s[n - 1] == ' ')) s[--n] = '\0';

		roff_to_buf(s, HISTORY_COL, temp, sizeof(temp));
		t = temp;
		for (i = 0; i < HISTORY_ROW; i++)
		{
			if(t[0] == 0) break;
			else
			{
				strcpy(creature_ptr->history[i], t);
				t += strlen(t) + 1;
			}
		}

		/* Fill the remaining spaces */
		for (i = 0; i < HISTORY_ROW; i++)
		{
			for (j = 0; creature_ptr->history[i][j]; j++) /* loop */;

			for (; j < HISTORY_COL - 1; j++) creature_ptr->history[i][j] = ' ';
			creature_ptr->history[i][HISTORY_COL - 1] = '\0';
		}

	}

	if(species_ptr->sc) creature_ptr->sc = species_info->sc;
	else
	{
		creature_ptr->sc = diceroll(4, 20);
		if(one_in_(10)) creature_ptr->sc += diceroll(1, 60);
	}

}


static void set_exp(creature_type *creature_ptr, species_type *species_ptr)
{
	s32b exp1, rate1;
	u32b exp2, rate2;

	exp1 = 0;
	exp2 = species_ptr->exp;
	rate1 = 0;
	rate2 = randnor(10000, EXP_STAND_RATE);

	s64b_mul(&exp1, &exp2, rate1, rate2);
	s64b_div(&exp1, &exp2, 0, 10000);

	exp2 = (exp2 >= 0) ? exp2 : 0;

	creature_ptr->exp = creature_ptr->max_exp = creature_ptr->max_max_exp = exp2;
}


// Computes character's age
// by henkma (get_ahw)
// Modified by deskull in D'angband.
static void set_age(creature_type *creature_ptr)
{
	species_type *species_ptr = &species_info[creature_ptr->species_idx];

	if(species_ptr->age <= 0)
	{
		creature_ptr->age = race_info[creature_ptr->race_idx1].b_age + race_info[creature_ptr->race_idx2].b_age;
		creature_ptr->age += randint0((race_info[creature_ptr->race_idx1].m_age + race_info[creature_ptr->race_idx2].m_age)/2);
	}
	else
	{
		creature_ptr->age = species_ptr->age;
	}
}


// Get the player's starting money
static void get_money(creature_type *creature_ptr)
{
	int gold;

	// Starting gold
	gold = randint1(100) + 300;
	if(creature_ptr->class_idx == CLASS_TOURIST) gold += 2000;
	if(gold < 100) gold = 100;

	if(creature_ptr->chara_idx == CHARA_NAMAKE) gold /= 2;
	else if(creature_ptr->chara_idx == CHARA_MUNCHKIN) gold = 10000000;
	if(has_trait(creature_ptr, TRAIT_ANDROID)) gold /= 5;

	gold += creature_ptr->sc * (creature_ptr->lev * creature_ptr->lev + 5) / 2; // Level and social class calc

	// Save the gold
	creature_ptr->au = gold;
}



/*
 * Clear all the global "character" data
 */
void creature_wipe(creature_type *creature_ptr)
{
	int i;

	/* Hack -- free the "last message" string */
	if(creature_ptr->last_message) string_free(creature_ptr->last_message);

	/* Hack -- zero the struct */
	(void)WIPE(creature_ptr, creature_type);

	/* Wipe the history */
	for (i = 0; i < HISTORY_ROW; i++) strcpy(creature_ptr->history[i], "");

	/* No weight */
	creature_ptr->carrying_weight = 0;
	creature_ptr->equipping_weight = 0;

	/* No items */
	creature_ptr->inven_cnt = 0;
	creature_ptr->equip_cnt = 0;

	/* Clear the creature_ptr->inventory */
	for (i = 0; i < INVEN_TOTAL; i++) object_wipe(&creature_ptr->inventory[i]);

	/* Hack -- Well fed player */
	creature_ptr->food = CREATURE_FOOD_FULL - 1;

	/* Wipe the spells */
	if(creature_ptr->class_idx == CLASS_SORCERER)
	{
		creature_ptr->spell_learned1 = creature_ptr->spell_learned2 = 0xffffffffL;
		creature_ptr->spell_worked1 = creature_ptr->spell_worked2 = 0xffffffffL;
	}
	else
	{
		creature_ptr->spell_learned1 = creature_ptr->spell_learned2 = 0L;
		creature_ptr->spell_worked1 = creature_ptr->spell_worked2 = 0L;
	}
	creature_ptr->spell_forgotten1 = creature_ptr->spell_forgotten2 = 0L;
	for (i = 0; i < (REALM_MAGIC_NUMBER * 2); i++) creature_ptr->spell_order[i] = 99;
	creature_ptr->learned_spells = 0;
	creature_ptr->add_spells = 0;
	creature_ptr->knowledge = 0;

	/* Clean the mutation count */
	creature_ptr->regenerate_mod = 100;

	/* Default pet command settings */
	creature_ptr->pet_follow_distance = PET_FOLLOW_DIST;
	creature_ptr->pet_extra_flags = (PF_TELEPORT | PF_ATTACK_SPELL | PF_TRAIT_S_SPELL);

	/* Wipe the recall depths */
	for (i = 0; i < max_dungeon_idx; i++) max_dlv[i] = 0;

	creature_ptr->visit = 1;

	/* Level one */
	creature_ptr->max_plv = creature_ptr->lev = 1;

	/* Initialize arena and rewards information -KMW- */
	arena_number = 0;

	for (i = 0; i < MAX_MANE; i++)
	{
		creature_ptr->mane_spell[i] = -1;
		creature_ptr->mane_dam[i] = 0;
	}
	creature_ptr->mane_num = 0;

	/* Reset karmas*/
	for (i = 0; i < MAX_KARMA; i++) creature_ptr->karmas[i] = 0;

	creature_ptr->recall_dungeon = DUNGEON_GALGALS;

	creature_ptr->camp_idx = INDEX_NONE;
	creature_ptr->race_idx1 = INDEX_NONE;
	creature_ptr->race_idx2 = INDEX_NONE;
	creature_ptr->mimic_race_idx = INDEX_NONE;
	creature_ptr->sex = SEX_NONE;
	creature_ptr->class_idx = INDEX_NONE;
	creature_ptr->chara_idx = INDEX_NONE;
	creature_ptr->patron_idx = INDEX_NONE;
	creature_ptr->realm1 = REALM_NONE;
	creature_ptr->realm2 = REALM_NONE;

	for(i = 0; i < RACE_FLAG_MAX; i++) creature_ptr->sub_race[i] = 0x0;

	creature_ptr->total_winner = FALSE;

}

/*
 * Determine the random quest uniques
 */
void determine_random_questor(quest_type *quest_ptr)
{
	SPECIES_ID species_idx;
	species_type *species_ptr;
	int i = 0;

	get_species_num_prep_trait(NULL, t_need(1, TRAIT_UNIQUE), t_except(4, TRAIT_QUESTOR, TRAIT_FRIENDLY, TRAIT_AQUATIC, TRAIT_WILD_ONLY), 0);

	do
	{
		// Random creatures 5 - 10 levels out of depth (depending on level)
		species_idx = get_species_num(CURRENT_FLOOR_PTR, quest_ptr->level + 5 + (FLOOR_LEV)randint1(quest_ptr->level / 10));
		species_ptr = &species_info[species_idx];

		if(species_ptr->rarity > 100) continue;
		if(no_questor_or_bounty_uniques(species_idx)) continue;

		// Accept creatures that are 2 - 6 levels out of depth depending on the quest level
		if(species_ptr->level > (quest_ptr->level + (quest_ptr->level / 20))) break;
	} while (i++ < MAX_TRIES);

	quest_ptr->species_idx = species_idx;
}


/*
 *  Initialize random quests and final quests
 */
void init_dungeon_quests(void)
{
	int number_of_quests = MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1;
	int i;

	// Init the random quests
	process_dungeon_file(NULL, QUEST_INFO_FILE, 0, 0, 0, 0, INIT_ASSIGN, MIN_RANDOM_QUEST);

	// Generate quests
	for (i = MIN_RANDOM_QUEST + number_of_quests - 1; i >= MIN_RANDOM_QUEST; i--)
	{
		quest_type      *quest_ptr = &quest[i];
		species_type    *quest_r_ptr;

		quest_ptr->status = QUEST_STATUS_TAKEN;
		determine_random_questor(quest_ptr);

		/* Mark uniques */
		quest_r_ptr = &species_info[quest_ptr->species_idx];
		//TODO quest_r_ptr->flags1 |= RF1_QUESTOR;

		quest_ptr->max_num = 1;
	}

	// Init the two main quests (AOY)
	process_dungeon_file(NULL, QUEST_INFO_FILE, 0, 0, 0, 0, INIT_ASSIGN, QUEST_AOY);
	quest[QUEST_AOY].status = QUEST_STATUS_TAKEN;
}

/*
 * Reset turn
 */
static void init_turn(creature_type *creature_ptr)
{
	if(has_trait(creature_ptr, TRAIT_UNDEAD))
	{
		/* Undead start just after midnight */
		turn = (TURNS_PER_TICK * 3 * TOWN_DAWN) / 4 + 1;
		turn_limit = TURNS_PER_TICK * TOWN_DAWN * MAX_DAYS + TURNS_PER_TICK * TOWN_DAWN * 3 / 4;
	}
	else
	{
		turn = 1;
		turn_limit = TURNS_PER_TICK * TOWN_DAWN * (MAX_DAYS - 1) + TURNS_PER_TICK * TOWN_DAWN * 3 / 4;
	}
}

static int wield_one(creature_type *creature_ptr, int item, FLAGS_32 flags)
{
	object_type *object_ptr; 
	object_type *i_ptr; 
	object_type object_type_body; 
 
	int slot; 

	object_ptr = &creature_ptr->inventory[item]; 
 
	// Skip non-objects
	if(!is_valid_object(object_ptr)) return -1; 
 
	// Make sure we can wield it and that there's nothing else in that slot
	slot = WIELD_SLOT(object_ptr);

	if(slot == INVEN_SLOT_INVENTORY) return -1; 
	if(creature_ptr->inventory[slot].k_idx) return -1; 
 
	i_ptr = &object_type_body; 
	object_copy(i_ptr, object_ptr); 
 
	/* Modify quantity */ 
	i_ptr->number = 1; 
 
	increase_item(creature_ptr, item, -1, FALSE);
 
	/* Get the wield slot */ 
	object_ptr = &creature_ptr->inventory[slot]; 
 
	/* Wear the new stuff */ 
	object_copy(object_ptr, i_ptr); 
 
	set_inventory_weight(creature_ptr);
 
	/* Increment the equip counter by hand */ 
	creature_ptr->equip_cnt++;

	return slot; 
}


/* 
 * Try to wield everything wieldable in the inventory. 
 * Code taken from Angband 3.1.0 under Angband license
 */ 
static void wield_all(creature_type *creature_ptr, FLAGS_32 flags) 
{ 
	int item;
	/* Scan through the slots backwards */ 
	for (item = INVEN_TOTAL - 1; item >= 0; item--) wield_one(creature_ptr, item, flags);
	return; 
} 


// Add an outfit object
void add_item_to_creature(creature_type *creature_ptr, object_type *object_ptr, FLAGS_32 flags)
{
	s16b slot;

	if(is_player(creature_ptr) && (flags & ADD_OUTFIT_EQUIP))
	{
		object_aware(object_ptr);
		object_known(object_ptr);
	}
	slot = inven_carry(creature_ptr, object_ptr);

	/* Auto-inscription */
	autopick_alter_item(creature_ptr, slot, FALSE);

	prepare_update(creature_ptr, CRU_COMBINE | CRU_REORDER);
	notice_stuff(creature_ptr);

	if(!(flags & ADD_OUTFIT_MULTIPLE_FENCING) && object_is_weapon(object_ptr)) return;

	/* Now try wielding everything */ 
	if(flags & ADD_OUTFIT_EQUIP) wield_all(creature_ptr, flags); 

}


void race_detail(int code)
{
	bool e;
	int base = 5;
	int i;
	char buf[100], temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++)
		prt("                                                                       ", base + i, 24);
	if(code < 0) return;

#ifdef JP
	c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
	put_str("̎푰C", base, 24+strlen(race_info[code].title));
	put_str("bx:   b_i:", base, 53);
#else
	c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
	put_str("'s Main-Race modification", base, 24+strlen(race_info[code].title));
	put_str("Base Level:   Base DR :", base, 53);
#endif
	put_str(format("%8s%8s%8s%8s%8s%8s%8s",
		stat_names[STAT_STR], stat_names[STAT_INT], stat_names[STAT_WIS],
		stat_names[STAT_DEX], stat_names[STAT_CON], stat_names[STAT_CHA], KW_EXP), base+1, 24);

	sprintf(buf, "%+3d>%+3d %+3d>%+3d %+3d>%+3d %+3d>%+3d %+3d>%+3d %+3d>%+3d  %+4d%% ",
		race_info[code].r_adj[0] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_STR), race_info[code].r_adj[0],
		race_info[code].r_adj[1] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_INT), race_info[code].r_adj[1],
		race_info[code].r_adj[2] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_WIS), race_info[code].r_adj[2],
		race_info[code].r_adj[3] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_DEX), race_info[code].r_adj[3],
		race_info[code].r_adj[4] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_CON), race_info[code].r_adj[4],
		race_info[code].r_adj[5] - calc_unreached_race_level_penalty(race_info[code].lev - 1, STAT_CHA), race_info[code].r_adj[5],
		(race_info[code].r_exp - 100));
	c_put_str(TERM_L_BLUE, buf, base+2, 23);
	c_put_str(TERM_L_WHITE, ">", base+2, 26);
	c_put_str(TERM_L_WHITE, ">", base+2, 34);
	c_put_str(TERM_L_WHITE, ">", base+2, 42);
	c_put_str(TERM_L_WHITE, ">", base+2, 50);
	c_put_str(TERM_L_WHITE, ">", base+2, 58);
	c_put_str(TERM_L_WHITE, ">", base+2, 66);

	sprintf(buf, "%2d", race_info[code].lev);
	c_put_str(TERM_L_BLUE, buf, base, 64);

	if(race_info[code].dr >= 0)
	{
		sprintf(buf, "%2d", race_info[code].dr);
		c_put_str(TERM_L_BLUE, buf, base, 76);
	}
	else
		c_put_str(TERM_L_DARK, "--", base, 76);

	roff_to_buf(race_text + race_info[code].text, 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;

		if(e) prt("                                                                       ", base+4 + i, 24);
		else
		{
			prt(t, base+4 + i, 24);
			t += strlen(t) + 1;
		}
	}
}

void subrace_detail(int code)
{
	bool e;
	int base = 5;
	int i;
	char buf[100], temp[58*18];
	cptr t;

	if(code >= 0)
	{
		put_str("                                                  " , base, 24);
		put_str("                                                  " , base+1, 24);
		put_str("                                                  " , base+2, 24);
#ifdef JP
		c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
		put_str("̕푰C", base, 24+strlen(race_info[code].title));
#else
		c_put_str(TERM_L_BLUE, race_info[code].title, base, 24);
		put_str("'s Sub-Race modification", base, 24+strlen(race_info[code].title));
#endif
		put_str(format("%8s%8s%8s%8s%8s%8s%8s",
			stat_names[STAT_STR], stat_names[STAT_INT], stat_names[STAT_WIS],
			stat_names[STAT_DEX], stat_names[STAT_CON], stat_names[STAT_CHA], KW_EXP), base+1, 24);

		sprintf(buf, "%+2d      %+2d      %+2d      %+2d      %+2d      %+2d      %+4d%% ",
			race_info[code].r_s_adj[STAT_STR],
			race_info[code].r_s_adj[STAT_INT],
			race_info[code].r_s_adj[STAT_WIS],
			race_info[code].r_s_adj[STAT_DEX],
			race_info[code].r_s_adj[STAT_CON],
			race_info[code].r_s_adj[STAT_CHA],
			(race_info[code].r_s_exp - 100));
		c_put_str(TERM_L_BLUE, buf, base+2, 24);

		roff_to_buf(race_text + race_info[code].text, 56, temp, sizeof(temp));
		t = temp;
		e = FALSE;
		for (i = 0; i < 18; i++)
		{
			if(!e) if(t[0] == 0) e = TRUE;

			if(e) prt("                                                                       ", base+4 + i, 24);
			else
			{
				prt(t, base+4 + i, 24);
				t += strlen(t) + 1;
			}
		}
	}
	else
	{
		put_str("                                                      " , base, 24);
		put_str("                                                      " , base+1, 24);
		put_str("                                                      " , base+2, 24);
		for (i = 0; i < 18; i++)
			prt("                                                                       ", base+4 + i, 24);
	}


}

void class_detail(int code)
{
	bool e;
	int base = 5;
	int i;
	char buf[100], temp[58*18];
	cptr t;
	put_str("                                                      " , base, 24);
	put_str("                                                      " , base+1, 24);
	put_str("                                                      " , base+2, 24);

	for (i = 0; i < 18; i++)
	{
		prt("                                                                       ", base+4 + i, 24);
	}

	if(code < 0) return;

#ifdef JP
	c_put_str(TERM_L_BLUE, class_info[code].title, base, 24);
	put_str("̎푰C", base, 24+strlen(class_info[code].title));
#else
	c_put_str(TERM_L_BLUE, class_info[code].title, base, 24);
	put_str("'s Main-Race modification", base, 24+strlen(class_info[code].title));
#endif
	put_str(format("%8s%8s%8s%8s%8s%8s%8s",
		stat_names[STAT_STR], stat_names[STAT_INT], stat_names[STAT_WIS],
		stat_names[STAT_DEX], stat_names[STAT_CON], stat_names[STAT_CHA], KW_EXP), base+1, 24);


	sprintf(buf, "%+2d      %+2d      %+2d      %+2d       %+2d      %+2d     %+4d%% ",
		class_info[code].c_adj[STAT_STR],
		class_info[code].c_adj[STAT_INT],
		class_info[code].c_adj[STAT_WIS],
		class_info[code].c_adj[STAT_DEX],
		class_info[code].c_adj[STAT_CON],
		class_info[code].c_adj[STAT_CHA],
		class_info[code].c_exp);
	c_put_str(TERM_L_BLUE, buf, base+2, 24);

	roff_to_buf(class_text + class_info[code].text, 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e) if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base+4 + i, 24);
			t += strlen(t) + 1;
		}
	}
}


void chara_detail(int code)
{
	bool e;
	int base = 5;
	int i;
	char buf[100], temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++) prt("                                                                       ", base + i, 24);
	if(code < 0) return;

#ifdef JP
	c_put_str(TERM_L_BLUE, chara_info[code].title, base, 24);
	put_str("̎푰C", base, 24+strlen(chara_info[code].title));
#else
	c_put_str(TERM_L_BLUE, chara_info[code].title, base, 24);
	put_str("'s Main-Race modification", base, 24+strlen(chara_info[code].title));
#endif
	put_str(format("%8s%8s%8s%8s%8s%8s%8s",
		stat_names[STAT_STR], stat_names[STAT_INT], stat_names[STAT_WIS],
		stat_names[STAT_DEX], stat_names[STAT_CON], stat_names[STAT_CHA], KW_EXP), base+1, 24);

	sprintf(buf, "%+2d      %+2d      %+2d      %+2d       %+2d      %+2d     %+4d%% ",
		chara_info[code].a_adj[STAT_STR],
		chara_info[code].a_adj[STAT_INT],
		chara_info[code].a_adj[STAT_WIS],
		chara_info[code].a_adj[STAT_DEX],
		chara_info[code].a_adj[STAT_CON],
		chara_info[code].a_adj[STAT_CHA],
		0);
	c_put_str(TERM_L_BLUE, buf, base+2, 24);

	roff_to_buf(chara_text + chara_info[code].text, 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base+4 + i, 24);
			t += strlen(t) + 1;
		}
	}
}


void realm_detail(int code)
{
	bool e;
	int base = 5;
	int i;
	char temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++)
		prt("                                                                       ", base + i, 24);

	if(code < 0) return;

	roff_to_buf(realm_jouhou[technic2magic(code)-1], 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base + i, 24);
			t += strlen(t) + 1;
		}
	}
}

void starting_point_detail(int code)
{
	bool e;
	int base = 5;
	int i;
	char temp[58*18];
	cptr t;

	for (i = 0; i < 22; i++)
		prt("                                                                       ", base + i, 24);

	if(code < 0) return;

	roff_to_buf(starting_point_jouhou[code], 56, temp, sizeof(temp));
	t = temp;
	e = FALSE;
	for (i = 0; i < 18; i++)
	{
		if(!e)
			if(t[0] == 0) e = TRUE;
		else
		{
			prt(t, base + i, 24);
			t += strlen(t) + 1;
		}
	}
}

// Creature first race
static int get_creature_first_race(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, lev, weight[MAX_RACES], id[MAX_RACES];
	selection_table se[MAX_RACES + 3];
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = race_detail;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 20;
	se_info.num = 0;

	if(species_ptr->race_idx1 != INDEX_VARIABLE)
	{
		creature_ptr->race_idx1 = species_ptr->race_idx1;
		return 0;
	}

	for (i = 0, se_info.num = 0; i < MAX_RACES; i++)
	{
		if(race_info[i].race_category < RACE_RARITY_UNSELECTABLE)
		{
			se[se_info.num].cap = race_name + race_info[i].name;
			se[se_info.num].code = i;
			se[se_info.num].key = '\0';
			se[se_info.num].d_color = TERM_L_DARK;
			se[se_info.num].l_color = TERM_WHITE;
			id[se_info.num] = i;
			weight[se_info.num] = 100000;
			if(race_info[i].race_category == RACE_RARITY_UNCOMMON) weight[se_info.num] /= 5;
			if(race_info[i].race_category == RACE_RARITY_RARE) weight[se_info.num] /= 40;
			if(race_info[i].race_category == RACE_RARITY_LEGENDARY) weight[se_info.num] /= 200;

			for(lev = 0; lev < CREATURE_MAX_LEVEL || creature_exp[lev] * 2 <= species_ptr->exp; lev++);
			if(lev < race_info[i].lev) weight[se_info.num] /= ((race_info[i].lev - lev) * (race_info[i].lev - lev));  

			if(species_ptr->dr < race_info[i].dr) weight[se_info.num] /= ((race_info[i].dr - species_ptr->dr) * (race_info[i].dr - species_ptr->dr));
			if(weight[se_info.num] <= 0) weight[se_info.num] = 1;
			se_info.num++;
		}
	}

	if(npc)
	{
		creature_ptr->race_idx1 = (s16b)uneven_rand(id, weight, se_info.num);
		return 0;
	}

	se[se_info.num].cap = KW_RANDOM;
	se[se_info.num].code = BIRTH_SELECT_RANDOM;
	se[se_info.num].key = '*';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_BACK_TO_START;
	se[se_info.num].code = BIRTH_SELECT_RETURN;
	se[se_info.num].key = 'S';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_QUIT_GAME;
	se[se_info.num].code = BIRTH_SELECT_QUIT;
	se[se_info.num].key = 'Q';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

#if JP
	put_str("푰Iĉ:", 0, 0);
#else
	put_str("Select a race:", 0, 0);
#endif

	i = get_selection(&se_info, se);

	if(i >= 0)
	{
		creature_ptr->race_idx1 = (s16b)i;
		return 0;
	}
	else if(i == BIRTH_SELECT_RANDOM)
	{
		creature_ptr->race_idx1 = (s16b)se[randint0(se_info.num - 3)].code;
		return 0;
	}
	else
	{
		return i;
	}
}

// Creature sub-race
static int get_creature_second_race(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i;
	selection_table se[MAX_RACES + 3];
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = race_detail;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 20;
	se_info.num = 0;

	if(species_ptr->race_idx2 != INDEX_VARIABLE)
	{
		creature_ptr->race_idx2 = species_ptr->race_idx2;
		return 0;
	}

	se[se_info.num].cap = KW_PURE_BLOOD;
	se[se_info.num].code = creature_ptr->race_idx1;
	se[se_info.num].key = '\0';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	for (i = 0; i < MAX_RACES; i++)
	{
		if(race_crossing[creature_ptr->race_idx1][i] > 0 && creature_ptr->race_idx1 != i)
		{
			se[se_info.num].cap = race_info[i].title;
			se[se_info.num].code = i;
			se[se_info.num].key = '\0';
			se[se_info.num].d_color = TERM_L_DARK;
			se[se_info.num].l_color = TERM_WHITE;
			se_info.num++;
		}
	}

	se[se_info.num].cap = KW_RANDOM;
	se[se_info.num].code = BIRTH_SELECT_RANDOM;
	se[se_info.num].key = '*';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_BACK_TO_START;
	se[se_info.num].code = BIRTH_SELECT_RETURN;
	se[se_info.num].key = 'S';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_QUIT_GAME;
	se[se_info.num].code = BIRTH_SELECT_QUIT;
	se[se_info.num].key = 'Q';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	if(npc)
	{
		if(one_in_(RATE_OF_HALF_RACE))
		{
			creature_ptr->race_idx2 = (s16b)se[randint0(se_info.num-3)].code;
			return 0;
		}
		else
		{
			creature_ptr->race_idx2 = creature_ptr->race_idx1;
			return 0;
		}
	}

#if JP
		put_str("푰Iĉ:", 0, 0);
#else
		put_str("Select second race:", 0, 0);
#endif
		i = get_selection(&se_info, se);

	if(i >= 0)
	{
		creature_ptr->race_idx2 = (s16b)i;
		return 0;
	}
	else if(i == BIRTH_SELECT_RANDOM)
	{
		int t = randint0(se_info.num-3);
		creature_ptr->race_idx2 = (s16b)se[t].code;
		return 0;
	}
	else return i;
}

// Player SubRace(Eldar)
static bool get_creature_subrace_eldar(creature_type *creature_ptr, bool npc)
{
/*
	int i, n = 0;
	selection_table se[3 + 3];

	strcpy(se[n].cap, race_info[RACE_TELERI_LINEAGE].title);
	se[n].code = RACE_TELERI_LINEAGE;
	se[n].key = '\0';
	se[n].d_color = TERM_L_DARK;
	se[n].l_color = TERM_WHITE;
	n++;

	strcpy(se[n].cap, race_info[RACE_NOLDOR_LINEAGE].title);
	se[n].code = RACE_NOLDOR_LINEAGE;
	se[n].key = '\0';
	se[n].d_color = TERM_L_DARK;
	se[n].l_color = TERM_WHITE;
	n++;

	strcpy(se[n].cap, race_info[RACE_VANYAR_LINEAGE].title);
	se[n].code = RACE_VANYAR_LINEAGE;
	se[n].key = '\0';
	se[n].d_color = TERM_L_DARK;
	se[n].l_color = TERM_WHITE;
	n++;

	strcpy(se[n].cap, KW_RANDOM);
	se[n].code = BIRTH_SELECT_RANDOM;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	strcpy(se[n].cap, KW_BACK_TO_START);
	se[n].code = BIRTH_SELECT_RETURN;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	strcpy(se[n].cap, KW_QUIT_GAME);
	se[n].code = BIRTH_SELECT_QUIT;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	if(!npc)
	{
#if JP
		put_str("G_[̕푰Iĉ:", 0, 0);
#else
		put_str("Select a sub-race of Eldar:", 0, 0);
#endif
		i = get_selection(NULL, se, n, 5, 2, 18, 20, subrace_detail, 0);
	}
	else
	{
		set_subrace(creature_ptr, se[randint0(3)].code, TRUE);
		return 0;
	}

	if(i >= 0)
	{
		set_subrace(creature_ptr, i, TRUE);
		return 0;
	}
	if(i == BIRTH_SELECT_RANDOM)
	{
		set_subrace(creature_ptr, se[randint0(3)].code, TRUE);
		return 0;
	}
	else
	{
		return i;
	}


*/
	return 0;

}

// Creature SubRace(Dragon & Draconian)
static bool get_creature_subrace_dragonbone(creature_type *creature_ptr, bool npc)
{
	/*
	int i, n = 0;
	selection_table se[15];

	strcpy(se[n].cap, race_info[RACE_RED_LINEAGE].title);
	se[n].code = RACE_RED_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_WHITE_LINEAGE].title);
	se[n].code = RACE_WHITE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BLUE_LINEAGE].title);
	se[n].code = RACE_BLUE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BLACK_LINEAGE].title);
	se[n].code = RACE_BLACK_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_GREEN_LINEAGE].title);
	se[n].code = RACE_GREEN_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_CHROMATIC_LINEAGE].title);
	se[n].code = RACE_CHROMATIC_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BRONZE_LINEAGE].title);
	se[n].code = RACE_BRONZE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_GOLD_LINEAGE].title);
	se[n].code = RACE_GOLD_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_CRYSTAL_LINEAGE].title);
	se[n].code = RACE_CRYSTAL_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_LAW_LINEAGE].title);
	se[n].code = RACE_LAW_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_BALANCE_LINEAGE].title);
	se[n].code = RACE_BALANCE_LINEAGE;
	n++;
	strcpy(se[n].cap, race_info[RACE_CHAOS_LINEAGE].title);
	n++;
	se[n].code = RACE_CHAOS_LINEAGE;

	for(i = 0; i < 12; i++)
	{
		se[i].d_color = TERM_L_DARK;
		se[i].l_color = TERM_WHITE;
		se[i].key = '\0';
	}

	strcpy(se[n].cap, KW_RANDOM);
	se[n].code = BIRTH_SELECT_RANDOM;
	se[n].key = '*';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	strcpy(se[n].cap, KW_BACK_TO_START);
	se[n].code = BIRTH_SELECT_RETURN;
	se[n].key = 'S';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	strcpy(se[n].cap, KW_QUIT_GAME);
	se[n].code = BIRTH_SELECT_QUIT;
	se[n].key = 'Q';
	se[n].d_color = TERM_UMBER;
	se[n].l_color = TERM_L_UMBER;
	n++;

	if(!npc)
	{
#if JP
		put_str("̕푰Iĉ:", 0, 0);
#else
		put_str("Select a sub-race of Dragonbone:", 0, 0);
#endif
		i = get_selection(NULL, se, n, 5, 2, 18, 20, subrace_detail, 0);
	}
	else
	{
		set_subrace(creature_ptr, se[randint0(12)].code, TRUE);
		return 0;
	}

	if(i >= 0)
	{
		set_subrace(creature_ptr, i, TRUE);
		return 0;
	}
	if(i == BIRTH_SELECT_RANDOM)
	{
		set_subrace(creature_ptr, se[randint0(12)].code, TRUE);
		return 0;
	}
	else
	{
		return i;
	}

*/
	return TRUE;

}

// Creature sex
static int get_creature_sex(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, category_num;
	selection_table se[MAX_SEXES + 3];
	int id[MAX_SEXES + 1], weight1[MAX_SEXES + 1], weight2[MAX_SEXES];
	int list[MAX_SEXES] = {SEX_MALE, SEX_FEMALE, SEX_INTERSEX, SEX_NONE};
	int trait_list[MAX_SEXES] = {TRAIT_MALE, TRAIT_FEMALE, TRAIT_INTERSEX, TRAIT_NOSEX};
	int left_per = 100;
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = NULL;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 20;
	se_info.num = 0;

	if(species_ptr->sex != INDEX_VARIABLE)
	{
		creature_ptr->sex = species_ptr->sex;
		return 0;
	}

	for (i = 0, se_info.num = 0, category_num = 0; i < MAX_SEXES; i++)
	{
		se[se_info.num].cap = sex_info[list[i]].title;
		se[se_info.num].code = list[i];
		se[se_info.num].key = '\0';
		id[se_info.num] = list[i];
		if(race_info[creature_ptr->race_idx1].sex_flag & (0x01 << list[i]) || race_info[creature_ptr->race_idx2].sex_flag & (0x01 << list[i]))
		{
			se[se_info.num].d_color = TERM_L_DARK;
			se[se_info.num].l_color = TERM_WHITE;
			if(has_trait_species(species_ptr, trait_list[i]))
			{
				weight1[se_info.num] = species_ptr->flags.probability[trait_list[i]];
				left_per -= weight1[se_info.num];
			}
			else weight1[se_info.num] = 0;
			weight2[se_info.num] = 100;
		}
		else
		{
			se[se_info.num].d_color = TERM_RED;
			se[se_info.num].l_color = TERM_L_RED;
			weight1[se_info.num] = 0;
			weight2[se_info.num] = 0;
		}
		se_info.num++;
		category_num++;
	}

	if(npc)
	{
		id[se_info.num] = MAX_SEXES;
		weight1[se_info.num] = left_per > 0 ? left_per: 0;
		se_info.num++;
		creature_ptr->sex = (s16b)uneven_rand(id, weight1, se_info.num);
		if(creature_ptr->sex == MAX_SEXES) creature_ptr->sex = (s16b)uneven_rand(id, weight2, se_info.num-1);
		return 0;
	}

	se[se_info.num].cap = KW_RANDOM;
	se[se_info.num].code = BIRTH_SELECT_RANDOM;
	se[se_info.num].key = '*';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_BACK_TO_START;
	se[se_info.num].code = BIRTH_SELECT_RETURN;
	se[se_info.num].key = 'S';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_QUIT_GAME;
	se[se_info.num].code = BIRTH_SELECT_QUIT;
	se[se_info.num].key = 'Q';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

#if JP
		put_str("ʂIĉ(Ԏ̐ʂɂ͎푰yieB܂):", 0, 0);
#else
		put_str("Select a sex(Red entries have race penalty) ", 0, 0);
#endif
		i = get_selection(&se_info, se);

	if(i >= 0)
	{
		creature_ptr->sex = (s16b)i;
		return 0;
	}
	else if(i == BIRTH_SELECT_RANDOM)
	{
		creature_ptr->sex = (s16b)se[randint0(category_num)].code;
		return 0;
	}
	else return i;
}

// Player class
static bool get_creature_class(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, n, id[MAX_CLASS], weight[MAX_CLASS];
	selection_table ce[MAX_CLASS+3];
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = class_detail;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 20;
	se_info.num = 0;

	if(species_ptr->class_idx != INDEX_VARIABLE)
	{
		creature_ptr->class_idx = species_ptr->class_idx;
		return 0;
	}

	clear_from(0);
	if(!npc) put_initial_status(creature_ptr);

	for (i = 0, n = 0; i < MAX_CLASS; i++)
	{
		if(class_info[i].selectable)
		{
			ce[se_info.num].cap = class_info[i].title;
			id[se_info.num] = i;
			if(class_info[i].rarity) weight[se_info.num] = 10000 / class_info[i].rarity;
			else weight[se_info.num] = 0;
			ce[se_info.num].code = i;
			ce[se_info.num].key = '\0';
			ce[se_info.num].d_color = TERM_L_DARK;
			ce[se_info.num].l_color = TERM_WHITE;
			if(SUITABLE_CLASS(creature_ptr, i))
			{
				ce[se_info.num].d_color = TERM_GREEN;
				ce[se_info.num].l_color = TERM_L_GREEN;
			}
			else
			{
				ce[se_info.num].d_color = TERM_L_DARK;
				ce[se_info.num].l_color = TERM_WHITE;
			}
			se_info.num++;
		}
	}

	if(npc)
	{
		creature_ptr->class_idx = (s16b)uneven_rand(id, weight, n);
		return 0;
	}

	ce[se_info.num].cap = KW_RANDOM;
	ce[se_info.num].code = BIRTH_SELECT_RANDOM;
	ce[se_info.num].key = '*';
	ce[se_info.num].d_color = TERM_UMBER;
	ce[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	ce[se_info.num].cap = KW_BACK_TO_START;
	ce[se_info.num].code = BIRTH_SELECT_RETURN;
	ce[se_info.num].key = 'S';
	ce[se_info.num].d_color = TERM_UMBER;
	ce[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	ce[se_info.num].cap = KW_QUIT_GAME;
	ce[se_info.num].code = BIRTH_SELECT_QUIT;
	ce[se_info.num].key = 'Q';
	ce[se_info.num].d_color = TERM_UMBER;
	ce[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

#if JP
	put_str("EƂIĉ(Ύ̐EƂɂ͎푰{[iX܂):", 0, 0);
#else
	put_str("Select a class(Any green entries have race bonus):", 0, 0);
#endif

	if(!npc) put_initial_status(creature_ptr);
	i = get_selection(&se_info, ce);

	if(i >= 0)
	{
		creature_ptr->class_idx = (s16b)i;
		return 0;
	}
	else if(i == BIRTH_SELECT_RANDOM)
	{
		creature_ptr->class_idx = (s16b)ce[randint0(n - 3)].code;
		return 0;
	}
	else return i;
}

// Player patron
static bool get_creature_patron(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i, n = 0;
	selection_table pt[400+3];
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = NULL;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 76;
	se_info.num = 0;

	if(species_ptr->patron_idx != INDEX_VARIABLE)
	{
		creature_ptr->patron_idx = species_ptr->patron_idx;
		return 0;
	}

	for (i = 0; i < max_species_idx; i++)
	{
		if(!has_trait_species(&species_info[i], TRAIT_UNIQUE)) continue;		
		if(species_info[i].dr < 5 || species_info[i].dr < calc_base_divine_rank(creature_ptr)) continue;
		
		if(IS_PURE_RACE(creature_ptr, RACE_MELNIBONE))
		{
			if(i != SPECIES_ARIOCH) continue;
		}

		if(IS_PURE_RACE(creature_ptr, RACE_AMBERITE))
		{
			if(i != SPECIES_UNICORN_ORD) continue;
		}

		if(IS_PURE_RACE(creature_ptr, RACE_CHAOSIAN))
		{
			if(i != SPECIES_SERPENT) continue;
		}

		if(IS_PURE_RACE(creature_ptr, RACE_ISTARI))
		{
			if(!has_trait_raw(&species_info[i].flags, TRAIT_AMAN)) continue;		
		}

		pt[se_info.num].cap = species_name + species_info[i].name;
		pt[se_info.num].code = i;
		pt[se_info.num].key = '\0';
		pt[se_info.num].d_color = TERM_L_DARK;
		pt[se_info.num].l_color = TERM_WHITE;
		se_info.num++; 
		
		if(n == 400) break;
	}

	pt[se_info.num].cap = KW_RANDOM;
	pt[se_info.num].code = BIRTH_SELECT_RANDOM;
	pt[se_info.num].key = '*';
	pt[se_info.num].d_color = TERM_UMBER;
	pt[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	pt[se_info.num].cap = KW_BACK_TO_START;
	pt[se_info.num].code = BIRTH_SELECT_RETURN;
	pt[se_info.num].key = 'S';
	pt[se_info.num].d_color = TERM_UMBER;
	pt[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	pt[se_info.num].cap = KW_QUIT_GAME;
	pt[se_info.num].code = BIRTH_SELECT_QUIT;
	pt[se_info.num].key = 'Q';
	pt[se_info.num].d_color = TERM_UMBER;
	pt[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	if(npc)
	{
		creature_ptr->patron_idx = (s16b)pt[randint0(se_info.num)].code;
		return 0;
	}

	put_str(MES_BIRTH_PATRON, 0, 0);
	if(!npc) put_initial_status(creature_ptr);
	i = get_selection(&se_info, pt);

	if(i >= 0)
	{
		creature_ptr->patron_idx = (s16b)i;
		return 0;
	}
	else if(i == BIRTH_SELECT_RANDOM)
	{
		creature_ptr->patron_idx = (s16b)pt[randint0(n - 3)].code;
		return 0;
	}
	else return i;

}

// Player Chara
static bool get_creature_chara(creature_type *creature_ptr, species_type *species_ptr, bool npc)
{
	int i;
	selection_table ce[MAX_CHARA + 3];
	int id[MAX_CHARA];
	int weight[MAX_CHARA];
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = chara_detail;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 20;
	se_info.num = 0;

	if(!npc)
	{
		clear_from(0);
		put_initial_status(creature_ptr);
	}

	if(creature_ptr->patron_idx == SPECIES_ILUVATAR)
	{
		creature_ptr->chara_idx = CHARA_MUNCHKIN;
		return 0;
	}

	if(species_ptr->chara_idx != INDEX_VARIABLE)
	{
		creature_ptr->chara_idx = species_ptr->chara_idx;
		return 0;
	}

	for (i = 0; i < MAX_CHARA; i++)
	{
		if((chara_info[i].sex & (0x01 << creature_ptr->sex)) && (!npc || chara_info[i].rarity < 100))
		{
			ce[se_info.num].cap = chara_info[i].title;
			ce[se_info.num].code = i;
			ce[se_info.num].key = '\0';
			ce[se_info.num].d_color = TERM_L_DARK;
			ce[se_info.num].l_color = TERM_WHITE;

			id[se_info.num] = i;
			weight[se_info.num] = (chara_info[i].rarity ? 10000 / chara_info[i].rarity : 10000);
			se_info.num++;
		}
	}

	if(npc)
	{
		creature_ptr->chara_idx = (s16b)uneven_rand(id, weight, se_info.num);
		return 0;
	}

	ce[se_info.num].cap = KW_RANDOM;
	ce[se_info.num].code = BIRTH_SELECT_RANDOM;
	ce[se_info.num].key = '*';
	ce[se_info.num].d_color = TERM_UMBER;
	ce[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	ce[se_info.num].cap = KW_BACK_TO_START;
	ce[se_info.num].code = BIRTH_SELECT_RETURN;
	ce[se_info.num].key = 'S';
	ce[se_info.num].d_color = TERM_UMBER;
	ce[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	ce[se_info.num].cap = KW_QUIT_GAME;
	ce[se_info.num].code = BIRTH_SELECT_QUIT;
	ce[se_info.num].key = 'Q';
	ce[se_info.num].d_color = TERM_UMBER;
	ce[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	put_str(MES_BIRTH_PERSONALITY, 0, 0);

	if(!npc) put_initial_status(creature_ptr);
	i = get_selection(&se_info, ce);

	if(i >= 0)
	{
		creature_ptr->chara_idx = (s16b)i;
		return 0;
	}
	else if(i == BIRTH_SELECT_RANDOM)
	{
		creature_ptr->chara_idx = (s16b)uneven_rand(id, weight, se_info.num - 3);
		return 0;
	}
	else return i;
}

// Player Starting Point
static bool get_starting_point(creature_type *creature_ptr, bool npc)
{
	int i, j, n;
	selection_table se[STARTING_MAX + 3];
	selection_info se_info;

	se_info.mode = 0;
	se_info.caption = NULL;
	se_info.detail = starting_point_detail;
	se_info.default_se = 0;
	se_info.y = 5;
	se_info.x = 2;
	se_info.h = 18;
	se_info.w = 20;
	se_info.num = 0;

	clear_from(0);
	if(!npc) put_initial_status(creature_ptr);

	for (i = 0, n = 0; i < STARTING_MAX; i++)
	{
		if(starting_point[i].enable)
		{
			se[se_info.num].cap = starting_point[i].name;
			se[se_info.num].code = i;
			se[se_info.num].key = '\0';
			se[se_info.num].d_color = TERM_L_DARK;
			se[se_info.num].l_color = TERM_WHITE;
			se_info.num++;
		}
	}

	se[se_info.num].cap = KW_RANDOM;
	se[se_info.num].code = BIRTH_SELECT_RANDOM;
	se[se_info.num].key = '*';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_BACK_TO_START;
	se[se_info.num].code = BIRTH_SELECT_RETURN;
	se[se_info.num].key = 'S';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	se[se_info.num].cap = KW_QUIT_GAME;
	se[se_info.num].code = BIRTH_SELECT_QUIT;
	se[se_info.num].key = 'Q';
	se[se_info.num].d_color = TERM_UMBER;
	se[se_info.num].l_color = TERM_L_UMBER;
	se_info.num++;

	if(!npc)
	{
		put_str(MES_BIRTH_START_POINT, 0, 0);
		i = get_selection(&se_info, se);
	}
	else
	{
		j = se[randint0(n - 3)].code;
		creature_ptr->start_wy = starting_point[j].wy;
		creature_ptr->start_wx = starting_point[j].wx;
		return 0;
	}

	if(i >= 0)
	{
		creature_ptr->start_wy = starting_point[i].wy;
		creature_ptr->start_wx = starting_point[i].wx;
		return 0;
	}
	else if(i == BIRTH_SELECT_RANDOM)
	{
		j = se[randint0(n - 3)].code;
		creature_ptr->start_wy = starting_point[j].wy;
		creature_ptr->start_wx = starting_point[j].wx;
		return 0;
	}
	else return i;
}

static bool get_stat_limits(creature_type *creature_ptr)
{
	int i, j, m, cs, os;
	int mval[STAT_MAX];
	s16b cval[STAT_MAX];
	char c;
	char buf[80], cur[80];
	char inp[80];

	clear_from(0);

	/* Extra infomation */
#ifdef JP
	put_str("\͒lUĂB", 10, 10);
	put_str("2/8ōڑIA4/6Œl̑AEnterŎ", 11, 10);
	put_str("         {l  푰 E i     vl  ől", 13, 10);
#else
	put_str("Set stats.", 10, 10);
	put_str("2/8 for Select, 4/6 for Change value, Enter for Goto next", 11, 10);
	put_str("           Base   Rac  Cla  Per      Total  Maximum", 13, 10);
#endif

	/* Output the maximum stats */
	for (i = 0; i < STAT_MAX; i++)
	{
		/* Reset the "success" counter */
		stat_match[i] = 0;
		cval[i] = 3;

		/* Race/Class bonus */
		if(IS_PURE(creature_ptr))
			j = race_info[creature_ptr->race_idx1].r_adj[i];
		else
			j = race_info[creature_ptr->race_idx1].r_s_adj[i] + race_info[creature_ptr->race_idx2].r_s_adj[i];
		
		j += class_info[creature_ptr->class_idx].c_adj[i] + chara_info[creature_ptr->chara_idx].a_adj[i];

		/* Save the maximum */
		mval[i] = j;
		sprintf(cur, "%2d", j / 10);
		sprintf(inp, "%2d", j / 10);

		/* Prepare a prompt */
		//TODO
		sprintf(buf, "%6s       %2d   %+3d  %+3d  %+3d  =  %6s  %6s",
			stat_names[i], cval[i], race_info[creature_ptr->race_idx1].r_adj[i], class_info[creature_ptr->class_idx].c_adj[i],
			chara_info[creature_ptr->chara_idx].a_adj[i], inp, cur);
		
		/* Dump the prompt */
		put_str(buf, 14 + i, 10);
	}
	
	/* Get a minimum stat */
	cs = 0;
	os = STAT_MAX;
	while (TRUE)
	{
		/* Move Cursol */
		if(cs != os)
		{
			
			if(os == STAT_MAX) c_put_str(TERM_WHITE, KW_ACCEPT, 21, 35);
			else if(os < STAT_MAX) c_put_str(TERM_WHITE, cur, 14 + os, 10);
			if(cs == STAT_MAX) c_put_str(TERM_YELLOW, KW_ACCEPT, 21, 35);
			else
			{
				/* Race/Class bonus */
				j = race_info[creature_ptr->race_idx1].r_adj[cs] + class_info[creature_ptr->class_idx].c_adj[cs] + chara_info[creature_ptr->chara_idx].a_adj[cs];

				/* Obtain the current stat */
				m = j;
				
				sprintf(inp, "%2d", m);
				
				/* Prepare a prompt */
				sprintf(cur, "%6s       %2d   %+3d  %+3d  %+3d  =  %6s",
					stat_names[cs], cval[cs], race_info[creature_ptr->race_idx1].r_adj[cs],
					class_info[creature_ptr->class_idx].c_adj[cs], chara_info[creature_ptr->chara_idx].a_adj[cs], inp);
				c_put_str(TERM_YELLOW, cur, 14 + cs, 10);
			}
			os = cs;
		}
		
		/* Prompt for the minimum stats */
		c = inkey();
		switch ( c ){
		case 'Q':
			birth_quit();
		case 'S':
			return FALSE;
		case ESCAPE:
			break;
		case ' ':
		case '\r':
		case '\n':
			if(cs == 6) break;
			cs++;
			c = '2';
			break;
		case '8':
		case 'k':
			if(cs > 0) cs--;
			break;
		case '2':
		case 'j':
			if(cs < STAT_MAX) cs++;
			break;
		case '4':
		case 'h':
			if(cs != STAT_MAX)
			{
				if(cval[cs] == 3)
				{
					cval[cs] = 17;
					os = 7;
				}
				else if(cval[cs] > 3)
				{
					cval[cs]--;
					os = 7;
				}
				else return FALSE;
			}
			break;
		case '6':
		case 'l':
			if(cs != 6)
			{
				if(cval[cs] == 17)
				{
					cval[cs] = 3;
					os = 7;
				}
				else if(cval[cs] < 17)
				{
					cval[cs]++;
					os = 7;
				}
				else return FALSE;
			}
			break;
		case 'm':
			if(cs != 6)
			{
				cval[cs] = 17;
				os = 7;
			}
			break;
		case 'n':
			if(cs != 6)
			{
				cval[cs] = 3;
				os = 7;
			}
			break;
		case '?':
			show_help(TEXT_FILES_BIRTH_AUTO_ROLLER);
			break;
		default:
			bell();
			break;
		}
		if(c == ESCAPE || ((c == ' ' || c == '\r' || c == '\n') && cs == 6))break;
	}

	/* Save the minimum stat */
	for (i = 0; i < STAT_MAX; i++) stat_limit[i] = cval[i];

	return TRUE;
}

#define HISTPREF_LIMIT 1024
static char *histpref_buf = NULL;

/*
 * Hook function for reading the histpref.prf file.
 */
void add_history_from_pref_line(cptr t)
{
	/* Do nothing if the buffer is not ready */
	if(!histpref_buf) return;

	my_strcat(histpref_buf, t, HISTPREF_LIMIT);
}


static bool do_cmd_histpref(creature_type *creature_ptr)
{
	char buf[80];
	errr err;
	int i, j, n;
	char *s, *t;
	char temp[HISTORY_ROW * HISTORY_COL];
	char histbuf[HISTPREF_LIMIT];
	if(!get_check(MES_BIRTH_PROFILE_LOAD_ASK)) return FALSE;

	/* Prepare the buffer */
	histbuf[0] = '\0';
	histpref_buf = histbuf;

	sprintf(buf, TEXT_FILES_HISTEDIT_N, player_base);
	err = process_histpref_file(buf);

	/* Process 'hist????.prf' if 'hist????-<name>.prf' doesn't exist */
	if(0 > err)
	{
		strcpy(buf, TEXT_FILES_HISTEDIT);
		err = process_histpref_file(buf);
	}

	if(err)
	{
		msg_print(MES_BIRTH_PROFILE_LOAD_FAILED);
		msg_print(NULL);

		/* Kill the buffer */
		histpref_buf = NULL;
		return FALSE;
	}
	else if(!histpref_buf[0])
	{
		msg_print(MES_BIRTH_PROFILE_LOAD_NO_DATA);
		msg_print(NULL);

		/* Kill the buffer */
		histpref_buf = NULL;

		return FALSE;
	}

	/* Clear the previous history strings */
	for (i = 0; i < HISTORY_ROW; i++) creature_ptr->history[i][0] = '\0';

	/* Skip leading spaces */
	for (s = histpref_buf; *s == ' '; s++) /* loop */;

	/* Get apparent length */
	n = strlen(s);

	/* Kill trailing spaces */
	while ((n > 0) && (s[n - 1] == ' ')) s[--n] = '\0';

	roff_to_buf(s, HISTORY_COL, temp, sizeof(temp));
	t = temp;
	for (i = 0; i < HISTORY_ROW; i++)
	{
		if(t[0] == 0) break;
		else
		{
			strcpy(creature_ptr->history[i], t);
			t += strlen(t) + 1;
		}
	}

	/* Fill the remaining spaces */
	for (i = 0; i < HISTORY_ROW; i++)
	{
		for (j = 0; creature_ptr->history[i][j]; j++) /* loop */;

		for (; j < HISTORY_COL - 1; j++) creature_ptr->history[i][j] = ' ';
		creature_ptr->history[i][HISTORY_COL - 1] = '\0';
	}

	/* Kill the buffer */
	histpref_buf = NULL;

	return TRUE;
}

/*
 *  Character background edit-mode
 */
static void edit_history(creature_type *creature_ptr)
{
	char old_history[HISTORY_ROW][HISTORY_COL];
	int y = 0, x = 0;
	int i, j;

	/* Edit character background */
	for (i = 0; i < HISTORY_ROW; i++)
	{
		sprintf(old_history[i], "%s", creature_ptr->history[i]);
	}
	/* Turn 0 to space */
	for (i = 0; i < HISTORY_ROW; i++)
	{
		for (j = 0; creature_ptr->history[i][j]; j++) /* loop */;

		for (; j < HISTORY_COL - 1; j++) creature_ptr->history[i][j] = ' ';
		creature_ptr->history[i][HISTORY_COL - 1] = '\0';
	}
	display_creature_status(1, creature_ptr);
	c_put_str(TERM_L_GREEN, KW_CREATURE_PROFILE_EDITING, 2, 20);
	put_str(MES_INTERFACE_EDIT_HISTORY, 23, 10);

	while (TRUE)
	{
		int skey;
		char c;

		for (i = 0; i < HISTORY_ROW; i++)
		{
			put_str(creature_ptr->history[i], i + 4, 3);
		}
#ifdef JP
		if(iskanji2(creature_ptr->history[y], x))
			c_put_str(TERM_L_BLUE, format("%c%c", creature_ptr->history[y][x],creature_ptr->history[y][x+1]), y + 4, x + 3);
		else
#endif
		c_put_str(TERM_L_BLUE, format("%c", creature_ptr->history[y][x]), y + 4, x + 3);

		/* Place cursor just after cost of current stat */
		Term_gotoxy(x + 3, y + 4);

		/* Get special key code */
		skey = inkey_special(TRUE);

		/* Get a character code */
		if(!(skey & SKEY_MASK)) c = (char)skey;
		else c = 0;

		if(skey == SKEY_UP || c == KTRL('p'))
		{
			y--;
			if(y < 0) y = HISTORY_ROW - 1;
#ifdef JP
			if((x > 0) && (iskanji2(creature_ptr->history[y], x-1))) x--;
#endif
		}
		else if(skey == SKEY_DOWN || c == KTRL('n'))
		{
			y++;
			if(y >= HISTORY_ROW) y = 0;
#ifdef JP
			if((x > 0) && (iskanji2(creature_ptr->history[y], x-1))) x--;
#endif
		}
		else if(skey == SKEY_RIGHT || c == KTRL('f'))
		{
#ifdef JP
			if(iskanji2(creature_ptr->history[y], x)) x++;
#endif
			x++;
			if(x > HISTORY_COL - 2)
			{
				x = 0;
				if(y < HISTORY_ROW - 1) y++;
			}
		}
		else if(skey == SKEY_LEFT || c == KTRL('b'))
		{
			x--;
			if(x < 0)
			{
				if(y)
				{
					y--;
					x = HISTORY_ROW - 2;
				}
				else x = 0;
			}

#ifdef JP
			if((x > 0) && (iskanji2(creature_ptr->history[y], x-1))) x--;
#endif
		}
		else if(c == '\r' || c == '\n')
		{
			Term_erase(0, 11, 255);
			Term_erase(0, 17, 255);
			put_str(KW_CREATURE_PROFILE_EDITED, 2, 20);
			break;
		}
		else if(c == ESCAPE)
		{
			clear_from(2);
			put_str(format("(%s)", KW_CREATURE_PROFILE), 2, 25);

			for (i = 0; i < HISTORY_ROW; i++)
			{
				sprintf(creature_ptr->history[i], "%s", old_history[i]);
				put_str(creature_ptr->history[i], i + 4, 3);
			}
			break;
		}
		else if(c == KTRL('A'))
		{
			if(do_cmd_histpref(creature_ptr))
			{
#ifdef JP
				if((x > 0) && (iskanji2(creature_ptr->history[y], x - 1))) x--;
#endif
			}
		}
		else if(c == '\010')
		{
			x--;
			if(x < 0)
			{
				if(y)
				{
					y--;
					x = HISTORY_ROW - 2;
				}
				else x = 0;
			}

			creature_ptr->history[y][x] = ' ';
#ifdef JP
			if((x > 0) && (iskanji2(creature_ptr->history[y], x - 1)))
			{
				x--;
				creature_ptr->history[y][x] = ' ';
			}
#endif
		}
#ifdef JP
		else if(iskanji(c) || isprint(c))
#else
		else if(isprint(c)) /* BUGFIX */
#endif
		{
#ifdef JP
			if(iskanji2(creature_ptr->history[y], x))
			{
				creature_ptr->history[y][x+1] = ' ';
			}

			if(iskanji(c))
			{
				if(x > HISTORY_COL - 3)
				{
					x = 0;
					y++;
					if(y > HISTORY_ROW - 1) y = 0;
				}

				if(iskanji2(creature_ptr->history[y], x+1))
				{
					creature_ptr->history[y][x+2] = ' ';
				}

				creature_ptr->history[y][x++] = c;

				c = inkey();
			}
#endif
			creature_ptr->history[y][x++] = c;
			if(x > HISTORY_COL - 2)
			{
				x = 0;
				y++;
				if(y >= HISTORY_ROW) y = 0;
			}
		}
	} /* while (TRUE) */

}


/*
 * Helper function for 'generate_creature'
 *
 * The delay may be reduced, but is recommended to keep players
 * from continuously rolling up characters, which can be VERY
 * expensive CPU wise.  And it cuts down on player stupidity.
 */
static bool generate_creature_aux(creature_type *creature_ptr, s16b species_idx, FLAGS_32 flags)
{
	int i;
	int mode = 0;

	bool prev = FALSE;
	bool player_generate = flags & GC_PLAYER;
	bool auto_generate = flags & GC_AUTO;

	char c;
	char b1 = '[';
	char b2 = ']';

	species_type *species_ptr = &species_info[species_idx];

	// Wipe the player_generate
	creature_wipe(creature_ptr);

	creature_ptr->creature_idx = ++creature_idx_latest;
	creature_ptr->species_idx = species_idx;
	creature_ptr->ap_species_idx = species_idx;
	creature_ptr->lev = 1;
	creature_ptr->exp = creature_ptr->max_exp = species_ptr->exp;
	creature_ptr->dr = species_ptr->dr;
	creature_ptr->alert_range = species_ptr->alert_range;
	creature_ptr->action_turn = 0;

	if(flags & GC_PLAYER) creature_ptr->player = TRUE;

	strcpy(creature_ptr->name, species_name + species_ptr->name);

	// Authority is statics
	for(i = 0; i < AUTHORITY_FLAG_MAX; i++) creature_ptr->authority[i] = species_ptr->authority[i];

	// Race Select
	if(species_ptr->race_idx1 == INDEX_VARIABLE)
	{
		if(!auto_generate)
		{
			Term_clear();
			clear_from(0);
			put_initial_status(creature_ptr);
		}
		i = get_creature_first_race(creature_ptr, species_ptr, auto_generate);
		if(i == BIRTH_SELECT_RETURN) return FALSE;
		if(i == BIRTH_SELECT_QUIT) birth_quit();
	}
	else creature_ptr->race_idx1 = species_ptr->race_idx1;

	if(species_ptr->race_idx2 == INDEX_VARIABLE)
	{
		if(!auto_generate) put_initial_status(creature_ptr);
		i = get_creature_second_race(creature_ptr, species_ptr, auto_generate);
		if(i == BIRTH_SELECT_RETURN) return FALSE;
		if(i == BIRTH_SELECT_QUIT) birth_quit();
	}
	else creature_ptr->race_idx2 = species_ptr->race_idx2;

	// race_idx swap
	if(creature_ptr->race_idx1 > creature_ptr->race_idx2)
	{
		creature_ptr->race_idx1 ^= creature_ptr->race_idx2;
		creature_ptr->race_idx2 ^= creature_ptr->race_idx1;
		creature_ptr->race_idx1 ^= creature_ptr->race_idx2;
	}

	// TODO Race Trait

	// Give beastman a mutation at character birth
	if(has_trait(creature_ptr, TRAIT_KALEIDOSCOPIC_RACE)) creature_ptr->hack_mutation = TRUE;
	else creature_ptr->hack_mutation = FALSE;

	// Sex Select
	if(species_ptr->sex == INDEX_VARIABLE)
	{
		if(!auto_generate)
		{
			clear_from(0);
			put_initial_status(creature_ptr);
		}
		i = get_creature_sex(creature_ptr, species_ptr, auto_generate);
		if(i == BIRTH_SELECT_RETURN) return FALSE;
		if(i == BIRTH_SELECT_QUIT) birth_quit();
	}
	else
	{
		creature_ptr->sex = species_ptr->sex;
	}

	// Class Select
	i = get_creature_class(creature_ptr, species_ptr, auto_generate);
	if(i == BIRTH_SELECT_RETURN) return FALSE;
	if(i == BIRTH_SELECT_QUIT) birth_quit();

	// Realm Select
	i = get_creature_realms(creature_ptr, species_ptr, auto_generate);
	if(i == BIRTH_SELECT_RETURN) return FALSE;
	if(i == BIRTH_SELECT_QUIT) birth_quit();

	// Patron Select
	i = get_creature_patron(creature_ptr, species_ptr, auto_generate);
	if(i == BIRTH_SELECT_RETURN) return FALSE;
	if(i == BIRTH_SELECT_QUIT) birth_quit();

	// Character Select
	i = get_creature_chara(creature_ptr, species_ptr, auto_generate);
	if(i == BIRTH_SELECT_RETURN) return FALSE;
	if(i == BIRTH_SELECT_QUIT) birth_quit();

	// Starting Point
	if(player_generate)
	{
		i = get_starting_point(creature_ptr, auto_generate);
		if(i == BIRTH_SELECT_RETURN) return FALSE;
		if(i == BIRTH_SELECT_QUIT) birth_quit();
	}

	creature_ptr->d_attr = species_ptr->d_attr;
	creature_ptr->d_char = species_ptr->d_char;
	creature_ptr->x_char = species_ptr->x_char;
	creature_ptr->x_attr = species_ptr->x_attr;

	if(player_generate)
	{
		clear_from(0);

		/* Reset turn; before auto-roll and after choosing race */
		init_turn(creature_ptr);
	}

	/*** Generate ***/


	// Roll
	while (TRUE)
	{
		for(i = 0; i < STAT_MAX; i++) creature_ptr->stat_max[i] = creature_ptr->stat_cur[i] = species_ptr->stat_max[i];
		set_age(creature_ptr);                  // Roll for age
		set_exp(creature_ptr, species_ptr);                  // Roll for exp
		set_height_weight(creature_ptr);        // Roll for height and weight
		set_underlings(creature_ptr, species_ptr);
		get_history(creature_ptr);              // Roll for social class

		flush();

		/*** Display ***/
		mode = 0;

		/* Roll for base hitpoints */
		get_extra(creature_ptr, TRUE);

		// Deal Item
		set_creature_bonuses(creature_ptr, FALSE);
		set_experience(creature_ptr);

		deal_item(creature_ptr);

		/* Roll for gold */
		get_money(creature_ptr);

		c = '\0';
		while (TRUE)
		{
			set_experience(creature_ptr);
			set_creature_bonuses(creature_ptr, FALSE);

			// Calculate the bonuses and hitpoints
			prepare_update(creature_ptr, CRU_BONUS | CRU_HP | CRU_MANA);
			update_creature(creature_ptr, FALSE);

			/* And start out fully healthy */
			if(creature_ptr->species_idx == SPECIES_WOUNDED_BEAR)
				set_creature_hp_percent(creature_ptr, 50);
			else
				set_creature_hp_percent(creature_ptr, 100);
			set_creature_sp_percent(creature_ptr, 100);

			// Sexy gal gets bonus to maximum weapon skill of whip
			// TODO if(creature_ptr->chara_idx == CHARA_SEXY) skill_info[player_generate_ptr->class_idx].w_max[TV_HAFTED - TV_WEAPON_BEGIN][SV_WHIP] = WEAPON_EXP_MASTER;

			if(auto_generate) break;

			display_creature_status(mode, creature_ptr);	// Display the player_generate

			// Prepare a prompt (must squeeze everything in)
			Term_gotoxy(2, 23);
			Term_addch(TERM_WHITE, b1);
			if(mode) Term_addstr(-1, TERM_WHITE, MES_INTERFACE_CREATURE_DUMP1);
			Term_addstr(-1, TERM_WHITE, MES_INTERFACE_CREATURE_DUMP2);
			Term_addch(TERM_WHITE, b2);

			c = inkey();	// Prompt and get a command

			if(c == 'Q') birth_quit();
			if(c == 'S') return FALSE;						// Start over
			if(c == '\r' || c == '\n' || c == ESCAPE) break;	// Escape accepts the roll
			if((c == 'H') || (c == 'h'))	// Toggle the display
			{
				((mode >= DISPLAY_CR_STATUS_MAX) ? mode = DISPLAY_CR_STATUS_STANDARD : mode++);
				continue;
			}
			if(c == '?')	// Help
			{
				show_help(TEXT_FILES_BIRTH_AUTO_ROLLER);
				continue;
			}

			bell();
		}

		// Are we done?
		if(auto_generate || c == '\r' || c == '\n' || c == ESCAPE) break;

		// Save this for the "previous" character
		if(player_generate)
		{
			player_prev = *creature_ptr;
			quick_ok = FALSE;
		}

		// Note that a previous roll exists
		prev = TRUE;
	}

	if(!auto_generate)
	{
		get_name(creature_ptr); // Get a name, recolor it, prepare savefile
		set_creature_name(creating_savefile, creature_ptr); // Process the player_generate name
		edit_history(creature_ptr); // Edit character background
	}

	get_max_stats(creature_ptr);
	if(auto_generate) return TRUE;
	prt(MES_INTERFACE_CREATURE_DUMP3, 23, 10);
	c = inkey();	// Get a key
	if(c == 'Q') birth_quit();
	if(c == 'S') return FALSE;	// Start over
	return TRUE;					// Accept
}

/*
 * Ask whether the player use Quick Start or not.
 */
bool ask_quick_start(creature_type *creature_ptr)
{

	/* Doesn't have previous data */
	if(!quick_ok) return FALSE;


	Term_clear();

	while(TRUE)
	{
		char c;
		put_str(MES_QUICKSTART_DESC, 11, 5);
		put_str(MES_QUICKSTART_ASK, 14, 10);
		c = inkey();

		if(c == 'Q') quit(NULL);
		else if(c == 'S') return FALSE;
		else if(c == '?')
			show_help(TEXT_FILES_BIRTH_AUTO_ROLLER);
		else if((c == 'y') || (c == 'Y'))
			break;
		else
			return FALSE;
	}

	*creature_ptr = player_prev;
	init_dungeon_quests();
	init_turn(creature_ptr);

	creature_ptr->wy = creature_ptr->start_wy;
	creature_ptr->wx = creature_ptr->start_wx;

	/* Calc hitdice, but don't roll */
	get_extra(creature_ptr, FALSE);

	// Update the bonuses and hitpoints
	prepare_update(creature_ptr, CRU_BONUS | CRU_HP);
	update_creature(creature_ptr, TRUE);

	creature_ptr->chp = creature_ptr->mhp;
	creature_ptr->csp = creature_ptr->msp;

	/* Process the player name */
	set_creature_name(FALSE, creature_ptr);

	return TRUE;
}

/*
 * Create a new character.
 *
 * Note that we may be called with "junk" leftover in the various
 * fields, so we must be sure to clear them first.
 */
creature_type* generate_creature(cave_type *c_ptr, s16b species_idx, FLAGS_32 flags)
{
	char buf[80];
	int id;
	creature_type *creature_ptr;

	// Make a new creature
	id = creature_pop();
	if(!id) return NULL;

	// Get a new creature record
	creature_ptr = &creature_list[id];

	if(c_ptr) c_ptr->creature_idx = (s16b)id;

	// Create a new character
	while (!generate_creature_aux(creature_ptr, species_idx, flags));

	if(flags & GC_PLAYER)
	{
		message_add(" ");
		message_add(" ");
		message_add("====================");
		message_add(" ");
		message_add(" ");

		do_cmd_write_diary(DIARY_GAMESTART, 1, DIARY_CREATE_PLAYER);
		do_cmd_write_diary(DIARY_HIGAWARI, 0, NULL);
		sprintf(buf, DIARY_SELECTSEX(sex_info[creature_ptr->sex].title));
		do_cmd_write_diary(DIARY_BUNSHOU, 1, buf);

		if(IS_PURE(creature_ptr))
			sprintf(buf, DIARY_SELECT_PURERACE(race_info[creature_ptr->race_idx1].title));
		else
			sprintf(buf, DIARY_SELECT_HALFRACE(race_info[creature_ptr->race_idx1].title, race_info[creature_ptr->race_idx2].title));
		do_cmd_write_diary(DIARY_BUNSHOU, 1, buf);

		sprintf(buf, DIARY_SELECT_CLASS(class_info[creature_ptr->class_idx].title));
		do_cmd_write_diary(DIARY_BUNSHOU, 1, buf);

		if(creature_ptr->realm1)
		{
			sprintf(buf, DIARY_SELECT_REALM(realm_names[creature_ptr->realm1]));
			do_cmd_write_diary(DIARY_BUNSHOU, 1, buf);
		}

		sprintf(buf, DIARY_SELECT_CHALA(chara_info[creature_ptr->chara_idx].title));
		do_cmd_write_diary(DIARY_BUNSHOU, 1, buf);

	}

	return creature_ptr;
}


void dump_yourself(creature_type *creature_ptr, FILE *fff)
{
	char temp[80*10];
	int i;
	cptr t;

	if(!fff) return;
	roff_to_buf(race_text + race_info[creature_ptr->race_idx1].text, 78, temp, sizeof(temp));
	fprintf(fff, "\n\n%s: %s\n", KW_RACE, race_info[creature_ptr->race_idx1].title);

	t = temp;
	for (i = 0; i < 10; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	roff_to_buf(class_text + class_info[creature_ptr->class_idx].text, 78, temp, sizeof(temp));
	fprintf(fff, "\n");
	fprintf(fff, "%s: %s\n", KW_CLASS, class_info[creature_ptr->class_idx].title);
	t = temp;
	for (i = 0; i < 10; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	roff_to_buf(chara_text + chara_info[creature_ptr->chara_idx].text, 78, temp, sizeof(temp));
	fprintf(fff, "\n");
	fprintf(fff, "%s: %s\n", KW_CHARA, chara_info[creature_ptr->chara_idx].title);
	t = temp;
	for (i = 0; i < STAT_MAX; i++)
	{
		if(t[0] == 0)
			break; 
		fprintf(fff, "%s\n",t);
		t += strlen(t) + 1;
	}
	fprintf(fff, "\n");
	if(creature_ptr->realm1)
	{
		roff_to_buf(realm_jouhou[technic2magic(creature_ptr->realm1)-1], 78, temp, sizeof(temp));
		fprintf(fff, "%s: %s\n", KW_REALM, realm_names[creature_ptr->realm1]);
		t = temp;
		for (i = 0; i < STAT_MAX; i++)
		{
			if(t[0] == 0)
				break; 
			fprintf(fff, "%s\n",t);
			t += strlen(t) + 1;
		}
	}
	fprintf(fff, "\n");
	if(creature_ptr->realm2)
	{
		roff_to_buf(realm_jouhou[technic2magic(creature_ptr->realm2)-1], 78, temp, sizeof(temp));
		fprintf(fff, "%s: %s\n", KW_REALM, realm_names[creature_ptr->realm2]);
		t = temp;
		for (i = 0; i < STAT_MAX; i++)
		{
			if(t[0] == 0)
				break; 
			fprintf(fff, "%s\n",t);
			t += strlen(t) + 1;
		}
	}
}

