/*!
* @file GameSurfaceSDL.h
* @brief GameSurfaceSDLNXƂ̑tvf̃vg^Cv
* @date 2014/02/19
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"

#include <SDL.h>
#include <SDL_image.h>
//#include <SDL_gfx.h>
#include <SDL_ttf.h>

#include "GameSurface.h"

BOOST_CLASS_VERSION(GameSurfaceSDL, 1);

namespace Deeangband
{

	/*! 
	* @class GameSurfaceSDL
	* @brief Q[̃CC^[tFCXNX(SDL)
	*/
	class GameSurfaceSDL : public GameSurface
	{
	private:

		SDL_Renderer *renderer;     //!< SDLp_Qƃ|C^
		SDL_Window *window;         //!< SDLEBhEQƃ|C^

		Creature *viewCreaturePtr;       //!< ݂̃Xe[^X\ΏۂƂȂCreatureQƃ|C^
		Creature *sideStatusCreatutePtr; //!< ݂̃Xe[^XȈՕ\ΏۂƂȂCreatureQƃ|C^
		Field *viewFieldPtr;       //!< `ΏۂƂȂFieldQ
		Coordinates focusPoint;    //!< tA̕`捶n_

		TTF_Font* font;  //!< `W|C^
		SDL_Color color; //!< J[W|C^

		SDL_RWops *rwop;
		std::string currentMessage; //!< ݕ\̃bZ[Wstring
		std::string error;
		SDL_Rect src;
		SDL_Rect title;

		SDL_Surface *windowSurface;  //!< Q[EBhESurfaceQ

		SDL_Surface *titleSurface;   //!< Q[^CgOtBbNSurfaceQ
		SDL_Surface *messageSurface; //!< bZ[WOtBbNSurfaceQ
		SDL_Surface *creatureStatusSurface;  //!< N[`[Xe[^X\SurfaceQ
		SDL_Surface *creatureSideStatusSurface;  //!< TChN[`[Xe[^X\SurfaceQ

		void GameSurfaceSDL::pushAnyKey(void);
		void GameSurfaceSDL::initInterfaces(void);

		void GameSurfaceSDL::drawCreatureStatus(Creature *creaturePtr);

		/*!
		* @brief tA`悷
		* @param fieldPtr \tA̍\̎Qƃ|C^
		* @param gameWorld GameWorldQƃ|C^
		* @param x N_XW
		* @param y N_YW
		* @param w \̃}X
		* @param h \̃}X
		* @return Ȃ
		*/
		void GameSurfaceSDL::drawField(GameWorld *gameWorld, Field *fieldPtr, int x, int y, int w, int h);

		/*!
		* @brief TChXe[^X\XV
		* @param creaturePtr XVN[`[Qƃ|C^
		* @return Ȃ
		*/
		void GameSurfaceSDL::updateSideCreatureStatus(Creature *creaturePtr);

		/*!
		* @brief TChXe[^X`悷
		* @return Ȃ
		*/
		void GameSurfaceSDL::drawSideCreatureStatus(void);

		/*!
		* @brief VXebZ[W`悷
		* @return Ȃ
		*/
		void GameSurfaceSDL::drawSystemMessage(void);

		/*!
		* @brief Q[bZ[W`悷
		* @return Ȃ
		*/
		void GameSurfaceSDL::drawGameMessage(void);

	public:

		/*!
		* @brief Q[ʂĕ`悷
		* @return Ȃ
		*/
		void GameSurfaceSDL::Redraw(void);

		/*!
		* @brief w肳ꂽN[`[̃Xe[^X\
		* @param creaturePtr \N[`[̎Qƃ|C^
		* @return Ȃ
		*/
		void GameSurfaceSDL::ViewCreatureStatus(Creature *creaturePtr);

		/*!
		* @brief Q[ʍɃvC[ȗ\B
		* @param creaturePtr \N[`[̃CX^XQƃ|C^BNULLȂΔ\B
		* @return Ȃ
		*/
		void GameSurfaceSDL::SetSideStatusCreature(Creature *creaturePtr);

		/*!
		* @brief \tA؂ւ
		* @param fieldPtr \tA̎Qƃ|C^
		* @return Ȃ
		*/
		void GameSurfaceSDL::SetField(Field *fieldPtr);

		/*!
		* @brief RXgN^
		* @param gameWorld GameWorldCX^X
		*/
		GameSurfaceSDL::GameSurfaceSDL(GameWorld *gameWorld);

		/*!
		* @brief fXgN^
		*/
		GameSurfaceSDL::~GameSurfaceSDL(void);

		/*!
		* @brief vC[R}h擾
		* @return Q[R}hID
		*/
		GAME_COMMAND GameSurfaceSDL::GetCommand(void);

		/*!
		* @brief tA\̃tH[JXύX
		* @param x XW
		* @param y YW
		* @return Ȃ
		*/
		void GameSurfaceSDL::FocusField(int x, int y);

		/*!
		* @brief tA\̃tH[JXύX
		* @param coord W
		* @return Ȃ
		*/
		void GameSurfaceSDL::FocusField(Coordinates coord);

		/*!
		* @brief WbZ[W\
		* @param message bZ[W
		* @return Ȃ
		*/
		void GameSurfaceSDL::SystemMessage(std::string message);

	};

}