/*!
* @file GameLogger.cpp
* @brief GameLoggerNX̒`
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "GameLogger.h"

namespace Deeangband
{
	GameLogger::GameLogger(void)
	{
		time_t t = time(0);
	    tm tx;
		setlocale(LC_CTYPE, "ja_JP.UTF-8");
		localtime_s(&tx, &t);
		ofs.open("Deeangband.log");
		if(ofs.fail())
		{
			exit(0);
		}
		ofs << std::put_time(&tx, "%Y-%m-%d %H:%M:%S =") << "D\'angband Jn \n";
	}

	void GameLogger::PutLog(std::string log)
	{
		time_t t = time(0);
	    tm tx;
		setlocale(LC_CTYPE, "ja_JP.UTF-8");
		localtime_s(&tx, &t);
		ofs << std::put_time(&tx, "%Y-%m-%d %H:%M:%S =") << log << "\n";
	}

	GameLogger::~GameLogger(void)
	{
		time_t t = time(0);
	    tm tx;
		setlocale(LC_CTYPE, "ja_JP.UTF-8");
		localtime_s(&tx, &t);
		ofs << std::put_time(&tx, "%Y-%m-%d %H:%M:%S =") << "D\'angband I \n";
	}

	void GameLogger::CreatureMoved(ID creatureID, NAME name, DIRECTION dir)
	{
		GameLogger::PutLog((boost::format("[%1%]%2%%3%Ɉړ") % creatureID % name.c_str() % dir).str());
	}

}