/*!
* @file Skill.cpp
* @brief Q[̃XL`
* @date 2013/12/17
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "Skill.h"

namespace Deeangband
{

	Skill::Skill(void)
	{
		this->WipeData();
	}

	Skill::~Skill(void)
	{
		this->WipeData();
	}

	void Skill::WipeData(void)
	{
		GameElement::WipeData();
	}

	std::string Skill::GetName(void)
	{
		return this->name;
	}

	std::string Skill::GetDetails(void)
	{
		return this->details;
	}

	SKILL_RANK Skill::CalcSkillRank(Creature *creaturePtr, TAG tag)
	{
		if(creaturePtr)
		{
			return (SKILL_RANK)sqrt(creaturePtr->GetSkillExp(tag) / 100); //!< vZ͌XB
		}
		else return 0;
	}

}