/*!
 * @file Item.cpp
 * @brief Q[̃N[`[`
 * @date 2013/12/11
 * @author Deskull
 * 2013 Sikabane Works.
 */

#include "stdafx.h"
#include "Item.h"

namespace Deeangband
{

Item::Item(void) : ItemTemplate(), GameInstance(), HaveGameTime(), HavePosition()
{
	this->WipeData();
}


Item::Item(std::map<TAG, boost::shared_ptr<ItemBase>>::iterator itemBaseIt) : ItemTemplate(), GameInstance(), HaveGameTime(), HavePosition()
{
	this->WipeData();
	this->weight = itemBaseIt->second->GetWeight();
	this->baseDamage = itemBaseIt->second->GetBaseDamage();
	this->baseSaving = itemBaseIt->second->GetBaseSaving();
	this->baseSaving = itemBaseIt->second->GetPlusSaving();
}

Item::~Item(void)
{
	this->WipeData();
}

void Item::WipeData(void)
{
	this->weight = 0;
	this->baseDamage.Set(0, 0);
	this->baseSaving.Set(0, 0, 0);
}

bool Item::TakeEffect(Effect *effectPtr, POWER amount)
{
	if(effectPtr)
	{
		amount = 0;
	}
	return true;
}

bool Item::addOneSustain(bool allowDuplicating)
{
	// @todo: Item::addOneSustainB
	return false;
}


void Item::XMLSave(std::string filename)
{
	Item item = *this;
	std::ofstream ofs(filename);
	 assert(ofs);
	boost::archive::xml_oarchive oa(ofs);
	oa << BOOST_SERIALIZATION_NVP(item);
}

}