/*!
* @file GameWorld.h
* @brief Q[Ẽvg^Cv錾
* @date 2013/02/01
* @author Deskull
* 2013-2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "Air.h"
#include "Ability.h"
#include "Authority.h"
#include "Building.h"
#include "Camp.h"
#include "Creature.h"
#include "CreatureTrait.h"
#include "Dungeon.h"
#include "Effect.h"
#include "Floor.h"
#include "FixedArtifact.h"
#include "GameMessage.h"
#include "ItemBase.h"
#include "ItemEgo.h"
#include "ItemTrait.h"
#include "Karma.h"
#include "Quest.h"
#include "Race.h"
#include "Space.h"
#include "Skill.h"
#include "Species.h"
#include "StartingClass.h"
#include "TrapBase.h"

#include "Item.h"
#include "Creature.h"
#include "Field.h"
#include "Trap.h"

BOOST_CLASS_VERSION(GameWorld, 1);

namespace Deeangband
{

	/*!
	* @class GameWorld
	* @brief Q[ẼNX
	*/
	class GameWorld
	{
	private:

		//ÓIf[^Xg
		std::map<TAG, boost::shared_ptr<Air>> airList;                      /*!<SCn`Xg*/
		std::map<TAG, boost::shared_ptr<Ability>> abilityList;              /*!<SZ\Xg*/
		std::map<TAG, boost::shared_ptr<Authority>> authorityList;          /*!<S\Xg*/
		std::map<TAG, boost::shared_ptr<Building>> buildingList;            /*!<S{݃Xg*/
		std::map<TAG, boost::shared_ptr<Camp>> campList;                    /*!<SwcXg*/
		std::map<TAG, boost::shared_ptr<CreatureTrait>> creatureTraitList;  /*!<SN[`[Xg*/
		std::map<TAG, boost::shared_ptr<Dungeon>> dungeonList;              /*!<S_WXg*/
		std::map<TAG, boost::shared_ptr<Effect>> effectList;                /*!<SʑXg*/
		std::map<TAG, boost::shared_ptr<Floor>> floorList;                  /*!<Sn`Xg*/
		std::map<TAG, boost::shared_ptr<FixedArtifact>> fixedArtifactList;  /*!<SŒA[eBt@NgXg*/
		std::map<TAG, boost::shared_ptr<ItemBase>> itemBaseList;            /*!<SACex[XXg*/
		std::map<TAG, boost::shared_ptr<ItemEgo>> itemEgoList;              /*!<SACeGSXg*/
		std::map<TAG, boost::shared_ptr<ItemTrait>> itemTraitList;          /*!<SACeXg*/
		std::map<TAG, boost::shared_ptr<Karma>> karmaList;                  /*!<SJ}Xg*/
		std::map<TAG, boost::shared_ptr<Quest>> questList;                  /*!<SNGXgXg*/
		std::map<TAG, boost::shared_ptr<Space>> spaceList;                      /*!<SԒn`Xg*/
		std::map<TAG, boost::shared_ptr<Skill>> skillList;                  /*!<SXLXg*/
		std::map<TAG, boost::shared_ptr<Species>> speciesList;              /*!<SN[`[ʃXg*/
		std::map<TAG, boost::shared_ptr<StartingClass>> startingClassList;  /*!<SoXg*/
		std::map<TAG, boost::shared_ptr<Race>> raceList;                    /*!<S푰Xg*/
		std::map<TAG, boost::shared_ptr<TrapBase>> trapBaseList;            /*!<Sgbvx[XʃXg*/

		//If[^Xg
		std::map<ID, boost::shared_ptr<Item>> itemList;                    /*!<SACeXg*/
		std::map<ID, boost::shared_ptr<Creature>> creatureList;            /*!<SN[`[Xg*/
		std::map<ID, boost::shared_ptr<Field>> fieldList;                  /*!<StAXg*/
		std::map<ID, boost::shared_ptr<Trap>> trapList;                    /*!<SgbvXg*/

		ID itemID;     //!<󂫃ACeID
		ID creatureID; //!<󂫃N[`[ID
		ID fieldID;    //!<󂫃tB[hID
		ID trapID;     //!<󂫃gbvID

		std::vector<boost::shared_ptr<HaveGameTime>> actionList; /*!<sXg*/

		Creature *playerPtr; //!< vC[N[`[Qƃ|C^
		GAME_TIME gameTime; //!<Q[

		friend class boost::serialization::access;

		/*!
		* @brief Cn`̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveAir(void);

		/*!
		* @brief Z\̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveAbility(void);

		/*!
		* @brief \̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveAuthority(void);

		/*!
		* @brief {ݏ̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveBuilding(void);

		/*!
		* @brief wc̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveCamp(void);

		/*!
		* @brief N[`[̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveCreatureTrait(void);

		/*!
		* @brief _W̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveDungeon(void);

		/*!
		* @brief ʑ̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveEffect(void);

		/*!
		* @brief n`̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveFloor(void);

		/*!
		* @brief ŒA[eBt@Ng̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveFixedArtifact(void);

		/*!
		* @brief x[XACẽZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveItemBase(void);

		/*!
		* @brief ACeGS̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveItemEgo(void);

		/*!
		* @brief ACẽZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveItemTrait(void);

		/*!
		* @brief J}̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveKarma(void);

		/*!
		* @brief NGXg̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveQuest(void);

		/*!
		* @brief NGXg̃Z[u
		* @return ݂ɐTRUEԂ
		* @todo ݏ̃G[
		*/
		bool GameWorld::xmlSaveRace(void);

		/*!
		* @brief XL̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveSkill(void);

		/*!
		* @brief Ԓn`̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveSpace(void);

		/*!
		* @brief N[`[ʏ̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveSpecie(void);

		/*!
		* @brief õZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveStartingClass(void);

		/*!
		* @brief x[XgbṽZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveTrapBase(void);

		bool GameWorld::xmlLoadAir(void);
		bool GameWorld::xmlLoadAbility(void);
		bool GameWorld::xmlLoadAuthority(void);
		bool GameWorld::xmlLoadBuilding(void);
		bool GameWorld::xmlLoadCamp(void);
		bool GameWorld::xmlLoadCreatureTrait(void);
		bool GameWorld::xmlLoadDungeon(void);
		bool GameWorld::xmlLoadEffect(void);
		bool GameWorld::xmlLoadFloor(void);
		bool GameWorld::xmlLoadFixedArtifact(void);
		bool GameWorld::xmlLoadItemBase(void);
		bool GameWorld::xmlLoadItemEgo(void);
		bool GameWorld::xmlLoadItemTrait(void);
		bool GameWorld::xmlLoadKarma(void);
		bool GameWorld::xmlLoadQuest(void);
		bool GameWorld::xmlLoadRace(void);
		bool GameWorld::xmlLoadSpace(void);
		bool GameWorld::xmlLoadSkill(void);
		bool GameWorld::xmlLoadSpecie(void);
		bool GameWorld::xmlLoadStartingClass(void);
		bool GameWorld::xmlLoadTrapBase(void);

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Authorities", authorityList);
				archive & boost::serialization::make_nvp("Buildings", buildingList);
				archive & boost::serialization::make_nvp("Camps", campList);
				archive & boost::serialization::make_nvp("Dungeons", dungeonList);
				archive & boost::serialization::make_nvp("Effects", effectList);
				archive & boost::serialization::make_nvp("Floors", floorList);
				archive & boost::serialization::make_nvp("FixedArtifacts", fixedArtifactList);
				archive & boost::serialization::make_nvp("ItemBases", itemBaseList);
				archive & boost::serialization::make_nvp("ItemEgos", itemEgoList);
				archive & boost::serialization::make_nvp("ItemTraits", itemTraitList);
				archive & boost::serialization::make_nvp("Karmas", karmaList);
				archive & boost::serialization::make_nvp("Quests", questList);
				archive & boost::serialization::make_nvp("Skills", skillList);
				archive & boost::serialization::make_nvp("Species", speciesList);
				archive & boost::serialization::make_nvp("TrapBases", trapBaseList);

				archive & boost::serialization::make_nvp("Authorities", authorityList);
				archive & boost::serialization::make_nvp("Creatures", creatureList);
				archive & boost::serialization::make_nvp("Items", itemList);
				archive & boost::serialization::make_nvp("Fields", fieldList);
				archive & boost::serialization::make_nvp("Traps", trapList);
			}
		}

	public:

		/*!
		* @brief GameWorldNX̃RXgN^
		* @param gSurface Q[̃C^[tFCXƂȂ GameSurface Q
		*/
		GameWorld::GameWorld(void);

		/*!
		* @brief GameWorldNX̃fXgN^
		*/
		GameWorld::~GameWorld(void);

		/*!
		* @brief N[`[𐶐GameWorld̏vfƘAg
		* @param creatureTag N[`[^O
		* @return ɐꍇtrueԂ
		*/
		bool GameWorld::GenerateCreature(TAG creatureTag);

		/*!
		* @brief N[`[𐶐GameWorld̏vfƘAg
		* @param creatureTag N[`[^O
		* @param fieldID zutB[hID
		* @param x zuXW
		* @param y zuYW
		* @return ɐꍇtrueԂ
		*/
		bool GameWorld::GenerateCreature(TAG creatureTag, ID fieldID, int x, int y);

		/*!
		* @brief GameWorldɑ݂錠\Ԃ
		* @param tag \̃^O
		* @return \̎Qƃ|C^A݂ȂNULLԂB
		*/
		Authority *GameWorld::GetAuthority(TAG tag);

		/*!
		* @brief GameWorldɑ݂N[`[Ԃ
		* @param tag N[`[̃^O
		* @return N[`[̎Qƃ|C^A݂ȂNULLԂB
		*/
		CreatureTrait *GameWorld::GetCreatureTrait(TAG tag);

		/*!
		* @brief GameWorldɑ݂ʑԂ
		* @param tag ʑ̃^O
		* @return ʑ̎Qƃ|C^A݂ȂNULLԂB
		*/
		Effect *GameWorld::GetEffect(TAG tag);

		/*!
		* @brief GameWorldɑ݂ŒA[eBt@NgԂ
		* @param tag ʑ̃^O
		* @return ŒA[eBt@Ng̎Qƃ|C^A݂ȂNULLԂB
		*/
		FixedArtifact *GameWorld::GetFixedArtifact(TAG tag);

		/*!
		* @brief GameWorldɑ݂n`Ԃ
		* @param tag n`̃^O
		* @return n`̎Qƃ|C^A݂ȂNULLԂB
		*/
		Floor *GameWorld::GetFloor(TAG tag);

		/*!
		* @brief GameWorldɑ݂x[XACeԂ
		* @param tag x[XACẽ^O
		* @return x[XACe̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemBase *GameWorld::GetItemBase(TAG tag);

		/*!
		* @brief GameWorldɑ݂ACeGSԂ
		* @param tag ACeGS̃^O
		* @return ACeGS̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemEgo *GameWorld::GetItemEgo(TAG tag);

		/*!
		* @brief GameWorldɑ݂ACeԂ
		* @param tag ACẽ^O
		* @return ACe̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemTrait *GameWorld::GetItemTrait(TAG tag);

		/*!
		 * @brief GameWorldɑ݂J}Ԃ
		 * @param tag J}̃^O
		 * @return J}̎Qƃ|C^A݂ȂNULLԂB
		 */
		Karma *GameWorld::GetKarma(TAG tag);

		/*!
		 * @brief GameWorldɑ݂XLԂ
		 * @param tag XL̃^O
		 * @return XL̎Qƃ|C^A݂ȂNULLԂB
		 */
		Skill *GameWorld::GetSkill(TAG tag);

		/*!
		 * @brief GameWorldɑ݂XLԂ
		 * @param tag XL̃^O
		 * @return XL̎Qƃ|C^A݂ȂNULLԂB
		 */
		Species *GameWorld::GetSpecies(TAG tag);

		/*!
		 * @brief GameWorldɑ݂gbvʂԂ
		 * @param tag gbvʂ̃^O
		 * @return gbvʂ̎Qƃ|C^A݂ȂNULLԂB
		 */
		TrapBase *GameWorld::GetTrapBase(TAG tag);

		/*!
		 * @brief GameWorldɑ݂{݂Ԃ
		 * @param tag {݂̃^O
		 * @return {݂̎Qƃ|C^A݂ȂNULLԂB
		 */
		Building *GameWorld::GetBuilding(TAG tag);

		/*!
		 * @brief GameWorldɑ݂wcԂ
		 * @param tag wc̃^O
		 * @return wc̎Qƃ|C^A݂ȂNULLԂB
		 */
		Camp *GameWorld::GetCamp(TAG tag);

		/*!
		 * @brief GameWorldɑ݂_WԂ
		 * @param tag _W̃^O
		 * @return _W̎Qƃ|C^A݂ȂNULLԂB
		 */
		Dungeon *GameWorld::GetDungeon(TAG tag);

		/*!
		 * @brief GameWorldɑ݂ACeԂ
		 * @param id ACeID
		 * @return ACe̎Qƃ|C^A݂ȂNULLԂB
		 */
		Item *GameWorld::GetItem(ID id);

		/*!
		 * @brief GameWorldɑ݂tAԂ
		 * @param id tAID
		 * @return tA̎Qƃ|C^A݂ȂNULLԂB
		 */
		Field *GameWorld::GetField(ID id);

		/*!
		 * @brief GameWorldɑ݂N[`[Ԃ
		 * @param id N[`[ID
		 * @return N[`[̎Qƃ|C^A݂ȂNULLԂB
		 */
		Creature *GameWorld::GetCreature(ID id);

		/*!
		 * @brief GameWorldɑ݂锭Z\Ԃ
		 * @return SZ\̃Xg
		 */
		std::map<TAG, boost::shared_ptr<Ability>> *GameWorld::GetAbilityList(void);

		/*!
		 * @brief GameWorldɑ݂N[`[Ԃ
		 * @return SN[`[̃Xg
		 */
		std::map<ID, boost::shared_ptr<Creature>> *GameWorld::GetCreatureList(void);

		/*!
		 * @brief GameWorldɑ݂NGXgԂ
		 * @param tag NGXg̃^O
		 * @return NGXg̎Qƃ|C^A݂ȂNULLԂB
		 */
		Quest *GameWorld::GetQuest(TAG tag);

		/*!
		 * @brief Q[ԂԂ
		 * @return Q[
		 */
		GAME_TIME GameWorld::GetGameTime(void);

		/*!
		 * @brief XMLVACYɂQ[f[^ۑ
		 * @return Ȃ
		 */
		bool GameWorld::XMLSave(void);

		/*!
		 * @brief XMLfVACYɂQ[f[^Ǎ
		 * @return Ȃ
		 */
		void GameWorld::XMLLoad(void);

		/*!
		 * @brief ΉID̃N[`[Xg珜O
		 * @return Ȃ
		 */
		void GameWorld::WipeCreature(ID id);

		/*!
		 * @brief vC[N[`[Ԃ
		 * @return vC[N[`[̎Qƃ|C^
		 */
		Creature *GameWorld::GetPlayerCreature(void);

		/*!
		 * @brief sXgԂ
		 * @return sXg
		 */
		std::vector<boost::shared_ptr<HaveGameTime>>* GameWorld::GetActionList(void);

		/*!
		 * @brief wtB[hyэWɑ݂N[`[邩𔻕ʂN[`[ԂB
		 * @param fieldID tB[hID
		 * @param positionPtr W|C^
		 * @param ݂N[`[̃|C^A݂ȂꍇNULLB
		 */
		Creature *GameWorld::GetCreatureFromPosition(ID fieldID, Coordinates *positionPtr);

	};

}