/*!
* @file Creature.h
* @brief Q[̃N[`[ƕtvf̃vg^Cv
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

//#include "GameEngine.h"

#include "stdafx.h"
#include "BaseStatusTable.h"
#include "Color.h"
#include "Coordinates.h"
#include "Deeangband.h"
#include "Discipline.h"
#include "Direction.h"
#include "Effect.h"
#include "Field.h"
#include "HaveInventory.h"
#include "HaveGameTime.h"
#include "HaveHp.h"
#include "HaveSize.h"
#include "HaveSymbol.h"
#include "HavePosition.h"
#include "Item.h"
#include "GameConstants.h"
#include "GameInstance.h"
#include "GameLogger.h"
#include "GameMessage.h"
#include "SavingTable.h"
#include "Species.h"

namespace Deeangband
{

	/*!
	* @class Creature
	* @brief N[`[̃NX
	* @details
	* <H1>Tv</H1>
	* CreatureNX́AQ[̓ƗsPʂłN[`[B
	* <H2>Xe[^Xvf</H2>
	* N[`[͈ȉ̃Xe[^XvfĂB
	* <ul>
	* <li>O / Name</li>
	* <li>N[`[ / Species</li>
	* <li>[ԃN[`[ / Appearance Species</li>
	* <li>x / Level</li>
	* <li>HPEőHPE{̍őHP/ Current HP, Max HP, Max Max HP</li>
	* <li>MPEőMPE{̍őMP/ Current MP, Max MP, Max Max MP</li>
	* <li>݃\ElE\Eő哞Bl / Current Soul, Max Soul</li>
	* <li>ݎ{lEő厠{l / Current Feed, Max Feed</li>
	* <li>_x / Divine Level</li>
	* <li>ݘŕEőŕEEr / Current STR, Max STR Max Max STR</li>
	* <li>ݒḿEőḿEEm / Current INT, Max INT Max Max INT</li>
	* <li>݌Eő匫EE / Current WIS, Max WIS Max Max WIS</li>
	* <li>݊pEőpEEp / Current DEX, Max DEX Max Max DEX</li>
	* <li>ݑϋvEőϋvEEϋv / Current CON, Max CON Max Max CON</li>
	* <li>ݖ́Eő喣́EE / Current CHA, Max CHA Max Max CHA</li>
	* <li>bZ[ul / Armor Saving</li>
	* <li>Z[ul / Evasion Saving</li>
	* <li>ӎuZ[ul / Volition Saving</li>
	* <li>݃tA / Current Field</li>
	* <li>ݍW / Current Pisition</li>
	* <li>ACeꗗ / Current Pisition</li>
	* <li>XLꗗ / Current Pisition</li>
	* </ul>
	*/
	class Creature : public GameInstance, public HaveSymbol, public HaveHp, public HaveGameTime, public HavePosition, public HaveInventory, public HaveSize
	{
	private:

		static SOUL soulLevel[CREATURE_MAX_LEVEL]; //!< Kv\Exe[u

		MP currentMp;     //!< ݂MP
		MP maxMp;         //!< ݂̍őMP
		MP maxMaxMp;      //!< {̍őMP
		SOUL currentSoul; //!< ݂̃\El
		SOUL maxSoul;     //!< \Eő哞Bl

		FEED currentFeed; //!< ݎ{l
		FEED maxFeed;     //!< ő厠{l

		TAG firstRace; //!< 푰^O1
		TAG secondRace; //!< 푰^O2

		Discipline currentDiscipilne; //!< ݂̏C{l
		LEVEL divineLevel;            //!< _x

		BaseStatusTable currentStatus; //!< ݂̃Xe[^X
		BaseStatusTable maxStatus;     //!< ʏ̃Xe[^X
		BaseStatusTable maxMaxStatus;  //!< ẼXe[^X

		SavingTable savings; //!< Z[rO

		std::map<TAG, SKILL_EXP> skillExpList; //!< XLolXg

		TAG campTag; //!< wc^O

		TAG speciesTag; //!< N[`[Tag
		TAG appearanceSpeciesTag; //!< [Ԑ̃N[`[Tag

		HP hpTable[CREATURE_MAX_LEVEL]; //!< qbg_CXɊÂꂽx̊{HP

		/*!
		* @brief N[`[S̏s
		* @return Ȃ
		*/
		void Creature::die(void);

		/*!
		* @brief N[`[̌MP𑝌
		* @param amount MP
		* @return Ȃ
		*/
		void Creature::calcMP(MP amount);

		/*!
		* @brief N[`[̌MPݒ肷
		* @param amount ݒHP
		* @return Ȃ
		*/
		void Creature::setMP(MP amount);

		/*!
		* @brief N[`[̃x{HPČvZ
		* @return Ȃ
		*/
		void Creature::calcHPTable(void);

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version f[^o[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Name", name);
				archive & boost::serialization::make_nvp("FirstRace", firstRace);
				archive & boost::serialization::make_nvp("SecondRace", secondRace);
				archive & boost::serialization::make_nvp("MHP", maxHp);
				archive & boost::serialization::make_nvp("MHP", maxHp);
				archive & boost::serialization::make_nvp("HPTable", hpTable);
				archive & boost::serialization::make_nvp("CMP", currentMp);
				archive & boost::serialization::make_nvp("MMP", maxMp);
				archive & boost::serialization::make_nvp("MMMP", maxMaxMp);
				archive & boost::serialization::make_nvp("CSoul", currentSoul);
				archive & boost::serialization::make_nvp("MSoul", maxSoul);
				archive & boost::serialization::make_nvp("CStatus", currentStatus);
				archive & boost::serialization::make_nvp("MStatus", maxStatus);
				archive & boost::serialization::make_nvp("MMStatus", maxMaxStatus);
				archive & boost::serialization::make_nvp("Height", height);
				archive & boost::serialization::make_nvp("Weight", weight);
				archive & boost::serialization::make_nvp("CFeed", currentFeed);
				archive & boost::serialization::make_nvp("MFeed", maxFeed);
				archive & boost::serialization::make_nvp("Savings", savings);
				archive & boost::serialization::make_nvp("FieldID", fieldID);
				archive & boost::serialization::make_nvp("Position", position);
				archive & boost::serialization::make_nvp("ItemList", itemList);
				archive & boost::serialization::make_nvp("SpeciesTAG", speciesTag);
				archive & boost::serialization::make_nvp("AppearanceSpeciesTAG", appearanceSpeciesTag);
			}
		}

	public:

		/*! 
		* @brief CreatureNXRXgN^(GameElementoΉ)
		* @param speciesIt ƂȂN[`[ʃCe[^
		*/
		Creature::Creature(std::map<TAG, boost::shared_ptr<Species>>::iterator speciesIt);

		/*! 
		* @brief CreatureNXRXgN^(GameElementoΉ)
		* @param speciesIt ƂȂN[`[ʃCe[^
		* @param fieldID tB[hID
		* @param coordinates W
		*/
		Creature::Creature(std::map<TAG, boost::shared_ptr<Species>>::iterator speciesIt, ID FieldID, Coordinates *coordinates);

		/*! 
		* @brief CreatureNXRXgN^(GameElementoΉ)
		* @param speciesIt ƂȂN[`[ʃCe[^
		* @param fieldID tB[hID
		* @param x XW
		* @param y YW
		*/
		Creature::Creature(std::map<TAG, boost::shared_ptr<Species>>::iterator speciesIt, ID FieldID, int x, int y);

		/*! 
		* @brief CreatureNXRXgN^
		*/
		Creature::Creature(void);

		/*! 
		* @brief CreatureNXfXgN^
		*/
		Creature::~Creature(void);

		/*! 
		* @brief N[`[ʂɊÂN[`[𐶐
		* @param speciesPtr ƂN[`[
		* @return Ȃ
		* @todo 푰^OVARIABLEȂǂłꍇ̓ʏ̎
		*/
		void Creature::SetSpeciesData(Species *speciesPtr);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Creature::WipeData(void);

		/*!
		* @brief N[`[ĂԂԂ
		* @return ĂȂtrueԂ
		*/
		bool Creature::IsAlive(void);

		/*!
		* @brief 󂯂ʂ
		* @param effectPtr
		* @param amount
		*/
		bool Creature::TakeEffect(Effect* effectPtr, POWER amount);

		/*! 
		* @brief N[`[̌xԂ
		* @return N[`[̌x
		*/
		LEVEL Creature::GetLevel(void);

		/*!
		* @brief N[`[̒ʏőHPԂ
		* @return N[`[̒ʏőHP
		*/
		HP Creature::GetNorMaxHP(void);

		/*!
		* @brief N[`[̌MPԂ
		* @return N[`[̌MP
		*/
		MP Creature::GetCurMP(void);

		/*!
		* @brief N[`[̌őMPԂ
		* @return N[`[̌őMP
		*/
		MP Creature::GetMaxMP(void);

		/*!
		* @brief N[`[̒ʏőMPԂ
		* @return N[`[̒ʏőMP
		*/
		MP Creature::GetNorMaxMP(void);

		/*!
		* @brief N[`[̌bZ[rOlԂ
		* @return N[`[̌bZ[rOl
		*/
		AC Creature::GetArmorSaving(void);

		/*!
		* @brief N[`[̌Z[rOlԂ
		* @return N[`[̌Z[rOl
		*/
		EV Creature::GetEvasionSaving(void);

		/*!
		* @brief N[`[̌ӎvZ[rOlԂ
		* @return N[`[̌ӎvZ[rOl
		*/
		VO Creature::GetVolitionSaving(void);

		/*!
		* @brief N[`[̏iXgԂ
		* @return N[`[iXg}bv
		*/
		std::vector<Item> *Creature::getItemList(void);

		/*!
		* @brief N[`[̌\ElԂ
		* @return N[`[̌\El
		*/
		SOUL Creature::GetCurrentSoul(void);

		/*!
		* @brief N[`[̃\Eő哞BlԂ
		* @return N[`[̃\Eő哞Bl
		*/
		SOUL Creature::GetMaxSoul(void);

		/*!
		* @brief N[`[̌b\͒lԂ
		* @param stat 擾b\͒lID
		* @return b\͒ľݒl
		*/
		BASE_STATUS Creature::GetCurrentStatus(CREATURE_STATUS stat);

		/*!
		* @brief N[`[̕b\͒lԂ
		* @param stat 擾\͒lID
		* @return b\͒l̕l
		*/
		BASE_STATUS Creature::GetMaxStatus(CREATURE_STATUS stat);

		/*!
		* @brief N[`[̌Eb\͒lԂ
		* @param stat 擾E\͒lID
		* @return b\͒ľEl
		*/
		BASE_STATUS Creature::GetMaxMAXStatus(CREATURE_STATUS stat);

		/*!
		* @brief N[`[̌ݏC{lԂ
		* @param typ 擾ݏC{lID
		* @return ݏC{l
		*/
		int Creature::GetDiscipilnePoint(DISCIPLINE_TYPE typ);

		/*!
		* @brief N[`[̌ݏC{NԂ
		* @param typ 擾ݏC{NID
		* @return ݏC{N
		*/
		int Creature::GetDiscipilneRank(DISCIPLINE_TYPE typ);

		/*!
		* @brief \El̐VKZ
		* @param plus VKZ\E
		* @return Ȃ
		*/
		void Creature::GainSoul(SOUL plus);

		/*!
		* @brief \El̑r
		* @param amount r\E
		* @return Ȃ
		*/
		void Creature::LostSoul(SOUL amount);

		/*!
		* @brief N[`[̐_xԂ
		* @return _x
		*/
		LEVEL Creature::GetDivineLevel(void);

		/*!
		* @brief ݎ{lԂ
		* @return ݎ{l
		*/
		FEED Creature::GetCurrentFeedPoint(void);

		/*!
		* @brief ő厠{lԂ
		* @return ő厠{l
		*/
		FEED Creature::GetMaxFeedPoint(void);

		/*!
		* @brief N[`[̃^[XVs
		* @return Ȃ
		*/
		void Creature::TurnProcess(void);

		/*!
		* @brief N[`[̃Q[ԍXVs
		* @return Ȃ
		*/
		void Creature::TimeProcess(void);

		/*!
		* @brief N[`[̌oߑ^[Ԃ
		* @return ^[
		*/
		TURN Creature::GetTurn(void);

		/*! 
		* @brief N[`[ʂ̃XL{olԂ
		* @param tag 擾XL̃^O
		* @return YXL̊{olAS̖oȂ0Ԃ
		*/
		SKILL_EXP Creature::GetSkillExp(TAG tag);

		/*!
		* @brief N[`[̏wcTagԂ
		* @return wcTag
		*/
		TAG Creature::GetCampTag(void);

		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void Creature::XMLSave(std::string filename);

		/*!
		* @brief N[`[wpɕ鏈
		* @param dir s
		* @return ړۂɏꂽtrueԂ
		* @todo Creature::Walk()ɔe̎
		*/
		bool Creature::Walk(GameLogger *gameLoggerPtr, DIRECTION dir);

		/*!
		* @brief N[`[ڕWN[`[ɑ΂s
		* @param creaturePtr ڕWN[`[̎Qƃ|C^
		* @return ۂɏꂽtrueԂ
		* @todo Creature::Melee()ɔe̎
		*/
		bool Creature::Melee(Creature *targerPtr);

		/*!
		* @brief N[`[ACe擾鏈
		* @param itemIt ǉACe̎QƃCe[^
		* @return ۂɃACeEƂłtrueԂ
		* @todo Creature::PickUpItem()ɔe̎
		*/
		bool Creature::PickUpItem(std::map<ID, boost::shared_ptr<Item>>::iterator itemIt);

		/*!
		* @brief N[`[ACe𗎂Ƃ
		* @param itemIt ƂACe̎QƃCe[^
		* @return ۂɃACe𗎂ƂƂłtrueԂ
		* @todo Creature::DropItem()ɔe̎
		*/
		bool Creature::DropItem(std::map<ID, boost::shared_ptr<Item>>::iterator itemIt);

		/*!
		* @brief N[`[ACeHׂ鏈
		* @param itemIt HׂACe̎QƃCe[^
		* @return ۂɃACeHׂ鏈݂trueԂ
		* @todo Creature::EatItem()ɔe̎
		*/
		bool Creature::EatItem(std::map<ID, boost::shared_ptr<Item>>::iterator itemIt);

		/*!
		* @brief N[`[ACeޏ
		* @param itemIt ރACe̎QƃCe[^
		* @return ۂɃACeޏ݂trueԂ
		* @todo Creature::QuaffItem()ɔe̎
		*/
		bool Creature::QuaffItem(std::map<ID, boost::shared_ptr<Item>>::iterator itemIt);

		/*!
		* @brief N[`[ACe𔭓鏈
		* @param itemIt ACe̎QƃCe[^
		* @return ۂɃACe𔭓݂trueԂ
		* @todo Creature::ActivateItem()ɔe̎
		*/
		bool Creature::ActivateItem(std::map<ID, boost::shared_ptr<Item>>::iterator itemIt);

		/*!
		* @brief N[`[ACe𓊝鏈
		* @param itemIt ACe̎QƃCe[^
		* @return ۂɃACe݂trueԂ
		* @todo Creature::ThrowItem()ɔe̎
		*/
		bool Creature::ThrowItem(std::map<ID, boost::shared_ptr<Item>>::iterator itemIt);

		/*!
		* @brief N[`[ACeǂޏ
		* @param itemIt ǂރACe̎QƃCe[^
		* @return ۂɃACeǂޏ݂trueԂ
		* @todo Creature::ReadItem()ɔe̎
		*/
		bool Creature::ReadItem(std::map<ID, boost::shared_ptr<Item>>::iterator itemIt);

		/*!
		* @brief N[`[wn_ɐN\Ԃ
		* @param itemIt ǂރACe̎QƃCe[^
		* @return N\ȂtrueԂ
		* @todo SȎs
		*/
		bool Creature::CanEnterPosition(GameWorld *worldPtr, Coordinates coordinates);

	};

}

BOOST_CLASS_VERSION(Deeangband::Creature, 10);
