/*!
* @file Coordinates.h
* @brief CoordinatesNXƂ̑tvf̒`
* @date 2014/01/26
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

BOOST_CLASS_VERSION(Coordinates, 1);

namespace Deeangband
{

	/*! 
	* @class Coordinates
	* @brief Q[W̃NX
	* @details
	* <H1>Tv</H1>
	* CoordinatesNXFieldɂ񎟌WɔzueIuWFNg̍W`B
	* <H2>Xe[^Xvf</H2>
	* Q[W͈ȉ̃Xe[^XvfĂB
	* <ul>
	* <li>XW/FX</li>
	* <li>YW/FY</li>
	* </ul>
	*/
	class Coordinates
	{
	private:
		int fx; //!< XW
		int fy; //!< YW

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("X", fx);
				archive & boost::serialization::make_nvp("Y", fy);
			}
		}

	public:

		/*! 
		* @brief CoordinatesNX̃RXgN^
		* @param x XW
		* @param y YW
		*/
		Coordinates::Coordinates(int x, int y);

		/*! 
		* @brief CoordinatesNX̃RXgN^
		*/
		Coordinates::Coordinates(void);

		/*! 
		* @brief CoordinatesNX̃fXgN^
		*/
		Coordinates::~Coordinates(void);

		/*
		* @brief Wݒ肷
		* @param x XW
		* @param y YW
		*/
		void Coordinates::Set(int x, int y);

		/*
		* @brief XW𓾂
		* @return XW
		*/
		int Coordinates::GetX(void);

		/*
		* @brief YW𓾂
		* @return YW𓾂
		*/
		int Coordinates::GetY(void);

		/*!
		* @brief +ZqɂW
		* @param plus Z
		*/
		Coordinates Coordinates::operator=(const Coordinates& plus);  

		/*!
		* @brief +ZqɂWZ
		* @param plus Z
		*/
		Coordinates Coordinates::operator+(const Coordinates& plus);  

		/*!
		* @brief +=ZqɂWZ
		* @param plus Z
		*/
		Coordinates& Coordinates::operator+=(const Coordinates& plus);

		/*!
		* @brief ==Zqɂ铙
		* @param plus Z
		*/
		bool Coordinates::operator==(const Coordinates& plus);  

	};

}

BOOST_CLASS_VERSION(Deeangband::Coordinates, 10);
