/*!
* @file Square.cpp
* @brief Q[̃}X`
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "Square.h"

namespace Deeangband
{

	Square::Square()
	{
		SetDammyData();
	}

	void Square::SetDammyData()
	{
		this->featureTag = SPECIAL_TAG_UNKNOWN;
		this->hitPoint = this->maxPoint = 100;
	}

	Square::~Square()
	{
	}

	bool Square::TakeEffect(Effect *effectPtr, POWER amount)
	{
		if(effectPtr)
		{
			this->hitPoint -= amount;
		}
		return false;
	}

	TAG Square::getFeatureTag(void)
	{
		return this->featureTag;
	}

	Feature *Square::getFeaturePtr(void)
	{
		return NULL;
	}

	const HP Square::GetCurrentHP(void)
	{
		return this->hitPoint;
	}

	const HP Square::GetMaxHP(void)
	{
		return this->maxPoint;
	}

}