/*!
* @file ItemTemplate.h
* @brief ACẽXe[^Xev[g
* @date 2014/04/04
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "Dice.h"
#include "Effect.h"
#include "GameElement.h"
#include "SavingTable.h"


namespace Deeangband
{

	/*!
	* @class ItemTemplate
	* @brief ACẽNX
	*/
	class ItemTemplate : public GameElement
	{
	private:

		Dice baseDamage; //!< x[X_[W̃_CX
		WEIGHT weight; //!< ACȅd
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version f[^o[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & BOOST_SERIALIZATION_NVP(baseDamage);
				archive & BOOST_SERIALIZATION_NVP(weight);
				archive & BOOST_SERIALIZATION_NVP(baseSaving);
				archive & BOOST_SERIALIZATION_NVP(plusSaving);
			}
		}

	public:

		/*! 
		* @brief ItemTemplateNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		ItemTemplate::ItemTemplate(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief ItemTemplateNXRXgN^
		*/
		ItemTemplate::ItemTemplate(void);

		/*! 
		* @brief ItemTemplateNXfXgN^
		*/
		ItemTemplate::~ItemTemplate(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void ItemTemplate::SetDammyData(void);

		/*! 󂯂ʂ */
		bool ItemTemplate::TakeEffect(Effect *effectPtr, POWER amount);

		/*! {bCԂ */
		AC ItemTemplate::GetBaseAC(void);

		/*! ǉbCԂ */
		AC ItemTemplate::GetPlusAC(void);

		/*! {CԂ */
		EV ItemTemplate::GetBaseEV(void);

		/*! ǉCԂ */
		EV ItemTemplate::GetPlusEV(void);

		/*! {ӎuCԂ */
		VO ItemTemplate::GetBaseVO(void);

		/*! ǉӎuCԂ */
		VO ItemTemplate::GetPlusVO(void);

		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void ItemTemplate::XMLSave(std::string filename);

	};

}