/*!
* @file ItemTemplate.cpp
* @brief ACeev[g`
* @date 2014/04/04
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "ItemTemplate.h"

namespace Deeangband
{

	ItemTemplate::ItemTemplate(ID id, TAG tag, GameWorld *gameWorld) : GameElement(id, tag, gameWorld)
	{
		this->SetDammyData();
	}

	ItemTemplate::ItemTemplate(void)
	{
		this->SetDammyData();
	}

	ItemTemplate::~ItemTemplate(void)
	{
	}

	void ItemTemplate::SetDammyData(void)
	{
		this->weight = 0;
	}

	bool ItemTemplate::TakeEffect(Effect *effectPtr, POWER amount)
	{
		if(effectPtr)
		{
			amount = 0;
		}
		return true;
	}

	void ItemTemplate::XMLSave(std::string filename)
	{
		ItemTemplate ItemTemplate = *this;
		std::ofstream ofs(filename);
		assert(ofs);
		boost::archive::xml_oarchive oa(ofs);
		oa << BOOST_SERIALIZATION_NVP(ItemTemplate);
	}

}