/*!
* @file ItemEgo.h
* @brief Q[̃ACeGS̃vg^Cv
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "Dice.h"
#include "GameElement.h"
#include "ItemTemplate.h"
#include "SavingTable.h"

BOOST_CLASS_VERSION(ItemEgo, 1);

namespace Deeangband 
{

	/*! 
	* @class ItemEgo
	* @brief ACeGS̃NX
	*/
	class ItemEgo : public ItemTemplate
	{

	private:

		std::string name; //!< GS̖
		Dice plusDamage; //!< x[X_[W̃_CXZC
		WEIGHT weight; //!< ACȅdʉZC
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC

		friend class boost::serialization::access;
		template<class Archive> void serialize(Archive &archive, const unsigned int) 
		{
			archive & BOOST_SERIALIZATION_NVP(name);
			archive & BOOST_SERIALIZATION_NVP(baseDamage);
			archive & BOOST_SERIALIZATION_NVP(weight);
			archive & BOOST_SERIALIZATION_NVP(baseSaving);
			archive & BOOST_SERIALIZATION_NVP(plusSaving);
		}


	public:

		/*! 
		* @brief ItemEgoNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		ItemEgo::ItemEgo(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief ItemEgoNXRXgN^
		*/
		ItemEgo::ItemEgo(void);

		/*! 
		* @brief ItemEgoNXfXgN^
		*/
		ItemEgo::~ItemEgo(void);

		/*! 
		* @brief _[W_CXCԂ
		* @return _[W_CXC
		*/
		Dice ItemEgo::GetPlusDamageDice(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void ItemEgo::SetDammyData(void);

	};

}