/*!
* @file ItemBase.h
* @brief Q[̃ACex[X̃vg^Cv
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "Dice.h"
#include "ItemTemplate.h"
#include "GameElement.h"
#include "SavingTable.h"

BOOST_CLASS_VERSION(ItemBase, 1);

namespace Deeangband
{

	/*! @class ItemBase
	*  @brief ACex[X̃NX
	*/
	class ItemBase : public ItemTemplate
	{
	private:
		std::string name; //!< x[XACe̖O
		Dice baseDamage; //!< x[X_[W̃_CX
		WEIGHT weight; //!< ACȅd
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC

		friend class boost::serialization::access;
		template<class Archive> void serialize(Archive &archive, const unsigned int) 
		{
			archive & BOOST_SERIALIZATION_NVP(name);
			archive & BOOST_SERIALIZATION_NVP(baseDamage);
			archive & BOOST_SERIALIZATION_NVP(weight);
			archive & BOOST_SERIALIZATION_NVP(baseSaving);
			archive & BOOST_SERIALIZATION_NVP(plusSaving);
		}

	public:

		/*! 
		* @brief ItemBaseNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		ItemBase::ItemBase(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief ItemBaseNXRXgN^
		*/
		ItemBase::ItemBase(void);

		/*! 
		* @brief ItemBasefXgN^
		*/
		ItemBase::~ItemBase(void);

		/*! 
		* @brief ACȅdʂԂ
		* @return ACȅd
		*/
		WEIGHT ItemBase::GetWeight(void);

		/*! 
		* @brief ACẽ_[W_CXԂ
		* @return ACẽ_[W_CX
		*/
		Dice ItemBase::GetDamageDice(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void ItemBase::SetDammyData(void);



		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void ItemBase::XMLSave(std::string filename);

	};

}