/*!
* @file Item.h
* @brief Q[̃ACeƕtvf̃vg^Cv
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "Dice.h"
#include "Effect.h"
#include "GameElement.h"
#include "ItemTemplate.h"
#include "SavingTable.h"

BOOST_CLASS_VERSION(Item, 1);

namespace Deeangband
{

	/*!
	* @class Item
	* @brief ACẽNX
	*/
	class Item : public ItemTemplate
	{
	private:

		Dice baseDamage; //!< x[X_[W̃_CX
		WEIGHT weight; //!< ACȅd
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version f[^o[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & BOOST_SERIALIZATION_NVP(baseDamage);
				archive & BOOST_SERIALIZATION_NVP(weight);
				archive & BOOST_SERIALIZATION_NVP(baseSaving);
				archive & BOOST_SERIALIZATION_NVP(plusSaving);
			}
		}

	public:

		/*! 
		* @brief ItemNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		Item::Item(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief ItemNXRXgN^
		*/
		Item::Item(void);

		/*! 
		* @brief ItemNXfXgN^
		*/
		Item::~Item(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Item::SetDammyData(void);

		/*! 󂯂ʂ */
		bool Item::TakeEffect(Effect *effectPtr, POWER amount);


		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void Item::XMLSave(std::string filename);

	};

}