/*!
* @file GameWorld.cpp
* @brief Q[E`
* @date 2013/12/22
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "GameWorld.h"
#include "Deeangband.h"

namespace Deeangband
{

	GameWorld::GameWorld(void)
	{
		Dice::Initialize();

		authorityList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Authority>(0, SPECIAL_TAG_UNKNOWN, this));
		creatureTraitList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<CreatureTrait>(0, SPECIAL_TAG_UNKNOWN, this));
		effectList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Effect>(0, SPECIAL_TAG_UNKNOWN, this));
		fixedArtifactList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<FixedArtifact>(0, SPECIAL_TAG_UNKNOWN, this));
		featureList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Feature>(0, SPECIAL_TAG_UNKNOWN, this));
		itemBaseList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<ItemBase>(0, SPECIAL_TAG_UNKNOWN, this));
		itemEgoList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<ItemEgo>(0, SPECIAL_TAG_UNKNOWN, this));
		itemTraitList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<ItemTrait>(0, SPECIAL_TAG_UNKNOWN, this));
		karmaList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Karma>(0, SPECIAL_TAG_UNKNOWN, this));
		skillList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Skill>(0, SPECIAL_TAG_UNKNOWN, this));
		speciesList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Species>(0, SPECIAL_TAG_UNKNOWN, this));
		trapBaseList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<TrapBase>(0, SPECIAL_TAG_UNKNOWN, this));
		buildingList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Building>(0, SPECIAL_TAG_UNKNOWN, this));
		campList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Camp>(0, SPECIAL_TAG_UNKNOWN, this));
		dungeonList.emplace(SPECIAL_TAG_UNKNOWN, std::make_shared<Dungeon>(0, SPECIAL_TAG_UNKNOWN, this));

		trapList.emplace(0, std::make_shared<Trap>(0, SPECIAL_TAG_UNKNOWN, this));
		itemList.emplace(0, std::make_shared<Item>(0, SPECIAL_TAG_UNKNOWN, this));
		floorList.emplace(0, std::make_shared<Floor>(0, SPECIAL_TAG_UNKNOWN, this));
		creatureList.emplace(0, std::make_shared<Creature>(0, SPECIAL_TAG_UNKNOWN, this));

		std::shared_ptr<Creature> crePtr(new Creature());

		std::ifstream ifs("HFOko.xml");
		boost::archive::xml_iarchive ia(ifs);
		ia >> BOOST_SERIALIZATION_NVP(*creatureList[0]);
		//creatureList[0]->XMLSave("HFOko.xml");

	}

	GameWorld::~GameWorld(void)
	{
	}

	void GameWorld::XMLSave(void)
	{
		std::ofstream ofs("World.xml");
		assert(ofs);
		boost::archive::xml_oarchive oa(ofs);
		//oa << BOOST_SERIALIZATION_NVP(*this);
	}

	Authority *GameWorld::GetAuthority(TAG tag)
	{
		return &(*authorityList[tag]);
	}

	CreatureTrait *GameWorld::GetCreatureTrait(TAG tag)
	{
		return &(*creatureTraitList[tag]);
	}

	Effect *GameWorld::GetEffect(TAG tag)
	{
		return &(*effectList[tag]);
	}

	FixedArtifact *GameWorld::GetFixedArtifact(TAG tag)
	{
		return &(*fixedArtifactList[tag]);
	}

	Feature *GameWorld::GetFeature(TAG tag)
	{
		return &(*featureList[tag]);
	}

	ItemBase *GameWorld::GetItemBase(TAG tag)
	{
		return &(*itemBaseList[tag]);
	}

	ItemEgo *GameWorld::GetItemEgo(TAG tag)
	{
		return &(*itemEgoList[tag]);
	}

	ItemTrait *GameWorld::GetItemTrait(TAG tag)
	{
		return &(*itemTraitList[tag]);
	}

	Karma *GameWorld::GetKarma(TAG tag)
	{
		return &(*karmaList[tag]);
	}

	Skill *GameWorld::GetSkill(TAG tag)
	{
		return &(*skillList[tag]);
	}

	Species *GameWorld::GetSpecies(TAG tag)
	{
		return &(*speciesList[tag]);
	}

	TrapBase *GameWorld::GetTrapBase(TAG tag)
	{
		return &(*trapBaseList[tag]);
	}

	Building *GameWorld::GetBuilding(TAG tag)
	{
		return &(*buildingList[tag]);
	}

	Camp *GameWorld::GetCamp(TAG tag)
	{
		return &(*campList[tag]);
	}

	Dungeon *GameWorld::GetDungeon(TAG tag)
	{
		return &(*dungeonList[tag]);
	}

	Item *GameWorld::GetItem(ID id)
	{
		return &(*itemList[id]);
	}

	Floor *GameWorld::GetFloor(ID id)
	{
		return &(*floorList[id]);
	}

	Creature *GameWorld::GetCreature(ID id)
	{
		return &(*creatureList[id]);
	}

	Quest *GameWorld::GetQuest(TAG tag)
	{
		return &(*questList[tag]);
	}

	GAME_TIME GameWorld::GetGameTime(void)
	{
		return this->gameTime;
	}

}