/*!
* @file FixedArtifact.h
* @brief Q[̌ŒA[eBt@Ng̃vg^Cv
* @date 2013/12/17
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "Dice.h"
#include "GameElement.h"
#include "ItemTemplate.h"
#include "SavingTable.h"

BOOST_CLASS_VERSION(FixedArtifact, 1);

namespace Deeangband
{

	/*!
	* @class FixedArtifact
	* @brief ŒA[eBt@Ng̃NX
	*/
	class FixedArtifact : public ItemTemplate
	{
	private:
		std::string name; //!< x[XACe̖O
		Dice baseDamage; //!< x[X_[W̃_CX
		WEIGHT weight; //!< ACȅd
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param fileVersion t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int fileVersion) 
		{
			archive & BOOST_SERIALIZATION_NVP(name);
			archive & BOOST_SERIALIZATION_NVP(baseDamage);
			archive & BOOST_SERIALIZATION_NVP(weight);
			archive & BOOST_SERIALIZATION_NVP(baseSaving);
			archive & BOOST_SERIALIZATION_NVP(plusSaving);
		}

	public:

		/*! 
		* @brief FixedArtifactNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		FixedArtifact::FixedArtifact(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief FixedArtifactNXRXgN^
		*/
		FixedArtifact::FixedArtifact(void);

		/*! 
		* @brief FixedArtifactNXfXgN^
		*/
		FixedArtifact::~FixedArtifact(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void FixedArtifact::SetDammyData(void);

	};

}