/*!
*  @file Feature.h
*  @brief Q[̒n`̃vg^Cv
*  @date 2014/02/20
*  @author Deskull
*  2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "GameElement.h"

namespace Deeangband
{

	/*!
	* @class Feature
	* @brief n`̃NX
	*/
	class Feature : public GameElement
	{
	private:
		std::string name; /*!< n`̖O */
		ID tileID; /*!< n`^CID */
		char symbol; /*!< n`^CV{ */
		Color symColor; /*!< n`V{J[ */
		Color backColor; /*!< n`wiJ[ */

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param fileVersion t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int fileVersion) 
		{
			archive & BOOST_SERIALIZATION_NVP(name);
			archive & BOOST_SERIALIZATION_NVP(tileID);
			archive & BOOST_SERIALIZATION_NVP(symbol);
			archive & BOOST_SERIALIZATION_NVP(symColor);
			archive & BOOST_SERIALIZATION_NVP(backColor);
		}

	public:

		/*! 
		* @brief FeatureNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		Feature::Feature(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief FeatureNXRXgN^
		*/
		Feature::Feature(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Feature::SetDammyData(void);

		/*! 
		* @brief FeatureNXfXgN^
		*/
		Feature::~Feature(void);

		/*! 
		* @brief ^CIDԂ
		* @brief ^CID
		*/
		ID Feature::GetTileID(void);

		/*! 
		* @brief n`LԂ
		* @return n`L
		*/
		ID Feature::GetSymbol(void);

		/*! 
		* @brief V{J[Ԃ
		* @brief V{J[
		*/
		Color Feature::GetSymColor(void);

		/*! 
		* @brief wiJ[Ԃ
		* @brief wiJ[
		*/
		Color Feature::GetBackColor(void);

	};

}