/*!
* @file ItemEgo.h
* @brief Q[̃ACeGS̃vg^Cv
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "Dice.h"
#include "GameElement.h"
#include "ItemTemplate.h"
#include "SavingTable.h"
#include "HaveSymbol.h"


namespace Deeangband 
{

	/*! 
	* @class ItemEgo
	* @brief ACeGS̃NX
	* @details
	* <H1>Tv</H1>
	* ItemEgoNX́AeACeɕt^ǉ\`B
	* <H2>Xe[^Xvf</H2>
	* GSACe͈ȉ̃Xe[^XvfĂB
	* <ul>
	* <li>_[W_CXZC/PlusDamageDice</li>
	* <li>dʉZC/PlusWeight</li>
	* <li>{Z[rOC/BaseSaving</li>
	* <li>ǉZ[rOC/PlusSaving</li>
	* </ul>
	*/
	class ItemEgo : public ItemTemplate
	{

	private:


		template<class Archive> void serialize(Archive &archive, const unsigned int) 
		{
			archive & BOOST_SERIALIZATION_NVP(name);
			archive & BOOST_SERIALIZATION_NVP(baseDamage);
			archive & BOOST_SERIALIZATION_NVP(weight);
			archive & BOOST_SERIALIZATION_NVP(baseSaving);
			archive & BOOST_SERIALIZATION_NVP(plusSaving);
		}

	public:

		/*! 
		* @brief ItemEgoNXRXgN^
		*/
		ItemEgo::ItemEgo(void);

		/*! 
		* @brief ItemEgoNXfXgN^
		*/
		ItemEgo::~ItemEgo(void);

		/*! 
		* @brief _[W_CXCԂ
		* @return _[W_CXC
		*/
		Dice ItemEgo::GetPlusDamageDice(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void ItemEgo::WipeData(void);

	};

}