/*!
* @file GameSurfaceSDL.h
* @brief GameSurfaceSDLNXƂ̑tvf̃vg^Cv
* @date 2014/02/19
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"

#include <SDL.h>
#include <SDL_image.h>
//#include <SDL_gfx.h>
#include <SDL_ttf.h>

#include "GameSurface.h"


namespace Deeangband
{
	class Creature;

	#define FPS_UPDATE 20 //!< FPSvZXVt[
	#define WAIT_MSEC 16 //!< EFCg~b(FPS = 1000.0 / WAIT_MSEC)

	struct SDL_Rect_Dee : public SDL_Rect
	{
		SDL_Rect_Dee(int x, int y, int w, int h)
		{
			this->x = x;
			this->y = y;
			this->w = w;
			this->h = h;
		}

		void SDL_Rect_Dee::Set(int x, int y, int w, int h)
		{
			this->x = x;
			this->y = y;
			this->w = w;
			this->h = h;
		}

		SDL_Rect_Dee SDL_Rect_Dee::operator+(const SDL_Rect_Dee& plus)
		{
			this->x += plus.x;
			this->y += plus.y;
			return *this;
		}

		SDL_Rect_Dee()
		{
			this->x = 0;
			this->y = 0;
			this->w = 0;
			this->h = 0;
		}
	};

	/*! 
	 * @class GameSurfaceSDL
	 * @brief Q[̃CC^[tFCXNX(SDL)
	 */
	class GameSurfaceSDL : public GameSurface
	{
	private:

		static const int squareGraphicWidth = 24; //!< 1}X̃OtBbN(sNZ) 
		static const int squareGraphicHeight = 24; //!< 1}X̃OtBbN(sNZ) 
		static const int fieldPadding = 3; //!< \̍ő匄(XNGA) 

		SDL_Rect_Dee rectTitleDst; //!< ^CgOtBbN]W
		SDL_Rect_Dee rectTitleSrc; //!< ^CgOtBbN]W

		SDL_Rect_Dee rectFpsDst; //!< FPS\]W
		SDL_Rect_Dee rectFpsSrc; //!< FPS\]W

		SDL_Rect_Dee rectMainMapDst; //!< C}bv\]

		SDL_Renderer *renderer;     //!< SDLp_Qƃ|C^
		SDL_Window *window;         //!< SDLEBhEQƃ|C^

		Creature *viewCreaturePtr;       //!< ݂̃Xe[^X\ΏۂƂȂCreatureQƃ|C^
		Creature *sideStatusCreatutePtr; //!< ݂̃Xe[^XȈՕ\ΏۂƂȂCreatureQƃ|C^
		Field *viewFieldPtr;       //!< `ΏۂƂȂFieldQ
		Coordinates focusPoint;    //!< tA̕`捶n_

		TTF_Font* font;  //!< `WtHg|C^
		TTF_Font* fontSmall;  //!< `揬^tHg|C^
		SDL_Color color; //!< J[W|C^

		SDL_RWops *rwop;
		std::string currentGameMessage; //!< ݕ\̃Q[bZ[Wstring
		std::string currentSystemMessage; //!< ݕ\̃VXebZ[Wstring
		std::string error;
		SDL_Rect src;
		SDL_Rect title;

		SDL_Surface *windowSurface;  //!< Q[EBhESurfaceQ

		SDL_Texture *titleTexture;   //!< Q[^CgOtBbNTextureQ
		SDL_Texture *unknownFieldTexture; //!< mtB[hOtBbNTextureQ
		SDL_Texture *unseenFieldTexture; //!< EOtB[hOtBbNTextureQ

		SDL_Texture *systemMessageTexture; //!< VXebZ[WOtBbNSurfaceQ
		SDL_Texture *gameMessageTexture; //!< Q[bZ[WOtBbNSurfaceQ
		SDL_Texture *creatureStatusTexture;  //!< N[`[Xe[^X\SurfaceQ
		SDL_Texture *creatureSideStatusTexture;  //!< TChN[`[Xe[^X\SurfaceQ
		SDL_Texture *gameTimeStatusTexture;  //!< Q[ԕ\SurfaceQ
		SDL_Texture *fpsTexture;


		std::map<TAG, SDL_Texture*> floorTextures; //!< tAOtBbNSurfaceQƃXg
		std::map<ID, SDL_Texture*> creatureTextures; //!< N[`[OtBbNSurfaceQƃXg

		void GameSurfaceSDL::pushAnyKey(const CREATURE_IT &subjectCreatureIt);
		void GameSurfaceSDL::pushAnyKey(void);

        int frameDeltaTime;
        int frameTime;
        int frameCount;
        int framesPerSecond;
        int frameTimeLast;
        int frameDeltaTimeLast;

		/*!
		 * @brief C^[tFCXf[^̏
		 * @param gameWorld C^[tFCXۂɕKvȏ𓾂邽߂GameWorldQ
		 * @return Ȃ
		 */
		void GameSurfaceSDL::initInterfaces(GameWorld *gameWorld);

		void GameSurfaceSDL::drawCreatureStatus(Creature *creaturePtr);

		/*!
		 * @brief tA`悷
		 * @param fieldPtr \tA̍\̎Qƃ|C^
		 * @param gameWorld GameWorldQƃ|C^
		 * @param rectDraw `
		 * @param x N_XW
		 * @param y N_YW
		 * @param w \̃}X
		 * @param h \̃}X
		 * @return Ȃ
		 */
		void GameSurfaceSDL::drawField(const CREATURE_IT &subjectCreatureIt, GameWorld *gameWorld, Field *fieldPtr, SDL_Rect_Dee &rectDraw);

		/*!
		 * @brief TChXe[^X`悷
		 * @return Ȃ
		 */
		void GameSurfaceSDL::drawSideCreatureStatus(void);

		/*!
		 * @brief VXebZ[W`悷
		 * @return Ȃ
		 */
		void GameSurfaceSDL::drawSystemMessage(void);

		/*!
		 * @brief Q[bZ[W`悷
		 * @return Ȃ
		 */
		void GameSurfaceSDL::drawGameMessage(void);

		/*!
		 * @brief Q[ԏ`悷
		 * @return Ȃ
		 */
		void GameSurfaceSDL::drawTimeStatus(void);

		void GameSurfaceSDL::fpsProcess(void);


	public:

		/*!
		 * @brief Q[ʂĕ`悷
		 * @param subjectCreatureIt ςƂȂN[`[Ce[^
		 * @return Ȃ
		 */
		void GameSurfaceSDL::Draw(const CREATURE_IT& subjectCreatureIt);

		/*!
		 * @brief Q[ԕ\XV
		 * @param currentTime ݎ
		 * @return Ȃ
		 */
		void GameSurfaceSDL::UpdateTimeStatus(GAME_TIME currentTime);

		/*!
		 * @brief TChXe[^X\XV
		 * @param creaturePtr XVN[`[Qƃ|C^
		 * @return Ȃ
		 */
		void GameSurfaceSDL::UpdateSideCreatureStatus(Creature *creaturePtr);


		/*!
		 * @brief w肳ꂽN[`[̃Xe[^X\
		 * @param creaturePtr \N[`[̎Qƃ|C^
		 * @return Ȃ
		 */
		void GameSurfaceSDL::ViewCreatureStatus(Creature *creaturePtr);

		/*!
		 * @brief Q[ʍɃvC[ȗ\B
		 * @param creaturePtr \N[`[̃CX^XQƃ|C^BNULLȂΔ\B
		 * @return Ȃ
		 */
		void GameSurfaceSDL::SetSideStatusCreature(Creature *creaturePtr);

		/*!
		 * @brief \tA؂ւ
		 * @param fieldPtr \tA̎Qƃ|C^
		 * @return Ȃ
		 */
		void GameSurfaceSDL::SetField(Field *fieldPtr);

		/*!
		 * @brief RXgN^
		 * @param gameWorld GameWorldCX^X
		 */
		GameSurfaceSDL::GameSurfaceSDL(GameWorld *gameWorld);

		/*!
		 * @brief fXgN^
		 */
		GameSurfaceSDL::~GameSurfaceSDL(void);

		/*!
		 * @brief vC[R}h擾
		 * @return Q[R}hID
		 */
		GAME_COMMAND GameSurfaceSDL::GetCommand(const CREATURE_IT& subjectCreatureIt);

		/*!
		 * @brief tA\̃tH[JXύX
		 * @param x XW
		 * @param y YW
		 * @return Ȃ
		 */
		void GameSurfaceSDL::FocusField(MAP_LENGTH x, MAP_LENGTH y);

		/*!
		* @brief tA\̃tH[JXύX
		* @param coord W
		* @return Ȃ
		*/
		void GameSurfaceSDL::FocusField(Coordinates coord);

		/*!
		 * @brief VXebZ[W\
		 * @param message bZ[W
		 * @return Ȃ
		 */
		void GameSurfaceSDL::SystemMessage(std::string message);

		/*!
		 * @brief Q[bZ[W\
		 * @param message bZ[W
		 * @return Ȃ
		 */
		void GameSurfaceSDL::GameMessage(std::string message);

		/*!
		 * @brief N[`[pOtBbNVK쐬/XV
		 * @param message bZ[W
		 * @return Ȃ
		 */
		void GameSurfaceSDL::updateCreatureGraphics(CREATURE_IT creatureIt);


	};

}