/*!
 * @file GameEngine.h
 * @brief Q[GW̃vg^Cv錾
 * @date 2013/04/13
 * @author Deskull
 * 2013-2014 Sikabane Works.
 */

#pragma once

#include "stdafx.h"
#include <mutex>
#include "Deeangband.h"

#include "Coordinates.h"
#include "Direction.h"
#include "GameWorld.h"
#include "GameSurface.h"
#include "GameSurfaceSDL.h"


namespace Deeangband
{
#include "EngineTypedef.h"

	class GameCampaign;
	class GameLogger;

	class GameEngine
	{
	private:
		GameWorld *gameWorld; //!< GameWorld̎Qƃ|C^
		GameSurface *gameSurface; //!< GameSurface̎Qƃ|C^
		GameLogger *gameLogger; //!< GameLogger̎Qƃ|C^
		std::mutex mutex;


	public:
		GameEngine::GameEngine();
		GameEngine::~GameEngine();

		/*!
		 * @brief `揈C[v
		 * @return Ȃ
		 */
		void GameEngine::DrawingLoop(void);

		/*!
		 * @brief vCC[v
		 * @return Q[IR[h
		 */
		PLAY_EXIT_CODE GameEngine::PlayLoop(void);

		/*!
		 * @brief N[`[m̔u
		 * @param creaturePtr UN[`[̎Qƃ|C^
		 * @param targetPtr ڕWN[`[̎Qƃ|C^
		 * @return ړsꂽtrue
		 */
		bool GameEngine::CombatCreatures(Creature *attackerPtr, Creature *targetPtr);

		/*!
		 * @brief N[`[̎SԂ𑖍A
		 * @return SsN[`[̑
		 */
		int GameEngine::ProcessDeadCreatures();

	};
}
