/*!
* @file HaveGameTime.cpp
* @brief Q[^[ێۃNX`
* @date 2014/06/11
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "HaveGameTime.h"

namespace Deeangband
{
	HaveGameTime::HaveGameTime(void)
	{
		WipeData();
		return;
	}

	HaveGameTime::~HaveGameTime(void)
	{
		WipeData();
		return;
	}

	void HaveGameTime::WipeData(void)
	{
		this->time = 0;
		this->turn = 0;
	}

	GAME_TIME HaveGameTime::GetGameTime(void)
	{
		return this->time;
	}

	TURN HaveGameTime::GetTurn(void)
	{
		return this->turn;
	}

	void HaveGameTime::PlusWait(ACTION_WAIT plusWait)
	{
		double wait = plusWait;
		this->wait += plusWait;
		std::normal_distribution<> distWait(wait, GameConstants::ActionWaitDeviation);
		this->wait += (ACTION_WAIT)distWait(Dice::mt);
	}

}
