/*!
* @file Field.h
* @brief Q[̃_Wƕtvf̃vg^Cv
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "Dungeon.h"
#include "GameWorld.h"
#include "GameInstance.h"
#include "Square.h"
#include "Door.h"
#include "TrapBase.h"
#include "Trap.h"
#include "Item.h"

namespace Deeangband
{

	/*!
	* @class Field
	* @brief tÃNX
	*/
	class Field : public GameInstance
	{
	private:
		std::vector<std::vector<boost::shared_ptr<Square>>> squares; //!<tA}X̔z
		std::vector<boost::shared_ptr<Creature>> creatures; //!<N[`[CX^X̔z
		std::vector<boost::shared_ptr<Door>> doors; //!<hACX^X̔z
		std::vector<boost::shared_ptr<Trap>> traps; //!<gbvCX^X̔z
		std::vector<boost::shared_ptr<Item>> items; //!<ACeCX^X̔z
		MAP_LENGTH width;  //!< tẢTCY
		MAP_LENGTH height; //!< tȀcTCY
		bool generated; //!< tAς
		TAG dungeonTag; //!< _W^O

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Squares", squares);
				archive & boost::serialization::make_nvp("Doors", doors);
				archive & boost::serialization::make_nvp("Traps", traps);
				archive & boost::serialization::make_nvp("Items", items);
				archive & boost::serialization::make_nvp("Doors", doors);
				archive & boost::serialization::make_nvp("Width", width);
				archive & boost::serialization::make_nvp("Height", height);
			}
		}

	public:

		/*! 
		* @brief FieldNXRXgN^(TAG,DungeonCe[^̐)
		* @param dungeonPtr _WCe[^
		* @param depth Kw
		* @details 
		* {RXgN^́A_WƐKɃtA𐶐A炭łp̋@̑RXgN^ɂȂB<br>
		* <h2>̗</h2>
		* <ul>
		* <li>tATCY̌</li>
		* <li>Oǒn`ł̑StA[U</li>
		* </ul>
		* @todo DungeonɂRXgN^̐
		*/
		Field::Field(std::map<TAG, boost::shared_ptr<Dungeon>>::iterator dungeonIt, DEPTH depth);


		/*! 
		* @brief FieldNXRXgN^
		*/
		Field::Field();

		/*! 
		* @brief FieldNXfXgN^
		* @todo tASۂɁAtAɔzuN[`[AACeAhAAgbvނAj[N̂̂ȂǂɂďoԂ𒲐邱ƁB
		*/
		Field::~Field();

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Field::WipeData(void);

		/*!
		* @brief tẢTCY𓾂
		* @return tẢTCY
		*/
		MAP_LENGTH Field::GetWidth(void);

		/*!
		* @brief tȀcTCY𓾂
		* @return tȀcTCY
		*/
		MAP_LENGTH Field::GetHeight(void);

		/*!
		* @brief tÃTCYݒ肷
		* @param width tẢTCY
		* @param height tȀcTCY
		* @return ɐꍇtrueԂ
		* @todo ύXꂽꍇ̃tAz̃TCY
		*/
		bool Field::SetSize(MAP_LENGTH width, MAP_LENGTH height);

		/*!
		* @brief tÅYW̃}XԂB
		* @return Y}XCX^X̎Qƃ|C^
		*/
		Square *Field::GetSquare(MAP_LENGTH x, MAP_LENGTH y);

		/*!
		* @brief tÅYWɃgbv𐶐
		* @param trapBaseTag zugbvʃ^O
		* @param position zuW
		* @return ɐꍇtrueԂB
		* @details
		* GenerateTrap֐̓^OŎwꂽgbvʂ̃gbvtȀ̈ʒuɔzuB<br>
		* @todo Field::GenerateTrap̎
		*/
		bool Field::GenerateTrap(std::map<TAG, boost::shared_ptr<TrapBase>>::iterator trapBaseIt, Coordinates *position);

	};

}

BOOST_CLASS_VERSION(Deeangband::Field, 10);
