/*
 * Decompiled with CFR 0.152.
 */
package kry.sql.tokenizer;

import java.util.Iterator;
import kry.sql.format.SqlFormatRule;
import kry.sql.tokenizer.SqlScanner;
import kry.sql.tokenizer.Token;
import kry.sql.tokenizer.TokenList;
import kry.sql.tokenizer.TokenUtil;
import kry.sql.util.StringUtil;

public class SqlTokenizer
implements Iterator {
    protected SqlScanner scanner;
    protected SqlFormatRule rule;
    protected TokenList tokenList;
    protected Iterator it;
    private boolean pushedBack = false;
    private Object token;

    public SqlTokenizer(String sql, SqlFormatRule rule) {
        this.init(sql, rule);
    }

    public SqlTokenizer() {
    }

    protected void init(String sql, SqlFormatRule rule) {
        this.scanner = new SqlScanner(sql);
        this.rule = rule;
        this.tokenList = new TokenList();
        this.parse();
        this.optimize();
        this.it = this.tokenList.iterator();
    }

    public boolean hasNext() {
        if (this.pushedBack) {
            return true;
        }
        return this.it.hasNext();
    }

    public Object next() {
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.token;
        }
        if (this.it.hasNext()) {
            this.token = this.it.next();
            return this.token;
        }
        return null;
    }

    public void pushBack() {
        if (this.token != null) {
            this.pushedBack = true;
        }
    }

    protected boolean isCanceled() {
        return false;
    }

    protected void parse() {
        Token token = new Token("", 0, 0, 0);
        token.setType(0);
        this.tokenList.add(token);
        int x = 0;
        int y = 0;
        int beforeType = -1;
        int depthParen = 0;
        while (this.scanner.hasNext()) {
            String str;
            if (this.isCanceled()) {
                return;
            }
            int skipCount = this.scanner.skipSpaceTab();
            if (!this.scanner.hasNext()) {
                return;
            }
            x += skipCount;
            int incY = 0;
            StringBuffer sb = new StringBuffer();
            int index = this.scanner.getCurrent();
            int type = -1;
            int subType = 0;
            char c = this.scanner.peek();
            if (c == '\"') {
                do {
                    sb.append(this.scanner.next());
                } while ((c = this.scanner.peek()) != '\"' && this.scanner.hasNext());
                if (this.scanner.hasNext()) {
                    sb.append(this.scanner.next());
                }
                type = 40;
            } else if (c == '\'') {
                sb.append(this.scanner.next());
                c = this.scanner.peek();
                do {
                    if (this.scanner.isPeekEquals("''")) {
                        sb.append(this.scanner.next());
                        sb.append(this.scanner.next());
                        c = this.scanner.peek();
                        continue;
                    }
                    if (c == '\'' && this.scanner.peek(1) != '\'') break;
                    sb.append(this.scanner.next());
                    c = this.scanner.peek();
                } while (c != '\'' && this.scanner.hasNext() || this.scanner.isPeekEquals("''"));
                if (this.scanner.hasNext()) {
                    sb.append(this.scanner.next());
                }
                type = 50;
                subType = 51;
            } else if (this.scanner.isPeekEquals("--")) {
                sb.append(this.scanner.next());
                c = this.scanner.peek();
                do {
                    sb.append(this.scanner.next());
                    c = this.scanner.peek();
                } while (this.scanner.hasNext() && !this.scanner.isPeekEquals(TokenUtil.NEW_LINES));
                type = 60;
                subType = 61;
            } else if (this.scanner.isPeekEquals("/*")) {
                sb.append(this.scanner.next());
                c = this.scanner.peek();
                do {
                    sb.append(this.scanner.next());
                    c = this.scanner.peek();
                    if (!this.scanner.isPeekEquals(TokenUtil.NEW_LINES)) continue;
                    if (this.scanner.isPeekEquals("\r\n")) {
                        sb.append(this.scanner.next());
                    }
                    ++incY;
                } while (!this.scanner.isPeekEquals("*/") && this.scanner.hasNext());
                if (this.scanner.hasNext()) {
                    sb.append(this.scanner.next());
                    sb.append(this.scanner.next());
                }
                type = 60;
                subType = 62;
            } else if (this.scanner.isPeekNextEqualsEx("(*)")) {
                sb.append("(*)");
                type = 20;
            } else if (this.scanner.isPeekNextEqualsEx("(+)")) {
                sb.append("(+)");
                type = 20;
            } else if (this.scanner.isPeekEquals(TokenUtil.NEW_LINES)) {
                type = beforeType == 70 || beforeType == 90 ? 90 : 70;
                index = this.scanner.getCurrent() - skipCount;
                if (this.scanner.isPeekEquals("\r\n")) {
                    sb.append(this.scanner.next());
                }
                sb.append(this.scanner.next());
                ++incY;
            } else if (Character.isDigit(c) || (c == '.' || c == '+' || c == '-') && Character.isDigit(this.scanner.peek(1))) {
                do {
                    sb.append(c);
                    this.scanner.next();
                } while (TokenUtil.isNumberChar(c = this.scanner.peek()));
                type = 50;
                subType = 52;
            } else if (TokenUtil.isOperatorChar(c)) {
                str = this.scanner.getPeekNextEqualsExString(TokenUtil.OPERATOR);
                if (str != null) {
                    sb.append(str);
                    if ("(".equals(str)) {
                        ++depthParen;
                    }
                } else {
                    sb.append(this.scanner.next());
                }
                type = 30;
            } else if (TokenUtil.isBindVariable(c) && !this.scanner.isPeekEqualsEx("::")) {
                sb.append(this.scanner.next());
                type = 50;
                subType = 53;
            } else if (TokenUtil.isSymbolChar(c)) {
                str = this.scanner.getPeekNextEqualsExString(TokenUtil.SYMBOL);
                if (str != null) {
                    sb.append(str);
                    if ("(".equals(str)) {
                        ++depthParen;
                    }
                } else {
                    sb.append(this.scanner.next());
                }
                type = 20;
            } else if (TokenUtil.isNameChar(c)) {
                do {
                    sb.append(c);
                    this.scanner.next();
                } while (TokenUtil.isNameChar(c = this.scanner.peek()) && c != '\uffffffff');
                String upper = sb.toString().toUpperCase();
                type = this.rule.isKeyword(upper) ? (TokenUtil.isSpecialValue(upper) ? 50 : 10) : 40;
            } else {
                sb.append(this.scanner.next());
            }
            String original = this.scanner.substring(index);
            token = new Token(original, x, y, index);
            switch (type) {
                case 10: {
                    token.setCustom(sb.toString());
                    if (this.rule.isDataTypes(token.getUpper())) {
                        subType = 11;
                        break;
                    }
                    if (!this.rule.isFunctions(token.getUpper())) break;
                    subType = 12;
                    break;
                }
                case 70: 
                case 90: {
                    token.setCustom(StringUtil.leftTrim(token.getOriginal(), TokenUtil.WORD_SEPARATE));
                    x = 0;
                    break;
                }
                default: {
                    token.setCustom(sb.toString());
                }
            }
            token.setType(type);
            token.setSubType(subType);
            token.setDepthParen(depthParen);
            this.tokenList.add(token);
            beforeType = type;
            x += original.length();
            y += incY;
            if (!")".equals(sb.toString())) continue;
            --depthParen;
        }
        token = new Token("", x, y, this.scanner.getLength());
        token.setType(100);
        this.tokenList.add(token);
    }

    /*
     * Unable to fully structure code
     */
    protected void optimize() {
        i = 0;
        while (i < this.tokenList.size()) {
            if (this.isCanceled()) {
                return;
            }
            current = this.tokenList.getToken(i);
            next1Index = this.tokenList.getNextValidTokenIndex(i, 1);
            next2Index = this.tokenList.getNextValidTokenIndex(i, 2);
            next1 = this.tokenList.getToken(next1Index);
            next2 = this.tokenList.getToken(next2Index);
            if (current != null && next1 != null) {
                currentType = current.getType();
                currentUpper = current.getUpper();
                next1Type = next1.getType();
                next1Upper = next1.getUpper();
                next2Type = next2 == null ? -1 : next2.getType();
                v0 = next2Upper = next2 == null ? null : next2.getUpper();
                if (next2 != null && (currentType == 10 || currentType == 40 || currentType == 50) && ".".equals(next1Upper) && (currentType == 10 || next2Type == 40 || next2Type == 50 || "*".equals(next2Upper))) {
                    current.setType(40);
                    current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next2.getIndex() + next2.getOriginalLength()));
                    current.setCustom(String.valueOf(current.getCustom()) + "." + next2.getCustom());
                    this.tokenList.removeToken(i + 1, next2Index);
                    --i;
                } else if (".".equals(currentUpper) && next1.getSubType() == 52) {
                    current.setType(50);
                    current.setSubType(52);
                    current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next1.getIndex() + next1.getOriginalLength()));
                    current.setCustom("." + next1.getCustom());
                    this.tokenList.removeToken(i + 1, next1Index);
                } else if (("N".equals(currentUpper) || "Q".equals(currentUpper) || "NQ".equals(currentUpper)) && next1.getSubType() == 51) {
                    current.setType(50);
                    current.setSubType(51);
                    current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next1.getIndex() + next1.getOriginalLength()));
                    current.setCustom(String.valueOf(current.getCustom()) + next1.getCustom());
                    this.tokenList.removeToken(i + 1, next1Index);
                    i -= 2;
                } else if ((currentType == 10 || currentType == 40 || currentType == 50) && ".".equals(next1Upper)) {
                    current.setType(40);
                    current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next1.getIndex() + next1.getOriginalLength()));
                    current.setCustom(String.valueOf(current.getCustom()) + ".");
                    this.tokenList.removeToken(i + 1, next1Index);
                } else if (current.getSubType() == 53 && ":".equals(currentUpper) && next1Type == 40) {
                    current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next1.getIndex() + next1.getOriginalLength()));
                    current.setCustom(":" + next1.getCustom());
                    this.tokenList.removeToken(i + 1, next1Index);
                } else {
                    this.setSqlSeparator(current, i);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.tokenList.size() - 1) {
            block21: {
                block22: {
                    if (this.isCanceled()) {
                        return;
                    }
                    current = this.tokenList.getToken(i);
                    next1Index = this.tokenList.getNextValidTokenIndex(i, 1);
                    next1 = this.tokenList.getToken(next1Index);
                    if (current.getType() != 10 || next1 == null || next1.getType() != 10) break block21;
                    next2Index = this.tokenList.getNextValidTokenIndex(i, 2);
                    next3Index = this.tokenList.getNextValidTokenIndex(i, 3);
                    next2 = this.tokenList.getToken(next2Index);
                    next3 = this.tokenList.getToken(next3Index);
                    if (next3 == null || next3.getType() != 10 || next2 == null || next2.getType() != 10) break block22;
                    sb4 = new StringBuffer();
                    sb4.append(current.getCustom()).append(' ');
                    sb4.append(next1.getCustom()).append(' ');
                    sb4.append(next2.getCustom()).append(' ');
                    sb4.append(next3.getCustom());
                    if (!TokenUtil.isMultiKeyword(sb4.toString().toUpperCase())) break block22;
                    current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next3.getIndex() + next3.getOriginalLength()));
                    current.setCustom(sb4.toString());
                    this.tokenList.set(i, current);
                    this.tokenList.removeToken(i + 1, next3Index);
                    break block21;
                }
                if (next2 == null || next2.getType() != 10) ** GOTO lbl-1000
                sb3 = new StringBuffer();
                sb3.append(current.getCustom()).append(' ');
                sb3.append(next1.getCustom()).append(' ');
                sb3.append(next2.getCustom());
                if (TokenUtil.isMultiKeyword(sb3.toString().toUpperCase())) {
                    current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next2.getIndex() + next2.getOriginalLength()));
                    current.setCustom(sb3.toString());
                    this.tokenList.set(i, current);
                    this.tokenList.removeToken(i + 1, next2Index);
                } else lbl-1000:
                // 2 sources

                {
                    sb2 = new StringBuffer();
                    sb2.append(current.getCustom()).append(' ');
                    sb2.append(next1.getCustom());
                    if (TokenUtil.isMultiKeyword(sb2.toString().toUpperCase())) {
                        current.setOriginal(this.scanner.getSql().substring(current.getIndex(), next1.getIndex() + next1.getOriginalLength()));
                        current.setCustom(sb2.toString());
                        this.tokenList.set(i, current);
                        this.tokenList.removeToken(i + 1, next1Index);
                    }
                }
            }
            ++i;
        }
        size = this.tokenList.size();
        i = 0;
        while (i < size) {
            if (this.isCanceled()) {
                return;
            }
            token = this.tokenList.getToken(i);
            if (token.getType() == 20 && "(".equals(token.getUpper())) {
                this.setInParenInfo(i);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSqlSeparator(Token token, int index) {
        Token nextToken;
        String upper = token.getUpper();
        if (upper.length() != 1) return;
        if (!TokenUtil.isSqlSeparate(upper.charAt(0))) {
            return;
        }
        int len = this.tokenList.size();
        int i = index;
        block15: while (i < len) {
            if (this.isCanceled()) {
                return;
            }
            Token current = this.tokenList.getToken(i);
            int type = current.getType();
            upper = current.getUpper();
            switch (type) {
                case 40: 
                case 50: 
                case 80: {
                    return;
                }
                case 20: {
                    if ("(".equals(upper)) break;
                    if (!TokenUtil.isSqlSeparate(upper.charAt(0))) return;
                    break block15;
                }
                case 30: {
                    if (!TokenUtil.isSqlSeparate(upper.charAt(0))) return;
                    break;
                }
                case 10: {
                    if (!TokenUtil.isBeginSqlKeyword(upper)) return;
                    break block15;
                }
                case 100: {
                    break block15;
                }
            }
            ++i;
        }
        token.setType(80);
        Token beforeToken = this.tokenList.getToken(index - 1);
        if (beforeToken != null) {
            int beforeType = beforeToken.getType();
            switch (beforeType) {
                case 70: {
                    token.setOriginal(String.valueOf(beforeToken.getOriginal()) + token.getOriginal());
                    token.setCustom(String.valueOf(this.rule.getOutNewLineCodeStr()) + token.getCustom());
                    token.setIndex(beforeToken.getIndex());
                    token.setX(beforeToken.getX());
                    token.setY(beforeToken.getY());
                    this.tokenList.remove(index - 1);
                    --index;
                    break;
                }
                case 0: 
                case 80: {
                    token.setCustom(token.getCustom());
                    break;
                }
                default: {
                    token.setCustom(String.valueOf(this.rule.getOutNewLineCodeStr()) + token.getCustom());
                }
            }
        }
        if ((nextToken = this.tokenList.getToken(index + 1)) == null) return;
        int nextType = nextToken.getType();
        switch (nextType) {
            case 70: {
                token.setOriginal(String.valueOf(token.getOriginal()) + nextToken.getOriginal());
                token.setCustom(String.valueOf(token.getCustom()) + this.rule.getOutNewLineCodeStr());
                this.tokenList.remove(index + 1);
            }
            case 100: {
                return;
            }
        }
        token.setOriginal(token.getOriginal());
        token.setCustom(String.valueOf(token.getCustom()) + this.rule.getOutNewLineCodeStr());
    }

    private void setInParenInfo(int startPos) {
        int deep = 1;
        int elementLength = 0;
        boolean valueOnly = true;
        int size = this.tokenList.size();
        Token parentTokenInParen = this.tokenList.getParentTokenInParen(startPos);
        Token nextToken = this.tokenList.getToken(startPos - 1);
        if (nextToken != null && !")".equals(nextToken.getUpper())) {
            ++elementLength;
        }
        int i = startPos + 1;
        while (i < size) {
            if (this.isCanceled()) {
                return;
            }
            Token current = this.tokenList.getToken(i);
            int type = current.getType();
            String upper = current.getUpper();
            if ("(".equals(upper)) {
                ++deep;
                current.setElementIndexInParen(0);
            } else if (")".equals(upper)) {
                current.setElementIndexInParen(0);
                if (--deep == 0) {
                    int j = startPos;
                    while (j <= i) {
                        current = this.tokenList.getToken(j);
                        current.setElementLengthInParen(elementLength);
                        current.setValueOnlyInParen(valueOnly);
                        current.setParentTokenInParen(parentTokenInParen);
                        ++j;
                    }
                    return;
                }
            } else {
                current.setElementIndexInParen(elementLength);
                switch (type) {
                    case 10: {
                        valueOnly = false;
                        break;
                    }
                    case 30: 
                    case 40: 
                    case 50: {
                        break;
                    }
                    case 20: {
                        if (deep == 1 && ",".equals(upper)) {
                            current.setElementIndexInParen(elementLength);
                            ++elementLength;
                            break;
                        }
                        if (!"(".equals(upper)) break;
                        valueOnly = false;
                        break;
                    }
                }
            }
            ++i;
        }
    }

    public void remove() {
    }
}

