/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.token;

import java.util.Arrays;

import kry.sql.util.StringUtil;

/**
 *
 * @author kry
 *
 */
public class TokenUtil {
	// sR[h
	public static final String NEW_LINE_SYSTEM = System
			.getProperty("line.separator");

	// s ύX֎~
	public static final String[] NEW_LINES = { "\r\n", "\r", "\n" };

	// sifobOpj
	public static final String[] DEBUG_NEW_LINES = { "CRLF", "CR", "LF" };

	// sK\
	public static final String NEW_LINES_REGEX;
	// s
	public static final char[] NEW_LINE_CHAR;

	// l
	public static final String[] SPECIAL_VALUE = { "NULL", "SYSDATE" };

	// oChϐ
	public static final char[] BIND_VARIABLE = { ':', '?' };

	// P؂
	public static final char[] WORD_SEPARATE = { ' ', '\t' };

	// SQL؂
	public static final char[] SQL_SEPARATE = { '/', ';' };

	static {
		// o^
		NEW_LINE_CHAR = StringUtil.getCharTable(NEW_LINES).toCharArray();

		// \[g
		Arrays.sort(SPECIAL_VALUE);
		Arrays.sort(BIND_VARIABLE);
		Arrays.sort(WORD_SEPARATE);
		Arrays.sort(SQL_SEPARATE);
		Arrays.sort(NEW_LINE_CHAR);

		// sR[hK\
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < NEW_LINES.length; i++) {
			if (i != 0)
				sb.append('|');
			sb.append(NEW_LINES[i]);
		}
		NEW_LINES_REGEX = sb.toString();
	};

	/**
	 * fobOpԂ܂B
	 *
	 * @param str
	 * @return
	 */
	public static String debugString(String str) {
		String debugString = str;
		for (int i = 0; i < NEW_LINES.length; i++) {
			debugString = debugString.replaceAll(NEW_LINES[i],
					DEBUG_NEW_LINES[i]);
		}
		return "w" + debugString + "x";
	}

	/**
	 * sł邩Ԃ܂B
	 *
	 * @param c
	 * @return
	 */
	public static boolean isNewLineChar(char c) {
		return (Arrays.binarySearch(NEW_LINE_CHAR, c) >= 0);
	}

	/**
	 * lł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public static boolean isSpecialValue(String str) {
		return (Arrays.binarySearch(SPECIAL_VALUE, str) >= 0);
	}

	/**
	 * oChϐł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public static boolean isBindVariable(char c) {
		return (Arrays.binarySearch(BIND_VARIABLE, c) >= 0);
	}

	/**
	 * lł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public static boolean isValue(String str) {
		if (str == null)
			return false;
		return (str.startsWith("'") && str.endsWith("'"));
	}

	/**
	 * ""ŊꂽOł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public static boolean isDubleQuoteName(String str) {
		if (str == null)
			return false;
		return (str.startsWith("\"") && str.endsWith("\""));
	}

	/**
	 * P؂蕶ł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public static boolean isWordSeparate(char c) {
		return (Arrays.binarySearch(WORD_SEPARATE, c) >= 0);
	}

	/**
	 * SQL؂蕶ł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public static boolean isSqlSeparate(char c) {
		return (Arrays.binarySearch(SQL_SEPARATE, c) >= 0);
	}

	/**
	 * lɎgp\ł镶Ԃ܂B
	 *
	 * @param c
	 * @return
	 */
	public static boolean isNumberChar(char c) {
		if (Character.isDigit(c))
			return true;
		switch (c) {
		case '.':
		case '+':
		case '-':
		case 'd':
		case 'D':
		case 'e':
		case 'E':
		case 'f':
		case 'F':
			return true;

		default:
			return false;
		}
	}

	/**
	 * ^CvԂ܂BifobOpj
	 *
	 * @param type
	 * @return
	 */
	public static String debugTypeString(int type) {
		StringBuffer sb = new StringBuffer();
		sb.append('w').append(type).append(':');

		switch (type) {
		case ITokenType.DEFAULT:
			sb.append("ftHg");
			break;
		case ITokenType.BEGIN_SQL:
			sb.append("JnSQL");
			break;
		case ITokenType.KEYWORD:
			sb.append("L[[h");
			break;

		case ITokenType.SYMBOL:
			sb.append("L");
			break;

		case ITokenType.OPERATOR:
			sb.append("Zq");
			break;

		case ITokenType.NAME:
			sb.append("");
			break;

		case ITokenType.VALUE:
			sb.append("l");
			break;

		case ITokenType.COMMENT:
			sb.append("Rg");
			break;

		case ITokenType.NEW_LINE:
			sb.append("s");
			break;

		case ITokenType.SQL_SEPARATE:
			sb.append("SQL؂蕶");
			break;

		case ITokenType.EMPTY_LINE:
			sb.append("s");
			break;
		case ITokenType.END_SQL:
			sb.append("ISQL");
			break;

		case ITokenType.UNKNOWN:
		default:
			sb.append("s");
			break;
		}
		sb.append('x');

		return sb.toString();
	}

	/**
	 * Tu^CvԂ܂BifobOpj
	 *
	 * @param subType
	 * @return
	 */
	public static String debugSubTypeString(int subType) {
		StringBuffer sb = new StringBuffer();
		sb.append('w').append(subType).append(':');

		switch (subType) {
		case ITokenSubType.DEFAULT:
			sb.append("ftHg");
			break;
		case ITokenSubType.KEYWORD_RESERVED_WORD:
			sb.append("\");
			break;
		case ITokenSubType.KEYWORD_DATATYPE:
			sb.append("f[^^");
			break;
		case ITokenSubType.KEYWORD_SQL_STATEMENT:
			sb.append("SQL");
			break;
		case ITokenSubType.KEYWORD_FUNCTION:
			sb.append("֐");
			break;
		case ITokenSubType.VALUE_NUMERIC:
			sb.append("l");
			break;
		case ITokenSubType.VALUE_STRING:
			sb.append("l");
			break;
		case ITokenSubType.VALUE_BIND:
			sb.append("oChϐ");
			break;
		case ITokenSubType.COMMENT_MULTI_LINE:
			sb.append("}`C");
			break;
		case ITokenSubType.COMMENT_SINGLE_LINE:
			sb.append("VOC");
			break;
		case ITokenSubType.UNKNOWN:
		default:
			sb.append("s");
			break;

		}
		sb.append('x');

		return sb.toString();
	}

	/**
	 * LSQLg[Nł邩Ԃ܂B
	 *
	 * @param token
	 * @return
	 */
	public static boolean isValidToken(Token token) {
		if (token == null)
			return false;

		switch (token.getType()) {
		case ITokenType.KEYWORD:
		case ITokenType.NAME:
		case ITokenType.OPERATOR:
		case ITokenType.SYMBOL:
		case ITokenType.VALUE:
		case ITokenType.SQL_SEPARATE:
			return true;
		default:
			return false;
		}
	}
}
