/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.token;

/**
 *
 * @author kry
 *
 */
public class Token {
	// IWi
	private String original;

	// 啶ipj
	private String upper;

	// JX^
	private String custom;

	// ^Cv
	private int type;

	// Tu^Cv
	private int subType;

	// 
	private int x;

	// s
	private int y;

	// 擪̕
	private int index;

	// ʏ
	private Paren paren;

	// ʗvfԍ
	private int parenIndex;

	/**
	 * RXgN^
	 *
	 * @param original
	 * @param x
	 * @param y
	 * @param index
	 */
	public Token(String original, int x, int y, int index) {
		this.original = original;
		this.upper = "";
		this.custom = "";
		this.x = x;
		this.y = y;
		this.index = index;
		this.paren = null;
		this.parenIndex = -1;
	}

	/**
	 * Rs[RXgN^
	 *
	 * @param token
	 */
	public Token(Token token) {
		this.original = token.getOriginal();
		this.upper = token.getUpper();
		this.custom = token.getCustom();
		this.x = token.getX();
		this.y = token.getY();
		this.index = token.getIndex();
	}

	public String getOriginal() {
		return original;
	}

	public void setOriginal(String original) {
		this.original = original;
	}

	public String getUpper() {
		return upper;
	}

	public void setUpper(String upper) {
		this.upper = upper;
	}

	public String getCustom() {
		return custom;
	}

	public void setCustom(String custom) {
		this.custom = custom;
		this.upper = custom.toUpperCase();
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public int getSubType() {
		return subType;
	}

	public void setSubType(int subType) {
		this.subType = subType;
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public Paren getParen() {
		return paren;
	}

	public void setParen(Paren paren) {
		this.paren = paren;
	}

	public int getParenIndex() {
		return parenIndex;
	}

	public void setParenIndex(int parenIndex) {
		this.parenIndex = parenIndex;
	}

	/**
	 * @generated by CodeSugar http://sourceforge.net/projects/codesugar
	 */

	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("[Token:");
		buffer.append(" original: ");
		buffer.append(TokenUtil.debugString(original));
		buffer.append(" upper: ");
		buffer.append(TokenUtil.debugString(upper));
		buffer.append(" custom: ");
		buffer.append(TokenUtil.debugString(custom));
		buffer.append(" type: ");
		buffer.append(TokenUtil.debugTypeString(type));
		buffer.append(" subType: ");
		buffer.append(TokenUtil.debugSubTypeString(subType));
		buffer.append(" x: ");
		buffer.append(x);
		buffer.append(" y: ");
		buffer.append(y);
		buffer.append(" index: ");
		buffer.append(index);
		buffer.append(" paren: ");
		buffer.append((paren == null) ? "null" : paren.toString());
		buffer.append(" parenIndex: ");
		buffer.append(parenIndex);
		buffer.append("]");
		return buffer.toString();
	}

	/**
	 * Ϗ\bh
	 *
	 * @return
	 */
	public Token getParentToken() {
		return (paren == null) ? null : paren.getParentToken();
	}

}
