/*
 * Decompiled with CFR 0.152.
 */
package zigen.sql.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import zigen.sql.parser.INode;
import zigen.sql.parser.IVisitor;
import zigen.sql.parser.ast.ASTAlias;
import zigen.sql.parser.ast.ASTCreateStatement;
import zigen.sql.parser.ast.ASTDeleteStatement;
import zigen.sql.parser.ast.ASTDropStatement;
import zigen.sql.parser.ast.ASTExpression;
import zigen.sql.parser.ast.ASTInsertStatement;
import zigen.sql.parser.ast.ASTParentheses;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTStatement;
import zigen.sql.parser.ast.ASTUpdateStatement;
import zigen.sql.parser.exception.NotFoundParentNodeException;
import zigen.sql.parser.exception.ParserException;

public class Node
implements INode {
    protected INode parent;
    protected List children;
    protected String name;
    protected int offset;
    protected int length;
    protected int id;
    protected int scope;

    public Node(String name) {
        this(name, 0, 0, 0);
    }

    public Node(String name, int offset, int length, int scope) {
        this.name = name;
        this.offset = offset;
        this.length = length;
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(INode n) {
        this.parent = n;
    }

    public INode getParent() {
        return this.parent;
    }

    public void addChild(INode n) {
        if (n != null) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(n);
            n.setParent(this);
        }
    }

    public void removeChild(INode child) {
        this.children.remove(child);
        if (child != null) {
            child.setParent(null);
        }
    }

    public INode getChild(int i) {
        return (INode)this.children.get(i);
    }

    public INode getLastChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return (INode)this.children.get(this.children.size() - 1);
    }

    public int getChildrenSize() {
        return this.children == null ? 0 : this.children.size();
    }

    public List getChildren() {
        return this.children;
    }

    public Object accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(IVisitor visitor, Object data) {
        try {
            if (this.children != null) {
                Iterator iter = this.children.iterator();
                while (iter.hasNext()) {
                    INode node = (INode)iter.next();
                    node.accept(visitor, data);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return data;
    }

    public String getNodeClassName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        return name;
    }

    public String toString() {
        return String.valueOf(this.getNodeClassName()) + " text=\"" + this.getName() + "\"";
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                Node n = (Node)this.children.get(i);
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ");
                }
                ++i;
            }
        }
    }

    public ASTStatement getASTStatement() throws ParserException {
        return this.getASTStatement(this);
    }

    private ASTStatement getASTStatement(INode node) throws ParserException {
        if (node instanceof ASTStatement) {
            return (ASTStatement)node;
        }
        if (node.getParent() != null) {
            return this.getASTStatement(node.getParent());
        }
        return null;
    }

    public ASTSelectStatement getASTSelectStatement() throws ParserException {
        return this.getASTSelectStatement(this);
    }

    private ASTSelectStatement getASTSelectStatement(INode node) throws ParserException {
        if (node instanceof ASTSelectStatement) {
            return (ASTSelectStatement)node;
        }
        if (node.getParent() != null) {
            return this.getASTSelectStatement(node.getParent());
        }
        throw new NotFoundParentNodeException("ASTSelectStatement");
    }

    public ASTInsertStatement getASTInsertStatement() throws ParserException {
        return this.getASTInsertStatement(this);
    }

    private ASTInsertStatement getASTInsertStatement(INode node) throws ParserException {
        if (node instanceof ASTInsertStatement) {
            return (ASTInsertStatement)node;
        }
        if (node.getParent() != null) {
            return this.getASTInsertStatement(node.getParent());
        }
        throw new NotFoundParentNodeException("ASTInsertStatement");
    }

    public ASTUpdateStatement getASTUpdateStatement() throws ParserException {
        return this.getASTUpdateStatement(this);
    }

    private ASTUpdateStatement getASTUpdateStatement(INode node) throws ParserException {
        if (node instanceof ASTUpdateStatement) {
            return (ASTUpdateStatement)node;
        }
        if (node.getParent() != null) {
            return this.getASTUpdateStatement(node.getParent());
        }
        throw new NotFoundParentNodeException("ASTUpdateStatement");
    }

    public ASTDeleteStatement getASTDeleteStatement() throws ParserException {
        return this.getASTDeleteStatement(this);
    }

    private ASTDeleteStatement getASTDeleteStatement(INode node) throws ParserException {
        if (node instanceof ASTDeleteStatement) {
            return (ASTDeleteStatement)node;
        }
        if (node.getParent() != null) {
            return this.getASTDeleteStatement(node.getParent());
        }
        throw new NotFoundParentNodeException("ASTDeleteStatement");
    }

    public ASTCreateStatement getASTCreateStatement() throws ParserException {
        return this.getASTCreateStatement(this);
    }

    private ASTCreateStatement getASTCreateStatement(INode node) throws ParserException {
        if (node instanceof ASTCreateStatement) {
            return (ASTCreateStatement)node;
        }
        if (node.getParent() != null) {
            return this.getASTCreateStatement(node.getParent());
        }
        throw new NotFoundParentNodeException("ASTCreateStatement");
    }

    public ASTDropStatement getASTDropStatement() throws ParserException {
        return this.getASTDropStatement(this);
    }

    private ASTDropStatement getASTDropStatement(INode node) throws ParserException {
        if (node instanceof ASTDropStatement) {
            return (ASTDropStatement)node;
        }
        if (node.getParent() != null) {
            return this.getASTDropStatement(node.getParent());
        }
        throw new NotFoundParentNodeException("ASTDropStatement");
    }

    public ASTParentheses getASTParentheses() throws ParserException {
        return this.getASTParentheses(this);
    }

    private ASTParentheses getASTParentheses(INode node) throws ParserException {
        if (node instanceof ASTParentheses) {
            return (ASTParentheses)node;
        }
        if (node.getParent() != null) {
            return this.getASTParentheses(node.getParent());
        }
        return null;
    }

    public ASTExpression getASTExpression() throws ParserException {
        return this.getASTExpression(this);
    }

    private ASTExpression getASTExpression(INode node) throws ParserException {
        if (node instanceof ASTExpression) {
            return (ASTExpression)node;
        }
        if (node instanceof ASTStatement) {
            return null;
        }
        if (node.getParent() != null) {
            return this.getASTExpression(node.getParent());
        }
        return null;
    }

    public ASTAlias getASTAlias() throws ParserException {
        return this.getASTAlias(this);
    }

    private ASTAlias getASTAlias(INode node) throws ParserException {
        if (node instanceof ASTAlias) {
            return (ASTAlias)node;
        }
        if (node.getParent() != null) {
            return this.getASTAlias(node.getParent());
        }
        return null;
    }

    public void addChildToStatement(INode addNode) {
        ASTStatement st = this.getASTStatement();
        if (st != null) {
            st.addChild(addNode);
        }
    }

    public void addChildToStatementParent(INode addNode) {
        ASTStatement st = this.getASTStatement();
        if (st != null && st.getParent() != null) {
            st.getParent().addChild(addNode);
        }
    }

    public INode getChild(String nodeName) {
        if (this.children != null) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                INode n = (INode)iter.next();
                if (!n.getNodeClassName().equals(nodeName)) continue;
                return n;
            }
        }
        return null;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public final int getScope() {
        return this.scope;
    }
}

