/*
 * Decompiled with CFR 0.152.
 */
package zigen.sql.parser;

import java.util.HashMap;
import java.util.Map;
import kry.sql.format.SqlFormatRule;
import kry.sql.tokenizer.SqlTokenizer;
import kry.sql.tokenizer.Token;
import zigen.sql.parser.ASTUtil;
import zigen.sql.parser.INode;
import zigen.sql.parser.ISqlParser;
import zigen.sql.parser.Util;
import zigen.sql.parser.ast.ASTAlias;
import zigen.sql.parser.ast.ASTBind;
import zigen.sql.parser.ast.ASTCase;
import zigen.sql.parser.ast.ASTCaseCause;
import zigen.sql.parser.ast.ASTColumn;
import zigen.sql.parser.ast.ASTComma;
import zigen.sql.parser.ast.ASTCreateStatement;
import zigen.sql.parser.ast.ASTDeleteStatement;
import zigen.sql.parser.ast.ASTDropStatement;
import zigen.sql.parser.ast.ASTElse;
import zigen.sql.parser.ast.ASTExpression;
import zigen.sql.parser.ast.ASTFrom;
import zigen.sql.parser.ast.ASTFunction;
import zigen.sql.parser.ast.ASTGroupby;
import zigen.sql.parser.ast.ASTHavingBy;
import zigen.sql.parser.ast.ASTInnerAlias;
import zigen.sql.parser.ast.ASTInsertStatement;
import zigen.sql.parser.ast.ASTInto;
import zigen.sql.parser.ast.ASTJoin;
import zigen.sql.parser.ast.ASTKeyword;
import zigen.sql.parser.ast.ASTMinus;
import zigen.sql.parser.ast.ASTOn;
import zigen.sql.parser.ast.ASTOperator;
import zigen.sql.parser.ast.ASTOrderby;
import zigen.sql.parser.ast.ASTOutfile;
import zigen.sql.parser.ast.ASTOver;
import zigen.sql.parser.ast.ASTParentheses;
import zigen.sql.parser.ast.ASTPartitionBy;
import zigen.sql.parser.ast.ASTRoot;
import zigen.sql.parser.ast.ASTSelect;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTSet;
import zigen.sql.parser.ast.ASTStatement;
import zigen.sql.parser.ast.ASTTable;
import zigen.sql.parser.ast.ASTTarget;
import zigen.sql.parser.ast.ASTThen;
import zigen.sql.parser.ast.ASTType;
import zigen.sql.parser.ast.ASTUnion;
import zigen.sql.parser.ast.ASTUpdateStatement;
import zigen.sql.parser.ast.ASTValue;
import zigen.sql.parser.ast.ASTValues;
import zigen.sql.parser.ast.ASTWhen;
import zigen.sql.parser.ast.ASTWhere;
import zigen.sql.parser.exception.LoopException;
import zigen.sql.parser.exception.ParserException;
import zigen.sql.parser.exception.UnexpectedTokenException;

public class SqlParser
implements ISqlParser {
    protected SqlTokenizer tokenizer;
    protected int offset = 0;
    protected int length = 0;
    protected int scope = 0;
    public static Map createMap = new HashMap();
    protected Token token;
    protected String _preToken;
    protected int checkPoint = 0;
    protected static final int MAX_SAME_WORD = 1000;

    public SqlParser(String sql, SqlFormatRule rule) {
        this.tokenizer = new SqlTokenizer(sql, rule);
    }

    public SqlParser(String sql, SqlTokenizer sqlTokenizer) {
        this.tokenizer = sqlTokenizer;
    }

    public boolean isCanceled() {
        return false;
    }

    public SqlParser() {
    }

    public void parse(INode node) throws ParserException {
        block8: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    ASTParentheses p;
                    INode lastNode;
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        if (begin.getParent() instanceof ASTFunction) {
                            this.parse(begin.getParent().getParent());
                        } else {
                            this.parse(begin.getParent());
                        }
                        return;
                    }
                    if ("(".equals(this.getToken())) {
                        lastNode = node.getLastChild();
                        p = new ASTParentheses(this.offset, this.length, this.scope);
                        if (lastNode instanceof ASTFunction) {
                            p.setASTFunction((ASTFunction)lastNode);
                            lastNode.addChild(p);
                        } else {
                            node.addChild(p);
                        }
                        this.parse(p);
                        continue block8;
                    }
                    if (!",".equals(this.getToken())) continue block8;
                    System.out.println(node);
                    System.out.println(node.getLastChild());
                    node.addChild(new ASTComma(this.offset, this.length, this.scope));
                    continue block8;
                }
                case 30: {
                    this.tokenizer.pushBack();
                    this.parseExpression(node);
                    continue block8;
                }
                case 10: {
                    ASTOrderby by;
                    ASTStatement st;
                    INode last;
                    ASTParentheses p;
                    if ("select".equalsIgnoreCase(this.getToken())) {
                        ASTSelect select;
                        ASTSelectStatement ss;
                        this.scope = 1;
                        last = node.getLastChild();
                        if (last instanceof ASTUnion) {
                            ss = new ASTSelectStatement(this.offset, this.length, this.scope);
                            select = new ASTSelect(this.offset, this.length, this.scope);
                            ss.addChild(select);
                            last.getParent().addChild(ss);
                            this.parseSelectStatement(select);
                            continue block8;
                        }
                        ss = new ASTSelectStatement(this.offset, this.length, this.scope);
                        select = new ASTSelect(this.offset, this.length, this.scope);
                        ss.addChild(select);
                        node.addChild(ss);
                        this.parseSelectStatement(select);
                        continue block8;
                    }
                    if ("insert".equalsIgnoreCase(this.getToken())) {
                        this.scope = 10;
                        st = new ASTInsertStatement(this.offset, this.length, this.scope);
                        node.addChild(st);
                        this.parseInsertStatement(st);
                        continue block8;
                    }
                    if ("update".equalsIgnoreCase(this.getToken())) {
                        this.scope = 20;
                        st = new ASTUpdateStatement(this.offset, this.length, this.scope);
                        node.addChild(st);
                        this.parseUpdateStatement(st);
                        continue block8;
                    }
                    if ("delete".equalsIgnoreCase(this.getToken())) {
                        this.scope = 30;
                        st = new ASTDeleteStatement(this.offset, this.length, this.scope);
                        node.addChild(st);
                        this.parseDeleteStatement((ASTDeleteStatement)st);
                        continue block8;
                    }
                    if ("create".equalsIgnoreCase(this.getToken())) {
                        this.scope = 50;
                        st = new ASTCreateStatement(this.offset, this.length, this.scope);
                        node.addChild(st);
                        this.parseCreateStatement((ASTCreateStatement)st);
                        continue block8;
                    }
                    if ("create or replace".equalsIgnoreCase(this.getToken())) {
                        this.scope = 50;
                        st = new ASTCreateStatement(this.offset, this.length, this.scope);
                        ((ASTCreateStatement)st).changeCreateOrReplace();
                        node.addChild(st);
                        this.parseCreateStatement((ASTCreateStatement)st);
                        continue block8;
                    }
                    if ("drop".equalsIgnoreCase(this.getToken())) {
                        this.scope = 60;
                        st = new ASTDropStatement(this.offset, this.length, this.scope);
                        node.addChild(st);
                        this.parseDropStatement((ASTDropStatement)st);
                        continue block8;
                    }
                    if ("where".equalsIgnoreCase(this.getToken())) {
                        this.scope = 3;
                        ASTWhere where = new ASTWhere(this.offset, this.length, this.scope);
                        node.addChildToStatement(where);
                        this.parseWhereClause(where);
                        continue block8;
                    }
                    if ("union".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, false);
                        continue block8;
                    }
                    if ("union all".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, true);
                        continue block8;
                    }
                    if ("minus".equalsIgnoreCase(this.getToken())) {
                        this.scope = 0;
                        node.addChild(new ASTMinus(this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("from".equalsIgnoreCase(this.getToken())) {
                        this.scope = 2;
                        ASTFrom from = new ASTFrom(this.offset, this.length, this.scope);
                        node.addChildToStatement(from);
                        this.parseFromClause(from);
                        return;
                    }
                    if ("order by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTOrderby(this.offset, this.length, this.scope);
                        if (node instanceof ASTParentheses) {
                            p = (ASTParentheses)node;
                            p.addChild(by);
                        } else {
                            node.addChildToStatement(by);
                        }
                        this.parseOrderByClause(by);
                        continue block8;
                    }
                    if ("partition by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTPartitionBy(this.offset, this.length, this.scope);
                        if (node instanceof ASTParentheses) {
                            p = (ASTParentheses)node;
                            p.addChild(by);
                        } else {
                            node.addChildToStatement(by);
                        }
                        this.parseOrderByClause(by);
                        continue block8;
                    }
                    if ("group by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTGroupby(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        continue block8;
                    }
                    if ("having by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTHavingBy(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        continue block8;
                    }
                    if ("case".equalsIgnoreCase(this.getToken())) {
                        ASTCaseCause cc = new ASTCaseCause(this.offset, this.length, this.scope);
                        node.addChild(cc);
                        ASTCase c = new ASTCase(this.offset, this.length, this.scope);
                        cc.addChild(c);
                        this.parseCase(cc);
                        continue block8;
                    }
                    if ("then".equalsIgnoreCase(this.getToken()) || "when".equalsIgnoreCase(this.getToken()) || "else".equalsIgnoreCase(this.getToken()) || "end".equalsIgnoreCase(this.getToken())) {
                        if (node instanceof ASTCaseCause) {
                            this.tokenizer.pushBack();
                            this.parseCase((ASTCaseCause)node);
                            continue block8;
                        }
                        if (node instanceof ASTCase || node instanceof ASTWhen || node instanceof ASTThen || node instanceof ASTElse) {
                            this.tokenizer.pushBack();
                            this.parseCase((ASTCaseCause)node.getParent());
                            return;
                        }
                        throw new UnexpectedTokenException(node.getClass().getName(), this.offset, this.length);
                    }
                    if ("into".equalsIgnoreCase(this.getToken())) {
                        ASTInto into = new ASTInto(this.getToken(), this.offset, this.length, this.scope);
                        if (node instanceof ASTSelect || node instanceof ASTFrom) {
                            node.getASTSelectStatement().addChild(into);
                            this.parse(into);
                            continue block8;
                        }
                        node.addChild(new ASTKeyword(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("as".equalsIgnoreCase(this.getToken())) {
                        System.out.println(node);
                        System.out.println(node.getLastChild());
                        last = node.getLastChild();
                        if (last instanceof ASTParentheses && (p = (ASTParentheses)last).isForFunction()) {
                            if (this.nextToken() == 40) {
                                p.setAliasName(this.getToken(), this.offset, this.length);
                                this.parse(node.getParent());
                                continue block8;
                            }
                            this.tokenizer.pushBack();
                            continue block8;
                        }
                        if (last instanceof ASTAlias) {
                            ASTAlias alias = (ASTAlias)last;
                            if (this.nextToken() == 40) {
                                alias.setAliasName(this.getToken(), this.offset, this.length);
                                continue block8;
                            }
                            this.tokenizer.pushBack();
                            continue block8;
                        }
                        throw new UnexpectedTokenException(node.getClass().getName(), this.offset, this.length);
                    }
                    if (this.token.getSubType() == 12) {
                        ASTFunction function = new ASTFunction(this.getToken(), this.offset, this.length, this.scope);
                        node.addChild(function);
                        continue block8;
                    }
                    if ("LEFT JOIN".equalsIgnoreCase(this.getToken()) || "LEFT OUTER JOIN".equalsIgnoreCase(this.getToken()) || "RIGHT JOIN".equalsIgnoreCase(this.getToken()) || "RIGHT OUTER JOIN".equalsIgnoreCase(this.getToken()) || "INNER JOIN".equalsIgnoreCase(this.getToken())) {
                        this.scope = 2;
                        node.addChild(new ASTJoin(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("on".equalsIgnoreCase(this.getToken())) {
                        this.scope = 3;
                        node.addChild(new ASTOn(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("over".equalsIgnoreCase(this.getToken())) {
                        last = node.getLastChild();
                        System.out.println(last);
                        ASTOver over = new ASTOver(this.getToken(), this.offset, this.length, this.scope);
                        node.addChild(over);
                        this.parse(over);
                        continue block8;
                    }
                    if (node instanceof ASTOperator) {
                        this.tokenizer.pushBack();
                        this.parse(node.getParent());
                        continue block8;
                    }
                    node.addChild(new ASTKeyword(this.getToken(), this.offset, this.length, this.scope));
                    continue block8;
                }
                case 40: {
                    INode lastNode = node.getLastChild();
                    System.out.println(node);
                    System.out.println(lastNode);
                    if ("OUTFILE".equalsIgnoreCase(this.getToken())) {
                        node.addChild(new ASTOutfile(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if (lastNode instanceof ASTAlias) {
                        if (node instanceof ASTFunction) {
                            ASTFunction func = (ASTFunction)node;
                            func.setAliasName(this.getToken(), this.offset, this.length);
                            this.parse(func.getParent());
                            continue block8;
                        }
                        if ("OVER".equalsIgnoreCase(this.getToken()) && "ROW_NUMBER".equalsIgnoreCase(lastNode.getName())) {
                            node.addChild(new ASTFunction(this.getToken(), this.offset, this.length, this.scope));
                            continue block8;
                        }
                        ((ASTAlias)lastNode).setAliasName(this.getToken(), this.offset, this.length);
                        continue block8;
                    }
                    if (lastNode instanceof ASTOutfile) {
                        ASTOutfile outfile = (ASTOutfile)lastNode;
                        outfile.setFilePath(this.getToken());
                        continue block8;
                    }
                    if (node instanceof ASTFrom) {
                        if (lastNode instanceof ASTOn) {
                            node.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                            continue block8;
                        }
                        node.addChild(new ASTTable(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if (node instanceof ASTOperator) {
                        this.parseValue(lastNode);
                        continue block8;
                    }
                    node.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                    continue block8;
                }
                case 50: {
                    INode lastNode2 = node.getLastChild();
                    if (lastNode2 instanceof ASTAlias) {
                        if (node instanceof ASTFunction) {
                            ASTFunction func = (ASTFunction)node;
                            func.setAliasName(this.getToken(), this.offset, this.length);
                            this.parse(func.getParent());
                            return;
                        }
                        ((ASTAlias)lastNode2).setAliasName(this.getToken(), this.offset, this.length);
                        continue block8;
                    }
                    if (lastNode2 instanceof ASTOperator) {
                        throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
                    }
                    this.parseValue(node);
                    continue block8;
                }
            }
        }
        return;
    }

    protected void parseSelectStatement(ASTSelect node) throws ParserException {
        block8: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    ASTColumn col;
                    ASTAlias col2;
                    ASTParentheses p;
                    INode lastNode;
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        this.parse(begin.getParent());
                        return;
                    }
                    if ("(".equals(this.getToken())) {
                        lastNode = node.getLastChild();
                        if (lastNode instanceof ASTFunction) {
                            p = new ASTParentheses(this.offset, this.length, this.scope);
                            p.setASTFunction((ASTFunction)lastNode);
                            lastNode.addChild(p);
                            this.parse(p);
                            continue block8;
                        }
                        if (node instanceof ASTSelect) {
                            p = new ASTParentheses(this.offset, this.length, this.scope);
                            node.addChild(p);
                            this.parse(p);
                            continue block8;
                        }
                        throw new UnexpectedTokenException(node.getClass().getName(), this.offset, this.length);
                    }
                    if (",".equals(this.getToken())) {
                        node.addChild(new ASTComma(this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("(*)".equals(this.getToken())) {
                        lastNode = node.getLastChild();
                        if (lastNode instanceof ASTFunction) {
                            p = new ASTParentheses(this.offset, this.length, this.scope);
                            col2 = new ASTColumn("*", this.offset, this.length, this.scope);
                            p.addChild(col2);
                            p.setASTFunction((ASTFunction)lastNode);
                            lastNode.addChild(p);
                            this.parse(lastNode);
                            continue block8;
                        }
                        throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
                    }
                    if ("||".equals(this.getToken())) {
                        lastNode = node.getLastChild();
                        if (lastNode instanceof ASTColumn) {
                            col = (ASTColumn)lastNode;
                            col.addConcat(this.getToken(), this.offset, this.length);
                            continue block8;
                        }
                        throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
                    }
                    throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
                }
                case 30: {
                    if ("*".equals(this.getToken())) {
                        node.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    this.tokenizer.pushBack();
                    this.parseExpression(node);
                    continue block8;
                }
                case 50: {
                    ASTColumn col;
                    INode lastNode1 = node.getLastChild();
                    if (lastNode1 instanceof ASTColumn) {
                        col = (ASTColumn)lastNode1;
                        if (col.isConcating()) {
                            col.addColumn(this.getToken(), this.offset, this.length);
                            continue block8;
                        }
                        col.setAliasName(this.getToken(), this.offset, this.length);
                        continue block8;
                    }
                    if (lastNode1 instanceof ASTAlias) {
                        ((ASTAlias)lastNode1).setAliasName(this.getToken(), this.offset, this.length);
                        continue block8;
                    }
                    this.parseValue(node);
                    continue block8;
                }
                case 40: {
                    ASTAlias col2;
                    INode lastNode = node.getLastChild();
                    if (lastNode instanceof ASTColumn) {
                        col2 = (ASTColumn)lastNode;
                        if (col2.isConcating()) {
                            col2.addColumn(this.getToken(), this.offset, this.length);
                            continue block8;
                        }
                        col2.setAliasName(this.getToken(), this.offset, this.length);
                        continue block8;
                    }
                    if (lastNode instanceof ASTAlias) {
                        ((ASTAlias)lastNode).setAliasName(this.getToken(), this.offset, this.length);
                        continue block8;
                    }
                    col2 = new ASTColumn(this.getToken(), this.offset, this.length, this.scope);
                    node.addChild(col2);
                    continue block8;
                }
                case 10: {
                    ASTOrderby by;
                    ASTAlias col2;
                    if ("select".equalsIgnoreCase(this.getToken())) {
                        this.scope = 1;
                        this.tokenizer.pushBack();
                        this.parse(node.getASTStatement().getParent());
                        continue block8;
                    }
                    if ("from".equalsIgnoreCase(this.getToken())) {
                        this.scope = 2;
                        ASTFrom from = new ASTFrom(this.offset, this.length, this.scope);
                        ASTStatement select = node.getASTStatement();
                        if (select == null) continue block8;
                        ASTFrom wkFrom = (ASTFrom)ASTUtil.findChildWide(select, "ASTFrom");
                        if (wkFrom != null && select.getParent() != null) {
                            ASTStatement pSelect = select.getParent().getASTStatement();
                            pSelect.addChild(from);
                        } else {
                            select.addChild(from);
                        }
                        this.parseFromClause(from);
                        continue block8;
                    }
                    if ("union".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, false);
                        continue block8;
                    }
                    if ("union all".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, true);
                        continue block8;
                    }
                    if ("minus".equalsIgnoreCase(this.getToken())) {
                        this.scope = 0;
                        node.addChildToStatementParent(new ASTMinus(this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("where".equalsIgnoreCase(this.getToken())) {
                        this.scope = 3;
                        ASTWhere where = new ASTWhere(this.offset, this.length, this.scope);
                        node.addChildToStatement(where);
                        this.parseWhereClause(where);
                        continue block8;
                    }
                    if ("order by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTOrderby(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        continue block8;
                    }
                    if ("group by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTGroupby(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        continue block8;
                    }
                    if ("having by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTHavingBy(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        continue block8;
                    }
                    if ("case".equalsIgnoreCase(this.getToken())) {
                        ASTCaseCause cc = new ASTCaseCause(this.offset, this.length, this.scope);
                        node.addChild(cc);
                        ASTCase c = new ASTCase(this.offset, this.length, this.scope);
                        cc.addChild(c);
                        this.parseCase(cc);
                        continue block8;
                    }
                    if (this.token.getSubType() == 12) {
                        col2 = new ASTFunction(this.getToken(), this.offset, this.length, this.scope);
                        node.addChild(col2);
                        continue block8;
                    }
                    this.tokenizer.pushBack();
                    this.parse(node);
                    continue block8;
                }
            }
        }
        return;
    }

    protected void parseFromClause(ASTFrom node) throws ParserException {
        block7: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        this.parse(begin.getParent());
                        return;
                    }
                    if ("(".equals(this.getToken())) {
                        ASTParentheses p = new ASTParentheses(this.offset, this.length, this.scope);
                        node.addChild(p);
                        this.parse(p);
                        continue block7;
                    }
                    if (!",".equals(this.getToken())) continue block7;
                    node.addChild(new ASTComma(this.offset, this.length, this.scope));
                    continue block7;
                }
                case 40: {
                    INode lastNode = node.getLastChild();
                    if (lastNode instanceof ASTAlias) {
                        ((ASTAlias)lastNode).setAliasName(this.getToken(), this.offset, this.length);
                        continue block7;
                    }
                    ASTTable table = new ASTTable(this.getToken(), this.offset, this.length, this.scope);
                    node.addChild(table);
                    continue block7;
                }
                case 50: {
                    INode lastNode2 = node.getLastChild();
                    if (lastNode2 instanceof ASTAlias) {
                        ((ASTAlias)lastNode2).setAliasName(this.getToken(), this.offset, this.length);
                        continue block7;
                    }
                    this.parseValue(node);
                    continue block7;
                }
                case 10: {
                    if ("where".equalsIgnoreCase(this.getToken())) {
                        this.scope = 3;
                        ASTWhere where = new ASTWhere(this.offset, this.length, this.scope);
                        node.addChildToStatement(where);
                        this.parseWhereClause(where);
                        continue block7;
                    }
                    if ("union".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, false);
                        continue block7;
                    }
                    if ("union all".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, true);
                        continue block7;
                    }
                    if ("minus".equalsIgnoreCase(this.getToken())) {
                        this.scope = 0;
                        ASTMinus minus = new ASTMinus(this.offset, this.length, this.scope);
                        ASTStatement st = node.getASTStatement();
                        if (st != null && st.getParent() != null) {
                            st.getParent().addChild(minus);
                            this.parse(st.getParent());
                            return;
                        }
                        ASTParentheses p = node.getASTParentheses();
                        if (p != null) {
                            p.addChild(minus);
                            this.parse(p);
                            return;
                        }
                        throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
                    }
                    this.tokenizer.pushBack();
                    this.parse(node);
                    return;
                }
            }
        }
        return;
    }

    protected void parseWhereClause(ASTWhere node) throws ParserException {
        while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        this.parse(begin.getParent());
                        return;
                    }
                    if ("(".equals(this.getToken())) {
                        ASTParentheses p = new ASTParentheses(this.offset, this.length, this.scope);
                        node.addChild(p);
                        this.parse(p);
                        break;
                    }
                    if (",".equals(this.getToken())) break;
                    this.parseOuterJoinForOracle(node);
                    break;
                }
                case 30: {
                    this.tokenizer.pushBack();
                    this.parseExpression(node);
                    break;
                }
                case 40: {
                    node.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                    break;
                }
                case 50: {
                    this.parseValue(node);
                    break;
                }
                case 10: {
                    ASTOrderby by;
                    if ("union".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, false);
                        break;
                    }
                    if ("union all".equalsIgnoreCase(this.getToken())) {
                        this.parseUnion(node, true);
                        break;
                    }
                    if ("minus".equalsIgnoreCase(this.getToken())) {
                        this.scope = 0;
                        node.addChildToStatementParent(new ASTMinus(this.offset, this.length, this.scope));
                        break;
                    }
                    if ("select".equalsIgnoreCase(this.getToken())) {
                        this.scope = 1;
                        ASTSelectStatement ss = new ASTSelectStatement(this.offset, this.length, this.scope);
                        ASTSelect select = new ASTSelect(this.offset, this.length, this.scope);
                        ss.addChild(select);
                        node.addChildToStatementParent(ss);
                        this.parseSelectStatement(select);
                        break;
                    }
                    if ("order by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTOrderby(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        break;
                    }
                    if ("group by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTGroupby(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        break;
                    }
                    if ("having by".equalsIgnoreCase(this.getToken())) {
                        this.scope = 4;
                        by = new ASTHavingBy(this.offset, this.length, this.scope);
                        node.addChildToStatement(by);
                        this.parseOrderByClause(by);
                        break;
                    }
                    this.tokenizer.pushBack();
                    this.parse(node);
                }
            }
        }
        return;
    }

    protected void parseOrderByClause(ASTOrderby node) throws ParserException {
        block6: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        this.parse(begin.getParent());
                        return;
                    }
                    if ("(".equals(this.getToken())) {
                        ASTParentheses p = new ASTParentheses(this.offset, this.length, this.scope);
                        node.addChild(p);
                        this.parse(p);
                        continue block6;
                    }
                    if (!",".equals(this.getToken())) continue block6;
                    node.addChild(new ASTComma(this.offset, this.length, this.scope));
                    continue block6;
                }
                case 40: {
                    INode lastNode = node.getLastChild();
                    if (lastNode instanceof ASTAlias) {
                        ((ASTAlias)lastNode).setAliasName(this.getToken(), this.offset, this.length);
                        continue block6;
                    }
                    ASTColumn col = new ASTColumn(this.getToken(), this.offset, this.length, this.scope);
                    node.addChild(col);
                    continue block6;
                }
                case 10: {
                    this.tokenizer.pushBack();
                    return;
                }
            }
        }
        return;
    }

    protected void skipToken(INode node, int offset, int length) throws ParserException {
        block9: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        return;
                    }
                    if (!"(".equals(this.getToken())) continue block9;
                    this.skipToken(node, offset, length);
                    continue block9;
                }
                case 10: {
                    if ("select".equalsIgnoreCase(this.getToken())) {
                        this.scope = 1;
                        this.tokenizer.pushBack();
                        ASTParentheses p = new ASTParentheses(offset, length, this.scope);
                        node.addChild(p);
                        this.parse(p);
                        continue block9;
                    }
                    this.tokenizer.pushBack();
                    block10: while (true) {
                        switch (this.nextToken()) {
                            case 100: {
                                break block10;
                            }
                            case 20: {
                                if (!")".equals(this.getToken())) continue block10;
                                break block10;
                            }
                            default: {
                                continue block10;
                            }
                        }
                        break;
                    }
                    this.tokenizer.pushBack();
                    continue block9;
                }
            }
        }
        return;
    }

    protected void skipClause(INode node, int offset, int length) throws ParserException {
        block9: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    this.tokenizer.pushBack();
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        this.tokenizer.pushBack();
                        return;
                    }
                    if (!"(".equals(this.getToken())) continue block9;
                    this.skipClause(node, offset, length);
                    continue block9;
                }
                case 10: {
                    if ("select".equalsIgnoreCase(this.getToken())) {
                        this.scope = 1;
                        this.tokenizer.pushBack();
                        ASTParentheses p = new ASTParentheses(offset, length, this.scope);
                        node.addChild(p);
                        this.parse(p);
                        continue block9;
                    }
                    if ("by".equalsIgnoreCase(this.getToken())) continue block9;
                    this.tokenizer.pushBack();
                    block10: while (true) {
                        switch (this.nextToken()) {
                            case 100: {
                                break block10;
                            }
                            case 20: {
                                if (!")".equals(this.getToken())) continue block10;
                                break block10;
                            }
                            default: {
                                continue block10;
                            }
                        }
                        break;
                    }
                    this.tokenizer.pushBack();
                    continue block9;
                }
            }
        }
        return;
    }

    protected void parseInsertStatement(INode node) throws ParserException {
        block7: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        this.parseInsertStatement(node.getParent());
                        continue block7;
                    }
                    if ("(".equals(this.getToken())) {
                        this.scope = node instanceof ASTInsertStatement ? 12 : 0;
                        ASTParentheses p = new ASTParentheses(this.offset, this.length, this.scope);
                        node.addChild(p);
                        this.parseInsertStatement(p);
                        continue block7;
                    }
                    if (!",".equals(this.getToken()) || !(node instanceof ASTParentheses)) continue block7;
                    node.addChild(new ASTComma(this.offset, this.length, this.scope));
                    continue block7;
                }
                case 10: {
                    if ("into".equalsIgnoreCase(this.getToken())) {
                        this.scope = 11;
                        ASTInto into = new ASTInto(this.getToken(), this.offset, this.length, this.scope);
                        node.getASTInsertStatement().addChild(into);
                        this.parseInsertStatement(into);
                        continue block7;
                    }
                    if ("values".equalsIgnoreCase(this.getToken())) {
                        this.scope = 3;
                        ASTValues values = new ASTValues(this.offset, this.length, this.scope);
                        node.addChild(values);
                        this.parseInsertStatement(values);
                        continue block7;
                    }
                    if (!"select".equalsIgnoreCase(this.getToken())) continue block7;
                    this.scope = 1;
                    this.tokenizer.pushBack();
                    this.parse(node.getASTInsertStatement());
                    continue block7;
                }
                case 40: {
                    if (node instanceof ASTInto) {
                        node.addChild(new ASTTable(this.getToken(), this.offset, this.length, this.scope));
                        this.parseInsertStatement(node.getASTInsertStatement());
                        continue block7;
                    }
                    if (node instanceof ASTParentheses) {
                        node.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                        continue block7;
                    }
                    throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
                }
                case 50: {
                    this.parseValue(node);
                    continue block7;
                }
            }
        }
        return;
    }

    protected void parseUpdateStatement(INode node) throws ParserException {
        block8: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        this.parseUpdateStatement(node.getParent());
                        continue block8;
                    }
                    if ("(".equals(this.getToken())) {
                        ASTParentheses p = new ASTParentheses(this.offset, this.length, this.scope);
                        node.addChild(p);
                        this.parseUpdateStatement(p);
                        continue block8;
                    }
                    if (!",".equals(this.getToken())) continue block8;
                    node.addChild(new ASTComma(this.offset, this.length, this.scope));
                    continue block8;
                }
                case 10: {
                    if ("set".equalsIgnoreCase(this.getToken())) {
                        this.scope = 21;
                        ASTSet set = new ASTSet(this.offset, this.length, this.scope);
                        node.getASTUpdateStatement().addChild(set);
                        this.parseUpdateStatement(set);
                        continue block8;
                    }
                    if (!"where".equalsIgnoreCase(this.getToken())) continue block8;
                    this.scope = 3;
                    ASTWhere where = new ASTWhere(this.offset, this.length, this.scope);
                    ASTUpdateStatement st = node.getASTUpdateStatement();
                    st.addChild(where);
                    this.parseWhereClause(where);
                    continue block8;
                }
                case 30: {
                    this.tokenizer.pushBack();
                    this.parseExpression(node);
                    continue block8;
                }
                case 50: {
                    this.parseValue(node);
                    continue block8;
                }
                case 40: {
                    if (node instanceof ASTUpdateStatement) {
                        node.addChild(new ASTTable(this.getToken(), this.offset, this.length, this.scope));
                        this.parseUpdateStatement(node.getASTUpdateStatement());
                        continue block8;
                    }
                    if (node instanceof ASTSet) {
                        node.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if (node instanceof ASTParentheses) {
                        node.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                        continue block8;
                    }
                    throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
                }
            }
        }
        return;
    }

    protected void parseDeleteStatement(ASTDeleteStatement node) throws ParserException {
        block5: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        this.parse(begin.getParent());
                        return;
                    }
                    if (!"(".equals(this.getToken())) continue block5;
                    this.skipToken(node, this.offset, this.length);
                    continue block5;
                }
                case 10: {
                    if ("from".equalsIgnoreCase(this.getToken())) {
                        this.scope = 2;
                        ASTFrom from = new ASTFrom(this.offset, this.length, this.scope);
                        node.getASTDeleteStatement().addChild(from);
                        this.parseFromClause(from);
                        continue block5;
                    }
                    if (!"where".equalsIgnoreCase(this.getToken())) continue block5;
                    this.scope = 3;
                    ASTWhere where = new ASTWhere(this.offset, this.length, this.scope);
                    ASTDeleteStatement ds = node.getASTDeleteStatement();
                    ds.addChild(where);
                    this.parseWhereClause(where);
                    continue block5;
                }
            }
        }
        return;
    }

    protected void parseCreateStatement(ASTCreateStatement node) throws ParserException {
        block5: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 10: {
                    if (node.hasType()) continue block5;
                    this.scope = 70;
                    node.addChild(new ASTType(this.getToken(), this.offset, this.length, this.scope));
                    continue block5;
                }
                case 40: {
                    ASTType type;
                    INode lastNode = node.getLastChild();
                    if (!(lastNode instanceof ASTType)) continue block5;
                    if ("body".equalsIgnoreCase(this.getToken())) {
                        type = (ASTType)lastNode;
                        type.setPackageBody(true);
                        continue block5;
                    }
                    type = (ASTType)lastNode;
                    if (type.hasTarget()) continue block5;
                    ASTTarget name = new ASTTarget(this.getToken(), this.offset, this.length, this.scope);
                    lastNode.addChild(name);
                    continue block5;
                }
            }
        }
        return;
    }

    protected void parseDropStatement(ASTDropStatement node) throws ParserException {
        block5: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 10: {
                    ASTType type;
                    this.scope = 70;
                    if ("function".equalsIgnoreCase(this.getToken())) {
                        type = new ASTType("function", this.offset, this.length, this.scope);
                        node.getASTDropStatement().addChild(type);
                        continue block5;
                    }
                    if ("procedure".equalsIgnoreCase(this.getToken())) {
                        type = new ASTType("procedure", this.offset, this.length, this.scope);
                        node.getASTDropStatement().addChild(type);
                        continue block5;
                    }
                    if ("trigger".equalsIgnoreCase(this.getToken())) {
                        type = new ASTType("trigger", this.offset, this.length, this.scope);
                        node.getASTDropStatement().addChild(type);
                        continue block5;
                    }
                    if ("package".equalsIgnoreCase(this.getToken())) {
                        type = new ASTType("package", this.offset, this.length, this.scope);
                        node.getASTDropStatement().addChild(type);
                        continue block5;
                    }
                    if ("table".equalsIgnoreCase(this.getToken())) {
                        type = new ASTType("table", this.offset, this.length, this.scope);
                        node.getASTDropStatement().addChild(type);
                        continue block5;
                    }
                    if ("view".equalsIgnoreCase(this.getToken())) {
                        type = new ASTType("view", this.offset, this.length, this.scope);
                        node.getASTDropStatement().addChild(type);
                        continue block5;
                    }
                    if (!"synonym".equalsIgnoreCase(this.getToken())) continue block5;
                    type = new ASTType("synonym", this.offset, this.length, this.scope);
                    node.getASTDropStatement().addChild(type);
                    continue block5;
                }
                case 40: {
                    INode lastNode = node.getLastChild();
                    if (!(lastNode instanceof ASTType)) continue block5;
                    if ("body".equalsIgnoreCase(this.getToken())) {
                        ASTType type = (ASTType)lastNode;
                        type.setPackageBody(true);
                        continue block5;
                    }
                    ASTTarget name = new ASTTarget(this.getToken(), this.offset, this.length, this.scope);
                    node.addChild(name);
                    continue block5;
                }
            }
        }
        return;
    }

    protected void parseCase(ASTCaseCause node) throws ParserException {
        block8: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        this.parse(begin.getParent());
                        return;
                    }
                    if ("(".equals(this.getToken())) {
                        INode lastNode = node.getLastChild();
                        ASTParentheses p = new ASTParentheses(this.offset, this.length, this.scope);
                        if (lastNode instanceof ASTFunction) {
                            p.setASTFunction((ASTFunction)lastNode);
                            lastNode.addChild(p);
                            this.parse(p);
                        } else {
                            node.getLastChild().addChild(p);
                            this.parse(p);
                        }
                        return;
                    }
                    if (!",".equals(this.getToken())) continue block8;
                    continue block8;
                }
                case 30: {
                    this.tokenizer.pushBack();
                    this.parseExpression(node);
                    continue block8;
                }
                case 40: {
                    INode n = node.getLastChild();
                    n.addChild(new ASTColumn(this.getToken(), this.offset, this.length, this.scope));
                    continue block8;
                }
                case 50: {
                    INode n2 = node.getLastChild();
                    if (n2 instanceof ASTAlias) {
                        ASTAlias alias = (ASTAlias)n2;
                        alias.setAliasName(this.getToken(), this.offset, this.length);
                        continue block8;
                    }
                    this.parseValue(n2);
                    continue block8;
                }
                case 10: {
                    if ("when".equalsIgnoreCase(this.getToken())) {
                        node.addChild(new ASTWhen(this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("then".equalsIgnoreCase(this.getToken())) {
                        node.addChild(new ASTThen(this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("else".equalsIgnoreCase(this.getToken())) {
                        node.addChild(new ASTElse(this.offset, this.length, this.scope));
                        continue block8;
                    }
                    if ("end".equalsIgnoreCase(this.getToken())) {
                        node.setComplete(true);
                        this.parse(node.getParent());
                        return;
                    }
                    if (this.token.getSubType() != 12) continue block8;
                    this.tokenizer.pushBack();
                    this.parse(node.getLastChild());
                    return;
                }
            }
        }
        return;
    }

    protected String getToken() {
        return this.token.getCustom();
    }

    protected int nextToken() {
        if (this.tokenizer.hasNext()) {
            this._preToken = this.token != null ? this.token.getOriginal() : "";
            this.token = (Token)this.tokenizer.next();
            this.offset = this.token.getIndex();
            this.length = this.token.getOriginalLength();
            this.checkPoint = this.token.getOriginal().equals(this._preToken) ? ++this.checkPoint : 0;
            if (this.checkPoint > 1000) {
                throw new LoopException(1000);
            }
            return this.token.getType();
        }
        return 100;
    }

    protected void parseExpression(INode node) throws ParserException {
        block8: while (!this.isCanceled()) {
            switch (this.nextToken()) {
                case 100: {
                    return;
                }
                case 20: {
                    if (")".equals(this.getToken())) {
                        ASTParentheses begin = node.getASTParentheses();
                        begin.setEndOffset(this.offset);
                        this.scope = begin.getScope();
                        if (begin.isForFunction()) {
                            this.parse(begin.getParent().getParent());
                        } else {
                            this.parse(begin.getParent());
                        }
                        return;
                    }
                    if ("(".equals(this.getToken())) {
                        INode lastNode = node.getLastChild();
                        ASTParentheses p = new ASTParentheses(this.offset, this.length, this.scope);
                        if (lastNode instanceof ASTFunction) {
                            p.setASTFunction((ASTFunction)lastNode);
                            lastNode.addChild(p);
                            this.parse(p);
                        } else {
                            node.addChild(p);
                            this.parse(p);
                        }
                        return;
                    }
                    if (",".equals(this.getToken())) {
                        node.getParent().addChild(new ASTComma(this.offset, this.length, this.scope));
                        this.parse(node.getParent());
                        return;
                    }
                    this.parseOuterJoinForOracle(node);
                    continue block8;
                }
                case 10: {
                    if (this.token.getSubType() == 12) {
                        ASTFunction function = new ASTFunction(this.getToken(), this.offset, this.length, this.scope);
                        node.addChild(function);
                        this.parseExpression(node);
                        return;
                    }
                    ASTExpression exp1 = node.getASTExpression();
                    if (exp1 != null) {
                        this.tokenizer.pushBack();
                        this.parse(exp1.getParent());
                    } else {
                        this.tokenizer.pushBack();
                        this.parse(node);
                    }
                    return;
                }
                case 40: {
                    ASTOperator ope;
                    if (node instanceof ASTOperator) {
                        ope = (ASTOperator)node;
                        if (ope.hasReftChild()) {
                            ASTExpression exp = ope.getASTExpression();
                            exp.setAliasName(this.getToken(), this.offset, this.length);
                            this.parse(exp.getParent());
                            return;
                        }
                        ASTColumn col = new ASTColumn(this.getToken(), this.offset, this.length, this.scope);
                        node.addChild(col);
                        continue block8;
                    }
                    ASTColumn col = new ASTColumn(this.getToken(), this.offset, this.length, this.scope);
                    node.addChild(col);
                    continue block8;
                }
                case 50: {
                    this.parseValue(node);
                    continue block8;
                }
                case 30: {
                    ASTOperator ope = new ASTOperator(this.getToken(), this.offset, this.length, this.scope);
                    INode lastNode = node.getLastChild();
                    if (lastNode instanceof ASTCase || lastNode instanceof ASTWhen || lastNode instanceof ASTThen || lastNode instanceof ASTElse) {
                        this.tokenizer.pushBack();
                        this.parseExpression(lastNode);
                        return;
                    }
                    if (lastNode instanceof ASTParentheses && ((ASTParentheses)lastNode).isForFunction()) {
                        ASTParentheses p = (ASTParentheses)lastNode;
                        ASTExpression exp = p.getASTFunction().getASTExpression();
                        if (exp == null) {
                            exp = new ASTExpression(this.offset, this.length, this.scope);
                            this.tokenizer.pushBack();
                            this.parseExpression(this.changeNode(p.getASTFunction(), exp));
                            return;
                        }
                        this.parseExpression(this.changeNode(p.getASTFunction(), ope));
                        continue block8;
                    }
                    if (!(lastNode instanceof ASTColumn) && !(lastNode instanceof ASTValue) && !(lastNode instanceof ASTFunction) && !(lastNode instanceof ASTParentheses)) continue block8;
                    ASTExpression exp = node.getASTExpression();
                    if (exp == null) {
                        exp = new ASTExpression(this.offset, this.length, this.scope);
                        this.tokenizer.pushBack();
                        this.parseExpression(this.changeNode(lastNode, exp));
                        return;
                    }
                    if (node instanceof ASTOperator) {
                        ASTOperator pre = (ASTOperator)node;
                        if (pre.compare(ope) < 0) {
                            this.parseExpression(this.changeNode(lastNode, ope));
                            continue block8;
                        }
                        this.parseExpression(this.changeNode(pre, ope));
                        continue block8;
                    }
                    this.parseExpression(this.changeNode(lastNode, ope));
                    return;
                }
            }
        }
        return;
    }

    protected void parseUnion(INode node, boolean isUnionAll) throws ParserException {
        this.scope = 0;
        ASTUnion union = isUnionAll ? new ASTUnion(this.offset, this.length, this.scope, true) : new ASTUnion(this.offset, this.length, this.scope);
        if (node instanceof ASTRoot) {
            node.addChild(union);
            this.parse(node);
            return;
        }
        if (node instanceof ASTParentheses) {
            ASTParentheses p = (ASTParentheses)node;
            p.addChild(union);
            this.parse(p);
            return;
        }
        ASTStatement st = node.getASTStatement();
        if (st != null && st.getParent() != null) {
            st.getParent().addChild(union);
            this.parse(st.getParent());
            return;
        }
        ASTParentheses p = node.getASTParentheses();
        if (p != null) {
            p.addChild(union);
            this.parse(p);
            return;
        }
        System.err.println("\u60f3\u5b9a\u5916");
        throw new UnexpectedTokenException(this.getToken(), this.offset, this.length);
    }

    protected void parseOuterJoinForOracle(INode node) {
        INode lastNode;
        if ("(+)".equals(this.getToken()) && (lastNode = node.getLastChild()) instanceof ASTColumn) {
            ((ASTColumn)lastNode).addOuterJoin(this.getToken(), this.offset, this.length);
        }
    }

    private INode changeNode(INode from, INode to) {
        INode parent = from.getParent();
        parent.removeChild(from);
        parent.addChild(to);
        to.addChild(from);
        return to;
    }

    INode parseValue(INode parent) {
        ASTValue node = null;
        node = this.token.getSubType() == 53 ? new ASTBind(this.getToken(), this.offset, this.length, this.scope) : new ASTValue(this.getToken(), this.offset, this.length, this.scope);
        parent.addChild(node);
        return node;
    }

    public int getScope() {
        return this.scope;
    }

    public String dump(INode node) {
        StringBuffer sb = new StringBuffer();
        this.dump(sb, node, "");
        return sb.toString();
    }

    protected void dump(StringBuffer sb, INode node, String pre) {
        boolean cfr_ignored_0 = node instanceof ASTInnerAlias;
        if (node.getChildrenSize() != 0) {
            sb.append(String.valueOf(pre) + "<" + node.toString() + ">\r\n");
            int i = 0;
            while (i < node.getChildrenSize()) {
                INode n = node.getChild(i);
                if (n != null) {
                    this.dump(sb, n, String.valueOf(pre) + " ");
                }
                ++i;
            }
            sb.append(String.valueOf(pre) + "</" + node.getNodeClassName() + ">\r\n");
        } else {
            sb.append(String.valueOf(pre) + "<" + node.toString() + " />\r\n");
        }
    }

    public String dumpXml(INode node) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.dumpXml(sb, node, "");
        return sb.toString();
    }

    protected void dumpXml(StringBuffer sb, INode node, String pre) {
        boolean cfr_ignored_0 = node instanceof ASTInnerAlias;
        if (node.getChildrenSize() != 0) {
            sb.append(String.valueOf(pre) + "<" + Util.encodeMarkup((String)node.toString()) + ">\r\n");
            int i = 0;
            while (i < node.getChildrenSize()) {
                INode n = node.getChild(i);
                if (n != null) {
                    this.dumpXml(sb, n, String.valueOf(pre) + " ");
                }
                ++i;
            }
            sb.append(String.valueOf(pre) + "</" + node.getNodeClassName() + ">\r\n");
        } else {
            sb.append(String.valueOf(pre) + "<" + Util.encodeMarkup((String)node.toString()) + " />\r\n");
        }
    }

    public void setTokenizer(SqlTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }
}

