/*
 * Decompiled with CFR 0.152.
 */
package kry.sql.tokenizer;

import java.util.LinkedList;
import kry.sql.tokenizer.Token;

public class TokenList
extends LinkedList {
    private static final long serialVersionUID = -7668336470690425446L;

    public Token getToken(int index) {
        if (index < 0 || this.size() - 1 < index) {
            return null;
        }
        return (Token)super.get(index);
    }

    public Token getFirstToken() {
        return (Token)super.getFirst();
    }

    public Token getLastToken() {
        return (Token)super.getLast();
    }

    public int getNextValidTokenIndex(int start, int index) {
        if (++start < 0 || this.size() - 1 < start || index <= 0) {
            return -1;
        }
        int count = 0;
        int len = this.size();
        int i = start;
        while (i < len) {
            Token token = this.getToken(i);
            switch (token.getType()) {
                case 70: {
                    break;
                }
                default: {
                    if (index > ++count) break;
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public void removeToken(int start, int end) {
        if (start < 0 || this.size() - 1 < start || end < 0 || this.size() - 1 < end) {
            return;
        }
        if (start > end) {
            return;
        }
        int i = end;
        while (i >= start) {
            this.remove(i);
            --i;
        }
    }

    public Token getParentTokenInParen(int index) {
        if (index - 1 <= 0) {
            return null;
        }
        int i = index - 1;
        while (i >= 0) {
            Token token = (Token)super.get(i);
            switch (token.getType()) {
                case 10: {
                    return token;
                }
                case 40: {
                    return token;
                }
                case 60: 
                case 70: 
                case 90: {
                    break;
                }
                default: {
                    return null;
                }
            }
            --i;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TokenList:");
        buffer.append(" modCount: ");
        buffer.append(this.modCount);
        buffer.append("]");
        return buffer.toString();
    }
}

