/*
 * 著作権: Copyright (c) 2007－2008 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.ext.s2jdbc.wizards;

import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Table;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;

public class TableKeyEventHandler2 {

    protected TableViewer viewer;

    protected Table table;

    public TableKeyEventHandler2(TableViewer viewer) {
        this.viewer = viewer;
        this.table = viewer.getTable();
    }

    
    public int getSelectedRow() {
        return table.getSelectionIndex();
    }

    public void selectRow(int index) {
        table.select(index);
    }

    public int getSelectedCellEditorIndex() {
        int defaultIndex = 0;
        CellEditor[] editors = viewer.getCellEditors();
        if (editors == null)
            return -1;
        for (int i = 0; i < editors.length; i++) {
            if (editors[i] != null && editors[i].isActivated()) {
                return i;
            }
        }
        return defaultIndex;
    }

    public int getEditableNextColumn(int cuurentCol) {
        ICellModifier modifier = viewer.getCellModifier();
        int nextCol = (cuurentCol < table.getColumnCount() - 1) ? cuurentCol + 1 : 2;
        return nextCol;
    }

    public int getEditablePrevColumn(int CurrentCol) {
        ICellModifier modifier = viewer.getCellModifier();
        int nextCol = (CurrentCol == 2) ? table.getColumnCount() - 1 : CurrentCol - 1;
        System.out.println("nextCol = " + nextCol);
        return nextCol;
    }

    public void editTableElement(int rowIndex, int columnIndex) {
        Object element = viewer.getElementAt(rowIndex);
        if (element != null) {
            if (columnIndex == 1) {
                table.showColumn(table.getColumn(0));
            } else {
                table.showColumn(table.getColumn(columnIndex));
            }
            viewer.editElement(element, columnIndex);

        }
    }

    public void updateColumn(FormProperty element, int col, Object newValue) {
        element.setValue(col, String.valueOf(newValue));
        viewer.update(element, null);
        columnsPack();

    }

    public void setMessage(String msg) {
        DbPlugin.getDefault().showWarningMessage(msg);
    }

    private void columnsPack() {
    }

    public boolean validate(int row, int col) {
        FormProperty element = (FormProperty) viewer.getElementAt(row);
        Object newValue = null;
        CellEditor editor = viewer.getCellEditors()[col];
        if (editor == null)
            throw new IllegalStateException("no Config CellEditor"); //$NON-NLS-1$

        if (editor instanceof TextCellEditor) {
            TextCellEditor tce = (TextCellEditor) editor;
            newValue = tce.getValue();
        }
        Object oldValue = element.getValue(col);

        String msg = editor.getErrorMessage();
        if (msg == null) {
            updateColumn(element, col, newValue);
            return true;

        } else {
            viewer.cancelEditing();
            updateColumn(element, col, newValue);
            setMessage(msg); //$NON-NLS-1$
            editTableElement(row, col);
            return false;
        }

    }


    public void removeRecord(FormProperty element) {
        TableViewerManager.remove(viewer, element);
    }

    public void dispose() {
    }

    public void createNewRecord() {

        int count = table.getItems().length;

        FormProperty fp = new FormProperty();
        fp.no = count + 1;
        fp.name = "";
        fp.type = "String";
        fp.modified = FormProperty.MODIFIED_PUBLIC;

        addFormProperty(viewer, fp);
        editTableElement(count, 2); 

    }

    @SuppressWarnings("unchecked")
    private void addFormProperty(TableViewer viewer, FormProperty newProperty) {
        Object obj = viewer.getInput();
        if (obj instanceof List<?>) {
            List<FormProperty> list = (List<FormProperty>) obj;
            list.add(newProperty);
            viewer.setInput(list);

        } else {
            throw new IllegalArgumentException("Object error"); //$NON-NLS-1$
        }
    }
}
