package zigen.plugin.db.ext.jdt.vo.rule;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;


public abstract class AbstractVOMappingFactory implements IVOMappingFactory {

	public static IVOMappingFactory getFactory(IDBConfig config) {
		return getFactory(config.getDriverName());
	}

	public static IVOMappingFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode) {
		try {
			return getFactory(objMet.getDriverName());

		} catch (SQLException e) {
			throw new IllegalStateException(" getDriverName is Failed"); //$NON-NLS-1$
		}

	}

	private static Map map = new HashMap();

	public static IVOMappingFactory getFactory(String driverName) {
		IVOMappingFactory factory = null;
		String key = driverName;
		if (map.containsKey(key)) {
			factory = (IVOMappingFactory) map.get(key);
		} else {
			switch (DBType.getType(driverName)) {
				case DBType.DB_TYPE_H2:
					factory = new H2VOMappingFactory();
					break;
				case DBType.DB_TYPE_ORACLE:
					factory = new OracleVOMappingFactory();
					break;
				default:
					factory = new DefaultVOMappingFactory();
					break;
			}

			map.put(key, factory);
		}
		return factory;
	}

}