/*
 * Decompiled with CFR 0.152.
 */
package zigen.sql.parser.ast;

import zigen.sql.parser.ASTVisitor;
import zigen.sql.parser.ast.ASTAlias;

public class ASTColumn
extends ASTAlias {
    private String schemaName;
    private String tableName;
    private String columnName;
    private boolean isConcating;
    private boolean isOuterJoin;

    public ASTColumn(String columnName, int offset, int length, int scope) {
        super(columnName, offset, length, scope);
        this.parse(columnName);
    }

    public void addConcat(String token, int _offset, int _length) {
        StringBuffer sb = new StringBuffer(this.columnName).append(token);
        this.parse(sb.toString());
        int lastOffset = this.offset + this.length;
        int space = _offset - lastOffset;
        this.length = this.length + space + _length;
        this.isConcating = true;
    }

    public void addOuterJoin(String token, int _offset, int _length) {
        StringBuffer sb = new StringBuffer(this.columnName).append(token);
        this.parse(sb.toString());
        int lastOffset = this.offset + this.length;
        int space = _offset - lastOffset;
        this.length = this.length + space + _length;
        this.isOuterJoin = true;
    }

    public void addColumn(String token, int _offset, int _length) {
        StringBuffer sb = new StringBuffer(this.columnName).append(token);
        this.parse(sb.toString());
        int lastOffset = this.offset + this.length;
        int space = _offset - lastOffset;
        this.length = this.length + space + _length;
        this.isConcating = false;
    }

    private void parse(String columnName) {
        String[] strs;
        if (columnName.endsWith(".")) {
            columnName = String.valueOf(columnName) + "[dummy]";
        }
        if ((strs = columnName.split("[.]")).length == 3) {
            this.schemaName = strs[0];
            this.tableName = strs[1];
            this.columnName = strs[2];
        } else if (strs.length == 2) {
            this.tableName = strs[0];
            this.columnName = strs[1];
        } else if (strs.length == 1) {
            this.columnName = strs[0];
        }
    }

    public String getName() {
        StringBuffer sb = new StringBuffer();
        if (this.schemaName != null) {
            sb.append(this.schemaName);
            sb.append(".");
        }
        if (this.tableName != null) {
            sb.append(this.tableName);
            sb.append(".");
        }
        sb.append(this.columnName);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.hasAlias()) {
            sb.append(" AS ");
            sb.append(this.getAliasName());
        }
        return String.valueOf(this.getNodeClassName()) + " text=\"" + sb.toString() + "\"";
    }

    public Object accept(ASTVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getAliasName() {
        if (this.hasAlias()) {
            return super.getAliasName();
        }
        return this.columnName;
    }

    public boolean isConcating() {
        return this.isConcating;
    }

    public void setConcating(boolean isConcating) {
        this.isConcating = isConcating;
    }

    public boolean isOuterJoin() {
        return this.isOuterJoin;
    }
}

