package org.dbunitng.util;

import static org.testng.Assert.assertEquals;

import org.dbunitng.annotations.FileType;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups = "util")
public class ResourceUtilTest {

	@DataProvider(name = "extension")
	public Object[][] dataExtension() {

		return new Object[][] { { "xml", FileType.XML },
			{ "xls", FileType.EXCEL }, { "xlsx", FileType.EXCEL } };
	}

	@Test(dataProvider = "extension")
	public void testToFileType(String extension, FileType expected) {
		assertEquals(ResourceUtil.toFileType(extension), expected);
	}

	@DataProvider(name = "exceptionExtension")
	public Object[][] dataExceptionExtension() {

		return new Object[][] { { null }, { "hoge" }, { ".xml" } };
	}

	@Test(dataProvider = "exceptionExtension", expectedExceptions = java.lang.IllegalArgumentException.class)
	public void testToFileTypeException(String extension) {
		ResourceUtil.toFileType(extension);
	}

	@DataProvider(name = "fileName")
	public Object[][] dataFileName() {

		return new Object[][] { { "test.xml", "xml" }, { "test.xls", "xls" },
			{ "sample.test.xml", "xml" }, { "abcdefg", "abcdefg" }, { "", "" } };
	}

	@Test(dataProvider = "fileName")
	public void testGetExtension(String fileName, String expected) {
		assertEquals(ResourceUtil.getExtension(fileName), expected);
	}

	@Test(expectedExceptions = java.lang.IllegalArgumentException.class)
	public void testGetExtensionException() {
		ResourceUtil.getExtension(null);
	}

	@DataProvider(name = "package")
	public Object[][] dataPackage() {
		return new Object[][] { { "aaa.bbb.Ccc", "aaa/bbb/Ccc" }, { "", "" },
			{ "aaabbbccc", "aaabbbccc" }, { null, null } };
	}

	@Test(dataProvider = "package")
	public void testReplacePackageToDirectory(String pac, String expected) {
		assertEquals(ResourceUtil.replacePackageToDirectory(pac), expected);
	}

	@DataProvider(name = "pathName")
	public Object[][] dataPathName() {
		return new Object[][] { { "aaa.bbb.Ccc", "xml", "aaa/bbb/Ccc.xml" },
			{ "aaa.bbb.Ccc", ".xml", "aaa/bbb/Ccc.xml" } };
	}

	@Test(dataProvider = "pathName")
	public void testToFilePath(String fqcn, String extension, String expected) {
		assertEquals(ResourceUtil.toFilePath(fqcn, extension), expected);
	}

	@Test(expectedExceptions = IllegalArgumentException.class)
	public void testToFilePathException() {
		ResourceUtil.toFilePath("", null);
	}
}
