package org.dbunitng.listeners;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups = "listener")
public class DbUnitNGContextTest {

	public void simpleTest1() {
		DbUnitNGContext ctx = DbUnitNGContext.currentContext();
		assertNotNull(ctx);
		assertEquals(ctx.getName(), "simpleTest1");
		assertEquals(ctx.getTestClass(), DbUnitNGContextTest.class);
		assertEquals(ctx.getInvocationCount(), 1);
	}

	public void simpleTest2() {
		DbUnitNGContext ctx = DbUnitNGContext.currentContext();
		assertNotNull(ctx);
		assertEquals(ctx.getName(), "simpleTest2");
		assertEquals(ctx.getTestClass(), DbUnitNGContextTest.class);
		assertEquals(ctx.getInvocationCount(), 1);
	}

	@Test(dataProvider = "data")
	public void usingDataProvidor(int invocationCount) {
		DbUnitNGContext ctx = DbUnitNGContext.currentContext();
		assertNotNull(ctx);
		assertEquals(ctx.getName(), "usingDataProvidor");
		assertEquals(ctx.getTestClass(), DbUnitNGContextTest.class);
		assertEquals(ctx.getInvocationCount(), invocationCount);
	}

	@DataProvider(name = "data")
	public Object[][] data() {
		return new Object[][] {{1}, {2}, {3}};
	}
}
