package org.dbunitng.dataset;

import java.util.ArrayList;
import java.util.List;

import org.dbunit.dataset.IDataSet;
import org.dbunitng.assertion.AssertionHelper;
import org.dbunitng.beans.testbeans.SampleListBean;
import org.dbunitng.beans.testbeans.SampleNestedBean;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups = "bean")
public class BeanListConverterNestedListTest {

	@DataProvider(name = "list")
	public Object[][] dataList() {

		SampleNestedBean nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean1");
		List<SampleNestedBean> list = new ArrayList<SampleNestedBean>();
		list.add(nestedBean);

		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean2");
		list.add(nestedBean);

		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean3");
		list.add(nestedBean);

		SampleListBean bean = new SampleListBean();
		bean.setName("SampleListBean1");
		bean.setList(list);

		List<SampleListBean> beanList = new ArrayList<SampleListBean>();
		beanList.add(bean);

		list = new ArrayList<SampleNestedBean>();
		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean4");
		list.add(nestedBean);

		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean5");
		list.add(nestedBean);

		bean = new SampleListBean();
		bean.setName("SampleListBean2");
		bean.setList(list);

		beanList.add(bean);

		return new Object[][] { { beanList } };
	}

	@Test(dataProvider = "list")
	public void testConvertNestedBeanList(List<SampleListBean> list)
			throws Exception {
		BeanListConverter converter = new BeanListConverter(list);
		IDataSet dataSet = converter.convert();

		AssertionHelper.assertEqualsOnlyColumnsInFile(
			dataSet,
			"nested",
			"NestedListTest.xml");

	}

}
