package org.dbunitng.sample.dao2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dbunitng.listeners.DbUnitNGTestListener;
import org.dbunitng.sample.dao.DeptDao;
import org.dbunitng.sample.entity.Dept;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

@Test
public class TableAssertTest {

	public void testTableAssert() {
		insert();
	}
	
	protected void insert() {
		DeptDao dao = new DeptDao();
		Dept dept = new Dept();
		dept.setDeptno(1);
		dept.setDname("test");
		dept.setLocation("Osaka");
		dao.addDept(dept);
	}

	@Test(enabled = false)
	public static void main(String[] args) {
		TestNG testNG = new TestNG();

		testNG.addListener(new DbUnitNGTestListener());
		TestListenerAdapter adapter = new TestListenerAdapter();
		testNG.addListener(adapter);

		XmlSuite suite = new XmlSuite();
		Map<String, String> parameters = new HashMap<String, String>();
		parameters.put("driver", "com.mysql.jdbc.Driver");
		parameters.put("url", "jdbc:mysql://127.0.0.1/testframework");
		parameters.put("username", "root");
		parameters.put("password", "root");
		parameters.put("defaultOperation", "CLEAN_INSERT");
		suite.setParameters(parameters);

		XmlTest test = new XmlTest(suite);
		XmlClass[] classes =
			new XmlClass[] { new XmlClass(TableAssertTest.class) };
		test.setXmlClasses(Arrays.asList(classes));

		List<XmlSuite> list = new ArrayList<XmlSuite>();
		list.add(suite);
		testNG.setXmlSuites(list);

		testNG.run();

		System.out.println("PassedTests:" + adapter.getPassedTests());
		System.out.println("FailedTests:" + adapter.getFailedTests());
		System.out.println("SkippedTests:" + adapter.getSkippedTests());

	}
}
