/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericOperationEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public final class PercentEval
extends NumericOperationEval {
    private PercentPtg _delegate;
    private static final ValueEvalToNumericXlator NUM_XLATOR = new ValueEvalToNumericXlator(27);

    public PercentEval(Ptg ptg) {
        this._delegate = (PercentPtg)ptg;
    }

    protected ValueEvalToNumericXlator getXlator() {
        return NUM_XLATOR;
    }

    public Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval ve = this.singleOperandEvaluate(args[0], srcRow, srcCol);
        if (ve instanceof NumericValueEval) {
            double d0 = ((NumericValueEval)ve).getNumberValue();
            return new NumberEval(d0 / 100.0);
        }
        if (ve instanceof BlankEval) {
            return NumberEval.ZERO;
        }
        if (ve instanceof ErrorEval) {
            return ve;
        }
        return ErrorEval.VALUE_INVALID;
    }

    public int getNumberOfOperands() {
        return this._delegate.getNumberOfOperands();
    }

    public int getType() {
        return this._delegate.getType();
    }
}

