/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class ChartRecord
extends Record {
    public static final short sid = 4098;
    private int field_1_x;
    private int field_2_y;
    private int field_3_width;
    private int field_4_height;

    public ChartRecord() {
    }

    public ChartRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4098) {
            throw new RecordFormatException("Not a Chart record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_x = in.readInt();
        this.field_2_y = in.readInt();
        this.field_3_width = in.readInt();
        this.field_4_height = in.readInt();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHART]\n");
        buffer.append("    .x                    = ").append("0x").append(HexDump.toHex(this.getX())).append(" (").append(this.getX()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .y                    = ").append("0x").append(HexDump.toHex(this.getY())).append(" (").append(this.getY()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .width                = ").append("0x").append(HexDump.toHex(this.getWidth())).append(" (").append(this.getWidth()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .height               = ").append("0x").append(HexDump.toHex(this.getHeight())).append(" (").append(this.getHeight()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/CHART]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4098);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(data, 4 + offset + pos, this.field_1_x);
        LittleEndian.putInt(data, 8 + offset + pos, this.field_2_y);
        LittleEndian.putInt(data, 12 + offset + pos, this.field_3_width);
        LittleEndian.putInt(data, 16 + offset + pos, this.field_4_height);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 4098;
    }

    public Object clone() {
        ChartRecord rec = new ChartRecord();
        rec.field_1_x = this.field_1_x;
        rec.field_2_y = this.field_2_y;
        rec.field_3_width = this.field_3_width;
        rec.field_4_height = this.field_4_height;
        return rec;
    }

    public int getX() {
        return this.field_1_x;
    }

    public void setX(int field_1_x) {
        this.field_1_x = field_1_x;
    }

    public int getY() {
        return this.field_2_y;
    }

    public void setY(int field_2_y) {
        this.field_2_y = field_2_y;
    }

    public int getWidth() {
        return this.field_3_width;
    }

    public void setWidth(int field_3_width) {
        this.field_3_width = field_3_width;
    }

    public int getHeight() {
        return this.field_4_height;
    }

    public void setHeight(int field_4_height) {
        this.field_4_height = field_4_height;
    }
}

