/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.List;
import org.apache.poi.hssf.record.Record;

final class RecordStream {
    private final List _list;
    private int _nextIndex;
    private int _countRead;

    public RecordStream(List inputList, int startIndex) {
        this._list = inputList;
        this._nextIndex = startIndex;
        this._countRead = 0;
    }

    public boolean hasNext() {
        return this._nextIndex < this._list.size();
    }

    public Record getNext() {
        if (this._nextIndex >= this._list.size()) {
            throw new RuntimeException("Attempt to read past end of record stream");
        }
        ++this._countRead;
        return (Record)this._list.get(this._nextIndex++);
    }

    public Class peekNextClass() {
        if (this._nextIndex >= this._list.size()) {
            return null;
        }
        return this._list.get(this._nextIndex).getClass();
    }

    public int getCountRead() {
        return this._countRead;
    }
}

