/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import org.apache.poi.hssf.model.ParseNode;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.ControlPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.ValueOperatorPtg;

final class OperandClassTransformer {
    private final int _formulaType;

    public OperandClassTransformer(int formulaType) {
        this._formulaType = formulaType;
    }

    public void transformFormula(ParseNode rootNode) {
        byte rootNodeOperandClass;
        switch (this._formulaType) {
            case 0: {
                rootNodeOperandClass = 32;
                break;
            }
            default: {
                throw new RuntimeException("Incomplete code - formula type (" + this._formulaType + ") not supported yet");
            }
        }
        this.transformNode(rootNode, rootNodeOperandClass, false);
    }

    private void transformNode(ParseNode node, byte desiredOperandClass, boolean callerForceArrayFlag) {
        block10: {
            Ptg token;
            block9: {
                token = node.getToken();
                ParseNode[] children = node.getChildren();
                if (token instanceof ValueOperatorPtg || token instanceof ControlPtg) {
                    for (int i = 0; i < children.length; ++i) {
                        ParseNode child = children[i];
                        this.transformNode(child, desiredOperandClass, callerForceArrayFlag);
                    }
                    return;
                }
                if (token instanceof AbstractFunctionPtg) {
                    this.transformFunctionNode((AbstractFunctionPtg)token, children, desiredOperandClass, callerForceArrayFlag);
                    return;
                }
                if (children.length > 0) {
                    throw new IllegalStateException("Node should not have any children");
                }
                if (token.isBaseToken()) {
                    return;
                }
                if (!callerForceArrayFlag) break block9;
                switch (desiredOperandClass) {
                    case 32: 
                    case 64: {
                        token.setClass((byte)64);
                        break block10;
                    }
                    case 0: {
                        token.setClass((byte)0);
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + desiredOperandClass + ")");
                    }
                }
            }
            token.setClass(desiredOperandClass);
        }
    }

    private void transformFunctionNode(AbstractFunctionPtg afp, ParseNode[] children, byte desiredOperandClass, boolean callerForceArrayFlag) {
        boolean localForceArrayFlag;
        block24: {
            byte defaultReturnOperandClass;
            block23: {
                defaultReturnOperandClass = afp.getDefaultOperandClass();
                if (!callerForceArrayFlag) break block23;
                switch (defaultReturnOperandClass) {
                    case 0: {
                        if (desiredOperandClass == 0) {
                            afp.setClass((byte)0);
                        } else {
                            afp.setClass((byte)64);
                        }
                        localForceArrayFlag = false;
                        break block24;
                    }
                    case 64: {
                        afp.setClass((byte)64);
                        localForceArrayFlag = false;
                        break block24;
                    }
                    case 32: {
                        afp.setClass((byte)64);
                        localForceArrayFlag = true;
                        break block24;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                    }
                }
            }
            if (defaultReturnOperandClass == desiredOperandClass) {
                localForceArrayFlag = false;
                afp.setClass(defaultReturnOperandClass);
            } else {
                switch (desiredOperandClass) {
                    case 32: {
                        afp.setClass((byte)32);
                        localForceArrayFlag = false;
                        break;
                    }
                    case 64: {
                        switch (defaultReturnOperandClass) {
                            case 0: {
                                afp.setClass((byte)0);
                                break;
                            }
                            case 32: {
                                afp.setClass((byte)64);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                            }
                        }
                        localForceArrayFlag = defaultReturnOperandClass == 32;
                        break;
                    }
                    case 0: {
                        switch (defaultReturnOperandClass) {
                            case 64: {
                                afp.setClass((byte)64);
                                break;
                            }
                            case 32: {
                                afp.setClass((byte)32);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + defaultReturnOperandClass + ")");
                            }
                        }
                        localForceArrayFlag = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + desiredOperandClass + ")");
                    }
                }
            }
        }
        for (int i = 0; i < children.length; ++i) {
            ParseNode child = children[i];
            byte paramOperandClass = afp.getParameterClass(i);
            this.transformNode(child, paramOperandClass, localForceArrayFlag);
        }
    }
}

