/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.search;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.dbunit.util.search.IEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Edge
implements IEdge {
    private static final Logger logger = LoggerFactory.getLogger((Class)Edge.class);
    private final Comparable nodeFrom;
    private final Comparable nodeTo;

    public Edge(Comparable nodeFrom, Comparable nodeTo) {
        if (nodeFrom == null) {
            throw new IllegalArgumentException("node from cannot be null");
        }
        if (nodeTo == null) {
            throw new IllegalArgumentException("node to cannot be null");
        }
        this.nodeFrom = nodeFrom;
        this.nodeTo = nodeTo;
    }

    public Object getFrom() {
        return this.nodeFrom;
    }

    public Object getTo() {
        return this.nodeTo;
    }

    public String toString() {
        return this.nodeFrom + "->" + this.nodeTo;
    }

    public int compareTo(Object o) {
        logger.debug("compareTo(o={}) - start", o);
        Edge otherEdge = (Edge)o;
        int result = this.nodeFrom.compareTo(otherEdge.getFrom());
        if (result == 0) {
            result = this.nodeTo.compareTo(otherEdge.getTo());
        }
        return result;
    }

    public boolean equals(Object obj) {
        logger.debug("equals(obj={}) - start", obj);
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

